/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Json;
import com.google.caliper.Result;
import com.google.caliper.Xml;
import com.google.gson.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class ResultsReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getResult(InputStream in) throws IOException {
        Result result;
        byte[] postedData = this.readAllBytes(in);
        InputStreamReader baisJsonReader = new InputStreamReader(new ByteArrayInputStream(postedData));
        try {
            result = (Result)Json.getGsonInstance().fromJson((Reader)baisJsonReader, Result.class);
        }
        catch (JsonParseException e) {
            ByteArrayInputStream baisXml = new ByteArrayInputStream(postedData);
            try {
                result = Xml.resultFromXml(baisXml);
            }
            catch (Exception e2) {
                throw new RuntimeException(e);
            }
            finally {
                baisXml.close();
            }
        }
        finally {
            baisJsonReader.close();
        }
        return result;
    }

    private byte[] readAllBytes(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) != -1) {
            baos.write(buf, 0, read);
        }
        return baos.toByteArray();
    }
}

