/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.Benchmark;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.model.ArbitraryMeasurement;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.util.Util;
import com.google.caliper.worker.ArbitraryMeasurementWorker;
import com.google.caliper.worker.Worker;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public final class ArbitraryMeasurementInstrument
extends Instrument {
    @Override
    public boolean isBenchmarkMethod(Method method) {
        return method.isAnnotationPresent(ArbitraryMeasurement.class);
    }

    @Override
    public BenchmarkMethod createBenchmarkMethod(BenchmarkClass benchmarkClass, Method method) throws InvalidBenchmarkException {
        if (method.getParameterTypes().length != 0) {
            throw new InvalidBenchmarkException("Arbitrary measurement methods should take no parameters: " + method.getName(), new Object[0]);
        }
        if (method.getReturnType() != Double.TYPE) {
            throw new InvalidBenchmarkException("Arbitrary measurement methods must have a return type of double: " + method.getName(), new Object[0]);
        }
        if (Util.isStatic(method)) {
            throw new InvalidBenchmarkException("Arbitrary measurement methods must not be static: " + method.getName(), new Object[0]);
        }
        if (!Util.isPublic(method)) {
            throw new InvalidBenchmarkException("Arbitrary measurement methods must be public: " + method.getName(), new Object[0]);
        }
        return new BenchmarkMethod(benchmarkClass, method, method.getName());
    }

    @Override
    public void dryRun(Benchmark benchmark, BenchmarkMethod benchmarkMethod) throws UserCodeException {
        Method m = benchmarkMethod.method();
        try {
            m.invoke((Object)benchmark, new Object[0]);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InvocationTargetException e) {
            Throwable userException = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)userException, SkipThisScenarioException.class);
            throw new UserCodeException(userException);
        }
    }

    @Override
    public Map<String, String> workerOptions() {
        return new ImmutableMap.Builder().put((Object)"gcBeforeEach", this.options.get((Object)"gcBeforeEach")).build();
    }

    @Override
    public Class<? extends Worker> workerClass() {
        return ArbitraryMeasurementWorker.class;
    }
}

