!define NAME "PortableFirefox"
!define VER "1.0.1"

!packhdr "C:\tmp.dat" "c:\Program Files\UPX\upx.exe --best --crp-ms=999999 C:\tmp.dat"

;=== Program Details
Name "${NAME}"
OutFile "${NAME}.exe"
Caption "${NAME} - Take Your Browser With You"
VIProductVersion "${VER}.0"
VIAddVersionKey FileDescription "Portable Firefox Launcher runs Firefox from a removable drive"
VIAddVersionKey LegalCopyright "GPL"
VIAddVersionKey Comments "This launcher allows Firefox to be run from a removable drive.  For additional details, visit portablefirefox.mozdev.org"
VIAddVersionKey CompanyName "by John T. Haller (with code from mai9 and tracon)"
VIAddVersionKey OriginalFilename "${NAME} ${VER}.exe"
VIAddVersionKey FileVersion "${VER}"

;=== Runtime switches
CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True

;=== Program Icon
Icon "unofficial_firefox.ico"

;=== Path variables
Var FIREFOXDIRECTORY
Var PROFILEDIRECTORY
Var ALLOWMULTIPLEINSTANCES
Var ADDITIONALPARAMETERS
Var EXECSTRING

Section "Main"
	
	;=== Get the path information from the INI file
	IfFileExists "$EXEDIR\${NAME}.ini" ReadINI NoINI
	ReadINI:
		ReadINIStr $0 "$EXEDIR\${NAME}.ini" "${NAME}" "firefoxdirectory"
		StrCpy "$FIREFOXDIRECTORY" "$EXEDIR\$0"
		ReadINIStr $0 "$EXEDIR\${NAME}.ini" "${NAME}" "profiledirectory"
		StrCpy "$PROFILEDIRECTORY" "$EXEDIR\$0"
		ReadINIStr $0 "$EXEDIR\${NAME}.ini" "${NAME}" "allowmultipleinstances"
		StrCpy "$ALLOWMULTIPLEINSTANCES" $0
		ReadINIStr $0 "$EXEDIR\${NAME}.ini" "${NAME}" "additionalparameters"
		StrCpy "$ADDITIONALPARAMETERS" $0
		IfErrors NoINI EndINI
	NoINI:
		;== No INI file, so we'll use the defaults
		IfFileExists "$EXEDIR\firefox\firefox.exe" FoundFirefoxDIR CheckPortableFirefoxDIR

		FoundFirefoxDIR:
			StrCpy "$FIREFOXDIRECTORY" "$EXEDIR\firefox"
			StrCpy "$PROFILEDIRECTORY" "$EXEDIR\profile"
			StrCpy "$ALLOWMULTIPLEINSTANCES" "no"
			StrCpy "$ADDITIONALPARAMETERS" ""
			GoTo EndINI

		CheckPortableFirefoxDIR:
			IfFileExists "$EXEDIR\PortableFirefox\firefox\firefox.exe" FoundPortableFirefoxDIR CheckPortableAppsDIR

		FoundPortableFirefoxDIR:
			StrCpy "$FIREFOXDIRECTORY" "$EXEDIR\PortableFirefox\firefox"
			StrCpy "$PROFILEDIRECTORY" "$EXEDIR\PortableFirefox\profile"
			StrCpy "$ALLOWMULTIPLEINSTANCES" "no"
			StrCpy "$ADDITIONALPARAMETERS" ""
			GoTo EndINI

		CheckPortableAppsDIR:
			IfFileExists "$EXEDIR\PortableApps\PortableFirefox\firefox\firefox.exe" FoundPortableAppsDIR NoFirefoxEXE

		FoundPortableAppsDIR:
			StrCpy "$FIREFOXDIRECTORY" "$EXEDIR\PortableApps\PortableFirefox\firefox"
			StrCpy "$PROFILEDIRECTORY" "$EXEDIR\PortableApps\PortableFirefox\profile"
			StrCpy "$ALLOWMULTIPLEINSTANCES" "no"
			StrCpy "$ADDITIONALPARAMETERS" ""
			GoTo EndINI

	EndINI:
		IfFileExists "$FIREFOXDIRECTORY\firefox.exe" FoundFirefoxEXE NoFirefoxEXE
	
	NoFirefoxEXE:
		MessageBox MB_OK|MB_ICONEXCLAMATION `firefox.exe was not found.  Please check your configuration`
		Abort
		
	FoundFirefoxEXE:

	;=== Check for an existing profile
	IfFileExists "$PROFILEDIRECTORY\prefs.js" ProfileFound NoProfileFound
	
	NoProfileFound:
		MessageBox MB_YESNO|MB_ICONQUESTION `No profile was found. Would you like to create a new profile here? $\n$PROFILEDIRECTORY\` IDYES CreateProfile
		MessageBox MB_OK|MB_ICONINFORMATION `Portable Firefox cannot run without a profile directory.  Please check your configuration.`
		Abort
	
	CreateProfile:
		IfFileExists "$PROFILEDIRECTORY\*.*" ProfileFound CreateProfileDIR

	CreateProfileDIR:
		CreateDirectory "$PROFILEDIRECTORY\"

	ProfileFound:
		IfFileExists "$PROFILEDIRECTORY\chrome\chrome.rdf" ChromeFound RunFirefox
	
	ChromeFound:
		FileOpen $0 "$PROFILEDIRECTORY\chrome\chrome.rdf" r
		FileOpen $R0 "$PROFILEDIRECTORY\chrome\chrome.rdf.new" w
		ClearErrors ; if there's an error, we're done with the file
	
	NextLine:
		FileWrite $R0 $4
		FileRead $0 $4
		IfErrors NoMoreLines
		;StrCpy $5 $4 39
		StrCpy $5 $4 34
		;MessageBox MB_OK "$5"
		;StrCmp $5 `                   c:baseURL="jar:file:` "" NextLine
		StrCmp $5 `                   c:baseURL="jar:` "" NextLine
		StrCpy $R4 40
	
	NotYet:
		IntOp $R4 $R4 + 1
		StrCpy $7 $4 10 $R4 ; looking for the point to strip the extension path
		;MessageBox MB_OK "$7"
		StrCmp $7 "extensions" PathFound NotYet
	
	PathFound:
		StrCpy $5 $4 "" $R4
		StrCpy $4 `                   c:baseURL="jar:file:///$PROFILEDIRECTORY/$5` ; the path made ABSOLUTE
		GoTo NextLine

	NoMoreLines:
		FileClose $0
		FileClose $R0
		;=== Backup the chrome.rdf just in case
		CopyFiles "$PROFILEDIRECTORY\chrome\chrome.rdf" "$PROFILEDIRECTORY\chrome\chrome.rdf.old" 		;=== Save the new chrome.rdf
		CopyFiles "$PROFILEDIRECTORY\chrome\chrome.rdf.new" "$PROFILEDIRECTORY\chrome\chrome.rdf" 

	RunFirefox:
		;=== Get any passed parameters
		Call GetParameters
		Pop $0
		StrCmp "'$0'" "''" LaunchFirefox LaunchFirefoxURL

	LaunchFirefox:
		StrCpy $EXECSTRING `"$FIREFOXDIRECTORY\firefox.exe" -profile "$PROFILEDIRECTORY"`
		Goto LaunchNow

	LaunchFirefoxURL:	
		;MessageBox MB_OK `$FIREFOXDIRECTORY\firefox.exe -profile '$PROFILEDIRECTORY' -url $0`
		StrCpy $EXECSTRING `"$FIREFOXDIRECTORY\firefox.exe" -profile "$PROFILEDIRECTORY" -url $0`

	LaunchNow:
		StrCmp $ALLOWMULTIPLEINSTANCES "yes" MultipleInstances NoMultiple

	MultipleInstances:
		System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("MOZ_NO_REMOTE", "1").r0'

	NoMultiple:
		StrCmp $ADDITIONALPARAMETERS "" NoParameters AdditionalParameters

	AdditionalParameters:
		StrCpy $EXECSTRING `$EXECSTRING $ADDITIONALPARAMETERS`

	NoParameters:
		;MessageBox MB_OK $EXECSTRING
		Exec $EXECSTRING

SectionEnd

Function "GetParameters"
  Push $R0
  Push $R1
  Push $R2
  StrCpy $R0 $CMDLINE 1
  StrCpy $R1 '"'
  StrCpy $R2 1
  StrCmp $R0 '"' loop
    StrCpy $R1 ' ' ; we're scanning for a space instead of a quote
  loop:
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 $R1 loop2
    StrCmp $R0 "\" "" "nofile"
      IntOp $2 $R2 + 1
    nofile:
    ;MessageBox MB_OK "r0: $R0"
    StrCmp $R0 "" loop2
    IntOp $R2 $R2 + 1
    Goto loop
  loop2:
    IntOp $R0 $R2 - $2
    IntOp $R0 $R0 - 4
    ;MessageBox MB_OK "$R2 - $2 = $R0"
    StrCpy $R7 $CMDLINE $R0 $2 ; we save the filename
    ;MessageBox MB_OK "$2"
  loop2b:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    ;MessageBox MB_OK "rr0: $R0"
    StrCmp $R0 " " loop2b
  StrCpy $R0 $CMDLINE "" $R2
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd
