/*****************************************************************************
 * Authors: Louis Bavoil <louis@bavoil.net>
 *          Fredrik Hbinette <hubbe@hubbe.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include "mozplugger.h"

/*****************************************************************************
 * Debug function
 *****************************************************************************/
#ifdef DEBUG

static FILE *debug_output;

static FILE *getout()
{
     if (debug_output)
	  return debug_output;
     if (!(debug_output = fopen(DEBUG_FILENAME,"a+")))
	  return NULL;
     fprintf(debug_output,"------------\n");
     return debug_output;
}

void close_debug()
{
     FILE *f;
     if ((f = getout()))
	  fclose(f);
     debug_output = NULL;
}

void D(char *fmt, ...)
{
     FILE *f;
     char buffer[9999];
     va_list ap;

     va_start(ap,fmt);
     vsnprintf(buffer,sizeof(buffer),fmt,ap);
     va_end(ap);

     if((f = getout()))
     {
	  fprintf(f,"PID%4d: %s",getpid(),buffer);
	  fflush(f);
     }
}

#else

void D(char *fmt, ...) { }

#endif

/*****************************************************************************
 * Window resizing
 *****************************************************************************/
static int gcd(int a, int b)
{
     if (a < b) return gcd(b,a);
     if (b == 0) return a;
     return gcd(b, a % b);
}

void max_aspect_window(Display *display, int victim, int w, int h)
{
     int tmp, tmpw, tmph;
     int xaspect;
     int yaspect;
     XWindowAttributes ca;

     D("Resizing window %x with MAXASPECT\n", victim);

     XGetWindowAttributes(display, victim, &ca);

     /* Use gcd to make xaspect and yaspect small */
     tmp = gcd(ca.width, ca.height);
     xaspect = ca.width / tmp;
     yaspect = ca.height / tmp;

     /* Select the side (x or y) to use to rescale */
     tmpw = w / xaspect;
     tmph = h / yaspect;
     if (tmpw < tmph) tmph = tmpw;

     /* Calculate the size of the new window */
     tmpw = tmph * xaspect;
     tmph = tmph * yaspect;
     
     D("New size: %dx%d+%d+%d (of %dx%d)\n", tmpw, tmph,
       (w - tmpw)/2,
       (h - tmph)/2,
       w, h);

     XMoveResizeWindow(display, victim,
		       (w - tmpw)/2,
		       (h - tmph)/2,
		       tmpw, 
		       tmph);
}

void fill_window(Display *display, int victim, int w, int h)
{
     D("Resizing window %x with FILL\n", victim);
     D("New size: %dx%d+%d+%d (of %dx%d)\n", w, h, 0, 0, w, h);
     XMoveResizeWindow(display, victim, 0, 0, w, h);
     XSync(display, FALSE);
}

/*****************************************************************************
 * Adaptive kill()
 *****************************************************************************/
void my_kill(int pid)
{
     int status;

     if(!kill(pid, SIGTERM))
     {
	  D("Killing PID %d with SIGTERM\n", pid);
	  usleep(4000);
	  if(!kill(pid, SIGTERM))
	  {
   	       D("Killing PID %d with SIGTERM\n", pid);
	       usleep(4000);
	       if(!kill(pid, SIGTERM))
	       {
		    D("Killing PID %d with SIGKILL\n", pid);
		    kill(pid, SIGKILL);
	       }
	  }
     }

     D("Waiting for sons\n");
     while (waitpid(-1, &status, WNOHANG) > 0);
}
