/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import java.util.concurrent.Callable;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.NodeImpl;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.interfaces.nsIDOMNamedNodeMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    protected nsISupports moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public nsIDOMNamedNodeMap getInstance() {
        return this.getInstanceAsnsIDOMNamedNodeMap();
    }

    protected NamedNodeMapImpl(nsISupports mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public NamedNodeMapImpl(nsIDOMNamedNodeMap mozInst) {
        this((nsISupports)mozInst);
    }

    public static NamedNodeMapImpl getDOMInstance(nsIDOMNamedNodeMap mozInst) {
        NamedNodeMapImpl node = (NamedNodeMapImpl)instances.get(mozInst);
        return node == null ? new NamedNodeMapImpl(mozInst) : node;
    }

    public nsIDOMNamedNodeMap getInstanceAsnsIDOMNamedNodeMap() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMNamedNodeMap)this.moz.queryInterface("{a6cf907b-15b3-11d2-932e-00805f8add32}");
    }

    public Node removeNamedItemNS(final String namespaceURI, final String localName) {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NamedNodeMapImpl.this.getInstanceAsnsIDOMNamedNodeMap().removeNamedItemNS(namespaceURI, localName);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node setNamedItemNS(Node arg) {
        final nsIDOMNode mozArg = arg != null ? ((NodeImpl)arg).getInstance() : null;
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NamedNodeMapImpl.this.getInstanceAsnsIDOMNamedNodeMap().setNamedItemNS(mozArg);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node getNamedItemNS(final String namespaceURI, final String localName) {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NamedNodeMapImpl.this.getInstanceAsnsIDOMNamedNodeMap().getNamedItemNS(namespaceURI, localName);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node getNamedItem(final String name) {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NamedNodeMapImpl.this.getInstanceAsnsIDOMNamedNodeMap().getNamedItem(name);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node setNamedItem(Node arg) {
        final nsIDOMNode mozArg = arg != null ? ((NodeImpl)arg).getInstance() : null;
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NamedNodeMapImpl.this.getInstanceAsnsIDOMNamedNodeMap().setNamedItem(mozArg);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node item(final int index) {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NamedNodeMapImpl.this.getInstanceAsnsIDOMNamedNodeMap().item((long)index);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node removeNamedItem(final String name) {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NamedNodeMapImpl.this.getInstanceAsnsIDOMNamedNodeMap().removeNamedItem(name);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public int getLength() {
        Callable<Integer> c = new Callable<Integer>(){

            @Override
            public Integer call() {
                long result = NamedNodeMapImpl.this.getInstanceAsnsIDOMNamedNodeMap().getLength();
                return (int)result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }
}

