

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom.ranges;

//Java imports
import java.util.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;

//XPCOM import
import org.mozilla.xpcom.*;
import org.mozilla.interfaces.*;


public class RangeImpl implements org.w3c.dom.ranges.Range
{
    protected nsIDOMRange moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();
    
    public RangeImpl(nsIDOMRange mozInst)
    {
        moz = mozInst;
        instances.put(mozInst, this);
    }    

    public static RangeImpl getDOMInstance(nsIDOMRange mozInst)
    {
        RangeImpl node = (RangeImpl) instances.get(mozInst);
        return node == null ? new RangeImpl(mozInst) : node;
    }
    
    public nsIDOMRange getInstance()
    {
        //This was already queryinterfaced, so safe to cast
        return (nsIDOMRange) moz;
    }
    
    public void setEnd(Node refNode, int offset)
    {
        nsIDOMNode mozRefnode = ((NodeImpl) refNode).getInstance();
        getInstance().setEnd(mozRefnode, offset);
    }
    
    public DocumentFragment cloneContents()
    {
        nsIDOMDocumentFragment result = getInstance().cloneContents();
        return (DocumentFragment) NodeFactory.getNodeInstance(result);
    }
    
    public void setEndAfter(Node refNode)
    {
        nsIDOMNode mozRefnode = ((NodeImpl) refNode).getInstance();
        getInstance().setEndAfter(mozRefnode);
    }
    
    public short compareBoundaryPoints(short how, Range sourceRange)
    {
        nsIDOMRange mozSourcerange = ((RangeImpl) sourceRange).getInstance();
        short result = getInstance().compareBoundaryPoints(how, mozSourcerange);
        return result;
    }
    
    public void setStart(Node refNode, int offset)
    {
        nsIDOMNode mozRefnode = ((NodeImpl) refNode).getInstance();
        getInstance().setStart(mozRefnode, offset);
    }
    
    public Node getCommonAncestorContainer()
    {
        nsIDOMNode result = getInstance().getCommonAncestorContainer();
        return (Node) NodeFactory.getNodeInstance(result);
    }
    
    public void setEndBefore(Node refNode)
    {
        nsIDOMNode mozRefnode = ((NodeImpl) refNode).getInstance();
        getInstance().setEndBefore(mozRefnode);
    }
    
    public void surroundContents(Node newParent)
    {
        nsIDOMNode mozNewparent = ((NodeImpl) newParent).getInstance();
        getInstance().surroundContents(mozNewparent);
    }
    
    public void setStartAfter(Node refNode)
    {
        nsIDOMNode mozRefnode = ((NodeImpl) refNode).getInstance();
        getInstance().setStartAfter(mozRefnode);
    }
    
    public Range cloneRange()
    {
        nsIDOMRange result = getInstance().cloneRange();
        return new RangeImpl(result);
    }
    
    public String toString()
    {
        String result = getInstance().toString();
        return result;
    }
    
    public void selectNodeContents(Node refNode)
    {
        nsIDOMNode mozRefnode = ((NodeImpl) refNode).getInstance();
        getInstance().selectNodeContents(mozRefnode);
    }
    
    public void collapse(boolean toStart)
    {
        getInstance().collapse(toStart);
    }
    
    public boolean getCollapsed()
    {
        boolean result = getInstance().getCollapsed();
        return result;
    }
    
    public void setStartBefore(Node refNode)
    {
        nsIDOMNode mozRefnode = ((NodeImpl) refNode).getInstance();
        getInstance().setStartBefore(mozRefnode);
    }
    
    public void insertNode(Node newNode)
    {
        nsIDOMNode mozNewnode = ((NodeImpl) newNode).getInstance();
        getInstance().insertNode(mozNewnode);
    }
    
    public void selectNode(Node refNode)
    {
        nsIDOMNode mozRefnode = ((NodeImpl) refNode).getInstance();
        getInstance().selectNode(mozRefnode);
    }
    
    public DocumentFragment extractContents()
    {
        nsIDOMDocumentFragment result = getInstance().extractContents();
        return (DocumentFragment) NodeFactory.getNodeInstance(result);
    }
    
    public void detach()
    {
        getInstance().detach();
    }
    
    public Node getStartContainer()
    {
        nsIDOMNode result = getInstance().getStartContainer();
        return (Node) NodeFactory.getNodeInstance(result);
    }
    
    public void deleteContents()
    {
        getInstance().deleteContents();
    }
    
    public Node getEndContainer()
    {
        nsIDOMNode result = getInstance().getEndContainer();
        return (Node) NodeFactory.getNodeInstance(result);
    }
    
    public int getEndOffset()
    {
        int result = getInstance().getEndOffset();
        return result;
    }
    
    public int getStartOffset()
    {
        int result = getInstance().getStartOffset();
        return result;
    }
    
}
