#!/bin/sh

# make-lang.sh v1.0.10
# this script is used to create a language-specifi XPI for mailredirect
# ported from enigmail make-lang.sh (enigmail.mozdev.org)

# if you want to debug this script, set DEBUG to something >0
DEBUG=0

MAILREDIRECTVERSION=${2:-`cat version.txt`}
export MAILREDIRECTVERSION

if [ $# -gt 2 -o $# -lt 1 ]; then
  echo "Usage: $0 xx-YY [version]"
  echo "       where: xx-YY   is the language and country code representing the"
  echo "                      translated language (e.g. pl-PL, de-DE, es-ES)"
  echo "              version (optional) is the Mail Redirect version, e.g. ${MAILREDIRECTVERSION}"
  echo "                      if parameter is not given value from version.txt is taken"
  exit 1
fi

MAILREDIRECTLANG=$1
export MAILREDIRECTLANG

LANGDIR=${MAILREDIRECTLANG}/chrome/locale/${MAILREDIRECTLANG}
cwd=`pwd`
rm -rf ${LANGDIR} >/dev/null 2>&1
mkdir -p ${LANGDIR} 

LANGHASH=`echo "${MAILREDIRECTLANG}" | md5sum | awk '{ print substr($0,0,2)}'`
export LANGHASH

# create install.js
cat > ${MAILREDIRECTLANG}/install.js <<EOT
// Install script for mailredirect ${MAILREDIRECTLANG} language pack

// 1. Set parameters of package installation
const APP_DISPLAY_NAME = "Mail Redirect ${MAILREDIRECTLANG} language pack";
const APP_NAME = "mailredirect";
const APP_VERSION = "${MAILREDIRECTVERSION}";

const APP_PACKAGE = "/" + APP_NAME;
const APP_JAR_FILE = APP_NAME + "-${MAILREDIRECTLANG}.jar";
const APP_CONTENT_FOLDER = "content/";
const APP_LOCALE_FOLDER = "locale/${MAILREDIRECTLANG}/";


const INST_TO_PROFILE = "Do you wish to install "+APP_DISPLAY_NAME+" to your profile?\nThis will mean it does not need reinstalling when you update your application.\n(Click Cancel if you want "+APP_DISPLAY_NAME+" installing to the application directory.)";


// 2. Initialise package
initInstall(APP_NAME, APP_PACKAGE, APP_VERSION);

// Get package directories
// profile installs only work since 2003-03-06
var instToProfile = false;
// var instToProfile = ((buildID>2003030600 || buildID==0000000000) && confirm(INST_TO_PROFILE));
var chromef = instToProfile ? getFolder("Profile", "chrome") : getFolder("chrome");

// 3. Flag files/folders to be added
addFile("", "chrome/" + APP_JAR_FILE, chromef, "");

err = getLastError();

if (err == SUCCESS) {

  // 4. Register chrome (this is what contents.rdf is used for)
  if(instToProfile) {
    registerChrome(LOCALE  | PROFILE_CHROME, getFolder(chromef, APP_JAR_FILE), APP_LOCALE_FOLDER);
  } else {
    registerChrome(LOCALE  | DELAYED_CHROME, getFolder(chromef, APP_JAR_FILE), APP_LOCALE_FOLDER);
  }

  // 5. Perform the installation
  err = performInstall();

  // 6. Report on success or otherwise  
  if(err == SUCCESS || err == 999) {
    refreshPlugins();
    alert(APP_DISPLAY_NAME+" "+APP_VERSION+" has been succesfully installed.\nYou need to restart Mozilla first.");
  } else {
    alert("Install failed. Error code: " + err);
    cancelInstall(err);
  }
} else {
  alert("Failed to create JAR file.\n"
    +"You probably don't have appropriate permissions \n"
    +"(write access to your profile or chrome directory). \n"
    +"_____________________________\nError code:" + err);
  cancelInstall(err);
}
EOT

# create install.rdf for Thunderbird 0.7 and newer
cat > ${MAILREDIRECTLANG}/install.rdf <<EOT
<?xml version="1.0"?>

<RDF xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:em="http://www.mozilla.org/2004/em-rdf#">

  <Description about="urn:mozilla:install-manifest">
    <em:id>{CC3C233D-66${LANGHASH}-41bc-AAEB-F3A1D1D594F5}</em:id> 
    <em:name>Mail Redirect ${MAILREDIRECTLANG}</em:name>
    <em:version>${MAILREDIRECTVERSION}</em:version>
    <em:description>Mail Redirect ${MAILREDIRECTLANG} language package</em:description>

    <!-- Author of the package, replace with your name if you like -->
    <em:creator>Pawe&#322; Krze&#347;niak</em:creator>

    <em:homepageURL>http://mailredirect.mozdev.org/langpack.html</em:homepageURL>
    <em:optionsURL>chrome://mailredirect/content/mailredirect-prefs.xul</em:optionsURL>
    <em:iconURL>chrome://mailredirect/skin/mailredirect-icon.png</em:iconURL>

    <em:file>
      <Description about="urn:mozilla:extension:file:mailredirect-${MAILREDIRECTLANG}.jar">
        <em:locale>locale/${MAILREDIRECTLANG}/</em:locale>
      </Description>
    </em:file>
    
    <em:targetApplication>
      <Description>
        <em:id>{3550f703-e582-4d05-9a08-453d09bdfdc6}</em:id>
        <em:minVersion>0.7</em:minVersion>
        <em:maxVersion>1.6+</em:maxVersion>
      </Description>
    </em:targetApplication>
  
  </Description>

</RDF>
EOT

cat >${LANGDIR}/contents.rdf <<EOT
<?xml version="1.0"?>
<RDF:RDF xmlns:RDF="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
         xmlns:chrome="http://www.mozilla.org/rdf/chrome#">

  <!-- list all the locales being supplied by this jar -->
  <RDF:Seq about="urn:mozilla:locale:root">
    <RDF:li resource="urn:mozilla:locale:${MAILREDIRECTLANG}"/>
  </RDF:Seq>

  <!-- list packages for which locale information is provided -->
   <RDF:Description about="urn:mozilla:locale:${MAILREDIRECTLANG}">
    <chrome:packages>
      <RDF:Seq about="urn:mozilla:locale:${MAILREDIRECTLANG}:packages">
        <RDF:li resource="urn:mozilla:locale:${MAILREDIRECTLANG}:mailredirect"/>
      </RDF:Seq>
    </chrome:packages>
  </RDF:Description>

</RDF:RDF> 
EOT

cat >${LANGDIR}/chrome.manifest <<EOT
locale	mailredirect	${MAILREDIRECTLANG}	jar:chrome/mailredirect-${MAILREDIRECTLANG}.jar!/locale/${MAILREDIRECTLANG}/
EOT

cd ${cwd}/locale/en-US
for f in aw.dtd mailredirect.dtd mailredirect-compose.dtd mailredirect-compose.properties mailredirect-prefs.dtd mailredirect-prefs.properties ; do
  cp ${f} ${cwd}/${LANGDIR}
done

cd ${cwd}/${MAILREDIRECTLANG}/chrome
zip -r -D mailredirect-${MAILREDIRECTLANG}.jar locale
cd ..
zip ../mailredirect-${MAILREDIRECTLANG}-${MAILREDIRECTVERSION}.xpi install.js install.rdf chrome.manifest chrome/mailredirect-${MAILREDIRECTLANG}.jar
cd ..

test $DEBUG -eq 0 && rm -rf ${MAILREDIRECTLANG}

