/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * Peter Bohan.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    R.J. Keller <rlk@trfenv.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.classes;

import java.util.*;
import java.io.Serializable;
import com.trfenv.rlk.Debug;
/**
   The Product class represents a product that clients create.

   @version 0.1
   @author Pete Bohan <neuralyzer@wowway.com>
   @author R.J. Keller <rlk@trfenv.com>
*/
public class Product implements Serializable
{
   public String name;

   private final List components = new ArrayList();
   private final List versions   = new ArrayList();
   private final List os         = new ArrayList();
   private final List platforms  = new ArrayList();

	public void addComponent(Product.component aUser) { components.add(aUser); }
	public Product.component getComponent(int aIndex) { return (Product.component)components.get(aIndex); }
	public int componentSize() { return components.size(); }

	public void addVersion(double aVersion) { components.add(new Double(aVersion)); }
	public double getVersion(int aIndex) { return ((Double)components.get(aIndex)).doubleValue(); }
	public int versionSize() { return versions.size(); }

	public void addOS(String aUser) { os.add(aUser); }
	public String getOS(int aIndex) { return (String)os.get(aIndex); }
	public int OSSize() { return os.size(); }

	public void addPlatform(String aUser) { platforms.add(aUser); }
	public String getPlatform(int aIndex) { return (String)platforms.get(aIndex); }
	public int platformSize() { return platforms.size(); }


   public class component
   {
   	  private String mName;
   	  private User mOwner;
   	  private User mQaContact;
   	  
      public component(String aName, User aOwner, User aQaContact)
      {
         mName = aName;
         mOwner = aOwner;
         mQaContact = aQaContact;
      }
      
      public void setOwner(User aUser)
      {
      	 mOwner = aUser;
      }
      
      public User getOwner()
      {
      	 return mOwner;
      }
      
      public void setQAContact(User aUser)
      {
      	 mQaContact = aUser;
      }
      
      public User getQAContact()
      {
      	 return mQaContact;
      }
      
      public String getName()
      {
      	 return mName;
      }
      
      public void setName(String aName)
      {
      	 mName = aName;
      }
   }
}
