/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Vector;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.Field;
import org.gjt.mm.mysql.Statement;

public abstract class ResultSet {
    protected Vector _rows;
    protected Field[] _fields;
    protected int _currentRow = -1;
    protected byte[][] _thisRow;
    protected Connection _connection;
    protected SQLWarning _warnings = null;
    protected boolean _wasNullFlag = false;
    protected boolean _reallyResult = false;
    protected Hashtable _columnNameToIndex = null;
    protected Hashtable _fullColumnNameToIndex = null;
    protected int _resultSetType = 0;
    protected int _resultSetConcurrency = 0;
    protected Statement _owningStatement;
    protected boolean _closed = false;
    protected long _updateID = -1L;
    protected long _updateCount;
    private SimpleDateFormat _TSDF = null;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] radixTenTenths = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] radixTenUnits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public boolean next() throws SQLException {
        boolean bl;
        if (!this.reallyResult()) {
            throw new SQLException("ResultSet is from UPDATE. No Data", "S1000");
        }
        if (this._rows.size() == 0) {
            bl = false;
        } else if (this._currentRow + 1 >= this._rows.size()) {
            this._currentRow = this._rows.size();
            bl = false;
        } else {
            this.clearWarnings();
            ++this._currentRow;
            this._thisRow = (byte[][])this._rows.elementAt(this._currentRow);
            bl = true;
        }
        return bl;
    }

    public boolean prev() throws SQLException {
        if (this._currentRow - 1 >= 0) {
            --this._currentRow;
            this._thisRow = (byte[][])this._rows.elementAt(this._currentRow);
            return true;
        }
        return false;
    }

    public void close() throws SQLException {
        if (this._rows != null) {
            this._rows.removeAllElements();
        }
        this._closed = true;
    }

    public boolean wasNull() throws SQLException {
        return this._wasNullFlag;
    }

    public String getString(int n) throws SQLException {
        this.checkRowPos();
        if (this._fields == null) {
            throw new SQLException("Query generated no fields for ResultSet", "S1002");
        }
        if (n < 1 || n > this._fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this._fields.length + ").", "S1002");
        }
        try {
            this._wasNullFlag = this._thisRow[n - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this._wasNullFlag = true;
        }
        if (this._wasNullFlag) {
            return null;
        }
        if (this._connection != null && this._connection.useUnicode()) {
            try {
                String string = this._connection.getEncoding();
                if (string == null) {
                    return new String(this._thisRow[n - 1]);
                }
                return new String(this._thisRow[n - 1], this._connection.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("Unsupported character encoding '" + this._connection.getEncoding() + "'.", "0S100");
            }
        }
        return new String(this._thisRow[n - 1]);
    }

    public boolean getBoolean(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null && string.length() > 0) {
            char c = string.toLowerCase().charAt(0);
            return c == 't' || c == 'y' || c == '1' || string.equals("-1");
        }
        return false;
    }

    public byte getByte(int n) throws SQLException {
        this.checkRowPos();
        if (n < 1 || n > this._fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this._fields.length + ").", "S1002");
        }
        try {
            this._wasNullFlag = this._thisRow[n - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this._wasNullFlag = true;
        }
        if (this._wasNullFlag) {
            return 0;
        }
        Field field = this._fields[n - 1];
        switch (field.getMysqlType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                try {
                    String string = this.getString(n);
                    if (string.indexOf(".") != -1) {
                        string = string.substring(0, string.indexOf("."));
                    }
                    return Byte.parseByte(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Value '" + this.getString(n) + "' is out of range [-127,127]", "S1009");
                }
            }
        }
        return this._thisRow[n - 1][0];
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getLong(n);
    }

    public int getInt(int n) throws SQLException {
        return (int)this.getLong(n);
    }

    public long getLong(int n) throws SQLException {
        this.checkRowPos();
        if (this._fields == null) {
            throw new SQLException("Query generated no fields for ResultSet", "S1002");
        }
        if (n < 1 || n > this._fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this._fields.length + ").", "S1002");
        }
        try {
            this._wasNullFlag = this._thisRow[n - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this._wasNullFlag = true;
        }
        if (this._wasNullFlag) {
            return 0L;
        }
        try {
            return this.getLong(this._thisRow[n - 1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Bad format for number '" + new String(this._thisRow[n - 1]) + "' in column " + n + "(" + this._fields[n - 1] + ").", "S1009");
        }
    }

    public float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    public double getDouble(int n) throws SQLException {
        this.checkRowPos();
        if (this._fields == null) {
            throw new SQLException("Query generated no fields for ResultSet", "S1002");
        }
        if (n < 1 || n > this._fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this._fields.length + ").", "S1002");
        }
        try {
            this._wasNullFlag = this._thisRow[n - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this._wasNullFlag = true;
        }
        if (this._wasNullFlag) {
            return 0.0;
        }
        try {
            return ResultSet.getDouble(this._thisRow[n - 1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Bad format for number '" + new String(this._thisRow[n - 1]) + "' in column " + n + "(" + this._fields[n - 1] + ").", "S1009");
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            BigDecimal bigDecimal;
            if (string.length() == 0) {
                BigDecimal bigDecimal2 = new BigDecimal(0.0);
                return bigDecimal2.setScale(n2);
            }
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Bad format for BigDecimal '" + string + "' in column " + n + "(" + this._fields[n - 1] + ").", "S1009");
            }
            try {
                return bigDecimal.setScale(n2);
            }
            catch (ArithmeticException arithmeticException) {
                throw new SQLException("Bad format for BigDecimal '" + string + "' in column " + n + "(" + this._fields[n - 1] + ").", "S1009");
            }
        }
        return null;
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkRowPos();
        if (n < 1 || n > this._fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this._fields.length + ").", "S1002");
        }
        try {
            this._wasNullFlag = this._thisRow[n - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this._wasNullFlag = true;
        }
        if (this._wasNullFlag) {
            return null;
        }
        return this._thisRow[n - 1];
    }

    public Date getDate(int n) throws SQLException {
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        String string = "";
        try {
            string = this.getString(n);
            if (string == null) {
                return null;
            }
            if (string.equals("0000-00-00")) {
                this._wasNullFlag = true;
                return null;
            }
            if (this._fields[n - 1].getMysqlType() == 7) {
                switch (string.length()) {
                    case 8: 
                    case 14: {
                        n2 = new Integer(string.substring(0, 4));
                        n3 = new Integer(string.substring(4, 6));
                        n4 = new Integer(string.substring(6, 8));
                        return new Date(n2 - 1900, n3 - 1, n4);
                    }
                    case 6: 
                    case 10: 
                    case 12: {
                        n2 = new Integer(string.substring(0, 2));
                        if (n2 <= 69) {
                            n2 = new Integer(n2 + 100);
                        }
                        n3 = new Integer(string.substring(2, 4));
                        n4 = new Integer(string.substring(4, 6));
                        return new Date(n2, n3 - 1, n4);
                    }
                    case 4: {
                        n2 = new Integer(string.substring(0, 4));
                        if (n2 <= 69) {
                            n2 = new Integer(n2 + 100);
                        }
                        n3 = new Integer(string.substring(2, 4));
                        return new Date(n2, n3 - 1, 1);
                    }
                    case 2: {
                        n2 = new Integer(string.substring(0, 2));
                        if (n2 <= 69) {
                            n2 = new Integer(n2 + 100);
                        }
                        return new Date(n2, 0, 1);
                    }
                }
                throw new SQLException("Bad format for Date '" + string + "' in column " + n + "(" + this._fields[n - 1] + ").", "S1009");
            }
            if (this._fields[n - 1].getMysqlType() == 13) {
                n2 = new Integer(string.substring(0, 4));
                return new Date(n2 - 1900, 0, 1);
            }
            if (string.length() < 10) {
                throw new SQLException("Bad format for Date '" + string + "' in column " + n + "(" + this._fields[n - 1] + ").", "S1009");
            }
            n2 = new Integer(string.substring(0, 4));
            n3 = new Integer(string.substring(5, 7));
            n4 = new Integer(string.substring(8, 10));
            return new Date(n2 - 1900, n3 - 1, n4);
        }
        catch (Exception exception) {
            throw new SQLException("Cannot convert value '" + string + "' from column " + n + "(" + string + " ) to DATE.", "S1009");
        }
    }

    public Time getTime(int n) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            String string = this.getString(n);
            if (string == null) {
                return null;
            }
            if (string.equals("0000-00-00")) {
                this._wasNullFlag = true;
                return null;
            }
            Field field = this._fields[n - 1];
            if (field.getMysqlType() == 7) {
                int n5 = string.length();
                switch (n5) {
                    case 12: 
                    case 14: {
                        n2 = Integer.parseInt(string.substring(n5 - 6, n5 - 4));
                        n3 = Integer.parseInt(string.substring(n5 - 4, n5 - 2));
                        n4 = Integer.parseInt(string.substring(n5 - 2, n5));
                        break;
                    }
                    case 10: {
                        n2 = Integer.parseInt(string.substring(6, 8));
                        n3 = Integer.parseInt(string.substring(8, 10));
                        n4 = 0;
                        break;
                    }
                    default: {
                        throw new SQLException("Timestamp too small to convert to Time value in column " + n + "(" + this._fields[n - 1] + ").", "S1009");
                    }
                }
                SQLWarning sQLWarning = new SQLWarning("Precision lost converting TIMESTAMP to Time with getTime() on column " + n + "(" + this._fields[n - 1] + ").");
                if (this._warnings == null) {
                    this._warnings = sQLWarning;
                } else {
                    this._warnings.setNextWarning(sQLWarning);
                }
            } else if (field.getMysqlType() == 12) {
                n2 = Integer.parseInt(string.substring(11, 13));
                n3 = Integer.parseInt(string.substring(14, 16));
                n4 = Integer.parseInt(string.substring(17, 19));
                SQLWarning sQLWarning = new SQLWarning("Precision lost converting DATETIME to Time with getTime() on column " + n + "(" + this._fields[n - 1] + ").");
                if (this._warnings == null) {
                    this._warnings = sQLWarning;
                } else {
                    this._warnings.setNextWarning(sQLWarning);
                }
            } else {
                if (string.length() != 5 && string.length() != 8) {
                    throw new SQLException("Bad format for Time '" + string + "' in column " + n + "(" + this._fields[n - 1] + ").", "S1009");
                }
                n2 = Integer.parseInt(string.substring(0, 2));
                n3 = Integer.parseInt(string.substring(3, 5));
                n4 = string.length() == 5 ? 0 : Integer.parseInt(string.substring(6));
            }
            return new Time(n2, n3, n4);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getClass().getName(), "S1009");
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        try {
            if (string == null) {
                return null;
            }
            if (string.equals("0000-00-00")) {
                this._wasNullFlag = true;
                return null;
            }
            if (this._fields[n - 1].getMysqlType() == 13) {
                return new Timestamp(Integer.parseInt(string.substring(0, 4)) - 1900, 0, 1, 0, 0, 0, 0);
            }
            switch (string.length()) {
                case 19: {
                    int n2 = Integer.parseInt(string.substring(0, 4));
                    int n3 = Integer.parseInt(string.substring(5, 7));
                    int n4 = Integer.parseInt(string.substring(8, 10));
                    int n5 = Integer.parseInt(string.substring(11, 13));
                    int n6 = Integer.parseInt(string.substring(14, 16));
                    int n7 = Integer.parseInt(string.substring(17, 19));
                    return new Timestamp(n2 - 1900, n3 - 1, n4, n5, n6, n7, 0);
                }
                case 14: {
                    int n8 = Integer.parseInt(string.substring(0, 4));
                    int n9 = Integer.parseInt(string.substring(4, 6));
                    int n10 = Integer.parseInt(string.substring(6, 8));
                    int n11 = Integer.parseInt(string.substring(8, 10));
                    int n12 = Integer.parseInt(string.substring(10, 12));
                    int n13 = Integer.parseInt(string.substring(12, 14));
                    return new Timestamp(n8 - 1900, n9 - 1, n10, n11, n12, n13, 0);
                }
                case 12: {
                    int n14 = Integer.parseInt(string.substring(0, 2));
                    if (n14 <= 69) {
                        n14 += 100;
                    }
                    int n15 = Integer.parseInt(string.substring(2, 4));
                    int n16 = Integer.parseInt(string.substring(4, 6));
                    int n17 = Integer.parseInt(string.substring(6, 8));
                    int n18 = Integer.parseInt(string.substring(8, 10));
                    int n19 = Integer.parseInt(string.substring(10, 12));
                    return new Timestamp(n14, n15 - 1, n16, n17, n18, n19, 0);
                }
                case 10: {
                    int n20 = Integer.parseInt(string.substring(0, 2));
                    if (n20 <= 69) {
                        n20 += 100;
                    }
                    int n21 = Integer.parseInt(string.substring(2, 4));
                    int n22 = Integer.parseInt(string.substring(4, 6));
                    int n23 = Integer.parseInt(string.substring(6, 8));
                    int n24 = Integer.parseInt(string.substring(8, 10));
                    return new Timestamp(n20, n21 - 1, n22, n23, n24, 0, 0);
                }
                case 8: {
                    int n25 = Integer.parseInt(string.substring(0, 4));
                    int n26 = Integer.parseInt(string.substring(4, 6));
                    int n27 = Integer.parseInt(string.substring(6, 8));
                    return new Timestamp(n25 - 1900, n26 - 1, n27, 0, 0, 0, 0);
                }
                case 6: {
                    int n28 = Integer.parseInt(string.substring(0, 2));
                    if (n28 <= 69) {
                        n28 += 100;
                    }
                    int n29 = Integer.parseInt(string.substring(2, 4));
                    int n30 = Integer.parseInt(string.substring(4, 6));
                    return new Timestamp(n28, n29 - 1, n30, 0, 0, 0, 0);
                }
                case 4: {
                    int n31 = Integer.parseInt(string.substring(0, 2));
                    if (n31 <= 69) {
                        n31 += 100;
                    }
                    int n32 = Integer.parseInt(string.substring(2, 4));
                    return new Timestamp(n31, n32 - 1, 1, 0, 0, 0, 0);
                }
                case 2: {
                    int n33 = Integer.parseInt(string.substring(0, 2));
                    if (n33 <= 69) {
                        n33 += 100;
                    }
                    return new Timestamp(n33, 0, 1, 0, 0, 0, 0);
                }
            }
            throw new SQLException("Bad format for Timestamp '" + string + "' in column " + n + "(" + this._fields[n - 1] + ").", "S1009");
        }
        catch (Exception exception) {
            throw new SQLException("Cannot convert value '" + string + "' from column " + n + "(" + string + " ) to TIMESTAMP.", "S1009");
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkRowPos();
        return this.getBinaryStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkRowPos();
        return this.getBinaryStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkRowPos();
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._warnings;
    }

    public void clearWarnings() throws SQLException {
        this._warnings = null;
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned Update not supported.", "S1C00");
    }

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public Object getObject(int n) throws SQLException {
        this.checkRowPos();
        if (n < 1 || n > this._fields.length) {
            throw new SQLException("Column index out of range (" + n + " > " + this._fields.length + ").", "S1002");
        }
        Field field = this._fields[n - 1];
        if (this._thisRow[n - 1] == null) {
            this._wasNullFlag = true;
            return null;
        }
        this._wasNullFlag = false;
        switch (field.getSQLType()) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: {
                if (field.isUnsigned()) {
                    return new Integer(this.getInt(n));
                }
                return new Byte(this.getByte(n));
            }
            case 5: {
                if (field.isUnsigned()) {
                    return new Integer(this.getInt(n));
                }
                return new Short(this.getShort(n));
            }
            case 4: {
                if (field.isUnsigned()) {
                    return new Long(this.getLong(n));
                }
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 2: 
            case 3: {
                String string = this.getString(n);
                if (string != null) {
                    BigDecimal bigDecimal;
                    if (string.length() == 0) {
                        BigDecimal bigDecimal2 = new BigDecimal(0.0);
                        return bigDecimal2;
                    }
                    try {
                        bigDecimal = new BigDecimal(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SQLException("Bad format for BigDecimal '" + string + "' in column " + n + "(" + this._fields[n - 1] + ").", "S1009");
                    }
                    return bigDecimal;
                }
                return null;
            }
            case 6: 
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case -1: 
            case 1: 
            case 12: {
                if (field.isBinary()) {
                    return this.getBytes(n);
                }
                return this.getString(n);
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray;
                if (!field.isBlob()) {
                    return this.getString(n);
                }
                if (!field.isBinary()) {
                    return this.getString(n);
                }
                Object object = byArray = this.getBytes(n);
                if (byArray != null && byArray.length >= 2 && byArray[0] == -84 && byArray[1] == -19) {
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        object = objectInputStream.readObject();
                        objectInputStream.close();
                        byteArrayInputStream.close();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new SQLException("Class not found: " + classNotFoundException.toString() + " while reading serialized object");
                    }
                    catch (IOException iOException) {
                        object = byArray;
                    }
                }
                return object;
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
        }
        return this.getString(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        Integer n = (Integer)this._columnNameToIndex.get(string);
        if (n == null) {
            n = (Integer)this._fullColumnNameToIndex.get(string);
        }
        if (n != null) {
            return n + 1;
        }
        String string2 = string.toUpperCase();
        int n2 = 0;
        while (n2 < this._fields.length) {
            if (this._fields[n2].getName().toUpperCase().equals(string2)) {
                return n2 + 1;
            }
            if (this._fields[n2].getFullName().toUpperCase().equals(string2)) {
                return n2 + 1;
            }
            ++n2;
        }
        throw new SQLException("Column '" + string + "' not found.", "S0022");
    }

    public ResultSet(Field[] fieldArray, Vector vector, Connection connection) {
        this(fieldArray, vector);
        this.setConnection(connection);
    }

    public ResultSet(Field[] fieldArray, Vector vector) {
        this._currentRow = -1;
        this._fields = fieldArray;
        this._rows = vector;
        this._updateCount = this._rows.size();
        this._reallyResult = true;
        if (this._rows.size() > 0) {
            this._thisRow = (byte[][])this._rows.elementAt(0);
            if (this._updateCount == 1L && this._thisRow == null) {
                this._currentRow = -1;
                this._rows.removeAllElements();
                this._updateCount = -1L;
            }
        } else {
            this._thisRow = null;
        }
        this.buildIndexMapping();
    }

    void setStatement(Statement statement) {
        this._owningStatement = statement;
    }

    protected void buildIndexMapping() {
        int n = this._fields.length;
        this._columnNameToIndex = new Hashtable();
        this._fullColumnNameToIndex = new Hashtable();
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = new Integer(n2);
            String string = this._fields[n2].getName();
            String string2 = this._fields[n2].getFullName();
            if (string != null) {
                this._columnNameToIndex.put(string, n3);
                this._columnNameToIndex.put(string.toUpperCase(), n3);
                this._columnNameToIndex.put(string.toLowerCase(), n3);
            }
            if (string2 != null) {
                this._fullColumnNameToIndex.put(string2, n3);
                this._fullColumnNameToIndex.put(string2.toUpperCase(), n3);
                this._fullColumnNameToIndex.put(string2.toLowerCase(), n3);
            }
            ++n2;
        }
    }

    public ResultSet(long l, long l2) {
        this._updateCount = l;
        this._updateID = l2;
        this._reallyResult = false;
        this._fields = new Field[0];
    }

    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    boolean reallyResult() {
        return this._reallyResult;
    }

    long getUpdateCount() {
        return this._updateCount;
    }

    long getUpdateID() {
        return this._updateID;
    }

    protected void checkRowPos() throws SQLException {
        if (this._closed) {
            throw new SQLException("Operation not allowed after ResultSet closed");
        }
        if (this._currentRow < 0) {
            throw new SQLException("Before start of result set");
        }
        if (this._currentRow == this._rows.size()) {
            throw new SQLException("After end of result set");
        }
    }

    public static double getDouble(byte[] byArray) throws SQLException {
        if (byArray.length == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(new String(byArray));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Bad format for number '" + new String(byArray) + "'");
        }
    }

    public long getLong(byte[] byArray) throws NumberFormatException {
        long l = 0L;
        boolean bl = false;
        int n = 0;
        int n2 = byArray.length;
        int n3 = 10;
        if (n2 > 0) {
            int n4;
            long l2;
            if ((char)byArray[0] == '-') {
                bl = true;
                l2 = Long.MIN_VALUE;
                ++n;
            } else {
                l2 = -9223372036854775807L;
            }
            long l3 = l2 / (long)n3;
            if (n < n2) {
                if ((n4 = Character.digit((char)byArray[n++], n3)) < 0) {
                    throw new NumberFormatException(new String(byArray));
                }
                l = -n4;
            }
            while (n < n2) {
                if ((n4 = Character.digit((char)byArray[n++], n3)) < 0) {
                    throw new NumberFormatException(new String(byArray));
                }
                if (l < l3) {
                    throw new NumberFormatException(new String(byArray));
                }
                if ((l *= (long)n3) < l2 + (long)n4) {
                    throw new NumberFormatException(new String(byArray));
                }
                l -= (long)n4;
            }
        } else {
            throw new NumberFormatException(new String(byArray));
        }
        if (bl) {
            if (n > 1) {
                return l;
            }
            throw new NumberFormatException(new String(byArray));
        }
        return -l;
    }

    protected void setResultSetType(int n) {
        this._resultSetType = n;
    }

    protected void setResultSetConcurrency(int n) {
        this._resultSetConcurrency = n;
    }
}

