/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Sun Microsystems,
 * Inc. Portions created by Sun are
 * Copyright (C) 1999 Sun Microsystems, Inc. All
 * Rights Reserved.
 *
 * Contributor(s):
 * Leila.Garin@eng.sun.com
 * Igor Kushnirskiy <idk@eng.sun.com>
 * Brad GNUberg <bkn3@columbia.edu>
 */

#include <stdio.h>
#include <stdlib.h>

#include "nsLiteralString.h"
#include "nsString2.h"			// for nsAutoString

#include "nsIModule.h"
#include "nsIServiceManager.h"

#include "bcDefs.h"
#include "bcIORB.h"
#include "bcIStub.h"

#include "bcIORBComponent.h"
#include "bcORBComponentCID.h"

#include "bcIXPCOMStubsAndProxies.h"
#include "bcXPCOMStubsAndProxiesCID.h"

#include "bcTestImpl.h"

nsrefcnt bcTestImpl::AddRef(void) { 
    nsrefcnt cnt = (nsrefcnt) PR_AtomicIncrement((PRInt32*)&mRefCnt);
    return cnt;
}

nsrefcnt bcTestImpl::Release(void) {
    nsrefcnt cnt = (nsrefcnt) PR_AtomicDecrement((PRInt32*)&mRefCnt);
    if(0 == cnt) {  
        delete this;
    }
    return cnt;
}

NS_IMETHODIMP bcTestImpl::QueryInterface(REFNSIID aIID, void** aInstancePtr) {
    if ( !aInstancePtr ) {
        return NS_ERROR_NULL_POINTER;
    }
    if ( aIID.Equals(NS_GET_IID(nsISupports)) 
         || aIID.Equals(NS_GET_IID(bcITest)))
    {
        *(nsISupports**)aInstancePtr = this;
        return NS_OK;
    } else {
        return NS_NOINTERFACE;
    }
    
}


/*void test1(inout long l);*/
NS_IMETHODIMP bcTestImpl::Test1(PRInt32 *l) {
    *l = 1234;
    return NS_OK;
}
    
/*void test2(in long l1,inout long l2);*/
NS_IMETHODIMP bcTestImpl::Test2(PRInt32 l1, PRInt32* l2) {
    *l2 = l1;
    return NS_OK;
}

/*void test3(in string s1,inout string s2);*/
NS_IMETHODIMP bcTestImpl::Test3(const char *s1, char **s2) {
    NS_WARN_IF_FALSE(nsDependentCString(s1, 2) == NS_LITERAL_CSTRING("s1"), "--bcTestImpl::Test3 failed"); 
	*s2 =  "hi";
    return NS_OK;
}

/*void test4(in PRUint32 count,[array, size_is(count)] in string valueArray);*/
NS_IMETHODIMP bcTestImpl::Test4(PRUint32 count, const char **valueArray) {
    NS_WARN_IF_FALSE(nsDependentCString(valueArray[0], 2) == NS_LITERAL_CSTRING("hi"), "--bcTestImpl::Test4 failed");
	NS_WARN_IF_FALSE(nsDependentCString(valueArray[1], 5) == NS_LITERAL_CSTRING("there"), "--bcTestImpl::Test4 failed");
	NS_WARN_IF_FALSE(nsDependentCString(valueArray[2], 1) == NS_LITERAL_CSTRING("a"), "--bcTestImpl::Test4 failed");
	NS_WARN_IF_FALSE(nsDependentCString(valueArray[3], 1) == NS_LITERAL_CSTRING("b"), "--bcTestImpl::Test4 failed");

    return NS_OK;
}

/*void test5(in PRUint32 count,[array, size_is(count)] inout string valueArray);*/
NS_IMETHODIMP bcTestImpl::Test5(PRUint32 count, char ***valueArray) {
    char ** array = (char **)malloc(sizeof(char*)*4);
    array[0] = "1";
    array[1] = "2";
    array[2] = "hello";
    array[3] = "world";
    *valueArray = array;
    
    return NS_OK;
}

/* void test6(in bcITest o); */
NS_IMETHODIMP bcTestImpl::Test6(class bcITest *o) {
    PRInt32 l = 1234;
    o->Test1(&l);
	NS_WARN_IF_FALSE(l == 1234, "--bcTestImpl::Test6 failed");
    return NS_OK;
}

/* void test7 (out bcITest o); */
NS_IMETHODIMP bcTestImpl::Test7(bcITest **o) {
    if (o == NULL) {
        return NS_ERROR_NULL_POINTER;
    }
    *o = new bcTestImpl();
    return NS_OK;
}

/** The following three methods test the XPCOM BlackConnect portion against
	the Mozilla String classes (AString, ACString, AUTF8String).  However,
	the bridge cannot currently support these types, so these methods are
	not filled out. -- bkn3@columbia.edu */

/* void test8(in AString s1, out AString s2); */
NS_IMETHODIMP bcTestImpl::Test8(const nsAString & s1, nsAString & s2) {
	NS_NOTYETIMPLEMENTED("Test8 not implemented");
	//printf("%d", s1.Length());
	//printf("%s", PromiseFlatString(s1));
	//NS_WARN_IF_FALSE(s1 == s1, "--bcTestImpl::Test8 failed");
	//s2.Assign(NS_LITERAL_STRING("Some value"));
	return NS_OK;
}

/* void test9(in ACString s1, out ACString s2); */
NS_IMETHODIMP bcTestImpl::Test9(const nsACString & s1, nsACString & s2) {
	NS_NOTYETIMPLEMENTED("Test9 not implemented");
	return NS_OK;
}

/* void test10(in AUTF8String s1, out AUTF8String s2); */
NS_IMETHODIMP bcTestImpl::Test10(const nsACString & s1, nsACString & s2) {
	NS_NOTYETIMPLEMENTED("Test10 not implemented");
	return NS_OK;
}

/****************************************************/

static void test(void) {
    printf("--bcTestImpl::Starting tests to check if xpcom portion of BlackConnect bridge is working\n");
	printf("--bcTestImpl::If no assertions fail then the xpcom portion is working correctly\n");

    nsresult r;
    //NS_WITH_SERVICE(bcORB, _orb, kORBCIID, &r); -- deprecated usage, bkn3@columbia.edu
	nsCOMPtr<bcIORBComponent> _orb = do_GetService(BC_ORBCOMPONENT_ContractID, &r);
    if (NS_FAILED(r)) {
        printf("--bcTestImpl test failed\n");
        return;
    }

    //NS_WITH_SERVICE(bcXPCOMStubsAndProxies, xpcomStubsAndProxies, kXPCOMStubsAndProxies, &r); -- deprecated usage, bkn3@columbia.edu
	nsCOMPtr<bcIXPCOMStubsAndProxies> xpcomStubsAndProxies = do_GetService(BC_XPCOMSTUBSANDPROXIES_ContractID, &r);
    if (NS_FAILED(r)) {
        printf("--bcTestImpl test failed\n");
        return;
    }
    bcIORB *orb;
    _orb->GetORB(&orb);
    bcIStub *stub = NULL;
    bcITest *object = new bcTestImpl();
    object->AddRef();
    bcITest *proxy = NULL;
    xpcomStubsAndProxies->GetStub((nsISupports*)object, &stub);
    bcOID oid = orb->RegisterStub(stub);
    r = xpcomStubsAndProxies->GetProxy(oid,NS_GET_IID(bcITest),orb,(nsISupports**)&proxy);
    if (NS_FAILED(r)) {
		NS_WARN_IF_FALSE(PR_FALSE, "--bcTestImpl test failed\n");
        return;
    }

    /*******************************************/
    PRInt32 l1 = 1999;
    object->Test1(&l1);
	NS_WARN_IF_FALSE(l1 == 1234, "--bcTestImpl::Test1 failed");
    l1 = 1999;
    proxy->Test1(&l1);
	NS_WARN_IF_FALSE(l1 == 1234, "--bcTestImpl::Test1 failed");
	
    /*******************************************/    
    PRInt32 l2 = 2000;
    l1 = 1999;
    proxy->Test2(l1,&l2);
	NS_WARN_IF_FALSE(l2 == l1, "--bcTestImpl::Test2 failed");
    
    /*******************************************/
    const char * s1 = "s1";
    char * s2 = "s2";
    proxy->Test3(s1,&s2);
	NS_WARN_IF_FALSE(nsDependentCString(s2, 2) == NS_LITERAL_CSTRING("hi"), "--bcTestImpl::Test3 failed");
    
    /*******************************************/
	char ** valueArray = (char **)malloc(sizeof(char*)*4);
    valueArray[0] = "hi";
    valueArray[1] = "there";
    valueArray[2] = "a";
    valueArray[3] = "b";

    proxy->Test4(4,(const char **)valueArray);
    /*******************************************/

    char ***valueArray2 = &valueArray;

    object->Test5(4,valueArray2);
	NS_WARN_IF_FALSE(nsDependentCString((*valueArray2)[0], 1) == NS_LITERAL_CSTRING("1"), "--bcTestImpl::Test5 failed");
	NS_WARN_IF_FALSE(nsDependentCString((*valueArray2)[1], 1) == NS_LITERAL_CSTRING("2"), "--bcTestImpl::Test5 failed");
	NS_WARN_IF_FALSE(nsDependentCString((*valueArray2)[2], 5) == NS_LITERAL_CSTRING("hello"), "--bcTestImpl::Test5 failed");
	NS_WARN_IF_FALSE(nsDependentCString((*valueArray2)[3], 5) == NS_LITERAL_CSTRING("world"), "--bcTestImpl::Test5 failed");
    
    valueArray2 = (char ***)&valueArray;
    proxy->Test5(4,valueArray2);

	NS_WARN_IF_FALSE(nsDependentCString((*valueArray2)[0], 1) == NS_LITERAL_CSTRING("1"), "--bcTestImpl::Test5 failed");
	NS_WARN_IF_FALSE(nsDependentCString((*valueArray2)[1], 1) == NS_LITERAL_CSTRING("2"), "--bcTestImpl::Test5 failed");
	NS_WARN_IF_FALSE(nsDependentCString((*valueArray2)[2], 5) == NS_LITERAL_CSTRING("hello"), "--bcTestImpl::Test5 failed");
	NS_WARN_IF_FALSE(nsDependentCString((*valueArray2)[3], 5) == NS_LITERAL_CSTRING("world"), "--bcTestImpl::Test5 failed");

    /*********************************************/
    proxy->Test6(object);
    /*********************************************/
    {
        bcITest *p1;
        proxy->Test7(&p1);
        PRInt32 l = 1999;
        p1->Test1(&l);
		NS_WARN_IF_FALSE(l == 1234, "--bcTestImpl::Test7 failed");
        bcITest *p3;
        // the following if statement does not succeed - check up on this
		// bkn3@columbia.edu
        if (NS_SUCCEEDED(p1->QueryInterface(NS_GET_IID(bcITest),(void**)&p3))) {
            l=2000;
            p3->Test1(&l);
        }


    }

	/*********************************************/
	
	//nsAutoString results;
	//const nsAString & arg = NS_LITERAL_STRING("Unicode is cool");
	//NS_NAMED_LITERAL_STRING(arg, "Unicode is cool");
	//proxy->Test8(arg, results);
	//NS_WARN_IF_FALSE(results == NS_LITERAL_STRING("Some value"), "--bcTestImpl::Test8 failed");
}

static int counter = 0;  //we do not need to call it on unload time;
extern "C" NS_EXPORT nsresult NSGetModule(nsIComponentManager *compMgr,
                                          nsIFile *location,
                                          nsIModule** result) //I am using it for running test *only*
{	if (counter == 0) {
        counter ++;
        test();
    }
    return NS_ERROR_FAILURE;
}




