/*$Id: fkStreamListenerTeeFactory.cpp,v 1.2 2008/05/18 10:29:01 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2008 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */


#include "fkStreamListenerTeeFactory.h"
#include "fkStreamListener.h"
#include "Error.h"


fkStreamListenerTeeFactory::fkStreamListenerTeeFactory()
{
	TRACE("constructor %08x", this);
}

fkStreamListenerTeeFactory::~fkStreamListenerTeeFactory()
{
	TRACE("destructor %08x", this);
}

NS_IMPL_THREADSAFE_ISUPPORTS1(fkStreamListenerTeeFactory, nsIFactory)


NS_IMETHODIMP
fkStreamListenerTeeFactory::CreateInstance(nsISupports *aOuter, 
					   const nsIID & iid, void **result)
{
	TRACE("create instance called");
	NS_ENSURE_ARG_POINTER(result);
	
	nsresult rv;
	fkStreamListener *inst;
	
	*result = nsnull;
	if (NULL != aOuter) {
		return NS_ERROR_NO_AGGREGATION;
	}

	inst = new fkStreamListener();
	if (NULL == inst) {
		return NS_ERROR_OUT_OF_MEMORY;
	}
	
	NS_ADDREF(inst);
	rv = inst->QueryInterface(iid, result);
	NS_RELEASE(inst);
	return rv;
}


NS_IMETHODIMP
fkStreamListenerTeeFactory::LockFactory(PRBool lock)
{
	FK_ASSERT(false);
	return NS_ERROR_NOT_IMPLEMENTED;
}

