/*$Id: fkRule.cpp,v 1.10 2008/05/18 10:29:01 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006,2007 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "plstr.h"
#include "fkRule.h"
#include "fkRuleReference.h"
#include "Error.h"
#include "string.h"
#include "nsMemory.h"


/*TODO: maybe better way than to copy all the fields in the Rule is to
  make fkRule own the Rule. Ay lease do the map no to duplicate fkRule for
  the same rule*/
fkRule::fkRule(): ruleraw(nsnull), action(nsnull), msg(nsnull),
		  references(nsnull), references_cnt(0), 
		  fid(0), rev(0)
{
	TRACE("constructor %08x", this);	
}

NS_IMETHODIMP
fkRule::Init(const Rule *rule)
{
	if (!rule)
		return NS_ERROR_NULL_POINTER;

	fid = rule->fid;
	rev = rule->rev;
	
	if (rule->ruleraw){
		ruleraw = PL_strdup(rule->ruleraw);
		if (!ruleraw)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	
	if (rule->action){
		action = PL_strdup(rule->action);
		if (!action)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	
	if (rule->msg){
		msg = PL_strdup(rule->msg);
		if (!msg)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	
	references_cnt = rule->references.size();
	if (references_cnt == 0)
		return NS_OK;
	
	references = (fkRuleReference **)
		nsMemory::Alloc(sizeof(fkRuleReference *) * references_cnt);
	if (!references)
		return NS_ERROR_OUT_OF_MEMORY;
	
	list<reference>::const_iterator it = rule->references.begin();
	for(PRUint32 i = 0; i < references_cnt; ++i, ++it){
		references[i] = new fkRuleReference();
		
		if (!references[i] || NS_FAILED(references[i]->Init(&*it))){
			for(PRUint32 j = 0; j <= i; j++)
				if (references[j])
					NS_RELEASE(references[j]);
			nsMemory::Free(references);
			references = nsnull;
			return NS_ERROR_OUT_OF_MEMORY;
		}
		NS_ADDREF(references[i]);		
	}
	return NS_OK;
}

fkRule::~fkRule()
{
	TRACE("destructor %08x", this);
	if (ruleraw)
		nsMemory::Free(ruleraw);
	if (action)
		nsMemory::Free(action);
	if (msg)
		nsMemory::Free(msg);
	if (references){
		for(PRUint32 j = 0; j < references_cnt; j++)
			NS_RELEASE(references[j]);
		nsMemory::Free(references);
	}
}

NS_IMPL_ISUPPORTS1(fkRule, fkIRule)

NS_IMETHODIMP fkRule::GetRuleraw(char **aRuleraw)
{
	if (!aRuleraw)
		return NS_ERROR_NULL_POINTER;
	*aRuleraw = nsnull;
	
	if(ruleraw){
		*aRuleraw = PL_strdup(ruleraw);	
		if (!*aRuleraw)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}

NS_IMETHODIMP fkRule::GetAction(char **aAction)
{
	if (!aAction)
		return NS_ERROR_NULL_POINTER;
	*aAction = nsnull;

	if(action){
		*aAction = PL_strdup(action);	
		if (!*aAction)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}

/* readonly attribute string msg; */
NS_IMETHODIMP fkRule::GetMsg(char **aMsg)
{
	if (!aMsg)
		return NS_ERROR_NULL_POINTER;
	*aMsg = nsnull;

	if(msg){
		*aMsg = PL_strdup(msg);	
		if (!*aMsg)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}


NS_IMETHODIMP fkRule::GetReferences(PRUint32 *aCount, fkIRuleReference ***aReferences)
{
	if (!aCount || !aReferences)
		return NS_ERROR_NULL_POINTER;
	*aCount = 0;
	*aReferences = nsnull;
	
	if (references_cnt == 0)
		return NS_OK;
	
	fkIRuleReference **out = (fkIRuleReference **)
		nsMemory::Alloc(sizeof(fkIRuleReference *) * references_cnt);
	if (!out)
		return NS_ERROR_OUT_OF_MEMORY;
	
	for(PRUint32 i = 0; i < references_cnt; ++i){
		out[i] = references[i];
		NS_ADDREF(out[i]);		
	}
	
	*aReferences = out;
	*aCount = references_cnt;
	return NS_OK;
}

/* readonly attribute unsigned long fid; */
NS_IMETHODIMP fkRule::GetFid(PRUint32 *aFid)
{	
	if (!aFid)
		return NS_ERROR_NULL_POINTER;
	*aFid = fid;
	return NS_OK;
}

/* readonly attribute unsigned long rev; */
NS_IMETHODIMP fkRule::GetRev(PRUint32 *aRev)
{
	if (!aRev)
		return NS_ERROR_NULL_POINTER;
	*aRev = rev;
	return NS_OK;
}


