/*$Id: config.js,v 1.19 2008/05/18 21:42:58 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006,2007 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

var rulesEditEnabled = false;

var sourcesObserver = {
	register: function()
	{
		var observerService =
		Components.classes["@mozilla.org/observer-service;1"]
		.getService(Components.interfaces.nsIObserverService);
		observerService.addObserver(this, 'fk_rules_sources_changed', 
					    true);		
		observerService.addObserver(this, 'fk_rules_load_started', 
					    true);		
		observerService.addObserver(this, 'fk_rules_load_stopped', 
					    true);		
	},
	
	observe:  function(subject, topic, data){
		if (topic == 'fk_rules_load_stopped'){
			loadState(false);			
		}else if (topic == 'fk_rules_load_started'){
			loadState(true);			
		}else{
			refreshRulesList();
		}
	},
	
	QueryInterface: function(iid){
		if ( iid.equals(Components.interfaces.nsIObserver) ||
		     iid.equals(Components.interfaces
				.nsISupportsWeakReference)         ||
		     iid.equals(Components.interfaces.nsISupports))
		return this;
		throw Components.results.NS_NOINTERFACE;
	}	
}

var propObserver =
{
	register: function()
	{
		var prefService = Components.classes["@mozilla.org/preferences-service;1"]
		.getService(Components.interfaces.nsIPrefService);
		this.prefs = prefService.getBranch("extensions.firekeeper.");
		this.prefs.QueryInterface(Components.interfaces
					   .nsIPrefBranch2);
		this.prefs.addObserver("enabled", this, true);
		this.prefs.addObserver("toolbar_icon", this, true);
		this.prefs.addObserver("log_automatically", this, true);
		this.prefs.addObserver("log_enabled", this, true);
		this.prefs.addObserver("blockalerts", this, true);
	},

	unregister: function()
	{
		if(!this.prefs) {
			return;
		}
		this.prefs.removeObserver("enabled", this);
		this.prefs.removeObserver("toolbar_icon", this);
		this.prefs.removeObserver("log_automatically", this);
		this.prefs.removeObserver("log_enabled", this);
		this.prefs.removeObserver("blockalerts", this);
	},
	
	observe: function(aSubject, aTopic, aData)
	{
		if(aTopic != "nsPref:changed"){
			return;
		}

		checkboxSetPref('enable-checkbox', 'enabled');		
		checkboxSetPref('icon-checkbox', 'toolbar_icon');		
		checkboxSetPref('blockalerts-checkbox', 'blockalerts');		
		this.setEnableLog();
		this.setAutoLogFile();
	},
	
	setEnableLog: function()
	{
		var logenabled = this.prefs.getBoolPref('log_enabled');
		
		if (!logenabled){
			checkboxSet('enablelog-checkbox', false);
			disableElement('autosavelog-checkbox');
			disableElement('autosavelog-label');
		}else{
			checkboxSet('enablelog-checkbox', true);
			enableElement('autosavelog-checkbox');
			enableElement('autosavelog-label');
		}
		
	},
	
	setAutoLogFile: function()
	{
		var autolog = this.prefs.getBoolPref('log_automatically');
		var label = document.getElementById('autosavelog-label');
		
		//alert(" setting " + autolog);
		if (!autolog){
			checkboxSet('autosavelog-checkbox', false);
			label.value = "";
		}else{
			checkboxSet('autosavelog-checkbox', true);
			var file = this.prefs.getComplexValue('auto_log_file', Components.interfaces.nsILocalFile);
			label.value = file.path;
		}
	},
	
	QueryInterface: function(iid){
		if ( iid.equals(Components.interfaces.nsIObserver) ||
		     iid.equals(Components.interfaces
				.nsISupportsWeakReference)         ||
		     iid.equals(Components.interfaces.nsISupports))
		return this;
		throw Components.results.NS_NOINTERFACE;
	}	
}

function displayLog()
{
	var listbox = document.getElementById('log-listbox');
	var cnt = listbox.getRowCount();
	var log = judge.getLog({});
	
	for(var i = 0; i < cnt; i++)
		listbox.removeItemAt(0);

	if (log.length)
		enableElement("savelog-button");
	else
		disableElement("savelog-button");
	
	for(i = 0; i < log.length; i++){
		var entry = log[i];
		var item = listbox.appendItem(entry.shortmsg, 0);
		item.setAttribute('id', 'log-listitem');
		item.setAttribute('crop', 'end');
	}
}


function loadState(loading)
{
	if (loading){
		disableElement('fkRulesEdit');
		document.getElementById('loading-label').value = "Loading...";
	}else{
		enableElement('fkRulesEdit');
		document.getElementById('loading-label').value = "";
	}
}

function displaySelectedLogEntry()
{	
	var listbox = document.getElementById('log-listbox');
	if (!listbox.selectedCount){
		//disableElement('details-button');
		return;
	}
	//enableElement('details-button');

	var log = judge.getLog({});
	if (listbox.selectedIndex >= log.length)
		return;
	var entry = log[listbox.selectedIndex];
	
	var options = "chrome,modal=yes,resizable,centerscreen";
	window.openDialog("chrome://firekeeper/content/alert.xul",
			  "_blank", options, 
			  entry.url, entry.rule, null, entry.details); 	

}

function saveLog()
{
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"]
		.createInstance(nsIFilePicker);
	fp.init(window, "Select a file to save log to.", nsIFilePicker.modeSave);
	var res = fp.show();
	if (res == nsIFilePicker.returnOK || res == nsIFilePicker.returnReplace){
		judge.saveLog(fp.file);		
	}
}

function setLogEnabled()
{
	var enable = checkboxVal('enablelog-checkbox');
	var prefs = Components.classes["@mozilla.org/preferences-service;1"]
		.getService(Components.interfaces.nsIPrefService).getBranch("extensions.firekeeper.");	
	
	if (!enable){		
		prefs.setBoolPref("log_enabled", false);
	}else{
		prefs.setBoolPref("log_enabled", true);
	}
	displayLog();
}

function changeSaveAutomatically()
{
	var on = checkboxVal('autosavelog-checkbox');
	var prefs = Components.classes["@mozilla.org/preferences-service;1"]
		.getService(Components.interfaces.nsIPrefService).getBranch("extensions.firekeeper.");	
	
	if (!on){		
		prefs.setBoolPref("log_automatically", false);
		return ;
	}
	
	if (!warning('Warning', "You have chosen to automatically update Firekeeper log file.\n" +
		     "This log contains detailed information about every request that triggered Firekeeper rule\n" +
		     "(request URL, response headers and body).\n" +
		     "Some of this information may be sensitive, private data.\n" +
		     "It is normally not recommended to save it automatically on the disc.")){
		//alert(" offing checkbox");
		prefs.setBoolPref("log_automatically", false);
		propObserver.setAutoLogFile();
		return;
	}
	
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"]
		.createInstance(nsIFilePicker);
	fp.init(window, "Select a file to automatically save log to.", nsIFilePicker.modeSave);
	var res = fp.show();
	if (res != nsIFilePicker.returnOK && res != nsIFilePicker.returnReplace){
		prefs.setBoolPref("log_automatically", false);
		propObserver.setAutoLogFile();
		return;
	}	
	if (!fp.file || !judge.saveLog(fp.file)){
		prefs.setBoolPref("log_automatically", false);
		propObserver.setAutoLogFile();
		return;
	}
	
	prefs.setComplexValue("auto_log_file", Components.interfaces.nsILocalFile, fp.file);
	prefs.setBoolPref("log_automatically", true);
	propObserver.setAutoLogFile();

}

function configInit()
{
	checkboxSetPref('icon-checkbox', 'toolbar_icon');
	checkboxSetPref('blockalerts-checkbox', 'blockalerts');

	try{		
		var enabled = Object();
		getServices();
		firekeeper.isEnabled(enabled);		
		
	}catch(e){
		showElement('error-box');		
		document.getElementById('error-label')
			.setAttribute('value', "Error: " + e);		
		disableElement("fkLoadError");		
		return;
	}
	
	checkboxSet('enable-checkbox', enabled.value);
	
	sourcesObserver.register();
	refreshRulesList();
	document.getElementById('rules-text').srcidx = -1;
	this.loadState(rulesLoader.loadInProgress());
	propObserver.register();	
	propObserver.setAutoLogFile();
	propObserver.setEnableLog();
	displayLog();
}

function refreshRulesList()
{
	var listbox = document.getElementById('sources-listbox');

	var cnt = listbox.getRowCount();
	for(var i = 0; i < cnt; i++)
		listbox.removeItemAt(0);
	
	var sources = rulesLoader.getRulesSources({});
	
	for(i = 0; i < sources.length; i++){
		var source = sources[i];
		var item;

		if (source.remote && source.name != "default"){
			item = listbox.appendItem(source.url, source.name);
		}else
			item = listbox.appendItem(source.name, source.name);
		
		if (source.remote && source.backupAvailable){
			item.setAttribute('tooltiptext', source.url + 
					  " document not available" +
					  " local backup used");
		}
		else
			item.setAttribute('tooltiptext', source.url);
		
		item.setAttribute('id', 'source-listitem');
		item.setAttribute('crop', 'end');
		
		if (source.disabled){
			item.setAttribute('status', 'disabled');
		}
		else if (source.loadError)
			item.setAttribute('status', 'error');
		else if (source.parsingError){
			item.setAttribute('status', 'parse-error');
		}
		else {
			item.setAttribute('status', 'ok');
		}
	}
	displaySelectedSource();
}

function addLocalSource()
{
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"]
		.createInstance(nsIFilePicker);
	fp.init(window, "Select a File", nsIFilePicker.modeOpen);
	var res = fp.show();
	if (res == nsIFilePicker.returnOK){
		var file = fp.file;
		rulesLoader.addLocalSource(file);
	}
}

function addRemoteSource()
{
	window.openDialog('chrome://firekeeper/content/addremotesource.xul', 
			  '_blank', 
			  'chrome,resizable,extrachrome,scrollbars,status,toolbar,centerscreen', 
			  rulesLoader);
}

function enableSource()
{
	var listbox = document.getElementById('sources-listbox');
	if (!listbox.selectedCount)
		return;
	rulesLoader.enableSource(listbox.selectedIndex);

	disableElement('enablesource-button');
	disableElement('disablesource-button');
}

function disableSource()
{
	var listbox = document.getElementById('sources-listbox');
	if (!listbox.selectedCount)
		return;
	rulesLoader.disableSource(listbox.selectedIndex);

	disableElement('enablesource-button');
	disableElement('disablesource-button');
}

function removeSource()
{
	var listbox = document.getElementById('sources-listbox');
	if (!listbox.selectedCount)
		return;
	rulesLoader.removeSource(listbox.selectedIndex);
}

function disableRulesEdit()
{
	disableElement('savesource-button');
	document.getElementById('savesource-button').
		setAttribute('tooltiptext', 'Can\'t modify selected file');	
	//document.getElementById('rules-text').
	//setAttribute('readonly', 'true');
}
         
function enableRulesEdit()
{
	enableElement('savesource-button');
	document.getElementById('savesource-button').
		setAttribute('tooltiptext', 'Save changes');	
	//document.getElementById('rules-text').
	//setAttribute('readonly', 'false');
}


function displaySource(idx)
{
	var sources = rulesLoader.getRulesSources({});
	if (0 > idx || idx >= sources.length){
		return;
	}
	document.getElementById('rules-text').srcidx = idx;
	
	var source = sources[idx];
	if (source.loadError || source.remote || source.disabled){
		disableRulesEdit();
	}else
		enableRulesEdit();
	
	var enbut = document.getElementById('enablesource-button');
	var disbut = document.getElementById('disablesource-button');
	var rembut = document.getElementById('removesource-button');
	var text = document.getElementById('rules-text');
	
	if (source.disabled){
		if (source.name == "default" || !source.remote)
			text.value = source.name + " file is disabled.\n";
		else
			text.value = "Remote file " + source.url + " is disabled.\n";
		text.value +="To enable and load rules from this file click [enable] button.";
		
		disbut.setAttribute('disabled', 'true');
		enbut.setAttribute('disabled', 'false');
	}else{
		disbut.setAttribute('disabled', 'false');
		enbut.setAttribute('disabled', 'true');
		
		if (source.loadError && !source.backupAvailable){
			text.value =  source.loadError;
			text.setAttribute('status', 'error');
		}
		else{
			if (source.remote){
				text.setAttribute('status', 'ok-remote');
				if (source.backupAvailable)
					/*TODO: write some info*/;
			}
			else{
				text.setAttribute('status', 'ok-local');
			}
			text.value = source.rules;
		}
	}
	document.getElementById('parsingerror-text').value = source.parsingError;	

	if (source.name == "blacklist" || source.name == "whitelist" || source.name == "default" || 
	    source.name == "experimental" || source.name == "new_threats" || source.name == "xss" ||
	    source.name == "malware"){
		rembut.setAttribute('disabled', 'true');	
		rembut.setAttribute('tooltiptext', 'Default files can only be disabled.');
	}		
	else{
		rembut.setAttribute('disabled', 'false');	
		rembut.setAttribute('tooltiptext', 
				    'Removes file from Firekeeper not from disc.');	
	}
}

function displaySelectedSource()
{	
	var listbox = document.getElementById('sources-listbox');
	if (!listbox.selectedCount){
		return;
	}
	displaySource(listbox.selectedIndex);	

}

function changeBoolPref(pref, val)
{
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService);	
	
	prefs = prefs.getBranch("extensions.firekeeper.");
	if (val)
		prefs.setBoolPref(pref, true);
	else
		prefs.setBoolPref(pref, false);
}   

function changeEnable()
{	
	var enable = document.getElementById('enable-checkbox').
		getAttribute('checked');
	try{
		firekeeper.enable(enable);
		changeBoolPref('enabled', enable);	
	}catch(e){}
	
}

function changeBlockAlerts()
{
	var enable = document.getElementById('blockalerts-checkbox').
		getAttribute('checked');
	changeBoolPref("blockalerts", enable);	
}

function changeToolbarIcon()
{	
	var enable = document.getElementById('icon-checkbox').
		getAttribute('checked');
	changeBoolPref("toolbar_icon", enable);	
}

function reloadSources()
{
	rulesLoader.reloadAllSources();
}

function saveSource()
{
	var idx = document.getElementById('rules-text').srcidx;
	if (idx < 0){
		return;
	}
	rulesLoader.changeLocalSource(idx, document
				      .getElementById('rules-text').value);
	displaySource(idx);
}
