/*$Id: FirekeeperModule.cpp,v 1.8 2006/08/20 16:39:54 jwrobel Exp $*/

/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "Firekeeper.h"

#include "fkHttpHandler.h"

#include "nsCOMPtr.h"
#include "nsMemory.h"

#include "nsIModule.h"
#include "nsIFactory.h"
#include "nsIComponentManager.h"
#include "nsICategoryManager.h"
#include "nsIServiceManager.h"
#include "nsIComponentRegistrar.h"

#include "nsIGenericFactory.h" 
#include "Error.h"

#define NS_CATEGORYMANAGER_CONTRACTID "@mozilla.org/categorymanager;1"

static NS_METHOD FirekeeperRegistration(nsIComponentManager *aCompMgr,
					nsIFile *aPath,
					const char *registryLocation,
					const char *componentType,
					const nsModuleComponentInfo *info)
{
	nsresult rv;
	TRACE("Firekeeper registration");
	nsCOMPtr<nsIServiceManager> servman = do_QueryInterface((nsISupports*)aCompMgr, &rv);
	if (NS_FAILED(rv)){
		TRACE("can't get service manager");
		return rv;
	}

	nsCOMPtr<nsICategoryManager> catman;
	rv = servman->GetServiceByContractID(NS_CATEGORYMANAGER_CONTRACTID,
					     NS_GET_IID(nsICategoryManager),
					     getter_AddRefs(catman));
	
	if (NS_FAILED(rv))
		return rv;
	
	rv = catman->AddCategoryEntry("app-startup",
				      "Firekeeper,service",
				      FIREKEEPER_CONTRACTID,
				      PR_TRUE, PR_TRUE, nsnull);	
	
	
	if (NS_FAILED(rv))
		TRACE("AddCategoryEntry failed");
	return rv;

}

static NS_METHOD FirekeeperUnregistration(nsIComponentManager *aCompMgr,
					  nsIFile *aPath,
					  const char *registryLocation,
					  const nsModuleComponentInfo *info)
{
	TRACE("Firekeeper unregistration called");
	nsresult rv;
	nsCOMPtr<nsIServiceManager> servman = do_QueryInterface((nsISupports*)aCompMgr, &rv);
	if (NS_FAILED(rv))
		return rv;
	

	nsCOMPtr<nsICategoryManager> catman;
	rv = servman->GetServiceByContractID(NS_CATEGORYMANAGER_CONTRACTID,
					     NS_GET_IID(nsICategoryManager),
					     getter_AddRefs(catman));

	if (NS_FAILED(rv))
		return rv;
	
	rv = catman->DeleteCategoryEntry("app-startup",
					 "Firekeeper,service",
					 PR_TRUE);

	return rv;
}


NS_GENERIC_FACTORY_SINGLETON_CONSTRUCTOR(Firekeeper, Firekeeper::GetInstance)

 


static const nsModuleComponentInfo components[] = 
{ 
	{ 
		"Firekeeper extension",  
		FIREKEEPER_CID,
		FIREKEEPER_CONTRACTID,
		FirekeeperConstructor,
		FirekeeperRegistration,
		FirekeeperUnregistration
	}
#if 0
	//This is another way to replace HTTP handler.
	{
		"Firekeeper Http Handler",
		FK_HTTPHANDLER_CID,
		HTTPHANDLER_CONTRACTID,
		fkHttpHandlerConstructor
	}
#endif	 
}; 

NS_IMPL_NSGETMODULE(FirekeeperModule, components) 
 
	
