/*$Id: Error.h,v 1.16 2007/08/17 21:33:16 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef ERROR_H
#define ERROR_H 

#include "Common.h"

/*error reporting/debugging routines, similar to these introduced
  by Richard Stevens in his "Advanced Programming in the Unix Environment"*/

void err_ret(const char *fmt, ...);
void err_msg(const char *fmt, ...);
void err_sys(const char *fmt, ...);
void err_quit(const char *fmt, ...);


void stderr_print(const char *fmt, ...);
void trace_func(const char *funcname,  const char *fmt, ...);
void trace_func_windows(const char *fmt, ...);

#ifdef DEBUG



#ifndef MSVC

//char trace_buf[64]; 
//snprintf(trace_buf, 64, ":%s:", __func__); 

#define TRACE(x...) do{\
        trace_func(__func__,  x);\
	}while(0)



#else /*MSVC*/

extern const char *__funcname;

#define TRACE __funcname = __FUNCTION__, trace_func_windows


#endif /*MSVC*/

#define FK_ASSERT(x) do{ if (!(x)){ TRACE("ASSERTion %s in file %s line %d failed. Press enter", #x, __FILE__, __LINE__); char c; scanf("%c", &c); exit(1);};} while(0)

#else  /*DEBUG*/

#ifndef MSVC
#define TRACE(x...)  
#define FK_ASSERT(x)
#else /*MSVC*/
#define TRACE  
#define FK_ASSERT 
#endif /*MSVC*/


#endif /*DEBUG*/

#endif /*ERROR_H*/
