/*$Id: fkHttpHandler.cpp,v 1.23 2007/03/15 23:34:47 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

/* to make NS_IMPL_THREADSAFE_ISUPPORTS* work*/
#ifdef MOZILLA_STRICT_API
#undef MOZILLA_STRICT_API
#endif

#ifdef XPCOM_GLUE
#undef XPCOM_GLUE
#endif

#include "nsISupportsImpl.h"
#define MOZILLA_STRICT_API
#define XPCOM_GLUE


#include "nsCOMPtr.h"
#include "nsXPCOM.h"
#include "nsMemory.h"
#include "nsStringAPI.h"
#include "nsEmbedString.h"

#include "nsIServiceManager.h"
#include "nsICategoryManager.h"
#include "nsIURI.h"

#include "fkHttpHandler.h"
#include "fkHttpChannel.h"
#include "Firekeeper.h"
#include "fkSentence.h"
#include "fkRule.h"

#include "Error.h"
#include "Common.h"
#include "ActiveRuleSet.h"


fkHttpHandler::fkHttpHandler()
{   
	TRACE("constructor %08x", this);
	tracingEnabled = PR_FALSE;
}   

fkHttpHandler::~fkHttpHandler()   
{   
	TRACE("destructor %08x", this);
}

NS_IMETHODIMP
fkHttpHandler::init(nsIHttpProtocolHandler *origHttpHandler)
{
	nsresult rv;
	this->origHttpHandler = origHttpHandler;
	
	origProxiedHandler = do_QueryInterface(origHttpHandler, &rv); 
	if (NS_FAILED(rv))
		return rv;
	
	origHandler = do_QueryInterface(origHttpHandler, &rv); 
	if (NS_FAILED(rv))
		return rv;
	
	/*https handler doesn't implement this*/
	origObserver = do_QueryInterface(origHttpHandler, &rv);	
	
	tracingEnabled = PR_TRUE;
	return NS_OK;
}

//-----------------------------------------------------------------------------
// fkHttpHandler::nsISupports
//-----------------------------------------------------------------------------

/*NS_IMPL_ISUPPORTS5(fkHttpHandler, nsIObserver, 
		   nsIHttpProtocolHandler,
		   nsIProtocolHandler, 
		   nsIProxiedProtocolHandler, 
		   nsISupportsWeakReference
		   );*/
NS_IMPL_THREADSAFE_ISUPPORTS5(fkHttpHandler, nsIObserver,
			      nsIHttpProtocolHandler,
			      nsIProtocolHandler,                         
			      nsIProxiedProtocolHandler,
			      nsISupportsWeakReference)

//-----------------------------------------------------------------------------
// fkHttpHandler::public methods
//-----------------------------------------------------------------------------
PRBool fkHttpHandler::isTracingEnabled()
{
	return this->tracingEnabled;
}

void fkHttpHandler::enableTracing(PRBool tracingEnabled)
{
	TRACE("");
	this->tracingEnabled = tracingEnabled;
}

//-----------------------------------------------------------------------------
// fkHttpHandler::nsIProtocolHandler
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpHandler::GetScheme(nsACString &aScheme)
{
	return origHandler->GetScheme(aScheme);
}

NS_IMETHODIMP
fkHttpHandler::GetDefaultPort(PRInt32 *result)
{
	return origHandler->GetDefaultPort(result);
}

NS_IMETHODIMP
fkHttpHandler::GetProtocolFlags(PRUint32 *result)
{
	return origHandler->GetProtocolFlags(result);
}

NS_IMETHODIMP
fkHttpHandler::NewURI(const nsACString &aSpec,
                      const char *aCharset,
                      nsIURI *aBaseURI,
                      nsIURI **aURI)
{	
	return origHandler->NewURI(aSpec, aCharset, aBaseURI, aURI);
}

NS_IMETHODIMP
fkHttpHandler::NewChannel(nsIURI *uri, nsIChannel **result)
{
	TRACE("no proxy");
	/*Create ProxiedChannel without proxy*/
	return this->NewProxiedChannel(uri, nsnull, result);
}

NS_IMETHODIMP 
fkHttpHandler::AllowPort(PRInt32 port, const char *scheme, PRBool *_retval)
{

	return origHandler->AllowPort(port, scheme, _retval);
}

//-----------------------------------------------------------------------------
// fkHttpHandler::nsIProxiedProtocolHandler
//-----------------------------------------------------------------------------

/*
  If Firekeeper is enabled, check if URL of new channel doesn't break any
  rules. If no, create new fkHttpChannel to trace data downloaded through 
  this new channel.
 */
NS_IMETHODIMP
fkHttpHandler::NewProxiedChannel(nsIURI *uri,
                                 nsIProxyInfo* givenProxyInfo,
                                 nsIChannel **result)
{
	nsresult rv;	
	nsEmbedCString s;
	TRACE("proxy info = %08x", givenProxyInfo);
	if (!tracingEnabled || fkJudge == nsnull){
		TRACE("not tracing new channel");
		return origProxiedHandler->NewProxiedChannel(uri, 
							     givenProxyInfo,
							     result);
	}
	
	fkSentence *sentence_raw = new fkSentence();
	if (!sentence_raw){
		return NS_ERROR_OUT_OF_MEMORY;
	}
	nsCOMPtr<fkISentence> 
		sentence(do_QueryInterface(sentence_raw));
	

	/*
	  Check URL after canonicalization eg. http://www.something.com/hehe/
	  instead of http://www.something.com:80/hehe/hehe/..
	*/
	uri->GetSpec(s);
	const char *url = s.get();
	TRACE("%s", url);
	
	/*Create new ActiveRuleSet for use only by this channel*/
	ActiveRuleSet *connRules = new ActiveRuleSet(rules);
	if (!connRules)
		return NS_ERROR_OUT_OF_MEMORY;

	list<const Rule *> match = connRules->checkURL(url, strlen(url));
	list<const Rule *>::iterator it;
	for(it = match.begin(); it != match.end(); ++it){
		fkRule *rule_raw = new fkRule(*it);
		if (!rule_raw){
			return NS_ERROR_OUT_OF_MEMORY;
		}
		nsCOMPtr<fkIRule> 
			rule(do_QueryInterface(rule_raw));
		fkJudge->Judge(url, rule, sentence);		
		int action;
		sentence->GetAction(&action);
		TRACE("action = %d", action);
		if (action == sentence->BLOCK){
			TRACE("aborting request");
			return NS_ERROR_ABORT;
		}
		else if (action == sentence->DONT_AUDIT){
			TRACE("passing request");
			break;
		}
		/*else (action == sentence->AUDIT) continue with remaining
		  rules*/
	}

	/*Create new Mozilla's channel*/
	nsCOMPtr<nsIChannel> origChannel;
	rv = origProxiedHandler->NewProxiedChannel(uri, givenProxyInfo, 
						   getter_AddRefs(origChannel)
						   );
	if (NS_FAILED(rv)){
		TRACE("failed");
		return rv;
	}

	/*Create new Firekeeper's channel that will pass traffic to Mozilla's 
	  channel after checking it*/
	fkHttpChannel *fkChannel = 
		new fkHttpChannel(origChannel, sentence, connRules);
	if (!fkChannel){
		*result = NULL;
		return NS_ERROR_OUT_OF_MEMORY;
	}
	NS_ADDREF(fkChannel);	

	/*TODO: NULL pointer check*/
	*result = fkChannel;

	return NS_OK;
}

//-----------------------------------------------------------------------------
// fkHttpHandler::nsIHttpProtocolHandler
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpHandler::GetUserAgent(nsACString &value)
{
	return origHttpHandler->GetUserAgent(value);
}

NS_IMETHODIMP
fkHttpHandler::GetAppName(nsACString &value)
{
	return origHttpHandler->GetAppName(value);
}

NS_IMETHODIMP
fkHttpHandler::GetAppVersion(nsACString &value)
{
	return origHttpHandler->GetAppVersion(value);
}

NS_IMETHODIMP
fkHttpHandler::GetVendor(nsACString &value)
{
	return origHttpHandler->GetVendor(value);
}
NS_IMETHODIMP
fkHttpHandler::SetVendor(const nsACString &value)
{
	return origHttpHandler->SetVendor(value);
}

NS_IMETHODIMP
fkHttpHandler::GetVendorSub(nsACString &value)
{
	return origHttpHandler->GetVendorSub(value);
}

NS_IMETHODIMP
fkHttpHandler::SetVendorSub(const nsACString &value)
{
	return origHttpHandler->SetVendorSub(value);
}

NS_IMETHODIMP
fkHttpHandler::GetVendorComment(nsACString &value)
{
	return origHttpHandler->GetVendorComment(value);
}

NS_IMETHODIMP
fkHttpHandler::SetVendorComment(const nsACString &value)
{
	return origHttpHandler->SetVendorComment(value);
}

NS_IMETHODIMP
fkHttpHandler::GetProduct(nsACString &value)
{
	return origHttpHandler->GetProduct(value);
}

NS_IMETHODIMP
fkHttpHandler::SetProduct(const nsACString &value)
{
	return origHttpHandler->SetProduct(value);
}

NS_IMETHODIMP
fkHttpHandler::GetProductSub(nsACString &value)
{
	return origHttpHandler->GetProductSub(value);
}

NS_IMETHODIMP
fkHttpHandler::SetProductSub(const nsACString &value)
{
	return origHttpHandler->SetProductSub(value);
}

NS_IMETHODIMP
fkHttpHandler::GetProductComment(nsACString &value)
{
	return origHttpHandler->GetProductComment(value);
}

NS_IMETHODIMP
fkHttpHandler::SetProductComment(const nsACString &value)
{
	return origHttpHandler->SetProductComment(value);
}

NS_IMETHODIMP
fkHttpHandler::GetPlatform(nsACString &value)
{
	return origHttpHandler->GetPlatform(value);
}

NS_IMETHODIMP
fkHttpHandler::GetOscpu(nsACString &value)
{
	return origHttpHandler->GetOscpu(value);
}

NS_IMETHODIMP
fkHttpHandler::GetLanguage(nsACString &value)
{
	return origHttpHandler->GetLanguage(value);
}

NS_IMETHODIMP
fkHttpHandler::SetLanguage(const nsACString &value)
{
	return origHttpHandler->SetLanguage(value);
}

NS_IMETHODIMP
fkHttpHandler::GetMisc(nsACString &value)
{
	return origHttpHandler->GetMisc(value);
}

NS_IMETHODIMP
fkHttpHandler::SetMisc(const nsACString &value)
{
	return origHttpHandler->SetMisc(value);
}

//-----------------------------------------------------------------------------
// fkHttpHandler::nsIObserver
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpHandler::Observe(nsISupports *subject,
                       const char *topic,
                       const PRUnichar *data)
{
	if (origObserver)
		return origObserver->Observe(subject, topic, data);
	
	return NS_ERROR_NOT_IMPLEMENTED;
}


