unit PrefsForm;
{PrefsForm unit for GeckoBrowser-D4, contains preferences dialog + methods}
{v1.0 Written by Dave Murray <irongut@vodafone.net>, October - November 2003}
{v1.1 for Delphi 4 Written by Dave Murray, Febuary 2004}
{v1.2 for Delphi 4 Written by Dave Murray, October 2004}
{GeckoBrowser v1.2 was written using Mozilla ActiveX Control v1.7.1}

(* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is GeckoBrowser framework for Delphi 4.
 *
 * The Initial Developer of the Original Code is
 * Conspiracy Software.
 * Portions created by the Initial Developer are Copyright (C) 2003 - 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Dave Murray <irongut@vodafone.net>
 *   Sterling Bates <sblistserv@bigbangco.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** *)


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TfrmPrefs = class(TForm)
    rdgrpStartPage: TRadioGroup;
    grpbxCustomStartPage: TGroupBox;
      spdbtnChooseStartFile: TSpeedButton;
    grpbxHomePage: TGroupBox;
      spdbtnChooseHomeFile: TSpeedButton;
    grpbxButtons: TGroupBox;
      btnOk: TBitBtn;
      btnCancel: TBitBtn;
    dlgOpen: TOpenDialog;
    lblStart: TLabel;
    lblHome: TLabel;
    edtCustomStartPage: TEdit;
    edtHomePage: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure rdgrpStartPageClick(Sender: TObject);
    procedure spdbtnChooseFileClick(Sender: TObject);
  private
    { Private declarations }
    procedure EnableCustomStartPage(const EnableSP : boolean);
  public
    { Public declarations }
  end;

var
  frmPrefs: TfrmPrefs;

implementation

{$R *.dfm}

uses Globals;

procedure TfrmPrefs.FormCreate(Sender: TObject);
{initialise}
begin
  {setup controls}
  rdgrpStartPage.ItemIndex := START_TYPE;
  EnableCustomStartPage(START_TYPE = 2);
  edtCustomStartPage.Text := START_ADDRESS;
  edtHomePage.Text := HOME_ADDRESS;
end; {procedure TfrmPrefs.FormCreate}

procedure TfrmPrefs.FormClose(Sender: TObject; var Action: TCloseAction);
{keep settings if OK clicked}
begin
  if (Self.ModalResult = mrOk) then begin
    {store settings}
    START_TYPE := rdgrpStartPage.ItemIndex;
    START_ADDRESS := edtCustomStartPage.Text;
    HOME_ADDRESS := edtHomePage.Text;
    end; {if Self = mrOk..}
end; {procedure TfrmPrefs.FormClose}

procedure TfrmPrefs.rdgrpStartPageClick(Sender: TObject);
{enable grpbxCustomStartPage if Custom clicked}
begin
  EnableCustomStartPage(rdgrpStartPage.ItemIndex = 2);
end; {procedure TfrmPrefs.rdgrpStartPageClick}

procedure TfrmPrefs.spdbtnChooseFileClick(Sender: TObject);
{show open file dialog + update URL if successful for both speedbuttons}
begin
  dlgOpen.FileName := '';
  if not(dlgOpen.Execute) then Exit;
  {update relevant edit box}
  if (Sender = spdbtnChooseStartFile) then
    edtCustomStartPage.Text := 'file:///' + dlgOpen.FileName
  else edtHomePage.Text := 'file:///' + dlgOpen.FileName;
end; {procedure TfrmPrefs.spdbtnChooseFileClick}


{### PRIVATE METHODS ###}


procedure TfrmPrefs.EnableCustomStartPage(const EnableSP: boolean);
{enables / disables grpbxCustomStartPage + controls}
begin
  grpbxCustomStartPage.Enabled := EnableSP;
  edtCustomStartPage.Enabled := EnableSP;
  spdbtnChooseStartFile.Enabled := EnableSP;
end; {procedure TfrmPrefs.EnableCustomStartPage}

end.
