/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class AutomatedInstaller
extends InstallerBase {
    private TreeMap panelInstanceCount;
    private AutomatedInstallData idata = new AutomatedInstallData();
    private boolean result = false;

    public AutomatedInstaller(String inputFilename) throws Exception {
        File input = new File(inputFilename);
        this.loadInstallData(this.idata);
        this.idata.xmlData = this.getXMLData(input);
        this.idata.localeISO3 = this.idata.xmlData.getAttribute("langpack", "eng");
        InputStream in = this.getClass().getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        this.idata.langpack = new LocaleDatabase(in);
        this.idata.setVariable("ISO3_LANG", this.idata.localeISO3);
        ResourceManager.create(this.idata);
        this.addCustomLangpack(this.idata);
        this.panelInstanceCount = new TreeMap();
    }

    private boolean writeUninstallData() {
        try {
            UninstallData udata = UninstallData.getInstance();
            List files = udata.getFilesList();
            ZipOutputStream outJar = this.idata.uninstallOutJar;
            if (outJar == null) {
                return true;
            }
            System.out.println("[ Writing the uninstaller data ... ]");
            outJar.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(this.idata.getInstallPath());
            logWriter.newLine();
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                logWriter.write((String)iter.next());
                if (!iter.hasNext()) continue;
                logWriter.newLine();
            }
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("jarlocation.log"));
            logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(udata.getUninstallerJarFilename());
            logWriter.newLine();
            logWriter.write(udata.getUninstallerPath());
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream execStream = new ObjectOutputStream(outJar);
            iter = udata.getExecutablesList().iterator();
            execStream.writeInt(udata.getExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
            execStream.flush();
            outJar.closeEntry();
            outJar.flush();
            outJar.close();
            return true;
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doInstall() throws Exception {
        System.out.println("[ Starting automated installation ]");
        Debug.log("[ Starting automated installation ]");
        try {
            this.result = true;
            panelsIterator = this.idata.panelsOrder.iterator();
lbl6:
            // 7 sources

            while (panelsIterator.hasNext()) {
                p = (Panel)panelsIterator.next();
                praefix = "com.izforge.izpack.panels.";
                if (p.className.compareTo(".") > -1) {
                    praefix = "";
                }
                if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
                panelClassName = p.className;
                automationHelperClassName = praefix + panelClassName + "AutomationHelper";
                automationHelperClass = null;
                Debug.log("AutomationHelper:" + automationHelperClassName);
                try {
                    automationHelperClass = Class.forName(automationHelperClassName);
                }
                catch (ClassNotFoundException e) {
                    Debug.log("ClassNotFoundException-skip :" + automationHelperClassName);
                    continue;
                }
                automationHelperInstance = null;
                if (automationHelperClass != null) {
                    try {
                        Debug.log("Instantiate :" + automationHelperClassName);
                        automationHelperInstance = (PanelAutomation)automationHelperClass.newInstance();
                    }
                    catch (Exception e) {
                        Debug.log("ERROR: no default constructor for " + automationHelperClassName + ", skipping...");
                        continue;
                    }
                }
                panelRoots = this.idata.xmlData.getChildrenNamed(panelClassName);
                panelRootNo = 0;
                if (this.panelInstanceCount.containsKey(panelClassName)) {
                    panelRootNo = (Integer)this.panelInstanceCount.get(panelClassName);
                }
                panelRoot = (XMLElement)panelRoots.elementAt(panelRootNo);
                this.panelInstanceCount.put(panelClassName, new Integer(panelRootNo + 1));
                if (automationHelperInstance == null) continue;
                try {
                    Debug.log("automationHelperInstance.runAutomated :" + automationHelperClassName + " entered.");
                    if (automationHelperInstance.runAutomated(this.idata, panelRoot)) ** GOTO lbl-1000
                    this.result = false;
                    ** GOTO lbl60
                }
                catch (Exception e) {
                    Debug.log("ERROR: automated installation failed for panel " + panelClassName);
                    e.printStackTrace();
                    this.result = false;
                }
            }
            ** GOTO lbl64
        }
        catch (Exception e) {
            try {
                this.result = false;
                System.err.println(e.toString());
                e.printStackTrace();
                System.out.println("[ Automated installation FAILED! ]");
            }
            catch (Throwable var12_15) {
                Housekeeper.getInstance().shutDown(this.result != false ? 0 : 1);
                throw var12_15;
            }
lbl60:
            // 1 sources

            Housekeeper.getInstance().shutDown(this.result != false ? 0 : 1);
            return;
lbl-1000:
            // 1 sources

            {
                Debug.log("automationHelperInstance.runAutomated :" + automationHelperClassName + " successfully done.");
            }
            ** GOTO lbl6
lbl64:
            // 1 sources

            this.writeUninstallData();
            if (this.result) {
                System.out.println("[ Automated installation done ]");
            } else {
                System.out.println("[ Automated installation FAILED! ]");
            }
            Housekeeper.getInstance().shutDown(this.result != false ? 0 : 1);
            return;
            Housekeeper.getInstance().shutDown(this.result != false ? 0 : 1);
            return;
        }
    }

    public XMLElement getXMLData(File input) throws Exception {
        FileInputStream in = new FileInputStream(input);
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(new StdXMLBuilder());
        parser.setReader(new StdXMLReader(in));
        parser.setValidator(new NonValidator());
        XMLElement rtn = (XMLElement)parser.parse();
        in.close();
        return rtn;
    }

    public boolean getResult() {
        return this.result;
    }
}

