/* 
   This file is public domain.

   The data is a matter of public record, and comes from
   http://sqlzoo.net/   
 */


SET search_path TO sqltutor;

--- createmovie, 1, 50
DROP TABLE casting;
DROP TABLE movie;
DROP TABLE actor;

CREATE TABLE actor
(id INTEGER NOT NULL
, name VARCHAR(35)
, PRIMARY KEY (id)
);
CREATE INDEX actor_name ON actor(name);
CREATE TABLE movie
(id INTEGER NOT NULL
, title VARCHAR(80)
, year DECIMAL(4) 
, score FLOAT
, votes INTEGER
, director INTEGER
, PRIMARY KEY (id)
, FOREIGN KEY (director) REFERENCES actor(id)
);
CREATE INDEX movie_title ON movie(title);
CREATE TABLE casting (movieid INTEGER NOT NULL
, actorid INTEGER NOT NULL
, ord INTEGER
, PRIMARY KEY (movieid, actorid)
, FOREIGN KEY (movieid) REFERENCES movie(id)
, FOREIGN KEY (actorid) REFERENCES actor(id)
);

CREATE INDEX casting_movie ON casting(movieid);
CREATE INDEX casting_actor ON casting(actorid);
CREATE INDEX casting_ord   ON casting(ord);

BEGIN;

--- tabactor, 1, 50
insert into actor values (1,'Woody Allen');
insert into actor values (2,'Clint Eastwood');
insert into actor values (3,'Robert De Niro');
insert into actor values (4,'Sean Connery');
insert into actor values (5,'Sylvester Stallone');
insert into actor values (6,'Harrison Ford');
insert into actor values (7,'Robin Williams');
insert into actor values (8,'Tom Hanks');
insert into actor values (9,'Arnold Schwarzenegger');
insert into actor values (10,'Kevin Costner');
insert into actor values (11,'Alfred Hitchcock');
insert into actor values (12,'Al Pacino');
insert into actor values (13,'Bruce Willis');
insert into actor values (14,'Steve Martin');
insert into actor values (15,'Dan Aykroyd');
insert into actor values (16,'Gene Hackman');
insert into actor values (17,'Nicolas Cage');
insert into actor values (18,'Steven Spielberg');
insert into actor values (19,'Tom Cruise');
insert into actor values (20,'Michael Douglas');
insert into actor values (21,'Ron Howard');
insert into actor values (22,'Mel Gibson');
insert into actor values (23,'John Carpenter');
insert into actor values (24,'Danny DeVito');
insert into actor values (25,'Tim Robbins');
insert into actor values (26,'Johnny Depp');
insert into actor values (27,'Dustin Hoffman');
insert into actor values (28,'Francis Ford Coppola');
insert into actor values (29,'Mel Brooks');
insert into actor values (30,'Kurt Russell');
insert into actor values (31,'Brian De Palma');
insert into actor values (32,'John Cusack');
insert into actor values (33,'Eddie Murphy');
insert into actor values (34,'John Travolta');
insert into actor values (35,'Jeff Bridges');
insert into actor values (36,'Robert Redford');
insert into actor values (37,'Rob Reiner');
insert into actor values (38,'Barry Levinson');
insert into actor values (39,'Anthony Hopkins');
insert into actor values (40,'Julia Roberts');
insert into actor values (41,'Denzel Washington');
insert into actor values (42,'Paul Newman');
insert into actor values (43,'Jack Nicholson');
insert into actor values (44,'Robert Duvall');
insert into actor values (45,'Michelle Pfeiffer');
insert into actor values (46,'Kevin Bacon');
insert into actor values (47,'Mike Nichols');
insert into actor values (48,'Kenneth Branagh');
insert into actor values (49,'Wesley Snipes');
insert into actor values (50,'Matthew Broderick');
--- tabactor, 51, 50
insert into actor values (51,'Dennis Quaid');
insert into actor values (52,'Michael Keaton');
insert into actor values (53,'Keanu Reeves');
insert into actor values (54,'Sigourney Weaver');
insert into actor values (55,'Chevy Chase');
insert into actor values (56,'Val Kilmer');
insert into actor values (57,'Meg Ryan');
insert into actor values (58,'Charlie Sheen');
insert into actor values (59,'Terry Gilliam');
insert into actor values (60,'Warren Beatty');
insert into actor values (61,'Kevin Kline');
insert into actor values (62,'John Landis');
insert into actor values (63,'Meryl Streep');
insert into actor values (64,'Demi Moore');
insert into actor values (65,'Blake Edwards');
insert into actor values (66,'John Badham');
insert into actor values (67,'Robert Zemeckis');
insert into actor values (68,'Alan Parker');
insert into actor values (69,'Oliver Stone');
insert into actor values (70,'Michael J. Fox');
insert into actor values (71,'Robert Downey Jr.');
insert into actor values (72,'Bill Murray');
insert into actor values (73,'Harvey Keitel');
insert into actor values (74,'Richard Gere');
insert into actor values (75,'Cary Grant');
insert into actor values (76,'Kevin Spacey');
insert into actor values (77,'Richard Dreyfuss');
insert into actor values (78,'Martin Scorsese');
insert into actor values (79,'Billy Wilder');
insert into actor values (80,'Sidney Lumet');
insert into actor values (81,'Norman Jewison');
insert into actor values (82,'Stanley Kubrick');
insert into actor values (83,'Michael Caine');
insert into actor values (84,'Sandra Bullock');
insert into actor values (85,'Marlon Brando');
insert into actor values (86,'Peter Weir');
insert into actor values (87,'Lawrence Kasdan');
insert into actor values (88,'Christian Slater');
insert into actor values (89,'Samuel L. Jackson');
insert into actor values (90,'Roman Polanski');
insert into actor values (91,'Morgan Freeman');
insert into actor values (92,'Sydney Pollack');
insert into actor values (93,'Sean Penn');
insert into actor values (94,'Diane Keaton');
insert into actor values (95,'Hugh Grant');
insert into actor values (96,'William Hurt');
insert into actor values (97,'David Cronenberg');
insert into actor values (98,'Gary Oldman');
insert into actor values (99,'Christopher Walken');
insert into actor values (100,'Liam Neeson');
--- tabactor, 101, 50
insert into actor values (101,'Nick Nolte');
insert into actor values (102,'Bill Pullman');
insert into actor values (103,'Peter Hyams');
insert into actor values (104,'Glenn Close');
insert into actor values (105,'Joel Schumacher');
insert into actor values (106,'Jack Lemmon');
insert into actor values (107,'Tony Scott');
insert into actor values (108,'Harold Ramis');
insert into actor values (109,'Ivan Reitman');
insert into actor values (110,'Ridley Scott');
insert into actor values (111,'Joel Coen');
insert into actor values (112,'Susan Sarandon');
insert into actor values (113,'James Woods');
insert into actor values (114,'Alec Baldwin');
insert into actor values (115,'Peter Sellers');
insert into actor values (116,'Winona Ryder');
insert into actor values (117,'Jackie Chan');
insert into actor values (118,'James Stewart');
insert into actor values (119,'Tommy Lee Jones');
insert into actor values (120,'Steve Guttenberg');
insert into actor values (121,'Leslie Nielsen');
insert into actor values (122,'Brendan Fraser');
insert into actor values (123,'Frank Oz');
insert into actor values (124,'Drew Barrymore');
insert into actor values (125,'Dennis Hopper');
insert into actor values (126,'Jim Carrey');
insert into actor values (127,'Jack Warden');
insert into actor values (128,'William Shatner');
insert into actor values (129,'Garry Marshall');
insert into actor values (130,'Bill Paxton');
insert into actor values (131,'Emilio Estevez');
insert into actor values (132,'Walter Matthau');
insert into actor values (133,'Wes Craven');
insert into actor values (134,'Christopher Lloyd');
insert into actor values (135,'Donald Sutherland');
insert into actor values (136,'Sharon Stone');
insert into actor values (137,'Jean-Claude Van Damme');
insert into actor values (138,'George Clooney');
insert into actor values (139,'David Lynch');
insert into actor values (140,'Wolfgang Petersen');
insert into actor values (141,'Sam Raimi');
insert into actor values (142,'Jamie Lee Curtis');
insert into actor values (143,'Walter Hill');
insert into actor values (144,'John Hughes');
insert into actor values (145,'Charles Chaplin');
insert into actor values (146,'Roger Donaldson');
insert into actor values (147,'Rick Moranis');
insert into actor values (148,'Tim Burton');
insert into actor values (149,'Stephen Herek');
insert into actor values (150,'Joe Dante');
--- tabactor, 151, 50
insert into actor values (151,'Ethan Hawke');
insert into actor values (152,'Joan Cusack');
insert into actor values (153,'Neil Jordan');
insert into actor values (154,'Jeff Daniels');
insert into actor values (155,'Robert Altman');
insert into actor values (156,'Chris Columbus');
insert into actor values (157,'Forest Whitaker');
insert into actor values (158,'Billy Crystal');
insert into actor values (159,'Ben Affleck');
insert into actor values (160,'Max von Sydow');
insert into actor values (161,'Jon Voight');
insert into actor values (162,'Willem Dafoe');
insert into actor values (163,'John Turturro');
insert into actor values (164,'Gregory Peck');
insert into actor values (165,'Charlton Heston');
insert into actor values (166,'Whoopi Goldberg');
insert into actor values (167,'Donald Pleasence');
insert into actor values (168,'Daniel Day-Lewis');
insert into actor values (169,'Nicole Kidman');
insert into actor values (170,'John Wayne');
insert into actor values (171,'Steven Seagal');
insert into actor values (172,'Geena Davis');
insert into actor values (173,'Kathleen Turner');
insert into actor values (174,'Ed Harris');
insert into actor values (175,'Jim Jarmusch');
insert into actor values (176,'Fred Ward');
insert into actor values (177,'Ralph Fiennes');
insert into actor values (178,'Roy Scheider');
insert into actor values (179,'John Goodman');
insert into actor values (180,'John Candy');
insert into actor values (181,'Matt Damon');
insert into actor values (182,'Faye Dunaway');
insert into actor values (183,'William Holden');
insert into actor values (184,'Bridget Fonda');
insert into actor values (185,'Leonardo DiCaprio');
insert into actor values (186,'Steve Buscemi');
insert into actor values (187,'Christina Ricci');
insert into actor values (188,'Adam Sandler');
insert into actor values (189,'Jim Abrahams');
insert into actor values (190,'Jeff Goldblum');
insert into actor values (191,'Mia Farrow');
insert into actor values (192,'Sam Neill');
insert into actor values (193,'Leonard Nimoy');
insert into actor values (194,'Julianne Moore');
insert into actor values (195,'John Cleese');
insert into actor values (196,'John McTiernan');
insert into actor values (197,'Howard Hawks');
insert into actor values (198,'James Cameron');
insert into actor values (199,'Michael Apted');
insert into actor values (200,'Herbert Ross');
--- tabactor, 201, 50
insert into actor values (201,'Paul Verhoeven');
insert into actor values (202,'Oliver Platt');
insert into actor values (203,'Melanie Griffith');
insert into actor values (204,'John Woo');
insert into actor values (205,'Richard Linklater');
insert into actor values (206,'Spike Lee');
insert into actor values (207,'Barbra Streisand');
insert into actor values (208,'Akira Kurosawa');
insert into actor values (209,'Richard Donner');
insert into actor values (210,'Renny Harlin');
insert into actor values (211,'Gwyneth Paltrow');
insert into actor values (212,'Phillip Noyce');
insert into actor values (213,'Humphrey Bogart');
insert into actor values (214,'Andy Garcia');
insert into actor values (215,'Jodie Foster');
insert into actor values (216,'Chris O''Donnell');
insert into actor values (217,'J.T. Walsh');
insert into actor values (218,'Woody Harrelson');
insert into actor values (219,'Pierce Brosnan');
insert into actor values (220,'Hank Azaria');
insert into actor values (221,'Carl Reiner');
insert into actor values (222,'Cary Elwes');
insert into actor values (223,'Matt Dillon');
insert into actor values (224,'Kiefer Sutherland');
insert into actor values (225,'Anne Bancroft');
insert into actor values (226,'William H. Macy');
insert into actor values (227,'John Mahoney');
insert into actor values (228,'Andie MacDowell');
insert into actor values (229,'Ewan McGregor');
insert into actor values (230,'John Heard');
insert into actor values (231,'Burt Reynolds');
insert into actor values (232,'Patrick Swayze');
insert into actor values (233,'Goldie Hawn');
insert into actor values (234,'Danny Glover');
insert into actor values (235,'Richard Attenborough');
insert into actor values (236,'Roger Moore');
insert into actor values (237,'Mike Myers');
insert into actor values (238,'Ned Beatty');
insert into actor values (239,'Ian Holm');
insert into actor values (240,'Matthew McConaughey');
insert into actor values (241,'Mark Wahlberg');
insert into actor values (242,'Ben Stiller');
insert into actor values (243,'Uma Thurman');
insert into actor values (244,'Michael Madsen');
insert into actor values (245,'Christian Bale');
insert into actor values (246,'Dan Hedaya');
insert into actor values (247,'Albert Brooks');
insert into actor values (248,'Bob Hoskins');
insert into actor values (249,'Annette Bening');
insert into actor values (250,'James Caan');
--- tabactor, 251, 50
insert into actor values (251,'Jennifer Lopez');
insert into actor values (252,'Lance Henriksen');
insert into actor values (253,'Orson Welles');
insert into actor values (254,'Barbara Hershey');
insert into actor values (255,'Gary Sinise');
insert into actor values (256,'James Spader');
insert into actor values (257,'Sean Astin');
insert into actor values (258,'Brad Pitt');
insert into actor values (259,'Joe Pesci');
insert into actor values (260,'Antonio Banderas');
insert into actor values (261,'John Leguizamo');
insert into actor values (262,'Jonathan Lynn');
insert into actor values (263,'Christopher McDonald');
insert into actor values (264,'William Friedkin');
insert into actor values (265,'Bette Midler');
insert into actor values (266,'Clyde Geronimi');
insert into actor values (267,'Gene Wilder');
insert into actor values (268,'Sergio Leone');
insert into actor values (269,'Wim Wenders');
insert into actor values (270,'Trey Parker');
insert into actor values (271,'Gus Van Sant');
insert into actor values (272,'Fred Schepisi');
insert into actor values (273,'Ang Lee');
insert into actor values (274,'Richard Lester');
insert into actor values (275,'Alan J. Pakula');
insert into actor values (276,'George Roy Hill');
insert into actor values (277,'Kirsten Dunst');
insert into actor values (278,'Elisabeth Shue');
insert into actor values (279,'Steve McQueen');
insert into actor values (280,'Holly Hunter');
insert into actor values (281,'Jonathan Demme');
insert into actor values (282,'Cameron Diaz');
insert into actor values (283,'Adrian Lyne');
insert into actor values (284,'Macaulay Culkin');
insert into actor values (285,'Howard Deutch');
insert into actor values (286,'Robert Wise');
insert into actor values (287,'John Ford');
insert into actor values (288,'Philip Kaufman');
insert into actor values (289,'Christopher Lambert');
insert into actor values (290,'Roland Emmerich');
insert into actor values (291,'Andrew Davis');
insert into actor values (292,'Stephen Frears');
insert into actor values (293,'John Boorman');
insert into actor values (294,'Patrick Stewart');
insert into actor values (295,'Harry Dean Stanton');
insert into actor values (296,'Robert Loggia');
insert into actor values (297,'Kim Basinger');
insert into actor values (298,'Billy Bob Thornton');
insert into actor values (299,'Christopher Reeve');
insert into actor values (300,'Danny Aiello');
--- tabactor, 301, 50
insert into actor values (301,'Peter Boyle');
insert into actor values (302,'Benicio Del Toro');
insert into actor values (303,'Lea Thompson');
insert into actor values (304,'Malcolm McDowell');
insert into actor values (305,'Robert Prosky');
insert into actor values (306,'Martin Sheen');
insert into actor values (307,'Bonnie Hunt');
insert into actor values (308,'Gabriel Byrne');
insert into actor values (309,'Randy Quaid');
insert into actor values (310,'Madonna');
insert into actor values (311,'Daniel Stern');
insert into actor values (312,'John Huston');
insert into actor values (313,'Will Patton');
insert into actor values (314,'John Lithgow');
insert into actor values (315,'Mira Sorvino');
insert into actor values (316,'Joan Allen');
insert into actor values (317,'Stockard Channing');
insert into actor values (318,'Tom Sizemore');
insert into actor values (319,'Mickey Rourke');
insert into actor values (320,'Richard Benjamin');
insert into actor values (321,'Kathy Bates');
insert into actor values (322,'Audrey Hepburn');
insert into actor values (323,'Freddie Prinze Jr.');
insert into actor values (324,'Russell Crowe');
insert into actor values (325,'Rene Russo');
insert into actor values (326,'Peter Jackson');
insert into actor values (327,'Peter Weller');
insert into actor values (328,'Neve Campbell');
insert into actor values (329,'Ben Kingsley');
insert into actor values (330,'Dennis Dugan');
insert into actor values (331,'Laurence Fishburne');
insert into actor values (332,'Griffin Dunne');
insert into actor values (333,'Minnie Driver');
insert into actor values (334,'Joe Mantegna');
insert into actor values (335,'David Arquette');
insert into actor values (336,'Jürgen Prochnow');
insert into actor values (337,'Maggie Smith');
insert into actor values (338,'Treat Williams');
insert into actor values (339,'James Remar');
insert into actor values (340,'Shirley MacLaine');
insert into actor values (341,'Michael McKean');
insert into actor values (342,'Claire Danes');
insert into actor values (343,'Anjelica Huston');
insert into actor values (344,'Richard Crenna');
insert into actor values (345,'Henry Fonda');
insert into actor values (346,'Don Siegel');
insert into actor values (347,'Robert Carlyle');
insert into actor values (348,'Giovanni Ribisi');
insert into actor values (349,'Ellen Barkin');
insert into actor values (350,'Jennifer Jason Leigh');
--- tabactor, 351, 50
insert into actor values (351,'Ian McKellen');
insert into actor values (352,'Christopher Guest');
insert into actor values (353,'Juliette Lewis');
insert into actor values (354,'Charles Durning');
insert into actor values (355,'Ving Rhames');
insert into actor values (356,'Tom Skerritt');
insert into actor values (357,'Bruno Kirby');
insert into actor values (358,'Janeane Garofalo');
insert into actor values (359,'Emma Thompson');
insert into actor values (360,'George Lucas');
insert into actor values (361,'Penny Marshall');
insert into actor values (362,'Wilford Brimley');
insert into actor values (363,'Denis Leary');
insert into actor values (364,'John Waters');
insert into actor values (365,'Steve Miner');
insert into actor values (366,'Gérard Depardieu');
insert into actor values (367,'Diane Lane');
insert into actor values (368,'Rosanna Arquette');
insert into actor values (369,'Sally Field');
insert into actor values (370,'Laurence Olivier');
insert into actor values (371,'Michael Lehmann (I)');
insert into actor values (372,'Rob Lowe');
insert into actor values (373,'Lloyd Bridges');
insert into actor values (374,'Michael Caton-Jones');
insert into actor values (375,'Andrew Bergman');
insert into actor values (376,'Rob Cohen');
insert into actor values (377,'Hugh Wilson');
insert into actor values (378,'Kevin Reynolds');
insert into actor values (379,'George A. Romero');
insert into actor values (380,'Aidan Quinn');
insert into actor values (381,'Ice Cube');
insert into actor values (382,'Edward Zwick');
insert into actor values (383,'Randal Kleiser');
insert into actor values (384,'Peter Segal');
insert into actor values (385,'Burgess Meredith');
insert into actor values (386,'Peter Greenaway');
insert into actor values (387,'Lasse Hallström');
insert into actor values (388,'Terence Young');
insert into actor values (389,'Luc Besson');
insert into actor values (390,'Lewis Gilbert (II)');
insert into actor values (391,'Cameron Crowe');
insert into actor values (392,'Frank Capra');
insert into actor values (393,'Yun-Fat Chow');
insert into actor values (394,'Pedro Almodóvar');
insert into actor values (395,'Brian Levant');
insert into actor values (396,'John Singleton');
insert into actor values (397,'Charles Shyer');
insert into actor values (398,'Krzysztof Kieslowski');
insert into actor values (399,'Federico Fellini');
insert into actor values (400,'Bubba Smith');
--- tabactor, 401, 50
insert into actor values (401,'Michael Hoffman');
insert into actor values (402,'Richard Fleischer');
insert into actor values (403,'Amy Heckerling');
insert into actor values (404,'Kirk Douglas');
insert into actor values (405,'Franklin J. Schaffner');
insert into actor values (406,'Patricia Arquette');
insert into actor values (407,'Roger Spottiswoode');
insert into actor values (408,'Milos Forman');
insert into actor values (409,'Don Bluth');
insert into actor values (410,'Joseph Ruben');
insert into actor values (411,'Jon Turteltaub');
insert into actor values (412,'Jeremiah S. Chechik');
insert into actor values (413,'Tom Wilkinson (I)');
insert into actor values (414,'David Fincher');
insert into actor values (415,'Ron Underwood');
insert into actor values (416,'Michael Rooker');
insert into actor values (417,'David Morse');
insert into actor values (418,'Michael Ritchie (I)');
insert into actor values (419,'Spencer Tracy');
insert into actor values (420,'Ingmar Bergman');
insert into actor values (421,'Jan de Bont');
insert into actor values (422,'Barry Sonnenfeld');
insert into actor values (423,'James Foley');
insert into actor values (424,'Joe Johnston');
insert into actor values (425,'Betty Thomas (I)');
insert into actor values (426,'Anne Heche');
insert into actor values (427,'Edward Norton');
insert into actor values (428,'Stanley Donen');
insert into actor values (429,'Katharine Hepburn');
insert into actor values (430,'Tom Berenger');
insert into actor values (431,'James Cromwell');
insert into actor values (432,'Viggo Mortensen');
insert into actor values (433,'James Rebhorn');
insert into actor values (434,'John C. McGinley');
insert into actor values (435,'Hal Holbrook');
insert into actor values (436,'Carol Kane');
insert into actor values (437,'M. Emmet Walsh');
insert into actor values (438,'John Hurt');
insert into actor values (439,'Jeffrey Jones');
insert into actor values (440,'Geoffrey Rush');
insert into actor values (441,'Chazz Palminteri');
insert into actor values (442,'Joaquin Phoenix');
insert into actor values (443,'Philip Seymour Hoffman');
insert into actor values (444,'Quentin Tarantino');
insert into actor values (445,'Kevin Smith');
insert into actor values (446,'Sarah Jessica Parker');
insert into actor values (447,'Chris Farley');
insert into actor values (448,'Jon Favreau');
insert into actor values (449,'Vincent D''Onofrio');
insert into actor values (450,'Burt Young');
--- tabactor, 451, 50
insert into actor values (451,'Tchéky Karyo');
insert into actor values (452,'Helen Mirren');
insert into actor values (453,'Martin Balsam');
insert into actor values (454,'Rupert Everett');
insert into actor values (455,'Michael Wincott');
insert into actor values (456,'Loren Dean');
insert into actor values (457,'Tim Curry');
insert into actor values (458,'Kevin Dunn (I)');
insert into actor values (459,'John C. Reilly');
insert into actor values (460,'Giancarlo Esposito');
insert into actor values (461,'Kelly Preston');
insert into actor values (462,'Carrie Fisher');
insert into actor values (463,'Sissy Spacek');
insert into actor values (464,'David Graf');
insert into actor values (465,'Martin Lawrence');
insert into actor values (466,'Alan Arkin');
insert into actor values (467,'Madeline Kahn');
insert into actor values (468,'Tom Everett Scott');
insert into actor values (469,'Will Smith');
insert into actor values (470,'Charles Grodin');
insert into actor values (471,'Maury Chaykin');
insert into actor values (472,'James Coburn');
insert into actor values (473,'Brian Dennehy');
insert into actor values (474,'Natalie Wood');
insert into actor values (475,'River Phoenix');
insert into actor values (476,'George Kennedy');
insert into actor values (477,'Cheech Marin');
insert into actor values (478,'Matthew Lillard');
insert into actor values (479,'George C. Scott');
insert into actor values (480,'Jennifer Aniston');
insert into actor values (481,'Oliver Reed');
insert into actor values (482,'R. Lee Ermey');
insert into actor values (483,'Vince Vaughn');
insert into actor values (484,'Delroy Lindo');
insert into actor values (485,'Edward Burns (I)');
insert into actor values (486,'David Duchovny');
insert into actor values (487,'Angelina Jolie');
insert into actor values (488,'Virginia Madsen');
insert into actor values (489,'Don Taylor (I)');
insert into actor values (490,'Joan Plowright');
insert into actor values (491,'Alicia Silverstone');
insert into actor values (492,'Ryan Phillippe');
insert into actor values (493,'Michael Biehn');
insert into actor values (494,'Cloris Leachman');
insert into actor values (495,'Frances McDormand');
insert into actor values (496,'Catherine Deneuve');
insert into actor values (497,'Jane Fonda');
insert into actor values (498,'Ronny Cox');
insert into actor values (499,'Jessica Lange');
insert into actor values (500,'Jonathan Frakes');
--- tabactor, 501, 50
insert into actor values (501,'Penelope Ann Miller');
insert into actor values (502,'Talia Shire');
insert into actor values (503,'John Malkovich');
insert into actor values (504,'Dianne Wiest');
insert into actor values (505,'François Truffaut');
insert into actor values (506,'David Paymer');
insert into actor values (507,'Bob Gunton');
insert into actor values (508,'John Gielgud');
insert into actor values (509,'Simon Callow');
insert into actor values (510,'Michael Winslow');
insert into actor values (511,'Steve Zahn');
insert into actor values (512,'Matthew Modine');
insert into actor values (513,'Vanessa Redgrave');
insert into actor values (514,'Tobey Maguire');
insert into actor values (515,'Brion James');
insert into actor values (516,'Xander Berkeley');
insert into actor values (517,'Craig T. Nelson');
insert into actor values (518,'Martin Landau');
insert into actor values (519,'Christopher Plummer');
insert into actor values (520,'Stephen Tobolowsky');
insert into actor values (521,'Raymond J. Barry');
insert into actor values (522,'Annabella Sciorra');
insert into actor values (523,'Jay Mohr');
insert into actor values (524,'Salma Hayek');
insert into actor values (525,'Jonathan Pryce');
insert into actor values (526,'David Chappelle');
insert into actor values (527,'Denholm Elliott');
insert into actor values (528,'Kevin Pollak');
insert into actor values (529,'Mary Steenburgen');
insert into actor values (530,'Hector Elizondo');
insert into actor values (531,'Catherine O''Hara');
insert into actor values (532,'James Doohan');
insert into actor values (533,'Marisa Tomei');
insert into actor values (534,'Lauren Bacall');
insert into actor values (535,'Lauren Holly');
insert into actor values (536,'Robin Wright');
insert into actor values (537,'Bill Duke');
insert into actor values (538,'Nigel Hawthorne');
insert into actor values (539,'Elizabeth Taylor');
insert into actor values (540,'Mako');
insert into actor values (541,'Lindsay Crouse');
insert into actor values (542,'Burt Lancaster');
insert into actor values (543,'David Thewlis');
insert into actor values (544,'Bruce Campbell (I)');
insert into actor values (545,'Robert Englund');
insert into actor values (546,'James Earl Jones');
insert into actor values (547,'Josh Mostel');
insert into actor values (548,'Lili Taylor');
insert into actor values (549,'Gina Gershon');
insert into actor values (550,'Ben Gazzara');
--- tabactor, 551, 50
insert into actor values (551,'Dom DeLuise');
insert into actor values (552,'Mark Hamill');
insert into actor values (553,'Isabella Rossellini');
insert into actor values (554,'Hume Cronyn');
insert into actor values (555,'Teri Garr');
insert into actor values (556,'Rod Taylor');
insert into actor values (557,'Emily Watson');
insert into actor values (558,'Shelley Duvall');
insert into actor values (559,'Brian Blessed');
insert into actor values (560,'Philip Baker Hall');
insert into actor values (561,'Jessica Tandy');
insert into actor values (562,'Tom Holland (I)');
insert into actor values (563,'Gary Busey');
insert into actor values (564,'William Hickey (I)');
insert into actor values (565,'Sam Shepard');
insert into actor values (566,'Richard E. Grant');
insert into actor values (567,'Olympia Dukakis');
insert into actor values (568,'Alfre Woodard');
insert into actor values (569,'Ryan O''Neal');
insert into actor values (570,'David Warner');
insert into actor values (571,'Nicholas Meyer');
insert into actor values (572,'Nick Park');
insert into actor values (573,'David Zucker');
insert into actor values (574,'James L. Brooks');
insert into actor values (575,'Jane Campion');
insert into actor values (576,'James Ivory');
insert into actor values (577,'Russell Mulcahy');
insert into actor values (578,'Toni Collette');
insert into actor values (579,'Bob Clark (III)');
insert into actor values (580,'Jonathan Kaplan (I)');
insert into actor values (581,'Jim Sheridan');
insert into actor values (582,'Mike Judge');
insert into actor values (583,'Mike Leigh');
insert into actor values (584,'Bille August');
insert into actor values (585,'Mike Newell');
insert into actor values (586,'Tom Shadyac');
insert into actor values (587,'Mike Starr (I)');
insert into actor values (588,'Shelley Long');
insert into actor values (589,'Mimi Leder');
insert into actor values (590,'Cuba Gooding Jr.');
insert into actor values (591,'Daryl Hannah');
insert into actor values (592,'Jennifer Love Hewitt');
insert into actor values (593,'Neil LaBute');
insert into actor values (594,'Beverly D''Angelo');
insert into actor values (595,'Martin Brest');
insert into actor values (596,'Josh Brolin');
insert into actor values (597,'Danny Boyle');
insert into actor values (598,'Bernardo Bertolucci');
insert into actor values (599,'Donald Petrie');
insert into actor values (600,'Jeannot Szwarc');
--- tabactor, 601, 50
insert into actor values (601,'DeForest Kelley');
insert into actor values (602,'Sarah Michelle Gellar');
insert into actor values (603,'Jean Reno');
insert into actor values (604,'Jay Roach');
insert into actor values (605,'Judy Davis');
insert into actor values (606,'David Mamet');
insert into actor values (607,'Curtis Hanson');
insert into actor values (608,'Peter O''Toole');
insert into actor values (609,'Kristin Scott Thomas');
insert into actor values (610,'Richard Pryor');
insert into actor values (611,'Kyle MacLachlan');
insert into actor values (612,'Peter Bogdanovich');
insert into actor values (613,'William Baldwin');
insert into actor values (614,'Frank Marshall (I)');
insert into actor values (615,'Lars von Trier');
insert into actor values (616,'Harold Becker');
insert into actor values (617,'Fred Zinnemann');
insert into actor values (618,'Hal Needham');
insert into actor values (619,'Louis Malle');
insert into actor values (620,'William Wyler');
insert into actor values (621,'Anthony Minghella');
insert into actor values (622,'Lou Diamond Phillips');
insert into actor values (623,'Paul Reubens');
insert into actor values (624,'Lee Tamahori');
insert into actor values (625,'Peter Sallis');
insert into actor values (626,'Gene Kelly');
insert into actor values (627,'Geoff Murphy');
insert into actor values (628,'George Cukor');
insert into actor values (629,'George Dzundza');
insert into actor values (630,'Gregory Hoblit');
insert into actor values (631,'George P. Cosmatos');
insert into actor values (632,'Les Mayfield');
insert into actor values (633,'Raja Gosnell');
insert into actor values (634,'Graham Chapman');
insert into actor values (635,'Glenne Headly');
insert into actor values (636,'Guy Hamilton (I)');
insert into actor values (637,'Illeana Douglas');
insert into actor values (638,'Rubén Blades');
insert into actor values (639,'Bryan Singer');
insert into actor values (640,'Kate Winslet');
insert into actor values (641,'Kathryn Bigelow');
insert into actor values (642,'Ron Shelton');
insert into actor values (643,'Veronica Cartwright');
insert into actor values (644,'Keith Gordon');
insert into actor values (645,'Timothy Hutton');
insert into actor values (646,'Anthony Michael Hall');
insert into actor values (647,'Kate Nelligan');
insert into actor values (648,'Roddy McDowall');
insert into actor values (649,'Marcello Mastroianni');
insert into actor values (650,'Ally Sheedy');
--- tabactor, 651, 50
insert into actor values (651,'Irvin Kershner');
insert into actor values (652,'Paul Schrader');
insert into actor values (653,'Paul Anderson (III)');
insert into actor values (654,'Andy Tennant');
insert into actor values (655,'Elia Kazan');
insert into actor values (656,'Elias Koteas');
insert into actor values (657,'Andrew Fleming');
insert into actor values (658,'Andrei Tarkovsky');
insert into actor values (659,'Ellen Burstyn');
insert into actor values (660,'Robert Benton');
insert into actor values (661,'Howard Zieff');
insert into actor values (662,'Emile Ardolino');
insert into actor values (663,'Emir Kusturica');
insert into actor values (664,'Wayne Wang');
insert into actor values (665,'Atom Egoyan');
insert into actor values (666,'Robert Rodriguez');
insert into actor values (667,'Stanley Tong');
insert into actor values (668,'John Glen (II)');
insert into actor values (669,'Jon Amiel');
insert into actor values (670,'Cher');
insert into actor values (671,'Tim Matheson');
insert into actor values (672,'Stephen Hopkins');
insert into actor values (673,'Stanley Kramer');
insert into actor values (674,'Taylor Hackford');
insert into actor values (675,'Michael Curtiz');
insert into actor values (676,'John Frankenheimer');
insert into actor values (677,'John Schlesinger');
insert into actor values (678,'Michael Bay');
insert into actor values (679,'Carl Weathers');
insert into actor values (680,'Chris Sarandon');
insert into actor values (681,'Bruce Greenwood (I)');
insert into actor values (682,'Melinda Dillon');
insert into actor values (683,'John G. Avildsen');
insert into actor values (684,'Tim Allen');
insert into actor values (685,'Bruce Beresford');
insert into actor values (686,'Terrence Malick');
insert into actor values (687,'John Ritter');
insert into actor values (688,'Takashi Shimura');
insert into actor values (689,'Steven Soderbergh');
insert into actor values (690,'Charles Dutton');
insert into actor values (691,'Jon Avnet');
insert into actor values (692,'Joe Don Baker');
insert into actor values (693,'John Milius');
insert into actor values (694,'Terry Jones');
insert into actor values (695,'Parker Posey');
insert into actor values (696,'Bob Balaban');
insert into actor values (697,'Michael Rapaport');
insert into actor values (698,'Keith David (I)');
insert into actor values (699,'Heather Graham');
insert into actor values (700,'Kristy Swanson');
--- tabactor, 701, 50
insert into actor values (701,'James Gandolfini');
insert into actor values (702,'Eric Stoltz');
insert into actor values (703,'Joe Pantoliano');
insert into actor values (704,'Brad Dourif');
insert into actor values (705,'Pam Grier');
insert into actor values (706,'Marcia Gay Harden');
insert into actor values (707,'Kevin J. O''Connor');
insert into actor values (708,'Reese Witherspoon');
insert into actor values (709,'Dabney Coleman');
insert into actor values (710,'Chris Penn');
insert into actor values (711,'Murray Hamilton');
insert into actor values (712,'Jeffrey Tambor');
insert into actor values (713,'Brian Cox');
insert into actor values (714,'Ron Perlman');
insert into actor values (715,'Julie Hagerty');
insert into actor values (716,'Helena Bonham Carter');
insert into actor values (717,'Luke Wilson');
insert into actor values (718,'Frank Whaley');
insert into actor values (719,'Warren Oates');
insert into actor values (720,'Paul Mazursky');
insert into actor values (721,'Tommy Chong');
insert into actor values (722,'Ernest Borgnine');
insert into actor values (723,'Gena Rowlands');
insert into actor values (724,'Famke Janssen');
insert into actor values (725,'Eileen Brennan');
insert into actor values (726,'Kate Capshaw');
insert into actor values (727,'Mario Van Peebles');
insert into actor values (728,'Chris Cooper (I)');
insert into actor values (729,'William Forsythe');
insert into actor values (730,'Hart Bochner');
insert into actor values (731,'William Daniels (I)');
insert into actor values (732,'Jack Palance');
insert into actor values (733,'Albert Finney');
insert into actor values (734,'Julie Christie');
insert into actor values (735,'Toshirô Mifune');
insert into actor values (736,'Embeth Davidtz');
insert into actor values (737,'Nathan Lane');
insert into actor values (738,'Fisher Stevens');
insert into actor values (739,'Don Cheadle');
insert into actor values (740,'John Wood (I)');
insert into actor values (741,'Jeremy Northam');
insert into actor values (742,'Jeremy Irons');
insert into actor values (743,'Rip Torn');
insert into actor values (744,'David Strathairn');
insert into actor values (745,'Udo Kier');
insert into actor values (746,'Brian Doyle-Murray');
insert into actor values (747,'Scott Glenn');
insert into actor values (748,'Josef Sommer');
insert into actor values (749,'Eric Idle');
insert into actor values (750,'Judi Dench');
--- tabactor, 751, 50
insert into actor values (751,'Rod Steiger');
insert into actor values (752,'Dennis Farina');
insert into actor values (753,'Kurtwood Smith');
insert into actor values (754,'Walter Koenig');
insert into actor values (755,'Paul Guilfoyle (II)');
insert into actor values (756,'Alfonso Arau');
insert into actor values (757,'Ray Walston');
insert into actor values (758,'Ossie Davis');
insert into actor values (759,'Dana Delany');
insert into actor values (760,'Cate Blanchett');
insert into actor values (761,'David Ogden Stiers');
insert into actor values (762,'Debi Mazar');
insert into actor values (763,'Louise Fletcher');
insert into actor values (764,'Don Ameche');
insert into actor values (765,'Stephen Rea');
insert into actor values (766,'Billy Zane');
insert into actor values (767,'Joe Morton');
insert into actor values (768,'Shawn Hatosy');
insert into actor values (769,'John Ashton (I)');
insert into actor values (770,'Fairuza Balk');
insert into actor values (771,'Kevin McCarthy');
insert into actor values (772,'Katie Holmes');
insert into actor values (773,'Bruce Davison');
insert into actor values (774,'Peter MacNicol');
insert into actor values (775,'Rade Serbedzija');
insert into actor values (776,'Ray Liotta');
insert into actor values (777,'Anthony LaPaglia');
insert into actor values (778,'Judge Reinhold');
insert into actor values (779,'Michael York');
insert into actor values (780,'Joseph Cotten');
insert into actor values (781,'Kelly McGillis');
insert into actor values (782,'Kathleen Quinlan');
insert into actor values (783,'William L. Petersen');
insert into actor values (784,'Bonnie Bedelia');
insert into actor values (785,'Laura Dern');
insert into actor values (786,'John Belushi');
insert into actor values (787,'Nastassja Kinski');
insert into actor values (788,'Joshua Jackson');
insert into actor values (789,'Tony Shalhoub');
insert into actor values (790,'Nancy Travis');
insert into actor values (791,'Tim Roth');
insert into actor values (792,'Jean-Marc Barr');
insert into actor values (793,'Jude Law');
insert into actor values (794,'James Russo');
insert into actor values (795,'Rose McGowan');
insert into actor values (796,'Charlotte Rampling');
insert into actor values (797,'Dennis Franz');
insert into actor values (798,'Armand Assante');
insert into actor values (799,'Michael Palin');
insert into actor values (800,'Paul Rudd (I)');
--- tabactor, 801, 50
insert into actor values (801,'Helen Hunt');
insert into actor values (802,'James Mason');
insert into actor values (803,'Jonny Lee Miller');
insert into actor values (804,'Courteney Cox');
insert into actor values (805,'Richard Burton');
insert into actor values (806,'Peter Berg');
insert into actor values (807,'Joely Richardson');
insert into actor values (808,'William Atherton');
insert into actor values (809,'Kim Cattrall');
insert into actor values (810,'Maureen Stapleton');
insert into actor values (811,'Irène Jacob');
insert into actor values (812,'Julie Andrews');
insert into actor values (813,'Bryan Brown');
insert into actor values (814,'Julian Sands');
insert into actor values (815,'Luis Buñuel');
insert into actor values (816,'Gary Cole');
insert into actor values (817,'Isabelle Adjani');
insert into actor values (818,'Jack Weston');
insert into actor values (819,'Vincent Gallo');
insert into actor values (820,'Roberto Benigni');
insert into actor values (821,'Geneviève Bujold');
insert into actor values (822,'Bruce Dern');
insert into actor values (823,'Steven Weber');
insert into actor values (824,'Raul Julia');
insert into actor values (825,'Molly Ringwald');
insert into actor values (826,'Lorraine Gary');
insert into actor values (827,'Ingrid Bergman');
insert into actor values (828,'Bette Davis');
insert into actor values (829,'Sidney Poitier');
insert into actor values (830,'Mary-Louise Parker');
insert into actor values (831,'Edward Furlong');
insert into actor values (832,'John Glover');
insert into actor values (833,'Colleen Camp');
insert into actor values (834,'Bradley Whitford');
insert into actor values (835,'Austin Pendleton');
insert into actor values (836,'Peter Horton');
insert into actor values (837,'John Carradine');
insert into actor values (838,'Charlize Theron');
insert into actor values (839,'Bernard Lee (I)');
insert into actor values (840,'Molly Shannon');
insert into actor values (841,'David Niven');
insert into actor values (842,'Richard Jenkins (I)');
insert into actor values (843,'Pat Hingle');
insert into actor values (844,'Richard Libertini');
insert into actor values (845,'Robert Stack');
insert into actor values (846,'Jon Lovitz');
insert into actor values (847,'Christine Baranski');
insert into actor values (848,'Rob Schneider');
insert into actor values (849,'Amanda Plummer');
insert into actor values (850,'Robert Wuhl');
--- tabactor, 851, 50
insert into actor values (851,'Ashley Judd');
insert into actor values (852,'Brad Renfro');
insert into actor values (853,'Bill Nunn');
insert into actor values (854,'Amy Brenneman');
insert into actor values (855,'Michael Ironside');
insert into actor values (856,'Christopher Eccleston');
insert into actor values (857,'Amy Yasbeck');
insert into actor values (858,'Richard Masur');
insert into actor values (859,'Jamie Kennedy');
insert into actor values (860,'D.B. Sweeney');
insert into actor values (861,'Seth Green');
insert into actor values (862,'Pete Postlethwaite');
insert into actor values (863,'Casey Siemaszko');
insert into actor values (864,'Robert Wagner');
insert into actor values (865,'Jeanne Tripplehorn');
insert into actor values (866,'Renée Zellweger');
insert into actor values (867,'George Gaynes');
insert into actor values (868,'Valeria Golino');
insert into actor values (869,'Devon Sawa');
insert into actor values (870,'Gaby Hoffmann');
insert into actor values (871,'Natalie Portman');
insert into actor values (872,'Harris Yulin');
insert into actor values (873,'Tom Selleck');
insert into actor values (874,'Richard Briers');
insert into actor values (875,'JoBeth Williams');
insert into actor values (876,'Laura Linney');
insert into actor values (877,'Dave Foley');
insert into actor values (878,'Leslie Easterbrook');
insert into actor values (879,'Anthony Edwards');
insert into actor values (880,'Moses Gunn');
insert into actor values (881,'Peter Gallagher');
insert into actor values (882,'O.J. Simpson');
insert into actor values (883,'Dudley Moore');
insert into actor values (884,'Maria Conchita Alonso');
insert into actor values (885,'C. Thomas Howell');
insert into actor values (886,'Cyril Cusack');
insert into actor values (887,'Ed O''Ross');
insert into actor values (888,'Sterling Holloway');
insert into actor values (889,'Ernie Hudson');
insert into actor values (890,'Paul Michael Glaser');
insert into actor values (891,'Tom Hulce');
insert into actor values (892,'Teresa Wright');
insert into actor values (893,'James Garner');
insert into actor values (894,'George Takei');
insert into actor values (895,'Annabeth Gish');
insert into actor values (896,'Adrienne Barbeau');
insert into actor values (897,'Lori Petty');
insert into actor values (898,'Deborah Unger');
insert into actor values (899,'Gunnar Björnstrand');
insert into actor values (900,'Strother Martin');
--- tabactor, 901, 50
insert into actor values (901,'Edward Fox');
insert into actor values (902,'Jerry Orbach');
insert into actor values (903,'Rosie Perez');
insert into actor values (904,'Patrick Dempsey');
insert into actor values (905,'Steven Berkoff');
insert into actor values (906,'Lara Flynn Boyle');
insert into actor values (907,'Joe Grifasi');
insert into actor values (908,'Herbert Lom');
insert into actor values (909,'Ken Russell');
insert into actor values (910,'Temuera Morrison');
insert into actor values (911,'Nia Long');
insert into actor values (912,'Peter Ustinov');
insert into actor values (913,'Mary Elizabeth Mastrantonio');
insert into actor values (914,'Eric Bogosian');
insert into actor values (915,'Marilyn Monroe');
insert into actor values (916,'Philip Bosco');
insert into actor values (917,'Liev Schreiber');
insert into actor values (918,'Phil Hartman');
insert into actor values (919,'Alan Rickman');
insert into actor values (920,'Kathy Najimy');
insert into actor values (921,'John Spencer (I)');
insert into actor values (922,'Stellan Skarsgård');
insert into actor values (923,'Rita Wilson');
insert into actor values (924,'Peter Coyote');
insert into actor values (925,'Alec Guinness');
insert into actor values (926,'John Neville');
insert into actor values (927,'Alan Cumming');
insert into actor values (928,'Marshall Bell');
insert into actor values (929,'Kyra Sedgwick');
insert into actor values (930,'John Savage');
insert into actor values (931,'John Sayles');
insert into actor values (932,'Pruitt Taylor Vince');
insert into actor values (933,'Karen Allen');
insert into actor values (934,'Moira Kelly (I)');
insert into actor values (935,'Will Ferrell');
insert into actor values (936,'Peter Fonda');
insert into actor values (937,'John Cazale');
insert into actor values (938,'Kim Hunter');
insert into actor values (939,'Anne Archer');
insert into actor values (940,'Aaron Eckhart');
insert into actor values (941,'Robert Mitchum');
insert into actor values (942,'Powers Boothe');
insert into actor values (943,'Anthony Quinn');
insert into actor values (944,'J.E. Freeman');
insert into actor values (945,'Lily Tomlin');
insert into actor values (946,'Gillian Anderson');
insert into actor values (947,'Elliott Gould');
insert into actor values (948,'Steve Oedekerk');
insert into actor values (949,'Roberts Blossom');
insert into actor values (950,'Mary McDonnell');
--- tabactor, 951, 50
insert into actor values (951,'Owen Wilson');
insert into actor values (952,'Jim Henson');
insert into actor values (953,'Frank Langella');
insert into actor values (954,'Ted Kotcheff');
insert into actor values (955,'Michael Moore (II)');
insert into actor values (956,'Chris Elliott (I)');
insert into actor values (957,'Richard Edson');
insert into actor values (958,'Dermot Mulroney');
insert into actor values (959,'B.D. Wong');
insert into actor values (960,'Crispin Glover');
insert into actor values (961,'Karen Young (I)');
insert into actor values (962,'Ethan Embry');
insert into actor values (963,'Allen Garfield');
insert into actor values (964,'F. Murray Abraham');
insert into actor values (965,'Wendy Crewson');
insert into actor values (966,'M. Night Shyamalan');
insert into actor values (967,'Jerry Paris');
insert into actor values (968,'G.W. Bailey');
insert into actor values (969,'Thora Birch');
insert into actor values (970,'Ralph Richardson');
insert into actor values (971,'Hal Ashby');
insert into actor values (972,'Andrew Robinson');
insert into actor values (973,'Robert Hays');
insert into actor values (974,'John McNaughton');
insert into actor values (975,'Robert John Burke');
insert into actor values (976,'Paul Dooley');
insert into actor values (977,'Adam Rifkin');
insert into actor values (978,'Priscilla Presley');
insert into actor values (979,'George Miller (II)');
insert into actor values (980,'Volker Schlöndorff');
insert into actor values (981,'Groucho Marx');
insert into actor values (982,'Hal Hartley');
insert into actor values (983,'Andrew McCarthy');
insert into actor values (984,'William Sadler');
insert into actor values (985,'Alejandro Amenábar');
insert into actor values (986,'Caroline Goodall');
insert into actor values (987,'Hugh Laurie');
insert into actor values (988,'Iain Softley');
insert into actor values (989,'Ray Wise');
insert into actor values (990,'Phil Daniels (I)');
insert into actor values (991,'Kenny Ortega');
insert into actor values (992,'Leo McCarey');
insert into actor values (993,'Phil Alden Robinson');
insert into actor values (994,'Peter Yates');
insert into actor values (995,'Marc Caro');
insert into actor values (996,'Linda Hamilton');
insert into actor values (997,'Agnieszka Holland');
insert into actor values (998,'Carl Franklin');
insert into actor values (999,'Yahoo Serious');
insert into actor values (1000,'Michael Gough');
--- tabactor, 1001, 50
insert into actor values (1001,'Peter Medak');
insert into actor values (1002,'Peter Vaughan');
insert into actor values (1003,'Carol Reed');
insert into actor values (1004,'Wolfgang Reitherman');
insert into actor values (1005,'Edward James Olmos');
insert into actor values (1006,'John Hannah');
insert into actor values (1007,'Robert Mandel');
insert into actor values (1008,'Edward Woodward');
insert into actor values (1009,'Rebecca De Mornay');
insert into actor values (1010,'Alan Metter');
insert into actor values (1011,'John Madden (II)');
insert into actor values (1012,'Lois Chiles');
insert into actor values (1013,'Melanie Lynskey');
insert into actor values (1014,'Guy Pearce');
insert into actor values (1015,'John Getz');
insert into actor values (1016,'Lewis Teague');
insert into actor values (1017,'Michael Crichton');
insert into actor values (1018,'Greg Kinnear');
insert into actor values (1019,'Heather Langenkamp');
insert into actor values (1020,'Richard Marquand');
insert into actor values (1021,'Penelope Spheeris');
insert into actor values (1022,'George Stevens');
insert into actor values (1023,'Kim Darby (I)');
insert into actor values (1024,'Penélope Cruz');
insert into actor values (1025,'Allan Moyle');
insert into actor values (1026,'Alex D. Linz');
insert into actor values (1027,'Rachel Ticotin');
insert into actor values (1028,'Bruce Robinson (I)');
insert into actor values (1029,'Stuart Rosenberg (I)');
insert into actor values (1030,'Helen Slater');
insert into actor values (1031,'Grace Kelly');
insert into actor values (1032,'Rachel Talalay');
insert into actor values (1033,'Lisa Kudrow');
insert into actor values (1034,'Wes Anderson');
insert into actor values (1035,'F. Gary Gray');
insert into actor values (1036,'Henry Selick');
insert into actor values (1037,'Paul Thomas Anderson');
insert into actor values (1038,'Paul Sorvino');
insert into actor values (1039,'Richard Rush');
insert into actor values (1040,'Frank Darabont');
insert into actor values (1041,'Alex Cox');
insert into actor values (1042,'Elizabeth Perkins');
insert into actor values (1043,'Steven Zaillian');
insert into actor values (1044,'John Lasseter');
insert into actor values (1045,'Fred MacMurray');
insert into actor values (1046,'Linda Hunt');
insert into actor values (1047,'Alex Proyas');
insert into actor values (1048,'Ted Demme');
insert into actor values (1049,'Andrei Konchalovsky');
insert into actor values (1050,'John Lennon');
--- tabactor, 1051, 50
insert into actor values (1051,'Hayao Miyazaki');
insert into actor values (1052,'Paul Hogan');
insert into actor values (1053,'Luis Llosa');
insert into actor values (1054,'Frank Coraci');
insert into actor values (1055,'Tamra Davis');
insert into actor values (1056,'George Sanders');
insert into actor values (1057,'Casey Affleck');
insert into actor values (1058,'Franco Zeffirelli');
insert into actor values (1059,'William Dear');
insert into actor values (1060,'Robert Aldrich');
insert into actor values (1061,'George Seaton');
insert into actor values (1062,'John Dahl');
insert into actor values (1063,'Hugh Hudson');
insert into actor values (1064,'Stuart Baird');
insert into actor values (1065,'Jason Alexander');
insert into actor values (1066,'Juliette Binoche');
insert into actor values (1067,'Mark Harmon');
insert into actor values (1068,'Julie Harris');
insert into actor values (1069,'Baz Luhrmann');
insert into actor values (1070,'David O. Russell');
insert into actor values (1071,'David N. Twohy');
insert into actor values (1072,'Sam Peckinpah');
insert into actor values (1073,'Mark L. Lester');
insert into actor values (1074,'Topol');
insert into actor values (1075,'Sam Weisman');
insert into actor values (1076,'Nicolas Roeg');
insert into actor values (1077,'Thomas Mitchell (I)');
insert into actor values (1078,'Samantha Mathis');
insert into actor values (1079,'Brenda Blethyn');
insert into actor values (1080,'David Lean');
insert into actor values (1081,'Tracey Walter');
insert into actor values (1082,'David Keith');
insert into actor values (1083,'Breckin Meyer');
insert into actor values (1084,'James Dean');
insert into actor values (1085,'Jared Leto');
insert into actor values (1086,'Debra Winger');
insert into actor values (1087,'Arthur Hiller');
insert into actor values (1088,'Matthew Perry');
insert into actor values (1089,'James Fox (I)');
insert into actor values (1090,'Rowdy Herrington');
insert into actor values (1091,'Nora Ephron');
insert into actor values (1092,'James Gammon (I)');
insert into actor values (1093,'Denise Richards');
insert into actor values (1094,'Brett Ratner');
insert into actor values (1095,'Kar-wai Wong');
insert into actor values (1096,'Steve Barron');
insert into actor values (1097,'James Whale');
insert into actor values (1098,'Marion Ramsey');
insert into actor values (1099,'James Mangold');
insert into actor values (1100,'Rutger Hauer');
--- tabactor, 1101, 50
insert into actor values (1101,'Dean Parisot');
insert into actor values (1102,'Dean Martin');
insert into actor values (1103,'Stephen Sommers (I)');
insert into actor values (1104,'Barbet Schroeder');
insert into actor values (1105,'Barnard Hughes');
insert into actor values (1106,'Michael Mann');
insert into actor values (1107,'Ruby Dee');
insert into actor values (1108,'Clark Gable');
insert into actor values (1109,'Ming-Na');
insert into actor values (1110,'Colin Higgins (I)');
insert into actor values (1111,'Joseph L. Mankiewicz');
insert into actor values (1112,'Jeroen Krabbé');
insert into actor values (1113,'Christina Applegate');
insert into actor values (1114,'Simon West (I)');
insert into actor values (1115,'Simon Wincer');
insert into actor values (1116,'Jerry Zucker');
insert into actor values (1117,'David Hand');
insert into actor values (1118,'Mick Jackson (II)');
insert into actor values (1119,'Joseph Sargent');
insert into actor values (1120,'Jonathan Mostow');
insert into actor values (1121,'Todd Solondz');
insert into actor values (1122,'Chuck Russell');
insert into actor values (1123,'Tobe Hooper');
insert into actor values (1124,'Bob Fosse');
insert into actor values (1125,'Christine Taylor');
insert into actor values (1126,'Mary Stuart Masterson');
insert into actor values (1127,'Joe Chappelle');
insert into actor values (1128,'Claude Rains');
insert into actor values (1129,'Danny Cannon');
insert into actor values (1130,'Jean-Hugues Anglade');
insert into actor values (1131,'Jean-Jacques Annaud');
insert into actor values (1132,'Jean-Jacques Beineix');
insert into actor values (1133,'David Anspaugh');
insert into actor values (1134,'Dave Goelz');
insert into actor values (1135,'Scott Hicks');
insert into actor values (1136,'Darren Aronofsky');
insert into actor values (1137,'Morton DaCosta');
insert into actor values (1138,'Stephan Elliott');
insert into actor values (1139,'Brad Silberling');
insert into actor values (1140,'Martin Donovan (II)');
insert into actor values (1141,'Martha Coolidge');
insert into actor values (1142,'Jeffrey Combs');
insert into actor values (1143,'Daniel Auteuil');
insert into actor values (1144,'Dan O''Herlihy');
insert into actor values (1145,'Sean Young');
insert into actor values (1146,'Jena Malone');
insert into actor values (1147,'Chris Tucker');
insert into actor values (1148,'Bibi Andersson');
insert into actor values (1149,'Nicholas Hytner');
insert into actor values (1150,'Bernard Rose');
--- tabactor, 1151, 50
insert into actor values (1151,'Victor Fleming');
insert into actor values (1152,'Ron Clements');
insert into actor values (1153,'Kelly Lynch');
insert into actor values (1154,'Michael Radford');
insert into actor values (1155,'Verna Felton');
insert into actor values (1156,'Douglas Trumbull');
insert into actor values (1157,'Patricia Neal');
insert into actor values (1158,'Jackie Cooper (I)');
insert into actor values (1159,'Antonia Bird');
insert into actor values (1160,'Katt Shea (I)');
insert into actor values (1161,'James Brolin');
insert into actor values (1162,'Don Rickles');
insert into actor values (1163,'Doug Liman');
insert into actor values (1164,'J. Lee Thompson');
insert into actor values (1165,'Kelsey Grammer');
insert into actor values (1166,'Ole Bornedal');
insert into actor values (1167,'James Algar');
insert into actor values (1168,'Robin Tunney');
insert into actor values (1169,'P.J. Hogan');
insert into actor values (1170,'Roland Joffé');
insert into actor values (1171,'Brian Gibson');
insert into actor values (1172,'Irwin Winkler');
insert into actor values (1173,'Jack Sholder');
insert into actor values (1174,'John Bruno');
insert into actor values (1175,'Annabel Jankel');
insert into actor values (1176,'Diane Venora');
insert into actor values (1177,'Vincent Perez');
insert into actor values (1178,'Dwight H. Little');
insert into actor values (1179,'Robin Shou');
insert into actor values (1180,'Isaac Hayes');
insert into actor values (1181,'Annie Potts');
insert into actor values (1182,'Marco Brambilla');
insert into actor values (1183,'Charles Laughton');
insert into actor values (1184,'Robert Shaw');
insert into actor values (1185,'Katrin Cartlidge');
insert into actor values (1186,'Bill Cobbs');
insert into actor values (1187,'Patricia Clarkson');
insert into actor values (1188,'Charles Rocket');
insert into actor values (1189,'Charles Hallahan');
insert into actor values (1190,'William Fichtner');
insert into actor values (1191,'Lois Smith');
insert into actor values (1192,'Victor Wong (III)');
insert into actor values (1193,'Natasha Lyonne');
insert into actor values (1194,'Ian Hart');
insert into actor values (1195,'Ted Danson');
insert into actor values (1196,'Freddie Jones');
insert into actor values (1197,'Don Harvey (I)');
insert into actor values (1198,'Frederic Forrest');
insert into actor values (1199,'Jason Isaacs');
insert into actor values (1200,'Jack Noseworthy');
--- tabactor, 1201, 50
insert into actor values (1201,'Glenn Plummer');
insert into actor values (1202,'Clancy Brown');
insert into actor values (1203,'Paul Winfield');
insert into actor values (1204,'Mykelti Williamson');
insert into actor values (1205,'Tom Atkins');
insert into actor values (1206,'Brent Spiner');
insert into actor values (1207,'Anna Paquin');
insert into actor values (1208,'Stephen Collins');
insert into actor values (1209,'Harvey Korman');
insert into actor values (1210,'Elijah Wood');
insert into actor values (1211,'Anthony Zerbe');
insert into actor values (1212,'James Frain');
insert into actor values (1213,'Geraldine Chaplin');
insert into actor values (1214,'Dylan Baker');
insert into actor values (1215,'Jason Lee (I)');
insert into actor values (1216,'Phoebe Cates');
insert into actor values (1217,'Everett McGill');
insert into actor values (1218,'Jonathan Hyde');
insert into actor values (1219,'David Krumholtz');
insert into actor values (1220,'Blythe Danner');
insert into actor values (1221,'Peter Falk');
insert into actor values (1222,'Wallace Shawn');
insert into actor values (1223,'Stephen Fry');
insert into actor values (1224,'Seymour Cassel');
insert into actor values (1225,'Catherine Hicks');
insert into actor values (1226,'Judd Nelson');
insert into actor values (1227,'Martin Short');
insert into actor values (1228,'Nancy Allen');
insert into actor values (1229,'Stanley Tucci');
insert into actor values (1230,'E.G. Marshall');
insert into actor values (1231,'Ralph Bellamy');
insert into actor values (1232,'Kasi Lemmons');
insert into actor values (1233,'Cliff De Young');
insert into actor values (1234,'Michael Gambon');
insert into actor values (1235,'Jennifer Tilly');
insert into actor values (1236,'Luis Guzmán');
insert into actor values (1237,'Wil Wheaton');
insert into actor values (1238,'Mary Beth Hurt');
insert into actor values (1239,'James Hampton');
insert into actor values (1240,'Maximilian Schell');
insert into actor values (1241,'Anthony Perkins');
insert into actor values (1242,'Jeffrey DeMunn');
insert into actor values (1243,'Stephen Baldwin');
insert into actor values (1244,'Marsha Mason');
insert into actor values (1245,'Sean Patrick Flanery');
insert into actor values (1246,'Terry O''Quinn');
insert into actor values (1247,'Daniel von Bargen');
insert into actor values (1248,'Connie Nielsen');
insert into actor values (1249,'Tony Burton');
insert into actor values (1250,'Vin Diesel');
--- tabactor, 1251, 50
insert into actor values (1251,'Jon Cryer');
insert into actor values (1252,'Piper Laurie');
insert into actor values (1253,'Fred Gwynne');
insert into actor values (1254,'Rachel Griffiths (I)');
insert into actor values (1255,'Graham Greene (II)');
insert into actor values (1256,'Angie Dickinson');
insert into actor values (1257,'George Segal');
insert into actor values (1258,'Jerry O''Connell');
insert into actor values (1259,'Bill McKinney');
insert into actor values (1260,'Campbell Scott');
insert into actor values (1261,'Ian Bannen');
insert into actor values (1262,'Caroline Aaron');
insert into actor values (1263,'Corey Feldman');
insert into actor values (1264,'Dylan McDermott');
insert into actor values (1265,'Miranda Richardson');
insert into actor values (1266,'Yaphet Kotto');
insert into actor values (1267,'Gene Saks');
insert into actor values (1268,'Jennifer Grey');
insert into actor values (1269,'Jennifer Connelly');
insert into actor values (1270,'Jennifer Beals');
insert into actor values (1271,'Jerry Nelson');
insert into actor values (1272,'Jack Thompson (I)');
insert into actor values (1273,'Brenda Fricker');
insert into actor values (1274,'Thomas Jane');
insert into actor values (1275,'Mae Whitman');
insert into actor values (1276,'Ward Bond');
insert into actor values (1277,'Richard Bohringer');
insert into actor values (1278,'Joey Lauren Adams');
insert into actor values (1279,'John Vernon');
insert into actor values (1280,'Rosie O''Donnell');
insert into actor values (1281,'Brenda Vaccaro');
insert into actor values (1282,'Diana Scarwid');
insert into actor values (1283,'Jason London');
insert into actor values (1284,'Larry Miller');
insert into actor values (1285,'Rick Rossovich');
insert into actor values (1286,'Andre Braugher');
insert into actor values (1287,'Jacqueline Bisset');
insert into actor values (1288,'Dee Wallace-Stone');
insert into actor values (1289,'Eugene Levy');
insert into actor values (1290,'Henry Jones (I)');
insert into actor values (1291,'John Forsythe');
insert into actor values (1292,'Henry Winkler');
insert into actor values (1293,'Bernard Hill');
insert into actor values (1294,'Bernadette Peters');
insert into actor values (1295,'Robert Forster');
insert into actor values (1296,'Teri Hatcher');
insert into actor values (1297,'Richard Roundtree');
insert into actor values (1298,'Charlie Korsmo');
insert into actor values (1299,'Catherine Zeta-Jones');
insert into actor values (1300,'Pamela Reed');
--- tabactor, 1301, 50
insert into actor values (1301,'Katherine Helmond');
insert into actor values (1302,'Elizabeth Hurley');
insert into actor values (1303,'Nina Foch');
insert into actor values (1304,'Brigitte Nielsen');
insert into actor values (1305,'Tony Roberts (I)');
insert into actor values (1306,'David Hemblen');
insert into actor values (1307,'Donald Moffat');
insert into actor values (1308,'Michael Jeter');
insert into actor values (1309,'CCH Pounder');
insert into actor values (1310,'Bruce McGill');
insert into actor values (1311,'Armin Mueller-Stahl');
insert into actor values (1312,'Richard Riehle');
insert into actor values (1313,'Peter Stormare');
insert into actor values (1314,'Patrick McGoohan');
insert into actor values (1315,'Frank McRae');
insert into actor values (1316,'Alan Alda');
insert into actor values (1317,'Halle Berry');
insert into actor values (1318,'Richard Kiel');
insert into actor values (1319,'Liv Tyler');
insert into actor values (1320,'Saul Rubinek');
insert into actor values (1321,'David Caruso');
insert into actor values (1322,'Leo G. Carroll');
insert into actor values (1323,'Cathy Moriarty');
insert into actor values (1324,'Damon Wayans');
insert into actor values (1325,'Chris Rock');
insert into actor values (1326,'Muse Watson');
insert into actor values (1327,'Elizabeth Daily');
insert into actor values (1328,'Marvin J. McIntyre');
insert into actor values (1329,'Paul Bartel');
insert into actor values (1330,'Jeremy Piven');
insert into actor values (1331,'Peter Donat');
insert into actor values (1332,'Paul Gleason (I)');
insert into actor values (1333,'Kenneth Mars');
insert into actor values (1334,'John Saxon');
insert into actor values (1335,'Joseph Maher');
insert into actor values (1336,'Porter Hall');
insert into actor values (1337,'James Caviezel');
insert into actor values (1338,'James Duval');
insert into actor values (1339,'Kirstie Alley');
insert into actor values (1340,'Michael Paré');
insert into actor values (1341,'John Lurie');
insert into actor values (1342,'James Cosmo');
insert into actor values (1343,'M.C. Gainey');
insert into actor values (1344,'Joanna Cassidy');
insert into actor values (1345,'Ian McDiarmid');
insert into actor values (1346,'Jack MacGowran');
insert into actor values (1347,'Josh Charles');
insert into actor values (1348,'Lee Marvin');
insert into actor values (1349,'Julie Delpy');
insert into actor values (1350,'Maurice Evans');
--- tabactor, 1351, 50
insert into actor values (1351,'Lee Van Cleef');
insert into actor values (1352,'Harland Williams');
insert into actor values (1353,'Jason Robards');
insert into actor values (1354,'Mitch Ryan');
insert into actor values (1355,'P.J. Soles');
insert into actor values (1356,'Miriam Margolyes');
insert into actor values (1357,'Marc McClure (I)');
insert into actor values (1358,'Harry Connick Jr.');
insert into actor values (1359,'Milla Jovovich');
insert into actor values (1360,'Kevin Peter Hall');
insert into actor values (1361,'Keenen Ivory Wayans');
insert into actor values (1362,'LL Cool J');
insert into actor values (1363,'Oprah Winfrey');
insert into actor values (1364,'James Belushi');
insert into actor values (1365,'Omar Sharif');
insert into actor values (1366,'Mickey Rooney');
insert into actor values (1367,'Kieran Culkin');
insert into actor values (1368,'Robert Patrick');
insert into actor values (1369,'Richard Schiff');
insert into actor values (1370,'Ed Binns');
insert into actor values (1371,'Rachel Roberts');
insert into actor values (1372,'Charles Martin Smith');
insert into actor values (1373,'David Schwimmer');
insert into actor values (1374,'Regina King');
insert into actor values (1375,'Charles Cyphers');
insert into actor values (1376,'Billy Crudup');
insert into actor values (1377,'Wallace Ford');
insert into actor values (1378,'Dominique Pinon');
insert into actor values (1379,'Betsy Palmer');
insert into actor values (1380,'Gedde Watanabe');
insert into actor values (1381,'Rodney Dangerfield');
insert into actor values (1382,'Richard Griffiths (I)');
insert into actor values (1383,'Edward Herrmann');
insert into actor values (1384,'Richard A. Dysart');
insert into actor values (1385,'Dennis Haysbert');
insert into actor values (1386,'Colm Meaney');
insert into actor values (1387,'Reni Santoni');
insert into actor values (1388,'Tia Carrere');
insert into actor values (1389,'Ann-Margret');
insert into actor values (1390,'Claudia Cardinale');
insert into actor values (1391,'Clea DuVall');
insert into actor values (1392,'Cliff Curtis');
insert into actor values (1393,'Christopher Lee');
insert into actor values (1394,'Clare Higgins (I)');
insert into actor values (1395,'Bill Hunter (I)');
insert into actor values (1396,'Tony Darrow');
insert into actor values (1397,'Joseph Mazzello');
insert into actor values (1398,'Tony Goldwyn');
insert into actor values (1399,'Timothy Spall');
insert into actor values (1400,'Josh Hamilton');
--- tabactor, 1401, 50
insert into actor values (1401,'Judd Hirsch');
insert into actor values (1402,'Mary Kay Place');
insert into actor values (1403,'James Cagney');
insert into actor values (1404,'Joseph Gordon-Levitt');
insert into actor values (1405,'José Ferrer');
insert into actor values (1406,'Otto Preminger');
insert into actor values (1407,'Ron Livingston');
insert into actor values (1408,'Oskar Werner');
insert into actor values (1409,'Tori Spelling');
insert into actor values (1410,'Dina Meyer');
insert into actor values (1411,'Omar Epps');
insert into actor values (1412,'Tom Arnold');
insert into actor values (1413,'Olivia Newton-John');
insert into actor values (1414,'Olivia Williams');
insert into actor values (1415,'Ron Rifkin');
insert into actor values (1416,'Verna Bloom');
insert into actor values (1417,'Hugo Weaving');
insert into actor values (1418,'Robert Davi');
insert into actor values (1419,'Katharine Ross');
insert into actor values (1420,'Elizabeth Wilson (I)');
insert into actor values (1421,'Elle Macpherson');
insert into actor values (1422,'Hoyt Axton');
insert into actor values (1423,'Isaiah Washington');
insert into actor values (1424,'Kathryn Beaumont');
insert into actor values (1425,'Iben Hjejle');
insert into actor values (1426,'Paul Mercurio');
insert into actor values (1427,'Keir Dullea');
insert into actor values (1428,'Keith Coogan');
insert into actor values (1429,'Margot Kidder');
insert into actor values (1430,'Marco Leonardi');
insert into actor values (1431,'Paul Scofield');
insert into actor values (1432,'Marianne Sägebrecht');
insert into actor values (1433,'Edmund Gwenn');
insert into actor values (1434,'Jack Gilford');
insert into actor values (1435,'Julia Ormond');
insert into actor values (1436,'Dylan Walsh');
insert into actor values (1437,'Trevor Howard');
insert into actor values (1438,'Rosalind Russell');
insert into actor values (1439,'Patrick Bergin');
insert into actor values (1440,'Kate Beckinsale');
insert into actor values (1441,'Robert Sean Leonard');
insert into actor values (1442,'Karl Malden');
insert into actor values (1443,'Julie Walters');
insert into actor values (1444,'Robert Preston (I)');
insert into actor values (1445,'Irene Bedard');
insert into actor values (1446,'Juliet Stevenson');
insert into actor values (1447,'Tuesday Weld');
insert into actor values (1448,'Ice-T');
insert into actor values (1449,'Jack Hawkins');
insert into actor values (1450,'James Hong');
--- tabactor, 1451, 50
insert into actor values (1451,'Sean Bean');
insert into actor values (1452,'Miriam Flynn');
insert into actor values (1453,'Sterling Hayden');
insert into actor values (1454,'Charles Dance');
insert into actor values (1455,'Dan Futterman');
insert into actor values (1456,'Jeffrey Wright');
insert into actor values (1457,'Dana Carvey');
insert into actor values (1458,'Roy Dotrice');
insert into actor values (1459,'Michael Dorn');
insert into actor values (1460,'John Astin');
insert into actor values (1461,'Danny Kaye');
insert into actor values (1462,'Casper Van Dien');
insert into actor values (1463,'Cary-Hiroyuki Tagawa');
insert into actor values (1464,'Myrna Loy');
insert into actor values (1465,'Carol Burnett');
insert into actor values (1466,'Michael Beck');
insert into actor values (1467,'Charles Bronson');
insert into actor values (1468,'Stanley Baker');
insert into actor values (1469,'Jim Mallon');
insert into actor values (1470,'Solveig Dommartin');
insert into actor values (1471,'Sofia Coppola');
insert into actor values (1472,'Michelle Yeoh');
insert into actor values (1473,'Joaquim de Almeida');
insert into actor values (1474,'Skeet Ulrich');
insert into actor values (1475,'Cylk Cozart');
insert into actor values (1476,'Sihung Lung');
insert into actor values (1477,'Shannon Elizabeth');
insert into actor values (1478,'Sheryl Lee');
insert into actor values (1479,'Chia-Liang Liu');
insert into actor values (1480,'Michael Jai White');
insert into actor values (1481,'Craig Sheffer');
insert into actor values (1482,'Mimi Rogers');
insert into actor values (1483,'Craig Wasson');
insert into actor values (1484,'Takeshi Kitano');
insert into actor values (1485,'Spike Jonze');
insert into actor values (1486,'James Marsden');
insert into actor values (1487,'Carlo Cecchi');
insert into actor values (1488,'Maureen O''Hara');
insert into actor values (1489,'Nicolette Sheridan');
insert into actor values (1490,'Thomas F. Wilson');
insert into actor values (1491,'Ruth Warrick');
insert into actor values (1492,'Dean Stockwell');
insert into actor values (1493,'Brian Henson');
insert into actor values (1494,'Ruth Gordon');
insert into actor values (1495,'Nick Cassavetes');
insert into actor values (1496,'John Williams (II)');
insert into actor values (1497,'Pamela Blair');
insert into actor values (1498,'Rufus Sewell');
insert into actor values (1499,'Paul Smith (I)');
insert into actor values (1500,'Johnathon Schaech');
--- tabactor, 1501, 50
insert into actor values (1501,'James Fleet');
insert into actor values (1502,'Bobby Driscoll');
insert into actor values (1503,'Nikita Mikhalkov');
insert into actor values (1504,'Sammi Davis (I)');
insert into actor values (1505,'Mary Wickes');
insert into actor values (1506,'Bruce McCulloch');
insert into actor values (1507,'John Houseman');
insert into actor values (1508,'Tara Fitzgerald');
insert into actor values (1509,'Jean Arthur');
insert into actor values (1510,'Tate Donovan');
insert into actor values (1511,'Saffron Burrows');
insert into actor values (1512,'Brooke Adams');
insert into actor values (1513,'David Carradine');
insert into actor values (1514,'Sam Wanamaker');
insert into actor values (1515,'Bridgette Wilson');
insert into actor values (1516,'Nichelle Nichols');
insert into actor values (1517,'John Meillon');
insert into actor values (1518,'Sam Elliott');
insert into actor values (1519,'Maxwell Caulfield');
insert into actor values (1520,'Terry Kinney');
insert into actor values (1521,'Jason Scott Lee');
insert into actor values (1522,'Adam Hann-Byrd');
insert into actor values (1523,'Greg Cruttwell');
insert into actor values (1524,'Vivien Leigh');
insert into actor values (1525,'Radha Mitchell');
insert into actor values (1526,'Warren Clarke');
insert into actor values (1527,'Farley Granger');
insert into actor values (1528,'Hayden Panettiere');
insert into actor values (1529,'Henry Czerny');
insert into actor values (1530,'Liza Minnelli');
insert into actor values (1531,'Reginald VelJohnson');
insert into actor values (1532,'Gailard Sartain');
insert into actor values (1533,'Lou Jacobi');
insert into actor values (1534,'Heath Ledger');
insert into actor values (1535,'Alexis Arquette');
insert into actor values (1536,'Walter Brennan');
insert into actor values (1537,'George Carlin');
insert into actor values (1538,'Richard Jordan (I)');
insert into actor values (1539,'Yul Brynner');
insert into actor values (1540,'Richard Lineback');
insert into actor values (1541,'Louis Gossett Jr.');
insert into actor values (1542,'Amy Madigan');
insert into actor values (1543,'William Powell');
insert into actor values (1544,'Akira Terao');
insert into actor values (1545,'Lee J. Cobb');
insert into actor values (1546,'Angela Lansbury');
insert into actor values (1547,'Koji Yakusho');
insert into actor values (1548,'Linda Fiorentino');
insert into actor values (1549,'Piper Perabo');
insert into actor values (1550,'Linus Roache');
--- tabactor, 1551, 50
insert into actor values (1551,'Paul Walker (I)');
insert into actor values (1552,'Richard Farnsworth');
insert into actor values (1553,'Glynis Johns');
insert into actor values (1554,'Kenneth Tsang');
insert into actor values (1555,'Annette O''Toole');
insert into actor values (1556,'Lisa Bonet');
insert into actor values (1557,'Peter Graves (I)');
insert into actor values (1558,'Leslie Mann');
insert into actor values (1559,'LeVar Burton');
insert into actor values (1560,'Peter Facinelli');
insert into actor values (1561,'Lane Smith (I)');
insert into actor values (1562,'Vincent Cassel');
insert into actor values (1563,'Ricki Lake');
insert into actor values (1564,'Rex Linn');
insert into actor values (1565,'Allison Janney');
insert into actor values (1566,'Nicky Katt');
insert into actor values (1567,'Jim Broadbent');
insert into actor values (1568,'Tom Waits');
insert into actor values (1569,'Fred Dalton Thompson');
insert into actor values (1570,'Frankie Faison');
insert into actor values (1571,'David Patrick Kelly');
insert into actor values (1572,'Martha Plimpton');
insert into actor values (1573,'Jane Adams (II)');
insert into actor values (1574,'Derek Jacobi');
insert into actor values (1575,'Jon Polito');
insert into actor values (1576,'Anthony Heald');
insert into actor values (1577,'Stuart Pankin');
insert into actor values (1578,'Marc Macaulay');
insert into actor values (1579,'Ronald Lacey');
insert into actor values (1580,'Bebe Neuwirth');
insert into actor values (1581,'Matt Craven');
insert into actor values (1582,'G.D. Spradlin');
insert into actor values (1583,'Lucinda Jenney');
insert into actor values (1584,'Daniel Roebuck');
insert into actor values (1585,'Chelcie Ross');
insert into actor values (1586,'Jeff Corey');
insert into actor values (1587,'Frances Bay');
insert into actor values (1588,'Sarah Polley');
insert into actor values (1589,'Holland Taylor');
insert into actor values (1590,'Max Casella');
insert into actor values (1591,'Sam Rockwell');
insert into actor values (1592,'Ally Walker');
insert into actor values (1593,'John Pankow');
insert into actor values (1594,'John Randolph');
insert into actor values (1595,'Michael Rispoli');
insert into actor values (1596,'Jake Busey');
insert into actor values (1597,'George Wendt');
insert into actor values (1598,'Billy Connolly');
insert into actor values (1599,'Olek Krupa');
insert into actor values (1600,'Donal Logue');
--- tabactor, 1601, 50
insert into actor values (1601,'Jon Tenney');
insert into actor values (1602,'Michael J. Pollard');
insert into actor values (1603,'Miguel Ferrer');
insert into actor values (1604,'Ling Bai');
insert into actor values (1605,'Jake Weber');
insert into actor values (1606,'Cliff Robertson');
insert into actor values (1607,'Cole Hauser');
insert into actor values (1608,'Kyle Secor');
insert into actor values (1609,'Stephen Lang');
insert into actor values (1610,'Om Puri');
insert into actor values (1611,'Allen Covert');
insert into actor values (1612,'Chloe Webb');
insert into actor values (1613,'William Lee Scott');
insert into actor values (1614,'John P. Ryan');
insert into actor values (1615,'Lorraine Bracco');
insert into actor values (1616,'John M. Jackson');
insert into actor values (1617,'Telly Savalas');
insert into actor values (1618,'John Larroquette');
insert into actor values (1619,'Lena Olin');
insert into actor values (1620,'Maura Tierney');
insert into actor values (1621,'Sandy Baron');
insert into actor values (1622,'David Suchet');
insert into actor values (1623,'Albert Hall (I)');
insert into actor values (1624,'Johnny Galecki');
insert into actor values (1625,'Brendan Sexton III');
insert into actor values (1626,'Grant Heslov');
insert into actor values (1627,'Noah Emmerich');
insert into actor values (1628,'Danny Trejo');
insert into actor values (1629,'Boyd Gaines');
insert into actor values (1630,'Rowan Atkinson');
insert into actor values (1631,'Rebecca Gayheart');
insert into actor values (1632,'Jeffrey Kramer');
insert into actor values (1633,'Alan Ruck');
insert into actor values (1634,'Mason Gamble');
insert into actor values (1635,'Roshan Seth');
insert into actor values (1636,'Timothy Busfield');
insert into actor values (1637,'Lonette McKee');
insert into actor values (1638,'Mark Blum');
insert into actor values (1639,'Harvey Fierstein');
insert into actor values (1640,'Paul Giamatti');
insert into actor values (1641,'Iggy Pop');
insert into actor values (1642,'Fran Drescher');
insert into actor values (1643,'Marilu Henner');
insert into actor values (1644,'Anthony Rapp');
insert into actor values (1645,'Margaret Colin');
insert into actor values (1646,'Elizabeth McGovern');
insert into actor values (1647,'Kevin Anderson');
insert into actor values (1648,'Trey Wilson');
insert into actor values (1649,'Til Schweiger');
insert into actor values (1650,'Paul Shenar');
--- tabactor, 1651, 50
insert into actor values (1651,'Judith Anderson');
insert into actor values (1652,'Marc Anthony (I)');
insert into actor values (1653,'Barry Pepper');
insert into actor values (1654,'Elizabeth Berkley');
insert into actor values (1655,'Anthony Daniels');
insert into actor values (1656,'Joss Ackland');
insert into actor values (1657,'Eric Christmas');
insert into actor values (1658,'Angela Bassett');
insert into actor values (1659,'Edie McClurg');
insert into actor values (1660,'James Whitmore');
insert into actor values (1661,'Thierry Lhermitte');
insert into actor values (1662,'Andrew Divoff');
insert into actor values (1663,'Charlotte Stewart');
insert into actor values (1664,'Bill Campbell');
insert into actor values (1665,'Cynthia Stevenson');
insert into actor values (1666,'Sally Kirkland');
insert into actor values (1667,'Alec McCowen');
insert into actor values (1668,'Cedric Hardwicke');
insert into actor values (1669,'Elsa Lanchester');
insert into actor values (1670,'Lee Evans (I)');
insert into actor values (1671,'Lesley Ann Warren');
insert into actor values (1672,'Peter Michael Goetz');
insert into actor values (1673,'Imelda Staunton');
insert into actor values (1674,'Damian Chapa');
insert into actor values (1675,'Lesley Sharp');
insert into actor values (1676,'Brent Jennings');
insert into actor values (1677,'Kathy Baker');
insert into actor values (1678,'John Rhys-Davies');
insert into actor values (1679,'Edward G. Robinson');
insert into actor values (1680,'Robert Pastorelli');
insert into actor values (1681,'Matt Stone');
insert into actor values (1682,'Marianne Jean-Baptiste');
insert into actor values (1683,'Nicholas Farrell');
insert into actor values (1684,'Sela Ward');
insert into actor values (1685,'Charles Cioffi');
insert into actor values (1686,'Greta Scacchi');
insert into actor values (1687,'Josh Hartnett');
insert into actor values (1688,'David Bowie');
insert into actor values (1689,'Jean-Luc Godard');
insert into actor values (1690,'Gemma Jones');
insert into actor values (1691,'Sammo Hung Kam-Bo');
insert into actor values (1692,'Taylor Nichols');
insert into actor values (1693,'Elaine Hendrix');
insert into actor values (1694,'Ursula Andress');
insert into actor values (1695,'Swoosie Kurtz');
insert into actor values (1696,'Sandahl Bergman');
insert into actor values (1697,'Mia Kirshner');
insert into actor values (1698,'Tatsuya Nakadai');
insert into actor values (1699,'Natasha Henstridge');
insert into actor values (1700,'John Herzfeld');
--- tabactor, 1701, 50
insert into actor values (1701,'Natascha McElhone');
insert into actor values (1702,'Leon (I)');
insert into actor values (1703,'Jason Mewes');
insert into actor values (1704,'Darren McGavin');
insert into actor values (1705,'George Newbern');
insert into actor values (1706,'Nicholas Ray');
insert into actor values (1707,'Irma P. Hall');
insert into actor values (1708,'Peter Riegert');
insert into actor values (1709,'Cybill Shepherd');
insert into actor values (1710,'Sam J. Jones');
insert into actor values (1711,'Elizabeth Peña');
insert into actor values (1712,'Brittany Murphy');
insert into actor values (1713,'Angela Featherstone');
insert into actor values (1714,'Nancy Kyes');
insert into actor values (1715,'Michael Clarke Duncan');
insert into actor values (1716,'Elaine May');
insert into actor values (1717,'Janet Leigh');
insert into actor values (1718,'Elden Ratliff');
insert into actor values (1719,'Phil Harris (I)');
insert into actor values (1720,'Michael Bates (I)');
insert into actor values (1721,'Gregory Hines');
insert into actor values (1722,'Karen Black');
insert into actor values (1723,'Stan Shaw');
insert into actor values (1724,'Kim Dickens');
insert into actor values (1725,'Stacy Keach');
insert into actor values (1726,'Ben Johnson (I)');
insert into actor values (1727,'Billy Dee Williams');
insert into actor values (1728,'Ron Eldard');
insert into actor values (1729,'Hilary Swank');
insert into actor values (1730,'Ben Cross');
insert into actor values (1731,'Jack Black (I)');
insert into actor values (1732,'Jessica Harper');
insert into actor values (1733,'Alison Elliott (I)');
insert into actor values (1734,'Christine Lahti');
insert into actor values (1735,'Madolyn Smith-Osborne');
insert into actor values (1736,'Christine Ebersole');
insert into actor values (1737,'Ali Larter');
insert into actor values (1738,'Anouk Aimée');
insert into actor values (1739,'Ron Silver');
insert into actor values (1740,'Mike McGlone');
insert into actor values (1741,'Spalding Gray');
insert into actor values (1742,'Harry Morgan');
insert into actor values (1743,'Pupella Maggio');
insert into actor values (1744,'Claire Bloom');
insert into actor values (1745,'Alyson Hannigan');
insert into actor values (1746,'Jim Brown');
insert into actor values (1747,'Michelle Williams');
insert into actor values (1748,'Wayne Knight');
insert into actor values (1749,'Cleavon Little');
insert into actor values (1750,'Slim Pickens');
--- tabactor, 1751, 50
insert into actor values (1751,'Marg Helgenberger');
insert into actor values (1752,'Michael Vartan');
insert into actor values (1753,'Linda Blair');
insert into actor values (1754,'Frances Sternhagen');
insert into actor values (1755,'Marco Hofschneider');
insert into actor values (1756,'Bill Tung');
insert into actor values (1757,'Gilbert Gottfried');
insert into actor values (1758,'Eric Roberts');
insert into actor values (1759,'Polly Walker (II)');
insert into actor values (1760,'Shawn Wayans');
insert into actor values (1761,'Fritz Weaver');
insert into actor values (1762,'Colm Feore');
insert into actor values (1763,'Milo O''Shea');
insert into actor values (1764,'Sid Caesar');
insert into actor values (1765,'Norm Macdonald');
insert into actor values (1766,'Lew Ayres');
insert into actor values (1767,'Lucy Liu');
insert into actor values (1768,'Grace Jones');
insert into actor values (1769,'Chloë Sevigny');
insert into actor values (1770,'Peter Jason');
insert into actor values (1771,'Jennifer Rubin (I)');
insert into actor values (1772,'Anatoli Solonitsyn');
insert into actor values (1773,'Curtis Armstrong');
insert into actor values (1774,'Keenan Wynn');
insert into actor values (1775,'Deborah Kerr');
insert into actor values (1776,'Eliza Dushku');
insert into actor values (1777,'Larry Gates');
insert into actor values (1778,'Patricia Hayes (I)');
insert into actor values (1779,'Miko Hughes');
insert into actor values (1780,'Michael Lonsdale');
insert into actor values (1781,'Joel Grey');
insert into actor values (1782,'Richard Haydn');
insert into actor values (1783,'Michael Lerner');
insert into actor values (1784,'Victor Argo');
insert into actor values (1785,'Jon Finch');
insert into actor values (1786,'Ben Chaplin');
insert into actor values (1787,'Dennis Miller (I)');
insert into actor values (1788,'Paul McGann');
insert into actor values (1789,'Mildred Natwick');
insert into actor values (1790,'Noble Willingham');
insert into actor values (1791,'David Margulies');
insert into actor values (1792,'Jack Kehoe');
insert into actor values (1793,'Desmond Llewelyn');
insert into actor values (1794,'Grace Zabriskie');
insert into actor values (1795,'Leon Rippy');
insert into actor values (1796,'Grand L. Bush');
insert into actor values (1797,'Stefan Gierasch');
insert into actor values (1798,'David Cross (II)');
insert into actor values (1799,'Lisa Jane Persky');
insert into actor values (1800,'Lois Maxwell');
--- tabactor, 1801, 50
insert into actor values (1801,'Jenette Goldstein');
insert into actor values (1802,'Zach Grenier');
insert into actor values (1803,'Zeljko Ivanek');
insert into actor values (1804,'Bronson Pinchot');
insert into actor values (1805,'Ed Lauter');
insert into actor values (1806,'Lanny Flaherty');
insert into actor values (1807,'Julia Sweeney');
insert into actor values (1808,'Mark Rolston');
insert into actor values (1809,'Dick Miller (I)');
insert into actor values (1810,'Nicholas Pryor');
insert into actor values (1811,'Terence Stamp');
insert into actor values (1812,'Ted Raimi');
insert into actor values (1813,'Richard Harris');
insert into actor values (1814,'David Proval');
insert into actor values (1815,'John Kapelos');
insert into actor values (1816,'Madeleine Stowe');
insert into actor values (1817,'Frank Vincent (I)');
insert into actor values (1818,'Tony Todd (I)');
insert into actor values (1819,'Bill Irwin');
insert into actor values (1820,'David Spade');
insert into actor values (1821,'Julie Kavner');
insert into actor values (1822,'James LeGros');
insert into actor values (1823,'Deborah Rush');
insert into actor values (1824,'William Windom');
insert into actor values (1825,'David Hayman');
insert into actor values (1826,'David Thornton (I)');
insert into actor values (1827,'Laurie Metcalf');
insert into actor values (1828,'Elya Baskin');
insert into actor values (1829,'Mary McCormack');
insert into actor values (1830,'Heather Matarazzo');
insert into actor values (1831,'Adam Baldwin');
insert into actor values (1832,'Ed Begley Jr.');
insert into actor values (1833,'Edward Hardwicke');
insert into actor values (1834,'Bob Goldthwait');
insert into actor values (1835,'Patrick Magee (I)');
insert into actor values (1836,'Todd Allen');
insert into actor values (1837,'Blair Underwood');
insert into actor values (1838,'Tom ''Tiny'' Lister Jr.');
insert into actor values (1839,'Julia Louis-Dreyfus');
insert into actor values (1840,'Roma Maffia');
insert into actor values (1841,'Jacqueline Kim');
insert into actor values (1842,'Ricky Jay');
insert into actor values (1843,'Jack Nance');
insert into actor values (1844,'Michelle Johnson');
insert into actor values (1845,'Robert Webber (I)');
insert into actor values (1846,'Carlos Gómez (II)');
insert into actor values (1847,'John Hillerman');
insert into actor values (1848,'Natasha Gregson Wagner');
insert into actor values (1849,'Adrian Pasdar');
insert into actor values (1850,'Michael G. Hagerty');
--- tabactor, 1851, 50
insert into actor values (1851,'Ian McNeice');
insert into actor values (1852,'Brian O''Halloran');
insert into actor values (1853,'Paul Bates');
insert into actor values (1854,'Wes Studi');
insert into actor values (1855,'Kenneth Cranham');
insert into actor values (1856,'Zero Mostel');
insert into actor values (1857,'Tracey Ullman');
insert into actor values (1858,'Tom Guiry');
insert into actor values (1859,'Lillo Brancato');
insert into actor values (1860,'Billy Gilbert (I)');
insert into actor values (1861,'Victoria Rowell');
insert into actor values (1862,'Joe Berlinger');
insert into actor values (1863,'Klaus Maria Brandauer');
insert into actor values (1864,'Mel Smith');
insert into actor values (1865,'Wesley Addy');
insert into actor values (1866,'Mic Rodgers');
insert into actor values (1867,'Megan Ward');
insert into actor values (1868,'Suzy Amis');
insert into actor values (1869,'Ulrich Thomsen');
insert into actor values (1870,'Angel David');
insert into actor values (1871,'Brooke Shields');
insert into actor values (1872,'Artie Lange');
insert into actor values (1873,'Tara Reid');
insert into actor values (1874,'Benjamin Bratt');
insert into actor values (1875,'Amy Irving');
insert into actor values (1876,'''Weird Al'' Yankovic');
insert into actor values (1877,'Tony Danza');
insert into actor values (1878,'Mario Machado');
insert into actor values (1879,'Billie Whitelaw');
insert into actor values (1880,'Michael Elphick');
insert into actor values (1881,'Abe Vigoda');
insert into actor values (1882,'Sonny Bono');
insert into actor values (1883,'Bruno Ganz');
insert into actor values (1884,'Adrien Brody');
insert into actor values (1885,'Kevin Hooks');
insert into actor values (1886,'Werner Herzog');
insert into actor values (1887,'Judith Hoag');
insert into actor values (1888,'Tatum O''Neal');
insert into actor values (1889,'Louis Giambalvo');
insert into actor values (1890,'Andrew Dice Clay');
insert into actor values (1891,'Beah Richards');
insert into actor values (1892,'Leland Orser');
insert into actor values (1893,'Brian Thompson (I)');
insert into actor values (1894,'Brad Davis');
insert into actor values (1895,'Ted Levine');
insert into actor values (1896,'Michael Currie');
insert into actor values (1897,'Mark Pellington');
insert into actor values (1898,'Louise Lasser');
insert into actor values (1899,'Zak Orth');
insert into actor values (1900,'Brian McCardie');
--- tabactor, 1901, 50
insert into actor values (1901,'Leslie Carlson');
insert into actor values (1902,'Theresa Randle');
insert into actor values (1903,'Arnold Vosloo');
insert into actor values (1904,'Steve Railsback');
insert into actor values (1905,'Steve Whitmire');
insert into actor values (1906,'Cecil B. DeMille');
insert into actor values (1907,'Thandie Newton');
insert into actor values (1908,'Zach Galligan');
insert into actor values (1909,'Barry Dennen');
insert into actor values (1910,'Jon Seda');
insert into actor values (1911,'Barry Miller');
insert into actor values (1912,'Jurnee Smollett');
insert into actor values (1913,'Adam Goldberg');
insert into actor values (1914,'Terence Rigby');
insert into actor values (1915,'Leopold Stokowski');
insert into actor values (1916,'Cherie Lunghi');
insert into actor values (1917,'Larry Block');
insert into actor values (1918,'Stuart Wilson (II)');
insert into actor values (1919,'Julie Bowen');
insert into actor values (1920,'Arsenio Hall');
insert into actor values (1921,'Magda Szubanski');
insert into actor values (1922,'Bokeem Woodbine');
insert into actor values (1923,'Mathieu Kassovitz');
insert into actor values (1924,'John Witherspoon');
insert into actor values (1925,'Julia Stiles');
insert into actor values (1926,'John Duigan');
insert into actor values (1927,'Jake Kasdan');
insert into actor values (1928,'Sherilyn Fenn');
insert into actor values (1929,'Scott Caan');
insert into actor values (1930,'Oliver Parker (I)');
insert into actor values (1931,'Daryl Mitchell');
insert into actor values (1932,'James Brown (I)');
insert into actor values (1933,'Paul Reiser');
insert into actor values (1934,'Monica Potter');
insert into actor values (1935,'Heather Locklear');
insert into actor values (1936,'Dick Van Dyke');
insert into actor values (1937,'Sam Waterston');
insert into actor values (1938,'Jeanne Moreau');
insert into actor values (1939,'Sean McGinley');
insert into actor values (1940,'Peter Howitt (II)');
insert into actor values (1941,'Ron Carey');
insert into actor values (1942,'Osheen Jones');
insert into actor values (1943,'Hope Davis');
insert into actor values (1944,'Gretchen Mol');
insert into actor values (1945,'Roger Rees');
insert into actor values (1946,'Minoru Chiaki');
insert into actor values (1947,'Hope Lange');
insert into actor values (1948,'Jenny Agutter');
insert into actor values (1949,'Craig Bierko');
insert into actor values (1950,'Courtney B. Vance');
--- tabactor, 1951, 50
insert into actor values (1951,'Jeremy Davies');
insert into actor values (1952,'Guillermo Díaz');
insert into actor values (1953,'Ethan Suplee');
insert into actor values (1954,'Jamie Foxx');
insert into actor values (1955,'Jamie Uys');
insert into actor values (1956,'Richard O''Brien (I)');
insert into actor values (1957,'Saeed Jaffrey');
insert into actor values (1958,'Harvey Atkin');
insert into actor values (1959,'Penelope Allen');
insert into actor values (1960,'Fiona Shaw');
insert into actor values (1961,'Nicoletta Braschi');
insert into actor values (1962,'James Sikking');
insert into actor values (1963,'Richard Gant');
insert into actor values (1964,'David Alan Grier');
insert into actor values (1965,'Rick Ducommun');
insert into actor values (1966,'Djimon Hounsou');
insert into actor values (1967,'David Hyde Pierce');
insert into actor values (1968,'Nina Siemaszko');
insert into actor values (1969,'Russ Tamblyn');
insert into actor values (1970,'Harmony Korine');
insert into actor values (1971,'Roy Kinnear');
insert into actor values (1972,'Dennis Christopher');
insert into actor values (1973,'Norman Alden');
insert into actor values (1974,'Ric Young');
insert into actor values (1975,'Jean-Paul Belmondo');
insert into actor values (1976,'Erland Josephson');
insert into actor values (1977,'Jean-Pierre Léaud');
insert into actor values (1978,'Jason Patric');
insert into actor values (1979,'Glenn Shadix');
insert into actor values (1980,'J.A. Preston');
insert into actor values (1981,'Jim Haynie');
insert into actor values (1982,'Gregg Henry');
insert into actor values (1983,'Patrice Camhi');
insert into actor values (1984,'Jeremy Sisto');
insert into actor values (1985,'Jessie Royce Landis');
insert into actor values (1986,'Clarence Williams III');
insert into actor values (1987,'Roberta Maxwell');
insert into actor values (1988,'Dougray Scott');
insert into actor values (1989,'Robert J. Wilke');
insert into actor values (1990,'Robert Vaughn');
insert into actor values (1991,'Gerrit Graham');
insert into actor values (1992,'Pamela Segall');
insert into actor values (1993,'Cliff Gorman');
insert into actor values (1994,'Jack Gilpin');
insert into actor values (1995,'Jesse Bradford');
insert into actor values (1996,'Miki Manojlovic');
insert into actor values (1997,'Ione Skye');
insert into actor values (1998,'Julieta Serrano');
insert into actor values (1999,'Kenneth More');
insert into actor values (2000,'Barry Fitzgerald');
--- tabactor, 2001, 50
insert into actor values (2001,'Kaige Chen');
insert into actor values (2002,'Ken Hughes (I)');
insert into actor values (2003,'Anne Baxter');
insert into actor values (2004,'Ken Leung');
insert into actor values (2005,'Ken Stott');
insert into actor values (2006,'Kenneth Johnson (I)');
insert into actor values (2007,'Ken Sagoes');
insert into actor values (2008,'Henry Silva');
insert into actor values (2009,'Errol Flynn');
insert into actor values (2010,'Anne Parillaud');
insert into actor values (2011,'Juzo Itami');
insert into actor values (2012,'Henry Travers');
insert into actor values (2013,'Ilene Woods');
insert into actor values (2014,'Ernst Lubitsch');
insert into actor values (2015,'Fernando Trueba');
insert into actor values (2016,'Floyd Mutrux');
insert into actor values (2017,'Andrew Morahan');
insert into actor values (2018,'Irwin Allen');
insert into actor values (2019,'Edward Asner');
insert into actor values (2020,'Andrew Niccol');
insert into actor values (2021,'Andrew Sipes');
insert into actor values (2022,'Irene Grazioli');
insert into actor values (2023,'Andrzej Bartkowiak');
insert into actor values (2024,'Andy Wachowski');
insert into actor values (2025,'Julie Taymor');
insert into actor values (2026,'Andy Wilson (IV)');
insert into actor values (2027,'Edward Dmytryk');
insert into actor values (2028,'Julien Temple');
insert into actor values (2029,'Henry Koster');
insert into actor values (2030,'Fernanda Montenegro');
insert into actor values (2031,'Fax Bahr');
insert into actor values (2032,'Kevin Conroy');
insert into actor values (2033,'Anita Mui');
insert into actor values (2034,'Henry Bergman');
insert into actor values (2035,'F.W. Murnau');
insert into actor values (2036,'Ann Reinking');
insert into actor values (2037,'Kerry Fox');
insert into actor values (2038,'Edward D. Wood Jr.');
insert into actor values (2039,'Anthony Drazan');
insert into actor values (2040,'Henry Hathaway');
insert into actor values (2041,'Ernie Reyes Jr.');
insert into actor values (2042,'Irene Cara');
insert into actor values (2043,'Ash Brannon');
insert into actor values (2044,'Honor Blackman');
insert into actor values (2045,'Katsuhiro Ôtomo');
insert into actor values (2046,'Ate de Jong');
insert into actor values (2047,'Antony Sher');
insert into actor values (2048,'Arlene Sanford');
insert into actor values (2049,'Arletty');
insert into actor values (2050,'Elise Neal');
--- tabactor, 2051, 50
insert into actor values (2051,'Arne Glimcher');
insert into actor values (2052,'Ashley Laurence');
insert into actor values (2053,'Kathryn Erbe');
insert into actor values (2054,'Ken Finkleman');
insert into actor values (2055,'Arnold Alfredsson');
insert into actor values (2056,'Ian Charleson');
insert into actor values (2057,'Kate Reid');
insert into actor values (2058,'Elizabeth Hoffman');
insert into actor values (2059,'Arthur Penn');
insert into actor values (2060,'Emmanuelle Béart');
insert into actor values (2061,'Howard Franklin');
insert into actor values (2062,'Emily Bergl');
insert into actor values (2063,'Howard Stern');
insert into actor values (2064,'Art Garfunkel');
insert into actor values (2065,'Arthur Hill (I)');
insert into actor values (2066,'Hugh Jackman');
insert into actor values (2067,'Ellen Greene');
insert into actor values (2068,'Kate Maberly');
insert into actor values (2069,'Kelly LeBrock');
insert into actor values (2070,'Kamatari Fujiwara');
insert into actor values (2071,'Ken Howard (I)');
insert into actor values (2072,'Eric Darnell');
insert into actor values (2073,'Erick Zonca');
insert into actor values (2074,'Katherine Heigl');
insert into actor values (2075,'Efrem Zimbalist Jr.');
insert into actor values (2076,'Erich von Stroheim');
insert into actor values (2077,'Kelly Rowan');
insert into actor values (2078,'Hermione Baddeley');
insert into actor values (2079,'Anthony Lucero (I)');
insert into actor values (2080,'Kelly Makin');
insert into actor values (2081,'Eli Wallach');
insert into actor values (2082,'Anthony Quayle');
insert into actor values (2083,'Antonella Attili');
insert into actor values (2084,'Hettie MacDonald');
insert into actor values (2085,'Bajram Severdzan');
insert into actor values (2086,'Anthony Waller');
insert into actor values (2087,'Ian Michael Smith');
insert into actor values (2088,'Hill Harper');
insert into actor values (2089,'Eric Radomski');
insert into actor values (2090,'Eric Leighton');
insert into actor values (2091,'Antoine Fuqua');
insert into actor values (2092,'Austin Stoker');
insert into actor values (2093,'Eleanor Audley');
insert into actor values (2094,'Ernest R. Dickerson');
insert into actor values (2095,'Barry Bostwick');
insert into actor values (2096,'Leon Lai');
insert into actor values (2097,'Adrienne Shelly');
insert into actor values (2098,'Adrienne King');
insert into actor values (2099,'Leo McKern');
insert into actor values (2100,'Gene Lockhart');
--- tabactor, 2101, 50
insert into actor values (2101,'Geoffrey Wright (I)');
insert into actor values (2102,'Francesca Annis');
insert into actor values (2103,'George Armitage');
insert into actor values (2104,'Gaspard Manesse');
insert into actor values (2105,'Gregory Widen');
insert into actor values (2106,'Gregory Walcott');
insert into actor values (2107,'George Coe');
insert into actor values (2108,'Adriana Caselotti');
insert into actor values (2109,'George Dunning (II)');
insert into actor values (2110,'Adam Resnick');
insert into actor values (2111,'Leon Gast');
insert into actor values (2112,'Gary Sinyor');
insert into actor values (2113,'Alastair Sim');
insert into actor values (2114,'Gary Fleder');
insert into actor values (2115,'Alan Shapiro');
insert into actor values (2116,'Lee David Zlotoff');
insert into actor values (2117,'Gary Nelson');
insert into actor values (2118,'Gary Ross');
insert into actor values (2119,'Ajay Naidu');
insert into actor values (2120,'Lee Grant (I)');
insert into actor values (2121,'Gene Barry');
insert into actor values (2122,'Alan Myerson');
insert into actor values (2123,'Lee Remick');
insert into actor values (2124,'Alan Ladd');
insert into actor values (2125,'Alan Cohn');
insert into actor values (2126,'Gary Trousdale');
insert into actor values (2127,'George Huang');
insert into actor values (2128,'Grigori Aleksandrov');
insert into actor values (2129,'Gil Junger');
insert into actor values (2130,'George Harrison');
insert into actor values (2131,'Liam Cunningham');
insert into actor values (2132,'Gore Verbinski');
insert into actor values (2133,'Abel Ferrara');
insert into actor values (2134,'Gordon Parks');
insert into actor values (2135,'Gian Maria Volonté');
insert into actor values (2136,'Adam Arkin');
insert into actor values (2137,'Giancarlo Giannini');
insert into actor values (2138,'Lewis Milestone');
insert into actor values (2139,'Glenn Gordon Caron');
insert into actor values (2140,'Gillian Armstrong');
insert into actor values (2141,'Gladys Cooper');
insert into actor values (2142,'Giuseppe Tornatore');
insert into actor values (2143,'Élodie Bouchez');
insert into actor values (2144,'Linda Henry (I)');
insert into actor values (2145,'Lilia Skala');
insert into actor values (2146,'Adam Bernstein');
insert into actor values (2147,'Gary Cooper');
insert into actor values (2148,'George Lazenby');
insert into actor values (2149,'George Pal');
insert into actor values (2150,'Gregg Edelman');
--- tabactor, 2151, 50
insert into actor values (2151,'Lesli Linka Glatter');
insert into actor values (2152,'Gregg Araki');
insert into actor values (2153,'Liam Aiken');
insert into actor values (2154,'Leslie Cheung');
insert into actor values (2155,'Gregory Nava');
insert into actor values (2156,'Gerald Potterton');
insert into actor values (2157,'Adam Beach');
insert into actor values (2158,'Gert Fröbe');
insert into actor values (2159,'Grégoire Colin');
insert into actor values (2160,'Gore Vidal');
insert into actor values (2161,'Ghita Nørby');
insert into actor values (2162,'George Sluizer');
insert into actor values (2163,'Allison Anders');
insert into actor values (2164,'Hark Tsui');
insert into actor values (2165,'Amy Locane');
insert into actor values (2166,'Kirk Jones (III)');
insert into actor values (2167,'Kirk Wong');
insert into actor values (2168,'Harry Elfont');
insert into actor values (2169,'Francis Veber');
insert into actor values (2170,'Kimberly Williams (I)');
insert into actor values (2171,'Frank Overton');
insert into actor values (2172,'Kimberly Peirce');
insert into actor values (2173,'Harpo Marx');
insert into actor values (2174,'Frankie Muniz');
insert into actor values (2175,'Fraser Clarke Heston');
insert into actor values (2176,'Kris Isacsson');
insert into actor values (2177,'Kristina Adolphson');
insert into actor values (2178,'Guillermo del Toro');
insert into actor values (2179,'Kitty Winn');
insert into actor values (2180,'Amy Smart');
insert into actor values (2181,'Fran Rubel Kuzui');
insert into actor values (2182,'Heather Donahue');
insert into actor values (2183,'Kieu Chinh');
insert into actor values (2184,'François Girard');
insert into actor values (2185,'Haviland Morris');
insert into actor values (2186,'Anand Tucker');
insert into actor values (2187,'Kinka Usher');
insert into actor values (2188,'Amy Steel');
insert into actor values (2189,'Allan Corduner');
insert into actor values (2190,'Harve Foster');
insert into actor values (2191,'Harry Winer');
insert into actor values (2192,'Basil Rathbone');
insert into actor values (2193,'Kimberly Deauna Adams');
insert into actor values (2194,'Douglas McGrath (I)');
insert into actor values (2195,'Harry Hamlin');
insert into actor values (2196,'Franc Roddam');
insert into actor values (2197,'Lauren Graham');
insert into actor values (2198,'Fred Clark (I)');
insert into actor values (2199,'Alexander Payne');
insert into actor values (2200,'Alex Winter');
--- tabactor, 2201, 50
insert into actor values (2201,'Alex Karras');
insert into actor values (2202,'Gabriele Ferzetti');
insert into actor values (2203,'Alex Désert');
insert into actor values (2204,'Gérard Pirès');
insert into actor values (2205,'Guy Ritchie');
insert into actor values (2206,'Fritz Kiersch');
insert into actor values (2207,'Aleksander Bardini');
insert into actor values (2208,'Alek Keshishian');
insert into actor values (2209,'Gabrielle Anwar');
insert into actor values (2210,'Gustav Botz');
insert into actor values (2211,'Albert Magnoli');
insert into actor values (2212,'Kevin Williamson');
insert into actor values (2213,'Laura San Giacomo');
insert into actor values (2214,'Lance Guest');
insert into actor values (2215,'Allan Arkush');
insert into actor values (2216,'Hardie Albright');
insert into actor values (2217,'Fred M. Wilcox');
insert into actor values (2218,'Kyle T. Heffner');
insert into actor values (2219,'Kylie Minogue');
insert into actor values (2220,'Alison Crosbie');
insert into actor values (2221,'Gabriel Axel');
insert into actor values (2222,'Lainie Kazan');
insert into actor values (2223,'Gary Farmer');
insert into actor values (2224,'Hamilton Luske');
insert into actor values (2225,'Haley Joel Osment');
insert into actor values (2226,'Alfonso Cuarón');
insert into actor values (2227,'Fredric March');
insert into actor values (2228,'Alexandra Paul');
insert into actor values (2229,'Alexandra Dahlström');
insert into actor values (2230,'Alicia Witt');
insert into actor values (2231,'Darren Stein');
insert into actor values (2232,'Carl Schultz');
insert into actor values (2233,'Jean-Paul Rappeneau');
insert into actor values (2234,'Jean-Pierre Cassel');
insert into actor values (2235,'Jean-Pierre Jeunet');
insert into actor values (2236,'John Fortenberry');
insert into actor values (2237,'Carmen Maura');
insert into actor values (2238,'Carole Lombard');
insert into actor values (2239,'Carroll Ballard (I)');
insert into actor values (2240,'John Diehl');
insert into actor values (2241,'John Denver');
insert into actor values (2242,'John De Bello');
insert into actor values (2243,'Dave Thomas (I)');
insert into actor values (2244,'Catherine McCormack');
insert into actor values (2245,'Ben Sharpsteen');
insert into actor values (2246,'Cecilia Roth');
insert into actor values (2247,'Charles Crichton');
insert into actor values (2248,'Daniel Myrick');
insert into actor values (2249,'John Call (I)');
insert into actor values (2250,'Daniel Petrie');
--- tabactor, 2251, 50
insert into actor values (2251,'Charles Berling');
insert into actor values (2252,'John Cornell');
insert into actor values (2253,'Daniel Petrie Jr.');
insert into actor values (2254,'Cathy Tyson');
insert into actor values (2255,'Cecil Kellaway');
insert into actor values (2256,'John Cassavetes');
insert into actor values (2257,'Jeff Kanew');
insert into actor values (2258,'Daphne Zuniga');
insert into actor values (2259,'Dario Argento');
insert into actor values (2260,'Byron Haskin');
insert into actor values (2261,'Jeffrey John Davis');
insert into actor values (2262,'Bronwen Hughes');
insert into actor values (2263,'David Arkin');
insert into actor values (2264,'David Hogan');
insert into actor values (2265,'John Irvin');
insert into actor values (2266,'David Huddleston');
insert into actor values (2267,'Jay Levey');
insert into actor values (2268,'Jean Gabin');
insert into actor values (2269,'David Kellogg');
insert into actor values (2270,'David Gulpilil');
insert into actor values (2271,'David Koepp');
insert into actor values (2272,'Jason James Richter');
insert into actor values (2273,'David M. Evans (I)');
insert into actor values (2274,'David Marshall Grant');
insert into actor values (2275,'Jason Bloom');
insert into actor values (2276,'Jason Biggs');
insert into actor values (2277,'Jason Schwartzman');
insert into actor values (2278,'John Gray (I)');
insert into actor values (2279,'Damon Santostefano');
insert into actor values (2280,'Jean-Marie Poiré');
insert into actor values (2281,'Burl Ives');
insert into actor values (2282,'David Carson (I)');
insert into actor values (2283,'David Dobkin');
insert into actor values (2284,'Jay Russell');
insert into actor values (2285,'Jean-Claude Dreyfus');
insert into actor values (2286,'Cantinflas');
insert into actor values (2287,'John Guillermin');
insert into actor values (2288,'David Emge');
insert into actor values (2289,'John Haycraft');
insert into actor values (2290,'Bruce Lee');
insert into actor values (2291,'Jean Seberg');
insert into actor values (2292,'Jean Renoir');
insert into actor values (2293,'Buddy Van Horn');
insert into actor values (2294,'Christopher Daniel Barnes');
insert into actor values (2295,'Jerome Robbins');
insert into actor values (2296,'Claude Sautet');
insert into actor values (2297,'Jesse Ventura');
insert into actor values (2298,'Christopher Leitch');
insert into actor values (2299,'Jocelyn Moorhouse');
insert into actor values (2300,'Joanna Pacula');
--- tabactor, 2301, 50
insert into actor values (2301,'Jodi Lyn O''Keefe');
insert into actor values (2302,'Jet Li');
insert into actor values (2303,'Joe Alves');
insert into actor values (2304,'Joe Belcher');
insert into actor values (2305,'Christopher Cain (I)');
insert into actor values (2306,'Christopher Ashley');
insert into actor values (2307,'Clint Howard');
insert into actor values (2308,'Dan Monahan (I)');
insert into actor values (2309,'Jerry Reed (I)');
insert into actor values (2310,'Jim True');
insert into actor values (2311,'Fred Dekker');
insert into actor values (2312,'Giuseppe Andrews');
insert into actor values (2313,'Claire Trevor');
insert into actor values (2314,'Jim Fall');
insert into actor values (2315,'Jim McBride');
insert into actor values (2316,'Joanne Whalley');
insert into actor values (2317,'Jim Drake (II)');
insert into actor values (2318,'Clu Gulager');
insert into actor values (2319,'Cindy Williams (I)');
insert into actor values (2320,'Claude Berri');
insert into actor values (2321,'Joan Fontaine');
insert into actor values (2322,'Chuck Pfarrer');
insert into actor values (2323,'Christopher Monger');
insert into actor values (2324,'Christopher McQuarrie');
insert into actor values (2325,'Jim Sharman');
insert into actor values (2326,'Cyril O''Reilly');
insert into actor values (2327,'Clive Barker');
insert into actor values (2328,'Joey Travolta');
insert into actor values (2329,'Chico Marx');
insert into actor values (2330,'John Ales');
insert into actor values (2331,'Jennifer O''Neill (I)');
insert into actor values (2332,'Joey Cramer');
insert into actor values (2333,'Jennifer Lien');
insert into actor values (2334,'Chris Buck (II)');
insert into actor values (2335,'John Baddeley');
insert into actor values (2336,'Dale Midkiff');
insert into actor values (2337,'Damien O''Donnell');
insert into actor values (2338,'John Beck (II)');
insert into actor values (2339,'Jennifer Chambers Lynch');
insert into actor values (2340,'Jared Rushton');
insert into actor values (2341,'Cy Endfield');
insert into actor values (2342,'Chris Smith (II)');
insert into actor values (2343,'Clyde Bruckman');
insert into actor values (2344,'Christine Cavanaugh');
insert into actor values (2345,'Christian Nyby');
insert into actor values (2346,'Christian Duguay (I)');
insert into actor values (2347,'Christian Duguay');
insert into actor values (2348,'Courtney Gains');
insert into actor values (2349,'Chris Young (I)');
insert into actor values (2350,'Jeni Courtney');
--- tabactor, 2351, 50
insert into actor values (2351,'Joe Pytka');
insert into actor values (2352,'Chris Roberts (II)');
insert into actor values (2353,'Chris Noonan');
insert into actor values (2354,'Chris Kattan');
insert into actor values (2355,'Chris Eyre');
insert into actor values (2356,'Jeremy Leven');
insert into actor values (2357,'Christian Clavier');
insert into actor values (2358,'Joseph McGinty Nichol');
insert into actor values (2359,'Don McKellar');
insert into actor values (2360,'Dolph Lundgren');
insert into actor values (2361,'Bill Thompson (I)');
insert into actor values (2362,'Dominic Sena');
insert into actor values (2363,'Jacob Sewell');
insert into actor values (2364,'Joseph Fiennes');
insert into actor values (2365,'Bill Condon');
insert into actor values (2366,'Jake Gyllenhaal');
insert into actor values (2367,'Joseph Melito');
insert into actor values (2368,'Jackie Mason');
insert into actor values (2369,'Bill Bernstein');
insert into actor values (2370,'Biff McGuire');
insert into actor values (2371,'Betty Buckley');
insert into actor values (2372,'Dian Bachar');
insert into actor values (2373,'Don Coscarelli');
insert into actor values (2374,'James Bond');
insert into actor values (2375,'Jason Bateman');
insert into actor values (2376,'Boaz Yakin');
insert into actor values (2377,'Diane Baker');
insert into actor values (2378,'Jonathan Darby');
insert into actor values (2379,'Bo Derek');
insert into actor values (2380,'Jacqueline McKenzie (I)');
insert into actor values (2381,'Björk');
insert into actor values (2382,'Don Roos');
insert into actor values (2383,'Bing Crosby');
insert into actor values (2384,'Dolly Parton');
insert into actor values (2385,'Jake Scott (II)');
insert into actor values (2386,'Jonathan Silverman');
insert into actor values (2387,'Jordana Brewster');
insert into actor values (2388,'Josef Rusnak');
insert into actor values (2389,'James Bridges (I)');
insert into actor values (2390,'Julian Schnabel');
insert into actor values (2391,'Don Gordon (I)');
insert into actor values (2392,'Judy Parfitt');
insert into actor values (2393,'Jack Carson (I)');
insert into actor values (2394,'Jace Alexander (I)');
insert into actor values (2395,'Duane Jones (I)');
insert into actor values (2396,'Jack Kruschen');
insert into actor values (2397,'Eamonn Owens');
insert into actor values (2398,'Drew Desmarais');
insert into actor values (2399,'Beeban Kidron');
insert into actor values (2400,'Ivo Caprino');
--- tabactor, 2401, 50
insert into actor values (2401,'Isao Takahata');
insert into actor values (2402,'Julie Carmen');
insert into actor values (2403,'Isabelle Huppert');
insert into actor values (2404,'Beau Bridges');
insert into actor values (2405,'J.L. Reate');
insert into actor values (2406,'Benny Chan');
insert into actor values (2407,'Josh Evans');
insert into actor values (2408,'Donald Adeosun Faison');
insert into actor values (2409,'Jack Thibeau');
insert into actor values (2410,'Donna Murphy');
insert into actor values (2411,'Bess Armstrong');
insert into actor values (2412,'Judy Garland');
insert into actor values (2413,'Benoît Poelvoorde');
insert into actor values (2414,'Dharmendra');
insert into actor values (2415,'Donna Reed');
insert into actor values (2416,'Dorian Harewood');
insert into actor values (2417,'Dorsey Wright');
insert into actor values (2418,'Douglas Aarniokoski');
insert into actor values (2419,'Ben Younger');
insert into actor values (2420,'Jim Gillespie (I)');
insert into actor values (2421,'Bernie Worrell');
insert into actor values (2422,'Brian Glover (I)');
insert into actor values (2423,'John Schultz (I)');
insert into actor values (2424,'John R. Leonetti');
insert into actor values (2425,'David S. Ward');
insert into actor values (2426,'James Wong (IV)');
insert into actor values (2427,'Brian Helgeland');
insert into actor values (2428,'Brian Kerwin');
insert into actor values (2429,'James Toback');
insert into actor values (2430,'Jamie Blanks');
insert into actor values (2431,'Brian Gilbert');
insert into actor values (2432,'Brian G. Hutton');
insert into actor values (2433,'David Swift (II)');
insert into actor values (2434,'Brian Desmond Hurst');
insert into actor values (2435,'David Wayne (I)');
insert into actor values (2436,'Bob Geldof');
insert into actor values (2437,'James Van Der Beek');
insert into actor values (2438,'Jane Curtin');
insert into actor values (2439,'Eduardo Noriega (II)');
insert into actor values (2440,'Brigitte Lin');
insert into actor values (2441,'Janni Brenn-Lowen');
insert into actor values (2442,'David Miller (II)');
insert into actor values (2443,'Jane Powell (III)');
insert into actor values (2444,'John Patrick Shanley');
insert into actor values (2445,'David Mirkin (I)');
insert into actor values (2446,'James Robinson (II)');
insert into actor values (2447,'David Nutter');
insert into actor values (2448,'John N. Smith');
insert into actor values (2449,'Brian Narelle');
insert into actor values (2450,'Jane Birkin');
--- tabactor, 2451, 50
insert into actor values (2451,'Jan Kounen');
insert into actor values (2452,'John Pasquin');
insert into actor values (2453,'Brian Robbins (I)');
insert into actor values (2454,'Denys Arcand');
insert into actor values (2455,'Brett Leonard');
insert into actor values (2456,'Jojo Marr');
insert into actor values (2457,'James Farentino');
insert into actor values (2458,'Bodil Jørgensen');
insert into actor values (2459,'Bobby Farrelly');
insert into actor values (2460,'James Franciscus');
insert into actor values (2461,'Bob Spiers');
insert into actor values (2462,'James Frawley');
insert into actor values (2463,'Deran Sarafian');
insert into actor values (2464,'Bob Saget');
insert into actor values (2465,'James Donald (I)');
insert into actor values (2466,'Des McAnuff');
insert into actor values (2467,'Bob Rafelson');
insert into actor values (2468,'Desmond Davis (I)');
insert into actor values (2469,'James Eckhouse');
insert into actor values (2470,'James Olson');
insert into actor values (2471,'Debbie Harry');
insert into actor values (2472,'Brenda Chapman');
insert into actor values (2473,'John Sturges');
insert into actor values (2474,'John Swanbeck');
insert into actor values (2475,'Debbie Reynolds');
insert into actor values (2476,'Dennis Dun');
insert into actor values (2477,'Bradford Dillman');
insert into actor values (2478,'David McNally (II)');
insert into actor values (2479,'James Merendino');
insert into actor values (2480,'Brad Bird');
insert into actor values (2481,'Deborah Theaker');
insert into actor values (2482,'Dennis Boutsikaris');
insert into actor values (2483,'Boris Sagal');
insert into actor values (2484,'Boris Karloff');
insert into actor values (2485,'Brandon Lee');
insert into actor values (2486,'Olivia de Havilland');
insert into actor values (2487,'Linda Kozlowski');
insert into actor values (2488,'Orlando Jones');
insert into actor values (2489,'Sally Potter');
insert into actor values (2490,'Ono Fleischer');
insert into actor values (2491,'Robert Iscove');
insert into actor values (2492,'Marshall Herskovitz');
insert into actor values (2493,'Robert Harmon (I)');
insert into actor values (2494,'Téa Leoni');
insert into actor values (2495,'Sam Bottoms');
insert into actor values (2496,'Oliver Robins');
insert into actor values (2497,'Victoria Jackson (I)');
insert into actor values (2498,'Marlon Wayans');
insert into actor values (2499,'Oleg Menshikov');
insert into actor values (2500,'Vincent Ward');
--- tabactor, 2501, 50
insert into actor values (2501,'Marleen Gorris');
insert into actor values (2502,'Robert Kurtzman');
insert into actor values (2503,'Nigel Cole');
insert into actor values (2504,'Paige Turco');
insert into actor values (2505,'Vincent Gardenia');
insert into actor values (2506,'Mark McKinney (I)');
insert into actor values (2507,'Mark Patton');
insert into actor values (2508,'Paige O''Hara');
insert into actor values (2509,'Sean S. Cunningham');
insert into actor values (2510,'Mark S. Waters');
insert into actor values (2511,'Mark Watson (II)');
insert into actor values (2512,'Mark Steven Johnson');
insert into actor values (2513,'Richard Franklin');
insert into actor values (2514,'Mark Stewart (I)');
insert into actor values (2515,'Mark Tarlov');
insert into actor values (2516,'Robert Joy (I)');
insert into actor values (2517,'Robert Greenwald');
insert into actor values (2518,'Mark Rydell');
insert into actor values (2519,'Nigel Terry');
insert into actor values (2520,'Marvin Chatinover');
insert into actor values (2521,'Robert Donat');
insert into actor values (2522,'Nikolaj Coster-Waldau');
insert into actor values (2523,'Mary Costa');
insert into actor values (2524,'Tanya Roberts');
insert into actor values (2525,'Victoria Abril');
insert into actor values (2526,'Richard Loncraine');
insert into actor values (2527,'Vernon Wells');
insert into actor values (2528,'Tarsem Singh');
insert into actor values (2529,'Robert Crumb');
insert into actor values (2530,'Nigel Havers');
insert into actor values (2531,'Mary Harron');
insert into actor values (2532,'Sam Wood');
insert into actor values (2533,'Rena Owen');
insert into actor values (2534,'Nikolai Grinko');
insert into actor values (2535,'Norbert Auerbach');
insert into actor values (2536,'Takeshi Kaneshiro');
insert into actor values (2537,'Talisa Soto');
insert into actor values (2538,'Victor Sjöström');
insert into actor values (2539,'Martin Campbell');
insert into actor values (2540,'Victor Salva');
insert into actor values (2541,'Victor Nunez');
insert into actor values (2542,'Sam Mendes');
insert into actor values (2543,'Tamara Jenkins');
insert into actor values (2544,'Marv Newland');
insert into actor values (2545,'Nomadlozi Kubheka');
insert into actor values (2546,'Vicki Lewis');
insert into actor values (2547,'Noah Hathaway');
insert into actor values (2548,'Marty Feldman');
insert into actor values (2549,'Vic Morrow');
insert into actor values (2550,'Sal Mineo');
--- tabactor, 2551, 50
insert into actor values (2551,'Martin Rosen (I)');
insert into actor values (2552,'Paul Auster');
insert into actor values (2553,'Robert Strauss (I)');
insert into actor values (2554,'Maria Bello');
insert into actor values (2555,'Walter Pidgeon');
insert into actor values (2556,'Paul Brickman');
insert into actor values (2557,'Rupert Wainwright');
insert into actor values (2558,'W.D. Richter');
insert into actor values (2559,'Walter Levine');
insert into actor values (2560,'Walter Salles');
insert into actor values (2561,'Stuart Gordon');
insert into actor values (2562,'Patrick Wymark');
insert into actor values (2563,'Selma Blair');
insert into actor values (2564,'W.S. Van Dyke');
insert into actor values (2565,'Marilyn Burns');
insert into actor values (2566,'Pamela Anderson');
insert into actor values (2567,'Paul Bogart');
insert into actor values (2568,'Wenche Foss');
insert into actor values (2569,'Shari Albert');
insert into actor values (2570,'Marc Rocco');
insert into actor values (2571,'Steve James (II)');
insert into actor values (2572,'Marc Singer');
insert into actor values (2573,'Marcel Carné');
insert into actor values (2574,'Steve Rash');
insert into actor values (2575,'Steven Lisberger');
insert into actor values (2576,'Paul Freeman (I)');
insert into actor values (2577,'Steven Kloves');
insert into actor values (2578,'Steven Baigelman (II)');
insert into actor values (2579,'Margaret Sheridan');
insert into actor values (2580,'Margaret Whitton');
insert into actor values (2581,'Steven E. De Souza');
insert into actor values (2582,'Robert Towne');
insert into actor values (2583,'Mario Adorf');
insert into actor values (2584,'Marcia Strassman');
insert into actor values (2585,'Vincenzo Natali');
insert into actor values (2586,'Robert Mulligan');
insert into actor values (2587,'Michelangelo Antonioni');
insert into actor values (2588,'Robert Moore (I)');
insert into actor values (2589,'Sönke Wortmann');
insert into actor values (2590,'Robert Longo');
insert into actor values (2591,'Patrick Macnee');
insert into actor values (2592,'Mark Christopher');
insert into actor values (2593,'Pat Proft');
insert into actor values (2594,'Søren Kragh-Jacobsen');
insert into actor values (2595,'Susanne Lothar');
insert into actor values (2596,'Mark Herman (I)');
insert into actor values (2597,'Vincente Minnelli');
insert into actor values (2598,'Mark Illsley');
insert into actor values (2599,'Paris Barclay');
insert into actor values (2600,'Pascal Benezech');
--- tabactor, 2601, 50
insert into actor values (2601,'Patricia Birch');
insert into actor values (2602,'Patricia Wettig');
insert into actor values (2603,'Sebastian Rice-Edwards');
insert into actor values (2604,'Marion Mack');
insert into actor values (2605,'Robert Rossen');
insert into actor values (2606,'Richard Brooks (I)');
insert into actor values (2607,'Sebastian Cabot');
insert into actor values (2608,'Robert Oliveri');
insert into actor values (2609,'Viveca Lindfors');
insert into actor values (2610,'Pat O''Connor (I)');
insert into actor values (2611,'Marius Weyers');
insert into actor values (2612,'Patrice Leconte');
insert into actor values (2613,'Patrice Chéreau');
insert into actor values (2614,'Mark A.Z. Dippé');
insert into actor values (2615,'Susan Seidelman');
insert into actor values (2616,'Robert Cornthwaite');
insert into actor values (2617,'Vivian Wu');
insert into actor values (2618,'Rick Rosenthal');
insert into actor values (2619,'Todd Phillips (I)');
insert into actor values (2620,'Mike Mitchell (VI)');
insert into actor values (2621,'Michael Goldenberg');
insert into actor values (2622,'Sarah Miles (I)');
insert into actor values (2623,'Rob Minkoff');
insert into actor values (2624,'Michael Hordern');
insert into actor values (2625,'Michael Haigney');
insert into actor values (2626,'Michael Corrente');
insert into actor values (2627,'Tom Ewell');
insert into actor values (2628,'Mike Hodges (I)');
insert into actor values (2629,'Michael Haneke');
insert into actor values (2630,'Mike Gabriel');
insert into actor values (2631,'Mikael Salomon');
insert into actor values (2632,'Mia Sara');
insert into actor values (2633,'Tom Dey');
insert into actor values (2634,'Scott Kalvert');
insert into actor values (2635,'Vera Miles');
insert into actor values (2636,'Tuesday Knight');
insert into actor values (2637,'Tsutomu Yamazaki');
insert into actor values (2638,'Mitsuo Iwata');
insert into actor values (2639,'Michael Bowen');
insert into actor values (2640,'Mitchell Lichtenstein');
insert into actor values (2641,'Troy Duffy');
insert into actor values (2642,'Tinto Brass');
insert into actor values (2643,'Milcho Manchevski');
insert into actor values (2644,'Tod Browning');
insert into actor values (2645,'Michael Cimino');
insert into actor values (2646,'Mili Avital');
insert into actor values (2647,'Todd Haynes');
insert into actor values (2648,'Michael Constantine');
insert into actor values (2649,'Tom Helmore');
insert into actor values (2650,'Tsutomu Tatsumi');
--- tabactor, 2651, 50
insert into actor values (2651,'Tony Bancroft');
insert into actor values (2652,'Michael Pressman');
insert into actor values (2653,'Tony Richardson (I)');
insert into actor values (2654,'Michael Rennie');
insert into actor values (2655,'Tony Randel');
insert into actor values (2656,'Tammy Lauren');
insert into actor values (2657,'Michael Hitchcock');
insert into actor values (2658,'Tony Lo Bianco');
insert into actor values (2659,'Michele Soavi');
insert into actor values (2660,'Ringo Starr');
insert into actor values (2661,'Tony Bill');
insert into actor values (2662,'Tony Curtis');
insert into actor values (2663,'Tony Kaye (I)');
insert into actor values (2664,'Risa Bramon Garcia');
insert into actor values (2665,'Michael Winterbottom');
insert into actor values (2666,'Michel Piccoli');
insert into actor values (2667,'Michael Moriarty');
insert into actor values (2668,'Miguel Sandoval (I)');
insert into actor values (2669,'Michael Jordan');
insert into actor values (2670,'Tom Mankiewicz');
insert into actor values (2671,'Michael Kirby');
insert into actor values (2672,'Mieko Harada');
insert into actor values (2673,'Rob Bowman (I)');
insert into actor values (2674,'Savage Steve Holland');
insert into actor values (2675,'Tom Stoppard');
insert into actor values (2676,'Michael Patrick Jann');
insert into actor values (2677,'Trace Beaulieu');
insert into actor values (2678,'Michael Nouri');
insert into actor values (2679,'Michael Oliver (I)');
insert into actor values (2680,'Tommy Lee Wallace');
insert into actor values (2681,'Michael Pataki');
insert into actor values (2682,'Timothy Balme');
insert into actor values (2683,'Riz Abbasi');
insert into actor values (2684,'Nelson Shin');
insert into actor values (2685,'Matt McCoy');
insert into actor values (2686,'Matt Reeves');
insert into actor values (2687,'Terry Ballard');
insert into actor values (2688,'Matt Williams (II)');
insert into actor values (2689,'Newt Arnold');
insert into actor values (2690,'Val Guest');
insert into actor values (2691,'Terry Hughes');
insert into actor values (2692,'Ted Post');
insert into actor values (2693,'Matthew Robbins (I)');
insert into actor values (2694,'Maud Adams');
insert into actor values (2695,'Terry Potter');
insert into actor values (2696,'Terry Zwigoff');
insert into actor values (2697,'Sean Chapman');
insert into actor values (2698,'Michael Anderson (I)');
insert into actor values (2699,'Matthew Bright');
insert into actor values (2700,'Vanessa L. Williams');
--- tabactor, 2701, 50
insert into actor values (2701,'Mary Lambert');
insert into actor values (2702,'Taye Diggs');
insert into actor values (2703,'Nick Metropolis');
insert into actor values (2704,'Nick Gomez');
insert into actor values (2705,'Mary Tyler Moore');
insert into actor values (2706,'Robert Clouse');
insert into actor values (2707,'Robert Butler (I)');
insert into actor values (2708,'Robert Carradine');
insert into actor values (2709,'Nicholas Rowe');
insert into actor values (2710,'Masatoshi Nagase');
insert into actor values (2711,'Sean Gullette');
insert into actor values (2712,'Masayuki Suo');
insert into actor values (2713,'Nicholas Webster');
insert into actor values (2714,'Ted Neeley');
insert into actor values (2715,'Neal Israel');
insert into actor values (2716,'Nick Castle (I)');
insert into actor values (2717,'Melvin Frank');
insert into actor values (2718,'Tilda Swinton');
insert into actor values (2719,'Melanie Brown (I)');
insert into actor values (2720,'Muhammad Ali');
insert into actor values (2721,'Tim Hill (III)');
insert into actor values (2722,'Melissa Joan Hart');
insert into actor values (2723,'Maureen O''Sullivan');
insert into actor values (2724,'Montgomery Clift');
insert into actor values (2725,'Scott Silver (I)');
insert into actor values (2726,'Menahem Golan');
insert into actor values (2727,'Tim Pope (I)');
insert into actor values (2728,'Tyrone Power');
insert into actor values (2729,'Rick Friedberg');
insert into actor values (2730,'Sara Gilbert (I)');
insert into actor values (2731,'Tushka Bergen');
insert into actor values (2732,'Morris Day');
insert into actor values (2733,'Scott Weinger');
insert into actor values (2734,'Ulu Grosbard');
insert into actor values (2735,'Ulrich Edel');
insert into actor values (2736,'Natasha Richardson');
insert into actor values (2737,'Max Pomeranc');
insert into actor values (2738,'Samy Naceri');
insert into actor values (2739,'Maxine Bahns');
insert into actor values (2740,'Mel Stuart');
insert into actor values (2741,'Natalya Bondarchuk');
insert into actor values (2742,'Mekhi Phifer');
insert into actor values (2743,'Thomas Carter (II)');
insert into actor values (2744,'Thomas Jay Ryan');
insert into actor values (2745,'Thomas Schlamme');
insert into actor values (2746,'Naomi Watts');
insert into actor values (2747,'Nancy Meyers');
insert into actor values (2748,'Robert Morley (I)');
insert into actor values (2749,'Robert Arkins');
insert into actor values (2750,'Poppy Montgomery');
--- tabactor, 2751, 50
insert into actor values (2751,'Wilhelmenia Fernandez');
insert into actor values (2752,'Roger Vadim');
insert into actor values (2753,'Youki Kudoh');
insert into actor values (2754,'Peter Bonerz');
insert into actor values (2755,'Shekhar Kapur');
insert into actor values (2756,'Roger Miller');
insert into actor values (2757,'Peter Cattaneo');
insert into actor values (2758,'Rod Daniel');
insert into actor values (2759,'Ronald Neame');
insert into actor values (2760,'Roger Michell');
insert into actor values (2761,'Ronald F. Maxwell');
insert into actor values (2762,'Peter Collinson');
insert into actor values (2763,'William Malone');
insert into actor values (2764,'Rossy de Palma');
insert into actor values (2765,'Roger Kumble');
insert into actor values (2766,'Polly Bergen');
insert into actor values (2767,'Lynn Whitfield');
insert into actor values (2768,'Rod Lurie');
insert into actor values (2769,'Ross Malinger');
insert into actor values (2770,'Peter Chelsom');
insert into actor values (2771,'Percy Adlon');
insert into actor values (2772,'Liz Gilles');
insert into actor values (2773,'Magali Noël');
insert into actor values (2774,'Sinbad');
insert into actor values (2775,'Stephen Kessler');
insert into actor values (2776,'Roy Ward Baker');
insert into actor values (2777,'Willard Carroll');
insert into actor values (2778,'Lochlyn Munro');
insert into actor values (2779,'Willard Huyck');
insert into actor values (2780,'Prince');
insert into actor values (2781,'Yves Montand');
insert into actor values (2782,'Lothaire Bluteau');
insert into actor values (2783,'Rémy Belvaux');
insert into actor values (2784,'Stephen Daldry');
insert into actor values (2785,'Régis Wargnier');
insert into actor values (2786,'Lonny Chapman');
insert into actor values (2787,'Randa Haines');
insert into actor values (2788,'Stephen Barker Turner');
insert into actor values (2789,'William Finley (I)');
insert into actor values (2790,'Lori Cardille');
insert into actor values (2791,'Willeke van Ammelrooy');
insert into actor values (2792,'Peter Lorre');
insert into actor values (2793,'Peter Hewitt (I)');
insert into actor values (2794,'Stacy Peralta');
insert into actor values (2795,'Luis Mandoki');
insert into actor values (2796,'Luis Barzaga');
insert into actor values (2797,'Rodman Flender');
insert into actor values (2798,'Rory Cochrane');
insert into actor values (2799,'Ray Milland');
insert into actor values (2800,'Yôji Matsuda');
--- tabactor, 2801, 50
insert into actor values (2801,'Lynn Redgrave');
insert into actor values (2802,'Peter Lord (I)');
insert into actor values (2803,'Lukas Moodysson');
insert into actor values (2804,'Peter MacDonald');
insert into actor values (2805,'Spiros Focás');
insert into actor values (2806,'Roger Christian');
insert into actor values (2807,'Phil Joanou');
insert into actor values (2808,'Peyton Reed');
insert into actor values (2809,'Peter R. Hunt (I)');
insert into actor values (2810,'Peter O''Fallon');
insert into actor values (2811,'Sophia Loren');
insert into actor values (2812,'Luigi Pistilli');
insert into actor values (2813,'Lou Reed');
insert into actor values (2814,'William Gates');
insert into actor values (2815,'Solomon Perel');
insert into actor values (2816,'Rebecca Pidgeon');
insert into actor values (2817,'Stanley Swerdlow');
insert into actor values (2818,'Ronee Blakley');
insert into actor values (2819,'Lou Adler');
insert into actor values (2820,'Sondra Locke');
insert into actor values (2821,'Pierre Batcheff');
insert into actor values (2822,'Peter H. Hunt');
insert into actor values (2823,'Peter Faiman');
insert into actor values (2824,'Ronny Yu');
insert into actor values (2825,'Peter Farrelly');
insert into actor values (2826,'Peter Firth');
insert into actor values (2827,'Roddy Piper');
insert into actor values (2828,'Philippe Noiret');
insert into actor values (2829,'Stan Dragoti');
insert into actor values (2830,'Yimou Zhang');
insert into actor values (2831,'Peter Friedman (I)');
insert into actor values (2832,'Raymond Massey (I)');
insert into actor values (2833,'Stefan Schwartz');
insert into actor values (2834,'Shelley Winters');
insert into actor values (2835,'Zbigniew Zamachowski');
insert into actor values (2836,'Zack Norman');
insert into actor values (2837,'Lisanne Falk');
insert into actor values (2838,'Sidney J. Furie');
insert into actor values (2839,'Lisa Blount');
insert into actor values (2840,'Ramón Menéndez (I)');
insert into actor values (2841,'Rachel Weisz');
insert into actor values (2842,'Stephen Surjik');
insert into actor values (2843,'Zachary David Cope');
insert into actor values (2844,'Lisa Banes');
insert into actor values (2845,'Yvette Mimieux');
insert into actor values (2846,'Ron Fricke');
insert into actor values (2847,'Steve Gordon (I)');
insert into actor values (2848,'Ramesh Sippy');
insert into actor values (2849,'Ralph Bakshi');
insert into actor values (2850,'Yvonne Furneaux');
--- tabactor, 2851, 50
insert into actor values (2851,'Ron Moody');
insert into actor values (2852,'Reginald Hudlin');
insert into actor values (2853,'Steve Carr (III)');
insert into actor values (2854,'Zakes Mokae');
insert into actor values (2855,'Paul McCartney');
insert into actor values (2856,'Ralph Macchio');
insert into actor values (2857,'Whit Stillman');
insert into actor values (2858,'Siem Vroom');
insert into actor values (2859,'Paul Weitz');
insert into actor values (2860,'Paul Weiland');
insert into actor values (2861,'Stephen Norrington');
insert into actor values (2862,'Paul Williams (III)');
insert into actor values (2863,'Robin Hardy');
insert into actor values (2864,'Lisa Gay Hamilton');
insert into actor values (2865,'Linden Ashby');
insert into actor values (2866,'Rachel True');
insert into actor values (2867,'Lisa Cholodenko');
insert into actor values (2868,'Rand Ravich');
insert into actor values (2869,'Lisa Boyle');
insert into actor values (2870,'Lindsay Lohan');
insert into actor values (2871,'María Barranco');
insert into actor values (2872,'Walter Gotell');
insert into actor values (2873,'Dana Ivey');
insert into actor values (2874,'Mark Margolis');
insert into actor values (2875,'Larry Hankin');
insert into actor values (2876,'Kevin Tighe');
insert into actor values (2877,'Mark Boone Junior');
insert into actor values (2878,'Robert Picardo');
insert into actor values (2879,'Richard Portnow');
insert into actor values (2880,'Norman Burton');
insert into actor values (2881,'Kenny Baker (I)');
insert into actor values (2882,'Jason Flemyng');
insert into actor values (2883,'Ian Wolfe');
insert into actor values (2884,'Dennis Burkley');
insert into actor values (2885,'Danielle Harris');
insert into actor values (2886,'Robin Bartlett');
insert into actor values (2887,'Jonathan Banks');
insert into actor values (2888,'Vincent Schiavelli');
insert into actor values (2889,'Don Calfa');
insert into actor values (2890,'J.C. Quinn');
insert into actor values (2891,'Richard Bright');
insert into actor values (2892,'Scott Paulin');
insert into actor values (2893,'Troy Evans');
insert into actor values (2894,'Scatman Crothers');
insert into actor values (2895,'Conchata Ferrell');
insert into actor values (2896,'John Capodice');
insert into actor values (2897,'Beatrice Winde');
insert into actor values (2898,'Brian Tarantina');
insert into actor values (2899,'Andy Romano');
insert into actor values (2900,'Amy Wright');
--- tabactor, 2901, 50
insert into actor values (2901,'Ron Dean');
insert into actor values (2902,'Connie Ray');
insert into actor values (2903,'Linda Harrison');
insert into actor values (2904,'Phyllida Law');
insert into actor values (2905,'Brock Peters');
insert into actor values (2906,'Lyle Lovett');
insert into actor values (2907,'Gene Canfield');
insert into actor values (2908,'Steven Hill (I)');
insert into actor values (2909,'James Saito');
insert into actor values (2910,'Matt Malloy (I)');
insert into actor values (2911,'Jay O. Sanders');
insert into actor values (2912,'Geoffrey Palmer');
insert into actor values (2913,'Fred Willard');
insert into actor values (2914,'Lee Tergesen');
insert into actor values (2915,'Philip Stone (I)');
insert into actor values (2916,'Elizabeth Lawrence');
insert into actor values (2917,'Jared Harris');
insert into actor values (2918,'Graham Stark');
insert into actor values (2919,'Victor Garber');
insert into actor values (2920,'Buck Henry');
insert into actor values (2921,'Bruce Mahler');
insert into actor values (2922,'Robert Miranda');
insert into actor values (2923,'Lin Shaye');
insert into actor values (2924,'Tony Plana');
insert into actor values (2925,'Martin Ferrero');
insert into actor values (2926,'Dick Van Patten');
insert into actor values (2927,'Steve Kahan');
insert into actor values (2928,'Earl Boen');
insert into actor values (2929,'Clive Merrison');
insert into actor values (2930,'Debra Monk');
insert into actor values (2931,'Tzi Ma');
insert into actor values (2932,'Mercedes Ruehl');
insert into actor values (2933,'Kathleen Freeman (I)');
insert into actor values (2934,'Stephanie Faracy');
insert into actor values (2935,'Ewen Bremner');
insert into actor values (2936,'Bo Hopkins');
insert into actor values (2937,'Alfred Molina');
insert into actor values (2938,'Patrick Van Horn');
insert into actor values (2939,'Leonard Rossiter');
insert into actor values (2940,'Stephen Spinella');
insert into actor values (2941,'Catherine Keener');
insert into actor values (2942,'John Finn');
insert into actor values (2943,'Michael Kitchen');
insert into actor values (2944,'George Wyner');
insert into actor values (2945,'Diane Ladd');
insert into actor values (2946,'Tsai Chin (I)');
insert into actor values (2947,'Stephen Root');
insert into actor values (2948,'Daniel Baldwin');
insert into actor values (2949,'Gerry Becker');
insert into actor values (2950,'Sheb Wooley');
--- tabactor, 2951, 50
insert into actor values (2951,'Susan Barnes');
insert into actor values (2952,'Gerry Bamman');
insert into actor values (2953,'Mena Suvari');
insert into actor values (2954,'Robin Thomas (I)');
insert into actor values (2955,'Chick Ortega');
insert into actor values (2956,'Dinah Manoff');
insert into actor values (2957,'John Fiedler (I)');
insert into actor values (2958,'Michael Richards');
insert into actor values (2959,'Ciarán Hinds');
insert into actor values (2960,'Matt Ross (I)');
insert into actor values (2961,'Dick O''Neill');
insert into actor values (2962,'Jerry Levine');
insert into actor values (2963,'Janet Carroll');
insert into actor values (2964,'Terry Alexander (I)');
insert into actor values (2965,'Jennifer Esposito');
insert into actor values (2966,'Dominic West');
insert into actor values (2967,'Jenny Wright');
insert into actor values (2968,'Leonardo Cimino');
insert into actor values (2969,'Valri Bromfield');
insert into actor values (2970,'R.G. Armstrong');
insert into actor values (2971,'Ralph Brown (I)');
insert into actor values (2972,'George DiCenzo');
insert into actor values (2973,'Leopoldo Trieste');
insert into actor values (2974,'Blair Brown');
insert into actor values (2975,'Rick Overton');
insert into actor values (2976,'Scarlett Johansson');
insert into actor values (2977,'Ray McAnally');
insert into actor values (2978,'Matt Adler');
insert into actor values (2979,'Jim Breuer');
insert into actor values (2980,'Michael A. Goorjian');
insert into actor values (2981,'David Andrews (I)');
insert into actor values (2982,'Esther Rolle');
insert into actor values (2983,'Barbara Barrie');
insert into actor values (2984,'John Lynch');
insert into actor values (2985,'Michael Murphy (I)');
insert into actor values (2986,'Clifton James');
insert into actor values (2987,'Don Lake');
insert into actor values (2988,'Michael Lombard');
insert into actor values (2989,'Graham Beckel');
insert into actor values (2990,'Joe Viterelli');
insert into actor values (2991,'Siobhan Fallon');
insert into actor values (2992,'Claire Forlani');
insert into actor values (2993,'Bill McCutcheon');
insert into actor values (2994,'Tom Wood (II)');
insert into actor values (2995,'John Michael Higgins');
insert into actor values (2996,'Bill Paterson (I)');
insert into actor values (2997,'Polly Holliday');
insert into actor values (2998,'Philippe Morier-Genoud');
insert into actor values (2999,'Evelyn Keyes');
insert into actor values (3000,'George Grizzard');
--- tabactor, 3001, 50
insert into actor values (3001,'Danny Mann (I)');
insert into actor values (3002,'Soon-Tek Oh');
insert into actor values (3003,'Meat Loaf');
insert into actor values (3004,'Janet Margolin');
insert into actor values (3005,'Arthur O''Connell');
insert into actor values (3006,'John Ratzenberger');
insert into actor values (3007,'Randall Batinkoff');
insert into actor values (3008,'Lolita Davidovich');
insert into actor values (3009,'Tim Kazurinsky');
insert into actor values (3010,'Morris Chestnut');
insert into actor values (3011,'Aeryk Egan');
insert into actor values (3012,'Portia de Rossi');
insert into actor values (3013,'Barbara Harris');
insert into actor values (3014,'Robert A. Silverman');
insert into actor values (3015,'Jason Bernard (I)');
insert into actor values (3016,'Barret Oliver');
insert into actor values (3017,'Harve Presnell');
insert into actor values (3018,'Peter Greene (I)');
insert into actor values (3019,'Gary Riley (I)');
insert into actor values (3020,'Harold Gould');
insert into actor values (3021,'Marilyn Sokol');
insert into actor values (3022,'Frank Welker');
insert into actor values (3023,'Dwier Brown');
insert into actor values (3024,'Dan Bell');
insert into actor values (3025,'Marley Shelton');
insert into actor values (3026,'Allan Rich (I)');
insert into actor values (3027,'Robert Stanton (II)');
insert into actor values (3028,'Renoly Santiago');
insert into actor values (3029,'Gabrielle Union');
insert into actor values (3030,'Kevin Dillon');
insert into actor values (3031,'L.Q. Jones');
insert into actor values (3032,'Paprika Steen');
insert into actor values (3033,'Byron Mann');
insert into actor values (3034,'Martin Mull');
insert into actor values (3035,'Robert Goulet');
insert into actor values (3036,'Harley Jane Kozak');
insert into actor values (3037,'Denise Y. Dowse');
insert into actor values (3038,'Richard Bradford (I)');
insert into actor values (3039,'Henry Daniell');
insert into actor values (3040,'Eddie Izzard');
insert into actor values (3041,'Christian Clemenson');
insert into actor values (3042,'Doug McGrath (I)');
insert into actor values (3043,'Jada Pinkett');
insert into actor values (3044,'Ingeborga Dapkunaite');
insert into actor values (3045,'Alexander Godunov');
insert into actor values (3046,'Gary Lewis (III)');
insert into actor values (3047,'Peter Arne');
insert into actor values (3048,'Henry Goodman');
insert into actor values (3049,'Mark Lenard');
insert into actor values (3050,'Daniel Benzali');
--- tabactor, 3051, 50
insert into actor values (3051,'Malik Yoba');
insert into actor values (3052,'Patrick Godfrey (I)');
insert into actor values (3053,'Pat Roach');
insert into actor values (3054,'Andrew Lowery');
insert into actor values (3055,'Dan Shor');
insert into actor values (3056,'Patti LuPone');
insert into actor values (3057,'Rodney Eastman');
insert into actor values (3058,'Susanna Thompson');
insert into actor values (3059,'Dylan Bruno');
insert into actor values (3060,'Ray McKinnon');
insert into actor values (3061,'Stacy Edwards');
insert into actor values (3062,'Amanda Wyss');
insert into actor values (3063,'Maddie Corman');
insert into actor values (3064,'Seann William Scott');
insert into actor values (3065,'Alan North');
insert into actor values (3066,'Heidi Schanz');
insert into actor values (3067,'Paul McCrane');
insert into actor values (3068,'Larry Joshua');
insert into actor values (3069,'Chris Haywood');
insert into actor values (3070,'Spencer Treat Clark');
insert into actor values (3071,'Charles Fleischer');
insert into actor values (3072,'Tamara Tunie');
insert into actor values (3073,'Brooke Langton');
insert into actor values (3074,'Lucas Black (II)');
insert into actor values (3075,'Mark Holton');
insert into actor values (3076,'Mary Mara');
insert into actor values (3077,'Mare Winningham');
insert into actor values (3078,'Jack Riley (II)');
insert into actor values (3079,'Derrick O''Connor');
insert into actor values (3080,'Nora Dunn');
insert into actor values (3081,'Marc Duret');
insert into actor values (3082,'Stephen Furst');
insert into actor values (3083,'Jenny McCarthy');
insert into actor values (3084,'Billy Green Bush');
insert into actor values (3085,'Eugene Roche (I)');
insert into actor values (3086,'Regina Taylor');
insert into actor values (3087,'Mindy Sterling');
insert into actor values (3088,'Patrick Labyorteaux');
insert into actor values (3089,'Susan May Pratt');
insert into actor values (3090,'Carrie Snodgress');
insert into actor values (3091,'Pauly Shore');
insert into actor values (3092,'Richard Brooks (II)');
insert into actor values (3093,'J. Pat O''Malley');
insert into actor values (3094,'Patricia Quinn (I)');
insert into actor values (3095,'Ramon Bieri');
insert into actor values (3096,'Stephen Lack');
insert into actor values (3097,'Jack Angel (I)');
insert into actor values (3098,'Susan Blakely');
insert into actor values (3099,'Richard Chamberlain');
insert into actor values (3100,'Carroll Baker');
--- tabactor, 3101, 50
insert into actor values (3101,'Patric Knowles');
insert into actor values (3102,'Chris Barnes (II)');
insert into actor values (3103,'Jack Albertson');
insert into actor values (3104,'Dan Hicks (I)');
insert into actor values (3105,'Clive Russell');
insert into actor values (3106,'Ian Richardson');
insert into actor values (3107,'Hugh Marlowe');
insert into actor values (3108,'Rae Dawn Chong');
insert into actor values (3109,'Hilary Gordon');
insert into actor values (3110,'Hugh Griffith (I)');
insert into actor values (3111,'Paul Henreid');
insert into actor values (3112,'Steve Rackman');
insert into actor values (3113,'Ralph Strait');
insert into actor values (3114,'Rik Mayall');
insert into actor values (3115,'Hugh Quarshie');
insert into actor values (3116,'Tone Loc');
insert into actor values (3117,'Michelle Forbes');
insert into actor values (3118,'Gérard Darmon');
insert into actor values (3119,'Jim Varney');
insert into actor values (3120,'Hoagy Carmichael');
insert into actor values (3121,'Renato Scarpa');
insert into actor values (3122,'Ernie Dingo');
insert into actor values (3123,'Ralph Carlsson');
insert into actor values (3124,'Charley Grapewin');
insert into actor values (3125,'Shannen Doherty');
insert into actor values (3126,'Ralph Meeker');
insert into actor values (3127,'Howard St. John');
insert into actor values (3128,'Estelle Parsons');
insert into actor values (3129,'Geraldine Fitzgerald');
insert into actor values (3130,'Rachael Leigh Cook');
insert into actor values (3131,'Scott Brady (I)');
insert into actor values (3132,'Richard Basehart');
insert into actor values (3133,'Clifton Collins Jr.');
insert into actor values (3134,'Miguel Bosé');
insert into actor values (3135,'Jessica Alba');
insert into actor values (3136,'Rhys Ifans');
insert into actor values (3137,'Paulette Goddard');
insert into actor values (3138,'Stephen Young (I)');
insert into actor values (3139,'Paula Kelly (I)');
insert into actor values (3140,'Mike Henry');
insert into actor values (3141,'Sig Ruman');
insert into actor values (3142,'Henry Rollins');
insert into actor values (3143,'Henry Thomas');
insert into actor values (3144,'Ian Abercrombie');
insert into actor values (3145,'Estelle Getty');
insert into actor values (3146,'Frederique Van Der Wal');
insert into actor values (3147,'Jim Carter (I)');
insert into actor values (3148,'Steven Bauer');
insert into actor values (3149,'Scott Bakula');
insert into actor values (3150,'Chad Everett');
--- tabactor, 3151, 50
insert into actor values (3151,'Burt Kwouk');
insert into actor values (3152,'Buzz Kilman');
insert into actor values (3153,'Fernando Fernán Gómez');
insert into actor values (3154,'Gates McFadden');
insert into actor values (3155,'Cindy Morgan');
insert into actor values (3156,'Richard Roxburgh');
insert into actor values (3157,'Stanislas Carré de Malberg');
insert into actor values (3158,'Harcourt Williams');
insert into actor values (3159,'Terry-Thomas');
insert into actor values (3160,'Buddy Hackett');
insert into actor values (3161,'James Gleason (I)');
insert into actor values (3162,'Oded Fehr');
insert into actor values (3163,'Daniel Gerroll');
insert into actor values (3164,'Scott Wolf (I)');
insert into actor values (3165,'Theodore Bikel');
insert into actor values (3166,'Scott Wilson (I)');
insert into actor values (3167,'Sean Pertwee');
insert into actor values (3168,'Naveen Andrews');
insert into actor values (3169,'Nathaniel Parker');
insert into actor values (3170,'Gordon Clapp (I)');
insert into actor values (3171,'T.K. Carter');
insert into actor values (3172,'Harold Perrineau Jr.');
insert into actor values (3173,'Perry Lopez');
insert into actor values (3174,'Taliesin Jaffe');
insert into actor values (3175,'Finlay Currie');
insert into actor values (3176,'Sophie Lee');
insert into actor values (3177,'Chuck Connors (I)');
insert into actor values (3178,'Peter Mayhew (II)');
insert into actor values (3179,'Nicol Williamson');
insert into actor values (3180,'Daniel Wyllie');
insert into actor values (3181,'Nigel Bruce');
insert into actor values (3182,'Sheryl Lee Ralph');
insert into actor values (3183,'Philip Davis (I)');
insert into actor values (3184,'Fiona Lewis');
insert into actor values (3185,'Noel Coward');
insert into actor values (3186,'Jane Kaczmarek');
insert into actor values (3187,'Natalie Trundy');
insert into actor values (3188,'Stacey Dash');
insert into actor values (3189,'Terrence Dashon Howard');
insert into actor values (3190,'Raymond Burr');
insert into actor values (3191,'Tantoo Cardinal');
insert into actor values (3192,'Daniel Olbrychski');
insert into actor values (3193,'François Chau');
insert into actor values (3194,'Fernando Rey');
insert into actor values (3195,'Richard Jaeckel');
insert into actor values (3196,'Brian McNamara');
insert into actor values (3197,'James Karen');
insert into actor values (3198,'Srdjan Todorovic');
insert into actor values (3199,'Queen Latifah');
insert into actor values (3200,'Gloria Reuben');
--- tabactor, 3201, 50
insert into actor values (3201,'Pamela Gidley');
insert into actor values (3202,'Carla Gugino');
insert into actor values (3203,'Suzanna Hamilton');
insert into actor values (3204,'Paolo Bonacelli');
insert into actor values (3205,'George Chakiris');
insert into actor values (3206,'Randall ''Tex'' Cobb');
insert into actor values (3207,'Monica Evans');
insert into actor values (3208,'Gary Dourdan');
insert into actor values (3209,'Jackie Earle Haley');
insert into actor values (3210,'Jack O''Halloran');
insert into actor values (3211,'Jackie Gayle');
insert into actor values (3212,'Timothy Dalton');
insert into actor values (3213,'Hattie McDaniel');
insert into actor values (3214,'Chris Owen (I)');
insert into actor values (3215,'Carol Cleveland');
insert into actor values (3216,'Heather Angel');
insert into actor values (3217,'Susan Tyrrell');
insert into actor values (3218,'Joan Chen');
insert into actor values (3219,'Chris Klein');
insert into actor values (3220,'R.D. Call');
insert into actor values (3221,'Jennifer Elise Cox');
insert into actor values (3222,'Park Overall');
insert into actor values (3223,'Nancy Marchand');
insert into actor values (3224,'Frances Fisher');
insert into actor values (3225,'Peter Dobson');
insert into actor values (3226,'Thomas Gibson (I)');
insert into actor values (3227,'Brendan Gleeson');
insert into actor values (3228,'Jean Hagen');
insert into actor values (3229,'Stefania Casini');
insert into actor values (3230,'Colin Friels');
insert into actor values (3231,'Jean Louisa Kelly');
insert into actor values (3232,'Richard T. Jones');
insert into actor values (3233,'Moroni Olsen');
insert into actor values (3234,'Peter Cushing');
insert into actor values (3235,'Heather O''Rourke');
insert into actor values (3236,'Clarence Felder');
insert into actor values (3237,'Randy Brooks (I)');
insert into actor values (3238,'Bradley Pierce');
insert into actor values (3239,'Candy Clark');
insert into actor values (3240,'Brad Sullivan');
insert into actor values (3241,'Sofie Gråbøl');
insert into actor values (3242,'Jacqueline Obradors');
insert into actor values (3243,'Dana Elcar');
insert into actor values (3244,'Peter Bull (I)');
insert into actor values (3245,'Suzanne Snyder');
insert into actor values (3246,'Jake Lloyd (I)');
insert into actor values (3247,'Marlene Dietrich');
insert into actor values (3248,'Elizabeth Ashley');
insert into actor values (3249,'Anna Quayle');
insert into actor values (3250,'David Sheiner');
--- tabactor, 3251, 50
insert into actor values (3251,'Vincent Spano');
insert into actor values (3252,'Julian Glover');
insert into actor values (3253,'David Schofield');
insert into actor values (3254,'Saïd Taghmaoui');
insert into actor values (3255,'Vince Vieluf');
insert into actor values (3256,'Mark Feuerstein');
insert into actor values (3257,'Joshua Rudoy');
insert into actor values (3258,'Anthony Dawson (I)');
insert into actor values (3259,'Martha Gehman');
insert into actor values (3260,'Josephine Hull');
insert into actor values (3261,'Anthony Higgins');
insert into actor values (3262,'Marina Sirtis');
insert into actor values (3263,'John de Lancie');
insert into actor values (3264,'Marita Geraghty');
insert into actor values (3265,'Justin Lazard');
insert into actor values (3266,'Kate Mulgrew');
insert into actor values (3267,'Melinda McGraw');
insert into actor values (3268,'Ruth White (II)');
insert into actor values (3269,'Robert Rusler');
insert into actor values (3270,'Marisa Berenson');
insert into actor values (3271,'Julie Bovasso');
insert into actor values (3272,'Kari Wuhrer');
insert into actor values (3273,'Sam Jaffe (I)');
insert into actor values (3274,'David Yip');
insert into actor values (3275,'Sarah Douglas (I)');
insert into actor values (3276,'Robert Peters (I)');
insert into actor values (3277,'John Castle (II)');
insert into actor values (3278,'Mark Blankfield');
insert into actor values (3279,'Julie Warner');
insert into actor values (3280,'Andy Devine (I)');
insert into actor values (3281,'John Mills (I)');
insert into actor values (3282,'Victor Buono');
insert into actor values (3283,'Matt Frewer');
insert into actor values (3284,'Sammy Davis Jr.');
insert into actor values (3285,'John Stockwell');
insert into actor values (3286,'John Harkins');
insert into actor values (3287,'Barbara Sukowa');
insert into actor values (3288,'Arsinée Khanjian');
insert into actor values (3289,'Arye Gross');
insert into actor values (3290,'Robbie Coltrane');
insert into actor values (3291,'B.B. King');
insert into actor values (3292,'David Hunt (II)');
insert into actor values (3293,'John McGiver (I)');
insert into actor values (3294,'John Marshall Jones');
insert into actor values (3295,'Meg Tilly');
insert into actor values (3296,'Megan Cavanagh');
insert into actor values (3297,'Valerie Chow');
insert into actor values (3298,'Arliss Howard');
insert into actor values (3299,'Anton Diffring');
insert into actor values (3300,'David Moscow');
--- tabactor, 3301, 50
insert into actor values (3301,'Barry Nelson (I)');
insert into actor values (3302,'David Morrissey');
insert into actor values (3303,'Michael Byrne');
insert into actor values (3304,'Jonathan Stark');
insert into actor values (3305,'Art Evans');
insert into actor values (3306,'Jonathan Lipnicki');
insert into actor values (3307,'Tracy Reed (I)');
insert into actor values (3308,'Jon Bon Jovi');
insert into actor values (3309,'Emmanuelle Seigner');
insert into actor values (3310,'Jon Abrahams');
insert into actor values (3311,'Mason Adams');
insert into actor values (3312,'Michael Angarano');
insert into actor values (3313,'Van Heflin');
insert into actor values (3314,'Jonathan Rhys-Meyers');
insert into actor values (3315,'Larry Drake');
insert into actor values (3316,'Laurence Luckinbill');
insert into actor values (3317,'Don Steele (I)');
insert into actor values (3318,'Rosalind Cash');
insert into actor values (3319,'Benny Hill');
insert into actor values (3320,'Donald F. Muhich');
insert into actor values (3321,'Larry Gilliard Jr.');
insert into actor values (3322,'David Clennon');
insert into actor values (3323,'Winston Chao');
insert into actor values (3324,'Yancy Butler');
insert into actor values (3325,'Larry B. Scott');
insert into actor values (3326,'Donald O''Connor');
insert into actor values (3327,'Lance Kinsey');
insert into actor values (3328,'Rosario Dawson');
insert into actor values (3329,'Luke Perry');
insert into actor values (3330,'Kate Hudson');
insert into actor values (3331,'Michael Patrick Carter');
insert into actor values (3332,'Erik King');
insert into actor values (3333,'Lisa Eilbacher');
insert into actor values (3334,'Adam LaVorgna');
insert into actor values (3335,'Joan Severance');
insert into actor values (3336,'Yvonne De Carlo');
insert into actor values (3337,'Roland Bertin');
insert into actor values (3338,'Leo Rossi (II)');
insert into actor values (3339,'Ritch Brinkley');
insert into actor values (3340,'Joanna Going');
insert into actor values (3341,'Laurence Mason');
insert into actor values (3342,'Leo Burmester');
insert into actor values (3343,'Lenore Banks');
insert into actor values (3344,'Lee Strasberg');
insert into actor values (3345,'Louis Calhern');
insert into actor values (3346,'Lawrence Dane');
insert into actor values (3347,'Rita Moreno');
insert into actor values (3348,'William Sage');
insert into actor values (3349,'Adrian Zmed');
insert into actor values (3350,'John Amos (I)');
--- tabactor, 3351, 50
insert into actor values (3351,'Debbi Morgan');
insert into actor values (3352,'Kent Williams');
insert into actor values (3353,'Amanda Peet');
insert into actor values (3354,'Marcus Gilbert');
insert into actor values (3355,'Eric Mabius');
insert into actor values (3356,'Wayne Newton');
insert into actor values (3357,'Michael Massee');
insert into actor values (3358,'Eartha Kitt');
insert into actor values (3359,'Wendy Hiller');
insert into actor values (3360,'Margarita Lozano');
insert into actor values (3361,'Ebbe Roe Smith');
insert into actor values (3362,'Maria de Medeiros');
insert into actor values (3363,'Maria Grazia Cucinotta');
insert into actor values (3364,'Russell Wong');
insert into actor values (3365,'Marian Seldes');
insert into actor values (3366,'Margaret Dumont');
insert into actor values (3367,'Alix Koromzay');
insert into actor values (3368,'Roscoe Karns');
insert into actor values (3369,'Roseanne');
insert into actor values (3370,'Dorothy Malone');
insert into actor values (3371,'Roxanne Hart');
insert into actor values (3372,'Kirk Baltz');
insert into actor values (3373,'William Devane');
insert into actor values (3374,'Alyssa Milano');
insert into actor values (3375,'Mae Questel');
insert into actor values (3376,'Wendy Makkena');
insert into actor values (3377,'Dwight Yoakam');
insert into actor values (3378,'Allen Payne (I)');
insert into actor values (3379,'Joe Turkel');
insert into actor values (3380,'Dyan Cannon');
insert into actor values (3381,'Kim Greist');
insert into actor values (3382,'Jack Kehler');
insert into actor values (3383,'Nicole Ari Parker');
insert into actor values (3384,'Sy Richardson');
insert into actor values (3385,'James Handy');
insert into actor values (3386,'Scott Thomson (I)');
insert into actor values (3387,'Kathleen Wilhoite');
insert into actor values (3388,'Robert Ridgely');
insert into actor values (3389,'Anna Levine (I)');
insert into actor values (3390,'John Qualen');
insert into actor values (3391,'Sab Shimono');
insert into actor values (3392,'Lee Garlington');
insert into actor values (3393,'George ''Buck'' Flower');
insert into actor values (3394,'José Zúñiga');
insert into actor values (3395,'Leslie Stefanson');
insert into actor values (3396,'Kurt Fuller');
insert into actor values (3397,'Rudy Bond');
insert into actor values (3398,'Barton Heyman');
insert into actor values (3399,'Carmen Argenziano');
insert into actor values (3400,'Raymond Cruz');
--- tabactor, 3401, 50
insert into actor values (3401,'Nancy Fish');
insert into actor values (3402,'Rosanna DeSoto');
insert into actor values (3403,'Lynne Thigpen');
insert into actor values (3404,'Courtney Love');
insert into actor values (3405,'Holt McCallany');
insert into actor values (3406,'Martin Clunes');
insert into actor values (3407,'Jacob Vargas');
insert into actor values (3408,'Michael Gaston');
insert into actor values (3409,'Max Perlich');
insert into actor values (3410,'Pepe Serna');
insert into actor values (3411,'Gregory Sporleder');
insert into actor values (3412,'Woodrow Parfrey');
insert into actor values (3413,'Michael Higgins (I)');
insert into actor values (3414,'Timothy Carhart');
insert into actor values (3415,'Geoffrey Blake');
insert into actor values (3416,'Jonathan Winters');
insert into actor values (3417,'Edie Adams');
insert into actor values (3418,'Sam McMurray');
insert into actor values (3419,'Peter Brocco');
insert into actor values (3420,'Alexa Vega');
insert into actor values (3421,'Norman Reedus');
insert into actor values (3422,'Reg E. Cathey');
insert into actor values (3423,'Sheila Kelley (I)');
insert into actor values (3424,'James Tolkan');
insert into actor values (3425,'Sophie Marceau');
insert into actor values (3426,'Alan Oppenheimer');
insert into actor values (3427,'Ellen Albertini Dow');
insert into actor values (3428,'Tommy Flanagan (I)');
insert into actor values (3429,'Jamie Farr');
insert into actor values (3430,'Jon Stewart');
insert into actor values (3431,'Ben Wright (I)');
insert into actor values (3432,'Bruce A. Young');
insert into actor values (3433,'Archie Hahn');
insert into actor values (3434,'Eve Arden');
insert into actor values (3435,'Mary Kay Bergman');
insert into actor values (3436,'Raynor Scheine');
insert into actor values (3437,'Robert Costanzo');
insert into actor values (3438,'Alida Valli');
insert into actor values (3439,'Peter Dvorsky (I)');
insert into actor values (3440,'Kimberly Scott');
insert into actor values (3441,'Laraine Newman');
insert into actor values (3442,'Steven Wright (I)');
insert into actor values (3443,'Mink Stole');
insert into actor values (3444,'Jack Murdock');
insert into actor values (3445,'Todd Louiso');
insert into actor values (3446,'Susan Traylor');
insert into actor values (3447,'Rick Zumwalt');
insert into actor values (3448,'Carolyn Jones (I)');
insert into actor values (3449,'Paul Calderon');
insert into actor values (3450,'Paul Herman');
--- tabactor, 3451, 50
insert into actor values (3451,'J.K. Simmons');
insert into actor values (3452,'Anna Deavere Smith');
insert into actor values (3453,'Tom Heaton');
insert into actor values (3454,'Richard C. Sarafian');
insert into actor values (3455,'Andy Dick');
insert into actor values (3456,'Vivica A. Fox');
insert into actor values (3457,'Emily Mortimer');
insert into actor values (3458,'Fred Asparagus');
insert into actor values (3459,'Richard Boes');
insert into actor values (3460,'Kate McGregor-Stewart');
insert into actor values (3461,'John Beasley');
insert into actor values (3462,'Milton Berle');
insert into actor values (3463,'Denise Crosby');
insert into actor values (3464,'Kim Robillard');
insert into actor values (3465,'Chris Ellis (I)');
insert into actor values (3466,'Art LaFleur');
insert into actor values (3467,'Helen Shaver');
insert into actor values (3468,'Stephen Pearlman');
insert into actor values (3469,'Tobin Bell');
insert into actor values (3470,'Charles Gray (I)');
insert into actor values (3471,'Malcolm Danare');
insert into actor values (3472,'O-Lan Jones');
insert into actor values (3473,'Cherry Jones');
insert into actor values (3474,'Anne Haney');
insert into actor values (3475,'Wendy Schaal');
insert into actor values (3476,'Chauncey Leopardi');
insert into actor values (3477,'Gabriel Mann');
insert into actor values (3478,'Anna Maria Horsford');
insert into actor values (3479,'Charles Napier');
insert into actor values (3480,'Charles McKeown');
insert into actor values (3481,'Dub Taylor');
insert into actor values (3482,'Claire Skinner (I)');
insert into actor values (3483,'Arthur Malet');
insert into actor values (3484,'Time Winters');
insert into actor values (3485,'Jay Patterson (I)');
insert into actor values (3486,'Gregg Berger');
insert into actor values (3487,'Liam Dunn');
insert into actor values (3488,'Maureen Teefy');
insert into actor values (3489,'Simon MacCorkindale');
insert into actor values (3490,'Lauren Tom');
insert into actor values (3491,'Joanna Merlin');
insert into actor values (3492,'Aida Turturro');
insert into actor values (3493,'Lawrence Pressman');
insert into actor values (3494,'Bernie Casey');
insert into actor values (3495,'Thomas Kopache');
insert into actor values (3496,'Lee McCain');
insert into actor values (3497,'Beth Grant');
insert into actor values (3498,'David Hemmings (I)');
insert into actor values (3499,'John Putch');
insert into actor values (3500,'Robert Beatty (I)');
--- tabactor, 3501, 50
insert into actor values (3501,'Dimitra Arliss');
insert into actor values (3502,'Ralph Waite');
insert into actor values (3503,'Tyra Ferrell');
insert into actor values (3504,'Leigh French');
insert into actor values (3505,'George P. Wilbur');
insert into actor values (3506,'Ron Jeremy');
insert into actor values (3507,'Mandy Patinkin');
insert into actor values (3508,'Deirdre O''Connell');
insert into actor values (3509,'Kenneth Tobey');
insert into actor values (3510,'Amanda Bearse');
insert into actor values (3511,'Les Tremayne');
insert into actor values (3512,'Amanda De Cadenet');
insert into actor values (3513,'Howard Erskine');
insert into actor values (3514,'Henry Victor');
insert into actor values (3515,'Joey Slotnick');
insert into actor values (3516,'Tom O''Brien (II)');
insert into actor values (3517,'Ron Vawter');
insert into actor values (3518,'Kevin O''Morrison');
insert into actor values (3519,'David Bowe');
insert into actor values (3520,'Dody Goodman');
insert into actor values (3521,'Priscilla Pointer');
insert into actor values (3522,'Marcel Iures');
insert into actor values (3523,'Jihmi Kennedy');
insert into actor values (3524,'Roger Wilson (I)');
insert into actor values (3525,'Adrian Dunbar');
insert into actor values (3526,'Tom Riis Farrell');
insert into actor values (3527,'Curt Bois');
insert into actor values (3528,'Gia Carides');
insert into actor values (3529,'Loles León');
insert into actor values (3530,'Estelle Harris');
insert into actor values (3531,'Paul Geoffrey');
insert into actor values (3532,'Cress Williams');
insert into actor values (3533,'Horst Buchholz');
insert into actor values (3534,'Estelle Winwood');
insert into actor values (3535,'Roger Yuan');
insert into actor values (3536,'Michael Williams (I)');
insert into actor values (3537,'Deems Taylor');
insert into actor values (3538,'Traci Lind');
insert into actor values (3539,'Kenneth Welsh');
insert into actor values (3540,'Claudia Christian');
insert into actor values (3541,'Kerry Walker');
insert into actor values (3542,'Michael McShane (I)');
insert into actor values (3543,'Mickey Cottrell');
insert into actor values (3544,'Deborah Harmon');
insert into actor values (3545,'Rufus Thomas');
insert into actor values (3546,'Paul Benjamin');
insert into actor values (3547,'Ed Nelson (I)');
insert into actor values (3548,'Maria Pitillo');
insert into actor values (3549,'Zelda Rubinstein');
insert into actor values (3550,'Paul Ben-Victor');
--- tabactor, 3551, 50
insert into actor values (3551,'Raf Vallone');
insert into actor values (3552,'George Raft');
insert into actor values (3553,'Carole Shelley');
insert into actor values (3554,'Linda Bassett');
insert into actor values (3555,'Simon Jones (I)');
insert into actor values (3556,'Dina Merrill');
insert into actor values (3557,'Tracy Brooks Swope');
insert into actor values (3558,'Linda Hart');
insert into actor values (3559,'Patti D''Arbanville');
insert into actor values (3560,'Ingrid Pitt');
insert into actor values (3561,'George Macready');
insert into actor values (3562,'Sully Boyar');
insert into actor values (3563,'Patrick Malahide');
insert into actor values (3564,'Robert Ryan');
insert into actor values (3565,'Rob Campbell');
insert into actor values (3566,'Irving Metzman');
insert into actor values (3567,'Patrick Kilpatrick');
insert into actor values (3568,'Ricardo Montalban');
insert into actor values (3569,'Hugo Stanger');
insert into actor values (3570,'Cynthia Rhodes');
insert into actor values (3571,'Gerald R. Molen');
insert into actor values (3572,'Paul Greco');
insert into actor values (3573,'Gina Hecht');
insert into actor values (3574,'Zack Duhame');
insert into actor values (3575,'Wilfrid Hyde-White');
insert into actor values (3576,'Amrish Puri');
insert into actor values (3577,'Wendell Pierce');
insert into actor values (3578,'Traci Lords');
insert into actor values (3579,'Eric Lloyd');
insert into actor values (3580,'Ron O''Neal');
insert into actor values (3581,'Eszter Balint');
insert into actor values (3582,'R.M. Haley');
insert into actor values (3583,'Wayne Grace');
insert into actor values (3584,'Lewis Fitz-Gerald');
insert into actor values (3585,'Paul Dillon (I)');
insert into actor values (3586,'Lewis Martin (I)');
insert into actor values (3587,'Sarita Choudhury');
insert into actor values (3588,'Kel Mitchell');
insert into actor values (3589,'Anders Hove');
insert into actor values (3590,'Maria Aitken');
insert into actor values (3591,'Clifton Powell');
insert into actor values (3592,'Daisuke Katô (I)');
insert into actor values (3593,'Lisa Lu');
insert into actor values (3594,'Greg Collins (II)');
insert into actor values (3595,'Don Pedro Colley');
insert into actor values (3596,'Willie Garson');
insert into actor values (3597,'Gaylen Ross');
insert into actor values (3598,'Sasha Jenson');
insert into actor values (3599,'Michelle Meyrink');
insert into actor values (3600,'Laila Robins');
--- tabactor, 3601, 50
insert into actor values (3601,'Lacey Kohl');
insert into actor values (3602,'Geoffrey Keen');
insert into actor values (3603,'Stanley Brock');
insert into actor values (3604,'Rod Mullinar');
insert into actor values (3605,'Corey Burton');
insert into actor values (3606,'Michel Galabru');
insert into actor values (3607,'Akosua Busia');
insert into actor values (3608,'Lupe Ontiveros');
insert into actor values (3609,'Ricky Dean Logan');
insert into actor values (3610,'Devin Ratray');
insert into actor values (3611,'Bill Erwin (I)');
insert into actor values (3612,'Lea Salonga');
insert into actor values (3613,'Philippe Volter');
insert into actor values (3614,'Leah Ayres');
insert into actor values (3615,'Donovan Scott (I)');
insert into actor values (3616,'Alison Doody');
insert into actor values (3617,'Lumi Cavazos');
insert into actor values (3618,'Michael Taliferro');
insert into actor values (3619,'Ray Collins (I)');
insert into actor values (3620,'Roger Ashton-Griffiths');
insert into actor values (3621,'Michael Talbott');
insert into actor values (3622,'Ray Charles (I)');
insert into actor values (3623,'Laurel Cronin');
insert into actor values (3624,'Rosalind Chao');
insert into actor values (3625,'Jodi Long');
insert into actor values (3626,'Christopher Meloni');
insert into actor values (3627,'Gregory Smith (I)');
insert into actor values (3628,'Donald Gibb');
insert into actor values (3629,'Saveli Kramarov');
insert into actor values (3630,'Guy Boyd');
insert into actor values (3631,'Rodger Bumpass');
insert into actor values (3632,'Lucille Bliss');
insert into actor values (3633,'Derek de Lint');
insert into actor values (3634,'Michael Reid MacKay');
insert into actor values (3635,'Michelle Burke (I)');
insert into actor values (3636,'Tony Sirico');
insert into actor values (3637,'Larry Brandenburg');
insert into actor values (3638,'Joe Flaherty (I)');
insert into actor values (3639,'Michelan Sisti');
insert into actor values (3640,'Rodney A. Grant');
insert into actor values (3641,'Tomas Milian');
insert into actor values (3642,'Peter Maloney (I)');
insert into actor values (3643,'Ruben Santiago-Hudson');
insert into actor values (3644,'Leelee Sobieski');
insert into actor values (3645,'Alfie Bass');
insert into actor values (3646,'Leib Lensky');
insert into actor values (3647,'Diana Kent (I)');
insert into actor values (3648,'Heidi Kling');
insert into actor values (3649,'Joe Spinell');
insert into actor values (3650,'Jill Clayburgh');
--- tabactor, 3651, 50
insert into actor values (3651,'Kim Coates');
insert into actor values (3652,'Lenny von Dohlen');
insert into actor values (3653,'Corin Nemec');
insert into actor values (3654,'Chip Zien');
insert into actor values (3655,'Ernest Thesiger');
insert into actor values (3656,'Garcelle Beauvais');
insert into actor values (3657,'Skipp Sudduth');
insert into actor values (3658,'Kieran Mulroney');
insert into actor values (3659,'Gale Hansen');
insert into actor values (3660,'William Katt');
insert into actor values (3661,'Betty Lou Gerson');
insert into actor values (3662,'Keye Luke');
insert into actor values (3663,'Alison Folland');
insert into actor values (3664,'Chester Conklin');
insert into actor values (3665,'Kevin West');
insert into actor values (3666,'Colin Blakely');
insert into actor values (3667,'Red Buttons');
insert into actor values (3668,'Kris Kristofferson');
insert into actor values (3669,'Stuart Charno');
insert into actor values (3670,'Phyllis Applegate');
insert into actor values (3671,'Phyllis Logan');
insert into actor values (3672,'Peter Capaldi');
insert into actor values (3673,'Alex Rocco (I)');
insert into actor values (3674,'Cory Buck');
insert into actor values (3675,'Dexter Fletcher');
insert into actor values (3676,'Mabel King');
insert into actor values (3677,'Don Keefer');
insert into actor values (3678,'Lee Ving');
insert into actor values (3679,'Alexander Goodwin');
insert into actor values (3680,'Lorraine Toussaint');
insert into actor values (3681,'Macdonald Carey');
insert into actor values (3682,'Douglas Spencer');
insert into actor values (3683,'William Frankfather');
insert into actor values (3684,'Bill Kerr (I)');
insert into actor values (3685,'Roy Cooper');
insert into actor values (3686,'Rockets Redglare');
insert into actor values (3687,'Shirley Knight');
insert into actor values (3688,'Ritchie Singer');
insert into actor values (3689,'Chris Mulkey');
insert into actor values (3690,'Jimmy Yuill');
insert into actor values (3691,'Stephanie Roth');
insert into actor values (3692,'James Nesbitt');
insert into actor values (3693,'Thomas G. Waites');
insert into actor values (3694,'Jacques Mathou');
insert into actor values (3695,'Robert J. Steinmiller Jr.');
insert into actor values (3696,'Jay Brazeau');
insert into actor values (3697,'Sam Robards');
insert into actor values (3698,'Bob Peck (I)');
insert into actor values (3699,'Timothy Daly');
insert into actor values (3700,'Dana Wynter');
--- tabactor, 3701, 50
insert into actor values (3701,'Toby Huss');
insert into actor values (3702,'Ellie Raab');
insert into actor values (3703,'Brian Bedford');
insert into actor values (3704,'Matt Winston');
insert into actor values (3705,'Orson Bean');
insert into actor values (3706,'Elizabeth Moody');
insert into actor values (3707,'David Prowse');
insert into actor values (3708,'Mark Webber (II)');
insert into actor values (3709,'Elpidia Carrillo');
insert into actor values (3710,'Anne Ramsey');
insert into actor values (3711,'Robert Hy Gorman');
insert into actor values (3712,'Taral Hicks');
insert into actor values (3713,'Carl Anderson (II)');
insert into actor values (3714,'Dana Wheeler-Nicholson');
insert into actor values (3715,'Vincent Laresca');
insert into actor values (3716,'Barry Otto');
insert into actor values (3717,'John Dall');
insert into actor values (3718,'Jacob Reynolds');
insert into actor values (3719,'Arija Bareikis');
insert into actor values (3720,'Jay Villiers');
insert into actor values (3721,'Béatrice Dalle');
insert into actor values (3722,'Judy Greer');
insert into actor values (3723,'John Trudell');
insert into actor values (3724,'Matthew Faber');
insert into actor values (3725,'Mark Phelan');
insert into actor values (3726,'Dann Florek');
insert into actor values (3727,'Jonathan Ke Quan');
insert into actor values (3728,'Carel Struycken');
insert into actor values (3729,'Cara Seymour');
insert into actor values (3730,'Vincent Beck');
insert into actor values (3731,'Brian Backer');
insert into actor values (3732,'Richard Foronjy');
insert into actor values (3733,'Sean Sullivan (I)');
insert into actor values (3734,'John Doe (I)');
insert into actor values (3735,'Bud Cort');
insert into actor values (3736,'Tamala Jones');
insert into actor values (3737,'Norman Fell');
insert into actor values (3738,'Victor Jory (I)');
insert into actor values (3739,'John Shrapnel');
insert into actor values (3740,'Elisha Cook Jr.');
insert into actor values (3741,'Jason Beghe');
insert into actor values (3742,'Bryan Larkin');
insert into actor values (3743,'T.E. Russell');
insert into actor values (3744,'Tippi Hedren');
insert into actor values (3745,'Bob Elliott (I)');
insert into actor values (3746,'John Rothman');
insert into actor values (3747,'Joseph Bologna');
insert into actor values (3748,'Valente Rodriguez');
insert into actor values (3749,'Fern Persons');
insert into actor values (3750,'Mischa Barton');
--- tabactor, 3751, 50
insert into actor values (3751,'Darwin Joston');
insert into actor values (3752,'Daniel Hugh Kelly');
insert into actor values (3753,'Valeri Nikolayev');
insert into actor values (3754,'Robert Gossett');
insert into actor values (3755,'Elisabeth Moss');
insert into actor values (3756,'Jens Albinus');
insert into actor values (3757,'Jason Lively');
insert into actor values (3758,'Elina Löwensohn');
insert into actor values (3759,'Busta Rhymes');
insert into actor values (3760,'Oliver Smith (I)');
insert into actor values (3761,'Thelma Ritter');
insert into actor values (3762,'Barry Primus');
insert into actor values (3763,'Neva Patterson');
insert into actor values (3764,'Brian McConnachie');
insert into actor values (3765,'Mitchell Whitfield');
insert into actor values (3766,'Victor Slezak');
insert into actor values (3767,'John Ridgely');
insert into actor values (3768,'Victor Spinetti');
insert into actor values (3769,'James Madio');
insert into actor values (3770,'Kathy Griffin');
insert into actor values (3771,'Martin Benson');
insert into actor values (3772,'Neil Patrick Harris');
insert into actor values (3773,'Valérie Lemercier');
insert into actor values (3774,'Minna Gombell');
insert into actor values (3775,'Theresa Merritt');
insert into actor values (3776,'Elizabeth Mitchell');
insert into actor values (3777,'Mike Nussbaum');
insert into actor values (3778,'Brenda Bakke');
insert into actor values (3779,'Mary Louise Wilson');
insert into actor values (3780,'Dean Jones (I)');
insert into actor values (3781,'Jeep Swenson');
insert into actor values (3782,'Richard Marcus');
insert into actor values (3783,'J. Smith-Cameron');
insert into actor values (3784,'Brownie McGhee');
insert into actor values (3785,'Brandon Smith (I)');
insert into actor values (3786,'Vanessa Williams (I)');
insert into actor values (3787,'Marisol Nichols');
insert into actor values (3788,'Barbara Baxley');
insert into actor values (3789,'Fanny Ardant');
insert into actor values (3790,'Nick Searcy');
insert into actor values (3791,'Richard Tyson');
insert into actor values (3792,'Edward Brophy');
insert into actor values (3793,'John MacKay (I)');
insert into actor values (3794,'James Sloyan');
insert into actor values (3795,'Jeff Anderson (I)');
insert into actor values (3796,'Michael Berryman');
insert into actor values (3797,'Marisa Paredes');
insert into actor values (3798,'Tim Blake Nelson');
insert into actor values (3799,'Susan Anspach');
insert into actor values (3800,'Isaach De Bankolé');
--- tabactor, 3801, 50
insert into actor values (3801,'John Benjamin Hickey');
insert into actor values (3802,'Rick Aviles');
insert into actor values (3803,'Patrick Fontana');
insert into actor values (3804,'Patrick Field');
insert into actor values (3805,'Darren Dalton');
insert into actor values (3806,'Musetta Vander');
insert into actor values (3807,'Jamie Foreman');
insert into actor values (3808,'Jan Hooks');
insert into actor values (3809,'Fortunio Bonanova');
insert into actor values (3810,'Mel Winkler');
insert into actor values (3811,'Johnny Williams (I)');
insert into actor values (3812,'Richard Widmark');
insert into actor values (3813,'Tristine Skyler');
insert into actor values (3814,'Johnny Whitworth');
insert into actor values (3815,'Timothy Olyphant');
insert into actor values (3816,'Ted Ross (II)');
insert into actor values (3817,'Susan Fleetwood');
insert into actor values (3818,'Barbara Crampton');
insert into actor values (3819,'Edwina Moore');
insert into actor values (3820,'Jeremy Howard');
insert into actor values (3821,'Richard Davalos');
insert into actor values (3822,'Eileen Heckart');
insert into actor values (3823,'Thomas Haden Church');
insert into actor values (3824,'Monica Bellucci');
insert into actor values (3825,'Frank Bruynbroek');
insert into actor values (3826,'Pat Morita');
insert into actor values (3827,'John Clive');
insert into actor values (3828,'James Urbaniak');
insert into actor values (3829,'Sage Stallone');
insert into actor values (3830,'Dave Duffy');
insert into actor values (3831,'Art Metrano');
insert into actor values (3832,'Jeff Conaway');
insert into actor values (3833,'Brad Beyer');
insert into actor values (3834,'Ellen Hamilton Latzen');
insert into actor values (3835,'Todd Field');
insert into actor values (3836,'Kai Wulff');
insert into actor values (3837,'Ryan Hurst');
insert into actor values (3838,'Brent Briscoe');
insert into actor values (3839,'Jackie Burroughs');
insert into actor values (3840,'Emmanuel Xuereb');
insert into actor values (3841,'Jean Simmons');
insert into actor values (3842,'Robert Phalen');
insert into actor values (3843,'Caroline Hunt');
insert into actor values (3844,'Tim Holt');
insert into actor values (3845,'K. Todd Freeman');
insert into actor values (3846,'Vinnie Jones');
insert into actor values (3847,'Barbara Babcock (I)');
insert into actor values (3848,'Suzanne Krull');
insert into actor values (3849,'Julie Brown (I)');
insert into actor values (3850,'Michael Durrell');
--- tabactor, 3851, 50
insert into actor values (3851,'Nickolas Grace');
insert into actor values (3852,'Jean Marsh');
insert into actor values (3853,'Balthazar Getty');
insert into actor values (3854,'Thomas Rosales Jr.');
insert into actor values (3855,'Sanjeev Kumar (I)');
insert into actor values (3856,'Samm-Art Williams');
insert into actor values (3857,'Conrad Veidt');
insert into actor values (3858,'Scott Schwartz');
insert into actor values (3859,'Constance Collier');
insert into actor values (3860,'Daniel York');
insert into actor values (3861,'Daniel Zacapa');
insert into actor values (3862,'Desmond Askew');
insert into actor values (3863,'Derrick Branche');
insert into actor values (3864,'Constance Marie');
insert into actor values (3865,'Connie Booth');
insert into actor values (3866,'Connie Britton');
insert into actor values (3867,'Daniela Bianchi');
insert into actor values (3868,'Samia Shoaib');
insert into actor values (3869,'Sandra Milo');
insert into actor values (3870,'Diane Cilento');
insert into actor values (3871,'Coleen Gray');
insert into actor values (3872,'Diane Franklin');
insert into actor values (3873,'Ronald Allen');
insert into actor values (3874,'Danny Rosen (I)');
insert into actor values (3875,'Cole Sprouse');
insert into actor values (3876,'Shon Greenblatt');
insert into actor values (3877,'Saverio Guerra');
insert into actor values (3878,'Diane Salinger');
insert into actor values (3879,'Sidney Blackmer');
insert into actor values (3880,'Scott Sowers');
insert into actor values (3881,'David Kelly (I)');
insert into actor values (3882,'David Brisbin (I)');
insert into actor values (3883,'Sandy Dennis');
insert into actor values (3884,'Daragh Donnelly');
insert into actor values (3885,'Ron Smerczak');
insert into actor values (3886,'Darby Dougherty');
insert into actor values (3887,'Daria Kalinina');
insert into actor values (3888,'Dick Anthony Williams');
insert into actor values (3889,'Sandra Prinsloo');
insert into actor values (3890,'Dick Crockett');
insert into actor values (3891,'Dario D''Ambrosi');
insert into actor values (3892,'David Herman (I)');
insert into actor values (3893,'Darlene Cates');
insert into actor values (3894,'Ron Lester');
insert into actor values (3895,'Dara Tomanovich');
insert into actor values (3896,'Ronald Squire');
insert into actor values (3897,'David Harris (I)');
insert into actor values (3898,'Samuel Le Bihan');
insert into actor values (3899,'Ronnie Corbett');
insert into actor values (3900,'Shirley Eaton');
--- tabactor, 3901, 50
insert into actor values (3901,'David Blair (V)');
insert into actor values (3902,'Collin Wilcox Paxton');
insert into actor values (3903,'Screamin'' Jay Hawkins');
insert into actor values (3904,'Danny Denzongpa');
insert into actor values (3905,'Colleen Rennison');
insert into actor values (3906,'Colleen Fitzpatrick (I)');
insert into actor values (3907,'Colleen Dewhurst');
insert into actor values (3908,'David Huffman (I)');
insert into actor values (3909,'Samuele Amighetti');
insert into actor values (3910,'Danny Lloyd');
insert into actor values (3911,'Danny Elfman');
insert into actor values (3912,'Scott Williamson');
insert into actor values (3913,'Colin Firth');
insert into actor values (3914,'Colin Clive');
insert into actor values (3915,'Sandra Bernhard');
insert into actor values (3916,'Sandy Nelson (II)');
insert into actor values (3917,'David Johansen');
insert into actor values (3918,'Diana Peñalver');
insert into actor values (3919,'Diana Rigg');
insert into actor values (3920,'Sandra Hess');
insert into actor values (3921,'Danny Lee (I)');
insert into actor values (3922,'Shirley Douglas');
insert into actor values (3923,'Shirley Jones (I)');
insert into actor values (3924,'David Buck');
insert into actor values (3925,'Da Ying');
insert into actor values (3926,'Declan Croghan');
insert into actor values (3927,'Shani Wallis');
insert into actor values (3928,'Dan O''Bannon');
insert into actor values (3929,'Dan Moran (I)');
insert into actor values (3930,'Declan Hannigan');
insert into actor values (3931,'David Crawford (I)');
insert into actor values (3932,'Dee McCaffrey');
insert into actor values (3933,'Shane (II)');
insert into actor values (3934,'David Bennent');
insert into actor values (3935,'Seth Smith');
insert into actor values (3936,'Debra Feuer');
insert into actor values (3937,'Dan Marino');
insert into actor values (3938,'Sharon Taylor (I)');
insert into actor values (3939,'David Warrilow');
insert into actor values (3940,'Shari Hall');
insert into actor values (3941,'Daniel Okrent');
insert into actor values (3942,'Cristi Conaway');
insert into actor values (3943,'Sharon Tate');
insert into actor values (3944,'Curd Jürgens');
insert into actor values (3945,'Sharon Farrell');
insert into actor values (3946,'Cynthia Gibb');
insert into actor values (3947,'Curtis Gates');
insert into actor values (3948,'Seth Gilliam');
insert into actor values (3949,'Dana Ashbrook');
insert into actor values (3950,'David Forman (I)');
--- tabactor, 3951, 50
insert into actor values (3951,'Sarah Berry (I)');
insert into actor values (3952,'Dana Andrews');
insert into actor values (3953,'Rufus Beck');
insert into actor values (3954,'Shann Johnson');
insert into actor values (3955,'David Gale (I)');
insert into actor values (3956,'Seiji Miyaguchi');
insert into actor values (3957,'Dan Lauria');
insert into actor values (3958,'Damian Young');
insert into actor values (3959,'Ruth Brown');
insert into actor values (3960,'Ry Cooder');
insert into actor values (3961,'Debby Bishop');
insert into actor values (3962,'Sergio Castellitto');
insert into actor values (3963,'Sarah Peirse');
insert into actor values (3964,'Scott H. Reiniger');
insert into actor values (3965,'Damon D''Oliveira');
insert into actor values (3966,'Ruth Hussey');
insert into actor values (3967,'David Della Rocco');
insert into actor values (3968,'Sarah York');
insert into actor values (3969,'Ruth Nelson');
insert into actor values (3970,'Ruth Roman');
insert into actor values (3971,'Sergio Bini Bustric');
insert into actor values (3972,'Dale Grand');
insert into actor values (3973,'David Dukes');
insert into actor values (3974,'Rya Kihlstedt');
insert into actor values (3975,'Rumer Willis');
insert into actor values (3976,'Dawn Didawick');
insert into actor values (3977,'Deborah Shelton');
insert into actor values (3978,'Deborah Foreman (I)');
insert into actor values (3979,'Dale Dye');
insert into actor values (3980,'Shawn Andrews');
insert into actor values (3981,'De''voreaux White');
insert into actor values (3982,'Dean Jagger');
insert into actor values (3983,'Dave Finnegan');
insert into actor values (3984,'Scott Foley');
insert into actor values (3985,'Sessue Hayakawa');
insert into actor values (3986,'Dame May Whitty');
insert into actor values (3987,'Daisuke Ryu');
insert into actor values (3988,'Rosemary Murphy');
insert into actor values (3989,'Dennis Akayama');
insert into actor values (3990,'Dennis Rodman');
insert into actor values (3991,'Sean Lawlor');
insert into actor values (3992,'Corey Parker');
insert into actor values (3993,'David Mendenhall');
insert into actor values (3994,'Dennis Storhøi');
insert into actor values (3995,'Scott Neal');
insert into actor values (3996,'Roscoe Ates');
insert into actor values (3997,'David Conrad (I)');
insert into actor values (3998,'Rossella Falk');
insert into actor values (3999,'Corinne Clery');
insert into actor values (4000,'Seizaburô Kawazu');
--- tabactor, 4001, 50
insert into actor values (4001,'Daniel London');
insert into actor values (4002,'Sally Ann Howes');
insert into actor values (4003,'Rosemary Clooney');
insert into actor values (4004,'Daniel Richter (I)');
insert into actor values (4005,'Sami Bouajila');
insert into actor values (4006,'Sean Daniel');
insert into actor values (4007,'Daniel Southern');
insert into actor values (4008,'Daniel Shalikar');
insert into actor values (4009,'Samantha Lavigne');
insert into actor values (4010,'Daniel Pollock');
insert into actor values (4011,'Sean Kearns');
insert into actor values (4012,'Sara Kestelman');
insert into actor values (4013,'Scott Benjaminson');
insert into actor values (4014,'Denys Hawthorne');
insert into actor values (4015,'Daniel Prévost (I)');
insert into actor values (4016,'Coral Browne');
insert into actor values (4017,'Corbett Monica');
insert into actor values (4018,'David McKnight');
insert into actor values (4019,'Consuelo De Haviland');
insert into actor values (4020,'Daniel Ades');
insert into actor values (4021,'Roy Chiao');
insert into actor values (4022,'Salvador Dalí');
insert into actor values (4023,'Sally Yeh (I)');
insert into actor values (4024,'Sally Struthers');
insert into actor values (4025,'Sally Kellerman');
insert into actor values (4026,'Daniel Boulanger');
insert into actor values (4027,'Craig Smith (I)');
insert into actor values (4028,'Demian Slade');
insert into actor values (4029,'Shea Fowler');
insert into actor values (4030,'Rudy Basquez');
insert into actor values (4031,'Delphine French');
insert into actor values (4032,'Dana Stubblefield');
insert into actor values (4033,'Del Henney');
insert into actor values (4034,'Dana Hill (I)');
insert into actor values (4035,'Sally Anne Newton');
insert into actor values (4036,'Roy Dupuis');
insert into actor values (4037,'Courtney Chase');
insert into actor values (4038,'Scott Mosier');
insert into actor values (4039,'David Naughton');
insert into actor values (4040,'Sheila Agee');
insert into actor values (4041,'Daniel Faraldo');
insert into actor values (4042,'Craig Reay');
insert into actor values (4043,'Courtney Thorne-Smith');
insert into actor values (4044,'Rosalind Hammond');
insert into actor values (4045,'Courtney White');
insert into actor values (4046,'Denis Arndt');
insert into actor values (4047,'Dave Austin');
insert into actor values (4048,'Shecky Greene');
insert into actor values (4049,'Craig Ferguson');
insert into actor values (4050,'Sam Huntington');
--- tabactor, 4051, 50
insert into actor values (4051,'Daniel Emilfork');
insert into actor values (4052,'Vinícius de Oliveira');
insert into actor values (4053,'Vincent Castellanos');
insert into actor values (4054,'Victoria Sus');
insert into actor values (4055,'Annie McEnroe');
insert into actor values (4056,'Annie Golden');
insert into actor values (4057,'Annie Corley');
insert into actor values (4058,'Victoria Tennant');
insert into actor values (4059,'Anny Nelsen');
insert into actor values (4060,'Anne Reid');
insert into actor values (4061,'Anthony Bushell');
insert into actor values (4062,'Anne Marie McEvoy');
insert into actor values (4063,'Anne Louise Hassing');
insert into actor values (4064,'Anne Gaybis');
insert into actor values (4065,'Anne Francis (I)');
insert into actor values (4066,'Anne Brochet');
insert into actor values (4067,'Andrew Knott');
insert into actor values (4068,'Viggo Bentzon');
insert into actor values (4069,'Antoine Basler');
insert into actor values (4070,'Antonio Sabato Jr.');
insert into actor values (4071,'Antonio Mendoza (II)');
insert into actor values (4072,'Vernon Campbell');
insert into actor values (4073,'Antonia San Juan');
insert into actor values (4074,'Antonia Franceschi');
insert into actor values (4075,'Antone DiLeo');
insert into actor values (4076,'Annie Wu');
insert into actor values (4077,'Vicellous Reon Shannon');
insert into actor values (4078,'Anna-Maria Gherardi');
insert into actor values (4079,'Victor Banerjee');
insert into actor values (4080,'Victor Colicchio');
insert into actor values (4081,'Anthony Portillo');
insert into actor values (4082,'Victor McLaglen');
insert into actor values (4083,'Victor Stiles');
insert into actor values (4084,'Victoria Beckham');
insert into actor values (4085,'Anton Rodgers');
insert into actor values (4086,'Vivian Smallwood');
insert into actor values (4087,'Anne Bartoletti');
insert into actor values (4088,'Virginia Paris');
insert into actor values (4089,'Virginie Ledoyen');
insert into actor values (4090,'Virna Lisi');
insert into actor values (4091,'Vivean Gray');
insert into actor values (4092,'Angélica Aragón');
insert into actor values (4093,'Virginia Mayo');
insert into actor values (4094,'Vivian Pickles');
insert into actor values (4095,'Angeline Ball');
insert into actor values (4096,'Vladimir Kulich');
insert into actor values (4097,'Andrew Schofield');
insert into actor values (4098,'Vladislav Dvorzhetsky');
insert into actor values (4099,'Andrew Pang');
insert into actor values (4100,'Vondie Curtis-Hall');
--- tabactor, 4101, 50
insert into actor values (4101,'Tammy Grimes');
insert into actor values (4102,'Viveca Dahlén');
insert into actor values (4103,'Vinny Argiro');
insert into actor values (4104,'Anna Gee Byrd');
insert into actor values (4105,'Anna Friel');
insert into actor values (4106,'Anna Falchi');
insert into actor values (4107,'Anna Chlumsky');
insert into actor values (4108,'Ann Suzuki');
insert into actor values (4109,'Ann Robinson (I)');
insert into actor values (4110,'Angela Winkler (I)');
insert into actor values (4111,'Anita Pallenberg');
insert into actor values (4112,'Arabella Field');
insert into actor values (4113,'Anita Morris');
insert into actor values (4114,'Anita Laurenzi');
insert into actor values (4115,'Anita Ekberg');
insert into actor values (4116,'Anita Bryant');
insert into actor values (4117,'Angus MacInnes');
insert into actor values (4118,'Virginia Christine');
insert into actor values (4119,'Ann Doran');
insert into actor values (4120,'Tung Thanh Tran');
insert into actor values (4121,'Vera-Ellen');
insert into actor values (4122,'Troels Lyby');
insert into actor values (4123,'Basil Sydney');
insert into actor values (4124,'Barton MacLane');
insert into actor values (4125,'Barry Watson');
insert into actor values (4126,'Truman Capote');
insert into actor values (4127,'Beatrice Straight');
insert into actor values (4128,'Barry Foster');
insert into actor values (4129,'Trini Alvarado');
insert into actor values (4130,'Barry Corbin');
insert into actor values (4131,'Tyra Banks');
insert into actor values (4132,'Barbara Stuart');
insert into actor values (4133,'Barbara Stanwyck');
insert into actor values (4134,'Barbara Magnolfi');
insert into actor values (4135,'Barbara Luddy');
insert into actor values (4136,'Barry Pearl');
insert into actor values (4137,'Ben Hammer (I)');
insert into actor values (4138,'Benoît Régent');
insert into actor values (4139,'Benjamin Weir');
insert into actor values (4140,'Toshie Negishi');
insert into actor values (4141,'Bengt Ekerot');
insert into actor values (4142,'Tracey Cherelle Jones');
insert into actor values (4143,'Ben Shenkman (II)');
insert into actor values (4144,'Beatie Edney');
insert into actor values (4145,'Ben Miles');
insert into actor values (4146,'Barbara Eda-Young');
insert into actor values (4147,'Tracy Arnold');
insert into actor values (4148,'Ben Duncan');
insert into actor values (4149,'Ben Davidson');
insert into actor values (4150,'Tracy Nelson');
--- tabactor, 4151, 50
insert into actor values (4151,'Bembol Roco');
insert into actor values (4152,'Traylor Howard');
insert into actor values (4153,'Ben Piazza');
insert into actor values (4154,'Armando Brancia');
insert into actor values (4155,'Arthur Burghardt');
insert into actor values (4156,'Arthur Agee');
insert into actor values (4157,'Van Johnson');
insert into actor values (4158,'Vance Johnson');
insert into actor values (4159,'Arnold Lucy');
insert into actor values (4160,'Arno Frisch');
insert into actor values (4161,'Barbara Leigh-Hunt');
insert into actor values (4162,'Vanna Urbino');
insert into actor values (4163,'Ashleigh Aston Moore');
insert into actor values (4164,'Veerle van Overloop');
insert into actor values (4165,'Vera Farmiga');
insert into actor values (4166,'Arlene Francis');
insert into actor values (4167,'Ariana Richards');
insert into actor values (4168,'Archie Panjabi');
insert into actor values (4169,'Andrew Kevin Walker');
insert into actor values (4170,'Armin Rohde');
insert into actor values (4171,'Ayano Shiraishi');
insert into actor values (4172,'Apollonia Kotero');
insert into actor values (4173,'Barbara Carrera');
insert into actor values (4174,'Barbara Bel Geddes');
insert into actor values (4175,'Barbara Bach');
insert into actor values (4176,'Ulf Pilgaard');
insert into actor values (4177,'Ulla Jacobsson');
insert into actor values (4178,'Valerie Hobson');
insert into actor values (4179,'Azura Skye');
insert into actor values (4180,'Valerie Harper');
insert into actor values (4181,'Avner Eisenberg');
insert into actor values (4182,'Avery Brooks');
insert into actor values (4183,'Ulrich Mühe');
insert into actor values (4184,'August Schellenberg');
insert into actor values (4185,'Uta Hagen');
insert into actor values (4186,'Asta Esper Andersen');
insert into actor values (4187,'Barbara Gordon (II)');
insert into actor values (4188,'Börje Ahlstedt');
insert into actor values (4189,'Yasmine Bleeth');
insert into actor values (4190,'Yoshiko Shinohara');
insert into actor values (4191,'Wyatt Knight');
insert into actor values (4192,'Alan Boyle (II)');
insert into actor values (4193,'Alan Bates');
insert into actor values (4194,'Alan Badel');
insert into actor values (4195,'Yûko Tanaka');
insert into actor values (4196,'Alan Hale');
insert into actor values (4197,'Al Checco');
insert into actor values (4198,'Alan Howard (I)');
insert into actor values (4199,'Akim Tamiroff');
insert into actor values (4200,'Akiko Wakabayashi');
--- tabactor, 4201, 50
insert into actor values (4201,'Akihiro Miwa');
insert into actor values (4202,'Akemi Yamaguchi');
insert into actor values (4203,'Yoshi Oida');
insert into actor values (4204,'Andrew Lauer');
insert into actor values (4205,'Al Fann');
insert into actor values (4206,'Wilt Chamberlain');
insert into actor values (4207,'Albert Rémy');
insert into actor values (4208,'William Snape');
insert into actor values (4209,'William Sylvester');
insert into actor values (4210,'William Vail');
insert into actor values (4211,'Alan Young (I)');
insert into actor values (4212,'Alan Vint');
insert into actor values (4213,'Alan Cox');
insert into actor values (4214,'Willie Nelson');
insert into actor values (4215,'Ahna Capri');
insert into actor values (4216,'Alan Randolph Scott');
insert into actor values (4217,'Wladyslaw Kowalski');
insert into actor values (4218,'Wolfgang Heinz');
insert into actor values (4219,'Wolfgang Lukschy');
insert into actor values (4220,'Wolfgang Preiss');
insert into actor values (4221,'Wood Harris');
insert into actor values (4222,'Alan Stock');
insert into actor values (4223,'Aaron Michael Metchik');
insert into actor values (4224,'Aitana Sánchez-Gijón');
insert into actor values (4225,'Adam LeFevre');
insert into actor values (4226,'Adam Garcia');
insert into actor values (4227,'Adam Bryant');
insert into actor values (4228,'Zara Turner');
insert into actor values (4229,'Ada Carrasco');
insert into actor values (4230,'Adam Storke');
insert into actor values (4231,'Abdel Ahmed Ghili');
insert into actor values (4232,'Addison Powell');
insert into actor values (4233,'Zeppo Marx');
insert into actor values (4234,'Aaliyah');
insert into actor values (4235,'A.J. Langer');
insert into actor values (4236,'Zhang Ziyi');
insert into actor values (4237,'Zitto Kazann');
insert into actor values (4238,'Élisabeth Bourgine');
insert into actor values (4239,'Abraham Benrubi');
insert into actor values (4240,'Adrian Rawlins');
insert into actor values (4241,'Yoshio Inaba');
insert into actor values (4242,'Agnes Moorehead');
insert into actor values (4243,'Agga Olsen');
insert into actor values (4244,'Agatha Hurle');
insert into actor values (4245,'Yu Tokui');
insert into actor values (4246,'Yu-Wen Wang');
insert into actor values (4247,'Yvonne Elliman');
insert into actor values (4248,'Yuriko Ishida');
insert into actor values (4249,'Alec Cawthorne');
insert into actor values (4250,'Yusaku Matsuda');
--- tabactor, 4251, 50
insert into actor values (4251,'Adrian Lester');
insert into actor values (4252,'Adrian Grenier');
insert into actor values (4253,'Adolphe Menjou');
insert into actor values (4254,'Adolfo Celi');
insert into actor values (4255,'Adewale Akinnuoye-Agbaje');
insert into actor values (4256,'Yuri Petrov');
insert into actor values (4257,'Wendie Jo Sperber');
insert into actor values (4258,'Aldo Giuffrè');
insert into actor values (4259,'Wayne Morris (I)');
insert into actor values (4260,'Wendell Corey');
insert into actor values (4261,'Amy Brooks');
insert into actor values (4262,'Amitabh Bachchan');
insert into actor values (4263,'Amie Carey');
insert into actor values (4264,'Warren Stevens (I)');
insert into actor values (4265,'Amber Benson');
insert into actor values (4266,'Anatoli Davydov');
insert into actor values (4267,'Amanda Peterson');
insert into actor values (4268,'Wendy Benson');
insert into actor values (4269,'Wendy Gazelle');
insert into actor values (4270,'Allison Gompf');
insert into actor values (4271,'Wendy Nottingham');
insert into actor values (4272,'Allen Joseph');
insert into actor values (4273,'Ami Almendral');
insert into actor values (4274,'Walter Huston');
insert into actor values (4275,'Andrew Fullerton');
insert into actor values (4276,'Wah Yuen');
insert into actor values (4277,'Wallace Wood');
insert into actor values (4278,'Walter Catlett');
insert into actor values (4279,'Andrew Cassese');
insert into actor values (4280,'Andrew Broder');
insert into actor values (4281,'Warwick Davis');
insert into actor values (4282,'Andres Aybar');
insert into actor values (4283,'Allan Jones');
insert into actor values (4284,'Andrea Eckert');
insert into actor values (4285,'Andras Jones');
insert into actor values (4286,'Andréas Voutsinas');
insert into actor values (4287,'André Oumansky');
insert into actor values (4288,'André Dussollier');
insert into actor values (4289,'Anders W. Berthelsen');
insert into actor values (4290,'Walter Connolly');
insert into actor values (4291,'William Prince');
insert into actor values (4292,'Alex Rafalowicz');
insert into actor values (4293,'William Hope');
insert into actor values (4294,'Alex Jennings');
insert into actor values (4295,'Alex Datcher');
insert into actor values (4296,'William McNamara');
insert into actor values (4297,'William O''Leary (I)');
insert into actor values (4298,'Allen Danziger');
insert into actor values (4299,'Aleksandr Baluyev');
insert into actor values (4300,'Alex Weir');
--- tabactor, 4301, 50
insert into actor values (4301,'William R. Moses');
insert into actor values (4302,'Alejandro Rey');
insert into actor values (4303,'William Ragsdale');
insert into actor values (4304,'William Redfield');
insert into actor values (4305,'William Richert');
insert into actor values (4306,'Tony Leung Chiu Wai');
insert into actor values (4307,'Alessandro Nivola');
insert into actor values (4308,'Alicia Goranson');
insert into actor values (4309,'Aldo Silvani (I)');
insert into actor values (4310,'Whitney Houston');
insert into actor values (4311,'Whittni Wright');
insert into actor values (4312,'Alison Whelan');
insert into actor values (4313,'Alison Price');
insert into actor values (4314,'Wilfrid Brambell');
insert into actor values (4315,'Alex Scott (II)');
insert into actor values (4316,'Will Lyman');
insert into actor values (4317,'Alex Vincent');
insert into actor values (4318,'Willard E. Pugh');
insert into actor values (4319,'William B. Davis (I)');
insert into actor values (4320,'Alexis Cruz');
insert into actor values (4321,'Alexandra Wilson');
insert into actor values (4322,'Alexandra Vandernoot');
insert into actor values (4323,'Alexander Granach');
insert into actor values (4324,'Wes Bentley');
insert into actor values (4325,'Aline Kominsky');
insert into actor values (4326,'Steve Huison');
insert into actor values (4327,'Steve O''Donnell (I)');
insert into actor values (4328,'Chazz Domingueza');
insert into actor values (4329,'Steve Forrest');
insert into actor values (4330,'Charlotte Véry');
insert into actor values (4331,'Steve Gevedon');
insert into actor values (4332,'Charlotte Lewis');
insert into actor values (4333,'Stephi Lineburg');
insert into actor values (4334,'Charlie Yeung');
insert into actor values (4335,'Chen Chang');
insert into actor values (4336,'Charlie Hofheimer');
insert into actor values (4337,'Charles Vanel');
insert into actor values (4338,'Charles Tyner');
insert into actor values (4339,'Charles Smith (V)');
insert into actor values (4340,'Charles Ruggles');
insert into actor values (4341,'Bernard Giraudeau');
insert into actor values (4342,'Steve Harris (I)');
insert into actor values (4343,'Chien-lien Wu');
insert into actor values (4344,'Stephen Boyd');
insert into actor values (4345,'Stephen D. Newman');
insert into actor values (4346,'Chris Lemmon');
insert into actor values (4347,'Stephen Dorff');
insert into actor values (4348,'Stephen Elliott (I)');
insert into actor values (4349,'Stephen Garlick');
insert into actor values (4350,'Steve Brown (IX)');
--- tabactor, 4351, 50
insert into actor values (4351,'Chintara Sukapatana');
insert into actor values (4352,'Charles Kay');
insert into actor values (4353,'Chief Dan George');
insert into actor values (4354,'Chiara Mastroianni');
insert into actor values (4355,'Chete Lera');
insert into actor values (4356,'Cheryl Pollak');
insert into actor values (4357,'Cheryl Ladd');
insert into actor values (4358,'Stephen Tompkinson');
insert into actor values (4359,'Stephen Geoffreys');
insert into actor values (4360,'Catherine Mary Stewart');
insert into actor values (4361,'Charles Powell');
insert into actor values (4362,'Cathy O''Donnell (I)');
insert into actor values (4363,'Su Cruickshank');
insert into actor values (4364,'Cathleen Nesbitt');
insert into actor values (4365,'Sukie Smith');
insert into actor values (4366,'Catherine Wilkening');
insert into actor values (4367,'Catlin Adams');
insert into actor values (4368,'Suli McCullough');
insert into actor values (4369,'Stuart Townsend');
insert into actor values (4370,'Sunny Johnson');
insert into actor values (4371,'Catharine Bolz');
insert into actor values (4372,'Cate Bauer');
insert into actor values (4373,'Casey Boersma');
insert into actor values (4374,'Susan Blu');
insert into actor values (4375,'Susan Burgess');
insert into actor values (4376,'Catherine Schell');
insert into actor values (4377,'Charles ''Bud'' Tingwell');
insert into actor values (4378,'Charles Haid');
insert into actor values (4379,'Steve Van Wormer');
insert into actor values (4380,'Charles Drake');
insert into actor values (4381,'Charles Does');
insert into actor values (4382,'Steven Ford');
insert into actor values (4383,'Charles Crumb');
insert into actor values (4384,'Stubby Kaye');
insert into actor values (4385,'Steven Scales');
insert into actor values (4386,'Chris Spencer');
insert into actor values (4387,'Chaim Jeraffi');
insert into actor values (4388,'Chad Donella');
insert into actor values (4389,'Celeste Holm');
insert into actor values (4390,'Cecillia Stark');
insert into actor values (4391,'Sting');
insert into actor values (4392,'Cecil Parker (I)');
insert into actor values (4393,'Charles Champlin');
insert into actor values (4394,'Claire Benedict');
insert into actor values (4395,'Stephanie Simon');
insert into actor values (4396,'Soia Lira');
insert into actor values (4397,'Solo');
insert into actor values (4398,'Claire Rushbrook');
insert into actor values (4399,'Claire Maurier');
insert into actor values (4400,'Claire Du Brey');
--- tabactor, 4401, 50
insert into actor values (4401,'Clarence Kolb');
insert into actor values (4402,'Sonia Braga');
insert into actor values (4403,'Slim Summerville');
insert into actor values (4404,'Clémentine Célarié');
insert into actor values (4405,'Cinqué Lee');
insert into actor values (4406,'Sonia Todd');
insert into actor values (4407,'Cindy Crawford');
insert into actor values (4408,'Ciccio Ingrassia');
insert into actor values (4409,'Ciaran Owens');
insert into actor values (4410,'Claire Cox');
insert into actor values (4411,'Cleavant Derricks');
insert into actor values (4412,'Simon Oakland');
insert into actor values (4413,'Cliff Potts');
insert into actor values (4414,'Simon Shepherd');
insert into actor values (4415,'Cliff Edwards');
insert into actor values (4416,'Simone Griffeth');
insert into actor values (4417,'Simone Mareuil');
insert into actor values (4418,'Clare Kramer');
insert into actor values (4419,'Sinéad Cusack');
insert into actor values (4420,'Chuck Pfeiffer');
insert into actor values (4421,'Clayton Rohner');
insert into actor values (4422,'Claudine Longet');
insert into actor values (4423,'Claudine Auger');
insert into actor values (4424,'Claudette Colbert');
insert into actor values (4425,'Skinny Puppy');
insert into actor values (4426,'Slavko Stimac');
insert into actor values (4427,'Clelia Matania');
insert into actor values (4428,'Stefan Hörberg');
insert into actor values (4429,'Christine Kaufmann');
insert into actor values (4430,'Christine Hargreaves');
insert into actor values (4431,'Christine Dunford');
insert into actor values (4432,'Stanley DeSantis');
insert into actor values (4433,'Stanley Holloway');
insert into actor values (4434,'Stanley Lawrence');
insert into actor values (4435,'Chus Lampreave');
insert into actor values (4436,'Stefan Clapczynski');
insert into actor values (4437,'Stan Alexander');
insert into actor values (4438,'Stella Keitel');
insert into actor values (4439,'Christian Campbell (I)');
insert into actor values (4440,'Christian Bujeau');
insert into actor values (4441,'Stephan Hockey');
insert into actor values (4442,'Stephanie Farrow');
insert into actor values (4443,'Susan Lynch');
insert into actor values (4444,'Christina Carlwind');
insert into actor values (4445,'Christopher Rozycki');
insert into actor values (4446,'Stephanie Sawyer');
insert into actor values (4447,'Sonny Landham');
insert into actor values (4448,'Chuck Montgomery (I)');
insert into actor values (4449,'Chuck Bush');
insert into actor values (4450,'Chu Kong');
--- tabactor, 4451, 50
insert into actor values (4451,'Sonny Tufts');
insert into actor values (4452,'Christopher Atkins');
insert into actor values (4453,'Christopher St. John');
insert into actor values (4454,'Christopher Bauer');
insert into actor values (4455,'Sophie Ward');
insert into actor values (4456,'Christopher J. Keene');
insert into actor values (4457,'Christopher Hewett');
insert into actor values (4458,'Christopher Eigeman');
insert into actor values (4459,'Stacy Nelkin');
insert into actor values (4460,'Christopher Castile');
insert into actor values (4461,'Sonja Smits');
insert into actor values (4462,'Christopher Villiers');
insert into actor values (4463,'Bobby Joe McFadden');
insert into actor values (4464,'Thaao Penghlis');
insert into actor values (4465,'Bradley Gregg');
insert into actor values (4466,'Thuy An Luu');
insert into actor values (4467,'Tim Davis');
insert into actor values (4468,'Brad Johnson (II)');
insert into actor values (4469,'Brad Greenquist');
insert into actor values (4470,'Brandon De Wilde');
insert into actor values (4471,'Bonnie Bartlett');
insert into actor values (4472,'Brandon Hammond');
insert into actor values (4473,'Bobby Di Cicco');
insert into actor values (4474,'Timothy Jerome');
insert into actor values (4475,'Tina Caspary');
insert into actor values (4476,'Bob Newhart');
insert into actor values (4477,'Tina Majorino');
insert into actor values (4478,'Bob Griffin (II)');
insert into actor values (4479,'Tim Robertson');
insert into actor values (4480,'Brenda De Banzie');
insert into actor values (4481,'Susan George');
insert into actor values (4482,'Brian Cesak');
insert into actor values (4483,'Thomas Antoni');
insert into actor values (4484,'Thomas Bo Larsen');
insert into actor values (4485,'Brett Harrelson');
insert into actor values (4486,'Thomas Ian Griffith');
insert into actor values (4487,'Thor Bishopric');
insert into actor values (4488,'Brenda Kendall');
insert into actor values (4489,'Bob Bingham');
insert into actor values (4490,'Breffni McKenna');
insert into actor values (4491,'Brawley Nolte');
insert into actor values (4492,'Branka Katic');
insert into actor values (4493,'Brandy Norwood');
insert into actor values (4494,'Brandon Merrill');
insert into actor values (4495,'Thomas Wilson Brown');
insert into actor values (4496,'Brendan Deary');
insert into actor values (4497,'Tony Britton');
insert into actor values (4498,'Tommy Bone');
insert into actor values (4499,'Tommy Luske');
insert into actor values (4500,'Bill Barretta');
--- tabactor, 4501, 50
insert into actor values (4501,'Tommy Rall');
insert into actor values (4502,'Beulah Garrick');
insert into actor values (4503,'Beulah Bondi');
insert into actor values (4504,'Tiny Sandford');
insert into actor values (4505,'Betty Kennedy (I)');
insert into actor values (4506,'Tomislav Maretic');
insert into actor values (4507,'Betsy Baker');
insert into actor values (4508,'Beth Ehlers');
insert into actor values (4509,'Tony Haygarth');
insert into actor values (4510,'Bert Lahr');
insert into actor values (4511,'Bernie Coulson');
insert into actor values (4512,'Sieghardt Rupp');
insert into actor values (4513,'Tony Beckley');
insert into actor values (4514,'Tom Keene');
insert into actor values (4515,'Tetsuro Tamba');
insert into actor values (4516,'Todd Graff');
insert into actor values (4517,'Birthe Neumann');
insert into actor values (4518,'Tom Aldredge');
insert into actor values (4519,'Tom Davis (I)');
insert into actor values (4520,'Billy Gray (I)');
insert into actor values (4521,'Bill Cosby');
insert into actor values (4522,'Billy Burke (I)');
insert into actor values (4523,'Tommaso Puntelli');
insert into actor values (4524,'Billy Bletcher');
insert into actor values (4525,'Bille Brown');
insert into actor values (4526,'Tom Murray (I)');
insert into actor values (4527,'Bill Smitrovich');
insert into actor values (4528,'Bill Shirley');
insert into actor values (4529,'Tom Towles');
insert into actor values (4530,'Bob Dishy');
insert into actor values (4531,'Tom Felton');
insert into actor values (4532,'Calista Flockhart');
insert into actor values (4533,'Theresa Russell');
insert into actor values (4534,'Candice Bergen');
insert into actor values (4535,'Candela Peña');
insert into actor values (4536,'Sylvia Chang');
insert into actor values (4537,'Cameron Dye');
insert into actor values (4538,'Sylvia Miles');
insert into actor values (4539,'Capucine');
insert into actor values (4540,'Calvin Green');
insert into actor values (4541,'Carey Lowell');
insert into actor values (4542,'Cal Kuniholm');
insert into actor values (4543,'Cab Calloway');
insert into actor values (4544,'T.J. Cross');
insert into actor values (4545,'T.J. Lowther');
insert into actor values (4546,'T.P. McKenna');
insert into actor values (4547,'Buddy Ebsen');
insert into actor values (4548,'Calvin Levels');
insert into actor values (4549,'Susan Ursitti');
insert into actor values (4550,'Tony Llewellyn-Jones');
--- tabactor, 4551, 50
insert into actor values (4551,'Carrie Nye');
insert into actor values (4552,'Carrie Henn');
insert into actor values (4553,'Carolyn McCormick');
insert into actor values (4554,'Carolyn Choa');
insert into actor values (4555,'Caroline Munro');
insert into actor values (4556,'Syed Alwi');
insert into actor values (4557,'Carole Bouquet');
insert into actor values (4558,'Tami Stronach');
insert into actor values (4559,'Carol Lynley');
insert into actor values (4560,'Susie Bright');
insert into actor values (4561,'Carlos Montalbán (I)');
insert into actor values (4562,'Suzanne Pleshette');
insert into actor values (4563,'Sy Kramer');
insert into actor values (4564,'Carl Anthony');
insert into actor values (4565,'Caroline Kava');
insert into actor values (4566,'Terry Camilleri');
insert into actor values (4567,'Britt Ekland');
insert into actor values (4568,'Terence Alexander (I)');
insert into actor values (4569,'Brigitte Catillon');
insert into actor values (4570,'Teresa Ann Savoy');
insert into actor values (4571,'Teri McMinn');
insert into actor values (4572,'Brid Brennan');
insert into actor values (4573,'Bryna Weiss');
insert into actor values (4574,'Brian Tochi');
insert into actor values (4575,'Taylor Negron');
insert into actor values (4576,'Brian Murray (I)');
insert into actor values (4577,'Brian McElroy (I)');
insert into actor values (4578,'Terry Kiser');
insert into actor values (4579,'Terry O''Neill');
insert into actor values (4580,'Teru Shimada');
insert into actor values (4581,'Tesshô Genda');
insert into actor values (4582,'Brian Tyler (II)');
insert into actor values (4583,'Bruce Boxleitner');
insert into actor values (4584,'Carroll O''Connor');
insert into actor values (4585,'Tamiyo Kusakari');
insert into actor values (4586,'Bruce Ramsay');
insert into actor values (4587,'Richard Grove');
insert into actor values (4588,'Bruce Payne (I)');
insert into actor values (4589,'Tania Mallet');
insert into actor values (4590,'Bronson Dudley');
insert into actor values (4591,'Taungaroa Emile');
insert into actor values (4592,'Ted Knight');
insert into actor values (4593,'Tawny Kitaen');
insert into actor values (4594,'Bruce Bennett');
insert into actor values (4595,'Bruce Altman');
insert into actor values (4596,'Bruce Abbott');
insert into actor values (4597,'Brother Paul Bagget');
insert into actor values (4598,'Taylor Momsen');
insert into actor values (4599,'Bryan Batt');
insert into actor values (4600,'Tara Morice');
--- tabactor, 4601, 50
insert into actor values (4601,'Jinpachi Nezu');
insert into actor values (4602,'Michael Wren');
insert into actor values (4603,'Michel Auclair');
insert into actor values (4604,'Joan Crawford');
insert into actor values (4605,'Michel Blanc');
insert into actor values (4606,'Joachim Król');
insert into actor values (4607,'Joachim Cooder');
insert into actor values (4608,'Jo Van Fleet');
insert into actor values (4609,'Jim King (IV)');
insert into actor values (4610,'Jo Ann Havrilla');
insert into actor values (4611,'Joanna Pettet');
insert into actor values (4612,'Jimmy Somerville');
insert into actor values (4613,'Jimmy Ortega');
insert into actor values (4614,'Jimmy Nail');
insert into actor values (4615,'Jimmy Dean');
insert into actor values (4616,'Jimmy Blanche');
insert into actor values (4617,'Jim Robinson (I)');
insert into actor values (4618,'Jeremy Foley');
insert into actor values (4619,'Jo Prestia');
insert into actor values (4620,'Joe Dorsey');
insert into actor values (4621,'Johann Carlo');
insert into actor values (4622,'Michael Learned');
insert into actor values (4623,'Michael Legge (II)');
insert into actor values (4624,'Joely Fisher');
insert into actor values (4625,'Joe Saunders');
insert into actor values (4626,'Joe Piscopo');
insert into actor values (4627,'Joe Nipote');
insert into actor values (4628,'Joan Shawlee');
insert into actor values (4629,'Michael Ontkean');
insert into actor values (4630,'Joanna Lumley');
insert into actor values (4631,'Joe Breen (I)');
insert into actor values (4632,'Michael Rees Davis');
insert into actor values (4633,'Michael Schoeffling');
insert into actor values (4634,'Michael T. Weiss');
insert into actor values (4635,'Michael Thys');
insert into actor values (4636,'Joanne Dru');
insert into actor values (4637,'Joanne DiMauro');
insert into actor values (4638,'Jim Kelly (II)');
insert into actor values (4639,'Michael O''Keefe');
insert into actor values (4640,'Jerry Colonna');
insert into actor values (4641,'Jesper Asholt');
insert into actor values (4642,'Jerzy Stuhr');
insert into actor values (4643,'Jerzy Kosinski');
insert into actor values (4644,'Mike Epps');
insert into actor values (4645,'Mike Minett');
insert into actor values (4646,'Jerry Mathers');
insert into actor values (4647,'Jerry Lewis');
insert into actor values (4648,'Michele Abrams');
insert into actor values (4649,'Jerry Grayson');
insert into actor values (4650,'Jesse Vint');
--- tabactor, 4651, 50
insert into actor values (4651,'Jeremy Spenser');
insert into actor values (4652,'Jeremy Slate');
insert into actor values (4653,'Mike Vitar');
insert into actor values (4654,'Miki Lee');
insert into actor values (4655,'Mildred Dunnock');
insert into actor values (4656,'Jeremy Kemp');
insert into actor values (4657,'Mathias Rust (I)');
insert into actor values (4658,'Jerry Lacy');
insert into actor values (4659,'Jill St. John');
insert into actor values (4660,'Michelle Ferre');
insert into actor values (4661,'Jim Gallagher (I)');
insert into actor values (4662,'Jim Farley (I)');
insert into actor values (4663,'Michelle Kennedy');
insert into actor values (4664,'Michelle Reis');
insert into actor values (4665,'Michelle Trachtenberg');
insert into actor values (4666,'Mick Jagger');
insert into actor values (4667,'Jesse Howell');
insert into actor values (4668,'Mick Lally');
insert into actor values (4669,'Jesse Lee');
insert into actor values (4670,'Jill Eikenberry');
insert into actor values (4671,'Mickey Knox');
insert into actor values (4672,'Jessie Robins');
insert into actor values (4673,'Jessie Keosian');
insert into actor values (4674,'Mie Hama');
insert into actor values (4675,'Jessica Brooks Grant');
insert into actor values (4676,'Jessica Biel');
insert into actor values (4677,'John Alderton');
insert into actor values (4678,'Jim Backus');
insert into actor values (4679,'Meg Foster');
insert into actor values (4680,'John Omirah Miluwi');
insert into actor values (4681,'Maxon Crumb');
insert into actor values (4682,'May Chin');
insert into actor values (4683,'Maynard Eziashi');
insert into actor values (4684,'John Megna');
insert into actor values (4685,'Meagan Good');
insert into actor values (4686,'John McLiam');
insert into actor values (4687,'Johanna ter Steege');
insert into actor values (4688,'Meera Syal');
insert into actor values (4689,'John Payne (I)');
insert into actor values (4690,'Megan Dodds');
insert into actor values (4691,'John Louie');
insert into actor values (4692,'John Lone');
insert into actor values (4693,'Mel Gorham');
insert into actor values (4694,'John Le Mesurier');
insert into actor values (4695,'John Larch');
insert into actor values (4696,'Melanie Chisholm');
insert into actor values (4697,'John Matthews (II)');
insert into actor values (4698,'Matthew Marsh');
insert into actor values (4699,'P.J. Johnson');
insert into actor values (4700,'Mathilda May');
--- tabactor, 4701, 50
insert into actor values (4701,'John Waters (III)');
insert into actor values (4702,'Matt Mulhern');
insert into actor values (4703,'John Tormey');
insert into actor values (4704,'John Thaw');
insert into actor values (4705,'John Terry (I)');
insert into actor values (4706,'Maurice Woods (I)');
insert into actor values (4707,'Matthew Glave');
insert into actor values (4708,'John Paul Pitoc');
insert into actor values (4709,'Matthew Pidgeon');
insert into actor values (4710,'John Russell (I)');
insert into actor values (4711,'Maureen Lipman');
insert into actor values (4712,'Maurice Page');
insert into actor values (4713,'John Posey');
insert into actor values (4714,'John Polson');
insert into actor values (4715,'John Phillip Law');
insert into actor values (4716,'John Ireland');
insert into actor values (4717,'John Steiner (I)');
insert into actor values (4718,'John Buckwalter');
insert into actor values (4719,'Melanie Mayron');
insert into actor values (4720,'Michael Chance (I)');
insert into actor values (4721,'Michael Chekhov');
insert into actor values (4722,'John Cullum (I)');
insert into actor values (4723,'Michael Clark (I)');
insert into actor values (4724,'Michael Dean Jacobs');
insert into actor values (4725,'Michael DeLuise');
insert into actor values (4726,'John Doolittle');
insert into actor values (4727,'Michael Graham Cox');
insert into actor values (4728,'Michael C. Williams');
insert into actor values (4729,'Michael Gross (I)');
insert into actor values (4730,'John Brady (II)');
insert into actor values (4731,'John Bott');
insert into actor values (4732,'John Bennett Perry');
insert into actor values (4733,'John Bennett (I)');
insert into actor values (4734,'John Bedford Lloyd');
insert into actor values (4735,'Michael J. Nelson');
insert into actor values (4736,'Millard Mitchell');
insert into actor values (4737,'Michael Forest');
insert into actor values (4738,'Mervyn Johns');
insert into actor values (4739,'Johanne-Marie Tremblay');
insert into actor values (4740,'Melody Anderson');
insert into actor values (4741,'Melville Cooper');
insert into actor values (4742,'John Howard (II)');
insert into actor values (4743,'John Howard (I)');
insert into actor values (4744,'Melvyn Douglas');
insert into actor values (4745,'John Haymes Newton');
insert into actor values (4746,'Michael Carmine (II)');
insert into actor values (4747,'Merritt Nelson');
insert into actor values (4748,'John Kani');
insert into actor values (4749,'John Gottowt');
insert into actor values (4750,'Mia Cottet');
--- tabactor, 4751, 50
insert into actor values (4751,'Michael Aherne');
insert into actor values (4752,'John Furey');
insert into actor values (4753,'John Fraser (I)');
insert into actor values (4754,'Michael Bell (I)');
insert into actor values (4755,'John Farley');
insert into actor values (4756,'John Emery (I)');
insert into actor values (4757,'Merritt Butrick');
insert into actor values (4758,'Nick Stahl');
insert into actor values (4759,'Jamie Renée Smith');
insert into actor values (4760,'Nick Corri');
insert into actor values (4761,'Jamie Draven');
insert into actor values (4762,'Jamie Bell');
insert into actor values (4763,'Jamie Alexis');
insert into actor values (4764,'Jami Gertz');
insert into actor values (4765,'Jameson Thomas');
insert into actor values (4766,'James McCaffrey');
insert into actor values (4767,'Nick Stabile');
insert into actor values (4768,'Jan Hockey');
insert into actor values (4769,'Nick Sutton');
insert into actor values (4770,'Nigel Davenport');
insert into actor values (4771,'James Robertson Justice');
insert into actor values (4772,'Nigel Ivy');
insert into actor values (4773,'James Read (II)');
insert into actor values (4774,'James R. Young');
insert into actor values (4775,'Miles Dougal');
insert into actor values (4776,'Jameson Parker');
insert into actor values (4777,'Nicholas Campbell');
insert into actor values (4778,'Janusz Gajos');
insert into actor values (4779,'Janine Turner');
insert into actor values (4780,'Janet Jackson');
insert into actor values (4781,'Jane Withers');
insert into actor values (4782,'Jane Seymour');
insert into actor values (4783,'Jane March');
insert into actor values (4784,'Jane Leeves');
insert into actor values (4785,'Nick Apollo Forte');
insert into actor values (4786,'Jane Hallaren');
insert into actor values (4787,'Nicholle Tom');
insert into actor values (4788,'Jane Darwell');
insert into actor values (4789,'Nicholas Clay (I)');
insert into actor values (4790,'Nicholas Colasanto (I)');
insert into actor values (4791,'Jane Alexander');
insert into actor values (4792,'Nicholas Turturro');
insert into actor values (4793,'Jan Rubes');
insert into actor values (4794,'Jan Munroe');
insert into actor values (4795,'Nikolaj Lie Kaas');
insert into actor values (4796,'Jane Horrocks');
insert into actor values (4797,'Jadrien Steele');
insert into actor values (4798,'James Bolam');
insert into actor values (4799,'Omri Katz');
insert into actor values (4800,'James Baskett');
--- tabactor, 4801, 50
insert into actor values (4801,'Jamal Mixon');
insert into actor values (4802,'Ornella Muti');
insert into actor values (4803,'Jake Sandvig');
insert into actor values (4804,'Oscar Levant');
insert into actor values (4805,'Nikolai Sergeyev');
insert into actor values (4806,'Jaimz Woolvett');
insert into actor values (4807,'Olivia d''Abo');
insert into actor values (4808,'Jacques Weber');
insert into actor values (4809,'Jacques Villeret');
insert into actor values (4810,'Jacques Fabbri');
insert into actor values (4811,'Jacques Boudet');
insert into actor values (4812,'Jacquelyn Hyde');
insert into actor values (4813,'Jacqueline Poelvoorde-Pappaert');
insert into actor values (4814,'Otto Sander');
insert into actor values (4815,'Othon Bastos');
insert into actor values (4816,'Nye Heron');
insert into actor values (4817,'Nils Poppe');
insert into actor values (4818,'Nina Van Pallandt');
insert into actor values (4819,'James Laurenson');
insert into actor values (4820,'Nobu McCarthy');
insert into actor values (4821,'Nobuko Miyamoto (I)');
insert into actor values (4822,'Nobuo Kaneko');
insert into actor values (4823,'Norma Crane');
insert into actor values (4824,'Olivia Hack');
insert into actor values (4825,'Nozomu Sasaki');
insert into actor values (4826,'James Booth');
insert into actor values (4827,'James Dreyfus');
insert into actor values (4828,'James DeBello');
insert into actor values (4829,'Odile Le Clezio');
insert into actor values (4830,'James Coco');
insert into actor values (4831,'Olga Baclanova');
insert into actor values (4832,'Olga Karlatos');
insert into actor values (4833,'Olivia Barash');
insert into actor values (4834,'Nelson Mashita');
insert into actor values (4835,'Norman Bartold');
insert into actor values (4836,'Myron McCormick');
insert into actor values (4837,'Jeffrey Commanor');
insert into actor values (4838,'Monica Mikala');
insert into actor values (4839,'Jeff Richards (I)');
insert into actor values (4840,'Jeff Kober');
insert into actor values (4841,'Monique Gabrielle');
insert into actor values (4842,'Jeff Cohen (I)');
insert into actor values (4843,'Jeff Chamberlain');
insert into actor values (4844,'Jarlath Conroy');
insert into actor values (4845,'Jeannine Taylor');
insert into actor values (4846,'Monica Calhoun');
insert into actor values (4847,'Jeanne Kuo Chang');
insert into actor values (4848,'Jeanne Bates');
insert into actor values (4849,'Jeananne Crowley');
insert into actor values (4850,'Jean-Pierre Melville');
--- tabactor, 4851, 50
insert into actor values (4851,'Jean-Pierre Lorit');
insert into actor values (4852,'N!xau');
insert into actor values (4853,'N''Bushe Wright');
insert into actor values (4854,'Jed Brophy');
insert into actor values (4855,'Mitsuko Baisho');
insert into actor values (4856,'Jenny Howe');
insert into actor values (4857,'Jenny Drye');
insert into actor values (4858,'Jennifer Warren');
insert into actor values (4859,'Jennifer Salt');
insert into actor values (4860,'Mirai Yamamoto');
insert into actor values (4861,'Miriam Díaz Aroca');
insert into actor values (4862,'Miriam Shor');
insert into actor values (4863,'Jeffrey Donovan');
insert into actor values (4864,'Jennifer Ehle');
insert into actor values (4865,'Jeffrey Hunter');
insert into actor values (4866,'Mitsunori Isaki');
insert into actor values (4867,'Jenna Elfman');
insert into actor values (4868,'Moishe Rosenfeld');
insert into actor values (4869,'Molly Picon');
insert into actor values (4870,'Molly Regan');
insert into actor values (4871,'Mona McKinnon');
insert into actor values (4872,'Mona Powell');
insert into actor values (4873,'Najwa Nimri');
insert into actor values (4874,'Mirjana Jokovic');
insert into actor values (4875,'Ned Dowd');
insert into actor values (4876,'Nadezhda Mikhalkova');
insert into actor values (4877,'Jayne Atkinson');
insert into actor values (4878,'Jaya Bhaduri');
insert into actor values (4879,'Jay Thomas');
insert into actor values (4880,'Nathan Bexton');
insert into actor values (4881,'Jay Fiondella');
insert into actor values (4882,'Natividad Abascal');
insert into actor values (4883,'Natalie Canerday');
insert into actor values (4884,'Ned Bellamy');
insert into actor values (4885,'Jean Bouise');
insert into actor values (4886,'Ned Glass');
insert into actor values (4887,'Neil Maffin');
insert into actor values (4888,'Jason Gould (I)');
insert into actor values (4889,'Jason Edwards (I)');
insert into actor values (4890,'Jason Dixie');
insert into actor values (4891,'Nell Campbell');
insert into actor values (4892,'Nelly Pappaert');
insert into actor values (4893,'Massimo Troisi');
insert into actor values (4894,'Jason Priestley');
insert into actor values (4895,'Nat Pendleton');
insert into actor values (4896,'Jascha Washington');
insert into actor values (4897,'Nancy Kwan');
insert into actor values (4898,'Jean-Louis Trintignant');
insert into actor values (4899,'Jean-Louis Barrault');
insert into actor values (4900,'Nancy Olson');
--- tabactor, 4901, 50
insert into actor values (4901,'Nando Orfei');
insert into actor values (4902,'Naoto Takenaka');
insert into actor values (4903,'Jayne Brook');
insert into actor values (4904,'Jean Sorel');
insert into actor values (4905,'Jean-Pierre Bacri');
insert into actor values (4906,'Jean Rochefort');
insert into actor values (4907,'Natacha Lindinger');
insert into actor values (4908,'Natacha Régnier');
insert into actor values (4909,'Jean Heywood');
insert into actor values (4910,'Jean Heather');
insert into actor values (4911,'Natalie B. Kikkenborg');
insert into actor values (4912,'Jean Carson');
insert into actor values (4913,'Jean Caffeine');
insert into actor values (4914,'Jean Stapleton');
insert into actor values (4915,'Mädchen Amick');
insert into actor values (4916,'Kristina Kennedy');
insert into actor values (4917,'Lynn-Holly Johnson');
insert into actor values (4918,'Kristin Rudrüd');
insert into actor values (4919,'Kristian Almgren');
insert into actor values (4920,'Kristen Wilson (I)');
insert into actor values (4921,'Kristen Cloke');
insert into actor values (4922,'Lynne Griffin');
insert into actor values (4923,'Machiko Kyô');
insert into actor values (4924,'Klaus Wennemann');
insert into actor values (4925,'Krystia Mova');
insert into actor values (4926,'Klaus Abramowsky');
insert into actor values (4927,'Kitty Carlisle');
insert into actor values (4928,'Kitt Brophy');
insert into actor values (4929,'Kirsty Child');
insert into actor values (4930,'Mac Mashourian');
insert into actor values (4931,'Kirsten Sheridan');
insert into actor values (4932,'Marcel Bozzuffi');
insert into actor values (4933,'Kresimir Novakovic');
insert into actor values (4934,'Lung Ti');
insert into actor values (4935,'Larenz Tate');
insert into actor values (4936,'Lara Tosh');
insert into actor values (4937,'Lukas Haas');
insert into actor values (4938,'Lane Cassidy');
insert into actor values (4939,'Landry Allbright');
insert into actor values (4940,'Luke Edwards');
insert into actor values (4941,'Lana Wood');
insert into actor values (4942,'Kristina Wayborn');
insert into actor values (4943,'L. Scott Caldwell');
insert into actor values (4944,'Kristine Sutherland');
insert into actor values (4945,'Luther Adler');
insert into actor values (4946,'Kyôko Seki');
insert into actor values (4947,'Lynn ''Red'' Williams');
insert into actor values (4948,'Lynn Ferguson');
insert into actor values (4949,'Kumeko Urabe');
insert into actor values (4950,'Kuei-Mei Yang');
--- tabactor, 4951, 50
insert into actor values (4951,'Lynn Mabry');
insert into actor values (4952,'Mack Swain');
insert into actor values (4953,'Labina Mitevska');
insert into actor values (4954,'Kevin Corrigan (I)');
insert into actor values (4955,'Mamaengaroa Kerr-Bell');
insert into actor values (4956,'Mami Koyama');
insert into actor values (4957,'Kevin P. Farley');
insert into actor values (4958,'Kevin Murphy (II)');
insert into actor values (4959,'Kevin McKidd');
insert into actor values (4960,'Kevin McKeon');
insert into actor values (4961,'Manner Washington');
insert into actor values (4962,'Kirsten Baker');
insert into actor values (4963,'Manuela Gourary');
insert into actor values (4964,'Kien Shih');
insert into actor values (4965,'Kevin Conway (I)');
insert into actor values (4966,'Marília Pêra');
insert into actor values (4967,'Mara Krup');
insert into actor values (4968,'Marc Akerstream');
insert into actor values (4969,'Marc de Jonge');
insert into actor values (4970,'Kerri Green');
insert into actor values (4971,'John Wray (I)');
insert into actor values (4972,'Manny Jacobs');
insert into actor values (4973,'Madison Eginton');
insert into actor values (4974,'King Donovan');
insert into actor values (4975,'Madeleine Carroll');
insert into actor values (4976,'Kimberly Stringer');
insert into actor values (4977,'Madeleine LeBeau');
insert into actor values (4978,'Kimberly Elise');
insert into actor values (4979,'Madeline Balmaceda');
insert into actor values (4980,'Kim Walker');
insert into actor values (4981,'Makoto Kobori');
insert into actor values (4982,'Kim Myers (I)');
insert into actor values (4983,'Mairéad Ní Ghallchóir');
insert into actor values (4984,'Kim Director');
insert into actor values (4985,'Madison Lanc');
insert into actor values (4986,'Kim Bodnia');
insert into actor values (4987,'Maggie Cheung');
insert into actor values (4988,'Kika Markham');
insert into actor values (4989,'Maggie McOmie');
insert into actor values (4990,'Maia Brewton');
insert into actor values (4991,'Larry Hagman');
insert into actor values (4992,'Kim Novak');
insert into actor values (4993,'Lloyd Avery II');
insert into actor values (4994,'Leslie Caron');
insert into actor values (4995,'Little Richard');
insert into actor values (4996,'Leslie Bibb');
insert into actor values (4997,'Leslie Ash');
insert into actor values (4998,'Liv Ullmann');
insert into actor values (4999,'Lesley-Anne Down');
insert into actor values (5000,'Livio Badurina');
--- tabactor, 5001, 50
insert into actor values (5001,'Larisa Oleynik');
insert into actor values (5002,'Leopoldine Konstantin');
insert into actor values (5003,'Leslie Howard');
insert into actor values (5004,'Lois Hall');
insert into actor values (5005,'Leonard Hicks');
insert into actor values (5006,'Leonard Harris (II)');
insert into actor values (5007,'Leonard Frey');
insert into actor values (5008,'Loren Nelson');
insert into actor values (5009,'Lori Martin (I)');
insert into actor values (5010,'Leo Gullotta');
insert into actor values (5011,'Ljubica Adzovic');
insert into actor values (5012,'Lisa Ann Walter');
insert into actor values (5013,'Linda Larkin');
insert into actor values (5014,'Linda Manz');
insert into actor values (5015,'Linda Moretti');
insert into actor values (5016,'Linda Faye Farkas');
insert into actor values (5017,'Lionel Atwill');
insert into actor values (5018,'Lionel Barrymore');
insert into actor values (5019,'Lillian Gish');
insert into actor values (5020,'Lisa Zane');
insert into actor values (5021,'Lionel Jeffries');
insert into actor values (5022,'Leslie Hope (I)');
insert into actor values (5023,'Liesel Matthews');
insert into actor values (5024,'Li Gong');
insert into actor values (5025,'Lezlie Deane');
insert into actor values (5026,'Lisa Daniels');
insert into actor values (5027,'Lisa Jolliff-andoh');
insert into actor values (5028,'Lisa Spoonhauer');
insert into actor values (5029,'Lisa Wilcox');
insert into actor values (5030,'Lena Cardwell');
insert into actor values (5031,'Lilli Palmer');
insert into actor values (5032,'Laura Harris (II)');
insert into actor values (5033,'Lori Singer');
insert into actor values (5034,'Louis Wolheim');
insert into actor values (5035,'Louw Verwey');
insert into actor values (5036,'Lauren Hutton');
insert into actor values (5037,'Luana Patten');
insert into actor values (5038,'Luc Roeg');
insert into actor values (5039,'Luca Bercovici');
insert into actor values (5040,'Louis Prima');
insert into actor values (5041,'Luciana Paluzzi');
insert into actor values (5042,'Laurie Zimmer');
insert into actor values (5043,'Lucie Mannheim');
insert into actor values (5044,'Laura Dean (I)');
insert into actor values (5045,'Laura Crossley');
insert into actor values (5046,'Laura Cheron');
insert into actor values (5047,'Laura Betti');
insert into actor values (5048,'Lucile Watson');
insert into actor values (5049,'Lucille La Verne');
insert into actor values (5050,'Marcel Hillaire');
--- tabactor, 5051, 50
insert into actor values (5051,'Lauren Ambrose');
insert into actor values (5052,'Lotte Lenya');
insert into actor values (5053,'Lucy Gutteridge');
insert into actor values (5054,'Leland Palmer');
insert into actor values (5055,'Lorraine Pilkington');
insert into actor values (5056,'Leila Hyams');
insert into actor values (5057,'Leigh Taylor-Young');
insert into actor values (5058,'Leigh Russell');
insert into actor values (5059,'Leif Tilden');
insert into actor values (5060,'Laurent Spielvogel');
insert into actor values (5061,'Lotte Andersen');
insert into actor values (5062,'Lorna Luft');
insert into actor values (5063,'Lee Hinton (I)');
insert into actor values (5064,'Lou Antonio');
insert into actor values (5065,'Lee Curreri');
insert into actor values (5066,'Louis Eppolito');
insert into actor values (5067,'Lazar Ristovski (I)');
insert into actor values (5068,'Lawrence T. Wrentz');
insert into actor values (5069,'Louis Jourdan');
insert into actor values (5070,'Lawrence A. Bonney');
insert into actor values (5071,'Leif Juster');
insert into actor values (5072,'Josh Milrad');
insert into actor values (5073,'Mark-Paul Gosselaar');
insert into actor values (5074,'Marlee Matlin');
insert into actor values (5075,'Judd Omen');
insert into actor values (5076,'Joy Boushel');
insert into actor values (5077,'Joshua Tilden');
insert into actor values (5078,'Joshua Shalikar');
insert into actor values (5079,'Joshua Leonard');
insert into actor values (5080,'Martin Kove');
insert into actor values (5081,'Marlies van Alcmaer');
insert into actor values (5082,'Judith Anna Roberts');
insert into actor values (5083,'Josh Lucas');
insert into actor values (5084,'Marshall R. Teague');
insert into actor values (5085,'Martha Vickers');
insert into actor values (5086,'Joseph Wiseman');
insert into actor values (5087,'Joseph Whipp');
insert into actor values (5088,'Joseph Thiaka');
insert into actor values (5089,'Kerr Smith');
insert into actor values (5090,'Joshua Keaton');
insert into actor values (5091,'Julia Campbell');
insert into actor values (5092,'Mark Kiely');
insert into actor values (5093,'Julie Benz');
insert into actor values (5094,'Mark Lee (I)');
insert into actor values (5095,'Julie Allred');
insert into actor values (5096,'Julianne Phillips');
insert into actor values (5097,'Julianna Margulies');
insert into actor values (5098,'Mark Lester (I)');
insert into actor values (5099,'Judi Bowker');
insert into actor values (5100,'Julia Nickson-Soul');
--- tabactor, 5101, 50
insert into actor values (5101,'Mark Wingett');
insert into actor values (5102,'Judy Kuhn');
insert into actor values (5103,'Judy Holliday');
insert into actor values (5104,'Judith Vittet');
insert into actor values (5105,'Judith O''Dea');
insert into actor values (5106,'Judith Malina');
insert into actor values (5107,'Judith Ivey (I)');
insert into actor values (5108,'Judith Godrèche');
insert into actor values (5109,'Joseph Mascolo');
insert into actor values (5110,'Julian Arahanga');
insert into actor values (5111,'Mary Lynette Braxton');
insert into actor values (5112,'Mary Demas');
insert into actor values (5113,'Mary Gregory');
insert into actor values (5114,'Jonathan Jackson');
insert into actor values (5115,'Jonathan Freeman (I)');
insert into actor values (5116,'Mary Jo Catlett');
insert into actor values (5117,'Mary Kate Schellhardt');
insert into actor values (5118,'Jonathan Brandis');
insert into actor values (5119,'Joseph Pilato');
insert into actor values (5120,'Jonah Blechman');
insert into actor values (5121,'Jonathan Vega');
insert into actor values (5122,'Mary Stein (I)');
insert into actor values (5123,'Jon Kassir');
insert into actor values (5124,'Mary Ure');
insert into actor values (5125,'Mary Woronov');
insert into actor values (5126,'Masayuki Mori (I)');
insert into actor values (5127,'Johnny Ray McGhee');
insert into actor values (5128,'Massimo Serato');
insert into actor values (5129,'Jonas Abry');
insert into actor values (5130,'Marty Belafsky');
insert into actor values (5131,'Martin Rosenblatt');
insert into actor values (5132,'Martin Semmelrogge');
insert into actor values (5133,'Martin Walsh (III)');
insert into actor values (5134,'Joseph Egger');
insert into actor values (5135,'Martin West (I)');
insert into actor values (5136,'Joseph Calleia');
insert into actor values (5137,'Joseph Cali');
insert into actor values (5138,'Jonathan Sagall');
insert into actor values (5139,'Zooey Deschanel');
insert into actor values (5140,'Jonathan Scott-Taylor');
insert into actor values (5141,'Ángela Molina');
insert into actor values (5142,'Jorge de Juan');
insert into actor values (5143,'Marty York');
insert into actor values (5144,'Jordan Routledge');
insert into actor values (5145,'Jordan Christopher');
insert into actor values (5146,'Jonn Cherico');
insert into actor values (5147,'Jonkit Lee');
insert into actor values (5148,'Julie Dawn Cole');
insert into actor values (5149,'Joseph Bottoms');
insert into actor values (5150,'Marianne Koch');
--- tabactor, 5151, 50
insert into actor values (5151,'Maria Mayenzet');
insert into actor values (5152,'Maria Michi');
insert into actor values (5153,'Katja Riemann');
insert into actor values (5154,'Katie Schlossberg');
insert into actor values (5155,'Maria Porter');
insert into actor values (5156,'Maria Schneider');
insert into actor values (5157,'Kathryn Harrold');
insert into actor values (5158,'Mark Joy');
insert into actor values (5159,'Marianne Hagan');
insert into actor values (5160,'Maria Casarès');
insert into actor values (5161,'Marie-Anne Chazel');
insert into actor values (5162,'Marie-Laure Dougnac');
insert into actor values (5163,'Kathleen Harrison');
insert into actor values (5164,'Katharine Towne');
insert into actor values (5165,'Marilyn Eastman');
insert into actor values (5166,'Katharine Houghton');
insert into actor values (5167,'Marilyn Ghigliotti');
insert into actor values (5168,'Marianna Hill');
insert into actor values (5169,'Margaret Avery');
insert into actor values (5170,'Kenn Scott');
insert into actor values (5171,'Ken Takakura');
insert into actor values (5172,'Marcel Marceau');
insert into actor values (5173,'Marcella Rovere');
insert into actor values (5174,'Ken Page (I)');
insert into actor values (5175,'Ken Ogata');
insert into actor values (5176,'Ken Jenkins (I)');
insert into actor values (5177,'Katy Jurado');
insert into actor values (5178,'Ken Foree');
insert into actor values (5179,'Maria Doyle Kennedy');
insert into actor values (5180,'Margaret Langrick');
insert into actor values (5181,'Margaretha Krook');
insert into actor values (5182,'Keith Wayne');
insert into actor values (5183,'Keith Szarabajka');
insert into actor values (5184,'Keith Stuart Thayer');
insert into actor values (5185,'Marge Champion');
insert into actor values (5186,'Keith Allen (I)');
insert into actor values (5187,'Mario Iván Martínez');
insert into actor values (5188,'Marcie Leeds');
insert into actor values (5189,'Julietta Novis');
insert into actor values (5190,'Katharina Thalbach');
insert into actor values (5191,'Justin Henry');
insert into actor values (5192,'Justin Braine');
insert into actor values (5193,'Mark Addy');
insert into actor values (5194,'June Whitfield');
insert into actor values (5195,'Jullan Kindahl');
insert into actor values (5196,'Julio Alberto Fernández');
insert into actor values (5197,'K.C. Martel');
insert into actor values (5198,'Mark Beech');
insert into actor values (5199,'k.d. lang');
insert into actor values (5200,'Juliet Neil');
--- tabactor, 5201, 50
insert into actor values (5201,'Julien Carette');
insert into actor values (5202,'Mark Eliot');
insert into actor values (5203,'Julie Hayden');
insert into actor values (5204,'Mark Herrier');
insert into actor values (5205,'Julie Hamilton (I)');
insert into actor values (5206,'Julie Follansbhee');
insert into actor values (5207,'James Larkin (I)');
insert into actor values (5208,'Mark Arnold (I)');
insert into actor values (5209,'Karen McLymont');
insert into actor values (5210,'Julie Cobb');
insert into actor values (5211,'Marion Cotillard');
insert into actor values (5212,'Kassie DePaiva');
insert into actor values (5213,'Karl Hardman');
insert into actor values (5214,'Karl Etlinger');
insert into actor values (5215,'Karl Bruckschwaiger');
insert into actor values (5216,'Karin Viard');
insert into actor values (5217,'Mark Acheson');
insert into actor values (5218,'Karen Mok');
insert into actor values (5219,'Mario Abe');
insert into actor values (5220,'Karen Lynn Gorney');
insert into actor values (5221,'Karen Finley');
insert into actor values (5222,'Karen Edgely');
insert into actor values (5223,'Kaoru Kobayashi');
insert into actor values (5224,'Kalina Jedrusik');
insert into actor values (5225,'Kali Rocha');
insert into actor values (5226,'Kadeem Hardison');
insert into actor values (5227,'Kabir Bedi');
insert into actor values (5228,'Marisa Coughlan');
insert into actor values (5229,'François Cluzet');
insert into actor values (5230,'Floyd ''Red Crow'' Westerman');
insert into actor values (5231,'Richard Grieco');
insert into actor values (5232,'Frances O''Connor (II)');
insert into actor values (5233,'Joseph Bennett (III)');
insert into actor values (5234,'France Nuyen');
insert into actor values (5235,'Richard Hunt (I)');
insert into actor values (5236,'Françoise Yip');
insert into actor values (5237,'Francesco Quinn');
insert into actor values (5238,'François Hadji-Lazaro');
insert into actor values (5239,'Francine Racette');
insert into actor values (5240,'Richard Lewis (II)');
insert into actor values (5241,'Fran Brill');
insert into actor values (5242,'Frédérique Feder');
insert into actor values (5243,'Frédéric Diefenthal');
insert into actor values (5244,'Frédéric Andréi');
insert into actor values (5245,'Forrest Tucker');
insert into actor values (5246,'Richard Beymer');
insert into actor values (5247,'Richard Ingram');
insert into actor values (5248,'Richard D. Fisher Jr.');
insert into actor values (5249,'Ethan Erickson');
insert into actor values (5250,'Richard Boone');
--- tabactor, 5251, 50
insert into actor values (5251,'Frankie Acciarito');
insert into actor values (5252,'Richard Brooker');
insert into actor values (5253,'Frank Sinatra');
insert into actor values (5254,'Frank Morgan (I)');
insert into actor values (5255,'Richard Coca');
insert into actor values (5256,'Francesca Bertini');
insert into actor values (5257,'Frank Finlay');
insert into actor values (5258,'Florijan Ajdini');
insert into actor values (5259,'Frank Coughlan');
insert into actor values (5260,'Richard Denning (I)');
insert into actor values (5261,'Richard Easton (II)');
insert into actor values (5262,'Franco Nero');
insert into actor values (5263,'Francis Huster');
insert into actor values (5264,'Francis De Wolff');
insert into actor values (5265,'Francis Capra');
insert into actor values (5266,'Frank Giering');
insert into actor values (5267,'Evan C. Kim');
insert into actor values (5268,'Richard McCabe');
insert into actor values (5269,'Fabiana Formica');
insert into actor values (5270,'Richard White (I)');
insert into actor values (5271,'F. William Parker');
insert into actor values (5272,'Richmond Arquette');
insert into actor values (5273,'Evelyn Varden');
insert into actor values (5274,'Evelyn Guerrero');
insert into actor values (5275,'Faith Prince');
insert into actor values (5276,'Evan Handler');
insert into actor values (5277,'Fannie Flagg');
insert into actor values (5278,'Evan Adams');
insert into actor values (5279,'Eva Marie Saint');
insert into actor values (5280,'Eunice Gayson');
insert into actor values (5281,'Eugene Pallette');
insert into actor values (5282,'Eugene Collier');
insert into actor values (5283,'Ethel Merman');
insert into actor values (5284,'R.J. Parnell');
insert into actor values (5285,'Eve Channing');
insert into actor values (5286,'Felix Wong');
insert into actor values (5287,'Florence Pernel');
insert into actor values (5288,'Flavio Bucci');
insert into actor values (5289,'Richard Norton (I)');
insert into actor values (5290,'Fionnula Flanagan');
insert into actor values (5291,'Finn Carter');
insert into actor values (5292,'Richard Romanus');
insert into actor values (5293,'Feodor Chaliapin Jr.');
insert into actor values (5294,'Richard Ward (I)');
insert into actor values (5295,'Felton Perry');
insert into actor values (5296,'Fred Astaire');
insert into actor values (5297,'Felix Bressart');
insert into actor values (5298,'Felicity Huffman');
insert into actor values (5299,'Fele Martínez');
insert into actor values (5300,'Richard S. Castellano');
--- tabactor, 5301, 50
insert into actor values (5301,'Feather');
insert into actor values (5302,'Faye Wong');
insert into actor values (5303,'Farrah Fawcett');
insert into actor values (5304,'Fengyi Zhang');
insert into actor values (5305,'Rawle D. Lewis');
insert into actor values (5306,'Gary Taggart');
insert into actor values (5307,'George Burns (I)');
insert into actor values (5308,'George Baker (I)');
insert into actor values (5309,'Randy Pearlstein');
insert into actor values (5310,'Raoul Trujillo');
insert into actor values (5311,'George ''Red'' Schwartz');
insert into actor values (5312,'Raphael Fejtö');
insert into actor values (5313,'George De La Pena');
insert into actor values (5314,'Geoffrey Holder');
insert into actor values (5315,'George Foreman');
insert into actor values (5316,'Geneviève Page');
insert into actor values (5317,'Ray Allen (V)');
insert into actor values (5318,'Ray Bolger');
insert into actor values (5319,'Gene Ruffini');
insert into actor values (5320,'Ray Iannicelli');
insert into actor values (5321,'Gary Werntz');
insert into actor values (5322,'Franklin Cover');
insert into actor values (5323,'Raquel Welch');
insert into actor values (5324,'George Wilson (II)');
insert into actor values (5325,'Geri Halliwell');
insert into actor values (5326,'Gerard Butler');
insert into actor values (5327,'Geraldine O''Rawe');
insert into actor values (5328,'Geraldine Muir');
insert into actor values (5329,'Georgina Cates');
insert into actor values (5330,'Georgia Hale');
insert into actor values (5331,'Georges Guétary');
insert into actor values (5332,'Randy Gornel');
insert into actor values (5333,'Georges Corraface');
insert into actor values (5334,'Jacqueline Brookes');
insert into actor values (5335,'Rachel Blanchard');
insert into actor values (5336,'Rachel Howard');
insert into actor values (5337,'Rachel Ward');
insert into actor values (5338,'George Peppard');
insert into actor values (5339,'Ralph Ineson');
insert into actor values (5340,'George Hearn');
insert into actor values (5341,'George Hamilton');
insert into actor values (5342,'Georges Flamant');
insert into actor values (5343,'Rex Harrison');
insert into actor values (5344,'Raymond Serra');
insert into actor values (5345,'René Hofschneider');
insert into actor values (5346,'Gérard Klein (I)');
insert into actor values (5347,'Gérard Ismaël');
insert into actor values (5348,'Géraldine Pailhas');
insert into actor values (5349,'Fritz Wepper');
insert into actor values (5350,'Rene Ceballos');
--- tabactor, 5351, 50
insert into actor values (5351,'Remy Ryan');
insert into actor values (5352,'Frederick Koehler');
insert into actor values (5353,'Gabriel Casseus');
insert into actor values (5354,'Rhea Perlman');
insert into actor values (5355,'Rhoda Williams');
insert into actor values (5356,'Rhonda Britton');
insert into actor values (5357,'Fred Norris (I)');
insert into actor values (5358,'Richard Allen (I)');
insert into actor values (5359,'Richard Anderson (I)');
insert into actor values (5360,'Richard B. Shull');
insert into actor values (5361,'Rene Medvesek');
insert into actor values (5362,'Garry Shandling');
insert into actor values (5363,'Rebecca Gordon');
insert into actor values (5364,'Gary Merrill');
insert into actor values (5365,'Gary Lockwood');
insert into actor values (5366,'Gary Kemp');
insert into actor values (5367,'Gary Hershberger');
insert into actor values (5368,'Rebel Russell');
insert into actor values (5369,'Reeve Carney');
insert into actor values (5370,'Gabino Diego');
insert into actor values (5371,'Gary Beach');
insert into actor values (5372,'Esther Vriessendorp');
insert into actor values (5373,'Regina Hall (I)');
insert into actor values (5374,'Gail Cronauer');
insert into actor values (5375,'Regina Torné');
insert into actor values (5376,'Gabrielle Rose');
insert into actor values (5377,'Gabrielle Fitzpatrick');
insert into actor values (5378,'Reginald Gardiner');
insert into actor values (5379,'Gabriel Damon');
insert into actor values (5380,'Gary Bullock');
insert into actor values (5381,'Rocky Carroll');
insert into actor values (5382,'Dorris Bowdon');
insert into actor values (5383,'Robin Givens');
insert into actor values (5384,'Dwight Ewell');
insert into actor values (5385,'Robin Quivers');
insert into actor values (5386,'Duke Moore');
insert into actor values (5387,'Robin Weisman');
insert into actor values (5388,'Robyn Lynne Raab');
insert into actor values (5389,'Dylan Sprouse');
insert into actor values (5390,'Dre Pahich');
insert into actor values (5391,'Roberta Collins');
insert into actor values (5392,'Douglas Rain');
insert into actor values (5393,'Rod Culbertson');
insert into actor values (5394,'Douglas Forsythe Rye');
insert into actor values (5395,'Douglas Bisset');
insert into actor values (5396,'Doug McKeon');
insert into actor values (5397,'Rod Loomis');
insert into actor values (5398,'Edward Albert');
insert into actor values (5399,'Rock Hudson');
insert into actor values (5400,'Robert Sampson');
--- tabactor, 5401, 50
insert into actor values (5401,'Rick Yune');
insert into actor values (5402,'Ednah Holt');
insert into actor values (5403,'Edmond O''Brien');
insert into actor values (5404,'Edie Falco');
insert into actor values (5405,'Eddy Mitchell');
insert into actor values (5406,'Eddie Griffin');
insert into actor values (5407,'Eddie Albert');
insert into actor values (5408,'Dylan Kussman');
insert into actor values (5409,'Ed Ramey');
insert into actor values (5410,'Dorothy Comingore');
insert into actor values (5411,'Robert Small (I)');
insert into actor values (5412,'Ed Gale');
insert into actor values (5413,'Ed Begley');
insert into actor values (5414,'Earl Hindman');
insert into actor values (5415,'Eanna MacLiam');
insert into actor values (5416,'Robert Walker (I)');
insert into actor values (5417,'Robert Weems');
insert into actor values (5418,'Ed Wynn');
insert into actor values (5419,'Dolores Moran');
insert into actor values (5420,'Doug E. Doug');
insert into actor values (5421,'Roger Smith (I)');
insert into actor values (5422,'Don ''D.C.'' Curry');
insert into actor values (5423,'Dominique Virton');
insert into actor values (5424,'Dominique Sanda');
insert into actor values (5425,'Dominique Dunne');
insert into actor values (5426,'Dominique Bettenfeld');
insert into actor values (5427,'Roger Heathcott');
insert into actor values (5428,'Rolf Hoppe');
insert into actor values (5429,'Don Johnson');
insert into actor values (5430,'DMX');
insert into actor values (5431,'Djiby Soumare');
insert into actor values (5432,'DJ Qualls');
insert into actor values (5433,'Divine');
insert into actor values (5434,'Diva Gray');
insert into actor values (5435,'Dita Parlo');
insert into actor values (5436,'Dick York (I)');
insert into actor values (5437,'Domingo Landicho');
insert into actor values (5438,'Donald Madden');
insert into actor values (5439,'Dora van der Groen');
insert into actor values (5440,'Donny Osmond');
insert into actor values (5441,'Donnie Wahlberg');
insert into actor values (5442,'Donnie Dunagan');
insert into actor values (5443,'Roddy Maude-Roxby');
insert into actor values (5444,'Donna Hanover');
insert into actor values (5445,'Donna Frenzel');
insert into actor values (5446,'Don Creech (I)');
insert into actor values (5447,'Donatas Banionis');
insert into actor values (5448,'Edward Arnold');
insert into actor values (5449,'Rodney Harvey');
insert into actor values (5450,'Don Stroud (I)');
--- tabactor, 5451, 50
insert into actor values (5451,'Roger Bart');
insert into actor values (5452,'Roger Daltrey');
insert into actor values (5453,'Don Pardo');
insert into actor values (5454,'Don Murray');
insert into actor values (5455,'Don King (I)');
insert into actor values (5456,'Donna Anderson (I)');
insert into actor values (5457,'Emma Bunton');
insert into actor values (5458,'Emil Tarding');
insert into actor values (5459,'Eric Braeden');
insert into actor values (5460,'Robbi Morgan');
insert into actor values (5461,'Enzo Turrin');
insert into actor values (5462,'Enzo Cannavale');
insert into actor values (5463,'Enrico Colantoni');
insert into actor values (5464,'Robby Benson');
insert into actor values (5465,'Eric Clapton');
insert into actor values (5466,'Emma Gates');
insert into actor values (5467,'Eric Gordon');
insert into actor values (5468,'Robby Kiger');
insert into actor values (5469,'Emily Woof');
insert into actor values (5470,'Emily Lloyd');
insert into actor values (5471,'Emily Cline');
insert into actor values (5472,'Robert Apel');
insert into actor values (5473,'Robert Apisa');
insert into actor values (5474,'Robert Romanus');
insert into actor values (5475,'Emma Sjöberg');
insert into actor values (5476,'Erik Mørk');
insert into actor values (5477,'Ernst-Hugo Järegård');
insert into actor values (5478,'Ernst Stötzner');
insert into actor values (5479,'Ricky Nelson');
insert into actor values (5480,'Rik Van Nutter');
insert into actor values (5481,'Ernie Banks');
insert into actor values (5482,'Ernest Liu');
insert into actor values (5483,'Rita Karin');
insert into actor values (5484,'Rob Morrow');
insert into actor values (5485,'Erik van ''t Wout');
insert into actor values (5486,'Emil Marwa');
insert into actor values (5487,'Erica Yohn');
insert into actor values (5488,'Erica Leerhsen');
insert into actor values (5489,'Erica Carlson (II)');
insert into actor values (5490,'Eric Weinstein');
insert into actor values (5491,'Rob Brownstein');
insert into actor values (5492,'Eric Laneuville');
insert into actor values (5493,'Eric Hull');
insert into actor values (5494,'Eriko Watanabe');
insert into actor values (5495,'Elaine Banham');
insert into actor values (5496,'Robert Ari');
insert into actor values (5497,'Eli Marienthal');
insert into actor values (5498,'Elgin Marlow');
insert into actor values (5499,'Eleanor Parker (I)');
insert into actor values (5500,'Eleanor David');
--- tabactor, 5501, 50
insert into actor values (5501,'Eleanor Coppola');
insert into actor values (5502,'Elaine Stritch');
insert into actor values (5503,'Elie Chaib');
insert into actor values (5504,'Elaine Cassidy');
insert into actor values (5505,'Elisa Donovan');
insert into actor values (5506,'Eileen Atkins');
insert into actor values (5507,'Eijirô Tono');
insert into actor values (5508,'Robert Littman');
insert into actor values (5509,'Robert MacNaughton');
insert into actor values (5510,'Robert McDarra');
insert into actor values (5511,'Edward Everett Horton');
insert into actor values (5512,'Robert Pugh');
insert into actor values (5513,'Robert Lepage (I)');
insert into actor values (5514,'Elke Sommer');
insert into actor values (5515,'Robert Ayres (I)');
insert into actor values (5516,'Elva Josephson');
insert into actor values (5517,'Elton John');
insert into actor values (5518,'Els Dottermans');
insert into actor values (5519,'Robert Blake');
insert into actor values (5520,'Ellie Gottwald');
insert into actor values (5521,'Ellen Sandweiss');
insert into actor values (5522,'Robert Hughes (I)');
insert into actor values (5523,'Robert Conrad');
insert into actor values (5524,'Reba McEntire');
insert into actor values (5525,'Robert Cummings');
insert into actor values (5526,'Robert DoQui');
insert into actor values (5527,'Robert Drivas');
insert into actor values (5528,'Robert Foxworth');
insert into actor values (5529,'Elizabeth Berridge');
insert into actor values (5530,'Robert Francis (I)');
insert into actor values (5531,'Elisabeth Depardieu');
insert into actor values (5532,'Ellen DeGeneres');
insert into actor values (5533,'Paul Roebling');
insert into actor values (5534,'Hiroshi Ôtake');
insert into actor values (5535,'Paul Perri (I)');
insert into actor values (5536,'Paul Rhys');
insert into actor values (5537,'Hilary Mason');
insert into actor values (5538,'Hideko Yoshida');
insert into actor values (5539,'Heydon Prowse');
insert into actor values (5540,'Harriet Andersson');
insert into actor values (5541,'Hermione Gingold');
insert into actor values (5542,'Holter Graham');
insert into actor values (5543,'Herman Bing');
insert into actor values (5544,'Paul Sand (I)');
insert into actor values (5545,'Paul Simon (I)');
insert into actor values (5546,'Herbert Grönemeyer');
insert into actor values (5547,'Herb Edelman');
insert into actor values (5548,'Paul Sutera');
insert into actor values (5549,'Paulo Costanzo');
insert into actor values (5550,'Paul Richards (I)');
--- tabactor, 5551, 50
insert into actor values (5551,'Paul J. Lombardi');
insert into actor values (5552,'Hugh Douglas (II)');
insert into actor values (5553,'Hudhail Al-Amir');
insert into actor values (5554,'Hubertus Bengsch');
insert into actor values (5555,'Hubert Koundé');
insert into actor values (5556,'Paul Hörbiger');
insert into actor values (5557,'Howard Storm');
insert into actor values (5558,'Howard Morris');
insert into actor values (5559,'Paul Pape');
insert into actor values (5560,'Howard Hesseman');
insert into actor values (5561,'Hollis McLaren');
insert into actor values (5562,'Paul Koslo');
insert into actor values (5563,'Howard Duff');
insert into actor values (5564,'Paul Le Mat');
insert into actor values (5565,'Howard Da Silva');
insert into actor values (5566,'Paul Lukas');
insert into actor values (5567,'Paul Mann');
insert into actor values (5568,'Peewee Wilson');
insert into actor values (5569,'Howard Keel');
insert into actor values (5570,'Peter Billingsley');
insert into actor values (5571,'Henry Dinhofer');
insert into actor values (5572,'Pernilla Allwin');
insert into actor values (5573,'Pernilla August');
insert into actor values (5574,'Haya Harareet');
insert into actor values (5575,'Perry Lang');
insert into actor values (5576,'Harvey Stephens (II)');
insert into actor values (5577,'Harvey Lembeck');
insert into actor values (5578,'Per Theodor Haugen');
insert into actor values (5579,'Peter Behn');
insert into actor values (5580,'Pep Munné');
insert into actor values (5581,'Hartley Power');
insert into actor values (5582,'Peter Boyden');
insert into actor values (5583,'Harry Stockwell');
insert into actor values (5584,'Harry Secombe');
insert into actor values (5585,'Harry Guardino');
insert into actor values (5586,'Harry Carey Jr.');
insert into actor values (5587,'Harriet Walter');
insert into actor values (5588,'Pete O''Herne');
insert into actor values (5589,'Peggy Dow');
insert into actor values (5590,'Paul Ford (I)');
insert into actor values (5591,'Henri-Jacques Huet');
insert into actor values (5592,'Rebecka Liljeberg');
insert into actor values (5593,'Henning Moritzen');
insert into actor values (5594,'Gerry Skilton');
insert into actor values (5595,'Hema Malini');
insert into actor values (5596,'Helmut Qualtinger');
insert into actor values (5597,'Percy Edwards');
insert into actor values (5598,'Peggy Ashcroft');
insert into actor values (5599,'Pedro Armendáriz');
insert into actor values (5600,'Helen Morse');
--- tabactor, 5601, 50
insert into actor values (5601,'Peggy Gormley');
insert into actor values (5602,'Helen Miller (I)');
insert into actor values (5603,'Peggy Wood');
insert into actor values (5604,'Heidi von Palleske');
insert into actor values (5605,'Hector Pappaert');
insert into actor values (5606,'Heather-Jay Jones');
insert into actor values (5607,'Helmut Griem');
insert into actor values (5608,'Patricia Hitchcock');
insert into actor values (5609,'Patrick Bauchau');
insert into actor values (5610,'Jack Elam');
insert into actor values (5611,'Jack Creley');
insert into actor values (5612,'Pat Thompson (II)');
insert into actor values (5613,'Patcharawan Patarakijjanon');
insert into actor values (5614,'Jack Benny');
insert into actor values (5615,'J.D. Cannon');
insert into actor values (5616,'Jack Ging');
insert into actor values (5617,'J. Stephen Peace');
insert into actor values (5618,'Jack Haley (I)');
insert into actor values (5619,'Jüri Järvet');
insert into actor values (5620,'Patricia Kalember');
insert into actor values (5621,'Izabella Scorupco');
insert into actor values (5622,'Patricia Richardson');
insert into actor values (5623,'Ivan Lapikov');
insert into actor values (5624,'Itzhak Perlman');
insert into actor values (5625,'Paul Fox (II)');
insert into actor values (5626,'Patricia Collinge');
insert into actor values (5627,'Jack Starrett');
insert into actor values (5628,'Jacqueline Barba');
insert into actor values (5629,'Jacobo Morales');
insert into actor values (5630,'Jackson Lou');
insert into actor values (5631,'Jackie Sawris');
insert into actor values (5632,'Jackie Gleason');
insert into actor values (5633,'Pamela Hart');
insert into actor values (5634,'Pamela Stephenson');
insert into actor values (5635,'Pat Slowey');
insert into actor values (5636,'Jack Taylor (II)');
insert into actor values (5637,'Isabelle Pasco');
insert into actor values (5638,'Jack Oakie');
insert into actor values (5639,'Pat Boone');
insert into actor values (5640,'Pat Corley');
insert into actor values (5641,'Pat Henning');
insert into actor values (5642,'Jack Lord');
insert into actor values (5643,'Pat O''Brien');
insert into actor values (5644,'Jack Kelly (I)');
insert into actor values (5645,'Pamela Tiffin');
insert into actor values (5646,'Ian Fried');
insert into actor values (5647,'Isao Hashizume');
insert into actor values (5648,'Ibrahim Ferrer');
insert into actor values (5649,'Paul Benedict');
insert into actor values (5650,'Ian Watkin');
--- tabactor, 5651, 50
insert into actor values (5651,'Ian Petrella');
insert into actor values (5652,'Ian Ogilvy');
insert into actor values (5653,'Paul Burke');
insert into actor values (5654,'Ilan Mitchell-Smith');
insert into actor values (5655,'Paul Chen');
insert into actor values (5656,'Paul A. Partain');
insert into actor values (5657,'Paul Cicero');
insert into actor values (5658,'Paul Collins (I)');
insert into actor values (5659,'Paul Dawson (II)');
insert into actor values (5660,'Iain Robertson');
insert into actor values (5661,'Iain Cuthbertson');
insert into actor values (5662,'Paul Drake (I)');
insert into actor values (5663,'Henki Kolstad');
insert into actor values (5664,'Ian Hendry (I)');
insert into actor values (5665,'Ingrid Thulin');
insert into actor values (5666,'Patrick Breen');
insert into actor values (5667,'Isabel Glasser');
insert into actor values (5668,'Patrick Fugit');
insert into actor values (5669,'Isa Danieli');
insert into actor values (5670,'Irma Raush');
insert into actor values (5671,'Irene Miracle');
insert into actor values (5672,'Patrick McGaw');
insert into actor values (5673,'Paul Barber (I)');
insert into actor values (5674,'Patrick Renna');
insert into actor values (5675,'Hugh O''Brian');
insert into actor values (5676,'Ingrid Rogers');
insert into actor values (5677,'Ing-Marie Carlsson');
insert into actor values (5678,'Imogene Coca');
insert into actor values (5679,'Imogen Stubbs');
insert into actor values (5680,'Imogen Boorman');
insert into actor values (5681,'Iman');
insert into actor values (5682,'Ilse Steppat');
insert into actor values (5683,'Patrick Mercado');
insert into actor values (5684,'Giulietta Masina');
insert into actor values (5685,'Giuliana Lojodice');
insert into actor values (5686,'Gus Mercurio');
insert into actor values (5687,'Peter McDonald');
insert into actor values (5688,'Hanno Pöschl');
insert into actor values (5689,'Glen Berry');
insert into actor values (5690,'Guillaume Canet');
insert into actor values (5691,'Hanna R. Hall');
insert into actor values (5692,'Giustino Durano');
insert into actor values (5693,'Peter Gowen');
insert into actor values (5694,'Peter Outerbridge');
insert into actor values (5695,'Godfrey Tearle');
insert into actor values (5696,'Pierre Clémenti');
insert into actor values (5697,'Pietro Falcone');
insert into actor values (5698,'Peter Sarsgaard');
insert into actor values (5699,'Hal Delrich');
insert into actor values (5700,'Pierre Brasseur');
--- tabactor, 5701, 50
insert into actor values (5701,'Peter Ostrum');
insert into actor values (5702,'Gwenn Mitchell');
insert into actor values (5703,'Peter Jurasik');
insert into actor values (5704,'Phil Buckman');
insert into actor values (5705,'Philip Ober');
insert into actor values (5706,'Peter Krantz');
insert into actor values (5707,'Hélène Vincent');
insert into actor values (5708,'Haley Miller (I)');
insert into actor values (5709,'Guy Decomble');
insert into actor values (5710,'Pierre Renoir');
insert into actor values (5711,'Hans Matheson');
insert into actor values (5712,'Gloria Charles');
insert into actor values (5713,'Halina Gryglaszewska');
insert into actor values (5714,'Gloria Swanson');
insert into actor values (5715,'Glen Cavender');
insert into actor values (5716,'Glen Campbell');
insert into actor values (5717,'Guy Kibbee');
insert into actor values (5718,'Pierre Fresnay');
insert into actor values (5719,'Piotr Kozlowski');
insert into actor values (5720,'Peter Donaldson');
insert into actor values (5721,'Gordon Warnecke');
insert into actor values (5722,'Giovanna Galletti');
insert into actor values (5723,'Goran Visnjic');
insert into actor values (5724,'Harold Hopkins');
insert into actor values (5725,'Phil Spector');
insert into actor values (5726,'Gregor Fisher');
insert into actor values (5727,'Priscilla Lane');
insert into actor values (5728,'Harold Oblong');
insert into actor values (5729,'Phil Reeves');
insert into actor values (5730,'Harold Sylvester');
insert into actor values (5731,'Philip Gordon');
insert into actor values (5732,'Philip King');
insert into actor values (5733,'Quincy Jones');
insert into actor values (5734,'Rémy Girard');
insert into actor values (5735,'Greg Grunberg');
insert into actor values (5736,'Gert Bastian');
insert into actor values (5737,'Quentin Crisp');
insert into actor values (5738,'Hans von Borsody');
insert into actor values (5739,'Greta Lind');
insert into actor values (5740,'Gitt Magrini');
insert into actor values (5741,'Henri Serre');
insert into actor values (5742,'Qi Lu');
insert into actor values (5743,'Phyllis Diller (I)');
insert into actor values (5744,'Harold Fong');
insert into actor values (5745,'Phoebe Augustine');
insert into actor values (5746,'Harald Heide-Steen Jr.');
insert into actor values (5747,'Hardy Krüger');
insert into actor values (5748,'Peter Finch');
insert into actor values (5749,'Harold Baigent');
insert into actor values (5750,'Drew Snyder');
--- tabactor, 5751, 50
insert into actor values (5751,'Max Wright');
insert into actor values (5752,'Eddie Jones (I)');
insert into actor values (5753,'Robert Lesser');
insert into actor values (5754,'Mary Ellen Trainor');
insert into actor values (5755,'Michael Milhoan');
insert into actor values (5756,'Celia Weston');
insert into actor values (5757,'Roy Brocksmith');
insert into actor values (5758,'Geoffrey Lewis (I)');
insert into actor values (5759,'William Hootkins');
insert into actor values (5760,'J. Kenneth Campbell');
insert into actor values (5761,'Gregory Sierra');
insert into actor values (5762,'Vyto Ruginis');
insert into actor values (5763,'John Carroll Lynch');
insert into actor values (5764,'Julio Oscar Mechoso');
insert into actor values (5765,'Frances Conroy');
insert into actor values (5766,'Stanley Anderson');
insert into actor values (5767,'Harry Shearer');
insert into actor values (5768,'Tom Noonan');
insert into actor values (5769,'George Cheung');
insert into actor values (5770,'Frank Adonis');
insert into actor values (5771,'Andrew Bryniarski');
insert into actor values (5772,'Leslie Phillips (I)');
insert into actor values (5773,'Rene Auberjonois');
insert into actor values (5774,'Gregory Jbara');
insert into actor values (5775,'Sean Whalen');
insert into actor values (5776,'Jack Walsh (I)');
insert into actor values (5777,'Jude Ciccolella');
insert into actor values (5778,'Shane Rimmer');
insert into actor values (5779,'Norbert Weisser');
insert into actor values (5780,'Bradford English');
insert into actor values (5781,'Sean Stone');
insert into actor values (5782,'Alice Drummond');
insert into actor values (5783,'John Hawkes (I)');
insert into actor values (5784,'George Wallace (I)');
insert into actor values (5785,'I.M. Hobson');
insert into actor values (5786,'MacIntyre Dixon');
insert into actor values (5787,'Raye Birk');
insert into actor values (5788,'Jack Purvis');
insert into actor values (5789,'Roger Guenveur Smith');
insert into actor values (5790,'William Smith (I)');
insert into actor values (5791,'James Keane (I)');
insert into actor values (5792,'Henry Gibson');
insert into actor values (5793,'Thomas Jefferson Byrd');
insert into actor values (5794,'Tim Guinee');
insert into actor values (5795,'John Bluthal');
insert into actor values (5796,'Margo Martindale');
insert into actor values (5797,'Richard Hamilton');
insert into actor values (5798,'Eric Edwards (I)');
insert into actor values (5799,'George Furth');
insert into actor values (5800,'Edward Bunker');
--- tabactor, 5801, 50
insert into actor values (5801,'Ann Cusack');
insert into actor values (5802,'Matt Clark (I)');
insert into actor values (5803,'David Wohl');
insert into actor values (5804,'Dirk Blocker');
insert into actor values (5805,'Ed Williams (II)');
insert into actor values (5806,'John Ventimiglia');
insert into actor values (5807,'Gerard Horan');
insert into actor values (5808,'Michael Champion');
insert into actor values (5809,'Philip Tan');
insert into actor values (5810,'Graham Jarvis (I)');
insert into actor values (5811,'Benito Stefanelli');
insert into actor values (5812,'Patty Hearst');
insert into actor values (5813,'Eddra Gale');
insert into actor values (5814,'James Lally');
insert into actor values (5815,'Camryn Manheim');
insert into actor values (5816,'Britt Leach');
insert into actor values (5817,'Calvin Lockhart');
insert into actor values (5818,'Roger Aaron Brown');
insert into actor values (5819,'Lela Rochon');
insert into actor values (5820,'Badja Djola');
insert into actor values (5821,'J. Patrick McNamara');
insert into actor values (5822,'George Buck');
insert into actor values (5823,'Norman Lloyd');
insert into actor values (5824,'Lee Wallace');
insert into actor values (5825,'Dick Warlock');
insert into actor values (5826,'George Aguilar');
insert into actor values (5827,'Michael Jace');
insert into actor values (5828,'Obba Babatundé');
insert into actor values (5829,'Octavia Spencer');
insert into actor values (5830,'Donald Hotton');
insert into actor values (5831,'Duane Martin');
insert into actor values (5832,'Catherine Kellner');
insert into actor values (5833,'Claude Akins');
insert into actor values (5834,'Basil Hoffman');
insert into actor values (5835,'John Roselius');
insert into actor values (5836,'Gene Hartline');
insert into actor values (5837,'Ed Crowley');
insert into actor values (5838,'Tracey Ellis');
insert into actor values (5839,'Susan Blommaert');
insert into actor values (5840,'Una O''Connor');
insert into actor values (5841,'Beau Billingslea');
insert into actor values (5842,'Godfrey Quigley');
insert into actor values (5843,'Burton Gilliam');
insert into actor values (5844,'Ralph Seymour');
insert into actor values (5845,'Don Yesso');
insert into actor values (5846,'Duncan Fraser (II)');
insert into actor values (5847,'Russi Taylor');
insert into actor values (5848,'Alan Fudge');
insert into actor values (5849,'Chi McBride');
insert into actor values (5850,'Joanna Barnes');
--- tabactor, 5851, 50
insert into actor values (5851,'Mariel Hemingway');
insert into actor values (5852,'Bodhi Elfman');
insert into actor values (5853,'Annie Ross');
insert into actor values (5854,'Dash Mihok');
insert into actor values (5855,'Tom Wright (I)');
insert into actor values (5856,'Christopher Adamson');
insert into actor values (5857,'Tim McInnerny');
insert into actor values (5858,'Scott Coffey');
insert into actor values (5859,'Joyce Van Patten');
insert into actor values (5860,'Frank McCarthy (I)');
insert into actor values (5861,'Darrell Zwerling');
insert into actor values (5862,'Henry Brandon');
insert into actor values (5863,'André Morell');
insert into actor values (5864,'André Maranne');
insert into actor values (5865,'Brad Garrett');
insert into actor values (5866,'Frank Sivero');
insert into actor values (5867,'Walter Sparrow');
insert into actor values (5868,'Henry O');
insert into actor values (5869,'Hal Landon Jr.');
insert into actor values (5870,'Kelly Bishop');
insert into actor values (5871,'Peter Jeffrey (I)');
insert into actor values (5872,'Andre Gregory');
insert into actor values (5873,'Ferdy Mayne');
insert into actor values (5874,'Sean McCann');
insert into actor values (5875,'Sean O''Bryan');
insert into actor values (5876,'Jerry Tondo');
insert into actor values (5877,'Mark L. Taylor');
insert into actor values (5878,'Harry J. Lennix');
insert into actor values (5879,'Daniel Lapaine');
insert into actor values (5880,'Flea');
insert into actor values (5881,'Anita Gillette');
insert into actor values (5882,'Blake Clark');
insert into actor values (5883,'Joyce Jameson');
insert into actor values (5884,'Billy Barty');
insert into actor values (5885,'Ken Hudson Campbell');
insert into actor values (5886,'Micole Mercurio');
insert into actor values (5887,'Penny Bae Bridges');
insert into actor values (5888,'Tiny Ron');
insert into actor values (5889,'Danny Nucci');
insert into actor values (5890,'Richard Stahl');
insert into actor values (5891,'Jessie Lawrence Ferguson');
insert into actor values (5892,'Penn Jillette');
insert into actor values (5893,'Richard Venture');
insert into actor values (5894,'Jennifer Coolidge');
insert into actor values (5895,'Frank Baker (III)');
insert into actor values (5896,'Richard Herd');
insert into actor values (5897,'Garette Ratliff Henson');
insert into actor values (5898,'Ellen Foley');
insert into actor values (5899,'Tony Jay');
insert into actor values (5900,'Neal McDonough');
--- tabactor, 5901, 50
insert into actor values (5901,'Samantha Eggar');
insert into actor values (5902,'Tom Green (III)');
insert into actor values (5903,'Elizabeth Whitcraft');
insert into actor values (5904,'Paul Fix');
insert into actor values (5905,'Elizabeth Franz');
insert into actor values (5906,'Elizabeth Bracco');
insert into actor values (5907,'Erick Avari');
insert into actor values (5908,'David Neidorf');
insert into actor values (5909,'Gretchen Palmer');
insert into actor values (5910,'Jon Kasdan');
insert into actor values (5911,'Garry Cooper');
insert into actor values (5912,'Nestor Serrano');
insert into actor values (5913,'Steven Randazzo');
insert into actor values (5914,'Niall Buggy');
insert into actor values (5915,'Red West');
insert into actor values (5916,'Nicholas Bell');
insert into actor values (5917,'Jane Morris');
insert into actor values (5918,'S. Epatha Merkerson');
insert into actor values (5919,'Celia Imrie');
insert into actor values (5920,'Michael Tucker (I)');
insert into actor values (5921,'Rex Everhart');
insert into actor values (5922,'Philip Moon');
insert into actor values (5923,'Christopher Hart');
insert into actor values (5924,'H.B. Warner');
insert into actor values (5925,'Bibi Besch');
insert into actor values (5926,'Christopher John Fields');
insert into actor values (5927,'Kenneth Colley');
insert into actor values (5928,'Dakin Matthews');
insert into actor values (5929,'Kenneth McMillan');
insert into actor values (5930,'Marc Lawrence (I)');
insert into actor values (5931,'Nancy Stephens');
insert into actor values (5932,'Peter Van Norden');
insert into actor values (5933,'Peter MacNeill (I)');
insert into actor values (5934,'Regis Toomey');
insert into actor values (5935,'Steve Hytner');
insert into actor values (5936,'Manning Redwood');
insert into actor values (5937,'Peter McRobbie');
insert into actor values (5938,'Tony Genaro');
insert into actor values (5939,'David Jensen (I)');
insert into actor values (5940,'Majel Barrett');
insert into actor values (5941,'Ren Woods');
insert into actor values (5942,'Jonathan Loughran');
insert into actor values (5943,'David Knell');
insert into actor values (5944,'Ken Curtis (I)');
insert into actor values (5945,'Gwen Verdon');
--- tabmovie, 1, 50
insert into movie values (1,'Star Wars',1977,8.80,53567,360);
insert into movie values (2,'Shawshank Redemption, The',1994,9.00,44974,1040);
insert into movie values (3,'Pulp Fiction',1994,8.60,43993,444);
insert into movie values (4,'Titanic',1997,7.20,43371,198);
insert into movie values (5,'Star Wars: Episode V - The Empire Strikes Back',1980,8.60,39446,651);
insert into movie values (6,'Usual Suspects, The',1995,8.70,35027,639);
insert into movie values (7,'Schindler''s List',1993,8.80,34251,18);
insert into movie values (8,'Saving Private Ryan',1998,8.50,34113,18);
insert into movie values (9,'Braveheart',1995,8.30,32870,22);
insert into movie values (10,'American Beauty',1999,8.80,32547,2542);
insert into movie values (11,'Raiders of the Lost Ark',1981,8.60,31750,18);
insert into movie values (12,'Godfather, The',1972,9.00,31225,28);
insert into movie values (13,'Star Wars: Episode VI - Return of the Jedi',1983,8.00,30178,1020);
insert into movie values (14,'Blade Runner',1982,8.30,29877,110);
insert into movie values (15,'Silence of the Lambs, The',1991,8.50,29582,281);
insert into movie values (16,'Forrest Gump',1994,7.80,29400,67);
insert into movie values (17,'Star Wars: Episode I - The Phantom Menace',1999,7.30,28641,360);
insert into movie values (18,'Sixth Sense, The',1999,8.50,27626,966);
insert into movie values (19,'Independence Day',1996,6.00,26259,290);
insert into movie values (20,'Terminator 2: Judgment Day',1991,7.90,25767,198);
insert into movie values (21,'Se7en',1995,8.10,25158,414);
insert into movie values (22,'Fargo',1996,8.20,25044,111);
insert into movie values (23,'2001: A Space Odyssey',1968,8.30,24536,82);
insert into movie values (24,'Aliens',1986,8.20,23965,198);
insert into movie values (25,'Truman Show, The',1998,7.80,23665,86);
insert into movie values (26,'Back to the Future',1985,7.80,23306,67);
insert into movie values (27,'Casablanca',1942,8.80,23283,675);
insert into movie values (28,'One Flew Over the Cuckoo''s Nest',1975,8.70,22868,408);
insert into movie values (29,'Good Will Hunting',1997,7.90,22734,271);
insert into movie values (30,'Fifth Element, The',1997,7.00,22365,389);
insert into movie values (31,'Twelve Monkeys',1995,7.80,22342,59);
insert into movie values (32,'Gladiator',2000,8.30,21955,110);
insert into movie values (33,'Fight Club',1999,8.50,21391,414);
insert into movie values (34,'Clockwork Orange, A',1971,8.20,21216,82);
insert into movie values (35,'Alien',1979,8.20,20998,110);
insert into movie values (36,'Princess Bride, The',1987,8.20,20931,37);
insert into movie values (37,'Indiana Jones and the Last Crusade',1989,7.80,20897,18);
insert into movie values (38,'Fugitive, The',1993,7.80,20843,291);
insert into movie values (39,'Reservoir Dogs',1992,8.20,20343,444);
insert into movie values (40,'Citizen Kane',1941,8.80,20269,253);
insert into movie values (41,'Dr. Strangelove or: How I Learned to Stop Worrying and Love the Bomb',1964,8.70,20034,82);
insert into movie values (42,'Die Hard',1988,7.90,19929,196);
insert into movie values (43,'Goodfellas',1990,8.50,19430,78);
insert into movie values (44,'Scream',1996,7.20,19350,133);
insert into movie values (45,'Apocalypse Now',1979,8.30,19335,28);
insert into movie values (46,'Terminator, The',1984,7.80,18995,198);
insert into movie values (47,'As Good As It Gets',1997,7.80,18856,574);
insert into movie values (48,'Dead Poets Society',1989,7.70,18769,86);
insert into movie values (49,'Monty Python and the Holy Grail',1975,8.30,18640,59);
insert into movie values (50,'Trainspotting',1996,7.80,18428,597);
--- tabmovie, 51, 50
insert into movie values (51,'Rock, The',1996,7.00,18013,678);
insert into movie values (52,'Shakespeare in Love',1998,7.90,17918,1011);
insert into movie values (53,'Apollo 13',1995,7.60,17797,21);
insert into movie values (54,'Psycho',1960,8.60,17734,11);
insert into movie values (55,'Contact',1997,7.60,17390,67);
insert into movie values (56,'There''s Something About Mary',1998,7.30,17352,2459);
insert into movie values (57,'Toy Story',1995,7.90,16971,1044);
insert into movie values (58,'Armageddon',1998,5.80,16581,678);
insert into movie values (59,'Blair Witch Project, The',1999,6.60,16204,2248);
insert into movie values (60,'Rain Man',1988,7.80,15933,38);
insert into movie values (61,'Godfather: Part II, The',1974,8.80,15487,28);
insert into movie values (62,'Face/Off',1997,7.20,14744,204);
insert into movie values (63,'Shining, The',1980,8.10,14653,82);
insert into movie values (64,'Amadeus',1984,8.20,14351,408);
insert into movie values (65,'Taxi Driver',1976,8.40,14090,78);
insert into movie values (66,'E.T. the Extra-Terrestrial',1982,7.70,14062,18);
insert into movie values (67,'Blues Brothers, The',1980,7.50,13979,62);
insert into movie values (68,'Star Trek: First Contact',1996,7.20,13948,500);
insert into movie values (69,'Full Metal Jacket',1987,8.10,13863,82);
insert into movie values (70,'Being John Malkovich',1999,8.30,13809,1485);
insert into movie values (71,'Clerks',1994,7.90,13803,445);
insert into movie values (72,'Wizard of Oz, The',1939,8.30,13444,1151);
insert into movie values (73,'Green Mile, The',1999,8.30,13409,1040);
insert into movie values (74,'Vita è bella, La',1997,8.60,13403,820);
insert into movie values (75,'Austin Powers: International Man of Mystery',1997,7.00,13372,604);
insert into movie values (76,'Ferris Bueller''s Day Off',1986,7.60,13326,144);
insert into movie values (77,'Starship Troopers',1997,6.60,13205,201);
insert into movie values (78,'Groundhog Day',1993,7.70,13093,108);
insert into movie values (79,'Mission: Impossible',1996,6.40,13029,31);
insert into movie values (80,'Heat',1995,7.70,13016,1106);
insert into movie values (81,'English Patient, The',1996,7.10,12995,621);
insert into movie values (82,'American History X',1998,8.30,12977,2663);
insert into movie values (83,'Top Gun',1986,6.40,12851,107);
insert into movie values (84,'Speed',1994,7.00,12715,421);
insert into movie values (85,'Twister',1996,5.90,12597,421);
insert into movie values (86,'Batman',1989,7.10,12512,148);
insert into movie values (87,'Rear Window',1954,8.70,12484,11);
insert into movie values (88,'Eyes Wide Shut',1999,7.30,12455,82);
insert into movie values (89,'Brazil',1985,8.00,12319,59);
insert into movie values (90,'Big Lebowski, The',1998,7.60,12266,111);
insert into movie values (91,'True Lies',1994,7.00,12109,198);
insert into movie values (92,'X-Men',2000,7.80,12093,639);
insert into movie values (93,'Full Monty, The',1997,7.40,11852,2757);
insert into movie values (94,'North by Northwest',1959,8.60,11588,11);
insert into movie values (95,'Chasing Amy',1997,7.60,11563,445);
insert into movie values (96,'Hunt for Red October, The',1990,7.50,11251,196);
insert into movie values (97,'Vertigo',1958,8.50,11231,11);
insert into movie values (98,'Dogma',1999,7.60,11133,445);
insert into movie values (99,'Mission: Impossible II',2000,6.30,11117,204);
insert into movie values (100,'Fish Called Wanda, A',1988,7.70,11075,2247);
--- tabmovie, 101, 50
insert into movie values (101,'American Pie',1999,7.10,10908,2859);
insert into movie values (102,'Austin Powers: The Spy Who Shagged Me',1999,6.50,10891,604);
insert into movie values (103,'Indiana Jones and the Temple of Doom',1984,6.90,10674,18);
insert into movie values (104,'When Harry Met Sally...',1989,7.60,10663,37);
insert into movie values (105,'Gone with the Wind',1939,8.10,10628,1151);
insert into movie values (106,'Stand by Me',1986,7.80,10579,37);
insert into movie values (107,'Batman  Robin',1997,3.50,10577,105);
insert into movie values (108,'Ghostbusters',1984,7.30,10543,109);
insert into movie values (109,'Dances with Wolves',1990,7.60,10522,10);
insert into movie values (110,'Sleepy Hollow',1999,7.50,10514,148);
insert into movie values (111,'South Park: Bigger, Longer and Uncut',1999,7.70,10471,270);
insert into movie values (112,'Three Kings',1999,7.70,10319,1070);
insert into movie values (113,'Platoon',1986,7.90,10272,69);
insert into movie values (114,'From Dusk Till Dawn',1996,6.60,10152,666);
insert into movie values (115,'Mummy, The',1999,6.60,10125,1103);
insert into movie values (116,'Toy Story 2',1999,8.50,10020,2043);
insert into movie values (117,'Air Force One',1997,6.50,9941,140);
insert into movie values (118,'Unforgiven',1992,7.90,9903,2);
insert into movie values (119,'Breakfast Club, The',1985,7.40,9760,144);
insert into movie values (120,'Field of Dreams',1989,7.60,9717,993);
insert into movie values (121,'To Kill a Mockingbird',1962,8.50,9707,2586);
insert into movie values (122,'Untouchables, The',1987,7.80,9592,31);
insert into movie values (123,'Graduate, The',1967,8.10,9558,47);
insert into movie values (124,'Thin Red Line, The',1998,7.20,9555,686);
insert into movie values (125,'Game, The',1997,7.50,9552,414);
insert into movie values (126,'Godzilla',1998,4.20,9464,290);
insert into movie values (127,'Boogie Nights',1997,7.50,9458,1037);
insert into movie values (128,'Abyss, The',1989,7.30,9434,198);
insert into movie values (129,'Romeo + Juliet',1996,6.60,9274,1069);
insert into movie values (130,'Total Recall',1990,7.10,9261,201);
insert into movie values (131,'Grosse Pointe Blank',1997,7.40,9211,2103);
insert into movie values (132,'X Files, The',1998,6.80,9114,2673);
insert into movie values (133,'Close Encounters of the Third Kind',1977,7.70,9107,18);
insert into movie values (134,'Few Good Men, A',1992,7.40,9077,37);
insert into movie values (135,'Exorcist, The',1973,7.90,8984,264);
insert into movie values (136,'Devil''s Advocate, The',1997,7.00,8983,674);
insert into movie values (137,'Scream 2',1997,6.20,8970,133);
insert into movie values (138,'Pleasantville',1998,7.50,8969,2118);
insert into movie values (139,'Deep Impact',1998,6.00,8950,589);
insert into movie values (140,'Con Air',1997,6.30,8917,1114);
insert into movie values (141,'Grease',1978,6.60,8857,383);
insert into movie values (142,'Natural Born Killers',1994,6.30,8744,69);
insert into movie values (143,'Sling Blade',1996,8.10,8740,298);
insert into movie values (144,'True Romance',1993,7.50,8657,107);
insert into movie values (145,'GoldenEye',1995,6.70,8484,2539);
insert into movie values (146,'Bug''s Life, A',1998,7.70,8481,1044);
insert into movie values (147,'Airplane!',1980,7.60,8431,189);
insert into movie values (148,'Back to the Future Part II',1989,6.60,8411,67);
insert into movie values (149,'Deer Hunter, The',1978,8.10,8393,2645);
insert into movie values (150,'Boot, Das',1981,8.50,8392,140);
--- tabmovie, 151, 50
insert into movie values (151,'Gattaca',1997,7.40,8388,2020);
insert into movie values (152,'Alien: Resurrection',1997,6.00,8363,2235);
insert into movie values (153,'Beauty and the Beast',1991,7.80,8306,2126);
insert into movie values (154,'Chinatown',1974,8.40,8280,90);
insert into movie values (155,'Casino',1995,7.60,8247,78);
insert into movie values (156,'World Is Not Enough, The',1999,6.60,8226,199);
insert into movie values (157,'Raising Arizona',1987,7.60,8185,111);
insert into movie values (158,'Army of Darkness',1993,7.20,8165,141);
insert into movie values (159,'12 Angry Men',1957,8.60,8158,80);
insert into movie values (160,'Batman Forever',1995,5.30,8130,105);
insert into movie values (161,'Sting, The',1973,8.20,8108,276);
insert into movie values (162,'Glory',1989,8.10,8079,382);
insert into movie values (163,'Raging Bull',1980,8.40,8029,78);
insert into movie values (164,'Dark City',1998,7.50,8024,1047);
insert into movie values (165,'Wallace  Gromit: The Wrong Trousers',1993,8.50,8024,572);
insert into movie values (166,'Beetlejuice',1988,6.90,8019,148);
insert into movie values (167,'Highlander',1986,7.10,8013,577);
insert into movie values (168,'Pretty Woman',1990,6.50,7993,129);
insert into movie values (169,'Notting Hill',1999,7.30,7977,2760);
insert into movie values (170,'Go',1999,7.80,7935,1163);
insert into movie values (171,'Sound of Music, The',1965,7.60,7913,286);
insert into movie values (172,'Crow, The',1994,6.90,7869,1047);
insert into movie values (173,'Patriot, The',2000,7.30,7826,290);
insert into movie values (174,'Enemy of the State',1998,7.20,7817,107);
insert into movie values (175,'Babe',1995,7.60,7811,2353);
insert into movie values (176,'Talented Mr. Ripley, The',1999,7.20,7797,621);
insert into movie values (177,'Who Framed Roger Rabbit',1988,7.30,7789,67);
insert into movie values (178,'Tomorrow Never Dies',1997,6.50,7683,407);
insert into movie values (179,'Dead Man Walking',1995,7.70,7636,25);
insert into movie values (180,'Out of Sight',1998,7.60,7555,689);
insert into movie values (181,'Sleepless in Seattle',1993,6.80,7551,1091);
insert into movie values (182,'Die Hard: With a Vengeance',1995,6.80,7544,196);
insert into movie values (183,'Aladdin',1992,7.50,7537,1152);
insert into movie values (184,'Dumb  Dumber',1994,6.20,7444,2825);
insert into movie values (185,'Wedding Singer, The',1998,6.80,7431,1054);
insert into movie values (186,'Insider, The',1999,8.20,7429,1106);
insert into movie values (187,'Negotiator, The',1998,7.20,7420,1035);
insert into movie values (188,'Perfect Storm, The',2000,6.60,7414,140);
insert into movie values (189,'Bridge on the River Kwai, The',1957,8.40,7395,1080);
insert into movie values (190,'Four Weddings and a Funeral',1994,7.20,7394,585);
insert into movie values (191,'Ransom',1996,6.70,7377,21);
insert into movie values (192,'Back to the Future Part III',1990,6.40,7337,67);
insert into movie values (193,'Rocky Horror Picture Show, The',1975,6.50,7288,2325);
insert into movie values (194,'Rushmore',1998,7.60,7269,1034);
insert into movie values (195,'Spaceballs',1987,6.40,7225,29);
insert into movie values (196,'Analyze This',1999,6.80,7224,108);
insert into movie values (197,'Die Hard 2',1990,6.60,7197,210);
insert into movie values (198,'Young Frankenstein',1974,8.00,7186,29);
insert into movie values (199,'Goldfinger',1964,7.70,7180,636);
insert into movie values (200,'Clueless',1995,6.70,7159,403);
--- tabmovie, 201, 50
insert into movie values (201,'Thelma  Louise',1991,7.20,7153,110);
insert into movie values (202,'Ronin',1998,7.00,7144,676);
insert into movie values (203,'Predator',1987,7.10,7136,196);
insert into movie values (204,'Cruel Intentions',1999,6.70,7081,2765);
insert into movie values (205,'Batman Returns',1992,6.20,7063,148);
insert into movie values (206,'Swingers',1996,7.50,7038,1163);
insert into movie values (207,'Basic Instinct',1992,6.50,7011,201);
insert into movie values (208,'Annie Hall',1977,8.20,6989,1);
insert into movie values (209,'Star Trek: The Wrath of Khan',1982,7.40,6969,571);
insert into movie values (210,'Waterworld',1995,5.30,6934,378);
insert into movie values (211,'Ben-Hur',1959,8.10,6927,620);
insert into movie values (212,'Animal House',1978,7.40,6925,62);
insert into movie values (213,'Blade',1998,6.70,6885,2861);
insert into movie values (214,'Dune',1984,6.10,6884,139);
insert into movie values (215,'Galaxy Quest',1999,7.50,6841,1101);
insert into movie values (216,'Shine',1996,7.50,6837,1135);
insert into movie values (217,'Simple Plan, A',1998,7.70,6763,141);
insert into movie values (218,'Ghost',1990,6.70,6741,1116);
insert into movie values (219,'Big',1988,7.20,6741,361);
insert into movie values (220,'Edward Scissorhands',1990,7.30,6697,148);
insert into movie values (221,'Christmas Story, A',1983,8.10,6693,579);
insert into movie values (222,'Singin'' in the Rain',1952,8.50,6662,428);
insert into movie values (223,'Time to Kill, A',1996,6.90,6658,105);
insert into movie values (224,'You''ve Got Mail',1998,6.40,6654,1091);
insert into movie values (225,'Butch Cassidy and the Sundance Kid',1969,8.10,6637,276);
insert into movie values (226,'Halloween',1978,7.50,6621,23);
insert into movie values (227,'Stargate',1994,6.20,6604,290);
insert into movie values (228,'Ed Wood',1994,7.80,6587,148);
insert into movie values (229,'Wild Things',1998,6.80,6569,974);
insert into movie values (230,'Elizabeth',1998,7.70,6562,2755);
insert into movie values (231,'Dracula',1992,6.90,6551,28);
insert into movie values (232,'My Best Friend''s Wedding',1997,6.50,6543,1169);
insert into movie values (233,'Robin Hood: Prince of Thieves',1991,6.30,6540,378);
insert into movie values (234,'High Fidelity',2000,7.90,6535,292);
insert into movie values (235,'Chicken Run',2000,8.00,6534,2802);
insert into movie values (236,'Sense and Sensibility',1995,7.70,6476,273);
insert into movie values (237,'Some Like It Hot',1959,8.40,6445,79);
insert into movie values (238,'Much Ado About Nothing',1993,7.50,6443,48);
insert into movie values (239,'Home Alone',1990,6.10,6430,156);
insert into movie values (240,'Ace Ventura: Pet Detective',1994,6.10,6414,586);
insert into movie values (241,'Shichinin no samurai',1954,9.00,6357,208);
insert into movie values (242,'While You Were Sleeping',1995,6.60,6353,411);
insert into movie values (243,'Witness',1985,7.60,6332,86);
insert into movie values (244,'I Know What You Did Last Summer',1997,5.30,6305,2420);
insert into movie values (245,'Alien³',1992,5.80,6293,414);
insert into movie values (246,'Player, The',1992,7.80,6278,155);
insert into movie values (247,'Wag the Dog',1997,6.90,6244,38);
insert into movie values (248,'Tombstone',1993,7.20,6171,631);
insert into movie values (249,'Buono, il brutto, il cattivo, Il',1966,8.50,6161,268);
insert into movie values (250,'Erin Brockovich',2000,7.60,6152,689);
--- tabmovie, 251, 50
insert into movie values (251,'End of Days',1999,5.50,6095,103);
insert into movie values (252,'Star Trek: Insurrection',1998,6.40,6088,500);
insert into movie values (253,'Sleepers',1996,6.80,6052,38);
insert into movie values (254,'Antz',1998,7.20,6045,2072);
insert into movie values (255,'City of Angels',1998,6.30,6022,1139);
insert into movie values (256,'Event Horizon',1997,5.40,5993,653);
insert into movie values (257,'Birds, The',1963,7.80,5969,11);
insert into movie values (258,'Superman',1978,6.90,5958,209);
insert into movie values (259,'Mrs. Doubtfire',1993,6.40,5956,156);
insert into movie values (260,'Entrapment',1999,6.20,5940,669);
insert into movie values (261,'Rocky',1976,7.60,5933,683);
insert into movie values (262,'Goonies, The',1985,6.70,5908,209);
insert into movie values (263,'Blazing Saddles',1974,7.60,5876,29);
insert into movie values (264,'This Is Spinal Tap',1984,7.90,5854,37);
insert into movie values (265,'Hook',1991,5.60,5852,18);
insert into movie values (266,'Donnie Brasco',1997,7.50,5832,585);
insert into movie values (267,'What''s Eating Gilbert Grape',1993,7.50,5808,387);
insert into movie values (268,'Scent of a Woman',1992,7.20,5799,595);
insert into movie values (269,'Philadelphia',1993,7.30,5790,281);
insert into movie values (270,'Crimson Tide',1995,7.10,5784,107);
insert into movie values (271,'Great Escape, The',1963,8.20,5783,2473);
insert into movie values (272,'Wayne''s World',1992,6.60,5756,1021);
insert into movie values (273,'Broken Arrow',1996,5.80,5751,204);
insert into movie values (274,'8MM',1999,6.00,5744,105);
insert into movie values (275,'Beverly Hills Cop',1984,7.00,5717,595);
insert into movie values (276,'Excalibur',1981,7.40,5716,293);
insert into movie values (277,'Election',1999,7.70,5713,2199);
insert into movie values (278,'Unbreakable',2000,7.50,5701,966);
insert into movie values (279,'Get Shorty',1995,7.00,5693,422);
insert into movie values (280,'Star Trek: Generations',1994,6.00,5674,2282);
insert into movie values (281,'Dangerous Liaisons',1988,7.70,5651,292);
insert into movie values (282,'Dazed and Confused',1993,7.10,5643,205);
insert into movie values (283,'Gandhi',1982,7.80,5643,235);
insert into movie values (284,'Blue Velvet',1986,7.60,5628,139);
insert into movie values (285,'Sneakers',1992,7.00,5627,993);
insert into movie values (286,'RoboCop',1987,6.90,5596,201);
insert into movie values (287,'Cider House Rules, The',1999,7.70,5588,387);
insert into movie values (288,'Third Man, The',1949,8.60,5576,1003);
insert into movie values (289,'Payback',1999,7.00,5566,2427);
insert into movie values (290,'Fantasia',1940,7.90,5552,1167);
insert into movie values (291,'Happy Gilmore',1996,6.60,5539,330);
insert into movie values (292,'Piano, The',1993,7.30,5526,575);
insert into movie values (293,'Saint, The',1997,5.70,5522,212);
insert into movie values (294,'Desperado',1995,6.60,5510,666);
insert into movie values (295,'Eraser',1996,6.00,5504,1122);
insert into movie values (296,'Strange Days',1995,6.90,5489,641);
insert into movie values (297,'Good Morning, Vietnam',1987,7.00,5485,38);
insert into movie values (298,'In the Line of Fire',1993,7.30,5481,140);
insert into movie values (299,'African Queen, The',1951,8.20,5468,312);
insert into movie values (300,'Phenomenon',1996,6.40,5456,411);
--- tabmovie, 301, 50
insert into movie values (301,'Thomas Crown Affair, The',1999,6.80,5444,196);
insert into movie values (302,'Fisher King, The',1991,7.30,5441,59);
insert into movie values (303,'Central do Brasil',1998,8.10,5429,2560);
insert into movie values (304,'Arlington Road',1999,7.20,5422,1897);
insert into movie values (305,'Mission to Mars',2000,4.80,5420,31);
insert into movie values (306,'Willy Wonka  the Chocolate Factory',1971,7.40,5392,2740);
insert into movie values (307,'Fried Green Tomatoes',1991,7.30,5388,691);
insert into movie values (308,'Deep Blue Sea',1999,6.00,5336,210);
insert into movie values (309,'Heathers',1989,7.40,5327,371);
insert into movie values (310,'Wild Wild West',1999,4.00,5323,422);
insert into movie values (311,'Conspiracy Theory',1997,6.50,5322,209);
insert into movie values (312,'Cape Fear',1991,7.00,5319,78);
insert into movie values (313,'Hamlet',1996,7.70,5317,48);
insert into movie values (314,'Gremlins',1984,6.60,5297,150);
insert into movie values (315,'Tootsie',1982,7.50,5291,92);
insert into movie values (316,'Waterboy, The',1998,5.50,5272,1054);
insert into movie values (317,'Scream 3',2000,6.10,5268,133);
insert into movie values (318,'Net, The',1995,5.60,5263,1172);
insert into movie values (319,'Firm, The',1993,6.50,5255,92);
insert into movie values (320,'That Thing You Do!',1996,6.60,5253,8);
insert into movie values (321,'Rush Hour',1998,6.70,5246,1094);
insert into movie values (322,'Gone in Sixty Seconds',2000,6.00,5234,2362);
insert into movie values (323,'Nightmare Before Christmas, The',1993,7.50,5226,1036);
insert into movie values (324,'Nuovo cinema Paradiso',1988,8.20,5178,2142);
insert into movie values (325,'Bound',1996,7.50,5127,2024);
insert into movie values (326,'West Side Story',1961,7.70,5101,2295);
insert into movie values (327,'Quiz Show',1994,7.40,5094,36);
insert into movie values (328,'WarGames',1983,6.80,5074,66);
insert into movie values (329,'Scary Movie',2000,5.80,5059,1361);
insert into movie values (330,'In  Out',1997,6.20,5055,123);
insert into movie values (331,'Wo hu zang long',2000,9.00,5016,273);
insert into movie values (332,'Spartacus',1960,8.00,5006,82);
insert into movie values (333,'Right Stuff, The',1983,8.00,5006,288);
insert into movie values (334,'Outbreak',1995,6.50,4999,140);
insert into movie values (335,'Evil Dead II',1987,7.40,4994,141);
insert into movie values (336,'Sphere',1998,5.10,4991,38);
insert into movie values (337,'Caddyshack',1980,6.80,4989,108);
insert into movie values (338,'Cable Guy, The',1996,5.40,4985,242);
insert into movie values (339,'American President, The',1995,7.00,4975,37);
insert into movie values (340,'My Fair Lady',1964,7.80,4969,628);
insert into movie values (341,'Crocodile Dundee',1986,6.50,4962,2823);
insert into movie values (342,'Once Upon a Time in America',1984,8.00,4959,268);
insert into movie values (343,'Backdraft',1991,6.50,4949,21);
insert into movie values (344,'Clear and Present Danger',1994,6.90,4943,212);
insert into movie values (345,'Ghostbusters II',1989,5.30,4919,109);
insert into movie values (346,'U-571',2000,6.90,4917,1120);
insert into movie values (347,'Birdcage, The',1996,6.50,4902,47);
insert into movie values (348,'Sliding Doors',1998,7.00,4886,1940);
insert into movie values (349,'Star Trek IV: The Voyage Home',1986,7.00,4879,193);
insert into movie values (350,'Scarface',1983,7.40,4877,31);
--- tabmovie, 351, 50
insert into movie values (351,'People vs. Larry Flynt, The',1996,7.20,4873,408);
insert into movie values (352,'Mr. Holland''s Opus',1995,7.00,4865,149);
insert into movie values (353,'Haunting, The',1999,4.80,4835,421);
insert into movie values (354,'Bone Collector, The',1999,6.20,4810,212);
insert into movie values (355,'In the Name of the Father',1993,7.70,4793,581);
insert into movie values (356,'Patriot Games',1992,6.80,4774,212);
insert into movie values (357,'Dirty Dancing',1987,5.80,4769,662);
insert into movie values (358,'Ever After',1998,7.20,4764,654);
insert into movie values (359,'Bowfinger',1999,6.80,4759,123);
insert into movie values (360,'Thing, The',1982,7.50,4751,23);
insert into movie values (361,'Hudsucker Proxy, The',1994,7.30,4743,111);
insert into movie values (362,'Planet of the Apes',1968,7.60,4742,405);
insert into movie values (363,'Elephant Man, The',1980,8.00,4728,139);
insert into movie values (364,'Any Given Sunday',1999,6.70,4722,69);
insert into movie values (365,'Ice Storm, The',1997,7.50,4718,273);
insert into movie values (366,'Nikita',1990,7.60,4714,389);
insert into movie values (367,'Naked Gun: From the Files of Police Squad!, The',1988,7.30,4707,573);
insert into movie values (368,'What Dreams May Come',1998,6.20,4686,2500);
insert into movie values (369,'Demolition Man',1993,6.10,4682,1182);
insert into movie values (370,'Showgirls',1995,3.50,4672,201);
insert into movie values (371,'American Graffiti',1973,7.70,4669,360);
insert into movie values (372,'Awakenings',1990,7.40,4662,361);
insert into movie values (373,'Fear and Loathing in Las Vegas',1998,6.50,4658,59);
insert into movie values (374,'Breaking the Waves',1996,7.70,4645,615);
insert into movie values (375,'Private Parts',1997,6.60,4644,425);
insert into movie values (376,'Patton',1970,8.10,4637,405);
insert into movie values (377,'Cool Hand Luke',1967,8.10,4635,1029);
insert into movie values (378,'Postino, Il',1994,7.70,4630,1154);
insert into movie values (379,'Whole Nine Yards, The',2000,6.70,4626,262);
insert into movie values (380,'Avengers, The',1998,3.40,4623,412);
insert into movie values (381,'Heavenly Creatures',1994,7.80,4592,326);
insert into movie values (382,'Patch Adams',1998,6.20,4569,586);
insert into movie values (383,'Wallace  Gromit: A Close Shave',1995,8.20,4561,572);
insert into movie values (384,'10 Things I Hate About You',1999,7.10,4539,2129);
insert into movie values (385,'Snake Eyes',1998,5.70,4536,31);
insert into movie values (386,'Remains of the Day, The',1993,7.80,4528,576);
insert into movie values (387,'October Sky',1999,8.00,4510,424);
insert into movie values (388,'Addams Family, The',1991,6.40,4499,422);
insert into movie values (389,'American Psycho',2000,7.00,4487,2531);
insert into movie values (390,'Breakfast at Tiffany''s',1961,7.70,4483,65);
insert into movie values (391,'Boys Don''t Cry',1999,8.00,4481,2172);
insert into movie values (392,'Miller''s Crossing',1990,7.90,4453,111);
insert into movie values (393,'Name der Rose, Der',1986,7.50,4453,1131);
insert into movie values (394,'Dragonheart',1996,6.20,4432,376);
insert into movie values (395,'Bringing Out the Dead',1999,7.00,4431,78);
insert into movie values (396,'Deliverance',1972,7.80,4418,293);
insert into movie values (397,'Delicatessen',1991,7.70,4394,995);
insert into movie values (398,'Shallow Grave',1994,7.40,4387,597);
insert into movie values (399,'Charlie''s Angels',2000,6.90,4374,2358);
insert into movie values (400,'All the President''s Men',1976,7.80,4361,275);
--- tabmovie, 401, 50
insert into movie values (401,'Mulan',1998,7.40,4360,2651);
insert into movie values (402,'Star Trek: The Motion Picture',1979,5.50,4358,286);
insert into movie values (403,'Conan the Barbarian',1982,6.20,4356,693);
insert into movie values (404,'Akira',1988,7.40,4321,2045);
insert into movie values (405,'Double Jeopardy',1999,6.00,4321,685);
insert into movie values (406,'Twins',1988,6.00,4318,109);
insert into movie values (407,'Speed 2: Cruise Control',1997,3.20,4313,421);
insert into movie values (408,'Dave',1993,7.10,4305,109);
insert into movie values (409,'Rebel Without a Cause',1955,7.80,4296,1706);
insert into movie values (410,'Star Trek VI: The Undiscovered Country',1991,6.70,4287,571);
insert into movie values (411,'Faculty, The',1998,6.30,4287,666);
insert into movie values (412,'Pi',1998,7.50,4283,1136);
insert into movie values (413,'Big Daddy',1999,6.10,4275,330);
insert into movie values (414,'Say Anything...',1989,7.50,4257,391);
insert into movie values (415,'Ace Ventura: When Nature Calls',1995,4.50,4250,948);
insert into movie values (416,'Midnight Cowboy',1969,7.90,4250,677);
insert into movie values (417,'Gods and Monsters',1998,7.80,4241,2365);
insert into movie values (418,'She''s All That',1999,6.00,4240,2491);
insert into movie values (419,'Nutty Professor, The',1996,6.00,4234,586);
insert into movie values (420,'Pitch Black',2000,6.60,4216,1071);
insert into movie values (421,'Bill  Ted''s Excellent Adventure',1989,6.50,4214,149);
insert into movie values (422,'Monty Python''s The Meaning of Life',1983,7.20,4212,59);
insert into movie values (423,'Highlander II: The Quickening',1991,3.20,4211,577);
insert into movie values (424,'Final Destination',2000,6.80,4196,2426);
insert into movie values (425,'Crying Game, The',1992,7.30,4192,153);
insert into movie values (426,'Bad Boys',1995,6.30,4190,678);
insert into movie values (427,'Poltergeist',1982,7.20,4182,1123);
insert into movie values (428,'Cop Land',1997,6.70,4173,1099);
insert into movie values (429,'What Lies Beneath',2000,6.80,4162,67);
insert into movie values (430,'Falling Down',1993,6.90,4161,105);
insert into movie values (431,'Coming to America',1988,6.50,4147,62);
insert into movie values (432,'Stigmata',1999,6.10,4141,2557);
insert into movie values (433,'eXistenZ',1999,6.90,4130,97);
insert into movie values (434,'Evita',1996,6.30,4129,68);
insert into movie values (435,'Trois couleurs: Rouge',1994,8.20,4113,398);
insert into movie values (436,'Six Days Seven Nights',1998,5.70,4107,109);
insert into movie values (437,'Godfather: Part III, The',1990,7.00,4105,28);
insert into movie values (438,'Star Trek III: The Search for Spock',1984,6.10,4094,193);
insert into movie values (439,'13th Warrior, The',1999,6.20,4089,196);
insert into movie values (440,'Sweet Hereafter, The',1997,8.00,4067,665);
insert into movie values (441,'Cliffhanger',1993,6.00,4064,210);
insert into movie values (442,'Sunset Blvd.',1950,8.60,4050,79);
insert into movie values (443,'Smoke',1995,7.50,4049,664);
insert into movie values (444,'Mystery Men',1999,6.10,4043,2187);
insert into movie values (445,'Pink Floyd The Wall',1982,7.20,4043,68);
insert into movie values (446,'Cell, The',2000,6.50,4037,2528);
insert into movie values (447,'Misery',1990,7.40,4026,37);
insert into movie values (448,'Happiness',1998,7.80,4011,1121);
insert into movie values (449,'My Cousin Vinny',1992,7.10,4011,262);
insert into movie values (450,'Born on the Fourth of July',1989,6.90,4002,69);
--- tabmovie, 451, 50
insert into movie values (451,'Office Space',1999,7.10,3997,582);
insert into movie values (452,'Courage Under Fire',1996,6.90,3987,382);
insert into movie values (453,'Mr. Smith Goes to Washington',1939,8.40,3977,392);
insert into movie values (454,'Color Purple, The',1985,7.40,3973,18);
insert into movie values (455,'Arsenic and Old Lace',1944,8.10,3970,392);
insert into movie values (456,'Romancing the Stone',1984,6.80,3967,67);
insert into movie values (457,'Secrets  Lies',1996,7.80,3967,583);
insert into movie values (458,'Craft, The',1996,5.90,3966,657);
insert into movie values (459,'Primal Fear',1996,7.30,3953,630);
insert into movie values (460,'Cité des enfants perdus, La',1995,7.70,3946,995);
insert into movie values (461,'Evil Dead, The',1982,7.10,3941,141);
insert into movie values (462,'General''s Daughter, The',1999,6.20,3939,1114);
insert into movie values (463,'Tarzan',1999,7.60,3937,2334);
insert into movie values (464,'Snow White and the Seven Dwarfs',1937,7.80,3931,1117);
insert into movie values (465,'Frequency',2000,7.60,3928,630);
insert into movie values (466,'Planes, Trains  Automobiles',1987,7.10,3925,144);
insert into movie values (467,'Henry V',1989,8.00,3921,48);
insert into movie values (468,'Trading Places',1983,7.20,3910,62);
insert into movie values (469,'Beach, The',2000,5.80,3908,597);
insert into movie values (470,'Point Break',1991,6.30,3907,641);
insert into movie values (471,'Doctor Zhivago',1965,7.70,3903,1080);
insert into movie values (472,'Star Trek V: The Final Frontier',1989,4.60,3880,128);
insert into movie values (473,'All About Eve',1950,8.60,3876,1111);
insert into movie values (474,'Being There',1979,7.90,3872,971);
insert into movie values (475,'Searching for Bobby Fischer',1993,7.60,3870,1043);
insert into movie values (476,'High Noon',1952,8.20,3864,617);
insert into movie values (477,'Running Man, The',1987,6.20,3864,890);
insert into movie values (478,'Philadelphia Story, The',1940,8.20,3856,628);
insert into movie values (479,'Dr. No',1962,7.10,3850,388);
insert into movie values (480,'Trois couleurs: Bleu',1993,7.90,3848,398);
insert into movie values (481,'Better Off Dead...',1985,7.10,3843,2674);
insert into movie values (482,'Working Girl',1988,6.50,3821,47);
insert into movie values (483,'Wild Bunch, The',1969,8.10,3814,1072);
insert into movie values (484,'Ghost and the Darkness, The',1996,6.40,3812,672);
insert into movie values (485,'Harold and Maude',1971,7.70,3811,971);
insert into movie values (486,'On the Waterfront',1954,8.30,3800,655);
insert into movie values (487,'Clue',1985,6.30,3794,262);
insert into movie values (488,'Beavis and Butt-head Do America',1996,5.90,3770,582);
insert into movie values (489,'Opposite of Sex, The',1998,7.00,3767,2382);
insert into movie values (490,'Bodyguard, The',1992,5.20,3757,1118);
insert into movie values (491,'Runaway Bride',1999,6.00,3753,129);
insert into movie values (492,'Wall Street',1987,7.00,3736,69);
insert into movie values (493,'Witches of Eastwick, The',1987,6.30,3736,979);
insert into movie values (494,'Hackers',1995,5.70,3734,988);
insert into movie values (495,'Midnight Run',1988,7.40,3732,595);
insert into movie values (496,'Fly, The',1986,6.90,3729,97);
insert into movie values (497,'U.S. Marshals',1998,6.20,3716,1064);
insert into movie values (498,'Dog Day Afternoon',1975,7.80,3715,80);
insert into movie values (499,'Bulworth',1998,7.10,3700,60);
insert into movie values (500,'Amistad',1997,7.20,3700,18);
--- tabmovie, 501, 50
insert into movie values (501,'Time Bandits',1981,6.80,3698,59);
insert into movie values (502,'Truth About Cats  Dogs, The',1996,6.60,3690,371);
insert into movie values (503,'Doors, The',1991,6.30,3681,69);
insert into movie values (504,'Day the Earth Stood Still, The',1951,7.80,3676,286);
insert into movie values (505,'Waking Ned Devine',1998,7.50,3671,2166);
insert into movie values (506,'Prince of Egypt, The',1998,7.20,3669,2472);
insert into movie values (507,'Hurricane, The',1999,7.70,3665,81);
insert into movie values (508,'Frighteners, The',1996,6.80,3662,326);
insert into movie values (509,'Very Bad Things',1998,5.80,3657,806);
insert into movie values (510,'Ran',1985,8.50,3654,208);
insert into movie values (511,'City Slickers',1991,6.70,3648,415);
insert into movie values (512,'Empire of the Sun',1987,7.30,3647,18);
insert into movie values (513,'Splash',1984,6.40,3646,21);
insert into movie values (514,'Fast Times at Ridgemont High',1982,6.90,3640,403);
insert into movie values (515,'Almost Famous',2000,8.60,3639,391);
insert into movie values (516,'Spanish Prisoner, The',1997,7.60,3633,606);
insert into movie values (517,'Naked Gun 2 1/2: The Smell of Fear, The',1991,6.10,3626,573);
insert into movie values (518,'Paths of Glory',1957,8.80,3620,82);
insert into movie values (519,'Ten Commandments, The',1956,7.70,3618,1906);
insert into movie values (520,'Dead Again',1991,7.20,3616,48);
insert into movie values (521,'Superman II',1980,6.30,3609,274);
insert into movie values (522,'Touch of Evil',1958,8.50,3607,253);
insert into movie values (523,'Girl, Interrupted',1999,7.10,3605,1099);
insert into movie values (524,'Rounders',1998,7.00,3598,1062);
insert into movie values (525,'Flatliners',1990,6.10,3593,105);
insert into movie values (526,'Bonnie and Clyde',1967,7.90,3589,2059);
insert into movie values (527,'Shaft',2000,6.40,3579,396);
insert into movie values (528,'Species',1995,5.30,3577,146);
insert into movie values (529,'Carrie',1976,7.10,3577,31);
insert into movie values (530,'Beverly Hills Cop II',1987,5.60,3574,107);
insert into movie values (531,'Short Cuts',1993,7.60,3569,155);
insert into movie values (532,'Hot Shots!',1991,6.10,3551,189);
insert into movie values (533,'Hollow Man',2000,5.60,3540,201);
insert into movie values (534,'Sister Act',1992,5.90,3535,662);
insert into movie values (535,'Empire Records',1995,6.00,3520,1025);
insert into movie values (536,'Congo',1995,4.30,3512,614);
insert into movie values (537,'Battlefield Earth',2000,2.30,3507,2806);
insert into movie values (538,'Striptease',1996,3.80,3506,375);
insert into movie values (539,'Braindead',1992,7.20,3505,326);
insert into movie values (540,'Cube',1997,7.30,3504,2585);
insert into movie values (541,'Todo sobre mi madre',1999,8.30,3501,394);
insert into movie values (542,'Cocoon',1985,6.60,3500,21);
insert into movie values (543,'Glengarry Glen Ross',1992,7.60,3498,423);
insert into movie values (544,'Perfect Murder, A',1998,6.40,3495,291);
insert into movie values (545,'48 Hrs.',1982,6.70,3492,143);
insert into movie values (546,'Nightmare on Elm Street, A',1984,6.90,3490,133);
insert into movie values (547,'Carlito''s Way',1993,7.40,3490,31);
insert into movie values (548,'Grand bleu, Le',1988,7.20,3490,389);
insert into movie values (549,'Boyz N the Hood',1991,7.70,3489,396);
insert into movie values (550,'Sixteen Candles',1984,6.80,3484,144);
--- tabmovie, 551, 50
insert into movie values (551,'Rebecca',1940,8.20,3476,11);
insert into movie values (552,'Adventures of Priscilla, Queen of the Desert, The',1994,7.10,3474,1138);
insert into movie values (553,'Sabrina',1995,6.20,3453,92);
insert into movie values (554,'Home Alone 2: Lost in New York',1992,4.60,3447,156);
insert into movie values (555,'Duck Soup',1933,8.40,3447,992);
insert into movie values (556,'Room with a View, A',1986,7.50,3441,576);
insert into movie values (557,'Dante''s Peak',1997,5.70,3439,146);
insert into movie values (558,'Ninth Gate, The',1999,6.50,3435,90);
insert into movie values (559,'Cocktail',1988,5.10,3434,146);
insert into movie values (560,'I Still Know What You Did Last Summer',1998,4.00,3423,1129);
insert into movie values (561,'Easy Rider',1969,7.10,3422,125);
insert into movie values (562,'Death Becomes Her',1992,5.40,3420,67);
insert into movie values (563,'Three Men and a Baby',1987,5.60,3405,193);
insert into movie values (564,'Bean',1997,5.30,3396,1864);
insert into movie values (565,'Treasure of the Sierra Madre, The',1948,8.50,3392,312);
insert into movie values (566,'Big Trouble in Little China',1986,6.40,3390,23);
insert into movie values (567,'Dick Tracy',1990,5.50,3387,60);
insert into movie values (568,'Wild at Heart',1990,6.80,3382,139);
insert into movie values (569,'Barton Fink',1991,7.20,3380,111);
insert into movie values (570,'Straight Story, The',1999,8.40,3353,139);
insert into movie values (571,'Stir of Echoes',1999,7.20,3342,2271);
insert into movie values (572,'Volcano',1997,5.30,3334,1118);
insert into movie values (573,'Dead Man',1995,7.40,3333,175);
insert into movie values (574,'Adventures of Baron Munchausen, The',1988,6.70,3319,59);
insert into movie values (575,'Bull Durham',1988,7.20,3311,642);
insert into movie values (576,'Rainmaker, The',1997,6.90,3309,28);
insert into movie values (577,'Three Amigos!',1986,5.60,3309,62);
insert into movie values (578,'Tron',1982,6.10,3306,2575);
insert into movie values (579,'From Russia with Love',1963,7.20,3302,388);
insert into movie values (580,'C''era una volta il West',1969,8.50,3297,268);
insert into movie values (581,'Driving Miss Daisy',1989,7.30,3288,685);
insert into movie values (582,'Double Indemnity',1944,8.50,3283,79);
insert into movie values (583,'Papillon',1973,7.60,3281,405);
insert into movie values (584,'Big Sleep, The',1946,8.20,3274,197);
insert into movie values (585,'Never Been Kissed',1999,6.10,3271,633);
insert into movie values (586,'Do the Right Thing',1989,7.60,3268,206);
insert into movie values (587,'Tremors',1990,6.80,3258,415);
insert into movie values (588,'Pelican Brief, The',1993,6.20,3251,275);
insert into movie values (589,'Modern Times',1936,8.40,3249,145);
insert into movie values (590,'Under Siege',1992,6.20,3247,291);
insert into movie values (591,'Hudson Hawk',1991,4.90,3244,371);
insert into movie values (592,'Crash',1996,5.50,3241,97);
insert into movie values (593,'Scrooged',1988,6.30,3239,209);
insert into movie values (594,'Escape from New York',1981,6.70,3238,23);
insert into movie values (595,'Four Rooms',1995,5.70,3232,2163);
insert into movie values (596,'Fletch',1985,6.40,3231,418);
insert into movie values (597,'Reality Bites',1994,6.10,3226,242);
insert into movie values (598,'G.I. Jane',1997,5.60,3226,110);
insert into movie values (599,'Midnight in the Garden of Good and Evil',1997,6.30,3226,2);
insert into movie values (600,'Primary Colors',1998,6.90,3225,47);
--- tabmovie, 601, 50
insert into movie values (601,'Blood Simple',1984,7.70,3223,111);
insert into movie values (602,'Dawn of the Dead',1978,7.50,3220,379);
insert into movie values (603,'Edtv',1999,6.60,3215,21);
insert into movie values (604,'Siege, The',1998,5.90,3211,382);
insert into movie values (605,'Shanghai Noon',2000,7.20,3207,2633);
insert into movie values (606,'First Blood',1982,6.50,3207,954);
insert into movie values (607,'Rocky IV',1985,4.80,3200,5);
insert into movie values (608,'Honey, I Shrunk the Kids',1989,5.80,3198,424);
insert into movie values (609,'Father of the Bride',1991,6.30,3178,397);
insert into movie values (610,'Vampires',1998,5.60,3178,23);
insert into movie values (611,'Weird Science',1985,6.00,3175,144);
insert into movie values (612,'Risky Business',1983,6.70,3164,2556);
insert into movie values (613,'Moonraker',1979,5.80,3161,390);
insert into movie values (614,'Anaconda',1997,4.20,3160,1053);
insert into movie values (615,'Billy Madison',1995,6.00,3154,1055);
insert into movie values (616,'Beautiful Girls',1996,7.10,3150,1048);
insert into movie values (617,'Urban Legend',1998,5.10,3150,2430);
insert into movie values (618,'Client, The',1994,6.40,3145,105);
insert into movie values (619,'Copycat',1995,6.50,3142,669);
insert into movie values (620,'U Turn',1997,6.40,3137,69);
insert into movie values (621,'Christmas Vacation',1989,6.60,3137,412);
insert into movie values (622,'Arachnophobia',1990,6.10,3134,614);
insert into movie values (623,'Fatal Attraction',1987,6.60,3132,283);
insert into movie values (624,'Tommy Boy',1995,6.20,3130,384);
insert into movie values (625,'Roxanne',1987,6.90,3128,272);
insert into movie values (626,'Dirty Harry',1971,7.40,3126,346);
insert into movie values (627,'Peacemaker, The',1997,5.80,3120,589);
insert into movie values (628,'Road Trip',2000,6.80,3115,2619);
insert into movie values (629,'Pump Up the Volume',1990,6.60,3114,1025);
insert into movie values (630,'Days of Thunder',1990,5.20,3114,107);
insert into movie values (631,'Robin Hood: Men in Tights',1993,5.30,3093,29);
insert into movie values (632,'Fallen',1998,6.60,3088,630);
insert into movie values (633,'Top Secret!',1984,6.60,3079,189);
insert into movie values (634,'Civil Action, A',1998,6.40,3077,1043);
insert into movie values (635,'Postman, The',1997,5.30,3076,10);
insert into movie values (636,'2010',1984,6.40,3071,103);
insert into movie values (637,'Color of Money, The',1986,6.70,3068,78);
insert into movie values (638,'River Runs Through It, A',1992,7.00,3066,36);
insert into movie values (639,'Can''t Hardly Wait',1998,6.30,3058,2168);
insert into movie values (640,'Dirty Rotten Scoundrels',1988,6.70,3057,123);
insert into movie values (641,'Mighty Aphrodite',1995,7.00,3054,1);
insert into movie values (642,'Deconstructing Harry',1997,7.10,3049,1);
insert into movie values (643,'First Knight',1995,5.60,3045,1116);
insert into movie values (644,'Searchers, The',1956,8.30,3042,287);
insert into movie values (645,'Great Expectations',1998,6.20,3032,2226);
insert into movie values (646,'Notorious',1946,8.20,3030,11);
insert into movie values (647,'Seven Years in Tibet',1997,6.50,3023,1131);
insert into movie values (648,'Mississippi Burning',1988,7.40,3021,68);
insert into movie values (649,'Replacement Killers, The',1998,5.80,3021,2091);
insert into movie values (650,'Naked Gun 33 1/3: The Final Insult',1994,5.70,3021,384);
--- tabmovie, 651, 50
insert into movie values (651,'Bridges of Madison County, The',1995,6.70,3020,2);
insert into movie values (652,'Natural, The',1984,7.20,3016,38);
insert into movie values (653,'Casper',1995,5.70,3011,1139);
insert into movie values (654,'War of the Roses, The',1989,6.30,3011,24);
insert into movie values (655,'Night of the Living Dead',1968,7.50,3010,379);
insert into movie values (656,'Wayne''s World 2',1993,5.40,3006,2842);
insert into movie values (657,'Absolute Power',1997,6.40,3006,2);
insert into movie values (658,'French Kiss',1995,6.30,3005,87);
insert into movie values (659,'Bambi',1942,7.60,3005,1117);
insert into movie values (660,'Rashomon',1950,8.60,3004,208);
insert into movie values (661,'Innerspace',1987,6.30,3002,150);
insert into movie values (662,'Devil''s Own, The',1997,5.80,2999,275);
insert into movie values (663,'Howard the Duck',1986,3.70,2990,2779);
insert into movie values (664,'Mononoke Hime',1997,8.50,2989,1051);
insert into movie values (665,'French Connection, The',1971,7.60,2986,264);
insert into movie values (666,'Far and Away',1992,6.30,2986,21);
insert into movie values (667,'Bringing Up Baby',1938,8.30,2983,197);
insert into movie values (668,'Network',1976,7.90,2982,80);
insert into movie values (669,'Vacation',1983,6.80,2979,108);
insert into movie values (670,'Parenthood',1989,7.00,2979,21);
insert into movie values (671,'Forbidden Planet',1956,7.50,2967,2217);
insert into movie values (672,'Himmel über Berlin, Der',1987,8.00,2966,269);
insert into movie values (673,'Mortal Kombat',1995,5.00,2966,653);
insert into movie values (674,'Executive Decision',1996,6.50,2966,1064);
insert into movie values (675,'Police Academy',1984,5.50,2965,377);
insert into movie values (676,'Commando',1985,5.60,2964,1073);
insert into movie values (677,'Ghost Dog: The Way of the Samurai',1999,7.80,2959,175);
insert into movie values (678,'Romy and Michele''s High School Reunion',1997,6.00,2953,2445);
insert into movie values (679,'What About Bob?',1991,6.40,2951,123);
insert into movie values (680,'Perfect World, A',1993,6.80,2943,2);
insert into movie values (681,'Dial M for Murder',1954,7.60,2942,11);
insert into movie values (682,'''Crocodile'' Dundee II',1988,5.00,2942,2252);
insert into movie values (683,'Strangers on a Train',1951,8.30,2937,11);
insert into movie values (684,'Angel Heart',1987,6.90,2937,68);
insert into movie values (685,'Emma',1996,6.90,2936,2194);
insert into movie values (686,'Die xue shuang xiong',1989,8.20,2935,204);
insert into movie values (687,'Plan 9 from Outer Space',1958,3.30,2931,2038);
insert into movie values (688,'To Die for',1995,6.70,2925,271);
insert into movie values (689,'Fucking Åmål',1998,8.20,2919,2803);
insert into movie values (690,'Roman Holiday',1953,8.00,2918,620);
insert into movie values (691,'Predator 2',1990,5.40,2909,672);
insert into movie values (692,'Bill  Ted''s Bogus Journey',1991,5.40,2908,2793);
insert into movie values (693,'Before Sunrise',1995,7.20,2906,205);
insert into movie values (694,'Streetcar Named Desire, A',1951,8.20,2904,655);
insert into movie values (695,'Real Genius',1985,6.70,2890,1141);
insert into movie values (696,'Halloween H20: 20 Years Later',1998,5.30,2884,365);
insert into movie values (697,'Producers, The',1968,7.70,2884,29);
insert into movie values (698,'Escape from L.A.',1996,4.70,2882,23);
insert into movie values (699,'Tin Cup',1996,6.30,2879,642);
insert into movie values (700,'Conversation, The',1974,8.10,2876,28);
--- tabmovie, 701, 50
insert into movie values (701,'Everyone Says I Love You',1996,6.90,2867,1);
insert into movie values (702,'American Werewolf in London, An',1981,7.10,2865,62);
insert into movie values (703,'Rambo: First Blood Part II',1985,4.80,2863,631);
insert into movie values (704,'Rosemary''s Baby',1968,7.70,2856,90);
insert into movie values (705,'Hannah and Her Sisters',1986,7.70,2851,1);
insert into movie values (706,'O Brother, Where Art Thou?',2000,8.00,2849,111);
insert into movie values (707,'Apartment, The',1960,8.30,2846,79);
insert into movie values (708,'Rosencrantz and Guildenstern Are Dead',1990,7.10,2844,2675);
insert into movie values (709,'Sex, Lies, and Videotape',1989,6.90,2841,689);
insert into movie values (710,'Summer of Sam',1999,6.50,2837,206);
insert into movie values (711,'Spawn',1997,4.60,2836,2614);
insert into movie values (712,'Breakdown',1997,6.70,2828,1120);
insert into movie values (713,'Chariots of Fire',1981,7.20,2826,1063);
insert into movie values (714,'Addams Family Values',1993,6.10,2825,422);
insert into movie values (715,'Great Dictator, The',1940,8.30,2819,145);
insert into movie values (716,'Commitments, The',1991,7.30,2818,68);
insert into movie values (717,'Pee-wee''s Big Adventure',1985,6.50,2803,148);
insert into movie values (718,'Muriel''s Wedding',1994,7.00,2803,1169);
insert into movie values (719,'Muppet Movie, The',1979,7.20,2801,2462);
insert into movie values (720,'Varsity Blues',1999,6.10,2801,2453);
insert into movie values (721,'Once Were Warriors',1994,7.80,2799,624);
insert into movie values (722,'Saturday Night Fever',1977,6.40,2796,66);
insert into movie values (723,'View to a Kill, A',1985,5.80,2790,668);
insert into movie values (724,'Crimes and Misdemeanors',1989,7.90,2781,1);
insert into movie values (725,'Barry Lyndon',1975,7.70,2772,82);
insert into movie values (726,'For Your Eyes Only',1981,6.70,2771,668);
insert into movie values (727,'House on Haunted Hill',1999,5.30,2767,2763);
insert into movie values (728,'UHF',1989,6.50,2755,2267);
insert into movie values (729,'Octopussy',1983,6.20,2755,668);
insert into movie values (730,'Horse Whisperer, The',1998,6.50,2753,36);
insert into movie values (731,'Big Chill, The',1983,7.20,2753,87);
insert into movie values (732,'Transformers: The Movie, The',1986,6.40,2746,2684);
insert into movie values (733,'Bronx Tale, A',1993,7.50,2730,3);
insert into movie values (734,'Quiet Man, The',1952,8.10,2729,287);
insert into movie values (735,'Stripes',1981,6.80,2724,109);
insert into movie values (736,'Rocky III',1982,5.30,2708,5);
insert into movie values (737,'Blast from the Past',1999,6.80,2695,377);
insert into movie values (738,'Spice World',1997,3.00,2694,2461);
insert into movie values (739,'Hot Shots! Part Deux',1993,5.50,2685,189);
insert into movie values (740,'Flintstones, The',1994,4.40,2685,395);
insert into movie values (741,'First Wives Club, The',1996,5.50,2680,377);
insert into movie values (742,'Young Guns',1988,6.30,2673,2305);
insert into movie values (743,'Practical Magic',1998,5.40,2668,332);
insert into movie values (744,'Romeo Must Die',2000,6.00,2667,2023);
insert into movie values (745,'My Own Private Idaho',1991,6.50,2662,271);
insert into movie values (746,'Psycho',1998,5.40,2661,271);
insert into movie values (747,'Diamonds Are Forever',1971,6.60,2659,636);
insert into movie values (748,'One Fine Day',1996,6.20,2659,401);
insert into movie values (749,'Nell',1994,6.30,2649,199);
insert into movie values (750,'Officer and a Gentleman, An',1982,6.70,2634,674);
--- tabmovie, 751, 50
insert into movie values (751,'White Men Can''t Jump',1992,6.20,2634,642);
insert into movie values (752,'Big Hit, The',1998,5.80,2632,2167);
insert into movie values (753,'Big Night',1996,7.40,2629,1260);
insert into movie values (754,'Cyrano de Bergerac',1990,7.60,2629,2233);
insert into movie values (755,'So I Married an Axe Murderer',1993,6.20,2629,2745);
insert into movie values (756,'Stepmom',1998,6.30,2615,156);
insert into movie values (757,'Cook the Thief His Wife  Her Lover, The',1989,6.90,2615,386);
insert into movie values (758,'Dancer in the Dark',2000,8.30,2614,615);
insert into movie values (759,'Space Jam',1996,5.20,2614,2351);
insert into movie values (760,'Out of Africa',1985,6.70,2612,92);
insert into movie values (761,'Rob Roy',1995,6.80,2612,374);
insert into movie values (762,'Rocky II',1979,5.90,2610,5);
insert into movie values (763,'Quick and the Dead, The',1995,5.90,2607,141);
insert into movie values (764,'Regarding Henry',1991,6.50,2603,47);
insert into movie values (765,'Airplane II: The Sequel',1982,5.50,2600,2054);
insert into movie values (766,'Cabaret',1972,7.70,2588,1124);
insert into movie values (767,'Bullets Over Broadway',1994,7.60,2585,1);
insert into movie values (768,'Beautiful Thing',1996,7.20,2585,2084);
insert into movie values (769,'Space Cowboys',2000,7.00,2583,2);
insert into movie values (770,'Moonstruck',1987,7.10,2581,81);
insert into movie values (771,'Never Say Never Again',1983,6.10,2579,651);
insert into movie values (772,'Strange Brew',1983,6.40,2571,147);
insert into movie values (773,'Doc Hollywood',1991,5.80,2564,374);
insert into movie values (774,'Gallipoli',1981,7.70,2563,86);
insert into movie values (775,'Disclosure',1994,6.00,2563,38);
insert into movie values (776,'Spies Like Us',1985,5.60,2562,62);
insert into movie values (777,'Sjunde inseglet, Det',1957,8.40,2559,420);
insert into movie values (778,'Grapes of Wrath, The',1940,8.30,2552,287);
insert into movie values (779,'Indecent Proposal',1993,5.10,2552,283);
insert into movie values (780,'Singles',1992,6.50,2548,391);
insert into movie values (781,'Hoosiers',1986,7.40,2545,1133);
insert into movie values (782,'Adventures of Buckaroo Banzai Across the 8th Dimension, The',1984,6.00,2543,2558);
insert into movie values (783,'Frantic',1988,6.50,2543,90);
insert into movie values (784,'Sliver',1993,4.50,2542,212);
insert into movie values (785,'Hustler, The',1961,8.20,2541,2605);
insert into movie values (786,'Howards End',1992,7.40,2540,576);
insert into movie values (787,'Spy Who Loved Me, The',1977,6.90,2534,390);
insert into movie values (788,'Mimic',1997,5.60,2534,2178);
insert into movie values (789,'Tango  Cash',1989,5.20,2528,1049);
insert into movie values (790,'Night on Earth',1991,7.20,2527,175);
insert into movie values (791,'Enter the Dragon',1973,7.20,2523,2706);
insert into movie values (792,'Short Circuit',1986,5.80,2522,66);
insert into movie values (793,'Gremlins 2: The New Batch',1990,5.60,2520,150);
insert into movie values (794,'Mission, The',1986,7.20,2516,1170);
insert into movie values (795,'Violon rouge, Le',1998,8.00,2516,2184);
insert into movie values (796,'Fiddler on the Roof',1971,7.40,2513,81);
insert into movie values (797,'Nine 1/2 Weeks',1986,5.20,2509,283);
insert into movie values (798,'Strictly Ballroom',1992,7.20,2506,1069);
insert into movie values (799,'Harvey',1950,8.00,2505,2029);
insert into movie values (800,'54',1998,5.30,2504,2592);
--- tabmovie, 801, 50
insert into movie values (801,'You Only Live Twice',1967,6.80,2503,390);
insert into movie values (802,'Wolf',1994,5.80,2485,47);
insert into movie values (803,'Unbearable Lightness of Being, The',1988,7.20,2485,288);
insert into movie values (804,'Dark Crystal, The',1982,6.80,2478,952);
insert into movie values (805,'Mystery Science Theater 3000: The Movie',1996,7.00,2473,1469);
insert into movie values (806,'Rambo III',1988,3.70,2468,2804);
insert into movie values (807,'Twin Peaks: Fire Walk with Me',1992,6.10,2466,139);
insert into movie values (808,'Small Soldiers',1998,6.00,2463,150);
insert into movie values (809,'Titan A.E.',2000,6.80,2455,409);
insert into movie values (810,'Thunderball',1965,6.80,2454,388);
insert into movie values (811,'World According to Garp, The',1982,7.00,2454,276);
insert into movie values (812,'Outlaw Josey Wales, The',1976,7.60,2447,2);
insert into movie values (813,'Dragnet',1987,5.50,2441,2670);
insert into movie values (814,'Superman III',1983,4.30,2439,274);
insert into movie values (815,'Friday',1995,6.70,2435,1035);
insert into movie values (816,'Forces of Nature',1999,5.70,2427,2262);
insert into movie values (817,'One Hundred and One Dalmatians',1961,7.20,2423,266);
insert into movie values (818,'Silverado',1985,7.00,2422,87);
insert into movie values (819,'Thirteenth Floor, The',1999,6.50,2422,2388);
insert into movie values (820,'Paris, Texas',1984,7.40,2415,269);
insert into movie values (821,'Rocketeer, The',1991,5.80,2415,424);
insert into movie values (822,'Buffy the Vampire Slayer',1992,5.40,2414,2181);
insert into movie values (823,'On Her Majesty''s Secret Service',1969,6.60,2413,2809);
insert into movie values (824,'Repo Man',1984,6.70,2401,1041);
insert into movie values (825,'Addicted to Love',1997,6.20,2399,332);
insert into movie values (826,'8 1/2',1963,8.00,2397,399);
insert into movie values (827,'Who''s Afraid of Virginia Woolf?',1966,8.20,2395,47);
insert into movie values (828,'Daylight',1996,5.40,2393,376);
insert into movie values (829,'Rope',1948,7.70,2389,11);
insert into movie values (830,'Zero Effect',1998,7.30,2387,1927);
insert into movie values (831,'Wonder Boys',2000,7.70,2386,607);
insert into movie values (832,'Buffalo ''66',1998,7.20,2385,819);
insert into movie values (833,'Gods Must Be Crazy, The',1980,6.90,2385,1955);
insert into movie values (834,'Midnight Express',1978,7.40,2384,68);
insert into movie values (835,'Throw Momma from the Train',1987,5.80,2381,24);
insert into movie values (836,'Welcome to the Dollhouse',1995,7.50,2376,1121);
insert into movie values (837,'Ordinary People',1980,7.70,2372,36);
insert into movie values (838,'Doctor Dolittle',1998,5.40,2365,425);
insert into movie values (839,'Apt Pupil',1998,6.50,2363,639);
insert into movie values (840,'Outsiders, The',1983,6.80,2363,28);
insert into movie values (841,'Deuce Bigalow: Male Gigolo',1999,5.50,2359,2620);
insert into movie values (842,'''burbs, The',1989,5.50,2354,150);
insert into movie values (843,'Pretty in Pink',1986,6.20,2349,285);
insert into movie values (844,'Peggy Sue Got Married',1986,6.30,2336,28);
insert into movie values (845,'Revenge of the Nerds',1984,5.90,2335,2257);
insert into movie values (846,'How the Grinch Stole Christmas',2000,6.60,2333,21);
insert into movie values (847,'Texas Chain Saw Massacre, The',1974,6.70,2333,1123);
insert into movie values (848,'City Lights',1931,8.60,2325,145);
insert into movie values (849,'Money Pit, The',1986,5.30,2319,320);
insert into movie values (850,'Relic, The',1997,5.20,2318,103);
--- tabmovie, 851, 50
insert into movie values (851,'No Way Out',1987,7.00,2314,146);
insert into movie values (852,'Golden Child, The',1986,5.20,2313,418);
insert into movie values (853,'Exotica',1994,7.10,2311,665);
insert into movie values (854,'Heavy Metal',1981,6.20,2311,2156);
insert into movie values (855,'Darkman',1990,5.90,2310,141);
insert into movie values (856,'Age of Innocence, The',1993,7.00,2299,78);
insert into movie values (857,'Charade',1963,8.00,2298,428);
insert into movie values (858,'Desperately Seeking Susan',1985,5.60,2297,2615);
insert into movie values (859,'Brassed Off',1996,7.10,2297,2596);
insert into movie values (860,'Adventures in Babysitting',1987,6.30,2293,156);
insert into movie values (861,'Benny  Joon',1993,6.60,2292,412);
insert into movie values (862,'Cool Runnings',1993,6.20,2291,411);
insert into movie values (863,'Superman IV: The Quest for Peace',1987,3.10,2289,2838);
insert into movie values (864,'Starman',1984,6.70,2288,23);
insert into movie values (865,'Presumed Innocent',1990,6.90,2279,275);
insert into movie values (866,'Pushing Tin',1999,6.00,2278,585);
insert into movie values (867,'Robocop 2',1990,4.30,2277,651);
insert into movie values (868,'European Vacation',1985,5.00,2272,403);
insert into movie values (869,'Don Juan DeMarco',1995,6.50,2267,2356);
insert into movie values (870,'Green Card',1990,5.90,2263,86);
insert into movie values (871,'Hard Rain',1998,5.50,2260,2631);
insert into movie values (872,'Roger  Me',1989,7.70,2259,955);
insert into movie values (873,'Eraserhead',1977,6.60,2258,139);
insert into movie values (874,'Terms of Endearment',1983,7.20,2256,574);
insert into movie values (875,'George of the Jungle',1997,5.70,2253,1075);
insert into movie values (876,'39 Steps, The',1935,8.00,2250,11);
insert into movie values (877,'Broadcast News',1987,7.00,2243,574);
insert into movie values (878,'Underground',1995,7.80,2242,663);
insert into movie values (879,'Miracle on 34th Street',1947,7.90,2237,1061);
insert into movie values (880,'Rising Sun',1993,6.00,2237,288);
insert into movie values (881,'Frankenstein',1994,5.90,2233,48);
insert into movie values (882,'Steel Magnolias',1989,6.70,2231,200);
insert into movie values (883,'Hard Day''s Night, A',1964,7.60,2228,274);
insert into movie values (884,'St. Elmo''s Fire',1985,5.80,2222,105);
insert into movie values (885,'1941',1979,5.50,2222,18);
insert into movie values (886,'Grumpy Old Men',1993,6.50,2222,599);
insert into movie values (887,'Flash Gordon',1980,5.60,2222,2628);
insert into movie values (888,'Hoop Dreams',1994,7.80,2220,2571);
insert into movie values (889,'Trzy kolory: Bialy',1994,7.70,2213,398);
insert into movie values (890,'Red Dawn',1984,5.60,2213,693);
insert into movie values (891,'Random Hearts',1999,4.80,2212,92);
insert into movie values (892,'Shadowlands',1993,7.20,2204,235);
insert into movie values (893,'After Hours',1985,7.30,2199,78);
insert into movie values (894,'Dangerous Minds',1995,5.70,2198,2448);
insert into movie values (895,'Up in Smoke',1978,6.20,2198,2819);
insert into movie values (896,'Dirty Dozen, The',1967,7.50,2191,1060);
insert into movie values (897,'Specialist, The',1994,4.60,2191,1053);
insert into movie values (898,'2 Days in the Valley',1996,6.40,2189,1700);
insert into movie values (899,'Three Musketeers, The',1993,5.90,2188,149);
insert into movie values (900,'Slap Shot',1977,7.00,2184,276);
--- tabmovie, 901, 50
insert into movie values (901,'Fierce Creatures',1997,6.10,2182,272);
insert into movie values (902,'Toys',1992,4.50,2179,38);
insert into movie values (903,'Assassins',1995,5.70,2173,209);
insert into movie values (904,'Footloose',1984,5.80,2167,200);
insert into movie values (905,'Wallace  Gromit: A Grand Day Out',1992,7.70,2167,572);
insert into movie values (906,'Uncle Buck',1989,6.10,2163,144);
insert into movie values (907,'Shane',1953,7.80,2161,1022);
insert into movie values (908,'Nine Months',1995,5.20,2153,156);
insert into movie values (909,'Blue Streak',1999,6.10,2153,632);
insert into movie values (910,'My Left Foot',1989,7.40,2152,581);
insert into movie values (911,'Omen, The',1976,7.10,2151,209);
insert into movie values (912,'Anna and the King',1999,7.00,2150,654);
insert into movie values (913,'Nine to Five',1980,6.20,2148,1110);
insert into movie values (914,'Hellraiser',1987,6.30,2144,2327);
insert into movie values (915,'Gettysburg',1993,7.40,2144,2761);
insert into movie values (916,'Hand That Rocks the Cradle, The',1992,6.20,2138,607);
insert into movie values (917,'Three Days of the Condor',1975,7.30,2137,92);
insert into movie values (918,'Pocahontas',1995,5.60,2130,2630);
insert into movie values (919,'Timecop',1994,5.60,2121,103);
insert into movie values (920,'Rio Bravo',1959,8.00,2119,197);
insert into movie values (921,'Sleeper',1973,7.30,2113,1);
insert into movie values (922,'Gold Rush, The',1925,8.30,2113,145);
insert into movie values (923,'Body Heat',1981,7.30,2112,87);
insert into movie values (924,'Adventures of Robin Hood, The',1938,8.10,2111,675);
insert into movie values (925,'Conan the Destroyer',1984,5.20,2104,402);
insert into movie values (926,'Bicentennial Man',1999,6.50,2103,156);
insert into movie values (927,'Waiting for Guffman',1996,7.60,2097,352);
insert into movie values (928,'Basketball Diaries, The',1995,6.60,2092,2634);
insert into movie values (929,'Michael Collins',1996,6.90,2092,153);
insert into movie values (930,'Bob Roberts',1992,7.10,2084,25);
insert into movie values (931,'Swimming with Sharks',1994,7.20,2072,2127);
insert into movie values (932,'Yellow Submarine',1968,6.90,2069,2109);
insert into movie values (933,'Turner  Hooch',1989,5.30,2057,407);
insert into movie values (934,'Nixon',1995,7.00,2055,69);
insert into movie values (935,'Porky''s',1981,5.10,2051,579);
insert into movie values (936,'Coyote Ugly',2000,5.90,2051,2478);
insert into movie values (937,'Edge, The',1997,6.90,2050,624);
insert into movie values (938,'Double vie de Véronique, La',1991,7.30,2050,398);
insert into movie values (939,'Always',1989,6.20,2050,18);
insert into movie values (940,'Boiler Room',2000,7.00,2049,2419);
insert into movie values (941,'Stuart Little',1999,6.30,2045,2623);
insert into movie values (942,'Things to Do in Denver When You''re Dead',1995,6.60,2045,2114);
insert into movie values (943,'Rudy',1993,6.90,2037,1133);
insert into movie values (944,'Some Kind of Wonderful',1987,6.50,2036,285);
insert into movie values (945,'Poseidon Adventure, The',1972,6.60,2035,2759);
insert into movie values (946,'History of the World: Part I',1981,6.20,2034,29);
insert into movie values (947,'Forever Young',1992,6.10,2034,365);
insert into movie values (948,'To Catch a Thief',1955,7.50,2032,11);
insert into movie values (949,'Police Academy 4: Citizens on Patrol',1987,3.10,2028,2317);
insert into movie values (950,'Night of the Hunter, The',1955,8.40,2027,1183);
--- tabmovie, 951, 50
insert into movie values (951,'Bad Taste',1987,6.70,2026,326);
insert into movie values (952,'His Girl Friday',1940,8.30,2023,197);
insert into movie values (953,'Rules of Engagement',2000,6.50,2020,264);
insert into movie values (954,'I.Q.',1994,6.10,2019,272);
insert into movie values (955,'Police Academy 5: Assignment: Miami Beach',1988,2.50,2014,2122);
insert into movie values (956,'Alive',1993,6.50,2011,614);
insert into movie values (957,'Sabrina',1954,7.60,2011,79);
insert into movie values (958,'Best Years of Our Lives, The',1946,8.50,2010,620);
insert into movie values (959,'Mickey Blue Eyes',1999,5.90,2003,2080);
insert into movie values (960,'All Quiet on the Western Front',1930,8.40,2002,2138);
insert into movie values (961,'Now and Then',1995,6.00,1999,2151);
insert into movie values (962,'Snatch',2000,8.10,1996,2205);
insert into movie values (963,'Accidental Tourist, The',1988,6.70,1995,87);
insert into movie values (964,'For Love of the Game',1999,6.60,1990,141);
insert into movie values (965,'Drugstore Cowboy',1989,7.50,1988,271);
insert into movie values (966,'Night at the Opera, A',1935,8.20,1983,2532);
insert into movie values (967,'Ruthless People',1986,6.80,1981,189);
insert into movie values (968,'Barbarella',1968,5.40,1980,2752);
insert into movie values (969,'Grifters, The',1990,7.20,1978,292);
insert into movie values (970,'Tequila Sunrise',1988,5.80,1976,2582);
insert into movie values (971,'Pink Panther, The',1963,7.20,1973,65);
insert into movie values (972,'Brady Bunch Movie, The',1995,5.60,1972,425);
insert into movie values (973,'Chain Reaction',1996,5.10,1971,291);
insert into movie values (974,'Yojimbo',1961,8.60,1961,208);
insert into movie values (975,'In the Heat of the Night',1967,7.90,1961,81);
insert into movie values (976,'Billy Elliot',2000,8.30,1960,2784);
insert into movie values (977,'Powder',1995,5.90,1958,2540);
insert into movie values (978,'Virgin Suicides, The',1999,7.40,1957,1471);
insert into movie values (979,'F/X',1986,6.60,1952,1007);
insert into movie values (980,'Mosquito Coast, The',1986,6.40,1949,86);
insert into movie values (981,'Hong faan kui',1995,6.60,1949,667);
insert into movie values (982,'Stalag 17',1953,8.30,1941,79);
insert into movie values (983,'Nosferatu, eine Symphonie des Grauens',1922,8.20,1941,2035);
insert into movie values (984,'Drop Dead Gorgeous',1999,6.40,1941,2676);
insert into movie values (985,'Of Mice and Men',1992,7.60,1940,255);
insert into movie values (986,'Multiplicity',1996,5.70,1939,108);
insert into movie values (987,'Object of My Affection, The',1998,6.10,1939,1149);
insert into movie values (988,'Suicide Kings',1997,6.90,1937,2810);
insert into movie values (989,'Towering Inferno, The',1974,6.20,1937,2018);
insert into movie values (990,'Purple Rose of Cairo, The',1985,7.50,1937,1);
insert into movie values (991,'Arthur',1981,6.50,1932,2847);
insert into movie values (992,'Hope Floats',1998,5.40,1927,157);
insert into movie values (993,'General, The',1927,8.70,1926,2343);
insert into movie values (994,'Somewhere in Time',1980,6.70,1923,600);
insert into movie values (995,'Rocky V',1990,3.70,1923,683);
insert into movie values (996,'Eye of the Beholder',1999,4.20,1921,1138);
insert into movie values (997,'Cinderella',1950,7.50,1911,266);
insert into movie values (998,'Under Siege 2: Dark Territory',1995,4.90,1909,627);
insert into movie values (999,'Point of No Return',1993,5.70,1908,66);
insert into movie values (1000,'Haunting, The',1963,7.70,1907,286);
--- tabmovie, 1001, 50
insert into movie values (1001,'Ideal Husband, An',1999,7.30,1904,1930);
insert into movie values (1002,'Grand Canyon',1991,6.80,1903,87);
insert into movie values (1003,'Barb Wire',1996,3.30,1900,2264);
insert into movie values (1004,'Dead Zone, The',1983,7.10,1898,97);
insert into movie values (1005,'Accused, The',1988,7.10,1886,580);
insert into movie values (1006,'Cookie''s Fortune',1999,7.30,1885,155);
insert into movie values (1007,'Ref, The',1994,6.80,1883,1048);
insert into movie values (1008,'Blues Brothers 2000',1998,4.20,1880,62);
insert into movie values (1009,'Red Heat',1988,5.30,1878,143);
insert into movie values (1010,'Pet Sematary',1989,5.40,1876,2701);
insert into movie values (1011,'Fearless',1993,7.10,1872,86);
insert into movie values (1012,'Fabulous Baker Boys, The',1989,6.60,1872,2577);
insert into movie values (1013,'Apostle, The',1997,7.20,1870,44);
insert into movie values (1014,'Dead Calm',1989,6.90,1864,212);
insert into movie values (1015,'Naked Lunch',1991,6.30,1863,97);
insert into movie values (1016,'Anastasia',1997,6.60,1860,409);
insert into movie values (1017,'Soldier',1998,5.30,1858,653);
insert into movie values (1018,'Popeye',1980,4.70,1857,155);
insert into movie values (1019,'Arrival, The',1996,6.00,1855,1071);
insert into movie values (1020,'Withnail and I',1987,6.90,1852,1028);
insert into movie values (1021,'Twilight Zone: The Movie',1983,6.00,1848,150);
insert into movie values (1022,'Police Academy 2: Their First Assignment',1985,4.00,1848,967);
insert into movie values (1023,'Breaking Away',1979,7.70,1846,994);
insert into movie values (1024,'Grease 2',1982,3.30,1846,2601);
insert into movie values (1025,'Fools Rush In',1997,5.90,1840,654);
insert into movie values (1026,'Nothing to Lose',1997,6.70,1836,948);
insert into movie values (1027,'True Crime',1999,6.30,1833,2);
insert into movie values (1028,'Flashdance',1983,5.40,1830,283);
insert into movie values (1029,'Smokey and the Bandit',1977,6.00,1822,618);
insert into movie values (1030,'Celebrity',1998,6.20,1820,1);
insert into movie values (1031,'Stop! Or My Mom Will Shoot',1992,3.00,1817,407);
insert into movie values (1032,'Wing Commander',1999,3.70,1811,2352);
insert into movie values (1033,'Street Fighter',1994,3.10,1809,2581);
insert into movie values (1034,'Black Rain',1989,6.20,1809,110);
insert into movie values (1035,'Midsummer Night''s Dream, A',1999,6.50,1809,401);
insert into movie values (1036,'Christine',1983,5.90,1806,23);
insert into movie values (1037,'Sea of Love',1989,6.60,1806,616);
insert into movie values (1038,'C''est arrivé près de chez vous',1992,7.40,1806,2783);
insert into movie values (1039,'Prizzi''s Honor',1985,7.00,1803,312);
insert into movie values (1040,'Mortal Kombat: Annihilation',1997,3.00,1802,2424);
insert into movie values (1041,'Serial Mom',1994,6.20,1801,364);
insert into movie values (1042,'Zulu',1964,7.60,1797,2341);
insert into movie values (1043,'Bachelor Party',1984,5.50,1796,2715);
insert into movie values (1044,'From Here to Eternity',1953,8.00,1794,617);
insert into movie values (1045,'Playing by Heart',1998,7.40,1793,2777);
insert into movie values (1046,'Freeway',1996,6.70,1787,2699);
insert into movie values (1047,'Hamlet',1990,6.90,1784,1058);
insert into movie values (1048,'Murder in the First',1995,6.90,1782,2570);
insert into movie values (1049,'Dead Men Don''t Wear Plaid',1982,6.40,1781,221);
insert into movie values (1050,'Bird on a Wire',1990,5.10,1781,66);
--- tabmovie, 1051, 50
insert into movie values (1051,'Deep Rising',1998,5.30,1780,1103);
insert into movie values (1052,'Disturbing Behavior',1998,5.10,1779,2447);
insert into movie values (1053,'Dolores Claiborne',1995,7.20,1779,674);
insert into movie values (1054,'Fan, The',1996,5.40,1779,107);
insert into movie values (1055,'Simon Birch',1998,7.10,1775,2512);
insert into movie values (1056,'Adventures of Ford Fairlane, The',1990,4.70,1774,210);
insert into movie values (1057,'Reindeer Games',2000,5.60,1772,676);
insert into movie values (1058,'Misérables, Les',1998,7.10,1768,584);
insert into movie values (1059,'Haine, La',1995,7.60,1766,1923);
insert into movie values (1060,'Unendliche Geschichte, Die',1984,6.90,1764,140);
insert into movie values (1061,'Where Eagles Dare',1969,7.30,1763,2432);
insert into movie values (1062,'On Golden Pond',1981,7.20,1759,2518);
insert into movie values (1063,'Down by Law',1986,7.40,1758,175);
insert into movie values (1064,'Frankenstein',1931,7.90,1755,1097);
insert into movie values (1065,'Red Rock West',1992,7.00,1752,1062);
insert into movie values (1066,'Naked',1993,7.40,1752,583);
insert into movie values (1067,'Friday the 13th',1980,5.50,1749,2509);
insert into movie values (1068,'BASEketball',1998,6.00,1747,573);
insert into movie values (1069,'Cannonball Run, The',1981,5.10,1747,618);
insert into movie values (1070,'Police Academy 6: City Under Siege',1989,2.50,1739,2754);
insert into movie values (1071,'Astronaut''s Wife, The',1999,4.60,1736,2868);
insert into movie values (1072,'Sleeping Beauty',1959,7.40,1735,266);
insert into movie values (1073,'Zelig',1983,7.40,1732,1);
insert into movie values (1074,'Andromeda Strain, The',1971,6.90,1731,286);
insert into movie values (1075,'Overboard',1987,6.00,1726,129);
insert into movie values (1076,'Caine Mutiny, The',1954,8.00,1722,2027);
insert into movie values (1077,'Hero',1992,6.10,1719,292);
insert into movie values (1078,'Bottle Rocket',1996,7.30,1717,1034);
insert into movie values (1079,'Spy Hard',1996,4.50,1716,2729);
insert into movie values (1080,'Dark Star',1973,6.60,1716,23);
insert into movie values (1081,'Odd Couple, The',1968,7.50,1714,1267);
insert into movie values (1082,'Music Man, The',1962,7.50,1714,1137);
insert into movie values (1083,'Cobra',1986,4.00,1712,631);
insert into movie values (1084,'Dinosaur',2000,6.50,1710,2090);
insert into movie values (1085,'Virus',1999,3.90,1709,1174);
insert into movie values (1086,'My Stepmother Is an Alien',1988,4.70,1708,320);
insert into movie values (1087,'Hair',1979,6.60,1708,408);
insert into movie values (1088,'Secret of My Succe$s, The',1987,6.00,1705,200);
insert into movie values (1089,'Return to Me',2000,7.30,1705,307);
insert into movie values (1090,'Crow: City of Angels, The',1996,3.70,1704,2727);
insert into movie values (1091,'Threesome',1994,6.00,1704,657);
insert into movie values (1092,'End of the Affair, The',1999,7.40,1703,153);
insert into movie values (1093,'Willow',1988,6.60,1703,21);
insert into movie values (1094,'Shall We Dansu?',1996,7.90,1701,2712);
insert into movie values (1095,'Nurse Betty',2000,7.30,1700,593);
insert into movie values (1096,'*batteries not included',1987,5.50,1696,2693);
insert into movie values (1097,'Enemy Mine',1985,6.20,1695,140);
insert into movie values (1098,'Per un pugno di dollari',1964,7.50,1694,268);
insert into movie values (1099,'Bullitt',1968,7.40,1693,994);
insert into movie values (1100,'Sleeping with the Enemy',1991,5.70,1692,410);
--- tabmovie, 1101, 50
insert into movie values (1101,'Beaches',1988,5.90,1691,129);
insert into movie values (1102,'Earth Girls Are Easy',1989,5.00,1689,2028);
insert into movie values (1103,'Stagecoach',1939,8.10,1689,287);
insert into movie values (1104,'Cutting Edge, The',1992,6.40,1688,890);
insert into movie values (1105,'Como agua para chocolate',1992,7.20,1686,756);
insert into movie values (1106,'Back to School',1986,5.80,1684,1010);
insert into movie values (1107,'Blue Lagoon, The',1980,4.30,1681,383);
insert into movie values (1108,'In the Mouth of Madness',1995,6.30,1681,23);
insert into movie values (1109,'Hercules',1997,6.80,1681,1152);
insert into movie values (1110,'Stakeout',1987,6.50,1680,66);
insert into movie values (1111,'Per qualche dollaro in più',1965,7.70,1680,268);
insert into movie values (1112,'Flirting with Disaster',1996,7.20,1674,1070);
insert into movie values (1113,'Fear',1996,5.80,1669,423);
insert into movie values (1114,'Nobody''s Fool',1994,7.30,1664,660);
insert into movie values (1115,'Story of Us, The',1999,5.60,1659,37);
insert into movie values (1116,'Prêt-à-Porter',1994,4.70,1652,155);
insert into movie values (1117,'Bugsy',1991,6.60,1648,38);
insert into movie values (1118,'Secret of NIMH, The',1982,7.20,1646,409);
insert into movie values (1119,'Big Momma''s House',2000,4.80,1645,633);
insert into movie values (1120,'Sleuth',1972,7.80,1645,1111);
insert into movie values (1121,'Everything You Always Wanted to Know About Sex',1972,6.60,1643,1);
insert into movie values (1122,'Heaven Can Wait',1978,6.70,1641,60);
insert into movie values (1123,'Another 48 Hrs.',1990,4.90,1639,143);
insert into movie values (1124,'In the Company of Men',1997,7.30,1635,593);
insert into movie values (1125,'Bronenosets Potyomkin',1925,8.40,1634,2128);
insert into movie values (1126,'Priest',1994,7.00,1632,1159);
insert into movie values (1127,'Tank Girl',1995,4.70,1632,1032);
insert into movie values (1128,'Six Degrees of Separation',1993,7.00,1628,272);
insert into movie values (1129,'Walk in the Clouds, A',1995,6.30,1625,756);
insert into movie values (1130,'Amarcord',1974,8.20,1624,399);
insert into movie values (1131,'Sure Thing, The',1985,6.80,1622,37);
insert into movie values (1132,'City Hall',1996,6.10,1622,616);
insert into movie values (1133,'Mr. Mom',1983,6.10,1620,2829);
insert into movie values (1134,'Quatre cents coups, Les',1959,8.60,1619,505);
insert into movie values (1135,'Halloween II',1981,5.30,1612,2618);
insert into movie values (1136,'Mouse Hunt',1997,5.80,1612,2132);
insert into movie values (1137,'Bad Lieutenant',1992,6.50,1612,2133);
insert into movie values (1138,'Down and Out in Beverly Hills',1986,6.00,1611,720);
insert into movie values (1139,'American Werewolf in Paris, An',1997,5.10,1611,2086);
insert into movie values (1140,'Pillow Book, The',1996,6.60,1606,386);
insert into movie values (1141,'Immortal Beloved',1994,7.00,1599,1150);
insert into movie values (1142,'Velvet Goldmine',1998,6.20,1598,2647);
insert into movie values (1143,'Day of the Jackal, The',1973,7.50,1595,617);
insert into movie values (1144,'Dead Ringers',1988,6.80,1595,97);
insert into movie values (1145,'Scrooge',1951,8.20,1591,2434);
insert into movie values (1146,'Birdy',1984,7.20,1587,68);
insert into movie values (1147,'House of Games',1987,7.50,1581,606);
insert into movie values (1148,'Police Academy 3: Back in Training',1986,3.40,1579,967);
insert into movie values (1149,'Crucible, The',1996,6.90,1579,1149);
insert into movie values (1150,'Smilla''s Sense of Snow',1997,6.20,1575,584);
--- tabmovie, 1151, 50
insert into movie values (1151,'Ravenous',1999,6.50,1575,1159);
insert into movie values (1152,'Sommersby',1993,5.90,1575,669);
insert into movie values (1153,'200 Cigarettes',1999,5.30,1573,2664);
insert into movie values (1154,'Diva',1981,7.30,1569,1132);
insert into movie values (1155,'Snow Falling on Cedars',1999,7.10,1566,1135);
insert into movie values (1156,'Soapdish',1991,6.10,1566,401);
insert into movie values (1157,'Skulls, The',2000,5.30,1563,376);
insert into movie values (1158,'Police Academy: Mission to Moscow',1994,1.90,1563,1010);
insert into movie values (1159,'Cat on a Hot Tin Roof',1958,7.70,1561,2606);
insert into movie values (1160,'China Syndrome, The',1979,7.20,1560,2389);
insert into movie values (1161,'Biloxi Blues',1988,6.40,1558,47);
insert into movie values (1162,'28 Days',2000,6.30,1556,425);
insert into movie values (1163,'Beverly Hills Cop III',1994,4.50,1555,62);
insert into movie values (1164,'Dolce vita, La',1960,8.00,1555,399);
insert into movie values (1165,'Private Benjamin',1980,6.00,1553,661);
insert into movie values (1166,'Stalker',1979,7.20,1551,658);
insert into movie values (1167,'My Girl',1991,6.20,1551,661);
insert into movie values (1168,'Mitt liv som hund',1985,7.60,1548,387);
insert into movie values (1169,'Sweet and Lowdown',1999,7.30,1548,1);
insert into movie values (1170,'Dick',1999,6.60,1543,657);
insert into movie values (1171,'Caddyshack II',1988,3.50,1541,2215);
insert into movie values (1172,'Corruptor, The',1999,6.00,1540,423);
insert into movie values (1173,'Casino Royale',1967,5.20,1529,2690);
insert into movie values (1174,'Night at the Roxbury, A',1998,4.80,1526,2236);
insert into movie values (1175,'Pay It Forward',2000,7.30,1512,589);
insert into movie values (1176,'River Wild, The',1994,6.20,1507,607);
insert into movie values (1177,'Greystoke: The Legend of Tarzan, Lord of the Apes',1984,5.90,1505,1063);
insert into movie values (1178,'Videodrome',1983,6.60,1504,97);
insert into movie values (1179,'Peter Pan',1953,7.30,1504,266);
insert into movie values (1180,'Freshman, The',1990,6.60,1503,375);
insert into movie values (1181,'Au revoir les enfants',1987,8.10,1503,619);
insert into movie values (1182,'Black Hole, The',1979,5.20,1499,2117);
insert into movie values (1183,'Pecker',1998,6.70,1494,364);
insert into movie values (1184,'Replacements, The',2000,6.60,1493,285);
insert into movie values (1185,'Bridge Too Far, A',1977,6.80,1487,235);
insert into movie values (1186,'Mujeres al borde de un ataque de nervios',1988,7.70,1486,394);
insert into movie values (1187,'Airheads',1994,5.30,1484,371);
insert into movie values (1188,'Color of Night',1994,4.80,1481,1039);
insert into movie values (1189,'Soylent Green',1973,6.50,1481,402);
insert into movie values (1190,'All of Me',1984,6.80,1479,221);
insert into movie values (1191,'Passenger 57',1992,5.40,1479,1885);
insert into movie values (1192,'Mystery, Alaska',1999,6.80,1477,604);
insert into movie values (1193,'Strada, La',1954,8.30,1475,399);
insert into movie values (1194,'Picnic at Hanging Rock',1975,7.60,1475,86);
insert into movie values (1195,'Radio Days',1987,7.30,1473,1);
insert into movie values (1196,'Year of Living Dangerously, The',1982,7.20,1471,86);
insert into movie values (1197,'Species II',1998,3.50,1470,1001);
insert into movie values (1198,'Teaching Mrs. Tingle',1999,5.00,1469,2212);
insert into movie values (1199,'Universal Soldier',1992,5.00,1467,290);
insert into movie values (1200,'Fanny och Alexander',1982,8.20,1467,420);
--- tabmovie, 1201, 50
insert into movie values (1201,'Richard III',1995,7.70,1467,2526);
insert into movie values (1202,'Requiem for a Dream',2000,8.70,1466,1136);
insert into movie values (1203,'Babe: Pig in the City',1998,6.90,1465,979);
insert into movie values (1204,'Wyatt Earp',1994,6.00,1460,87);
insert into movie values (1205,'Return to Paradise',1998,6.80,1458,410);
insert into movie values (1206,'Affliction',1997,7.00,1456,652);
insert into movie values (1207,'Smoke Signals',1998,7.30,1454,2355);
insert into movie values (1208,'Mister Roberts',1955,7.90,1452,287);
insert into movie values (1209,'In Dreams',1998,5.20,1451,153);
insert into movie values (1210,'Husbands and Wives',1992,7.50,1449,1);
insert into movie values (1211,'Westworld',1973,6.80,1447,1017);
insert into movie values (1212,'Fantasia/2000',1999,7.90,1445,1167);
insert into movie values (1213,'Chongqing senlin',1994,7.70,1445,1095);
insert into movie values (1214,'Warriors, The',1979,6.90,1444,143);
insert into movie values (1215,'Thin Man, The',1934,8.10,1444,2564);
insert into movie values (1216,'Remember the Titans',2000,8.00,1438,2376);
insert into movie values (1217,'Mrs. Brown',1997,7.50,1434,1011);
insert into movie values (1218,'Pinocchio',1940,7.80,1429,2224);
insert into movie values (1219,'Coneheads',1993,5.00,1427,1096);
insert into movie values (1220,'Stealing Beauty',1996,6.30,1423,598);
insert into movie values (1221,'Prophecy, The',1995,6.60,1420,2105);
insert into movie values (1222,'Inherit the Wind',1960,8.00,1420,673);
insert into movie values (1223,'Single White Female',1992,6.20,1419,1104);
insert into movie values (1224,'Death and the Maiden',1994,7.00,1414,90);
insert into movie values (1225,'Three to Tango',1999,6.40,1412,2279);
insert into movie values (1226,'Badlands',1973,7.80,1410,686);
insert into movie values (1227,'Half Baked',1998,5.80,1409,1055);
insert into movie values (1228,'Idle Hands',1999,5.50,1407,2797);
insert into movie values (1229,'Candyman',1992,6.10,1403,1150);
insert into movie values (1230,'Da hong deng long gao gao gua',1991,8.30,1403,2830);
insert into movie values (1231,'Hana-bi',1997,7.90,1402,1484);
insert into movie values (1232,'Outland',1981,6.40,1402,103);
insert into movie values (1233,'10',1979,5.50,1395,65);
insert into movie values (1234,'Grande illusion, La',1937,8.60,1393,2292);
insert into movie values (1235,'Flubber',1997,4.70,1393,632);
insert into movie values (1236,'Nineteen Eighty-Four',1984,6.70,1390,1154);
insert into movie values (1237,'And Now for Something Completely Different',1971,7.20,1388,59);
insert into movie values (1238,'THX 1138',1970,6.40,1388,360);
insert into movie values (1239,'Up Close  Personal',1996,5.80,1386,691);
insert into movie values (1240,'Hurlyburly',1998,5.70,1385,2039);
insert into movie values (1241,'Oliver!',1968,7.30,1381,1003);
insert into movie values (1242,'They Live',1988,6.30,1378,23);
insert into movie values (1243,'Money Train',1995,5.10,1378,410);
insert into movie values (1244,'Small Time Crooks',2000,6.70,1378,1);
insert into movie values (1245,'Dumbo',1941,7.50,1377,2245);
insert into movie values (1246,'To Have and Have Not',1944,7.90,1374,197);
insert into movie values (1247,'Shadow of a Doubt',1943,8.30,1370,11);
insert into movie values (1248,'Witness for the Prosecution',1957,8.30,1370,79);
insert into movie values (1249,'Victor/Victoria',1982,7.10,1365,65);
insert into movie values (1250,'Trees Lounge',1996,7.00,1365,186);
--- tabmovie, 1251, 50
insert into movie values (1251,'Swing Kids',1993,6.00,1365,2743);
insert into movie values (1252,'All That Jazz',1979,7.50,1362,1124);
insert into movie values (1253,'Teenage Mutant Ninja Turtles',1990,5.20,1348,1096);
insert into movie values (1254,'Bloodsport',1988,5.80,1348,2689);
insert into movie values (1255,'Topsy-Turvy',1999,7.70,1346,583);
insert into movie values (1256,'Diabolique',1996,4.90,1345,412);
insert into movie values (1257,'101 Dalmatians',1996,5.70,1343,149);
insert into movie values (1258,'Mirror Has Two Faces, The',1996,5.60,1343,207);
insert into movie values (1259,'Nashville',1975,7.90,1340,155);
insert into movie values (1260,'He Got Game',1998,6.80,1339,206);
insert into movie values (1261,'Five Easy Pieces',1970,7.40,1338,2467);
insert into movie values (1262,'East of Eden',1955,7.80,1337,655);
insert into movie values (1263,'She''s the One',1996,6.20,1334,485);
insert into movie values (1264,'Eight Men Out',1988,7.30,1331,931);
insert into movie values (1265,'Solyaris',1972,7.40,1330,658);
insert into movie values (1266,'Body Double',1984,6.30,1327,31);
insert into movie values (1267,'Spellbound',1945,7.50,1327,11);
insert into movie values (1268,'This Boy''s Life',1993,7.10,1325,374);
insert into movie values (1269,'Silent Running',1971,6.80,1324,1156);
insert into movie values (1270,'About Last Night...',1986,5.80,1324,382);
insert into movie values (1271,'Bride of Chucky',1998,5.50,1323,2824);
insert into movie values (1272,'Nick of Time',1995,6.10,1323,66);
insert into movie values (1273,'Freaks',1932,7.70,1322,2644);
insert into movie values (1274,'Altered States',1980,6.60,1321,909);
insert into movie values (1275,'Amazon Women on the Moon',1987,5.50,1317,150);
insert into movie values (1276,'Serpico',1973,7.50,1317,80);
insert into movie values (1277,'Murder at 1600',1997,6.00,1314,1178);
insert into movie values (1278,'Blown Away',1994,5.70,1314,672);
insert into movie values (1279,'Teen Wolf',1985,5.00,1310,2758);
insert into movie values (1280,'Pokémon the First Movie: Mewtwo Strikes Back',1999,4.00,1308,2625);
insert into movie values (1281,'Big Easy, The',1987,6.60,1304,2315);
insert into movie values (1282,'Escape from Alcatraz',1979,7.00,1303,346);
insert into movie values (1283,'At First Sight',1999,6.10,1302,1172);
insert into movie values (1284,'Frankie and Johnny',1991,6.50,1302,129);
insert into movie values (1285,'Rumble Fish',1983,6.70,1299,28);
insert into movie values (1286,'Wings of the Dove, The',1997,6.90,1296,988);
insert into movie values (1287,'Parent Trap, The',1998,6.90,1295,2747);
insert into movie values (1288,'Arizona Dream',1993,6.80,1285,663);
insert into movie values (1289,'Sister Act 2: Back in the Habit',1993,4.40,1285,537);
insert into movie values (1290,'Santa Clause, The',1994,5.90,1284,2452);
insert into movie values (1291,'Caligula',1980,4.30,1282,2642);
insert into movie values (1292,'Honeymoon in Vegas',1992,6.10,1282,375);
insert into movie values (1293,'Affair to Remember, An',1957,7.10,1281,992);
insert into movie values (1294,'To Wong Foo, Thanks for Everything, Julie Newmar',1995,5.50,1281,2399);
insert into movie values (1295,'Gorillas in the Mist',1988,6.70,1280,199);
insert into movie values (1296,'White Squall',1996,6.60,1280,110);
insert into movie values (1297,'Dirty Work',1998,5.70,1280,2464);
insert into movie values (1298,'Party, The',1968,7.30,1278,65);
insert into movie values (1299,'Smultronstället',1957,8.50,1278,420);
insert into movie values (1300,'Virtuosity',1995,5.40,1277,2455);
--- tabmovie, 1301, 50
insert into movie values (1301,'Book of Shadows: Blair Witch 2',2000,4.50,1277,1862);
insert into movie values (1302,'Taxi',1998,6.70,1276,2204);
insert into movie values (1303,'Crumb',1994,7.80,1273,2696);
insert into movie values (1304,'Fly Away Home',1996,7.00,1270,2239);
insert into movie values (1305,'Orgazmo',1997,5.70,1269,270);
insert into movie values (1306,'Cat People',1982,5.80,1267,652);
insert into movie values (1307,'Cool World',1992,4.00,1265,2849);
insert into movie values (1308,'Children of a Lesser God',1986,7.00,1265,2787);
insert into movie values (1309,'37°2 le matin',1986,6.90,1264,1132);
insert into movie values (1310,'Bonfire of the Vanities, The',1990,4.80,1262,31);
insert into movie values (1311,'Tampopo',1986,7.80,1259,2011);
insert into movie values (1312,'Guns of Navarone, The',1961,7.40,1259,1164);
insert into movie values (1313,'Chaplin',1992,6.80,1257,235);
insert into movie values (1314,'Hard Target',1993,5.70,1256,204);
insert into movie values (1315,'Nutty Professor II: The Klumps',2000,4.70,1251,384);
insert into movie values (1316,'Highlander III: The Sorcerer',1994,3.80,1249,2017);
insert into movie values (1317,'Eve''s Bayou',1997,7.30,1247,1232);
insert into movie values (1318,'Bananas',1971,7.00,1247,1);
insert into movie values (1319,'Where the Heart Is',2000,6.80,1245,2688);
insert into movie values (1320,'When We Were Kings',1996,7.80,1241,2111);
insert into movie values (1321,'Seven Brides for Seven Brothers',1954,7.20,1238,428);
insert into movie values (1322,'Brewster''s Millions',1985,5.50,1236,143);
insert into movie values (1323,'Titus',1999,7.80,1236,2025);
insert into movie values (1324,'Prince of Tides, The',1991,6.40,1232,207);
insert into movie values (1325,'Sophie''s Choice',1982,7.60,1231,275);
insert into movie values (1326,'T2 3-D: Battle Across Time',1996,7.80,1231,1174);
insert into movie values (1327,'Ulee''s Gold',1997,7.20,1227,2541);
insert into movie values (1328,'East Is East',1999,7.20,1226,2337);
insert into movie values (1329,'Hitcher, The',1986,6.80,1223,2493);
insert into movie values (1330,'Night to Remember, A',1958,7.70,1221,2776);
insert into movie values (1331,'Anywhere But Here',1999,6.30,1219,664);
insert into movie values (1332,'Pale Rider',1985,6.80,1218,2);
insert into movie values (1333,'Blowup',1966,7.20,1214,2587);
insert into movie values (1334,'Mystic Pizza',1988,6.00,1212,599);
insert into movie values (1335,'Young Guns II',1990,5.70,1209,627);
insert into movie values (1336,'Belle de jour',1967,7.70,1208,815);
insert into movie values (1337,'Blind Date',1987,5.30,1206,65);
insert into movie values (1338,'Fahrenheit 451',1966,7.00,1206,505);
insert into movie values (1339,'Ba wang bie ji',1993,7.80,1206,2001);
insert into movie values (1340,'Vegas Vacation',1997,4.80,1204,2775);
insert into movie values (1341,'Best in Show',2000,8.00,1203,352);
insert into movie values (1342,'When a Man Loves a Woman',1994,6.50,1203,2795);
insert into movie values (1343,'Murder by Death',1976,6.80,1202,2588);
insert into movie values (1344,'Straw Dogs',1971,7.20,1200,1072);
insert into movie values (1345,'Fail-Safe',1964,7.80,1199,80);
insert into movie values (1346,'Spitfire Grill, The',1996,6.70,1196,2116);
insert into movie values (1347,'Hilary and Jackie',1998,7.70,1196,2186);
insert into movie values (1348,'Henry: Portrait of a Serial Killer',1986,7.20,1194,974);
insert into movie values (1349,'Shooting Fish',1997,6.70,1190,2833);
insert into movie values (1350,'Crna macka, beli macor',1998,8.10,1189,663);
--- tabmovie, 1351, 50
insert into movie values (1351,'Cutthroat Island',1995,5.20,1188,210);
insert into movie values (1352,'Father of the Bride Part II',1995,5.50,1188,397);
insert into movie values (1353,'Bis ans Ende der Welt',1991,6.50,1185,269);
insert into movie values (1354,'Shadow, The',1994,5.30,1184,577);
insert into movie values (1355,'Sgt. Bilko',1996,5.10,1181,262);
insert into movie values (1356,'Nightmare on Elm Street 3: Dream Warriors, A',1987,5.70,1177,1122);
insert into movie values (1357,'Reine Margot, La',1994,7.50,1176,2613);
insert into movie values (1358,'RoboCop 3',1993,3.10,1175,2311);
insert into movie values (1359,'Dangerous Beauty',1998,7.10,1174,2492);
insert into movie values (1360,'Weekend at Bernie''s',1989,5.40,1173,954);
insert into movie values (1361,'Phantoms',1998,5.00,1172,1127);
insert into movie values (1362,'Dead Pool, The',1988,5.70,1168,2293);
insert into movie values (1363,'Presidio, The',1988,5.70,1162,103);
insert into movie values (1364,'Shaft',1971,6.50,1160,2134);
insert into movie values (1365,'Murder on the Orient Express',1974,6.90,1158,80);
insert into movie values (1366,'Englishman Who Went Up a Hill But Came Down a Mountain, The',1995,6.50,1155,2323);
insert into movie values (1367,'Diner',1982,7.40,1154,38);
insert into movie values (1368,'Your Friends  Neighbors',1998,6.40,1153,593);
insert into movie values (1369,'White Christmas',1954,7.00,1153,675);
insert into movie values (1370,'Tucker: The Man and His Dream',1988,6.80,1152,28);
insert into movie values (1371,'Sirens',1994,6.00,1152,1926);
insert into movie values (1372,'Bring It On',2000,6.50,1152,2808);
insert into movie values (1373,'Secret Garden, The',1993,7.10,1150,997);
insert into movie values (1374,'Forget Paris',1995,6.30,1150,158);
insert into movie values (1375,'Supernova',2000,3.90,1149,143);
insert into movie values (1376,'Mulholland Falls',1996,5.70,1148,624);
insert into movie values (1377,'Cradle Will Rock',1999,7.20,1147,25);
insert into movie values (1378,'Striking Distance',1993,5.30,1145,1090);
insert into movie values (1379,'Anatomy of a Murder',1959,8.20,1143,1406);
insert into movie values (1380,'New Nightmare',1994,6.20,1142,133);
insert into movie values (1381,'À bout de souffle',1960,8.00,1141,1689);
insert into movie values (1382,'Doom Generation, The',1995,4.90,1141,2152);
insert into movie values (1383,'Extreme Measures',1996,6.10,1139,199);
insert into movie values (1384,'Way of the Gun, The',2000,7.00,1137,2324);
insert into movie values (1385,'Something Wild',1986,6.60,1135,281);
insert into movie values (1386,'Romper Stomper',1992,7.10,1133,2101);
insert into movie values (1387,'Angela''s Ashes',1999,7.00,1131,68);
insert into movie values (1388,'Don''t Tell Mom the Babysitter''s Dead',1991,5.10,1127,149);
insert into movie values (1389,'Halloween III: Season of the Witch',1982,3.40,1126,2680);
insert into movie values (1390,'Red Sonja',1985,4.10,1124,402);
insert into movie values (1391,'Gingerbread Man, The',1998,5.90,1123,155);
insert into movie values (1392,'Mumford',1999,7.20,1121,87);
insert into movie values (1393,'Encino Man',1992,4.80,1120,632);
insert into movie values (1394,'Casualties of War',1989,6.60,1119,31);
insert into movie values (1395,'Giant',1956,7.60,1116,1022);
insert into movie values (1396,'Three Musketeers, The',1973,7.40,1116,274);
insert into movie values (1397,'Seventh Sign, The',1988,5.80,1115,2232);
insert into movie values (1398,'Auntie Mame',1958,7.50,1113,1137);
insert into movie values (1399,'Short Circuit 2',1988,4.30,1110,2006);
insert into movie values (1400,'Muse, The',1999,5.80,1110,247);
--- tabmovie, 1401, 50
insert into movie values (1401,'Phantom, The',1996,5.10,1107,1115);
insert into movie values (1402,'Enfants du paradis, Les',1945,8.40,1106,2573);
insert into movie values (1403,'Other Sister, The',1999,6.30,1104,129);
insert into movie values (1404,'Pacific Heights',1990,6.20,1102,677);
insert into movie values (1405,'Walkabout',1971,7.50,1101,1076);
insert into movie values (1406,'Aguirre, der Zorn Gottes',1972,8.10,1101,1886);
insert into movie values (1407,'Nothing But Trouble',1991,3.40,1100,15);
insert into movie values (1408,'Bitter Moon',1992,6.70,1100,90);
insert into movie values (1409,'Grumpier Old Men',1995,6.30,1100,285);
insert into movie values (1410,'House of the Spirits, The',1993,6.00,1099,584);
insert into movie values (1411,'Time Machine, The',1960,7.30,1097,2149);
insert into movie values (1412,'Catch-22',1970,6.90,1094,47);
insert into movie values (1413,'Hanging Up',2000,4.50,1093,94);
insert into movie values (1414,'Can''t Buy Me Love',1987,6.10,1091,2574);
insert into movie values (1415,'Trust',1990,7.70,1090,982);
insert into movie values (1416,'Boondock Saints, The',1999,7.40,1089,2641);
insert into movie values (1417,'Babettes gæstebud',1987,7.90,1088,2221);
insert into movie values (1418,'Nattevagten',1994,7.60,1085,1166);
insert into movie values (1419,'Air America',1990,5.20,1085,407);
insert into movie values (1420,'Ultimo tango a Parigi',1972,6.90,1081,598);
insert into movie values (1421,'How to Make an American Quilt',1995,6.10,1081,2299);
insert into movie values (1422,'Runaway Train',1985,7.00,1081,1049);
insert into movie values (1423,'Problem Child 2',1991,2.70,1080,395);
insert into movie values (1424,'Fright Night',1985,6.50,1079,562);
insert into movie values (1425,'Higher Learning',1995,6.30,1078,396);
insert into movie values (1426,'Defending Your Life',1991,7.10,1078,247);
insert into movie values (1427,'Annie',1982,5.30,1077,312);
insert into movie values (1428,'Slums of Beverly Hills',1998,6.40,1076,2543);
insert into movie values (1429,'Days of Heaven',1978,7.80,1076,686);
insert into movie values (1430,'Newsies',1992,5.20,1075,991);
insert into movie values (1431,'Picture Perfect',1997,5.80,1075,2139);
insert into movie values (1432,'Batman: Mask of the Phantasm',1993,6.90,1075,2089);
insert into movie values (1433,'High Plains Drifter',1972,7.10,1075,2);
insert into movie values (1434,'Cheech  Chong''s Next Movie',1980,5.20,1074,721);
insert into movie values (1435,'Adam''s Rib',1949,7.80,1073,628);
insert into movie values (1436,'''Breaker'' Morant',1980,7.80,1072,685);
insert into movie values (1437,'Brokedown Palace',1999,6.10,1071,580);
insert into movie values (1438,'Tea with Mussolini',1999,6.90,1071,1058);
insert into movie values (1439,'Super Mario Bros.',1993,3.40,1071,1175);
insert into movie values (1440,'Firefox',1982,5.30,1070,2);
insert into movie values (1441,'Stranger Than Paradise',1984,7.40,1069,175);
insert into movie values (1442,'Bedazzled',2000,6.40,1065,108);
insert into movie values (1443,'Yin shi nan nu',1994,7.80,1063,273);
insert into movie values (1444,'Detroit Rock City',1999,6.20,1061,977);
insert into movie values (1445,'Untamed Heart',1993,6.50,1061,2661);
insert into movie values (1446,'Antonia',1995,7.80,1061,2501);
insert into movie values (1447,'Young Sherlock Holmes',1985,6.30,1059,38);
insert into movie values (1448,'Tommy',1975,5.90,1059,909);
insert into movie values (1449,'School Ties',1992,6.70,1059,1007);
insert into movie values (1450,'One True Thing',1998,7.40,1058,998);
--- tabmovie, 1451, 50
insert into movie values (1451,'Boys on the Side',1995,6.20,1058,200);
insert into movie values (1452,'Buena Vista Social Club',1999,7.40,1057,269);
insert into movie values (1453,'Clash of the Titans',1981,5.70,1056,2468);
insert into movie values (1454,'Hellbound: Hellraiser II',1988,5.60,1056,2655);
insert into movie values (1455,'Holy Man',1998,5.20,1055,149);
insert into movie values (1456,'Bachelor, The',1999,5.10,1055,2112);
insert into movie values (1457,'Down Periscope',1996,5.30,1055,2425);
insert into movie values (1458,'Happy, Texas',1999,6.70,1054,2598);
insert into movie values (1459,'Guess Who''s Coming to Dinner',1967,7.20,1054,673);
insert into movie values (1460,'Fearless Vampire Killers, The',1967,6.80,1051,90);
insert into movie values (1461,'Assault on Precinct 13',1976,7.20,1050,23);
insert into movie values (1462,'Chase, The',1994,5.30,1046,977);
insert into movie values (1463,'Mod Squad, The',1999,3.60,1045,2725);
insert into movie values (1464,'Great Outdoors, The',1988,5.50,1044,285);
insert into movie values (1465,'Hairspray',1988,6.50,1044,364);
insert into movie values (1466,'Shootist, The',1976,7.40,1044,346);
insert into movie values (1467,'Un coeur en hiver',1992,7.70,1044,2296);
insert into movie values (1468,'Europa',1991,7.60,1042,615);
insert into movie values (1469,'Running on Empty',1988,7.10,1042,80);
insert into movie values (1470,'Nightmare on Elm Street Part 2: Freddy''s Revenge, A',1985,4.40,1041,1173);
insert into movie values (1471,'Paper, The',1994,6.30,1040,21);
insert into movie values (1472,'Holy Smoke',1999,5.80,1039,575);
insert into movie values (1473,'Near Dark',1987,7.00,1039,641);
insert into movie values (1474,'With Honors',1994,6.20,1036,2208);
insert into movie values (1475,'Clockers',1995,6.90,1035,206);
insert into movie values (1476,'Vanishing, The',1993,5.90,1035,2162);
insert into movie values (1477,'Getaway, The',1994,5.60,1034,146);
insert into movie values (1478,'Belle époque',1992,7.30,1033,2015);
insert into movie values (1479,'Road to Wellville, The',1994,5.00,1033,68);
insert into movie values (1480,'Peter''s Friends',1992,6.60,1033,48);
insert into movie values (1481,'Torch Song Trilogy',1988,6.70,1032,2567);
insert into movie values (1482,'Trouble with Harry, The',1955,7.30,1031,11);
insert into movie values (1483,'American in Paris, An',1951,7.50,1030,2597);
insert into movie values (1484,'Muppet Christmas Carol, The',1992,6.90,1030,1493);
insert into movie values (1485,'Secret of Roan Inish, The',1994,7.50,1030,931);
insert into movie values (1486,'Adventures of Rocky  Bullwinkle, The',2000,4.80,1028,2466);
insert into movie values (1487,'Child''s Play',1988,5.60,1028,562);
insert into movie values (1488,'Help!',1965,6.80,1027,274);
insert into movie values (1489,'Rage: Carrie 2, The',1999,4.80,1026,1160);
insert into movie values (1490,'Oscar',1991,5.30,1024,62);
insert into movie values (1491,'Desperate Measures',1998,5.50,1024,1104);
insert into movie values (1492,'Frenzy',1972,7.30,1022,11);
insert into movie values (1493,'Drop Dead Fred',1991,4.30,1022,2046);
insert into movie values (1494,'My Blue Heaven',1990,5.90,1022,200);
insert into movie values (1495,'Sid and Nancy',1986,7.00,1020,1041);
insert into movie values (1496,'What Ever Happened to Baby Jane?',1962,7.80,1020,1060);
insert into movie values (1497,'Freejack',1992,4.80,1019,627);
insert into movie values (1498,'Alice in Wonderland',1951,7.20,1018,266);
insert into movie values (1499,'Vie rêvée des anges, La',1998,8.10,1017,2073);
insert into movie values (1500,'Butcher Boy, The',1997,7.20,1017,153);
--- tabmovie, 1501, 50
insert into movie values (1501,'Carne trémula',1997,7.50,1016,394);
insert into movie values (1502,'Red Corner',1997,6.00,1016,691);
insert into movie values (1503,'Tonari no Totoro',1988,7.90,1014,1051);
insert into movie values (1504,'Rollerball',1975,6.20,1013,81);
insert into movie values (1505,'Outside Providence',1999,6.30,1010,2626);
insert into movie values (1506,'Verdict, The',1982,7.50,1010,80);
insert into movie values (1507,'PCU',1994,5.80,1009,730);
insert into movie values (1508,'Noises Off...',1992,6.80,1006,612);
insert into movie values (1509,'City Slickers II: The Legend of Curly''s Gold',1994,5.00,1006,2860);
insert into movie values (1510,'Sydney',1996,7.50,1006,1037);
insert into movie values (1511,'Clay Pigeons',1998,6.70,1005,2283);
insert into movie values (1512,'Suspiria',1977,7.10,1004,2259);
insert into movie values (1513,'Excess Baggage',1997,4.60,1003,1182);
insert into movie values (1514,'Mighty Ducks, The',1992,5.70,1003,149);
insert into movie values (1515,'Creepshow',1982,5.90,1001,379);
insert into movie values (1516,'Basquiat',1996,6.50,1001,2390);
insert into movie values (1517,'Baraka',1992,7.60,1000,2846);
insert into movie values (1518,'Heartbreak Ridge',1986,6.10,1000,2);
insert into movie values (1519,'On Deadly Ground',1994,3.70,999,171);
insert into movie values (1520,'Circle of Friends',1995,6.80,999,2610);
insert into movie values (1521,'Dracula: Dead and Loving It',1995,4.40,999,29);
insert into movie values (1522,'Andrei Rublyov',1969,8.40,996,658);
insert into movie values (1523,'HouseSitter',1992,6.00,995,123);
insert into movie values (1524,'Free Willy',1993,5.20,993,1115);
insert into movie values (1525,'Nightmare on Elm Street 4: The Dream Master, A',1988,4.80,992,210);
insert into movie values (1526,'Trick',1999,7.70,992,2314);
insert into movie values (1527,'Fog, The',1980,6.20,991,23);
insert into movie values (1528,'Twilight',1998,6.10,988,660);
insert into movie values (1529,'Colors',1988,6.30,988,125);
insert into movie values (1530,'Bambi Meets Godzilla',1969,7.50,985,2544);
insert into movie values (1531,'Sholay',1975,7.50,985,2848);
insert into movie values (1532,'D.O.A.',1988,6.10,983,1175);
insert into movie values (1533,'War of the Worlds, The',1953,7.10,983,2260);
insert into movie values (1534,'Midnight Clear, A',1991,7.50,981,644);
insert into movie values (1535,'Winslow Boy, The',1999,7.50,979,606);
insert into movie values (1536,'Tesis',1996,7.80,977,985);
insert into movie values (1537,'Saving Grace',2000,7.30,977,2503);
insert into movie values (1538,'Wrongfully Accused',1998,5.30,976,2593);
insert into movie values (1539,'Cry-Baby',1990,5.90,972,364);
insert into movie values (1540,'Mighty, The',1998,7.50,972,2770);
insert into movie values (1541,'1492: Conquest of Paradise',1992,6.00,970,110);
insert into movie values (1542,'Beneath the Planet of the Apes',1970,5.50,969,2692);
insert into movie values (1543,'Utomlyonnye solntsem',1994,7.70,968,1503);
insert into movie values (1544,'New York Stories',1989,6.20,968,1);
insert into movie values (1545,'Henry  June',1990,6.30,963,288);
insert into movie values (1546,'Deep End of the Ocean, The',1999,6.10,962,2734);
insert into movie values (1547,'Mighty Joe Young',1998,5.90,962,415);
insert into movie values (1548,'Blow Out',1981,7.00,961,31);
insert into movie values (1549,'Sandlot, The',1993,6.70,959,2273);
insert into movie values (1550,'Dressed to Kill',1980,6.90,958,31);
--- tabmovie, 1551, 50
insert into movie values (1551,'Beethoven',1992,5.10,958,395);
insert into movie values (1552,'Re-Animator',1985,6.70,957,2561);
insert into movie values (1553,'Fletch Lives',1989,5.10,955,418);
insert into movie values (1554,'Hsi yen',1993,7.70,954,273);
insert into movie values (1555,'Thunderheart',1992,6.50,953,199);
insert into movie values (1556,'Dellamorte Dellamore',1994,7.10,953,2659);
insert into movie values (1557,'Nightwatch',1998,6.00,953,1166);
insert into movie values (1558,'Pred dozhdot',1994,7.60,952,2643);
insert into movie values (1559,'Play It Again, Sam',1972,7.30,952,200);
insert into movie values (1560,'Harry and the Hendersons',1987,5.30,951,1059);
insert into movie values (1561,'Bio-Dome',1996,3.60,951,2275);
insert into movie values (1562,'Quick Change',1990,6.60,950,2061);
insert into movie values (1563,'My Dinner with André',1981,7.20,950,619);
insert into movie values (1564,'Wicker Man, The',1973,7.30,949,2863);
insert into movie values (1565,'Boomerang',1992,5.30,949,2852);
insert into movie values (1566,'Dragon: The Bruce Lee Story',1993,6.80,946,376);
insert into movie values (1567,'Bulletproof',1996,5.50,945,2094);
insert into movie values (1568,'Bride of Frankenstein',1935,8.10,945,1097);
insert into movie values (1569,'Cabin Boy',1994,4.30,944,2110);
insert into movie values (1570,'Quadrophenia',1979,6.70,944,2196);
insert into movie values (1571,'Mifunes sidste sang',1999,7.40,940,2594);
insert into movie values (1572,'Baby Geniuses',1999,2.20,939,579);
insert into movie values (1573,'Next Best Thing, The',2000,5.00,939,677);
insert into movie values (1574,'Coma',1978,6.40,939,1017);
insert into movie values (1575,'Night Shift',1982,6.30,936,21);
insert into movie values (1576,'Blue in the Face',1995,6.40,936,2552);
insert into movie values (1577,'Out-of-Towners, The',1999,5.00,936,1075);
insert into movie values (1578,'Take the Money and Run',1969,7.20,936,1);
insert into movie values (1579,'Screamers',1995,5.50,935,2347);
insert into movie values (1580,'Watership Down',1978,7.20,935,2551);
insert into movie values (1581,'Freddy''s Dead: The Final Nightmare',1991,4.20,935,1032);
insert into movie values (1582,'Screamers',1995,5.50,935,2346);
insert into movie values (1583,'House of Yes, The',1997,6.70,934,2510);
insert into movie values (1584,'Road House',1989,5.20,932,1090);
insert into movie values (1585,'New Jack City',1991,6.10,932,727);
insert into movie values (1586,'Chitty Chitty Bang Bang',1968,6.10,932,2002);
insert into movie values (1587,'Down to You',2000,4.60,931,2176);
insert into movie values (1588,'Mystery Train',1989,7.10,930,175);
insert into movie values (1589,'Return of the Pink Panther, The',1974,6.60,929,65);
insert into movie values (1590,'Palmetto',1998,5.40,929,980);
insert into movie values (1591,'Ngo hai sui',1998,6.90,926,2406);
insert into movie values (1592,'Beloved',1998,5.80,926,281);
insert into movie values (1593,'Subway',1985,6.40,925,389);
insert into movie values (1594,'Black Sheep',1996,4.90,924,1021);
insert into movie values (1595,'Power of One, The',1992,6.20,923,683);
insert into movie values (1596,'Fair Game',1995,3.90,922,2021);
insert into movie values (1597,'Boxing Helena',1993,3.90,921,2339);
insert into movie values (1598,'Dennis the Menace',1993,4.80,921,2716);
insert into movie values (1599,'Brothers McMullen, The',1995,6.60,920,485);
insert into movie values (1600,'Drowning Mona',2000,5.30,920,2704);
--- tabmovie, 1601, 50
insert into movie values (1601,'Problem Child',1990,3.60,918,330);
insert into movie values (1602,'Children of the Corn',1984,4.60,918,2206);
insert into movie values (1603,'Capricorn One',1978,6.20,917,103);
insert into movie values (1604,'Postcards from the Edge',1990,6.30,917,47);
insert into movie values (1605,'Cocoon: The Return',1988,4.80,917,2250);
insert into movie values (1606,'Romeo Is Bleeding',1993,6.10,915,1001);
insert into movie values (1607,'Silkwood',1983,6.90,915,47);
insert into movie values (1608,'Hunger, The',1983,6.20,914,107);
insert into movie values (1609,'Shot in the Dark, A',1964,7.40,914,65);
insert into movie values (1610,'1900',1976,7.60,913,598);
insert into movie values (1611,'Chamber, The',1996,5.60,913,423);
insert into movie values (1612,'Fame',1980,6.30,912,68);
insert into movie values (1613,'American Tail, An',1986,6.40,911,409);
insert into movie values (1614,'Friday the 13th Part 2',1981,4.40,907,365);
insert into movie values (1615,'Dîner de cons, Le',1998,7.70,906,2169);
insert into movie values (1616,'Big Kahuna, The',1999,7.10,905,2474);
insert into movie values (1617,'Beastmaster, The',1982,5.10,904,2373);
insert into movie values (1618,'Taps',1981,6.20,903,616);
insert into movie values (1619,'Highlander: Endgame',2000,5.20,901,2418);
insert into movie values (1620,'American Movie: The Making of Northwestern',1999,7.70,901,2342);
insert into movie values (1621,'Cadillac Man',1990,5.20,901,146);
insert into movie values (1622,'Zardoz',1974,5.40,900,293);
insert into movie values (1623,'Blechtrommel, Die',1979,7.90,900,980);
insert into movie values (1624,'High Anxiety',1977,6.30,898,29);
insert into movie values (1625,'Beverly Hills Ninja',1997,4.80,898,330);
insert into movie values (1626,'Next Friday',2000,4.90,897,2853);
insert into movie values (1627,'Tin Men',1987,6.30,894,38);
insert into movie values (1628,'Silent Movie',1976,6.00,893,29);
insert into movie values (1629,'She''s So Lovely',1997,5.80,893,1495);
insert into movie values (1630,'Funny Farm',1988,5.20,891,276);
insert into movie values (1631,'True Grit',1969,7.10,891,2040);
insert into movie values (1632,'Abre los ojos',1997,8.00,891,985);
insert into movie values (1633,'Simply Irresistible',1999,4.80,891,2515);
insert into movie values (1634,'Death Race 2000',1975,5.60,890,1329);
insert into movie values (1635,'Final Countdown, The',1980,6.50,889,489);
insert into movie values (1636,'Home Fries',1998,5.00,888,1101);
insert into movie values (1637,'Above the Law',1988,5.20,888,291);
insert into movie values (1638,'Dead Man on Campus',1998,5.50,888,2125);
insert into movie values (1639,'Supergirl',1984,3.70,888,600);
insert into movie values (1640,'Cure, The',1995,6.90,887,836);
insert into movie values (1641,'Cannonball Run II',1984,3.50,887,618);
insert into movie values (1642,'Fathers'' Day',1997,4.60,886,109);
insert into movie values (1643,'Persona',1966,8.00,885,420);
insert into movie values (1644,'Russia House, The',1990,6.10,885,272);
insert into movie values (1645,'Devil in a Blue Dress',1995,6.70,885,998);
insert into movie values (1646,'Over the Top',1987,3.80,885,2726);
insert into movie values (1647,'3 Men and a Little Lady',1990,4.50,885,662);
insert into movie values (1648,'Broadway Danny Rose',1984,7.30,884,1);
insert into movie values (1649,'Ying huang boon sik',1986,7.40,884,204);
insert into movie values (1650,'Xanadu',1980,4.30,884,2517);
--- tabmovie, 1651, 50
insert into movie values (1651,'Plunkett  Macleane',1999,6.40,883,2385);
insert into movie values (1652,'Visiteurs, Les',1993,6.30,882,2280);
insert into movie values (1653,'Flåklypa Grand Prix',1975,7.80,881,2400);
insert into movie values (1654,'Drop Zone',1994,5.50,880,66);
insert into movie values (1655,'Seven Year Itch, The',1955,7.10,880,79);
insert into movie values (1656,'Thing From Another World, The',1951,7.30,878,2345);
insert into movie values (1657,'I Love You to Death',1990,6.00,878,87);
insert into movie values (1658,'Repulsion',1965,7.90,877,90);
insert into movie values (1659,'Rosewood',1997,6.70,876,396);
insert into movie values (1660,'Firestarter',1984,5.60,875,1073);
insert into movie values (1661,'To Live and Die in L.A.',1985,6.60,874,264);
insert into movie values (1662,'Reds',1981,6.90,873,60);
insert into movie values (1663,'Flight of the Navigator',1986,6.30,873,383);
insert into movie values (1664,'High Art',1998,7.30,872,2867);
insert into movie values (1665,'Bed of Roses',1996,6.20,872,2621);
insert into movie values (1666,'Feeling Minnesota',1996,5.30,870,2578);
insert into movie values (1667,'Monty Python Live at the Hollywood Bowl',1982,7.10,869,2691);
insert into movie values (1668,'She''s Having a Baby',1988,5.60,868,144);
insert into movie values (1669,'What''s Up, Doc?',1972,7.30,868,612);
insert into movie values (1670,'Drowning by Numbers',1988,6.90,868,386);
insert into movie values (1671,'Stop Making Sense',1984,7.60,867,281);
insert into movie values (1672,'One Eight Seven',1997,6.50,867,378);
insert into movie values (1673,'Oscar and Lucinda',1997,6.80,866,2140);
insert into movie values (1674,'Amateur',1994,7.10,865,982);
insert into movie values (1675,'Something to Talk About',1995,5.80,864,387);
insert into movie values (1676,'My Fellow Americans',1996,6.50,864,384);
insert into movie values (1677,'Day of the Dead',1985,6.40,864,379);
insert into movie values (1678,'Fandango',1985,6.30,864,378);
insert into movie values (1679,'Purple Rain',1984,5.40,862,2211);
insert into movie values (1680,'My Dog Skip',2000,7.40,862,2284);
insert into movie values (1681,'Universal Soldier: The Return',1999,3.30,862,1866);
insert into movie values (1682,'Boxer, The',1997,6.90,862,581);
insert into movie values (1683,'Prospero''s Books',1991,5.90,860,386);
insert into movie values (1684,'Home for the Holidays',1995,6.30,859,215);
insert into movie values (1685,'Gorky Park',1983,6.50,858,199);
insert into movie values (1686,'Dream Team, The',1989,6.00,858,661);
insert into movie values (1687,'Gummo',1997,5.40,858,1970);
insert into movie values (1688,'Cotton Club, The',1984,6.10,857,28);
insert into movie values (1689,'Renaissance Man',1994,5.80,857,361);
insert into movie values (1690,'Only You',1994,6.30,855,81);
insert into movie values (1691,'Ridicule',1996,7.20,854,2612);
insert into movie values (1692,'Pink Panther Strikes Again, The',1976,6.80,852,65);
insert into movie values (1693,'Needful Things',1993,5.70,851,2175);
insert into movie values (1694,'Sudden Death',1995,5.10,851,103);
insert into movie values (1695,'20,000 Leagues Under the Sea',1954,7.10,850,402);
insert into movie values (1696,'Suspicion',1941,7.50,850,11);
insert into movie values (1697,'Stunt Man, The',1980,7.40,849,1039);
insert into movie values (1698,'Bad News Bears, The',1976,6.50,847,418);
insert into movie values (1699,'Song of the South',1946,7.20,847,2190);
insert into movie values (1700,'Airport',1970,6.30,846,1061);
--- tabmovie, 1701, 50
insert into movie values (1701,'Contender, The',2000,7.00,846,2768);
insert into movie values (1702,'Superstar',1999,4.50,846,1506);
insert into movie values (1703,'Drive Me Crazy',1999,5.10,846,2423);
insert into movie values (1704,'Prince of Darkness',1987,6.20,844,23);
insert into movie values (1705,'Exorcist II: The Heretic',1977,3.20,842,293);
insert into movie values (1706,'I Love Trouble',1994,5.20,842,397);
insert into movie values (1707,'Blue Thunder',1983,6.00,840,66);
insert into movie values (1708,'Amityville Horror, The',1979,5.10,839,1029);
insert into movie values (1709,'Blame It on Rio',1984,5.10,839,428);
insert into movie values (1710,'Omega Man, The',1971,6.30,838,2483);
insert into movie values (1711,'Attack of the Killer Tomatoes!',1978,3.60,837,2242);
insert into movie values (1712,'Scanners',1981,6.30,837,97);
insert into movie values (1713,'Damien: Omen II',1978,5.50,837,489);
insert into movie values (1714,'Around the World in Eighty Days',1956,6.70,836,2698);
insert into movie values (1715,'Indochine',1992,6.90,835,2785);
insert into movie values (1716,'Oh, God!',1977,5.90,832,221);
insert into movie values (1717,'Body of Evidence',1993,4.10,831,2735);
insert into movie values (1718,'Canadian Bacon',1995,5.40,829,955);
insert into movie values (1719,'Wait Until Dark',1967,7.50,829,388);
insert into movie values (1720,'Felicia''s Journey',1999,7.20,827,665);
insert into movie values (1721,'Yume',1990,7.40,825,208);
insert into movie values (1722,'Home Alone 3',1997,3.70,825,633);
insert into movie values (1723,'Hotaru no haka',1988,8.50,822,2401);
insert into movie values (1724,'1776',1972,7.00,821,2822);
insert into movie values (1725,'Brainstorm',1983,6.20,821,1156);
insert into movie values (1726,'Wilde',1997,7.00,820,2431);
insert into movie values (1727,'Escape from the Planet of the Apes',1971,5.80,819,489);
insert into movie values (1728,'Foul Play',1978,6.50,818,1110);
insert into movie values (1729,'One, Two, Three',1961,7.70,818,79);
insert into movie values (1730,'Turbulence',1997,4.20,818,2707);
insert into movie values (1731,'Halloween 4: The Return of Michael Myers',1988,5.00,818,1178);
insert into movie values (1732,'Moscow on the Hudson',1984,6.20,818,720);
insert into movie values (1733,'Pallbearer, The',1996,4.90,817,2686);
insert into movie values (1734,'See No Evil, Hear No Evil',1989,5.60,817,1087);
insert into movie values (1735,'Crush, The',1993,5.30,817,2115);
insert into movie values (1736,'Guarding Tess',1994,6.10,816,377);
insert into movie values (1737,'Hotel New Hampshire, The',1984,5.80,814,2653);
insert into movie values (1738,'Music of the Heart',1999,6.90,814,133);
insert into movie values (1739,'Yatgo ho yan',1997,6.40,814,1691);
insert into movie values (1740,'Erik the Viking',1989,5.60,814,694);
insert into movie values (1741,'Red River',1948,8.40,813,197);
insert into movie values (1742,'We''re No Angels',1989,5.30,812,153);
insert into movie values (1743,'SLC Punk!',1999,7.10,811,2479);
insert into movie values (1744,'Boys from Brazil, The',1978,6.50,809,405);
insert into movie values (1745,'Young Einstein',1988,4.80,809,999);
insert into movie values (1746,'Hitlerjunge Salomon',1990,7.70,808,997);
insert into movie values (1747,'Navy SEALS',1990,5.00,807,1016);
insert into movie values (1748,'Poison Ivy',1992,5.00,806,1160);
insert into movie values (1749,'Ikiru',1952,8.80,805,208);
insert into movie values (1750,'Hope and Glory',1987,7.60,803,293);
--- tabmovie, 1751, 50
insert into movie values (1751,'Cape Fear',1962,7.60,803,1164);
insert into movie values (1752,'Yentl',1983,5.70,803,207);
insert into movie values (1753,'Bounty, The',1984,6.70,802,146);
insert into movie values (1754,'Talk Radio',1988,6.80,799,69);
insert into movie values (1755,'Silver Streak',1976,6.50,798,1087);
insert into movie values (1756,'Exit to Eden',1994,3.90,797,129);
insert into movie values (1757,'Dobermann',1997,6.60,797,2451);
insert into movie values (1758,'Poltergeist II: The Other Side',1986,4.80,796,1171);
insert into movie values (1759,'Hush',1998,4.40,796,2378);
insert into movie values (1760,'Phantom of the Paradise',1974,6.60,796,31);
insert into movie values (1761,'Terminal Velocity',1994,5.40,795,2463);
insert into movie values (1762,'Wishmaster',1997,4.90,794,2502);
insert into movie values (1763,'Honey, I Blew Up the Kid',1992,4.30,793,383);
insert into movie values (1764,'Thomas Crown Affair, The',1968,6.80,793,81);
insert into movie values (1765,'...And Justice for All',1979,6.70,791,81);
insert into movie values (1766,'Halloween: The Curse of Michael Myers',1995,4.30,791,1127);
insert into movie values (1767,'Paper Moon',1973,7.50,790,612);
insert into movie values (1768,'To Be or Not to Be',1942,8.50,789,2014);
insert into movie values (1769,'Toy Soldiers',1991,5.80,789,2253);
insert into movie values (1770,'Midsummer Night''s Sex Comedy, A',1982,6.20,789,1);
insert into movie values (1771,'Death on the Nile',1978,6.50,787,2287);
insert into movie values (1772,'Funny Games',1997,7.40,786,2629);
insert into movie values (1773,'Stand and Deliver',1987,7.00,786,2840);
insert into movie values (1774,'Gung Ho',1986,5.60,786,21);
insert into movie values (1775,'Distinguished Gentleman, The',1992,5.70,786,262);
insert into movie values (1776,'Good Son, The',1993,5.50,785,410);
insert into movie values (1777,'Milk Money',1994,5.20,785,320);
insert into movie values (1778,'Family Business',1989,5.20,783,80);
insert into movie values (1779,'Sudden Impact',1983,6.10,782,2);
insert into movie values (1780,'Remo Williams: The Adventure Begins...',1985,5.60,781,636);
insert into movie values (1781,'Hidden, The',1987,6.90,781,1173);
insert into movie values (1782,'SubUrbia',1997,6.40,780,205);
insert into movie values (1783,'Scarlet Letter, The',1995,4.20,780,1170);
insert into movie values (1784,'SpaceCamp',1986,5.30,780,2191);
insert into movie values (1785,'Glimmer Man, The',1996,5.00,779,2278);
insert into movie values (1786,'Richie Rich',1994,4.30,778,599);
insert into movie values (1787,'Double Team',1997,4.20,778,2164);
insert into movie values (1788,'Atlantic City',1980,7.80,777,619);
insert into movie values (1789,'Educating Rita',1983,6.80,777,390);
insert into movie values (1790,'Court Jester, The',1956,8.20,777,2717);
insert into movie values (1791,'Teen Wolf Too',1987,2.50,775,2298);
insert into movie values (1792,'Slacker',1991,6.80,774,205);
insert into movie values (1793,'Two Girls and a Guy',1997,5.80,773,2429);
insert into movie values (1794,'Raw Deal',1986,4.70,773,2265);
insert into movie values (1795,'Taking of Pelham One Two Three, The',1974,7.50,773,1119);
insert into movie values (1796,'Psycho II',1983,5.60,772,2513);
insert into movie values (1797,'Friday the 13th Part 3: 3D',1982,3.80,772,365);
insert into movie values (1798,'Ghosts of Mississippi',1996,6.50,772,37);
insert into movie values (1799,'Great Race, The',1965,6.80,772,65);
insert into movie values (1800,'Un chien andalou',1929,8.30,772,815);
--- tabmovie, 1801, 50
insert into movie values (1801,'Hearts of Darkness: A Filmmaker''s Apocalypse',1991,8.20,772,2031);
insert into movie values (1802,'Hoffa',1992,6.00,771,24);
insert into movie values (1803,'Don''t Look Now',1973,7.50,770,1076);
insert into movie values (1804,'Teenage Mutant Ninja Turtles II: The Secret of the Ooze',1991,4.10,769,2652);
insert into movie values (1805,'Orlando',1992,6.50,769,2489);
insert into movie values (1806,'Playing God',1997,5.40,768,2026);
insert into movie values (1807,'American Gigolo',1980,5.70,768,652);
insert into movie values (1808,'Serpent and the Rainbow, The',1988,5.80,768,133);
insert into movie values (1809,'U2: Rattle and Hum',1988,6.80,767,2807);
insert into movie values (1810,'Used Cars',1980,6.30,767,67);
insert into movie values (1811,'Valley Girl',1983,6.00,767,1141);
insert into movie values (1812,'Shadows and Fog',1992,6.20,767,1);
insert into movie values (1813,'Out of Rosenheim',1988,7.20,767,2771);
insert into movie values (1814,'Portrait of a Lady, The',1996,5.80,767,575);
insert into movie values (1815,'Selena',1997,6.10,765,2155);
insert into movie values (1816,'My Beautiful Laundrette',1985,6.80,764,292);
insert into movie values (1817,'Project X',1987,5.80,763,580);
insert into movie values (1818,'Robin Hood',1973,7.10,762,1004);
insert into movie values (1819,'Newton Boys, The',1998,5.80,762,205);
insert into movie values (1820,'Money Talks',1997,5.60,760,1094);
insert into movie values (1821,'Don''t Be a Menace to South Central While Drinking Your Juice in the Hood',1996,5.90,760,2599);
insert into movie values (1822,'Billy Bathgate',1991,5.70,760,660);
insert into movie values (1823,'Muppets From Space',1999,6.20,760,2721);
insert into movie values (1824,'Hocus Pocus',1993,4.90,760,991);
insert into movie values (1825,'Thinner',1996,4.90,759,562);
insert into movie values (1826,'Restoration',1995,6.80,759,401);
insert into movie values (1827,'Hard Way, The',1991,6.00,758,66);
insert into movie values (1828,'Baby Boom',1987,5.70,758,397);
insert into movie values (1829,'Time After Time',1979,7.10,757,571);
insert into movie values (1830,'¡Átame!',1990,6.70,755,394);
insert into movie values (1831,'Angels in the Outfield',1994,5.50,752,1059);
insert into movie values (1832,'Parent Trap, The',1961,6.90,752,2433);
insert into movie values (1833,'Santa Claus Conquers the Martians',1964,2.10,750,2713);
insert into movie values (1834,'Truly Madly Deeply',1991,6.80,749,621);
insert into movie values (1835,'Very Brady Sequel, A',1996,5.30,749,2048);
insert into movie values (1836,'Duoluo tianshi',1995,7.40,747,1095);
insert into movie values (1837,'Summer School',1987,5.80,745,221);
insert into movie values (1838,'Bewegte Mann, Der',1994,6.70,743,2589);
insert into movie values (1839,'Streets of Fire',1984,6.10,742,143);
insert into movie values (1840,'Heart and Souls',1993,6.80,736,415);
insert into movie values (1841,'Barcelona',1994,6.60,734,2857);
insert into movie values (1842,'Absence of Malice',1981,6.70,734,92);
insert into movie values (1843,'Milagro Beanfield War, The',1988,6.70,726,36);
insert into movie values (1844,'End of Violence, The',1997,5.60,724,269);
insert into movie values (1845,'Hollywood Knights, The',1980,5.50,721,2016);
--- tabcasting, 1, 50
insert into casting values (972,588,1);
insert into casting values (849,588,2);
insert into casting values (1575,588,3);
insert into casting values (1835,588,1);
insert into casting values (47,590,4);
insert into casting values (334,590,5);
insert into casting values (368,590,2);
insert into casting values (549,590,4);
insert into casting values (886,591,5);
insert into casting values (882,591,4);
insert into casting values (1391,591,4);
insert into casting values (1409,591,6);
insert into casting values (14,591,6);
insert into casting values (625,591,2);
insert into casting values (513,591,2);
insert into casting values (244,592,1);
insert into casting values (639,592,1);
insert into casting values (560,592,1);
insert into casting values (1087,594,3);
insert into casting values (868,594,2);
insert into casting values (1340,594,2);
insert into casting values (82,594,3);
insert into casting values (621,594,2);
insert into casting values (669,594,2);
insert into casting values (788,596,6);
insert into casting values (1112,596,8);
insert into casting values (1463,596,5);
insert into casting values (1557,596,4);
insert into casting values (1665,596,4);
insert into casting values (262,596,2);
insert into casting values (533,596,3);
insert into casting values (209,601,3);
insert into casting values (349,601,3);
insert into casting values (472,601,3);
insert into casting values (402,601,3);
insert into casting values (438,601,2);
insert into casting values (410,601,3);
insert into casting values (1633,602,1);
insert into casting values (204,602,1);
insert into casting values (244,602,2);
insert into casting values (137,602,4);
insert into casting values (1652,603,2);
insert into casting values (126,603,2);
insert into casting values (202,603,2);
insert into casting values (79,603,5);
insert into casting values (658,603,4);
insert into casting values (548,603,3);
insert into casting values (1015,605,2);
insert into casting values (1030,605,3);
insert into casting values (1007,605,2);
--- tabcasting, 51, 50
insert into casting values (1210,605,5);
insert into casting values (569,605,3);
insert into casting values (657,605,7);
insert into casting values (642,605,8);
insert into casting values (1361,608,1);
insert into casting values (1291,608,4);
insert into casting values (1639,608,3);
insert into casting values (1697,608,1);
insert into casting values (891,609,2);
insert into casting values (1201,609,6);
insert into casting values (1408,609,2);
insert into casting values (190,609,5);
insert into casting values (79,609,7);
insert into casting values (81,609,4);
insert into casting values (730,609,2);
insert into casting values (814,610,2);
insert into casting values (1322,610,1);
insert into casting values (1734,610,1);
insert into casting values (1755,610,3);
insert into casting values (740,611,5);
insert into casting values (1781,611,1);
insert into casting values (214,611,8);
insert into casting values (284,611,2);
insert into casting values (370,611,2);
insert into casting values (503,611,8);
insert into casting values (1085,613,2);
insert into casting values (784,613,2);
insert into casting values (1596,613,1);
insert into casting values (343,613,2);
insert into casting values (525,613,4);
insert into casting values (742,622,3);
insert into casting values (752,622,2);
insert into casting values (1437,622,5);
insert into casting values (1375,622,4);
insert into casting values (1335,622,3);
insert into casting values (452,622,3);
insert into casting values (822,623,3);
insert into casting values (1434,623,9);
insert into casting values (1663,623,2);
insert into casting values (323,623,6);
insert into casting values (717,623,1);
insert into casting values (444,623,5);
insert into casting values (905,625,1);
insert into casting values (165,625,1);
insert into casting values (383,625,1);
insert into casting values (1222,626,3);
insert into casting values (1483,626,1);
insert into casting values (1650,626,2);
insert into casting values (222,626,1);
insert into casting values (851,629,6);
--- tabcasting, 101, 50
insert into casting values (894,629,2);
insert into casting values (1197,629,5);
insert into casting values (270,629,4);
insert into casting values (149,629,6);
insert into casting values (207,629,3);
insert into casting values (1237,634,1);
insert into casting values (49,634,1);
insert into casting values (422,634,1);
insert into casting values (898,635,5);
insert into casting values (1355,635,4);
insert into casting values (1203,635,7);
insert into casting values (1678,635,8);
insert into casting values (352,635,2);
insert into casting values (567,635,3);
insert into casting values (640,635,3);
insert into casting values (956,637,9);
insert into casting values (1458,637,5);
insert into casting values (1431,637,5);
insert into casting values (1573,637,3);
insert into casting values (312,637,9);
insert into casting values (571,637,4);
insert into casting values (688,637,5);
insert into casting values (1377,638,2);
insert into casting values (1188,638,3);
insert into casting values (1843,638,1);
insert into casting values (691,638,4);
insert into casting values (662,638,4);
insert into casting values (1472,640,1);
insert into casting values (236,640,4);
insert into casting values (4,640,2);
insert into casting values (381,640,2);
insert into casting values (1820,643,7);
insert into casting values (1663,643,3);
insert into casting values (257,643,5);
insert into casting values (35,643,3);
insert into casting values (333,643,8);
insert into casting values (493,643,5);
insert into casting values (1036,644,1);
insert into casting values (1106,644,4);
insert into casting values (1550,644,4);
insert into casting values (837,645,4);
insert into casting values (1806,645,2);
insert into casting values (1618,645,2);
insert into casting values (658,645,3);
insert into casting values (616,645,5);
insert into casting values (462,645,4);
insert into casting values (1128,646,8);
insert into casting values (220,646,4);
insert into casting values (119,646,3);
insert into casting values (550,646,6);
--- tabcasting, 151, 50
insert into casting values (669,646,5);
insert into casting values (611,646,1);
insert into casting values (802,647,4);
insert into casting values (1324,647,4);
insert into casting values (1284,647,5);
insert into casting values (1421,647,4);
insert into casting values (1239,647,5);
insert into casting values (287,647,9);
insert into casting values (497,647,9);
insert into casting values (1075,648,6);
insert into casting values (945,648,5);
insert into casting values (1424,648,4);
insert into casting values (1182,648,8);
insert into casting values (1727,648,1);
insert into casting values (362,648,2);
insert into casting values (826,649,1);
insert into casting values (1164,649,1);
insert into casting values (1116,649,1);
insert into casting values (792,650,1);
insert into casting values (884,650,6);
insert into casting values (1664,650,1);
insert into casting values (119,650,7);
insert into casting values (328,650,4);
insert into casting values (853,656,7);
insert into casting values (944,656,6);
insert into casting values (1221,656,2);
insert into casting values (1253,656,2);
insert into casting values (1370,656,6);
insert into casting values (124,656,8);
insert into casting values (151,656,7);
insert into casting values (632,656,6);
insert into casting values (592,656,3);
insert into casting values (1045,659,2);
insert into casting values (1346,659,2);
insert into casting values (1342,659,3);
insert into casting values (1421,659,3);
insert into casting values (135,659,1);
insert into casting values (1073,1,1);
insert into casting values (921,1,1);
insert into casting values (1169,1,1);
insert into casting values (1244,1,1);
insert into casting values (1121,1,1);
insert into casting values (1210,1,2);
insert into casting values (1318,1,1);
insert into casting values (1173,1,7);
insert into casting values (1812,1,2);
insert into casting values (1648,1,1);
insert into casting values (1544,1,1);
insert into casting values (1578,1,1);
insert into casting values (1770,1,1);
--- tabcasting, 201, 50
insert into casting values (1559,1,1);
insert into casting values (208,1,1);
insert into casting values (254,1,1);
insert into casting values (705,1,9);
insert into casting values (642,1,1);
insert into casting values (724,1,8);
insert into casting values (1027,2,1);
insert into casting values (1061,2,2);
insert into casting values (1098,2,1);
insert into casting values (769,2,1);
insert into casting values (812,2,1);
insert into casting values (1440,2,1);
insert into casting values (1111,2,1);
insert into casting values (1433,2,1);
insert into casting values (1362,2,1);
insert into casting values (1332,2,1);
insert into casting values (1282,2,1);
insert into casting values (1779,2,1);
insert into casting values (1518,2,1);
insert into casting values (298,2,1);
insert into casting values (118,2,1);
insert into casting values (249,2,1);
insert into casting values (626,2,1);
insert into casting values (651,2,1);
insert into casting values (657,2,1);
insert into casting values (680,2,2);
insert into casting values (733,3,1);
insert into casting values (794,3,1);
insert into casting values (1054,3,1);
insert into casting values (881,3,1);
insert into casting values (1268,3,1);
insert into casting values (1486,3,5);
insert into casting values (1610,3,1);
insert into casting values (1742,3,1);
insert into casting values (155,3,1);
insert into casting values (343,3,3);
insert into casting values (43,3,1);
insert into casting values (247,3,2);
insert into casting values (253,3,3);
insert into casting values (61,3,4);
insert into casting values (149,3,1);
insert into casting values (65,3,1);
insert into casting values (312,3,1);
insert into casting values (202,3,1);
insert into casting values (342,3,1);
insert into casting values (196,3,1);
insert into casting values (80,3,2);
insert into casting values (89,3,2);
insert into casting values (122,3,5);
insert into casting values (163,3,1);
--- tabcasting, 251, 50
insert into casting values (372,3,1);
insert into casting values (684,3,2);
insert into casting values (495,3,1);
insert into casting values (428,3,4);
insert into casting values (645,3,6);
insert into casting values (880,4,1);
insert into casting values (747,4,1);
insert into casting values (1045,4,3);
insert into casting values (810,4,1);
insert into casting values (771,4,1);
insert into casting values (801,4,1);
insert into casting values (1232,4,1);
insert into casting values (1363,4,1);
insert into casting values (1185,4,9);
insert into casting values (1365,4,7);
insert into casting values (1644,4,1);
insert into casting values (1778,4,1);
insert into casting values (1622,4,1);
insert into casting values (260,4,1);
insert into casting values (96,4,1);
insert into casting values (37,4,2);
insert into casting values (167,4,4);
insert into casting values (51,4,1);
insert into casting values (199,4,1);
insert into casting values (122,4,2);
insert into casting values (393,4,1);
insert into casting values (501,4,2);
insert into casting values (380,4,3);
insert into casting values (423,4,1);
insert into casting values (479,4,1);
insert into casting values (643,4,1);
insert into casting values (579,4,1);
insert into casting values (806,5,1);
insert into casting values (789,5,1);
insert into casting values (762,5,1);
insert into casting values (1083,5,1);
insert into casting values (897,5,1);
insert into casting values (1031,5,1);
insert into casting values (736,5,1);
insert into casting values (995,5,1);
insert into casting values (828,5,1);
insert into casting values (903,5,1);
insert into casting values (1490,5,5);
insert into casting values (1634,5,3);
insert into casting values (1646,5,1);
insert into casting values (254,5,11);
insert into casting values (261,5,1);
insert into casting values (607,5,1);
insert into casting values (703,5,1);
insert into casting values (606,5,1);
--- tabcasting, 301, 50
insert into casting values (441,5,1);
insert into casting values (428,5,1);
insert into casting values (369,5,1);
insert into casting values (783,6,1);
insert into casting values (980,6,1);
insert into casting values (891,6,1);
insert into casting values (764,6,1);
insert into casting values (865,6,1);
insert into casting values (243,6,1);
insert into casting values (11,6,1);
insert into casting values (103,6,1);
insert into casting values (356,6,1);
insert into casting values (38,6,1);
insert into casting values (37,6,1);
insert into casting values (5,6,2);
insert into casting values (13,6,2);
insert into casting values (344,6,1);
insert into casting values (1,6,2);
insert into casting values (14,6,1);
insert into casting values (45,6,10);
insert into casting values (117,6,1);
insert into casting values (662,6,1);
insert into casting values (553,6,1);
insert into casting values (371,6,12);
insert into casting values (436,6,1);
insert into casting values (700,6,9);
insert into casting values (429,6,1);
insert into casting values (482,6,1);
insert into casting values (811,7,1);
insert into casting values (1018,7,1);
insert into casting values (902,7,1);
insert into casting values (908,7,6);
insert into casting values (926,7,1);
insert into casting values (1235,7,1);
insert into casting values (1642,7,1);
insert into casting values (1732,7,1);
insert into casting values (1621,7,1);
insert into casting values (265,7,2);
insert into casting values (259,7,1);
insert into casting values (302,7,3);
insert into casting values (183,7,2);
insert into casting values (297,7,1);
insert into casting values (48,7,1);
insert into casting values (29,7,1);
insert into casting values (347,7,1);
insert into casting values (368,7,1);
insert into casting values (382,7,1);
insert into casting values (372,7,2);
insert into casting values (520,7,9);
insert into casting values (574,7,15);
--- tabcasting, 351, 50
insert into casting values (842,8,1);
insert into casting values (849,8,1);
insert into casting values (1043,8,1);
insert into casting values (813,8,2);
insert into casting values (933,8,1);
insert into casting values (1310,8,1);
insert into casting values (53,8,1);
insert into casting values (224,8,1);
insert into casting values (57,8,1);
insert into casting values (16,8,1);
insert into casting values (320,8,6);
insert into casting values (219,8,1);
insert into casting values (181,8,1);
insert into casting values (8,8,1);
insert into casting values (73,8,1);
insert into casting values (269,8,1);
insert into casting values (116,8,1);
insert into casting values (513,8,1);
insert into casting values (1009,9,1);
insert into casting values (925,9,1);
insert into casting values (1390,9,1);
insert into casting values (1794,9,1);
insert into casting values (130,9,1);
insert into casting values (295,9,1);
insert into casting values (107,9,1);
insert into casting values (91,9,1);
insert into casting values (46,9,1);
insert into casting values (251,9,1);
insert into casting values (20,9,1);
insert into casting values (203,9,1);
insert into casting values (406,9,1);
insert into casting values (403,9,1);
insert into casting values (477,9,1);
insert into casting values (676,9,1);
insert into casting values (964,10,1);
insert into casting values (851,10,1);
insert into casting values (818,10,3);
insert into casting values (1204,10,1);
insert into casting values (1678,10,1);
insert into casting values (109,10,1);
insert into casting values (233,10,1);
insert into casting values (120,10,1);
insert into casting values (210,10,1);
insert into casting values (122,10,1);
insert into casting values (490,10,1);
insert into casting values (635,10,1);
insert into casting values (680,10,1);
insert into casting values (699,10,1);
insert into casting values (575,10,1);
insert into casting values (1037,12,1);
--- tabcasting, 401, 50
insert into casting values (1284,12,1);
insert into casting values (1276,12,1);
insert into casting values (1132,12,1);
insert into casting values (1765,12,1);
insert into casting values (136,12,2);
insert into casting values (80,12,1);
insert into casting values (266,12,1);
insert into casting values (268,12,1);
insert into casting values (364,12,1);
insert into casting values (12,12,2);
insert into casting values (186,12,1);
insert into casting values (350,12,1);
insert into casting values (61,12,1);
insert into casting values (437,12,1);
insert into casting values (543,12,1);
insert into casting values (547,12,1);
insert into casting values (567,12,4);
insert into casting values (498,12,2);
insert into casting values (1378,13,1);
insert into casting values (1188,13,1);
insert into casting values (1114,13,3);
insert into casting values (1337,13,2);
insert into casting values (1310,13,2);
insert into casting values (1115,13,1);
insert into casting values (1822,13,4);
insert into casting values (31,13,2);
insert into casting values (182,13,1);
insert into casting values (42,13,1);
insert into casting values (58,13,1);
insert into casting values (18,13,1);
insert into casting values (3,13,12);
insert into casting values (278,13,1);
insert into casting values (30,13,1);
insert into casting values (197,13,1);
insert into casting values (562,13,2);
insert into casting values (604,13,3);
insert into casting values (379,13,1);
insert into casting values (591,13,1);
insert into casting values (1002,14,3);
insert into casting values (1049,14,1);
insert into casting values (1190,14,1);
insert into casting values (1355,14,1);
insert into casting values (1212,14,1);
insert into casting values (1352,14,1);
insert into casting values (1523,14,1);
insert into casting values (1577,14,1);
insert into casting values (1494,14,1);
insert into casting values (359,14,1);
insert into casting values (670,14,1);
insert into casting values (609,14,1);
--- tabcasting, 451, 50
insert into casting values (625,14,1);
insert into casting values (506,14,9);
insert into casting values (466,14,1);
insert into casting values (577,14,6);
insert into casting values (640,14,1);
insert into casting values (516,14,4);
insert into casting values (885,15,1);
insert into casting values (1021,15,1);
insert into casting values (776,15,11);
insert into casting values (1008,15,2);
insert into casting values (1086,15,1);
insert into casting values (813,15,1);
insert into casting values (1313,15,7);
insert into casting values (1171,15,13);
insert into casting values (1167,15,1);
insert into casting values (1355,15,2);
insert into casting values (1219,15,1);
insert into casting values (1407,15,2);
insert into casting values (1464,15,1);
insert into casting values (1676,15,3);
insert into casting values (1756,15,4);
insert into casting values (1666,15,7);
insert into casting values (131,15,4);
insert into casting values (285,15,6);
insert into casting values (67,15,2);
insert into casting values (254,15,2);
insert into casting values (345,15,2);
insert into casting values (108,15,2);
insert into casting values (103,15,13);
insert into casting values (581,15,3);
insert into casting values (624,15,5);
insert into casting values (468,15,2);
insert into casting values (781,16,1);
insert into casting values (945,16,1);
insert into casting values (763,16,2);
insert into casting values (851,16,2);
insert into casting values (863,16,2);
insert into casting values (1185,16,11);
insert into casting values (1383,16,2);
insert into casting values (1184,16,2);
insert into casting values (1204,16,3);
insert into casting values (1604,16,4);
insert into casting values (1528,16,3);
insert into casting values (1611,16,2);
insert into casting values (174,16,2);
insert into casting values (279,16,2);
insert into casting values (118,16,2);
insert into casting values (347,16,2);
insert into casting values (258,16,2);
insert into casting values (270,16,2);
--- tabcasting, 501, 50
insert into casting values (254,16,6);
insert into casting values (319,16,3);
insert into casting values (521,16,1);
insert into casting values (526,16,4);
insert into casting values (657,16,2);
insert into casting values (665,16,1);
insert into casting values (648,16,1);
insert into casting values (700,16,1);
insert into casting values (770,17,2);
insert into casting values (844,17,2);
insert into casting values (1065,17,1);
insert into casting values (1146,17,2);
insert into casting values (1292,17,2);
insert into casting values (1285,17,7);
insert into casting values (1688,17,7);
insert into casting values (1736,17,2);
insert into casting values (1811,17,1);
insert into casting values (62,17,2);
insert into casting values (157,17,1);
insert into casting values (140,17,1);
insert into casting values (274,17,1);
insert into casting values (322,17,1);
insert into casting values (51,17,2);
insert into casting values (255,17,1);
insert into casting values (568,17,1);
insert into casting values (385,17,1);
insert into casting values (395,17,1);
insert into casting values (840,19,7);
insert into casting values (1618,19,5);
insert into casting values (79,19,1);
insert into casting values (83,19,1);
insert into casting values (60,19,2);
insert into casting values (99,19,1);
insert into casting values (134,19,1);
insert into casting values (88,19,1);
insert into casting values (319,19,1);
insert into casting values (612,19,1);
insert into casting values (450,19,1);
insert into casting values (559,19,1);
insert into casting values (666,19,1);
insert into casting values (630,19,1);
insert into casting values (637,19,2);
insert into casting values (1034,20,1);
insert into casting values (831,20,1);
insert into casting values (775,20,1);
insert into casting values (1160,20,3);
insert into casting values (1574,20,2);
insert into casting values (125,20,1);
insert into casting values (339,20,1);
insert into casting values (207,20,1);
--- tabcasting, 551, 50
insert into casting values (492,20,9);
insert into casting values (623,20,1);
insert into casting values (654,20,1);
insert into casting values (430,20,1);
insert into casting values (484,20,1);
insert into casting values (544,20,1);
insert into casting values (456,20,1);
insert into casting values (1082,21,6);
insert into casting values (1466,21,3);
insert into casting values (371,21,2);
insert into casting values (918,22,3);
insert into casting values (774,22,1);
insert into casting values (1047,22,1);
insert into casting values (947,22,1);
insert into casting values (1050,22,1);
insert into casting values (970,22,1);
insert into casting values (1419,22,1);
insert into casting values (1196,22,1);
insert into casting values (1753,22,1);
insert into casting values (235,22,3);
insert into casting values (289,22,1);
insert into casting values (191,22,1);
insert into casting values (173,22,1);
insert into casting values (311,22,1);
insert into casting values (835,24,1);
insert into casting values (967,24,1);
insert into casting values (874,24,4);
insert into casting values (978,24,9);
insert into casting values (1109,24,4);
insert into casting values (1689,24,1);
insert into casting values (1616,24,2);
insert into casting values (1627,24,2);
insert into casting values (1600,24,1);
insert into casting values (1802,24,2);
insert into casting values (205,24,2);
insert into casting values (279,24,4);
insert into casting values (28,24,10);
insert into casting values (406,24,2);
insert into casting values (654,24,3);
insert into casting values (576,24,2);
insert into casting values (456,24,3);
insert into casting values (930,25,1);
insert into casting values (1026,25,2);
insert into casting values (954,25,1);
insert into casting values (1131,25,5);
insert into casting values (1621,25,2);
insert into casting values (1740,25,1);
insert into casting values (234,25,8);
insert into casting values (2,25,1);
insert into casting values (305,25,2);
--- tabcasting, 601, 50
insert into casting values (83,25,10);
insert into casting values (304,25,2);
insert into casting values (361,25,1);
insert into casting values (246,25,1);
insert into casting values (575,25,3);
insert into casting values (663,25,3);
insert into casting values (861,26,1);
insert into casting values (1071,26,1);
insert into casting values (869,26,2);
insert into casting values (1272,26,1);
insert into casting values (1288,26,1);
insert into casting values (1539,26,1);
insert into casting values (1581,26,11);
insert into casting values (267,26,1);
insert into casting values (113,26,11);
insert into casting values (110,26,1);
insert into casting values (228,26,1);
insert into casting values (266,26,2);
insert into casting values (220,26,1);
insert into casting values (546,26,6);
insert into casting values (373,26,1);
insert into casting values (573,26,1);
insert into casting values (558,26,1);
insert into casting values (1077,27,1);
insert into casting values (1344,27,1);
insert into casting values (1778,27,2);
insert into casting values (1822,27,1);
insert into casting values (123,27,2);
insert into casting values (336,27,1);
insert into casting values (334,27,1);
insert into casting values (247,27,1);
insert into casting values (60,27,1);
insert into casting values (315,27,1);
insert into casting values (265,27,1);
insert into casting values (253,27,7);
insert into casting values (416,27,1);
insert into casting values (567,27,14);
insert into casting values (400,27,1);
insert into casting values (583,27,2);
insert into casting values (1801,28,6);
insert into casting values (946,29,1);
insert into casting values (1628,29,1);
insert into casting values (1521,29,5);
insert into casting values (1624,29,1);
insert into casting values (263,29,6);
insert into casting values (195,29,6);
insert into casting values (719,29,11);
insert into casting values (506,29,12);
insert into casting values (970,30,3);
insert into casting values (789,30,2);
--- tabcasting, 651, 50
insert into casting values (1075,30,2);
insert into casting values (1017,30,1);
insert into casting values (1810,30,1);
insert into casting values (1607,30,2);
insert into casting values (360,30,1);
insert into casting values (343,30,1);
insert into casting values (248,30,1);
insert into casting values (227,30,1);
insert into casting values (566,30,1);
insert into casting values (698,30,1);
insert into casting values (594,30,1);
insert into casting values (712,30,1);
insert into casting values (674,30,1);
insert into casting values (866,32,1);
insert into casting values (969,32,2);
insert into casting values (1016,32,2);
insert into casting values (767,32,1);
insert into casting values (1377,32,4);
insert into casting values (1131,32,1);
insert into casting values (1264,32,2);
insert into casting values (1132,32,2);
insert into casting values (1479,32,4);
insert into casting values (124,32,6);
insert into casting values (140,32,3);
insert into casting values (131,32,1);
insert into casting values (70,32,1);
insert into casting values (234,32,1);
insert into casting values (481,32,1);
insert into casting values (550,32,15);
insert into casting values (414,32,1);
insert into casting values (599,32,1);
insert into casting values (838,33,1);
insert into casting values (852,33,2);
insert into casting values (1315,33,1);
insert into casting values (1163,33,1);
insert into casting values (1123,33,1);
insert into casting values (1455,33,1);
insert into casting values (1775,33,1);
insert into casting values (1565,33,1);
insert into casting values (359,33,2);
insert into casting values (275,33,1);
insert into casting values (401,33,3);
insert into casting values (419,33,1);
insert into casting values (530,33,1);
insert into casting values (431,33,2);
insert into casting values (545,33,2);
insert into casting values (1548,34,1);
insert into casting values (3,34,1);
insert into casting values (279,34,1);
insert into casting values (273,34,1);
--- tabcasting, 701, 50
insert into casting values (300,34,1);
insert into casting values (141,34,1);
insert into casting values (62,34,1);
insert into casting values (722,34,1);
insert into casting values (634,34,1);
insert into casting values (600,34,1);
insert into casting values (529,34,5);
insert into casting values (462,34,1);
insert into casting values (537,34,1);
insert into casting values (1012,35,1);
insert into casting values (1011,35,1);
insert into casting values (864,35,1);
insert into casting values (1258,35,2);
insert into casting values (1278,35,1);
insert into casting values (1370,35,1);
insert into casting values (1296,35,1);
insert into casting values (1476,35,1);
insert into casting values (1701,35,3);
insert into casting values (304,35,1);
insert into casting values (90,35,1);
insert into casting values (302,35,1);
insert into casting values (578,35,1);
insert into casting values (917,36,1);
insert into casting values (760,36,2);
insert into casting values (779,36,1);
insert into casting values (1239,36,1);
insert into casting values (225,36,2);
insert into casting values (285,36,3);
insert into casting values (161,36,2);
insert into casting values (652,36,1);
insert into casting values (400,36,2);
insert into casting values (730,36,1);
insert into casting values (835,37,7);
insert into casting values (1115,37,7);
insert into casting values (1604,37,6);
insert into casting values (264,37,1);
insert into casting values (603,37,7);
insert into casting values (600,37,13);
insert into casting values (1624,38,12);
insert into casting values (892,39,1);
insert into casting values (934,39,1);
insert into casting values (937,39,1);
insert into casting values (786,39,1);
insert into casting values (846,39,3);
insert into casting values (1323,39,2);
insert into casting values (1313,39,6);
insert into casting values (1753,39,2);
insert into casting values (1479,39,1);
insert into casting values (1497,39,4);
insert into casting values (231,39,3);
--- tabcasting, 751, 50
insert into casting values (363,39,1);
insert into casting values (15,39,1);
insert into casting values (500,39,3);
insert into casting values (386,39,3);
insert into casting values (1100,40,1);
insert into casting values (882,40,6);
insert into casting values (756,40,1);
insert into casting values (929,40,2);
insert into casting values (1334,40,2);
insert into casting values (1706,40,2);
insert into casting values (1675,40,1);
insert into casting values (168,40,2);
insert into casting values (311,40,2);
insert into casting values (169,40,1);
insert into casting values (265,40,3);
insert into casting values (232,40,1);
insert into casting values (250,40,1);
insert into casting values (525,40,2);
insert into casting values (491,40,1);
insert into casting values (588,40,1);
insert into casting values (1260,41,1);
insert into casting values (1216,41,1);
insert into casting values (1300,41,1);
insert into casting values (1645,41,1);
insert into casting values (238,41,12);
insert into casting values (162,41,2);
insert into casting values (270,41,1);
insert into casting values (269,41,2);
insert into casting values (354,41,1);
insert into casting values (452,41,1);
insert into casting values (588,41,2);
insert into casting values (604,41,1);
insert into casting values (632,41,1);
insert into casting values (507,41,1);
insert into casting values (900,42,1);
insert into casting values (989,42,2);
insert into casting values (785,42,1);
insert into casting values (1159,42,2);
insert into casting values (1114,42,1);
insert into casting values (1842,42,1);
insert into casting values (1528,42,1);
insert into casting values (1506,42,1);
insert into casting values (361,42,3);
insert into casting values (225,42,1);
insert into casting values (161,42,1);
insert into casting values (377,42,1);
insert into casting values (637,42,1);
insert into casting values (1039,43,1);
insert into casting values (802,43,1);
insert into casting values (874,43,3);
--- tabcasting, 801, 50
insert into casting values (877,43,9);
insert into casting values (1448,43,9);
insert into casting values (1261,43,1);
insert into casting values (1802,43,1);
insert into casting values (1662,43,5);
insert into casting values (154,43,1);
insert into casting values (28,43,1);
insert into casting values (63,43,1);
insert into casting values (134,43,2);
insert into casting values (86,43,2);
insert into casting values (47,43,1);
insert into casting values (493,43,1);
insert into casting values (1099,44,5);
insert into casting values (1391,44,9);
insert into casting values (1238,44,1);
insert into casting values (1471,44,2);
insert into casting values (1801,44,10);
insert into casting values (1529,44,2);
insert into casting values (1675,44,3);
insert into casting values (1783,44,3);
insert into casting values (1631,44,5);
insert into casting values (12,44,4);
insert into casting values (300,44,4);
insert into casting values (139,44,1);
insert into casting values (322,44,12);
insert into casting values (121,44,12);
insert into casting values (45,44,2);
insert into casting values (143,44,8);
insert into casting values (61,44,2);
insert into casting values (430,44,2);
insert into casting values (634,44,2);
insert into casting values (652,44,2);
insert into casting values (668,44,4);
insert into casting values (630,44,2);
insert into casting values (802,45,2);
insert into casting values (748,45,1);
insert into casting values (1012,45,2);
insert into casting values (1024,45,2);
insert into casting values (970,45,2);
insert into casting values (894,45,1);
insert into casting values (1035,45,2);
insert into casting values (856,45,2);
insert into casting values (1284,45,2);
insert into casting values (1239,45,2);
insert into casting values (1115,45,2);
insert into casting values (1275,45,10);
insert into casting values (1845,45,11);
insert into casting values (1546,45,1);
insert into casting values (1644,45,2);
insert into casting values (281,45,3);
--- tabcasting, 851, 50
insert into casting values (350,45,3);
insert into casting values (205,45,3);
insert into casting values (493,45,4);
insert into casting values (506,45,3);
insert into casting values (429,45,2);
insert into casting values (1067,46,5);
insert into casting values (1048,46,2);
insert into casting values (904,46,1);
insert into casting values (1367,46,4);
insert into casting values (1176,46,12);
insert into casting values (1431,46,3);
insert into casting values (1668,46,1);
insert into casting values (1680,46,4);
insert into casting values (53,46,3);
insert into casting values (253,46,1);
insert into casting values (134,46,4);
insert into casting values (229,46,1);
insert into casting values (533,46,2);
insert into casting values (466,46,5);
insert into casting values (587,46,1);
insert into casting values (571,46,2);
insert into casting values (525,46,3);
insert into casting values (1030,48,2);
insert into casting values (881,48,2);
insert into casting values (1391,48,1);
insert into casting values (1480,48,5);
insert into casting values (310,48,3);
insert into casting values (313,48,5);
insert into casting values (467,48,2);
insert into casting values (520,48,1);
insert into casting values (751,49,1);
insert into casting values (1054,49,2);
insert into casting values (880,49,2);
insert into casting values (1294,49,1);
insert into casting values (1277,49,1);
insert into casting values (1191,49,1);
insert into casting values (1243,49,1);
insert into casting values (1585,49,1);
insert into casting values (1654,49,1);
insert into casting values (213,49,1);
insert into casting values (497,49,2);
insert into casting values (369,49,2);
insert into casting values (825,50,2);
insert into casting values (1161,50,1);
insert into casting values (1180,50,2);
insert into casting values (1479,50,3);
insert into casting values (1817,50,1);
insert into casting values (1481,50,2);
insert into casting values (1778,50,3);
insert into casting values (126,50,1);
--- tabcasting, 901, 50
insert into casting values (162,50,1);
insert into casting values (277,50,1);
insert into casting values (328,50,1);
insert into casting values (338,50,2);
insert into casting values (76,50,1);
insert into casting values (1045,51,8);
insert into casting values (1023,51,2);
insert into casting values (1097,51,1);
insert into casting values (1287,51,2);
insert into casting values (1204,51,2);
insert into casting values (1281,51,1);
insert into casting values (1532,51,1);
insert into casting values (1604,51,3);
insert into casting values (1675,51,2);
insert into casting values (364,51,4);
insert into casting values (333,51,4);
insert into casting values (465,51,1);
insert into casting values (661,51,1);
insert into casting values (394,51,1);
insert into casting values (986,52,1);
insert into casting values (1471,52,1);
insert into casting values (1133,52,1);
insert into casting values (1404,52,3);
insert into casting values (1774,52,1);
insert into casting values (1686,52,1);
insert into casting values (1491,52,1);
insert into casting values (1575,52,2);
insert into casting values (205,52,1);
insert into casting values (86,52,1);
insert into casting values (166,52,6);
insert into casting values (745,53,2);
insert into casting values (973,53,1);
insert into casting values (1184,53,1);
insert into casting values (1129,53,1);
insert into casting values (1666,53,10);
insert into casting values (1657,53,6);
insert into casting values (281,53,5);
insert into casting values (136,53,1);
insert into casting values (238,53,13);
insert into casting values (231,53,4);
insert into casting values (84,53,1);
insert into casting values (421,53,1);
insert into casting values (670,53,8);
insert into casting values (470,53,2);
insert into casting values (692,53,1);
insert into casting values (1196,54,2);
insert into casting values (1224,54,1);
insert into casting values (1295,54,1);
insert into casting values (1541,54,3);
insert into casting values (365,54,10);
--- tabcasting, 951, 50
insert into casting values (24,54,1);
insert into casting values (215,54,2);
insert into casting values (245,54,1);
insert into casting values (108,54,3);
insert into casting values (35,54,2);
insert into casting values (345,54,3);
insert into casting values (152,54,1);
insert into casting values (482,54,2);
insert into casting values (619,54,1);
insert into casting values (408,54,2);
insert into casting values (776,55,7);
insert into casting values (868,55,1);
insert into casting values (1297,55,7);
insert into casting values (1407,55,1);
insert into casting values (1340,55,1);
insert into casting values (1171,55,12);
insert into casting values (1630,55,1);
insert into casting values (1728,55,2);
insert into casting values (1553,55,1);
insert into casting values (337,55,1);
insert into casting values (621,55,1);
insert into casting values (577,55,5);
insert into casting values (669,55,1);
insert into casting values (596,55,1);
insert into casting values (1093,56,1);
insert into casting values (1283,56,1);
insert into casting values (1555,56,1);
insert into casting values (80,56,3);
insert into casting values (293,56,1);
insert into casting values (83,56,3);
insert into casting values (144,56,4);
insert into casting values (248,56,2);
insert into casting values (160,56,1);
insert into casting values (506,56,1);
insert into casting values (633,56,1);
insert into casting values (484,56,2);
insert into casting values (503,56,2);
insert into casting values (954,57,2);
insert into casting values (825,57,1);
insert into casting values (1016,57,1);
insert into casting values (1240,57,7);
insert into casting values (1342,57,2);
insert into casting values (1363,57,3);
insert into casting values (1413,57,1);
insert into casting values (1532,57,2);
insert into casting values (1826,57,5);
insert into casting values (255,57,2);
insert into casting values (224,57,2);
insert into casting values (83,57,14);
insert into casting values (181,57,7);
--- tabcasting, 1001, 50
insert into casting values (104,57,2);
insert into casting values (503,57,9);
insert into casting values (452,57,2);
insert into casting values (658,57,1);
insert into casting values (661,57,3);
insert into casting values (739,58,1);
insert into casting values (1019,58,2);
insert into casting values (899,58,1);
insert into casting values (742,58,4);
insert into casting values (890,58,4);
insert into casting values (1264,58,10);
insert into casting values (1462,58,1);
insert into casting values (1820,58,1);
insert into casting values (1747,58,1);
insert into casting values (1761,58,1);
insert into casting values (113,58,3);
insert into casting values (76,58,9);
insert into casting values (492,58,1);
insert into casting values (532,58,1);
insert into casting values (1237,59,6);
insert into casting values (49,59,4);
insert into casting values (422,59,3);
insert into casting values (1117,60,1);
insert into casting values (1122,60,1);
insert into casting values (1662,60,1);
insert into casting values (567,60,1);
insert into casting values (499,60,9);
insert into casting values (526,60,1);
insert into casting values (901,61,3);
insert into casting values (1035,61,1);
insert into casting values (818,61,1);
insert into casting values (1002,61,2);
insert into casting values (1325,61,2);
insert into casting values (1313,61,10);
insert into casting values (1156,61,2);
insert into casting values (1657,61,1);
insert into casting values (365,61,1);
insert into casting values (100,61,3);
insert into casting values (330,61,1);
insert into casting values (310,61,2);
insert into casting values (658,61,2);
insert into casting values (731,61,5);
insert into casting values (408,61,1);
insert into casting values (760,63,1);
insert into casting values (1176,63,1);
insert into casting values (1410,63,1);
insert into casting values (1325,63,1);
insert into casting values (1450,63,1);
insert into casting values (1607,63,1);
insert into casting values (1738,63,1);
--- tabcasting, 1051, 50
insert into casting values (1604,63,1);
insert into casting values (149,63,5);
insert into casting values (562,63,1);
insert into casting values (651,63,2);
insert into casting values (775,64,2);
insert into casting values (884,64,4);
insert into casting values (961,64,5);
insert into casting values (779,64,2);
insert into casting values (1270,64,2);
insert into casting values (1397,64,1);
insert into casting values (1407,64,4);
insert into casting values (1742,64,3);
insert into casting values (1709,64,5);
insert into casting values (1783,64,1);
insert into casting values (218,64,2);
insert into casting values (134,64,3);
insert into casting values (538,64,1);
insert into casting values (598,64,1);
insert into casting values (1088,70,1);
insert into casting values (773,70,1);
insert into casting values (1394,70,1);
insert into casting values (1279,70,1);
insert into casting values (1827,70,1);
insert into casting values (1576,70,2);
insert into casting values (148,70,1);
insert into casting values (26,70,1);
insert into casting values (339,70,4);
insert into casting values (192,70,1);
insert into casting values (508,70,1);
insert into casting values (831,71,4);
insert into casting values (1419,71,2);
insert into casting values (1106,71,5);
insert into casting values (1391,71,3);
insert into casting values (1209,71,3);
insert into casting values (1156,71,3);
insert into casting values (1201,71,4);
insert into casting values (1313,71,1);
insert into casting values (1793,71,1);
insert into casting values (1690,71,2);
insert into casting values (1840,71,1);
insert into casting values (1826,71,1);
insert into casting values (1684,71,2);
insert into casting values (359,71,10);
insert into casting values (142,71,3);
insert into casting values (531,71,14);
insert into casting values (611,71,7);
insert into casting values (497,71,3);
insert into casting values (735,72,1);
insert into casting values (759,72,9);
insert into casting values (1377,72,9);
--- tabcasting, 1101, 50
insert into casting values (1562,72,1);
insert into casting values (337,72,5);
insert into casting values (315,72,6);
insert into casting values (194,72,2);
insert into casting values (108,72,1);
insert into casting values (78,72,1);
insert into casting values (345,72,1);
insert into casting values (229,72,8);
insert into casting values (228,72,8);
insert into casting values (679,72,1);
insert into casting values (399,72,4);
insert into casting values (593,72,1);
insert into casting values (999,73,8);
insert into casting values (880,73,3);
insert into casting values (1137,73,1);
insert into casting values (1472,73,2);
insert into casting values (1117,73,3);
insert into casting values (1475,73,1);
insert into casting values (65,73,4);
insert into casting values (346,73,3);
insert into casting values (201,73,3);
insert into casting values (3,73,4);
insert into casting values (292,73,2);
insert into casting values (39,73,1);
insert into casting values (114,73,1);
insert into casting values (443,73,4);
insert into casting values (428,73,2);
insert into casting values (534,73,6);
insert into casting values (750,74,1);
insert into casting values (1152,74,1);
insert into casting values (1429,74,1);
insert into casting values (1502,74,1);
insert into casting values (1807,74,1);
insert into casting values (1688,74,1);
insert into casting values (168,74,1);
insert into casting values (459,74,1);
insert into casting values (643,74,2);
insert into casting values (491,74,2);
insert into casting values (857,75,1);
insert into casting values (952,75,1);
insert into casting values (948,75,1);
insert into casting values (1293,75,1);
insert into casting values (1696,75,1);
insert into casting values (94,75,1);
insert into casting values (646,75,1);
insert into casting values (455,75,1);
insert into casting values (667,75,2);
insert into casting values (478,75,1);
insert into casting values (931,76,1);
insert into casting values (1007,76,3);
--- tabcasting, 1151, 50
insert into casting values (1175,76,1);
insert into casting values (1240,76,2);
insert into casting values (1545,76,5);
insert into casting values (1616,76,1);
insert into casting values (1734,76,4);
insert into casting values (6,76,5);
insert into casting values (146,76,2);
insert into casting values (187,76,2);
insert into casting values (334,76,4);
insert into casting values (223,76,4);
insert into casting values (10,76,1);
insert into casting values (543,76,6);
insert into casting values (599,76,2);
insert into casting values (482,76,10);
insert into casting values (939,77,1);
insert into casting values (1138,77,3);
insert into casting values (1110,77,1);
insert into casting values (1627,77,1);
insert into casting values (1604,77,5);
insert into casting values (133,77,1);
insert into casting values (106,77,15);
insert into casting values (352,77,1);
insert into casting values (339,77,10);
insert into casting values (679,77,2);
insert into casting values (371,77,1);
insert into casting values (708,77,3);
insert into casting values (1721,78,11);
insert into casting values (1042,83,5);
insert into casting values (1120,83,2);
insert into casting values (1484,83,1);
insert into casting values (1789,83,1);
insert into casting values (1550,83,1);
insert into casting values (1519,83,2);
insert into casting values (1508,83,2);
insert into casting values (1709,83,1);
insert into casting values (287,83,5);
insert into casting values (640,83,2);
insert into casting values (705,83,3);
insert into casting values (816,84,2);
insert into casting values (992,84,1);
insert into casting values (743,84,1);
insert into casting values (1162,84,1);
insert into casting values (1476,84,4);
insert into casting values (223,84,2);
insert into casting values (242,84,1);
insert into casting values (318,84,1);
insert into casting values (84,84,3);
insert into casting values (506,84,4);
insert into casting values (407,84,1);
insert into casting values (369,84,3);
--- tabcasting, 1201, 50
insert into casting values (869,85,1);
insert into casting values (1420,85,1);
insert into casting values (1180,85,1);
insert into casting values (1801,85,3);
insert into casting values (258,85,1);
insert into casting values (12,85,1);
insert into casting values (45,85,1);
insert into casting values (694,85,2);
insert into casting values (486,85,1);
insert into casting values (871,88,2);
insert into casting values (1048,88,1);
insert into casting values (1370,88,7);
insert into casting values (1445,88,1);
insert into casting values (1335,88,4);
insert into casting values (1701,88,5);
insert into casting values (1665,88,1);
insert into casting values (233,88,4);
insert into casting values (309,88,2);
insert into casting values (273,88,2);
insert into casting values (144,88,1);
insert into casting values (509,88,4);
insert into casting values (393,88,2);
insert into casting values (629,88,11);
insert into casting values (953,89,2);
insert into casting values (1317,89,3);
insert into casting values (1672,89,1);
insert into casting values (1510,89,4);
insert into casting values (278,89,2);
insert into casting values (182,89,3);
insert into casting values (336,89,3);
insert into casting values (187,89,1);
insert into casting values (144,89,9);
insert into casting values (356,89,7);
insert into casting values (223,89,3);
insert into casting values (3,89,2);
insert into casting values (308,89,3);
insert into casting values (527,89,1);
insert into casting values (1460,90,2);
insert into casting values (154,90,9);
insert into casting values (973,91,2);
insert into casting values (871,91,1);
insert into casting values (1095,91,1);
insert into casting values (1310,91,6);
insert into casting values (21,91,1);
insert into casting values (2,91,2);
insert into casting values (334,91,3);
insert into casting values (139,91,5);
insert into casting values (118,91,3);
insert into casting values (162,91,4);
insert into casting values (233,91,2);
--- tabcasting, 1251, 50
insert into casting values (581,91,1);
insert into casting values (500,91,1);
insert into casting values (891,92,6);
insert into casting values (1210,92,4);
insert into casting values (315,92,7);
insert into casting values (246,92,11);
insert into casting values (88,92,5);
insert into casting values (634,92,15);
insert into casting values (1240,93,1);
insert into casting values (1169,93,7);
insert into casting values (1394,93,2);
insert into casting values (1529,93,1);
insert into casting values (1629,93,9);
insert into casting values (1618,93,4);
insert into casting values (1742,93,2);
insert into casting values (179,93,2);
insert into casting values (125,93,2);
insert into casting values (124,93,1);
insert into casting values (620,93,1);
insert into casting values (514,93,1);
insert into casting values (547,93,2);
insert into casting values (741,94,3);
insert into casting values (921,94,2);
insert into casting values (1352,94,2);
insert into casting values (1403,94,1);
insert into casting values (1413,94,2);
insert into casting values (1828,94,1);
insert into casting values (1662,94,2);
insert into casting values (1559,94,2);
insert into casting values (61,94,3);
insert into casting values (12,94,3);
insert into casting values (208,94,2);
insert into casting values (609,94,2);
insert into casting values (437,94,2);
insert into casting values (908,95,1);
insert into casting values (959,95,1);
insert into casting values (1366,95,1);
insert into casting values (1383,95,1);
insert into casting values (1244,95,8);
insert into casting values (1371,95,1);
insert into casting values (1408,95,1);
insert into casting values (1826,95,7);
insert into casting values (190,95,1);
insert into casting values (236,95,7);
insert into casting values (169,95,2);
insert into casting values (386,95,15);
insert into casting values (877,96,1);
insert into casting values (963,96,1);
insert into casting values (923,96,1);
insert into casting values (1450,96,3);
--- tabcasting, 1301, 50
insert into casting values (1308,96,1);
insert into casting values (1353,96,6);
insert into casting values (1274,96,1);
insert into casting values (1685,96,1);
insert into casting values (1657,96,5);
insert into casting values (164,96,6);
insert into casting values (731,96,4);
insert into casting values (443,96,6);
insert into casting values (496,97,8);
insert into casting values (1048,98,3);
insert into casting values (1141,98,1);
insert into casting values (1701,98,2);
insert into casting values (1783,98,2);
insert into casting values (1495,98,1);
insert into casting values (1606,98,1);
insert into casting values (1516,98,7);
insert into casting values (117,98,2);
insert into casting values (231,98,1);
insert into casting values (30,98,2);
insert into casting values (144,98,5);
insert into casting values (708,98,1);
insert into casting values (737,99,3);
insert into casting values (1004,99,1);
insert into casting values (942,99,10);
insert into casting values (988,99,2);
insert into casting values (1272,99,4);
insert into casting values (1136,99,14);
insert into casting values (1221,99,1);
insert into casting values (1161,99,2);
insert into casting values (1516,99,8);
insert into casting values (1513,99,3);
insert into casting values (1725,99,1);
insert into casting values (1843,99,10);
insert into casting values (144,99,7);
insert into casting values (3,99,11);
insert into casting values (208,99,9);
insert into casting values (254,99,13);
insert into casting values (149,99,4);
insert into casting values (205,99,4);
insert into casting values (110,99,10);
insert into casting values (656,99,10);
insert into casting values (723,99,2);
insert into casting values (794,100,8);
insert into casting values (855,100,1);
insert into casting values (929,100,4);
insert into casting values (1058,100,1);
insert into casting values (761,100,1);
insert into casting values (749,100,2);
insert into casting values (1362,100,3);
insert into casting values (1753,100,8);
--- tabcasting, 1351, 50
insert into casting values (7,100,1);
insert into casting values (276,100,11);
insert into casting values (17,100,1);
insert into casting values (353,100,1);
insert into casting values (1138,101,1);
insert into casting values (1206,101,1);
insert into casting values (1324,101,2);
insert into casting values (1376,101,1);
insert into casting values (1123,101,2);
insert into casting values (1706,101,1);
insert into casting values (1557,101,1);
insert into casting values (312,101,2);
insert into casting values (124,101,12);
insert into casting values (620,101,2);
insert into casting values (545,101,1);
insert into casting values (963,102,7);
insert into casting values (967,102,6);
insert into casting values (809,102,2);
insert into casting values (780,102,7);
insert into casting values (830,102,1);
insert into casting values (1204,102,11);
insert into casting values (1152,102,3);
insert into casting values (1437,102,3);
insert into casting values (1844,102,1);
insert into casting values (1808,102,1);
insert into casting values (242,102,2);
insert into casting values (195,102,1);
insert into casting values (181,102,8);
insert into casting values (19,102,2);
insert into casting values (653,102,2);
insert into casting values (1047,104,2);
insert into casting values (1006,104,3);
insert into casting values (811,104,3);
insert into casting values (1410,104,2);
insert into casting values (1471,104,3);
insert into casting values (1257,104,1);
insert into casting values (117,104,3);
insert into casting values (281,104,1);
insert into casting values (731,104,2);
insert into casting values (652,104,3);
insert into casting values (623,104,2);
insert into casting values (463,104,2);
insert into casting values (1081,106,1);
insert into casting values (886,106,1);
insert into casting values (1409,106,2);
insert into casting values (1208,106,4);
insert into casting values (1160,106,2);
insert into casting values (1676,106,1);
insert into casting values (1799,106,1);
insert into casting values (237,106,3);
--- tabcasting, 1401, 50
insert into casting values (543,106,2);
insert into casting values (531,106,3);
insert into casting values (707,106,1);
insert into casting values (854,108,21);
insert into casting values (735,108,2);
insert into casting values (1828,108,3);
insert into casting values (108,108,4);
insert into casting values (345,108,4);
insert into casting values (756,112,2);
insert into casting values (1331,112,1);
insert into casting values (1377,112,11);
insert into casting values (1788,112,2);
insert into casting values (1608,112,3);
insert into casting values (1528,112,2);
insert into casting values (201,112,1);
insert into casting values (179,112,1);
insert into casting values (193,112,2);
insert into casting values (493,112,3);
insert into casting values (618,112,1);
insert into casting values (575,112,2);
insert into casting values (1027,113,4);
insert into casting values (897,113,3);
insert into casting values (934,113,12);
insert into casting values (978,113,1);
insert into casting values (1178,113,1);
insert into casting values (1109,113,5);
insert into casting values (1827,113,2);
insert into casting values (1477,113,4);
insert into casting values (1798,113,2);
insert into casting values (364,113,5);
insert into casting values (155,113,4);
insert into casting values (342,113,2);
insert into casting values (610,113,1);
insert into casting values (462,113,8);
insert into casting values (937,114,2);
insert into casting values (1354,114,1);
insert into casting values (1505,114,8);
insert into casting values (1754,114,5);
insert into casting values (1668,114,3);
insert into casting values (1798,114,1);
insert into casting values (1477,114,1);
insert into casting values (96,114,2);
insert into casting values (166,114,1);
insert into casting values (543,114,3);
insert into casting values (482,114,4);
insert into casting values (971,115,2);
insert into casting values (1298,115,1);
insert into casting values (1173,115,1);
insert into casting values (1343,115,8);
insert into casting values (1589,115,1);
--- tabcasting, 1451, 50
insert into casting values (1692,115,1);
insert into casting values (1609,115,1);
insert into casting values (41,115,1);
insert into casting values (474,115,1);
insert into casting values (790,116,2);
insert into casting values (856,116,3);
insert into casting values (1030,116,10);
insert into casting values (1410,116,4);
insert into casting values (1421,116,1);
insert into casting values (1149,116,2);
insert into casting values (166,116,12);
insert into casting values (152,116,2);
insert into casting values (231,116,2);
insert into casting values (309,116,1);
insert into casting values (220,116,2);
insert into casting values (597,116,1);
insert into casting values (523,116,1);
insert into casting values (1069,117,10);
insert into casting values (981,117,1);
insert into casting values (1641,117,13);
insert into casting values (1591,117,1);
insert into casting values (1739,117,1);
insert into casting values (321,117,2);
insert into casting values (605,117,1);
insert into casting values (799,118,1);
insert into casting values (829,118,1);
insert into casting values (1466,118,4);
insert into casting values (1379,118,1);
insert into casting values (87,118,1);
insert into casting values (97,118,1);
insert into casting values (478,118,3);
insert into casting values (453,118,2);
insert into casting values (953,119,1);
insert into casting values (769,119,2);
insert into casting values (1278,119,2);
insert into casting values (142,119,4);
insert into casting values (38,119,2);
insert into casting values (160,119,2);
insert into casting values (572,119,1);
insert into casting values (405,119,1);
insert into casting values (497,119,1);
insert into casting values (618,119,2);
insert into casting values (949,120,1);
insert into casting values (1022,120,1);
insert into casting values (792,120,2);
insert into casting values (1148,120,1);
insert into casting values (1367,120,1);
insert into casting values (1744,120,6);
insert into casting values (1684,120,7);
insert into casting values (1605,120,6);
--- tabcasting, 1501, 50
insert into casting values (1647,120,2);
insert into casting values (563,120,2);
insert into casting values (675,120,1);
insert into casting values (542,120,6);
insert into casting values (1079,121,1);
insert into casting values (1515,121,4);
insert into casting values (1538,121,1);
insert into casting values (1521,121,1);
insert into casting values (147,121,4);
insert into casting values (517,121,1);
insert into casting values (367,121,1);
insert into casting values (650,121,1);
insert into casting values (671,121,3);
insert into casting values (737,122,1);
insert into casting values (875,122,1);
insert into casting values (1187,122,1);
insert into casting values (1393,122,2);
insert into casting values (1442,122,1);
insert into casting values (1449,122,1);
insert into casting values (1474,122,2);
insert into casting values (115,122,1);
insert into casting values (417,122,2);
insert into casting values (804,123,15);
insert into casting values (776,123,14);
insert into casting values (1008,123,4);
insert into casting values (1484,123,5);
insert into casting values (1823,123,7);
insert into casting values (17,123,13);
insert into casting values (5,123,9);
insert into casting values (13,123,9);
insert into casting values (702,123,13);
insert into casting values (719,123,2);
insert into casting values (809,124,3);
insert into casting values (1451,124,3);
insert into casting values (1274,124,10);
insert into casting values (1636,124,1);
insert into casting values (1660,124,2);
insert into casting values (1748,124,2);
insert into casting values (66,124,5);
insert into casting values (44,124,11);
insert into casting values (160,124,8);
insert into casting values (185,124,2);
insert into casting values (358,124,1);
insert into casting values (399,124,2);
insert into casting values (701,124,2);
insert into casting values (585,124,1);
insert into casting values (781,125,3);
insert into casting values (1065,125,8);
insert into casting values (1285,125,4);
insert into casting values (1439,125,3);
--- tabcasting, 1551, 50
insert into casting values (1395,125,8);
insert into casting values (1516,125,6);
insert into casting values (1801,125,14);
insert into casting values (1631,125,6);
insert into casting values (284,125,3);
insert into casting values (84,125,2);
insert into casting values (144,125,3);
insert into casting values (45,125,8);
insert into casting values (377,125,15);
insert into casting values (603,125,9);
insert into casting values (409,125,9);
insert into casting values (561,125,2);
insert into casting values (1102,126,3);
insert into casting values (846,126,1);
insert into casting values (1055,126,12);
insert into casting values (844,126,7);
insert into casting values (1362,126,15);
insert into casting values (240,126,1);
insert into casting values (160,126,3);
insert into casting values (25,126,1);
insert into casting values (338,126,1);
insert into casting values (184,126,1);
insert into casting values (415,126,1);
insert into casting values (1044,127,10);
insert into casting values (942,127,6);
insert into casting values (902,127,8);
insert into casting values (767,127,2);
insert into casting values (1423,127,3);
insert into casting values (1363,127,4);
insert into casting values (1122,127,4);
insert into casting values (1297,127,2);
insert into casting values (1184,127,6);
insert into casting values (1771,127,13);
insert into casting values (1810,127,2);
insert into casting values (1506,127,3);
insert into casting values (1601,127,2);
insert into casting values (1765,127,2);
insert into casting values (242,127,5);
insert into casting values (159,127,5);
insert into casting values (400,127,3);
insert into casting values (474,127,4);
insert into casting values (765,128,7);
insert into casting values (209,128,1);
insert into casting values (280,128,11);
insert into casting values (349,128,1);
insert into casting values (438,128,1);
insert into casting values (402,128,1);
insert into casting values (410,128,1);
insert into casting values (472,128,1);
insert into casting values (1156,129,8);
--- tabcasting, 1601, 50
insert into casting values (585,129,11);
insert into casting values (1473,130,4);
insert into casting values (1597,130,3);
insert into casting values (1747,130,6);
insert into casting values (1839,130,9);
insert into casting values (1547,130,1);
insert into casting values (91,130,4);
insert into casting values (4,130,7);
insert into casting values (53,130,2);
insert into casting values (248,130,4);
insert into casting values (346,130,2);
insert into casting values (85,130,2);
insert into casting values (46,130,13);
insert into casting values (217,130,1);
insert into casting values (24,130,6);
insert into casting values (611,130,4);
insert into casting values (691,130,6);
insert into casting values (840,131,6);
insert into casting values (742,131,1);
insert into casting values (824,131,2);
insert into casting values (884,131,1);
insert into casting values (1335,131,1);
insert into casting values (1110,131,2);
insert into casting values (1497,131,1);
insert into casting values (1514,131,1);
insert into casting values (119,131,1);
insert into casting values (886,132,2);
insert into casting values (857,132,3);
insert into casting values (1081,132,2);
insert into casting values (954,132,3);
insert into casting values (1409,132,1);
insert into casting values (1345,132,2);
insert into casting values (1413,132,4);
insert into casting values (1598,132,1);
insert into casting values (1698,132,1);
insert into casting values (1795,132,1);
insert into casting values (1380,133,8);
insert into casting values (1016,134,4);
insert into casting values (942,134,2);
insert into casting values (782,134,5);
insert into casting values (1133,134,10);
insert into casting values (1686,134,2);
insert into casting values (1831,134,4);
insert into casting values (1598,134,4);
insert into casting values (1572,134,2);
insert into casting values (177,134,2);
insert into casting values (192,134,2);
insert into casting values (148,134,2);
insert into casting values (26,134,2);
insert into casting values (438,134,11);
--- tabcasting, 1651, 50
insert into casting values (487,134,4);
insert into casting values (388,134,3);
insert into casting values (714,134,3);
insert into casting values (769,135,3);
insert into casting values (775,135,3);
insert into casting values (1085,135,3);
insert into casting values (837,135,1);
insert into casting values (896,135,12);
insert into casting values (822,135,2);
insert into casting values (1128,135,3);
insert into casting values (1803,135,2);
insert into casting values (223,135,8);
insert into casting values (343,135,4);
insert into casting values (334,135,6);
insert into casting values (632,135,3);
insert into casting values (763,136,1);
insert into casting values (949,136,6);
insert into casting values (784,136,1);
insert into casting values (897,136,2);
insert into casting values (1256,136,1);
insert into casting values (1540,136,1);
insert into casting values (1637,136,6);
insert into casting values (336,136,2);
insert into casting values (130,136,3);
insert into casting values (207,136,2);
insert into casting values (254,136,12);
insert into casting values (155,136,2);
insert into casting values (1033,137,1);
insert into casting values (919,137,1);
insert into casting values (1199,137,1);
insert into casting values (1254,137,1);
insert into casting values (1314,137,10);
insert into casting values (1681,137,1);
insert into casting values (1787,137,1);
insert into casting values (1694,137,1);
insert into casting values (748,138,2);
insert into casting values (111,138,11);
insert into casting values (188,138,1);
insert into casting values (107,138,2);
insert into casting values (112,138,1);
insert into casting values (180,138,1);
insert into casting values (114,138,2);
insert into casting values (124,138,5);
insert into casting values (706,138,1);
insert into casting values (627,138,1);
insert into casting values (807,139,14);
insert into casting values (947,142,2);
insert into casting values (901,142,2);
insert into casting values (1085,142,1);
insert into casting values (1135,142,1);
--- tabcasting, 1701, 50
insert into casting values (1167,142,2);
insert into casting values (1527,142,2);
insert into casting values (1600,142,4);
insert into casting values (226,142,2);
insert into casting values (91,142,2);
insert into casting values (100,142,2);
insert into casting values (696,142,1);
insert into casting values (922,145,1);
insert into casting values (589,145,1);
insert into casting values (715,145,1);
insert into casting values (740,147,3);
insert into casting values (772,147,2);
insert into casting values (1839,147,3);
insert into casting values (1494,147,2);
insert into casting values (1763,147,1);
insert into casting values (108,147,5);
insert into casting values (195,147,3);
insert into casting values (345,147,5);
insert into casting values (670,147,5);
insert into casting values (608,147,1);
insert into casting values (956,151,1);
insert into casting values (1155,151,1);
insert into casting values (1819,151,3);
insert into casting values (1534,151,4);
insert into casting values (151,151,1);
insert into casting values (48,151,3);
insert into casting values (645,151,1);
insert into casting values (597,151,2);
insert into casting values (693,151,1);
insert into casting values (908,152,4);
insert into casting values (877,152,6);
insert into casting values (902,152,3);
insert into casting values (1077,152,4);
insert into casting values (1319,152,4);
insert into casting values (1377,152,3);
insert into casting values (1494,152,4);
insert into casting values (116,152,3);
insert into casting values (234,152,7);
insert into casting values (131,152,5);
insert into casting values (304,152,3);
insert into casting values (330,152,2);
insert into casting values (482,152,5);
insert into casting values (491,152,3);
insert into casting values (714,152,4);
insert into casting values (990,154,2);
insert into casting values (874,154,5);
insert into casting values (915,154,4);
insert into casting values (898,154,3);
insert into casting values (1385,154,1);
insert into casting values (1257,154,2);
--- tabcasting, 1751, 50
insert into casting values (1304,154,1);
insert into casting values (138,154,2);
insert into casting values (184,154,2);
insert into casting values (84,154,5);
insert into casting values (622,154,1);
insert into casting values (1110,157,6);
insert into casting values (1116,157,14);
insert into casting values (1254,157,5);
insert into casting values (1278,157,5);
insert into casting values (113,157,4);
insert into casting values (297,157,2);
insert into casting values (300,157,3);
insert into casting values (443,157,12);
insert into casting values (528,157,4);
insert into casting values (537,157,3);
insert into casting values (677,157,1);
insert into casting values (425,157,1);
insert into casting values (514,157,12);
insert into casting values (835,158,2);
insert into casting values (1374,158,1);
insert into casting values (1509,158,1);
insert into casting values (1642,158,2);
insert into casting values (196,158,2);
insert into casting values (104,158,1);
insert into casting values (313,158,10);
insert into casting values (36,158,13);
insert into casting values (511,158,1);
insert into casting values (642,158,7);
insert into casting values (940,159,11);
insert into casting values (1057,159,1);
insert into casting values (816,159,1);
insert into casting values (1361,159,5);
insert into casting values (1153,159,1);
insert into casting values (1449,159,7);
insert into casting values (98,159,1);
insert into casting values (58,159,3);
insert into casting values (95,159,1);
insert into casting values (29,159,3);
insert into casting values (887,160,3);
insert into casting values (917,160,4);
insert into casting values (772,160,3);
insert into casting values (777,160,4);
insert into casting values (771,160,3);
insert into casting values (1468,160,9);
insert into casting values (1155,160,6);
insert into casting values (1299,160,13);
insert into casting values (1705,160,4);
insert into casting values (1693,160,1);
insert into casting values (135,160,2);
insert into casting values (403,160,3);
--- tabcasting, 1801, 50
insert into casting values (368,160,4);
insert into casting values (705,160,8);
insert into casting values (1412,161,11);
insert into casting values (1422,161,1);
insert into casting values (1659,161,1);
insert into casting values (174,161,3);
insert into casting values (79,161,2);
insert into casting values (80,161,4);
insert into casting values (416,161,2);
insert into casting values (720,161,3);
insert into casting values (614,161,3);
insert into casting values (576,161,3);
insert into casting values (620,161,8);
insert into casting values (396,161,1);
insert into casting values (1416,162,1);
insert into casting values (1206,162,4);
insert into casting values (1516,162,9);
insert into casting values (1661,162,2);
insert into casting values (1839,162,5);
insert into casting values (1717,162,12);
insert into casting values (344,162,2);
insert into casting values (81,162,3);
insert into casting values (113,162,2);
insert into casting values (389,162,2);
insert into casting values (407,162,3);
insert into casting values (433,162,5);
insert into casting values (568,162,3);
insert into casting values (648,162,2);
insert into casting values (1011,163,5);
insert into casting values (858,163,11);
insert into casting values (1260,163,14);
insert into casting values (1377,163,13);
insert into casting values (1475,163,2);
insert into casting values (1774,163,5);
insert into casting values (1661,163,5);
insert into casting values (327,163,1);
insert into casting values (90,163,15);
insert into casting values (524,163,5);
insert into casting values (392,163,3);
insert into casting values (586,163,8);
insert into casting values (637,163,5);
insert into casting values (569,163,1);
insert into casting values (706,163,2);
insert into casting values (705,163,15);
insert into casting values (911,164,1);
insert into casting values (1267,164,2);
insert into casting values (1312,164,1);
insert into casting values (1744,164,1);
insert into casting values (1751,164,1);
insert into casting values (312,164,7);
--- tabcasting, 1851, 50
insert into casting values (121,164,1);
insert into casting values (690,164,1);
insert into casting values (1396,165,14);
insert into casting values (1108,165,4);
insert into casting values (1189,165,1);
insert into casting values (1710,165,1);
insert into casting values (364,165,11);
insert into casting values (91,165,9);
insert into casting values (248,165,7);
insert into casting values (211,165,1);
insert into casting values (362,165,1);
insert into casting values (522,165,2);
insert into casting values (519,165,1);
insert into casting values (1289,166,1);
insert into casting values (1451,166,1);
insert into casting values (1156,166,6);
insert into casting values (1798,166,4);
insert into casting values (1546,166,3);
insert into casting values (1486,166,10);
insert into casting values (246,166,4);
insert into casting values (454,166,2);
insert into casting values (523,166,9);
insert into casting values (534,166,1);
insert into casting values (801,167,7);
insert into casting values (1135,167,2);
insert into casting values (1238,167,2);
insert into casting values (1716,167,4);
insert into casting values (1704,167,1);
insert into casting values (1812,167,14);
insert into casting values (1731,167,1);
insert into casting values (1766,167,1);
insert into casting values (226,167,1);
insert into casting values (271,167,6);
insert into casting values (594,167,4);
insert into casting values (856,168,1);
insert into casting values (910,168,1);
insert into casting values (803,168,1);
insert into casting values (1149,168,1);
insert into casting values (1682,168,1);
insert into casting values (1753,168,5);
insert into casting values (1816,168,3);
insert into casting values (355,168,5);
insert into casting values (556,168,11);
insert into casting values (1014,169,1);
insert into casting values (743,169,2);
insert into casting values (1814,169,1);
insert into casting values (1822,169,2);
insert into casting values (88,169,2);
insert into casting values (160,169,4);
insert into casting values (688,169,1);
--- tabcasting, 1901, 50
insert into casting values (627,169,2);
insert into casting values (630,169,3);
insert into casting values (666,169,2);
insert into casting values (920,170,1);
insert into casting values (734,170,1);
insert into casting values (1103,170,2);
insert into casting values (1466,170,1);
insert into casting values (1631,170,1);
insert into casting values (1741,170,1);
insert into casting values (644,170,1);
insert into casting values (998,171,1);
insert into casting values (1637,171,1);
insert into casting values (1519,171,1);
insert into casting values (1785,171,1);
insert into casting values (674,171,2);
insert into casting values (590,171,1);
insert into casting values (1102,172,1);
insert into casting values (941,172,1);
insert into casting values (1077,172,2);
insert into casting values (963,172,3);
insert into casting values (1351,172,1);
insert into casting values (1562,172,4);
insert into casting values (315,172,9);
insert into casting values (166,172,2);
insert into casting values (201,172,2);
insert into casting values (596,172,9);
insert into casting values (496,172,2);
insert into casting values (1039,173,2);
insert into casting values (844,173,1);
insert into casting values (963,173,2);
insert into casting values (978,173,2);
insert into casting values (1041,173,1);
insert into casting values (923,173,2);
insert into casting values (1572,173,1);
insert into casting values (456,173,2);
insert into casting values (654,173,2);
insert into casting values (934,174,4);
insert into casting values (756,174,3);
insert into casting values (1515,174,8);
insert into casting values (1777,174,2);
insert into casting values (1693,174,2);
insert into casting values (53,174,5);
insert into casting values (51,174,3);
insert into casting values (333,174,3);
insert into casting values (319,174,7);
insert into casting values (128,174,1);
insert into casting values (657,174,3);
insert into casting values (543,174,5);
insert into casting values (1576,175,5);
insert into casting values (973,176,4);
--- tabcasting, 1951, 50
insert into casting values (1282,176,5);
insert into casting values (1359,176,6);
insert into casting values (1780,176,1);
insert into casting values (1607,176,6);
insert into casting values (1545,176,1);
insert into casting values (1555,176,4);
insert into casting values (246,176,3);
insert into casting values (333,176,5);
insert into casting values (628,176,8);
insert into casting values (531,176,8);
insert into casting values (587,176,2);
insert into casting values (650,176,5);
insert into casting values (1092,177,1);
insert into casting values (1673,177,1);
insert into casting values (296,177,1);
insert into casting values (81,177,1);
insert into casting values (327,177,3);
insert into casting values (7,177,3);
insert into casting values (506,177,2);
insert into casting values (380,177,1);
insert into casting values (1015,178,5);
insert into casting values (1252,178,1);
insert into casting values (1707,178,1);
insert into casting values (1644,178,3);
insert into casting values (665,178,3);
insert into casting values (636,178,1);
insert into casting values (740,179,1);
insert into casting values (1037,179,3);
insert into casting values (936,179,12);
insert into casting values (939,179,4);
insert into casting values (845,179,15);
insert into casting values (1281,179,4);
insert into casting values (1486,179,9);
insert into casting values (90,179,2);
insert into casting values (157,179,4);
insert into casting values (706,179,5);
insert into casting values (569,179,2);
insert into casting values (632,179,2);
insert into casting values (622,179,3);
insert into casting values (395,179,3);
insert into casting values (862,180,5);
insert into casting values (885,180,15);
insert into casting values (854,180,5);
insert into casting values (906,180,1);
insert into casting values (735,180,6);
insert into casting values (1322,180,2);
insert into casting values (1464,180,2);
insert into casting values (1407,180,3);
insert into casting values (1718,180,1);
insert into casting values (195,180,4);
--- tabcasting, 2001, 50
insert into casting values (466,180,2);
insert into casting values (513,180,4);
insert into casting values (669,180,13);
insert into casting values (809,181,1);
insert into casting values (1449,181,2);
insert into casting values (95,181,13);
insert into casting values (98,181,2);
insert into casting values (29,181,2);
insert into casting values (176,181,1);
insert into casting values (8,181,9);
insert into casting values (576,181,1);
insert into casting values (524,181,1);
insert into casting values (452,181,5);
insert into casting values (989,182,4);
insert into casting values (917,182,2);
insert into casting values (869,182,3);
insert into casting values (1396,182,13);
insert into casting values (1288,182,3);
insert into casting values (1639,182,1);
insert into casting values (1611,182,3);
insert into casting values (1764,182,2);
insert into casting values (301,182,9);
insert into casting values (154,182,2);
insert into casting values (526,182,2);
insert into casting values (668,182,1);
insert into casting values (989,183,3);
insert into casting values (982,183,1);
insert into casting values (1173,183,9);
insert into casting values (1713,183,1);
insert into casting values (189,183,1);
insert into casting values (483,183,1);
insert into casting values (442,183,1);
insert into casting values (668,183,2);
insert into casting values (780,184,1);
insert into casting values (773,184,8);
insert into casting values (999,184,1);
insert into casting values (1132,184,3);
insert into casting values (1223,184,1);
insert into casting values (1479,184,2);
insert into casting values (217,184,3);
insert into casting values (158,184,8);
insert into casting values (437,184,8);
insert into casting values (1030,185,4);
insert into casting values (928,185,1);
insert into casting values (763,185,4);
insert into casting values (1268,185,3);
insert into casting values (1748,185,9);
insert into casting values (129,185,1);
insert into casting values (4,185,1);
insert into casting values (267,185,2);
--- tabcasting, 2051, 50
insert into casting values (469,185,1);
insert into casting values (880,186,11);
insert into casting values (942,186,7);
insert into casting values (1162,186,6);
insert into casting values (1250,186,3);
insert into casting values (1187,186,2);
insert into casting values (1822,186,6);
insert into casting values (58,186,6);
insert into casting values (294,186,5);
insert into casting values (90,186,4);
insert into casting values (140,186,7);
insert into casting values (22,186,2);
insert into casting values (39,186,5);
insert into casting values (569,186,8);
insert into casting values (392,186,11);
insert into casting values (698,186,3);
insert into casting values (413,186,14);
insert into casting values (961,187,1);
insert into casting values (832,187,2);
insert into casting values (1183,187,2);
insert into casting values (1153,187,15);
insert into casting values (1827,187,12);
insert into casting values (365,187,7);
insert into casting values (110,187,2);
insert into casting values (489,187,1);
insert into casting values (714,187,5);
insert into casting values (388,187,5);
insert into casting values (373,187,6);
insert into casting values (653,187,1);
insert into casting values (1219,188,11);
insert into casting values (1187,188,3);
insert into casting values (1567,188,2);
insert into casting values (185,188,1);
insert into casting values (316,188,1);
insert into casting values (291,188,1);
insert into casting values (413,188,1);
insert into casting values (615,188,1);
insert into casting values (147,189,10);
insert into casting values (1102,190,2);
insert into casting values (977,190,4);
insert into casting values (908,190,5);
insert into casting values (782,190,4);
insert into casting values (1259,190,14);
insert into casting values (1455,190,2);
insert into casting values (19,190,3);
insert into casting values (496,190,1);
insert into casting values (731,190,3);
insert into casting values (506,190,5);
insert into casting values (1073,191,2);
insert into casting values (990,191,1);
--- tabcasting, 2101, 50
insert into casting values (1210,191,3);
insert into casting values (1639,191,4);
insert into casting values (1812,191,10);
insert into casting values (1648,191,2);
insert into casting values (1770,191,2);
insert into casting values (1771,191,5);
insert into casting values (1544,191,4);
insert into casting values (704,191,1);
insert into casting values (705,191,4);
insert into casting values (926,192,2);
insert into casting values (1014,192,2);
insert into casting values (1353,192,10);
insert into casting values (1371,192,3);
insert into casting values (1108,192,1);
insert into casting values (1826,192,2);
insert into casting values (292,192,3);
insert into casting values (256,192,2);
insert into casting values (96,192,4);
insert into casting values (730,192,3);
insert into casting values (732,193,28);
insert into casting values (349,193,2);
insert into casting values (209,193,2);
insert into casting values (472,193,2);
insert into casting values (438,193,12);
insert into casting values (410,193,2);
insert into casting values (402,193,2);
insert into casting values (746,194,3);
insert into casting values (903,194,3);
insert into casting values (908,194,2);
insert into casting values (916,194,5);
insert into casting values (1092,194,3);
insert into casting values (861,194,4);
insert into casting values (1006,194,2);
insert into casting values (1001,194,4);
insert into casting values (1717,194,15);
insert into casting values (38,194,4);
insert into casting values (90,194,3);
insert into casting values (127,194,3);
insert into casting values (531,194,5);
insert into casting values (881,195,8);
insert into casting values (875,195,10);
insert into casting values (818,195,9);
insert into casting values (901,195,1);
insert into casting values (1237,195,2);
insert into casting values (1740,195,6);
insert into casting values (1577,195,4);
insert into casting values (49,195,2);
insert into casting values (100,195,1);
insert into casting values (156,195,8);
insert into casting values (501,195,1);
--- tabcasting, 2151, 50
insert into casting values (422,195,2);
insert into casting values (899,202,4);
insert into casting values (779,202,5);
insert into casting values (838,202,3);
insert into casting values (861,202,5);
insert into casting values (1055,202,4);
insert into casting values (926,202,4);
insert into casting values (1225,202,4);
insert into casting values (1359,202,3);
insert into casting values (1551,202,7);
insert into casting values (223,202,5);
insert into casting values (482,202,8);
insert into casting values (525,202,5);
insert into casting values (674,202,5);
insert into casting values (1030,203,5);
insert into casting values (961,203,8);
insert into casting values (1266,203,2);
insert into casting values (1114,203,4);
insert into casting values (1376,203,2);
insert into casting values (1404,203,1);
insert into casting values (1385,203,2);
insert into casting values (1310,203,3);
insert into casting values (1777,203,1);
insert into casting values (1843,203,6);
insert into casting values (482,203,3);
insert into casting values (1792,205,1);
insert into casting values (1320,206,7);
insert into casting values (586,206,6);
insert into casting values (1324,207,1);
insert into casting values (1258,207,1);
insert into casting values (1669,207,1);
insert into casting values (1759,211,2);
insert into casting values (1733,211,2);
insert into casting values (1510,211,3);
insert into casting values (21,211,5);
insert into casting values (348,211,1);
insert into casting values (52,211,4);
insert into casting values (176,211,2);
insert into casting values (685,211,1);
insert into casting values (544,211,2);
insert into casting values (645,211,2);
insert into casting values (1076,213,1);
insert into casting values (1246,213,1);
insert into casting values (299,213,1);
insert into casting values (27,213,1);
insert into casting values (584,213,1);
insert into casting values (565,213,1);
insert into casting values (942,214,1);
insert into casting values (1034,214,2);
insert into casting values (1077,214,3);
--- tabcasting, 2201, 50
insert into casting values (1342,214,1);
insert into casting values (1491,214,2);
insert into casting values (122,214,4);
insert into casting values (437,214,4);
insert into casting values (520,214,2);
insert into casting values (1005,215,2);
insert into casting values (749,215,1);
insert into casting values (912,215,1);
insert into casting values (1152,215,2);
insert into casting values (1737,215,2);
insert into casting values (65,215,2);
insert into casting values (15,215,2);
insert into casting values (55,215,3);
insert into casting values (899,216,3);
insert into casting values (1006,216,5);
insert into casting values (1449,216,3);
insert into casting values (1456,216,1);
insert into casting values (1520,216,1);
insert into casting values (1611,216,1);
insert into casting values (160,216,5);
insert into casting values (268,216,2);
insert into casting values (107,216,3);
insert into casting values (934,217,11);
insert into casting values (1065,217,6);
insert into casting values (970,217,5);
insert into casting values (1147,217,5);
insert into casting values (1802,217,4);
insert into casting values (1693,217,5);
insert into casting values (1627,217,9);
insert into casting values (1644,217,7);
insert into casting values (138,217,5);
insert into casting values (343,217,9);
insert into casting values (143,217,3);
insert into casting values (187,217,6);
insert into casting values (297,217,7);
insert into casting values (134,217,8);
insert into casting values (712,217,2);
insert into casting values (705,217,14);
insert into casting values (618,217,5);
insert into casting values (674,217,14);
insert into casting values (773,218,4);
insert into casting values (751,218,2);
insert into casting values (779,218,3);
insert into casting values (1243,218,2);
insert into casting values (1590,218,1);
insert into casting values (124,218,7);
insert into casting values (247,218,11);
insert into casting values (351,218,1);
insert into casting values (142,218,1);
insert into casting values (603,218,4);
--- tabcasting, 2251, 50
insert into casting values (1258,219,6);
insert into casting values (301,219,1);
insert into casting values (259,219,3);
insert into casting values (178,219,1);
insert into casting values (156,219,1);
insert into casting values (145,219,1);
insert into casting values (557,219,1);
insert into casting values (1016,220,5);
insert into casting values (1030,220,1);
insert into casting values (1377,220,1);
insert into casting values (1192,220,2);
insert into casting values (347,220,7);
insert into casting values (126,220,4);
insert into casting values (131,220,6);
insert into casting values (327,220,6);
insert into casting values (645,220,3);
insert into casting values (444,220,1);
insert into casting values (1049,221,3);
insert into casting values (1486,221,7);
insert into casting values (1377,222,5);
insert into casting values (1735,222,1);
insert into casting values (231,222,6);
insert into casting values (162,222,3);
insert into casting values (85,222,4);
insert into casting values (36,222,1);
insert into casting values (630,222,5);
insert into casting values (631,222,1);
insert into casting values (532,222,2);
insert into casting values (840,223,2);
insert into casting values (965,223,1);
insert into casting values (780,223,6);
insert into casting values (1285,223,1);
insert into casting values (330,223,3);
insert into casting values (229,223,2);
insert into casting values (56,223,2);
insert into casting values (616,223,1);
insert into casting values (688,223,2);
insert into casting values (742,224,2);
insert into casting values (899,224,2);
insert into casting values (1046,224,1);
insert into casting values (1335,224,2);
insert into casting values (1476,224,2);
insert into casting values (134,224,5);
insert into casting values (164,224,2);
insert into casting values (106,224,5);
insert into casting values (223,224,9);
insert into casting values (525,224,1);
insert into casting values (999,225,5);
insert into casting values (1421,225,2);
insert into casting values (1292,225,8);
--- tabcasting, 2301, 50
insert into casting values (1481,225,1);
insert into casting values (1684,225,3);
insert into casting values (254,225,3);
insert into casting values (363,225,3);
insert into casting values (123,225,1);
insert into casting values (598,225,3);
insert into casting values (645,225,5);
insert into casting values (746,226,4);
insert into casting values (861,226,9);
insert into casting values (1048,226,5);
insert into casting values (994,226,11);
insert into casting values (1457,226,6);
insert into casting values (1458,226,3);
insert into casting values (1798,226,10);
insert into casting values (127,226,10);
insert into casting values (352,226,5);
insert into casting values (117,226,8);
insert into casting values (22,226,1);
insert into casting values (247,226,8);
insert into casting values (138,226,4);
insert into casting values (618,226,14);
insert into casting values (444,226,3);
insert into casting values (634,226,4);
insert into casting values (475,226,11);
insert into casting values (770,227,7);
insert into casting values (1264,227,7);
insert into casting values (1263,227,1);
insert into casting values (1378,227,8);
insert into casting values (1627,227,4);
insert into casting values (1644,227,5);
insert into casting values (254,227,8);
insert into casting values (298,227,7);
insert into casting values (361,227,5);
insert into casting values (597,227,12);
insert into casting values (414,227,3);
insert into casting values (569,227,5);
insert into casting values (459,227,4);
insert into casting values (986,228,2);
insert into casting values (884,228,9);
insert into casting values (870,228,2);
insert into casting values (1177,228,5);
insert into casting values (1400,228,3);
insert into casting values (1823,228,14);
insert into casting values (1844,228,2);
insert into casting values (78,228,2);
insert into casting values (190,228,8);
insert into casting values (531,228,1);
insert into casting values (709,228,2);
insert into casting values (591,228,3);
insert into casting values (859,229,3);
--- tabcasting, 2351, 50
insert into casting values (996,229,1);
insert into casting values (1142,229,1);
insert into casting values (1140,229,5);
insert into casting values (1557,229,3);
insert into casting values (17,229,2);
insert into casting values (50,229,1);
insert into casting values (398,229,3);
insert into casting values (1101,230,3);
insert into casting values (893,230,7);
insert into casting values (1306,230,3);
insert into casting values (1672,230,2);
insert into casting values (1676,230,4);
insert into casting values (1843,230,7);
insert into casting values (239,230,4);
insert into casting values (219,230,4);
insert into casting values (588,230,4);
insert into casting values (385,230,3);
insert into casting values (372,230,5);
insert into casting values (554,230,5);
insert into casting values (1069,231,1);
insert into casting values (1029,231,1);
insert into casting values (1121,231,8);
insert into casting values (1192,231,4);
insert into casting values (1641,231,1);
insert into casting values (127,231,2);
insert into casting values (564,231,6);
insert into casting values (396,231,2);
insert into casting values (538,231,2);
insert into casting values (840,232,4);
insert into casting values (890,232,1);
insert into casting values (1294,232,2);
insert into casting values (1584,232,1);
insert into casting values (218,232,1);
insert into casting values (357,232,2);
insert into casting values (470,232,1);
insert into casting values (1075,233,1);
insert into casting values (1050,233,2);
insert into casting values (741,233,2);
insert into casting values (1165,233,1);
insert into casting values (1577,233,2);
insert into casting values (1523,233,2);
insert into casting values (1728,233,1);
insert into casting values (562,233,3);
insert into casting values (818,234,4);
insert into casting values (1002,234,1);
insert into casting values (1592,234,2);
insert into casting values (1831,234,1);
insert into casting values (243,234,7);
insert into casting values (254,234,5);
insert into casting values (506,234,6);
--- tabcasting, 2401, 50
insert into casting values (454,234,1);
insert into casting values (691,234,2);
insert into casting values (271,235,3);
insert into casting values (313,235,2);
insert into casting values (1069,236,2);
insert into casting values (787,236,1);
insert into casting values (726,236,1);
insert into casting values (723,236,1);
insert into casting values (729,236,1);
insert into casting values (613,236,1);
insert into casting values (800,237,4);
insert into casting values (755,237,1);
insert into casting values (102,237,1);
insert into casting values (272,237,1);
insert into casting values (75,237,1);
insert into casting values (656,237,1);
insert into casting values (885,238,2);
insert into casting values (1006,238,8);
insert into casting values (943,238,3);
insert into casting values (1260,238,7);
insert into casting values (1259,238,3);
insert into casting values (1106,238,11);
insert into casting values (1281,238,3);
insert into casting values (1705,238,8);
insert into casting values (1755,238,5);
insert into casting values (258,238,4);
insert into casting values (668,238,6);
insert into casting values (521,238,3);
insert into casting values (400,238,9);
insert into casting values (396,238,3);
insert into casting values (881,239,6);
insert into casting values (753,239,14);
insert into casting values (1047,239,5);
insert into casting values (1015,239,3);
insert into casting values (1177,239,2);
insert into casting values (89,239,4);
insert into casting values (30,239,3);
insert into casting values (35,239,6);
insert into casting values (440,239,1);
insert into casting values (433,239,3);
insert into casting values (467,239,13);
insert into casting values (501,239,5);
insert into casting values (713,239,6);
insert into casting values (1451,240,4);
insert into casting values (1831,240,15);
insert into casting values (1819,240,1);
insert into casting values (55,240,9);
insert into casting values (223,240,1);
insert into casting values (346,240,1);
insert into casting values (500,240,5);
--- tabcasting, 2451, 50
insert into casting values (603,240,1);
insert into casting values (752,241,1);
insert into casting values (928,241,6);
insert into casting values (1113,241,1);
insert into casting values (1172,241,1);
insert into casting values (1689,241,12);
insert into casting values (127,241,1);
insert into casting values (188,241,2);
insert into casting values (112,241,2);
insert into casting values (830,242,2);
insert into casting values (1112,242,1);
insert into casting values (1368,242,6);
insert into casting values (56,242,3);
insert into casting values (338,242,7);
insert into casting values (444,242,6);
insert into casting values (512,242,12);
insert into casting values (597,242,5);
insert into casting values (1058,243,3);
insert into casting values (1545,243,2);
insert into casting values (151,243,2);
insert into casting values (3,243,3);
insert into casting values (107,243,4);
insert into casting values (281,243,7);
insert into casting values (502,243,1);
insert into casting values (616,243,2);
insert into casting values (574,243,12);
insert into casting values (380,243,2);
insert into casting values (1204,244,9);
insert into casting values (1197,244,1);
insert into casting values (1376,244,4);
insert into casting values (1477,244,3);
insert into casting values (1524,244,5);
insert into casting values (266,244,3);
insert into casting values (39,244,3);
insert into casting values (201,244,4);
insert into casting values (652,244,15);
insert into casting values (528,244,2);
insert into casting values (503,244,4);
insert into casting values (1035,245,7);
insert into casting values (918,245,8);
insert into casting values (1251,245,2);
insert into casting values (1430,245,1);
insert into casting values (1142,245,3);
insert into casting values (1814,245,9);
insert into casting values (512,245,1);
insert into casting values (527,245,4);
insert into casting values (389,245,1);
insert into casting values (741,246,6);
insert into casting values (1046,246,10);
insert into casting values (861,246,7);
--- tabcasting, 2501, 50
insert into casting values (828,246,4);
insert into casting values (1404,246,14);
insert into casting values (1174,246,3);
insert into casting values (1170,246,3);
insert into casting values (1608,246,6);
insert into casting values (152,246,8);
insert into casting values (6,246,10);
insert into casting values (200,246,9);
insert into casting values (388,246,7);
insert into casting values (634,246,13);
insert into casting values (475,246,12);
insert into casting values (527,246,6);
insert into casting values (688,246,7);
insert into casting values (676,246,3);
insert into casting values (601,246,3);
insert into casting values (507,246,7);
insert into casting values (877,247,2);
insert into casting values (1021,247,2);
insert into casting values (1400,247,2);
insert into casting values (1165,247,9);
insert into casting values (1426,247,1);
insert into casting values (65,247,3);
insert into casting values (934,248,5);
insert into casting values (1439,248,1);
insert into casting values (1720,248,1);
insert into casting values (1688,248,5);
insert into casting values (89,248,5);
insert into casting values (177,248,1);
insert into casting values (265,248,4);
insert into casting values (445,248,6);
insert into casting values (764,249,3);
insert into casting values (969,249,3);
insert into casting values (1464,249,4);
insert into casting values (1209,249,1);
insert into casting values (1201,249,2);
insert into casting values (1117,249,2);
insert into casting values (1604,249,9);
insert into casting values (339,249,2);
insert into casting values (10,249,2);
insert into casting values (604,249,2);
insert into casting values (959,250,2);
insert into casting values (1292,250,1);
insert into casting values (1384,250,3);
insert into casting values (1567,250,3);
insert into casting values (1504,250,1);
insert into casting values (295,250,2);
insert into casting values (12,250,6);
insert into casting values (447,250,1);
insert into casting values (1243,251,3);
insert into casting values (1815,251,1);
--- tabcasting, 2551, 50
insert into casting values (254,251,7);
insert into casting values (180,251,3);
insert into casting values (614,251,1);
insert into casting values (446,251,1);
insert into casting values (620,251,3);
insert into casting values (763,252,9);
insert into casting values (977,252,3);
insert into casting values (1188,252,7);
insert into casting values (1314,252,4);
insert into casting values (1439,252,12);
insert into casting values (1473,252,3);
insert into casting values (1713,252,8);
insert into casting values (24,252,5);
insert into casting values (133,252,13);
insert into casting values (46,252,5);
insert into casting values (333,252,12);
insert into casting values (317,252,6);
insert into casting values (245,252,10);
insert into casting values (463,252,6);
insert into casting values (573,252,3);
insert into casting values (946,253,12);
insert into casting values (732,253,35);
insert into casting values (1412,253,12);
insert into casting values (1173,253,4);
insert into casting values (288,253,3);
insert into casting values (40,253,1);
insert into casting values (522,253,1);
insert into casting values (1101,254,2);
insert into casting values (781,254,2);
insert into casting values (1251,254,4);
insert into casting values (1733,254,11);
insert into casting values (1697,254,3);
insert into casting values (1627,254,3);
insert into casting values (1814,254,3);
insert into casting values (333,254,6);
insert into casting values (652,254,6);
insert into casting values (705,254,1);
insert into casting values (430,254,3);
insert into casting values (985,255,2);
insert into casting values (763,255,11);
insert into casting values (1534,255,5);
insert into casting values (191,255,4);
insert into casting values (53,255,4);
insert into casting values (16,255,3);
insert into casting values (305,255,1);
insert into casting values (385,255,2);
insert into casting values (802,256,3);
insert into casting values (898,256,9);
insert into casting values (843,256,5);
insert into casting values (930,256,15);
--- tabcasting, 2601, 50
insert into casting values (1375,256,1);
insert into casting values (1828,256,7);
insert into casting values (227,256,2);
insert into casting values (709,256,1);
insert into casting values (592,256,1);
insert into casting values (943,257,1);
insert into casting values (1393,257,1);
insert into casting values (1769,257,1);
insert into casting values (262,257,1);
insert into casting values (452,257,13);
insert into casting values (499,257,3);
insert into casting values (654,257,5);
insert into casting values (962,258,4);
insert into casting values (1307,258,2);
insert into casting values (201,258,7);
insert into casting values (253,258,13);
insert into casting values (33,258,2);
insert into casting values (144,258,6);
insert into casting values (21,258,2);
insert into casting values (662,258,2);
insert into casting values (638,258,2);
insert into casting values (647,258,1);
insert into casting values (733,259,10);
insert into casting values (1474,259,1);
insert into casting values (163,259,3);
insert into casting values (43,259,3);
insert into casting values (239,259,2);
insert into casting values (342,259,7);
insert into casting values (155,259,3);
insert into casting values (554,259,2);
insert into casting values (449,259,1);
insert into casting values (903,260,2);
insert into casting values (1410,260,5);
insert into casting values (1186,260,2);
insert into casting values (1830,260,2);
insert into casting values (294,260,1);
insert into casting values (434,260,2);
insert into casting values (595,260,10);
insert into casting values (439,260,1);
insert into casting values (1054,261,4);
insert into casting values (809,261,4);
insert into casting values (1394,261,5);
insert into casting values (1294,261,3);
insert into casting values (1439,261,2);
insert into casting values (129,261,13);
insert into casting values (547,261,4);
insert into casting values (674,261,4);
insert into casting values (710,261,1);
insert into casting values (711,261,2);
insert into casting values (1647,262,10);
--- tabcasting, 2651, 50
insert into casting values (1024,263,9);
insert into casting values (886,263,9);
insert into casting values (1235,263,3);
insert into casting values (1297,263,6);
insert into casting values (1157,263,5);
insert into casting values (1761,263,4);
insert into casting values (1743,263,5);
insert into casting values (1596,263,4);
insert into casting values (188,263,11);
insert into casting values (291,263,2);
insert into casting values (327,263,7);
insert into casting values (201,263,5);
insert into casting values (411,263,9);
insert into casting values (1101,265,1);
insert into casting values (741,265,1);
insert into casting values (967,265,2);
insert into casting values (1138,265,2);
insert into casting values (1212,265,4);
insert into casting values (1600,265,2);
insert into casting values (1824,265,1);
insert into casting values (1121,267,9);
insert into casting values (1734,267,2);
insert into casting values (1755,267,1);
insert into casting values (263,267,2);
insert into casting values (306,267,1);
insert into casting values (198,267,1);
insert into casting values (526,267,9);
insert into casting values (697,267,2);
insert into casting values (1068,270,1);
insert into casting values (1305,270,1);
insert into casting values (111,270,1);
insert into casting values (984,277,1);
insert into casting values (1016,277,7);
insert into casting values (808,277,7);
insert into casting values (978,277,3);
insert into casting values (1170,277,1);
insert into casting values (1372,277,1);
insert into casting values (247,277,7);
insert into casting values (860,278,1);
insert into casting values (1156,278,5);
insert into casting values (1590,278,2);
insert into casting values (1840,278,7);
insert into casting values (293,278,2);
insert into casting values (148,278,5);
insert into casting values (192,278,6);
insert into casting values (533,278,1);
insert into casting values (559,278,3);
insert into casting values (1099,279,1);
insert into casting values (989,279,1);
insert into casting values (1764,279,1);
--- tabcasting, 2701, 50
insert into casting values (271,279,1);
insert into casting values (583,279,1);
insert into casting values (939,280,2);
insert into casting values (877,280,3);
insert into casting values (1684,280,1);
insert into casting values (157,280,2);
insert into casting values (292,280,1);
insert into casting values (319,280,8);
insert into casting values (592,280,2);
insert into casting values (619,280,2);
insert into casting values (706,280,7);
insert into casting values (1263,282,6);
insert into casting values (1666,282,4);
insert into casting values (56,282,1);
insert into casting values (70,282,2);
insert into casting values (364,282,2);
insert into casting values (232,282,3);
insert into casting values (399,282,1);
insert into casting values (509,282,3);
insert into casting values (373,282,8);
insert into casting values (906,284,4);
insert into casting values (1167,284,3);
insert into casting values (1776,284,1);
insert into casting values (1786,284,1);
insert into casting values (239,284,1);
insert into casting values (554,284,1);
insert into casting values (1177,289,4);
insert into casting values (1316,289,1);
insert into casting values (1593,289,1);
insert into casting values (167,289,1);
insert into casting values (673,289,1);
insert into casting values (423,289,3);
insert into casting values (252,294,1);
insert into casting values (280,294,1);
insert into casting values (92,294,2);
insert into casting values (276,294,14);
insert into casting values (68,294,1);
insert into casting values (311,294,3);
insert into casting values (506,294,7);
insert into casting values (631,294,12);
insert into casting values (890,295,10);
insert into casting values (1036,295,5);
insert into casting values (824,295,1);
insert into casting values (843,295,2);
insert into casting values (1165,295,8);
insert into casting values (1457,295,4);
insert into casting values (1629,295,4);
insert into casting values (1540,295,3);
insert into casting values (73,295,13);
insert into casting values (35,295,4);
--- tabcasting, 2751, 50
insert into casting values (568,295,9);
insert into casting values (594,295,7);
insert into casting values (750,296,4);
insert into casting values (1039,296,3);
insert into casting values (1089,296,4);
insert into casting values (1455,296,4);
insert into casting values (1150,296,12);
insert into casting values (1706,296,5);
insert into casting values (1796,296,4);
insert into casting values (1646,296,2);
insert into casting values (19,296,6);
insert into casting values (219,296,3);
insert into casting values (350,296,5);
insert into casting values (1086,297,2);
insert into casting values (797,297,2);
insert into casting values (771,297,5);
insert into casting values (1337,297,1);
insert into casting values (1116,297,4);
insert into casting values (1307,297,6);
insert into casting values (1477,297,2);
insert into casting values (86,297,3);
insert into casting values (652,297,4);
insert into casting values (656,297,11);
insert into casting values (779,298,6);
insert into casting values (866,298,2);
insert into casting values (1519,298,7);
insert into casting values (217,298,2);
insert into casting values (58,298,2);
insert into casting values (143,298,1);
insert into casting values (620,298,7);
insert into casting values (664,298,18);
insert into casting values (600,298,3);
insert into casting values (863,299,1);
insert into casting values (994,299,1);
insert into casting values (814,299,1);
insert into casting values (1508,299,7);
insert into casting values (258,299,3);
insert into casting values (521,299,2);
insert into casting values (386,299,2);
insert into casting values (990,300,3);
insert into casting values (770,300,5);
insert into casting values (898,300,1);
insert into casting values (1132,300,4);
insert into casting values (342,300,8);
insert into casting values (586,300,1);
insert into casting values (591,300,2);
insert into casting values (1009,301,3);
insert into casting values (838,301,4);
insert into casting values (1290,301,9);
insert into casting values (1354,301,4);
--- tabcasting, 2801, 50
insert into casting values (1292,301,9);
insert into casting values (1232,301,2);
insert into casting values (1686,301,3);
insert into casting values (242,301,4);
insert into casting values (198,301,2);
insert into casting values (65,301,6);
insert into casting values (1054,302,5);
insert into casting values (1011,302,6);
insert into casting values (962,302,1);
insert into casting values (931,302,4);
insert into casting values (1384,302,2);
insert into casting values (1513,302,2);
insert into casting values (1516,302,3);
insert into casting values (6,302,3);
insert into casting values (373,302,2);
insert into casting values (890,303,3);
insert into casting values (944,303,3);
insert into casting values (1784,303,2);
insert into casting values (1598,303,5);
insert into casting values (148,303,3);
insert into casting values (26,303,3);
insert into casting values (192,303,5);
insert into casting values (663,303,1);
insert into casting values (1127,304,8);
insert into casting values (1306,304,2);
insert into casting values (1291,304,1);
insert into casting values (1829,304,1);
insert into casting values (1707,304,8);
insert into casting values (1777,304,4);
insert into casting values (34,304,1);
insert into casting values (280,304,8);
insert into casting values (877,305,4);
insert into casting values (870,305,5);
insert into casting values (793,305,4);
insert into casting values (1036,305,4);
insert into casting values (1464,305,9);
insert into casting values (1783,305,6);
insert into casting values (1802,305,9);
insert into casting values (1611,305,4);
insert into casting values (179,305,3);
insert into casting values (259,305,9);
insert into casting values (652,305,7);
insert into casting values (666,305,4);
insert into casting values (915,306,2);
insert into casting values (1004,306,7);
insert into casting values (1226,306,1);
insert into casting values (1412,306,10);
insert into casting values (1635,306,2);
insert into casting values (1801,306,16);
insert into casting values (1660,306,5);
--- tabcasting, 2851, 50
insert into casting values (45,306,3);
insert into casting values (339,306,3);
insert into casting values (283,306,7);
insert into casting values (711,306,3);
insert into casting values (492,306,13);
insert into casting values (961,307,10);
insert into casting values (891,307,4);
insert into casting values (1089,307,5);
insert into casting values (1690,307,3);
insert into casting values (1551,307,2);
insert into casting values (146,307,12);
insert into casting values (73,307,3);
insert into casting values (60,307,9);
insert into casting values (408,307,10);
insert into casting values (999,308,2);
insert into casting values (1150,308,6);
insert into casting values (1307,308,5);
insert into casting values (1844,308,3);
insert into casting values (251,308,2);
insert into casting values (6,308,2);
insert into casting values (174,308,14);
insert into casting values (276,308,8);
insert into casting values (432,308,2);
insert into casting values (392,308,1);
insert into casting values (573,308,12);
insert into casting values (871,309,3);
insert into casting values (834,309,6);
insert into casting values (1340,309,3);
insert into casting values (1471,309,5);
insert into casting values (1171,309,11);
insert into casting values (1562,309,5);
insert into casting values (1669,309,15);
insert into casting values (1486,309,4);
insert into casting values (19,309,7);
insert into casting values (630,309,4);
insert into casting values (669,309,4);
insert into casting values (621,309,3);
insert into casting values (858,310,2);
insert into casting values (1812,310,12);
insert into casting values (1576,310,14);
insert into casting values (1717,310,1);
insert into casting values (1573,310,1);
insert into casting values (434,310,1);
insert into casting values (567,310,5);
insert into casting values (595,310,4);
insert into casting values (1023,311,3);
insert into casting values (1367,311,2);
insert into casting values (1509,311,2);
insert into casting values (1494,311,10);
insert into casting values (1532,311,4);
--- tabcasting, 2901, 50
insert into casting values (1707,311,4);
insert into casting values (1843,311,8);
insert into casting values (239,311,3);
insert into casting values (554,311,3);
insert into casting values (511,311,2);
insert into casting values (509,311,7);
insert into casting values (1173,312,11);
insert into casting values (154,312,3);
insert into casting values (851,313,4);
insert into casting values (893,313,11);
insert into casting values (858,313,8);
insert into casting values (1216,313,2);
insert into casting values (1346,313,4);
insert into casting values (1606,313,5);
insert into casting values (322,313,8);
insert into casting values (58,313,5);
insert into casting values (260,313,4);
insert into casting values (635,313,2);
insert into casting values (619,313,7);
insert into casting values (618,313,8);
insert into casting values (904,314,3);
insert into casting values (811,314,4);
insert into casting values (782,314,2);
insert into casting values (874,314,6);
insert into casting values (1560,314,1);
insert into casting values (1548,314,3);
insert into casting values (634,314,7);
insert into casting values (441,314,2);
insert into casting values (636,314,2);
insert into casting values (588,314,11);
insert into casting values (788,315,1);
insert into casting values (1283,315,2);
insert into casting values (1841,315,4);
insert into casting values (327,315,11);
insert into casting values (616,315,3);
insert into casting values (678,315,1);
insert into casting values (710,315,3);
insert into casting values (649,315,2);
insert into casting values (844,316,12);
insert into casting values (934,316,2);
insert into casting values (1370,316,2);
insert into casting values (1149,316,4);
insert into casting values (1701,316,1);
insert into casting values (365,316,2);
insert into casting values (138,316,3);
insert into casting values (62,316,3);
insert into casting values (475,316,3);
insert into casting values (743,317,3);
insert into casting values (741,317,7);
insert into casting values (1294,317,4);
--- tabcasting, 2951, 50
insert into casting values (1128,317,1);
insert into casting values (1408,317,7);
insert into casting values (1319,317,3);
insert into casting values (1239,317,3);
insert into casting values (1528,317,5);
insert into casting values (141,317,3);
insert into casting values (443,317,13);
insert into casting values (850,318,2);
insert into casting values (1204,318,13);
insert into casting values (1191,318,3);
insert into casting values (1378,318,4);
insert into casting values (1840,318,5);
insert into casting values (1645,318,2);
insert into casting values (80,318,5);
insert into casting values (296,318,4);
insert into casting values (8,318,2);
insert into casting values (395,318,5);
insert into casting values (797,319,1);
insert into casting values (832,319,4);
insert into casting values (923,319,6);
insert into casting values (1367,319,3);
insert into casting values (1285,319,2);
insert into casting values (1787,319,3);
insert into casting values (576,319,9);
insert into casting values (684,319,1);
insert into casting values (1412,320,3);
insert into casting values (1211,320,2);
insert into casting values (642,320,5);
insert into casting values (1053,321,1);
insert into casting values (1256,321,4);
insert into casting values (307,321,1);
insert into casting values (316,321,2);
insert into casting values (4,321,4);
insert into casting values (447,321,2);
insert into casting values (600,321,5);
insert into casting values (857,322,2);
insert into casting values (939,322,5);
insert into casting values (1719,322,1);
insert into casting values (340,322,1);
insert into casting values (390,322,1);
insert into casting values (690,322,2);
insert into casting values (1032,323,1);
insert into casting values (1587,323,1);
insert into casting values (1583,323,4);
insert into casting values (244,323,4);
insert into casting values (560,323,2);
insert into casting values (418,323,1);
insert into casting values (763,324,3);
insert into casting values (1192,324,1);
insert into casting values (1386,324,1);
--- tabcasting, 3001, 50
insert into casting values (1300,324,3);
insert into casting values (186,324,2);
insert into casting values (32,324,1);
insert into casting values (1486,325,1);
insert into casting values (1497,325,3);
insert into casting values (191,325,2);
insert into casting values (334,325,2);
insert into casting values (279,325,3);
insert into casting values (298,325,3);
insert into casting values (301,325,2);
insert into casting values (699,325,2);
insert into casting values (951,326,5);
insert into casting values (1015,327,1);
insert into casting values (782,327,1);
insert into casting values (867,327,3);
insert into casting values (1579,327,1);
insert into casting values (1582,327,1);
insert into casting values (286,327,1);
insert into casting values (800,328,3);
insert into casting values (1225,328,1);
insert into casting values (1600,328,3);
insert into casting values (137,328,2);
insert into casting values (229,328,3);
insert into casting values (317,328,2);
insert into casting values (44,328,2);
insert into casting values (458,328,3);
insert into casting values (953,329,9);
insert into casting values (1117,329,4);
insert into casting values (1224,329,2);
insert into casting values (7,329,2);
insert into casting values (283,329,1);
insert into casting values (528,329,1);
insert into casting values (408,329,6);
insert into casting values (475,329,4);
insert into casting values (1414,330,8);
insert into casting values (1668,330,10);
insert into casting values (291,330,10);
insert into casting values (670,330,10);
insert into casting values (1009,331,5);
insert into casting values (1285,331,9);
insert into casting values (1425,331,9);
insert into casting values (1356,331,10);
insert into casting values (1688,331,15);
insert into casting values (1801,331,11);
insert into casting values (45,331,7);
insert into casting values (256,331,1);
insert into casting values (475,331,5);
insert into casting values (549,331,1);
insert into casting values (893,332,1);
insert into casting values (1167,332,6);
--- tabcasting, 3051, 50
insert into casting values (1275,332,12);
insert into casting values (327,332,14);
insert into casting values (548,332,8);
insert into casting values (702,332,3);
insert into casting values (871,333,4);
insert into casting values (1089,333,2);
insert into casting values (1001,333,2);
insert into casting values (753,333,7);
insert into casting values (1520,333,2);
insert into casting values (131,333,2);
insert into casting values (111,333,13);
insert into casting values (29,333,5);
insert into casting values (253,333,5);
insert into casting values (664,333,15);
insert into casting values (463,333,3);
insert into casting values (849,334,5);
insert into casting values (1030,334,8);
insert into casting values (1117,334,6);
insert into casting values (1239,334,4);
insert into casting values (1187,334,14);
insert into casting values (1147,334,2);
insert into casting values (1374,334,3);
insert into casting values (1717,334,3);
insert into casting values (1825,334,2);
insert into casting values (475,334,2);
insert into casting values (577,334,12);
insert into casting values (437,334,6);
insert into casting values (822,335,9);
insert into casting values (1187,335,12);
insert into casting values (1151,335,3);
insert into casting values (1823,335,13);
insert into casting values (137,335,1);
insert into casting values (317,335,1);
insert into casting values (44,335,1);
insert into casting values (585,335,4);
insert into casting values (1032,336,5);
insert into casting values (1108,336,2);
insert into casting values (1397,336,3);
insert into casting values (150,336,1);
insert into casting values (81,336,8);
insert into casting values (214,336,15);
insert into casting values (117,336,11);
insert into casting values (530,336,3);
insert into casting values (649,336,5);
insert into casting values (741,337,4);
insert into casting values (1453,337,6);
insert into casting values (1343,337,9);
insert into casting values (1373,337,4);
insert into casting values (1289,337,11);
insert into casting values (1438,337,4);
--- tabcasting, 3101, 50
insert into casting values (1201,337,8);
insert into casting values (1771,337,12);
insert into casting values (265,337,5);
insert into casting values (534,337,2);
insert into casting values (556,337,1);
insert into casting values (1087,338,2);
insert into casting values (885,338,11);
insert into casting values (942,338,5);
insert into casting values (1051,338,1);
insert into casting values (1401,338,3);
insert into casting values (1376,338,6);
insert into casting values (1546,338,2);
insert into casting values (342,338,4);
insert into casting values (662,338,5);
insert into casting values (965,339,7);
insert into casting values (1040,339,3);
insert into casting values (746,339,12);
insert into casting values (1214,339,2);
insert into casting values (1451,339,5);
insert into casting values (1401,339,5);
insert into casting values (1689,339,3);
insert into casting values (1686,339,9);
insert into casting values (1688,339,6);
insert into casting values (545,339,5);
insert into casting values (429,339,5);
insert into casting values (874,340,1);
insert into casting values (882,340,3);
insert into casting values (1482,340,10);
insert into casting values (1641,340,8);
insert into casting values (1604,340,2);
insert into casting values (1736,340,1);
insert into casting values (474,340,2);
insert into casting values (707,340,2);
insert into casting values (972,341,15);
insert into casting values (1027,341,8);
insert into casting values (1026,341,6);
insert into casting values (1102,341,6);
insert into casting values (1341,341,7);
insert into casting values (1198,341,7);
insert into casting values (1399,341,2);
insert into casting values (1219,341,5);
insert into casting values (1187,341,5);
insert into casting values (1810,341,8);
insert into casting values (264,341,8);
insert into casting values (487,341,5);
insert into casting values (466,341,4);
insert into casting values (1058,342,4);
insert into casting values (1463,342,1);
insert into casting values (1437,342,1);
insert into casting values (1684,342,9);
--- tabcasting, 3151, 50
insert into casting values (129,342,4);
insert into casting values (620,342,5);
insert into casting values (576,342,5);
insert into casting values (664,342,13);
insert into casting values (1039,343,8);
insert into casting values (969,343,1);
insert into casting values (832,343,7);
insert into casting values (358,343,2);
insert into casting values (724,343,7);
insert into casting values (714,343,1);
insert into casting values (388,343,1);
insert into casting values (923,344,3);
insert into casting values (806,344,2);
insert into casting values (739,344,4);
insert into casting values (1538,344,2);
insert into casting values (1719,344,3);
insert into casting values (606,344,2);
insert into casting values (553,344,6);
insert into casting values (703,344,2);
insert into casting values (1062,345,2);
insert into casting values (778,345,1);
insert into casting values (1208,345,1);
insert into casting values (1345,345,6);
insert into casting values (159,345,1);
insert into casting values (580,345,2);
insert into casting values (1387,347,2);
insert into casting values (1151,347,2);
insert into casting values (1126,347,3);
insert into casting values (1651,347,3);
insert into casting values (50,347,5);
insert into casting values (156,347,3);
insert into casting values (93,347,1);
insert into casting values (469,347,6);
insert into casting values (940,348,1);
insert into casting values (1463,348,2);
insert into casting values (1403,348,4);
insert into casting values (1782,348,1);
insert into casting values (322,348,3);
insert into casting values (320,348,9);
insert into casting values (8,348,7);
insert into casting values (635,348,9);
insert into casting values (984,349,2);
insert into casting values (1054,349,3);
insert into casting values (1063,349,5);
insert into casting values (782,349,3);
insert into casting values (1037,349,2);
insert into casting values (1281,349,2);
insert into casting values (1367,349,6);
insert into casting values (1268,349,2);
insert into casting values (373,349,4);
--- tabcasting, 3201, 50
insert into casting values (1053,350,2);
insert into casting values (1223,350,2);
insert into casting values (1329,350,3);
insert into casting values (343,350,5);
insert into casting values (361,350,2);
insert into casting values (433,350,1);
insert into casting values (514,350,2);
insert into casting values (531,350,9);
insert into casting values (839,351,2);
insert into casting values (1128,351,4);
insert into casting values (1354,351,5);
insert into casting values (1201,351,1);
insert into casting values (1826,351,6);
insert into casting values (92,351,3);
insert into casting values (417,351,1);
insert into casting values (927,352,6);
insert into casting values (1341,352,1);
insert into casting values (36,352,4);
insert into casting values (134,352,9);
insert into casting values (264,352,9);
insert into casting values (1086,353,14);
insert into casting values (928,353,14);
insert into casting values (1210,353,11);
insert into casting values (1403,353,2);
insert into casting values (1384,353,4);
insert into casting values (1606,353,3);
insert into casting values (296,353,3);
insert into casting values (312,353,4);
insert into casting values (114,353,4);
insert into casting values (142,353,2);
insert into casting values (267,353,3);
insert into casting values (621,353,11);
insert into casting values (954,354,10);
insert into casting values (1079,354,3);
insert into casting values (748,354,5);
insert into casting values (1635,354,6);
insert into casting values (1684,354,4);
insert into casting values (161,354,4);
insert into casting values (361,354,4);
insert into casting values (315,354,5);
insert into casting values (567,354,10);
insert into casting values (498,354,14);
insert into casting values (719,354,6);
insert into casting values (706,354,4);
insert into casting values (1031,355,13);
insert into casting values (1394,355,9);
insert into casting values (1659,355,2);
insert into casting values (140,355,11);
insert into casting values (3,355,8);
insert into casting values (99,355,4);
--- tabcasting, 3251, 50
insert into casting values (180,355,12);
insert into casting values (260,355,3);
insert into casting values (79,355,6);
insert into casting values (408,355,5);
insert into casting values (538,355,4);
insert into casting values (395,355,4);
insert into casting values (882,356,8);
insert into casting values (780,356,14);
insert into casting values (1004,356,3);
insert into casting values (1403,356,3);
insert into casting values (1748,356,3);
insert into casting values (1784,356,7);
insert into casting values (55,356,10);
insert into casting values (35,356,1);
insert into casting values (83,356,5);
insert into casting values (638,356,3);
insert into casting values (485,356,11);
insert into casting values (928,357,8);
insert into casting values (1146,357,6);
insert into casting values (1180,357,3);
insert into casting values (1627,357,8);
insert into casting values (1742,357,5);
insert into casting values (297,357,5);
insert into casting values (264,357,11);
insert into casting values (253,357,9);
insert into casting values (61,357,13);
insert into casting values (266,357,4);
insert into casting values (104,357,4);
insert into casting values (511,357,3);
insert into casting values (809,358,5);
insert into casting values (961,358,15);
insert into casting values (1153,358,6);
insert into casting values (1486,358,6);
insert into casting values (1511,358,3);
insert into casting values (98,358,15);
insert into casting values (338,358,9);
insert into casting values (444,358,2);
insert into casting values (428,358,6);
insert into casting values (678,358,5);
insert into casting values (597,358,3);
insert into casting values (502,358,2);
insert into casting values (786,359,2);
insert into casting values (1480,359,4);
insert into casting values (355,359,3);
insert into casting values (238,359,10);
insert into casting values (236,359,5);
insert into casting values (600,359,2);
insert into casting values (386,359,4);
insert into casting values (520,359,3);
insert into casting values (1801,360,15);
--- tabcasting, 3301, 50
insert into casting values (1827,361,11);
insert into casting values (1160,362,7);
insert into casting values (1605,362,2);
insert into casting values (1676,362,5);
insert into casting values (1780,362,3);
insert into casting values (1842,362,10);
insert into casting values (319,362,6);
insert into casting values (330,362,5);
insert into casting values (360,362,2);
insert into casting values (542,362,2);
insert into casting values (652,362,5);
insert into casting values (808,363,4);
insert into casting values (988,363,3);
insert into casting values (1027,363,5);
insert into casting values (1007,363,1);
insert into casting values (1549,363,10);
insert into casting values (301,363,3);
insert into casting values (146,363,9);
insert into casting values (247,363,4);
insert into casting values (369,363,8);
insert into casting values (1385,364,15);
insert into casting values (1797,365,12);
insert into casting values (754,366,1);
insert into casting values (870,366,1);
insert into casting values (1610,366,2);
insert into casting values (1541,366,1);
insert into casting values (313,366,13);
insert into casting values (840,367,9);
insert into casting values (1285,367,3);
insert into casting values (1277,367,2);
insert into casting values (1313,367,15);
insert into casting values (1839,367,2);
insert into casting values (1688,367,3);
insert into casting values (1680,367,2);
insert into casting values (188,367,3);
insert into casting values (832,368,5);
insert into casting values (893,368,2);
insert into casting values (858,368,1);
insert into casting values (3,368,10);
insert into casting values (379,368,3);
insert into casting values (548,368,1);
insert into casting values (592,368,5);
insert into casting values (882,369,1);
insert into casting values (1029,369,2);
insert into casting values (1156,369,1);
insert into casting values (1319,369,12);
insert into casting values (1842,369,2);
insert into casting values (16,369,5);
insert into casting values (259,369,2);
insert into casting values (1453,370,4);
--- tabcasting, 3351, 50
insert into casting values (1120,370,1);
insert into casting values (1753,370,3);
insert into casting values (1744,370,2);
insert into casting values (332,370,2);
insert into casting values (551,370,1);
insert into casting values (840,372,5);
insert into casting values (884,372,2);
insert into casting values (1270,372,1);
insert into casting values (1737,372,1);
insert into casting values (272,372,3);
insert into casting values (102,372,5);
insert into casting values (765,373,3);
insert into casting values (739,373,2);
insert into casting values (1278,373,4);
insert into casting values (1763,373,6);
insert into casting values (147,373,3);
insert into casting values (476,373,3);
insert into casting values (532,373,4);
insert into casting values (929,380,5);
insert into casting values (794,380,4);
insert into casting values (858,380,3);
insert into casting values (743,380,6);
insert into casting values (861,380,3);
insert into casting values (881,380,5);
insert into casting values (1110,380,4);
insert into casting values (1209,380,2);
insert into casting values (1738,380,6);
insert into casting values (815,381,1);
insert into casting values (1425,381,5);
insert into casting values (1626,381,1);
insert into casting values (112,381,3);
insert into casting values (614,381,2);
insert into casting values (549,381,5);
insert into casting values (762,385,5);
insert into casting values (995,385,5);
insert into casting values (886,385,4);
insert into casting values (736,385,5);
insert into casting values (1453,385,3);
insert into casting values (1409,385,5);
insert into casting values (1728,385,3);
insert into casting values (261,385,5);
insert into casting values (912,393,2);
insert into casting values (1172,393,2);
insert into casting values (331,393,1);
insert into casting values (649,393,1);
insert into casting values (686,393,1);
insert into casting values (1070,400,1);
insert into casting values (949,400,2);
insert into casting values (1022,400,2);
insert into casting values (955,400,1);
--- tabcasting, 3401, 50
insert into casting values (1148,400,2);
insert into casting values (675,400,4);
insert into casting values (1635,404,1);
insert into casting values (1695,404,1);
insert into casting values (332,404,1);
insert into casting values (518,404,1);
insert into casting values (1112,406,2);
insert into casting values (1356,406,3);
insert into casting values (1557,406,2);
insert into casting values (228,406,4);
insert into casting values (144,406,2);
insert into casting values (395,406,2);
insert into casting values (432,406,1);
insert into casting values (1126,413,2);
insert into casting values (1150,413,8);
insert into casting values (1726,413,9);
insert into casting values (1673,413,4);
insert into casting values (93,413,5);
insert into casting values (321,413,3);
insert into casting values (52,413,3);
insert into casting values (236,413,2);
insert into casting values (484,413,3);
insert into casting values (1037,416,4);
insert into casting values (1264,416,9);
insert into casting values (1348,416,1);
insert into casting values (1659,416,9);
insert into casting values (354,416,4);
insert into casting values (630,416,6);
insert into casting values (441,416,3);
insert into casting values (648,416,8);
insert into casting values (649,416,3);
insert into casting values (758,417,3);
insert into casting values (1383,417,4);
insert into casting values (1776,417,4);
insert into casting values (1477,417,5);
insert into casting values (51,417,5);
insert into casting values (55,417,2);
insert into casting values (187,417,3);
insert into casting values (73,417,2);
insert into casting values (1222,419,1);
insert into casting values (1435,419,1);
insert into casting values (1459,419,1);
insert into casting values (746,426,2);
insert into casting values (1205,426,2);
insert into casting values (1777,426,5);
insert into casting values (266,426,6);
insert into casting values (244,426,7);
insert into casting values (247,426,3);
insert into casting values (436,426,2);
insert into casting values (572,426,2);
--- tabcasting, 3451, 50
insert into casting values (33,427,1);
insert into casting values (82,427,1);
insert into casting values (351,427,3);
insert into casting values (459,427,3);
insert into casting values (701,427,1);
insert into casting values (1062,429,1);
insert into casting values (1435,429,2);
insert into casting values (1459,429,3);
insert into casting values (299,429,2);
insert into casting values (478,429,2);
insert into casting values (667,429,1);
insert into casting values (915,430,1);
insert into casting values (784,430,3);
insert into casting values (1391,430,5);
insert into casting values (113,430,1);
insert into casting values (731,430,1);
insert into casting values (845,431,13);
insert into casting values (769,431,5);
insert into casting values (1155,431,8);
insert into casting values (1197,431,6);
insert into casting values (1203,431,2);
insert into casting values (1343,431,12);
insert into casting values (1456,431,6);
insert into casting values (1606,431,11);
insert into casting values (139,431,7);
insert into casting values (175,431,12);
insert into casting values (68,431,9);
insert into casting values (73,431,5);
insert into casting values (351,431,6);
insert into casting values (295,431,6);
insert into casting values (462,431,3);
insert into casting values (746,432,5);
insert into casting values (828,432,3);
insert into casting values (1162,432,2);
insert into casting values (1335,432,13);
insert into casting values (1221,432,5);
insert into casting values (1814,432,10);
insert into casting values (243,432,12);
insert into casting values (270,432,5);
insert into casting values (547,432,9);
insert into casting values (598,432,2);
insert into casting values (544,432,3);
insert into casting values (1155,433,7);
insert into casting values (1239,433,7);
insert into casting values (1736,433,5);
insert into casting values (1812,433,4);
insert into casting values (1676,433,10);
insert into casting values (1486,433,13);
insert into casting values (1706,433,4);
insert into casting values (176,433,7);
--- tabcasting, 3501, 50
insert into casting values (268,433,3);
insert into casting values (125,433,4);
insert into casting values (19,433,9);
insert into casting values (547,433,7);
insert into casting values (449,433,12);
insert into casting values (1026,434,3);
insert into casting values (1225,434,6);
insert into casting values (1754,434,4);
insert into casting values (1519,434,4);
insert into casting values (1534,434,7);
insert into casting values (113,434,6);
insert into casting values (364,434,14);
insert into casting values (51,434,9);
insert into casting values (470,434,5);
insert into casting values (492,434,5);
insert into casting values (423,434,6);
insert into casting values (451,434,10);
insert into casting values (1109,435,12);
insert into casting values (1456,435,5);
insert into casting values (1759,435,9);
insert into casting values (1527,435,10);
insert into casting values (1603,435,6);
insert into casting values (1553,435,2);
insert into casting values (1515,435,1);
insert into casting values (319,435,4);
insert into casting values (400,435,5);
insert into casting values (492,435,6);
insert into casting values (1250,436,1);
insert into casting values (1494,436,7);
insert into casting values (1733,436,5);
insert into casting values (36,436,12);
insert into casting values (208,436,4);
insert into casting values (498,436,6);
insert into casting values (593,436,7);
insert into casting values (714,436,6);
insert into casting values (837,437,5);
insert into casting values (1106,437,8);
insert into casting values (1727,437,12);
insert into casting values (1528,437,11);
insert into casting values (1662,437,9);
insert into casting values (1560,437,9);
insert into casting values (310,437,5);
insert into casting values (14,437,5);
insert into casting values (232,437,6);
insert into casting values (601,437,4);
insert into casting values (596,437,6);
insert into casting values (761,438,3);
insert into casting values (834,438,8);
insert into casting values (1236,438,1);
insert into casting values (1580,438,1);
--- tabcasting, 3551, 50
insert into casting values (35,438,5);
insert into casting values (195,438,11);
insert into casting values (363,438,2);
insert into casting values (573,438,13);
insert into casting values (941,439,4);
insert into casting values (1149,439,7);
insert into casting values (1151,439,5);
insert into casting values (136,439,4);
insert into casting values (110,439,6);
insert into casting values (96,439,12);
insert into casting values (64,439,7);
insert into casting values (76,439,4);
insert into casting values (166,439,11);
insert into casting values (228,439,5);
insert into casting values (663,439,2);
insert into casting values (1058,440,2);
insert into casting values (1673,440,12);
insert into casting values (216,440,1);
insert into casting values (52,440,1);
insert into casting values (727,440,1);
insert into casting values (444,440,9);
insert into casting values (733,441,2);
insert into casting values (767,441,11);
insert into casting values (1256,441,3);
insert into casting values (1240,441,4);
insert into casting values (1376,441,3);
insert into casting values (1490,441,2);
insert into casting values (196,441,4);
insert into casting values (6,441,6);
insert into casting values (1205,442,3);
insert into casting values (1784,442,5);
insert into casting values (1511,442,1);
insert into casting values (274,442,2);
insert into casting values (32,442,2);
insert into casting values (620,442,6);
insert into casting values (688,442,3);
insert into casting values (670,442,11);
insert into casting values (1114,443,9);
insert into casting values (1342,443,7);
insert into casting values (1477,443,9);
insert into casting values (1510,443,6);
insert into casting values (176,443,5);
insert into casting values (90,443,6);
insert into casting values (268,443,5);
insert into casting values (127,443,7);
insert into casting values (85,443,6);
insert into casting values (448,443,3);
insert into casting values (382,443,4);
insert into casting values (515,443,15);
insert into casting values (294,444,7);
--- tabcasting, 3601, 50
insert into casting values (114,444,3);
insert into casting values (39,444,10);
insert into casting values (71,445,6);
insert into casting values (98,445,8);
insert into casting values (95,445,6);
insert into casting values (904,446,6);
insert into casting values (741,446,5);
insert into casting values (1292,446,3);
insert into casting values (1378,446,2);
insert into casting values (1383,446,3);
insert into casting values (1824,446,2);
insert into casting values (1663,446,5);
insert into casting values (228,446,3);
insert into casting values (1187,447,4);
insert into casting values (1219,447,8);
insert into casting values (1594,447,1);
insert into casting values (1625,447,1);
insert into casting values (624,447,1);
insert into casting values (943,448,2);
insert into casting values (1184,448,5);
insert into casting values (1507,448,4);
insert into casting values (206,448,1);
insert into casting values (139,448,9);
insert into casting values (509,448,1);
insert into casting values (819,449,4);
insert into casting values (860,449,6);
insert into casting values (1334,449,4);
insert into casting values (1666,449,8);
insert into casting values (1819,449,5);
insert into casting values (69,449,3);
insert into casting values (228,449,7);
insert into casting values (246,449,8);
insert into casting values (296,449,6);
insert into casting values (446,449,3);
insert into casting values (959,450,4);
insert into casting values (736,450,3);
insert into casting values (995,450,3);
insert into casting values (762,450,3);
insert into casting values (1106,450,3);
insert into casting values (342,450,6);
insert into casting values (261,450,3);
insert into casting values (607,450,3);
insert into casting values (1032,451,4);
insert into casting values (825,451,4);
insert into casting values (1537,451,4);
insert into casting values (1757,451,1);
insert into casting values (1541,451,8);
insert into casting values (173,451,6);
insert into casting values (145,451,8);
insert into casting values (426,451,4);
--- tabcasting, 3651, 50
insert into casting values (757,452,3);
insert into casting values (980,452,2);
insert into casting values (1291,452,3);
insert into casting values (1198,452,1);
insert into casting values (276,452,2);
insert into casting values (506,452,8);
insert into casting values (636,452,3);
insert into casting values (884,453,8);
insert into casting values (1365,453,3);
insert into casting values (1412,453,2);
insert into casting values (1795,453,3);
insert into casting values (1751,453,5);
insert into casting values (312,453,8);
insert into casting values (159,453,6);
insert into casting values (390,453,5);
insert into casting values (400,453,4);
insert into casting values (1001,454,3);
insert into casting values (1035,454,3);
insert into casting values (1116,454,8);
insert into casting values (1573,454,2);
insert into casting values (1556,454,1);
insert into casting values (232,454,4);
insert into casting values (899,455,8);
insert into casting values (1541,455,7);
insert into casting values (1516,455,2);
insert into casting values (1606,455,8);
insert into casting values (233,455,9);
insert into casting values (296,455,5);
insert into casting values (172,455,3);
insert into casting values (152,455,6);
insert into casting values (573,455,4);
insert into casting values (503,455,3);
insert into casting values (769,456,8);
insert into casting values (1392,456,1);
insert into casting values (1844,456,4);
insert into casting values (1822,456,3);
insert into casting values (1541,456,4);
insert into casting values (1659,456,5);
insert into casting values (174,456,8);
insert into casting values (414,456,8);
insert into casting values (899,457,5);
insert into casting values (1427,457,4);
insert into casting values (1354,457,6);
insert into casting values (193,457,1);
insert into casting values (96,457,9);
insert into casting values (536,457,4);
insert into casting values (399,457,6);
insert into casting values (487,457,2);
insert into casting values (934,458,14);
insert into casting values (973,458,5);
--- tabcasting, 3701, 50
insert into casting values (808,458,10);
insert into casting values (1310,458,8);
insert into casting values (1431,458,6);
insert into casting values (1313,458,13);
insert into casting values (1541,458,9);
insert into casting values (126,458,5);
insert into casting values (408,458,4);
insert into casting values (571,458,5);
insert into casting values (532,458,5);
insert into casting values (385,458,6);
insert into casting values (648,458,11);
insert into casting values (1053,459,7);
insert into casting values (964,459,3);
insert into casting values (1176,459,9);
insert into casting values (1394,459,4);
insert into casting values (1510,459,2);
insert into casting values (1742,459,9);
insert into casting values (1802,459,5);
insert into casting values (188,459,8);
insert into casting values (124,459,13);
insert into casting values (127,459,12);
insert into casting values (267,459,9);
insert into casting values (630,459,8);
insert into casting values (585,459,10);
insert into casting values (858,460,14);
insert into casting values (1026,460,4);
insert into casting values (790,460,7);
insert into casting values (930,460,2);
insert into casting values (1528,460,7);
insert into casting values (1618,460,10);
insert into casting values (1576,460,8);
insert into casting values (6,460,9);
insert into casting values (443,460,1);
insert into casting values (586,460,5);
insert into casting values (1026,461,5);
insert into casting values (1036,461,13);
insert into casting values (964,461,2);
insert into casting values (825,461,3);
insert into casting values (1455,461,3);
insert into casting values (1784,461,3);
insert into casting values (114,461,15);
insert into casting values (406,461,3);
insert into casting values (842,462,3);
insert into casting values (1156,462,13);
insert into casting values (1493,462,5);
insert into casting values (13,462,3);
insert into casting values (5,462,3);
insert into casting values (67,462,15);
insert into casting values (104,462,3);
insert into casting values (1,462,3);
--- tabcasting, 3751, 50
insert into casting values (705,462,2);
insert into casting values (737,463,4);
insert into casting values (1226,463,2);
insert into casting values (1206,463,2);
insert into casting values (529,463,1);
insert into casting values (570,463,1);
insert into casting values (972,464,10);
insert into casting values (955,464,2);
insert into casting values (1022,464,3);
insert into casting values (949,464,4);
insert into casting values (1070,464,2);
insert into casting values (1148,464,3);
insert into casting values (1158,464,3);
insert into casting values (1736,464,8);
insert into casting values (675,464,8);
insert into casting values (1026,465,1);
insert into casting values (909,465,1);
insert into casting values (1119,465,1);
insert into casting values (1565,465,5);
insert into casting values (426,465,10);
insert into casting values (821,466,3);
insert into casting values (1412,466,1);
insert into casting values (1428,466,2);
insert into casting values (1719,466,2);
insert into casting values (131,466,3);
insert into casting values (220,466,12);
insert into casting values (543,466,4);
insert into casting values (946,467,3);
insert into casting values (1669,467,3);
insert into casting values (1767,467,3);
insert into casting values (1624,467,2);
insert into casting values (146,467,11);
insert into casting values (263,467,5);
insert into casting values (198,467,4);
insert into casting values (487,467,3);
insert into casting values (940,468,10);
insert into casting values (1139,468,1);
insert into casting values (1450,468,4);
insert into casting values (1638,468,1);
insert into casting values (320,468,1);
insert into casting values (1128,469,2);
insert into casting values (310,469,1);
insert into casting values (174,469,1);
insert into casting values (19,469,1);
insert into casting values (426,469,11);
insert into casting values (755,470,7);
insert into casting values (1122,470,5);
insert into casting values (1840,470,2);
insert into casting values (1551,470,1);
insert into casting values (495,470,2);
--- tabcasting, 3801, 50
insert into casting values (704,470,11);
insert into casting values (408,470,7);
insert into casting values (1077,471,6);
insert into casting values (1192,471,7);
insert into casting values (1351,471,4);
insert into casting values (1136,471,4);
insert into casting values (1645,471,5);
insert into casting values (260,471,5);
insert into casting values (109,471,9);
insert into casting values (406,471,11);
insert into casting values (449,471,9);
insert into casting values (440,471,2);
insert into casting values (857,472,4);
insert into casting values (1289,472,5);
insert into casting values (1335,472,8);
insert into casting values (1206,472,3);
insert into casting values (295,472,4);
insert into casting values (271,472,7);
insert into casting values (719,472,12);
insert into casting values (419,472,3);
insert into casting values (591,472,4);
insert into casting values (865,473,2);
insert into casting values (979,473,2);
insert into casting values (1233,473,7);
insert into casting values (1685,473,3);
insert into casting values (1728,473,8);
insert into casting values (542,473,4);
insert into casting values (624,473,3);
insert into casting values (606,473,3);
insert into casting values (879,474,5);
insert into casting values (1725,474,2);
insert into casting values (1799,474,3);
insert into casting values (326,474,1);
insert into casting values (644,474,5);
insert into casting values (409,474,2);
insert into casting values (980,475,3);
insert into casting values (745,475,1);
insert into casting values (1469,475,2);
insert into casting values (1657,475,4);
insert into casting values (106,475,2);
insert into casting values (285,475,7);
insert into casting values (37,475,7);
insert into casting values (857,476,5);
insert into casting values (896,476,7);
insert into casting values (1700,476,5);
insert into casting values (1771,476,8);
insert into casting values (650,476,3);
insert into casting values (367,476,3);
insert into casting values (377,476,2);
insert into casting values (517,476,3);
--- tabcasting, 3851, 50
insert into casting values (895,477,1);
insert into casting values (893,477,8);
insert into casting values (1434,477,1);
insert into casting values (114,477,7);
insert into casting values (294,477,4);
insert into casting values (699,477,4);
insert into casting values (1032,478,3);
insert into casting values (1041,478,4);
insert into casting values (1743,478,1);
insert into casting values (44,478,4);
insert into casting values (418,478,3);
insert into casting values (494,478,4);
insert into casting values (785,479,4);
insert into casting values (1379,479,7);
insert into casting values (1660,479,6);
insert into casting values (1618,479,1);
insert into casting values (41,479,2);
insert into casting values (376,479,1);
insert into casting values (987,480,3);
insert into casting values (1431,480,1);
insert into casting values (1263,480,5);
insert into casting values (451,480,2);
insert into casting values (1396,481,1);
insert into casting values (1448,481,1);
insert into casting values (1241,481,3);
insert into casting values (32,481,4);
insert into casting values (574,481,4);
insert into casting values (1048,482,8);
insert into casting values (1152,482,11);
insert into casting values (1519,482,5);
insert into casting values (1769,482,5);
insert into casting values (1553,482,4);
insert into casting values (21,482,10);
insert into casting values (57,482,11);
insert into casting values (116,482,14);
insert into casting values (179,482,5);
insert into casting values (69,482,4);
insert into casting values (508,482,12);
insert into casting values (648,482,5);
insert into casting values (746,483,1);
insert into casting values (1205,483,1);
insert into casting values (1511,483,2);
insert into casting values (206,483,2);
insert into casting values (446,483,2);
insert into casting values (744,484,6);
insert into casting values (1827,484,9);
insert into casting values (1666,484,5);
insert into casting values (1475,484,3);
insert into casting values (322,484,9);
insert into casting values (287,484,3);
--- tabcasting, 3901, 50
insert into casting values (279,484,6);
insert into casting values (273,484,4);
insert into casting values (191,484,5);
insert into casting values (1263,485,2);
insert into casting values (1599,485,5);
insert into casting values (8,485,3);
insert into casting values (1089,486,1);
insert into casting values (1388,486,7);
insert into casting values (1806,486,1);
insert into casting values (1551,486,9);
insert into casting values (132,486,1);
insert into casting values (866,487,4);
insert into casting values (1045,487,5);
insert into casting values (1806,487,3);
insert into casting values (322,487,2);
insert into casting values (354,487,2);
insert into casting values (523,487,2);
insert into casting values (494,487,2);
insert into casting values (1229,488,1);
insert into casting values (1221,488,3);
insert into casting values (1798,488,3);
insert into casting values (353,488,7);
insert into casting values (214,488,9);
insert into casting values (576,488,4);
insert into casting values (423,488,2);
insert into casting values (982,489,2);
insert into casting values (1084,490,9);
insert into casting values (1257,490,4);
insert into casting values (1438,490,3);
insert into casting values (1783,490,8);
insert into casting values (1657,490,3);
insert into casting values (1670,490,1);
insert into casting values (1598,490,2);
insert into casting values (737,491,2);
insert into casting values (1735,491,2);
insert into casting values (1513,491,1);
insert into casting values (107,491,5);
insert into casting values (200,491,1);
insert into casting values (1045,492,7);
insert into casting values (800,492,1);
insert into casting values (1296,492,6);
insert into casting values (1384,492,1);
insert into casting values (244,492,3);
insert into casting values (204,492,2);
insert into casting values (1397,493,2);
insert into casting values (1747,493,2);
insert into casting values (51,493,7);
insert into casting values (248,493,6);
insert into casting values (24,493,3);
insert into casting values (128,493,3);
--- tabcasting, 3951, 50
insert into casting values (46,493,2);
insert into casting values (946,494,5);
insert into casting values (1413,494,8);
insert into casting values (1738,494,2);
insert into casting values (1624,494,3);
insert into casting values (225,494,8);
insert into casting values (198,494,5);
insert into casting values (488,494,3);
insert into casting values (855,495,2);
insert into casting values (831,495,3);
insert into casting values (22,495,3);
insert into casting values (157,495,7);
insert into casting values (459,495,6);
insert into casting values (515,495,2);
insert into casting values (601,495,2);
insert into casting values (648,495,3);
insert into casting values (758,496,2);
insert into casting values (1336,496,1);
insert into casting values (1608,496,1);
insert into casting values (1658,496,1);
insert into casting values (968,497,1);
insert into casting values (913,497,1);
insert into casting values (1062,497,3);
insert into casting values (1160,497,1);
insert into casting values (816,498,6);
insert into casting values (1277,498,6);
insert into casting values (1618,498,3);
insert into casting values (286,498,4);
insert into casting values (130,498,4);
insert into casting values (275,498,5);
insert into casting values (530,498,4);
insert into casting values (396,498,4);
insert into casting values (761,499,2);
insert into casting values (1323,499,4);
insert into casting values (1252,499,2);
insert into casting values (1759,499,1);
insert into casting values (315,499,2);
insert into casting values (312,499,3);
insert into casting values (280,500,2);
insert into casting values (252,500,2);
insert into casting values (68,500,2);
insert into casting values (850,501,1);
insert into casting values (860,501,7);
insert into casting values (1161,501,7);
insert into casting values (1354,501,3);
insert into casting values (1313,501,9);
insert into casting values (1180,501,4);
insert into casting values (547,501,3);
insert into casting values (372,501,6);
insert into casting values (762,502,2);
--- tabcasting, 4001, 50
insert into casting values (995,502,2);
insert into casting values (736,502,2);
insert into casting values (12,502,7);
insert into casting values (261,502,2);
insert into casting values (61,502,6);
insert into casting values (437,502,3);
insert into casting values (607,502,2);
insert into casting values (985,503,1);
insert into casting values (1376,503,10);
insert into casting values (1812,503,11);
insert into casting values (1814,503,2);
insert into casting values (281,503,2);
insert into casting values (298,503,2);
insert into casting values (140,503,12);
insert into casting values (70,503,14);
insert into casting values (524,503,12);
insert into casting values (512,503,2);
insert into casting values (743,504,4);
insert into casting values (904,504,4);
insert into casting values (220,504,3);
insert into casting values (347,504,4);
insert into casting values (705,504,5);
insert into casting values (730,504,4);
insert into casting values (670,504,3);
insert into casting values (133,505,2);
insert into casting values (934,506,7);
insert into casting values (1132,506,6);
insert into casting values (1392,506,9);
insert into casting values (1840,506,6);
insert into casting values (1547,506,7);
insert into casting values (1509,506,11);
insert into casting values (279,506,10);
insert into casting values (289,506,4);
insert into casting values (339,506,8);
insert into casting values (327,506,5);
insert into casting values (511,506,10);
insert into casting values (507,506,6);
insert into casting values (500,506,6);
insert into casting values (475,506,8);
insert into casting values (1053,507,9);
insert into casting values (1785,507,3);
insert into casting values (162,507,11);
insert into casting values (2,507,3);
insert into casting values (273,507,5);
insert into casting values (188,507,6);
insert into casting values (369,507,6);
insert into casting values (415,507,5);
insert into casting values (599,507,15);
insert into casting values (382,507,5);
insert into casting values (991,508,3);
--- tabcasting, 4051, 50
insert into casting values (1291,508,14);
insert into casting values (1365,508,8);
insert into casting values (1814,508,12);
insert into casting values (1683,508,1);
insert into casting values (1714,508,7);
insert into casting values (363,508,4);
insert into casting values (283,508,4);
insert into casting values (713,508,7);
insert into casting values (643,508,10);
insert into casting values (1033,509,6);
insert into casting values (1604,509,10);
insert into casting values (190,509,3);
insert into casting values (64,509,4);
insert into casting values (52,509,12);
insert into casting values (556,509,5);
insert into casting values (415,509,3);
insert into casting values (955,510,3);
insert into casting values (1070,510,3);
insert into casting values (1022,510,4);
insert into casting values (949,510,3);
insert into casting values (1158,510,2);
insert into casting values (1148,510,4);
insert into casting values (1434,510,15);
insert into casting values (195,510,8);
insert into casting values (675,510,10);
insert into casting values (816,511,4);
insert into casting values (1458,511,1);
insert into casting values (1782,511,2);
insert into casting values (270,511,15);
insert into casting values (180,511,15);
insert into casting values (224,511,6);
insert into casting values (320,511,4);
insert into casting values (597,511,4);
insert into casting values (1146,512,1);
insert into casting values (1351,512,2);
insert into casting values (1404,512,2);
insert into casting values (1737,512,15);
insert into casting values (364,512,10);
insert into casting values (69,512,1);
insert into casting values (531,512,6);
insert into casting values (786,513,3);
insert into casting values (1333,513,1);
insert into casting values (1377,513,10);
insert into casting values (1410,513,6);
insert into casting values (1365,513,11);
insert into casting values (1726,513,3);
insert into casting values (139,513,4);
insert into casting values (79,513,8);
insert into casting values (523,513,8);
insert into casting values (831,514,2);
--- tabcasting, 4101, 50
insert into casting values (1268,514,12);
insert into casting values (365,514,6);
insert into casting values (138,514,1);
insert into casting values (287,514,1);
insert into casting values (642,514,15);
insert into casting values (373,514,3);
insert into casting values (1009,515,13);
insert into casting values (1097,515,3);
insert into casting values (789,515,5);
insert into casting values (1378,515,5);
insert into casting values (1123,515,3);
insert into casting values (1532,515,10);
insert into casting values (1569,515,6);
insert into casting values (30,515,7);
insert into casting values (246,515,6);
insert into casting values (14,515,8);
insert into casting values (545,515,8);
insert into casting values (1012,516,5);
insert into casting values (1003,516,5);
insert into casting values (1229,516,3);
insert into casting values (1495,516,6);
insert into casting values (1681,516,4);
insert into casting values (134,516,13);
insert into casting values (117,516,7);
insert into casting values (20,516,11);
insert into casting values (151,516,5);
insert into casting values (605,516,6);
insert into casting values (933,517,3);
insert into casting values (1157,517,8);
insert into casting values (1765,517,11);
insert into casting values (1607,517,4);
insert into casting values (1798,517,6);
insert into casting values (1758,517,2);
insert into casting values (136,517,7);
insert into casting values (427,517,1);
insert into casting values (784,518,7);
insert into casting values (1132,518,5);
insert into casting values (1370,518,3);
insert into casting values (228,518,2);
insert into casting values (94,518,8);
insert into casting values (132,518,5);
insert into casting values (603,518,6);
insert into casting values (524,518,15);
insert into casting values (724,518,2);
insert into casting values (994,519,3);
insert into casting values (1053,519,4);
insert into casting values (802,519,7);
insert into casting values (813,519,3);
insert into casting values (1589,519,2);
insert into casting values (186,519,3);
--- tabcasting, 4151, 50
insert into casting values (171,519,2);
insert into casting values (410,519,14);
insert into casting values (1048,520,6);
insert into casting values (969,520,6);
insert into casting values (1050,520,5);
insert into casting values (1077,520,7);
insert into casting values (1223,520,5);
insert into casting values (1785,520,7);
insert into casting values (78,520,4);
insert into casting values (201,520,6);
insert into casting values (207,520,12);
insert into casting values (186,520,8);
insert into casting values (648,520,7);
insert into casting values (1007,521,6);
insert into casting values (862,521,6);
insert into casting values (1407,521,8);
insert into casting values (1235,521,4);
insert into casting values (1694,521,3);
insert into casting values (1611,521,5);
insert into casting values (179,521,4);
insert into casting values (430,521,11);
insert into casting values (450,521,3);
insert into casting values (916,522,1);
insert into casting values (1827,522,4);
insert into casting values (1606,522,13);
insert into casting values (1621,522,7);
insert into casting values (1640,522,8);
insert into casting values (428,522,9);
insert into casting values (368,522,3);
insert into casting values (808,523,2);
insert into casting values (1045,523,6);
insert into casting values (988,523,9);
insert into casting values (1431,523,2);
insert into casting values (1175,523,6);
insert into casting values (1153,523,12);
insert into casting values (170,523,8);
insert into casting values (800,524,2);
insert into casting values (1025,524,2);
insert into casting values (1596,524,7);
insert into casting values (294,524,2);
insert into casting values (114,524,6);
insert into casting values (98,524,5);
insert into casting values (310,524,4);
insert into casting values (411,524,6);
insert into casting values (595,524,15);
insert into casting values (89,525,1);
insert into casting values (202,525,9);
insert into casting values (178,525,2);
insert into casting values (434,525,3);
insert into casting values (432,525,3);
--- tabcasting, 4201, 50
insert into casting values (543,525,7);
insert into casting values (574,525,9);
insert into casting values (909,526,4);
insert into casting values (1153,526,3);
insert into casting values (1227,526,1);
insert into casting values (224,526,5);
insert into casting values (140,526,10);
insert into casting values (419,526,5);
insert into casting values (631,526,6);
insert into casting values (1580,527,10);
insert into casting values (1508,527,3);
insert into casting values (1744,527,7);
insert into casting values (1769,527,7);
insert into casting values (37,527,3);
insert into casting values (11,527,7);
insert into casting values (468,527,1);
insert into casting values (556,527,3);
insert into casting values (1093,528,14);
insert into casting values (832,528,8);
insert into casting values (886,528,6);
insert into casting values (1409,528,7);
insert into casting values (1718,528,4);
insert into casting values (155,528,7);
insert into casting values (251,528,4);
insert into casting values (134,528,6);
insert into casting values (6,528,4);
insert into casting values (418,528,6);
insert into casting values (379,528,7);
insert into casting values (977,529,1);
insert into casting values (934,529,10);
insert into casting values (1770,529,6);
insert into casting values (1829,529,3);
insert into casting values (192,529,3);
insert into casting values (267,529,4);
insert into casting values (670,529,2);
insert into casting values (1403,530,13);
insert into casting values (1284,530,3);
insert into casting values (1807,530,3);
insert into casting values (1756,530,5);
insert into casting values (1795,530,4);
insert into casting values (1730,530,4);
insert into casting values (168,530,6);
insert into casting values (491,530,4);
insert into casting values (927,531,8);
insert into casting values (893,531,9);
insert into casting values (1341,531,5);
insert into casting values (1471,531,9);
insert into casting values (1204,531,10);
insert into casting values (1636,531,2);
insert into casting values (239,531,6);
--- tabcasting, 4251, 50
insert into casting values (166,531,8);
insert into casting values (323,531,3);
insert into casting values (554,531,4);
insert into casting values (209,532,4);
insert into casting values (280,532,9);
insert into casting values (349,532,4);
insert into casting values (472,532,4);
insert into casting values (410,532,4);
insert into casting values (438,532,3);
insert into casting values (402,532,4);
insert into casting values (1445,533,2);
insert into casting values (1313,533,8);
insert into casting values (1428,533,4);
insert into casting values (1471,533,4);
insert into casting values (1690,533,1);
insert into casting values (449,533,3);
insert into casting values (1365,534,2);
insert into casting values (1246,534,3);
insert into casting values (1258,534,3);
insert into casting values (1466,534,2);
insert into casting values (1676,534,6);
insert into casting values (584,534,2);
insert into casting values (447,534,5);
insert into casting values (1056,535,5);
insert into casting values (1457,535,2);
insert into casting values (1566,535,2);
insert into casting values (1730,535,2);
insert into casting values (184,535,3);
insert into casting values (364,535,7);
insert into casting values (553,535,8);
insert into casting values (616,535,6);
insert into casting values (902,536,4);
insert into casting values (1240,536,3);
insert into casting values (1629,536,1);
insert into casting values (36,536,8);
insert into casting values (278,536,3);
insert into casting values (16,536,2);
insert into casting values (1050,537,4);
insert into casting values (1807,537,5);
insert into casting values (203,537,4);
insert into casting values (289,537,5);
insert into casting values (676,537,8);
insert into casting values (1440,538,8);
insert into casting values (1201,538,5);
insert into casting values (1535,538,1);
insert into casting values (463,538,5);
insert into casting values (500,538,2);
insert into casting values (369,538,4);
insert into casting values (827,539,1);
insert into casting values (740,539,7);
--- tabcasting, 4301, 50
insert into casting values (1395,539,1);
insert into casting values (1159,539,1);
insert into casting values (925,540,4);
insert into casting values (880,540,6);
insert into casting values (1370,540,5);
insert into casting values (1316,540,4);
insert into casting values (1404,540,4);
insert into casting values (1358,540,7);
insert into casting values (403,540,7);
insert into casting values (647,540,4);
insert into casting values (1019,541,1);
insert into casting values (900,541,5);
insert into casting values (1147,541,1);
insert into casting values (1506,541,6);
insert into casting values (186,541,6);
insert into casting values (1044,542,1);
insert into casting values (1700,542,1);
insert into casting values (1788,542,1);
insert into casting values (120,542,7);
insert into casting values (1066,543,1);
insert into casting values (1826,543,3);
insert into casting values (647,543,2);
insert into casting values (394,543,2);
insert into casting values (335,544,1);
insert into casting values (158,544,1);
insert into casting values (361,544,8);
insert into casting values (461,544,1);
insert into casting values (1056,545,10);
insert into casting values (1356,545,4);
insert into casting values (1470,545,10);
insert into casting values (1380,545,2);
insert into casting values (1762,545,3);
insert into casting values (1525,545,9);
insert into casting values (1581,545,1);
insert into casting values (546,545,9);
insert into casting values (617,545,11);
insert into casting values (1212,546,5);
insert into casting values (1152,546,4);
insert into casting values (1705,546,7);
insert into casting values (1549,546,12);
insert into casting values (356,546,10);
insert into casting values (13,546,10);
insert into casting values (120,546,6);
insert into casting values (96,546,5);
insert into casting values (41,546,7);
insert into casting values (403,546,2);
insert into casting values (431,546,9);
insert into casting values (928,547,13);
insert into casting values (849,547,7);
insert into casting values (1325,547,7);
--- tabcasting, 4351, 50
insert into casting values (1462,547,4);
insert into casting values (1195,547,15);
insert into casting values (1577,547,7);
insert into casting values (1509,547,12);
insert into casting values (511,547,9);
insert into casting values (413,547,6);
insert into casting values (645,547,7);
insert into casting values (615,547,5);
insert into casting values (524,547,8);
insert into casting values (943,548,8);
insert into casting values (1288,548,4);
insert into casting values (1183,548,9);
insert into casting values (1116,548,12);
insert into casting values (1334,548,3);
insert into casting values (234,548,11);
insert into casting values (353,548,4);
insert into casting values (191,548,6);
insert into casting values (531,548,13);
insert into casting values (595,548,6);
insert into casting values (414,548,4);
insert into casting values (843,549,14);
insert into casting values (1009,549,6);
insert into casting values (1590,549,3);
insert into casting values (186,549,11);
insert into casting values (325,549,1);
insert into casting values (62,549,5);
insert into casting values (370,549,3);
insert into casting values (559,549,7);
insert into casting values (832,550,3);
insert into casting values (1379,550,3);
insert into casting values (1584,550,2);
insert into casting values (301,550,4);
insert into casting values (448,550,12);
insert into casting values (516,550,1);
insert into casting values (710,550,15);
insert into casting values (1069,551,4);
insert into casting values (946,551,2);
insert into casting values (1118,551,6);
insert into casting values (1628,551,3);
insert into casting values (1572,551,5);
insert into casting values (1641,551,2);
insert into casting values (719,551,13);
insert into casting values (631,551,13);
insert into casting values (1432,552,11);
insert into casting values (1,552,1);
insert into casting values (5,552,1);
insert into casting values (13,552,1);
insert into casting values (1011,553,2);
insert into casting values (753,553,9);
insert into casting values (1141,553,3);
--- tabcasting, 4401, 50
insert into casting values (1204,553,12);
insert into casting values (284,553,1);
insert into casting values (562,553,4);
insert into casting values (568,553,8);
insert into casting values (811,554,5);
insert into casting values (1096,554,1);
insert into casting values (1322,554,8);
insert into casting values (1247,554,6);
insert into casting values (1605,554,4);
insert into casting values (542,554,3);
insert into casting values (588,554,10);
insert into casting values (893,555,6);
insert into casting values (1133,555,2);
insert into casting values (1170,555,6);
insert into casting values (1716,555,3);
insert into casting values (198,555,6);
insert into casting values (133,555,3);
insert into casting values (315,555,3);
insert into casting values (184,555,11);
insert into casting values (700,555,8);
insert into casting values (817,556,1);
insert into casting values (1395,556,10);
insert into casting values (1411,556,1);
insert into casting values (257,556,1);
insert into casting values (1377,557,14);
insert into casting values (1347,557,1);
insert into casting values (1387,557,1);
insert into casting values (374,557,1);
insert into casting values (1018,558,2);
insert into casting values (1259,558,10);
insert into casting values (1636,558,5);
insert into casting values (1814,558,8);
insert into casting values (208,558,6);
insert into casting values (63,558,2);
insert into casting values (501,558,3);
insert into casting values (625,558,4);
insert into casting values (887,559,7);
insert into casting values (238,559,5);
insert into casting values (17,559,15);
insert into casting values (233,559,8);
insert into casting values (313,559,4);
insert into casting values (463,559,1);
insert into casting values (467,559,5);
insert into casting values (953,560,6);
insert into casting values (746,560,7);
insert into casting values (1377,560,6);
insert into casting values (1701,560,7);
insert into casting values (1510,560,1);
insert into casting values (186,560,5);
insert into casting values (127,560,6);
--- tabcasting, 4451, 50
insert into casting values (176,560,9);
insert into casting values (495,560,12);
insert into casting values (1096,561,2);
insert into casting values (811,561,6);
insert into casting values (1114,561,2);
insert into casting values (1605,561,10);
insert into casting values (307,561,4);
insert into casting values (257,561,2);
insert into casting values (542,561,8);
insert into casting values (581,561,2);
insert into casting values (1796,562,14);
insert into casting values (1017,563,9);
insert into casting values (1654,563,2);
insert into casting values (1594,563,5);
insert into casting values (319,563,10);
insert into casting values (590,563,7);
insert into casting values (691,563,3);
insert into casting values (470,563,3);
insert into casting values (373,563,5);
insert into casting values (1037,564,5);
insert into casting values (1039,564,5);
insert into casting values (1374,564,7);
insert into casting values (1136,564,13);
insert into casting values (1494,564,8);
insert into casting values (323,564,4);
insert into casting values (393,564,8);
insert into casting values (697,564,9);
insert into casting values (621,564,5);
insert into casting values (882,565,12);
insert into casting values (1429,565,3);
insert into casting values (1828,565,2);
insert into casting values (1555,565,2);
insert into casting values (333,565,1);
insert into casting values (588,565,3);
insert into casting values (856,566,8);
insert into casting values (1020,566,1);
insert into casting values (1814,566,7);
insert into casting values (1545,566,4);
insert into casting values (231,566,5);
insert into casting values (246,566,10);
insert into casting values (591,566,5);
insert into casting values (770,567,4);
insert into casting values (882,567,5);
insert into casting values (1431,567,4);
insert into casting values (1706,567,7);
insert into casting values (352,567,4);
insert into casting values (482,567,12);
insert into casting values (1002,568,6);
insert into casting values (1084,568,2);
insert into casting values (1392,568,4);
--- tabcasting, 4501, 50
insert into casting values (1421,568,5);
insert into casting values (1840,568,3);
insert into casting values (68,568,8);
insert into casting values (459,568,5);
insert into casting values (593,568,11);
insert into casting values (830,569,3);
insert into casting values (1185,569,10);
insert into casting values (1767,569,1);
insert into casting values (1669,569,2);
insert into casting values (725,569,1);
insert into casting values (1032,570,7);
insert into casting values (911,570,3);
insert into casting values (1804,570,2);
insert into casting values (1829,570,2);
insert into casting values (1820,570,11);
insert into casting values (4,570,9);
insert into casting values (578,570,3);
insert into casting values (501,570,9);
insert into casting values (472,570,8);
insert into casting values (1142,578,4);
insert into casting values (1733,578,4);
insert into casting values (18,578,3);
insert into casting values (527,578,7);
insert into casting values (685,578,8);
insert into casting values (718,578,1);
insert into casting values (488,582,1);
insert into casting values (906,587,11);
insert into casting values (1195,587,1);
insert into casting values (1822,587,11);
insert into casting values (1519,587,13);
insert into casting values (1630,587,8);
insert into casting values (43,587,8);
insert into casting values (184,587,4);
insert into casting values (228,587,9);
insert into casting values (385,587,11);
insert into casting values (710,587,12);
insert into casting values (392,587,7);
insert into casting values (490,587,8);
insert into casting values (770,670,1);
insert into casting values (1438,670,1);
insert into casting values (1607,670,3);
insert into casting values (493,670,2);
insert into casting values (885,671,7);
insert into casting values (1115,671,6);
insert into casting values (1493,671,4);
insert into casting values (1594,671,3);
insert into casting values (1835,671,3);
insert into casting values (212,671,2);
insert into casting values (596,671,5);
insert into casting values (762,679,4);
--- tabcasting, 4551, 50
insert into casting values (736,679,4);
insert into casting values (261,679,4);
insert into casting values (291,679,5);
insert into casting values (203,679,2);
insert into casting values (607,679,4);
insert into casting values (1424,680,1);
insert into casting values (1487,680,2);
insert into casting values (36,680,3);
insert into casting values (323,680,1);
insert into casting values (953,681,4);
insert into casting values (853,681,8);
insert into casting values (1052,681,5);
insert into casting values (1191,681,5);
insert into casting values (1642,681,6);
insert into casting values (405,681,5);
insert into casting values (440,681,5);
insert into casting values (1294,682,9);
insert into casting values (1324,682,6);
insert into casting values (1560,682,2);
insert into casting values (1842,682,4);
insert into casting values (133,682,4);
insert into casting values (221,682,1);
insert into casting values (1290,684,1);
insert into casting values (116,684,2);
insert into casting values (215,684,1);
insert into casting values (57,684,2);
insert into casting values (1423,687,1);
insert into casting values (1271,687,7);
insert into casting values (1508,687,8);
insert into casting values (1601,687,1);
insert into casting values (143,687,4);
insert into casting values (974,688,4);
insert into casting values (1749,688,1);
insert into casting values (241,688,1);
insert into casting values (660,688,4);
insert into casting values (943,690,7);
insert into casting values (891,690,3);
insert into casting values (1006,690,6);
insert into casting values (788,690,5);
insert into casting values (1272,690,3);
insert into casting values (1775,690,8);
insert into casting values (245,690,2);
insert into casting values (223,690,6);
insert into casting values (1775,692,4);
insert into casting values (145,692,5);
insert into casting values (312,692,5);
insert into casting values (178,692,7);
insert into casting values (536,692,6);
insert into casting values (597,692,9);
insert into casting values (596,692,2);
--- tabcasting, 4601, 50
insert into casting values (652,692,9);
insert into casting values (1801,693,1);
insert into casting values (1237,694,4);
insert into casting values (1740,694,4);
insert into casting values (49,694,5);
insert into casting values (422,694,5);
insert into casting values (927,695,9);
insert into casting values (1341,695,2);
insert into casting values (1382,695,14);
insert into casting values (1782,695,15);
insert into casting values (1516,695,11);
insert into casting values (1583,695,1);
insert into casting values (224,695,3);
insert into casting values (317,695,10);
insert into casting values (927,696,15);
insert into casting values (1341,696,11);
insert into casting values (1274,696,3);
insert into casting values (1377,696,15);
insert into casting values (1412,696,13);
insert into casting values (1225,696,7);
insert into casting values (1842,696,3);
insert into casting values (133,696,5);
insert into casting values (636,696,4);
insert into casting values (642,696,4);
insert into casting values (999,697,12);
insert into casting values (1244,697,3);
insert into casting values (1425,697,3);
insert into casting values (1590,697,5);
insert into casting values (1733,697,3);
insert into casting values (308,697,5);
insert into casting values (144,697,10);
insert into casting values (428,697,8);
insert into casting values (616,697,12);
insert into casting values (939,698,7);
insert into casting values (763,698,8);
insert into casting values (1242,698,2);
insert into casting values (1475,698,6);
insert into casting values (56,698,9);
insert into casting values (113,698,10);
insert into casting values (58,698,13);
insert into casting values (360,698,5);
insert into casting values (664,698,14);
insert into casting values (420,698,4);
insert into casting values (572,698,6);
insert into casting values (807,699,10);
insert into casting values (965,699,4);
insert into casting values (1128,699,9);
insert into casting values (1793,699,2);
insert into casting values (1657,699,13);
insert into casting values (102,699,2);
--- tabcasting, 4651, 50
insert into casting values (206,699,6);
insert into casting values (127,699,8);
insert into casting values (359,699,3);
insert into casting values (822,700,1);
insert into casting values (1462,700,2);
insert into casting values (1425,700,2);
insert into casting values (1401,700,2);
insert into casting values (76,700,15);
insert into casting values (413,700,10);
insert into casting values (532,700,8);
insert into casting values (1540,701,6);
insert into casting values (1629,701,2);
insert into casting values (1761,701,3);
insert into casting values (270,701,6);
insert into casting values (144,701,13);
insert into casting values (279,701,7);
insert into casting values (634,701,11);
insert into casting values (632,701,5);
insert into casting values (761,702,5);
insert into casting values (898,702,10);
insert into casting values (944,702,1);
insert into casting values (780,702,12);
insert into casting values (1221,702,4);
insert into casting values (3,702,9);
insert into casting values (614,702,4);
insert into casting values (1275,703,14);
insert into casting values (38,703,5);
insert into casting values (262,703,10);
insert into casting values (325,703,3);
insert into casting values (497,703,4);
insert into casting values (512,703,5);
insert into casting values (612,703,3);
insert into casting values (495,703,6);
insert into casting values (1048,704,7);
insert into casting values (1271,704,2);
insert into casting values (1188,704,6);
insert into casting values (1557,704,7);
insert into casting values (1487,704,4);
insert into casting values (214,704,3);
insert into casting values (152,704,10);
insert into casting values (284,704,12);
insert into casting values (648,704,4);
insert into casting values (1472,705,3);
insert into casting values (1637,705,2);
insert into casting values (692,705,5);
insert into casting values (698,705,7);
insert into casting values (769,706,6);
insert into casting values (741,706,11);
insert into casting values (1079,706,4);
insert into casting values (1346,706,3);
--- tabcasting, 4701, 50
insert into casting values (1235,706,2);
insert into casting values (1491,706,4);
insert into casting values (392,706,2);
insert into casting values (844,707,13);
insert into casting values (882,707,9);
insert into casting values (1077,707,5);
insert into casting values (1051,707,4);
insert into casting values (1188,707,8);
insert into casting values (1300,707,9);
insert into casting values (1718,707,6);
insert into casting values (115,707,5);
insert into casting values (417,707,6);
insert into casting values (1046,708,2);
insert into casting values (1113,708,2);
insert into casting values (1528,708,4);
insert into casting values (277,708,2);
insert into casting values (204,708,3);
insert into casting values (138,708,9);
insert into casting values (389,708,12);
insert into casting values (813,709,8);
insert into casting values (941,709,12);
insert into casting values (1062,709,5);
insert into casting values (913,709,4);
insert into casting values (328,709,2);
insert into casting values (224,709,7);
insert into casting values (315,709,4);
insert into casting values (904,710,5);
insert into casting values (1285,710,8);
insert into casting values (1332,710,4);
insert into casting values (1294,710,8);
insert into casting values (1376,710,5);
insert into casting values (321,710,9);
insert into casting values (39,710,4);
insert into casting values (531,710,10);
insert into casting values (885,711,5);
insert into casting values (785,711,6);
insert into casting values (1379,711,10);
insert into casting values (1708,711,5);
insert into casting values (123,711,5);
insert into casting values (846,712,4);
insert into casting values (838,712,7);
insert into casting values (1133,712,9);
insert into casting values (1198,712,3);
insert into casting values (1765,712,5);
insert into casting values (1823,712,8);
insert into casting values (56,712,7);
insert into casting values (523,712,7);
insert into casting values (511,712,12);
insert into casting values (761,713,7);
insert into casting values (973,713,6);
--- tabcasting, 4751, 50
insert into casting values (964,713,5);
insert into casting values (1172,713,8);
insert into casting values (1491,713,3);
insert into casting values (1785,713,4);
insert into casting values (194,713,5);
insert into casting values (9,713,11);
insert into casting values (809,714,7);
insert into casting values (1458,714,7);
insert into casting values (1158,714,7);
insert into casting values (152,714,4);
insert into casting values (460,714,1);
insert into casting values (393,714,12);
insert into casting values (765,715,2);
insert into casting values (1115,715,8);
insert into casting values (1508,715,4);
insert into casting values (1770,715,4);
insert into casting values (147,715,2);
insert into casting values (679,715,3);
insert into casting values (620,715,10);
insert into casting values (881,716,4);
insert into casting values (1047,716,6);
insert into casting values (786,716,4);
insert into casting values (1286,716,1);
insert into casting values (33,716,10);
insert into casting values (556,716,2);
insert into casting values (909,717,2);
insert into casting values (1078,717,1);
insert into casting values (1636,717,3);
insert into casting values (1680,717,3);
insert into casting values (194,717,9);
insert into casting values (399,717,13);
insert into casting values (954,718,9);
insert into casting values (931,718,2);
insert into casting values (1180,718,5);
insert into casting values (1251,718,3);
insert into casting values (1802,718,6);
insert into casting values (1534,718,6);
insert into casting values (273,718,6);
insert into casting values (120,718,8);
insert into casting values (503,718,11);
insert into casting values (975,719,3);
insert into casting values (735,719,3);
insert into casting values (885,719,9);
insert into casting values (1226,719,3);
insert into casting values (1707,719,2);
insert into casting values (483,719,5);
insert into casting values (898,720,8);
insert into casting values (1138,720,9);
insert into casting values (254,720,9);
insert into casting values (895,721,2);
--- tabcasting, 4801, 50
insert into casting values (893,721,4);
insert into casting values (1434,721,2);
insert into casting values (1227,721,8);
insert into casting values (896,722,2);
insert into casting values (1044,722,9);
insert into casting values (945,722,2);
insert into casting values (1068,722,6);
insert into casting values (1182,722,6);
insert into casting values (483,722,2);
insert into casting values (594,722,3);
insert into casting values (992,723,3);
insert into casting values (790,723,1);
insert into casting values (1045,723,9);
insert into casting values (1675,723,4);
insert into casting values (1540,723,2);
insert into casting values (1030,724,6);
insert into casting values (1051,724,2);
insert into casting values (1391,724,6);
insert into casting values (145,724,4);
insert into casting values (92,724,4);
insert into casting values (411,724,7);
insert into casting values (727,724,2);
insert into casting values (1165,725,2);
insert into casting values (1343,725,1);
insert into casting values (161,725,6);
insert into casting values (487,725,1);
insert into casting values (1034,726,4);
insert into casting values (1421,726,8);
insert into casting values (1784,726,1);
insert into casting values (103,726,2);
insert into casting values (1316,727,2);
insert into casting values (1585,727,5);
insert into casting values (1518,727,8);
insert into casting values (1243,728,5);
insert into casting values (1268,728,6);
insert into casting values (173,728,5);
insert into casting values (10,728,8);
insert into casting values (730,728,6);
insert into casting values (387,728,2);
insert into casting values (645,728,4);
insert into casting values (841,729,4);
insert into casting values (942,729,3);
insert into casting values (1300,729,5);
insert into casting values (342,729,9);
insert into casting values (157,729,5);
insert into casting values (51,729,6);
insert into casting values (567,729,6);
insert into casting values (1023,730,8);
insert into casting values (1331,730,5);
insert into casting values (1432,730,3);
--- tabcasting, 4851, 50
insert into casting values (1639,730,9);
insert into casting values (42,730,7);
insert into casting values (1107,731,4);
insert into casting values (1337,731,4);
insert into casting values (1716,731,6);
insert into casting values (1724,731,1);
insert into casting values (123,731,4);
insert into casting values (907,732,5);
insert into casting values (742,732,8);
insert into casting values (789,732,4);
insert into casting values (1509,732,4);
insert into casting values (1813,732,3);
insert into casting values (86,732,8);
insert into casting values (511,732,6);
insert into casting values (1427,733,1);
insert into casting values (1365,733,1);
insert into casting values (250,733,4);
insert into casting values (392,733,6);
insert into casting values (1122,734,2);
insert into casting values (1338,734,2);
insert into casting values (1803,734,1);
insert into casting values (313,734,9);
insert into casting values (471,734,2);
insert into casting values (885,735,8);
insert into casting values (974,735,1);
insert into casting values (241,735,2);
insert into casting values (660,735,1);
insert into casting values (926,736,3);
insert into casting values (1048,736,4);
insert into casting values (1391,736,2);
insert into casting values (158,736,2);
insert into casting values (7,736,6);
insert into casting values (632,736,4);
insert into casting values (809,737,6);
insert into casting values (1136,737,1);
insert into casting values (1283,737,6);
insert into casting values (1284,737,4);
insert into casting values (347,737,3);
insert into casting values (792,738,3);
insert into casting values (1439,738,5);
insert into casting values (1399,738,1);
insert into casting values (1690,738,5);
insert into casting values (494,738,7);
insert into casting values (1645,739,4);
insert into casting values (1529,739,6);
insert into casting values (1659,739,3);
insert into casting values (127,739,5);
insert into casting values (305,739,3);
insert into casting values (572,739,4);
insert into casting values (1001,740,6);
--- tabcasting, 4901, 50
insert into casting values (892,740,5);
insert into casting values (1201,740,7);
insert into casting values (328,740,3);
insert into casting values (553,740,5);
insert into casting values (380,740,9);
insert into casting values (1001,741,5);
insert into casting values (788,741,2);
insert into casting values (1458,741,2);
insert into casting values (1535,741,2);
insert into casting values (318,741,2);
insert into casting values (685,741,7);
insert into casting values (794,742,2);
insert into casting values (1144,742,1);
insert into casting values (1220,742,6);
insert into casting values (1410,742,3);
insert into casting values (182,742,2);
insert into casting values (831,743,6);
insert into casting values (765,743,14);
insert into casting values (1457,743,13);
insert into casting values (1109,743,9);
insert into casting values (1421,743,15);
insert into casting values (1426,743,8);
insert into casting values (1358,743,6);
insert into casting values (1718,743,5);
insert into casting values (1617,743,3);
insert into casting values (1574,743,4);
insert into casting values (186,743,13);
insert into casting values (1055,744,5);
insert into casting values (930,744,14);
insert into casting values (1035,744,9);
insert into casting values (1053,744,5);
insert into casting values (1176,744,4);
insert into casting values (1264,744,11);
insert into casting values (1607,744,14);
insert into casting values (1684,744,13);
insert into casting values (285,744,5);
insert into casting values (319,744,9);
insert into casting values (758,745,5);
insert into casting values (1003,745,6);
insert into casting values (745,745,12);
insert into casting values (1468,745,3);
insert into casting values (1844,745,12);
insert into casting values (1512,745,9);
insert into casting values (213,745,6);
insert into casting values (251,745,10);
insert into casting values (240,745,9);
insert into casting values (374,745,8);
insert into casting values (941,746,7);
insert into casting values (986,746,11);
insert into casting values (1407,746,9);
--- tabcasting, 4951, 50
insert into casting values (1442,746,9);
insert into casting values (1569,746,5);
insert into casting values (47,746,15);
insert into casting values (78,746,5);
insert into casting values (272,746,5);
insert into casting values (337,746,14);
insert into casting values (669,746,8);
insert into casting values (818,747,2);
insert into casting values (1259,747,13);
insert into casting values (45,747,12);
insert into casting values (343,747,6);
insert into casting values (96,747,3);
insert into casting values (15,747,7);
insert into casting values (333,747,2);
insert into casting values (452,747,10);
insert into casting values (657,747,5);
insert into casting values (1114,748,8);
insert into casting values (1607,748,9);
insert into casting values (1514,748,5);
insert into casting values (1573,748,5);
insert into casting values (1842,748,7);
insert into casting values (243,748,3);
insert into casting values (296,748,11);
insert into casting values (382,748,6);
insert into casting values (527,748,10);
insert into casting values (626,748,12);
insert into casting values (732,749,18);
insert into casting values (1237,749,3);
insert into casting values (111,749,15);
insert into casting values (49,749,3);
insert into casting values (653,749,4);
insert into casting values (574,749,2);
insert into casting values (422,749,4);
insert into casting values (1217,750,1);
insert into casting values (1438,750,2);
insert into casting values (178,750,9);
insert into casting values (156,750,6);
insert into casting values (52,750,13);
insert into casting values (145,750,6);
insert into casting values (313,750,12);
insert into casting values (556,750,7);
insert into casting values (897,751,4);
insert into casting values (975,751,2);
insert into casting values (1708,751,3);
insert into casting values (251,751,15);
insert into casting values (507,751,11);
insert into casting values (471,751,4);
insert into casting values (486,751,4);
insert into casting values (962,752,2);
insert into casting values (1463,752,4);
--- tabcasting, 5001, 50
insert into casting values (1378,752,3);
insert into casting values (180,752,14);
insert into casting values (279,752,5);
insert into casting values (8,752,12);
insert into casting values (495,752,5);
insert into casting values (806,753,4);
insert into casting values (1735,753,4);
insert into casting values (1490,753,15);
insert into casting values (1597,753,4);
insert into casting values (286,753,5);
insert into casting values (48,753,9);
insert into casting values (688,753,9);
insert into casting values (410,753,13);
insert into casting values (280,754,10);
insert into casting values (209,754,5);
insert into casting values (349,754,6);
insert into casting values (438,754,5);
insert into casting values (402,754,6);
insert into casting values (410,754,5);
insert into casting values (472,754,5);
insert into casting values (891,755,8);
insert into casting values (1209,755,5);
insert into casting values (1383,755,7);
insert into casting values (1331,755,9);
insert into casting values (1802,755,12);
insert into casting values (1621,755,8);
insert into casting values (1808,755,10);
insert into casting values (327,755,13);
insert into casting values (117,755,6);
insert into casting values (191,755,13);
insert into casting values (530,755,11);
insert into casting values (600,755,8);
insert into casting values (663,755,12);
insert into casting values (538,755,6);
insert into casting values (1810,756,11);
insert into casting values (456,756,5);
insert into casting values (1018,757,3);
insert into casting values (985,757,3);
insert into casting values (1755,757,7);
insert into casting values (161,757,5);
insert into casting values (514,757,7);
insert into casting values (707,757,4);
insert into casting values (1084,758,3);
insert into casting values (838,758,2);
insert into casting values (886,758,7);
insert into casting values (586,758,2);
insert into casting values (618,758,15);
insert into casting values (1304,759,3);
insert into casting values (1432,759,2);
insert into casting values (1756,759,1);
--- tabcasting, 5051, 50
insert into casting values (1523,759,3);
insert into casting values (248,759,12);
insert into casting values (1001,760,1);
insert into casting values (866,760,3);
insert into casting values (1673,760,2);
insert into casting values (230,760,14);
insert into casting values (176,760,4);
insert into casting values (773,761,5);
insert into casting values (918,761,7);
insert into casting values (963,761,5);
insert into casting values (1812,761,3);
insert into casting values (1716,761,13);
insert into casting values (153,761,5);
insert into casting values (481,761,8);
insert into casting values (902,762,9);
insert into casting values (755,762,9);
insert into casting values (1250,762,13);
insert into casting values (1759,762,5);
insert into casting values (1629,762,5);
insert into casting values (186,762,7);
insert into casting values (160,762,9);
insert into casting values (535,762,3);
insert into casting values (898,763,13);
insert into casting values (1300,763,6);
insert into casting values (1705,763,3);
insert into casting values (1725,763,3);
insert into casting values (1660,763,8);
insert into casting values (28,763,2);
insert into casting values (204,763,5);
insert into casting values (1490,764,8);
insert into casting values (1605,764,1);
insert into casting values (1560,764,8);
insert into casting values (542,764,1);
insert into casting values (468,764,14);
insert into casting values (929,765,15);
insert into casting values (1092,765,2);
insert into casting values (1209,765,4);
insert into casting values (1116,765,6);
insert into casting values (1500,765,8);
insert into casting values (425,765,3);
insert into casting values (1014,766,3);
insert into casting values (1401,766,1);
insert into casting values (1690,766,6);
insert into casting values (26,766,14);
insert into casting values (148,766,9);
insert into casting values (4,766,3);
insert into casting values (985,767,9);
insert into casting values (1008,767,10);
insert into casting values (1071,767,3);
insert into casting values (947,767,6);
--- tabcasting, 5101, 50
insert into casting values (20,767,6);
insert into casting values (84,767,4);
insert into casting values (674,767,6);
insert into casting values (429,767,4);
insert into casting values (1331,768,4);
insert into casting values (1587,768,4);
insert into casting values (1505,768,1);
insert into casting values (330,768,14);
insert into casting values (411,768,5);
insert into casting values (1023,769,11);
insert into casting values (944,769,5);
insert into casting values (1668,769,8);
insert into casting values (275,769,3);
insert into casting values (495,769,4);
insert into casting values (530,769,5);
insert into casting values (942,770,8);
insert into casting values (82,770,6);
insert into casting values (316,770,4);
insert into casting values (458,770,1);
insert into casting values (515,770,11);
insert into casting values (1775,771,7);
insert into casting values (661,771,4);
insert into casting values (728,771,3);
insert into casting values (1052,772,2);
insert into casting values (831,772,5);
insert into casting values (1198,772,2);
insert into casting values (365,772,11);
insert into casting values (170,772,1);
insert into casting values (839,773,7);
insert into casting values (776,773,3);
insert into casting values (1128,773,6);
insert into casting values (1283,773,5);
insert into casting values (1149,773,5);
insert into casting values (92,773,11);
insert into casting values (531,773,2);
insert into casting values (1325,774,3);
insert into casting values (1572,774,4);
insert into casting values (1521,774,2);
insert into casting values (1523,774,6);
insert into casting values (345,774,8);
insert into casting values (564,774,2);
insert into casting values (714,774,14);
insert into casting values (769,775,10);
insert into casting values (962,775,5);
insert into casting values (1558,775,2);
insert into casting values (1547,775,3);
insert into casting values (99,775,8);
insert into casting values (293,775,3);
insert into casting values (432,775,6);
insert into casting values (1730,776,1);
--- tabcasting, 5151, 50
insert into casting values (1823,776,12);
insert into casting values (120,776,4);
insert into casting values (43,776,2);
insert into casting values (428,776,3);
insert into casting values (755,777,3);
insert into casting values (1250,777,5);
insert into casting values (618,777,4);
insert into casting values (535,777,1);
insert into casting values (710,777,13);
insert into casting values (967,778,3);
insert into casting values (735,778,13);
insert into casting values (1290,778,2);
insert into casting values (275,778,2);
insert into casting values (514,778,3);
insert into casting values (530,778,2);
insert into casting values (766,779,2);
insert into casting values (1396,779,4);
insert into casting values (1365,779,14);
insert into casting values (1538,779,5);
insert into casting values (75,779,3);
insert into casting values (102,779,3);
insert into casting values (1247,780,2);
insert into casting values (1189,780,4);
insert into casting values (40,780,2);
insert into casting values (288,780,1);
insert into casting values (1005,781,1);
insert into casting values (1283,781,3);
insert into casting values (83,781,2);
insert into casting values (243,781,2);
insert into casting values (256,782,3);
insert into casting values (53,782,6);
insert into casting values (712,782,3);
insert into casting values (503,782,1);
insert into casting values (634,782,8);
insert into casting values (1157,783,7);
insert into casting values (1113,783,3);
insert into casting values (1335,783,5);
insert into casting values (1661,783,1);
insert into casting values (1701,783,6);
insert into casting values (865,784,4);
insert into casting values (1331,784,3);
insert into casting values (1693,784,3);
insert into casting values (197,784,2);
insert into casting values (42,784,2);
insert into casting values (284,785,4);
insert into casting values (568,785,2);
insert into casting values (680,785,3);
insert into casting values (387,785,3);
insert into casting values (885,786,3);
insert into casting values (212,786,1);
--- tabcasting, 5201, 50
insert into casting values (67,786,1);
insert into casting values (1306,787,1);
insert into casting values (1368,787,4);
insert into casting values (1642,787,4);
insert into casting values (1761,787,2);
insert into casting values (839,788,3);
insert into casting values (1157,788,1);
insert into casting values (1514,788,6);
insert into casting values (204,788,6);
insert into casting values (617,788,4);
insert into casting values (954,789,8);
insert into casting values (753,789,2);
insert into casting values (215,789,4);
insert into casting values (634,789,3);
insert into casting values (569,789,6);
insert into casting values (604,789,4);
insert into casting values (755,790,2);
insert into casting values (1419,790,3);
insert into casting values (1647,790,4);
insert into casting values (1476,790,3);
insert into casting values (563,790,4);
insert into casting values (757,791,5);
insert into casting values (761,791,4);
insert into casting values (3,791,5);
insert into casting values (39,791,2);
insert into casting values (708,791,2);
insert into casting values (758,792,9);
insert into casting values (1468,792,1);
insert into casting values (1750,792,8);
insert into casting values (374,792,4);
insert into casting values (548,792,2);
insert into casting values (1726,793,2);
insert into casting values (176,793,3);
insert into casting values (151,793,3);
insert into casting values (599,793,5);
insert into casting values (433,793,2);
insert into casting values (745,794,3);
insert into casting values (1742,794,7);
insert into casting values (266,794,5);
insert into casting values (275,794,7);
insert into casting values (558,794,4);
insert into casting values (635,794,5);
insert into casting values (1382,795,2);
insert into casting values (1361,795,2);
insert into casting values (44,795,5);
insert into casting values (1286,796,3);
insert into casting values (1622,796,2);
insert into casting values (1506,796,2);
insert into casting values (1532,796,3);
insert into casting values (684,796,4);
--- tabcasting, 5251, 50
insert into casting values (1266,797,6);
insert into casting values (1550,797,5);
insert into casting values (1796,797,5);
insert into casting values (1548,797,4);
insert into casting values (197,797,8);
insert into casting values (255,797,4);
insert into casting values (1165,798,3);
insert into casting values (1541,798,2);
insert into casting values (1802,798,3);
insert into casting values (538,798,3);
insert into casting values (901,799,4);
insert into casting values (1237,799,5);
insert into casting values (100,799,4);
insert into casting values (89,799,6);
insert into casting values (49,799,6);
insert into casting values (422,799,6);
insert into casting values (501,799,6);
insert into casting values (987,800,1);
insert into casting values (1766,800,2);
insert into casting values (287,800,4);
insert into casting values (200,800,4);
insert into casting values (1175,801,2);
insert into casting values (1817,801,2);
insert into casting values (47,801,2);
insert into casting values (85,801,1);
insert into casting values (1122,802,3);
insert into casting values (1506,802,4);
insert into casting values (1695,802,2);
insert into casting values (1744,802,3);
insert into casting values (94,802,3);
insert into casting values (1651,803,1);
insert into casting values (50,803,3);
insert into casting values (494,803,1);
insert into casting values (1605,804,3);
insert into casting values (317,804,3);
insert into casting values (240,804,2);
insert into casting values (137,804,3);
insert into casting values (44,804,3);
insert into casting values (827,805,2);
insert into casting values (1061,805,1);
insert into casting values (1236,805,2);
insert into casting values (1705,805,2);
insert into casting values (1534,806,1);
insert into casting values (428,806,5);
insert into casting values (1089,807,7);
insert into casting values (1257,807,3);
insert into casting values (1670,807,3);
insert into casting values (1737,807,9);
insert into casting values (173,807,3);
insert into casting values (256,807,4);
--- tabcasting, 5301, 50
insert into casting values (1561,808,1);
insert into casting values (42,808,6);
insert into casting values (108,808,7);
insert into casting values (197,808,3);
insert into casting values (695,808,9);
insert into casting values (588,808,7);
insert into casting values (935,809,8);
insert into casting values (1310,809,4);
insert into casting values (1572,809,3);
insert into casting values (675,809,2);
insert into casting values (566,809,2);
insert into casting values (410,809,8);
insert into casting values (825,810,5);
insert into casting values (849,810,4);
insert into casting values (1605,810,8);
insert into casting values (1662,810,7);
insert into casting values (1700,810,8);
insert into casting values (542,810,7);
insert into casting values (938,811,1);
insert into casting values (1373,811,8);
insert into casting values (497,811,8);
insert into casting values (435,811,1);
insert into casting values (1249,812,1);
insert into casting values (1233,812,2);
insert into casting values (171,812,1);
insert into casting values (979,813,1);
insert into casting values (1436,813,4);
insert into casting values (1295,813,2);
insert into casting values (559,813,2);
insert into casting values (1015,814,4);
insert into casting values (1597,814,1);
insert into casting values (556,814,4);
insert into casting values (622,814,4);
insert into casting values (1800,815,3);
insert into casting values (972,816,2);
insert into casting values (1835,816,2);
insert into casting values (298,816,5);
insert into casting values (217,816,4);
insert into casting values (451,816,5);
insert into casting values (1256,817,2);
insert into casting values (1357,817,1);
insert into casting values (1593,817,2);
insert into casting values (1399,818,4);
insert into casting values (1719,818,5);
insert into casting values (1764,818,4);
insert into casting values (357,818,5);
insert into casting values (832,819,1);
insert into casting values (1288,819,5);
insert into casting values (1063,820,3);
insert into casting values (74,820,1);
--- tabcasting, 5351, 50
insert into casting values (996,821,4);
insert into casting values (1144,821,2);
insert into casting values (1574,821,1);
insert into casting values (1583,821,5);
insert into casting values (842,822,2);
insert into casting values (1269,822,1);
insert into casting values (1457,822,5);
insert into casting values (353,822,5);
insert into casting values (1223,823,3);
insert into casting values (1283,823,4);
insert into casting values (1521,823,3);
insert into casting values (970,824,4);
insert into casting values (1033,824,2);
insert into casting values (865,824,3);
insert into casting values (388,824,2);
insert into casting values (714,824,2);
insert into casting values (843,825,1);
insert into casting values (1198,825,8);
insert into casting values (119,825,6);
insert into casting values (550,825,1);
insert into casting values (885,826,4);
insert into casting values (1365,827,4);
insert into casting values (1267,827,1);
insert into casting values (27,827,2);
insert into casting values (646,827,2);
insert into casting values (1496,828,1);
insert into casting values (1771,828,4);
insert into casting values (473,828,1);
insert into casting values (975,829,1);
insert into casting values (1459,829,2);
insert into casting values (285,829,4);
insert into casting values (1002,830,5);
insert into casting values (1451,830,2);
insert into casting values (1814,830,4);
insert into casting values (307,830,3);
insert into casting values (618,830,3);
insert into casting values (1444,831,3);
insert into casting values (1183,831,1);
insert into casting values (20,831,3);
insert into casting values (82,831,2);
insert into casting values (793,832,3);
insert into casting values (867,832,1);
insert into casting values (107,832,8);
insert into casting values (289,832,7);
insert into casting values (593,832,4);
insert into casting values (1022,833,7);
insert into casting values (784,833,5);
insert into casting values (1801,833,4);
insert into casting values (1811,833,11);
insert into casting values (277,833,12);
--- tabcasting, 5401, 50
insert into casting values (272,833,12);
insert into casting values (365,833,15);
insert into casting values (182,833,5);
insert into casting values (407,833,8);
insert into casting values (487,833,8);
insert into casting values (926,834,9);
insert into casting values (865,834,12);
insert into casting values (860,834,10);
insert into casting values (1400,834,11);
insert into casting values (1502,834,3);
insert into casting values (1676,834,9);
insert into casting values (268,834,7);
insert into casting values (680,834,8);
insert into casting values (615,834,4);
insert into casting values (618,834,9);
insert into casting values (898,835,14);
insert into casting values (792,835,4);
insert into casting values (1258,835,8);
insert into casting values (1355,835,14);
insert into casting values (1736,835,3);
insert into casting values (1684,835,12);
insert into casting values (1669,835,5);
insert into casting values (719,835,7);
insert into casting values (449,835,7);
insert into casting values (780,836,15);
insert into casting values (898,836,6);
insert into casting values (1275,836,11);
insert into casting values (1844,836,11);
insert into casting values (1602,836,1);
insert into casting values (778,837,3);
insert into casting values (1103,837,4);
insert into casting values (844,837,11);
insert into casting values (1121,837,2);
insert into casting values (1466,837,9);
insert into casting values (1118,837,4);
insert into casting values (1790,837,11);
insert into casting values (519,837,13);
insert into casting values (898,838,11);
insert into casting values (1030,838,11);
insert into casting values (1057,838,13);
insert into casting values (1071,838,2);
insert into casting values (1547,838,2);
insert into casting values (320,838,7);
insert into casting values (136,838,3);
insert into casting values (287,838,2);
insert into casting values (801,839,8);
insert into casting values (747,839,11);
insert into casting values (787,839,8);
insert into casting values (823,839,8);
insert into casting values (810,839,9);
--- tabcasting, 5451, 50
insert into casting values (199,839,7);
insert into casting values (288,839,10);
insert into casting values (579,839,6);
insert into casting values (479,839,5);
insert into casting values (613,839,6);
insert into casting values (846,840,7);
insert into casting values (1174,840,4);
insert into casting values (1702,840,1);
insert into casting values (196,840,11);
insert into casting values (585,840,3);
insert into casting values (448,840,15);
insert into casting values (971,841,1);
insert into casting values (1312,841,2);
insert into casting values (1343,841,7);
insert into casting values (1173,841,3);
insert into casting values (1771,841,11);
insert into casting values (1714,841,10);
insert into casting values (891,842,7);
insert into casting values (802,842,5);
insert into casting values (1037,842,6);
insert into casting values (1155,842,9);
insert into casting values (1463,842,7);
insert into casting values (1112,842,9);
insert into casting values (1505,842,9);
insert into casting values (493,842,6);
insert into casting values (657,842,12);
insert into casting values (763,843,10);
insert into casting values (1322,843,6);
insert into casting values (1779,843,3);
insert into casting values (1828,843,8);
insert into casting values (160,843,7);
insert into casting values (205,843,9);
insert into casting values (107,843,7);
insert into casting values (86,843,5);
insert into casting values (527,843,13);
insert into casting values (749,844,4);
insert into casting values (1018,844,6);
insert into casting values (1429,844,11);
insert into casting values (1190,844,5);
insert into casting values (1553,844,5);
insert into casting values (596,844,4);
insert into casting values (372,844,12);
insert into casting values (1068,845,11);
insert into casting values (732,845,32);
insert into casting values (885,845,10);
insert into casting values (1171,845,2);
insert into casting values (1768,845,3);
insert into casting values (147,845,6);
insert into casting values (488,845,2);
insert into casting values (1086,846,3);
--- tabcasting, 5501, 50
insert into casting values (1244,846,5);
insert into casting values (1509,846,3);
insert into casting values (219,846,7);
insert into casting values (448,846,2);
insert into casting values (577,846,13);
insert into casting values (797,847,5);
insert into casting values (1007,847,8);
insert into casting values (846,847,5);
insert into casting values (359,847,4);
insert into casting values (204,847,10);
insert into casting values (347,847,8);
insert into casting values (714,847,15);
insert into casting values (499,847,7);
insert into casting values (841,848,1);
insert into casting values (1457,848,3);
insert into casting values (1823,848,10);
insert into casting values (316,848,13);
insert into casting values (413,848,9);
insert into casting values (755,849,4);
insert into casting values (1109,849,14);
insert into casting values (1221,849,6);
insert into casting values (1693,849,4);
insert into casting values (1497,849,7);
insert into casting values (302,849,6);
insert into casting values (3,849,6);
insert into casting values (1845,850,1);
insert into casting values (86,850,4);
insert into casting values (297,850,6);
insert into casting values (490,850,15);
insert into casting values (575,850,5);
insert into casting values (1055,851,3);
insert into casting values (996,851,2);
insert into casting values (1319,851,2);
insert into casting values (80,851,8);
insert into casting values (223,851,11);
insert into casting values (405,851,2);
insert into casting values (839,852,1);
insert into casting values (1640,852,1);
insert into casting values (253,852,14);
insert into casting values (618,852,7);
insert into casting values (942,853,4);
insert into casting values (1383,853,5);
insert into casting values (1260,853,10);
insert into casting values (1585,853,7);
insert into casting values (1567,853,9);
insert into casting values (1718,853,7);
insert into casting values (586,853,7);
insert into casting values (534,853,7);
insert into casting values (828,854,2);
insert into casting values (1368,854,1);
--- tabcasting, 5551, 50
insert into casting values (1113,854,4);
insert into casting values (80,854,7);
insert into casting values (653,854,10);
insert into casting values (1524,855,6);
insert into casting values (1712,855,5);
insert into casting values (130,855,5);
insert into casting values (77,855,9);
insert into casting values (188,855,14);
insert into casting values (83,855,6);
insert into casting values (423,855,4);
insert into casting values (322,856,13);
insert into casting values (230,856,5);
insert into casting values (398,856,2);
insert into casting values (433,856,7);
insert into casting values (1423,857,5);
insert into casting values (1521,857,4);
insert into casting values (1601,857,5);
insert into casting values (1684,857,14);
insert into casting values (168,857,8);
insert into casting values (631,857,4);
insert into casting values (986,858,6);
insert into casting values (1128,858,7);
insert into casting values (1374,858,5);
insert into casting values (1393,858,12);
insert into casting values (1167,858,5);
insert into casting values (360,858,9);
insert into casting values (612,858,4);
insert into casting values (940,859,7);
insert into casting values (137,859,5);
insert into casting values (317,859,15);
insert into casting values (359,859,5);
insert into casting values (129,859,5);
insert into casting values (44,859,7);
insert into casting values (112,859,6);
insert into casting values (1084,860,1);
insert into casting values (1104,860,1);
insert into casting values (1264,860,12);
insert into casting values (711,860,6);
insert into casting values (1086,861,6);
insert into casting values (1414,861,5);
insert into casting values (1195,861,13);
insert into casting values (1228,861,2);
insert into casting values (1737,861,7);
insert into casting values (75,861,6);
insert into casting values (102,861,6);
insert into casting values (639,861,6);
insert into casting values (859,862,1);
insert into casting values (245,862,15);
insert into casting values (6,862,7);
insert into casting values (500,862,7);
--- tabcasting, 5601, 50
insert into casting values (394,862,3);
insert into casting values (985,863,4);
insert into casting values (742,863,6);
insert into casting values (1401,863,8);
insert into casting values (1161,863,5);
insert into casting values (1777,863,6);
insert into casting values (148,863,8);
insert into casting values (106,863,6);
insert into casting values (26,863,13);
insert into casting values (989,864,11);
insert into casting values (971,864,3);
insert into casting values (1566,864,3);
insert into casting values (102,864,4);
insert into casting values (75,864,5);
insert into casting values (229,864,7);
insert into casting values (959,865,3);
insert into casting values (348,865,4);
insert into casting values (319,865,2);
insert into casting values (210,865,12);
insert into casting values (207,865,4);
insert into casting values (509,865,8);
insert into casting values (1095,866,2);
insert into casting values (1456,866,2);
insert into casting values (1450,866,2);
insert into casting values (597,866,10);
insert into casting values (535,866,7);
insert into casting values (955,867,10);
insert into casting values (1070,867,10);
insert into casting values (1049,867,5);
insert into casting values (949,867,12);
insert into casting values (1022,867,10);
insert into casting values (1149,867,13);
insert into casting values (1148,867,10);
insert into casting values (1158,867,1);
insert into casting values (315,867,8);
insert into casting values (675,867,6);
insert into casting values (739,868,3);
insert into casting values (1141,868,8);
insert into casting values (60,868,3);
insert into casting values (698,868,10);
insert into casting values (595,868,3);
insert into casting values (532,868,3);
insert into casting values (961,869,11);
insert into casting values (1228,869,1);
insert into casting values (1743,869,6);
insert into casting values (424,869,1);
insert into casting values (906,870,3);
insert into casting values (961,870,3);
insert into casting values (1153,870,7);
insert into casting values (120,870,3);
--- tabcasting, 5651, 50
insert into casting values (572,870,3);
insert into casting values (701,870,15);
insert into casting values (1331,871,2);
insert into casting values (1319,871,1);
insert into casting values (80,871,14);
insert into casting values (17,871,3);
insert into casting values (616,871,7);
insert into casting values (986,872,5);
insert into casting values (1351,872,11);
insert into casting values (1277,872,9);
insert into casting values (344,872,6);
insert into casting values (345,872,9);
insert into casting values (350,872,9);
insert into casting values (507,872,8);
insert into casting values (564,872,5);
insert into casting values (1574,873,15);
insert into casting values (1647,873,1);
insert into casting values (330,873,7);
insert into casting values (563,873,1);
insert into casting values (881,874,7);
insert into casting values (738,874,9);
insert into casting values (1580,874,2);
insert into casting values (1480,874,11);
insert into casting values (313,874,6);
insert into casting values (238,874,1);
insert into casting values (1031,875,3);
insert into casting values (1204,875,14);
insert into casting values (1758,875,1);
insert into casting values (731,875,8);
insert into casting values (427,875,2);
insert into casting values (25,876,2);
insert into casting values (459,876,2);
insert into casting values (475,876,13);
insert into casting values (408,876,9);
insert into casting values (536,876,2);
insert into casting values (657,876,4);
insert into casting values (737,877,5);
insert into casting values (1170,877,7);
insert into casting values (146,877,1);
insert into casting values (111,877,14);
insert into casting values (955,878,4);
insert into casting values (949,878,7);
insert into casting values (1070,878,4);
insert into casting values (1148,878,6);
insert into casting values (1158,878,4);
insert into casting values (675,878,9);
insert into casting values (845,879,2);
insert into casting values (1045,879,4);
insert into casting values (1131,879,3);
insert into casting values (83,879,4);
--- tabcasting, 5701, 50
insert into casting values (618,879,6);
insert into casting values (1060,880,4);
insert into casting values (1364,880,2);
insert into casting values (1660,880,9);
insert into casting values (1504,880,5);
insert into casting values (1518,880,4);
insert into casting values (242,881,3);
insert into casting values (10,881,6);
insert into casting values (246,881,5);
insert into casting values (709,881,3);
insert into casting values (727,881,4);
insert into casting values (989,882,9);
insert into casting values (1603,882,5);
insert into casting values (517,882,4);
insert into casting values (367,882,5);
insert into casting values (650,882,4);
insert into casting values (991,883,1);
insert into casting values (1233,883,1);
insert into casting values (1728,883,6);
insert into casting values (1410,884,7);
insert into casting values (1529,884,3);
insert into casting values (1732,884,2);
insert into casting values (691,884,5);
insert into casting values (477,884,2);
insert into casting values (840,885,1);
insert into casting values (890,885,2);
insert into casting values (1329,885,2);
insert into casting values (66,885,8);
insert into casting values (910,886,8);
insert into casting values (1143,886,8);
insert into casting values (1338,886,3);
insert into casting values (1236,886,4);
insert into casting values (666,886,6);
insert into casting values (485,886,4);
insert into casting values (1009,887,4);
insert into casting values (1199,887,4);
insert into casting values (1123,887,5);
insert into casting values (1781,887,6);
insert into casting values (69,887,8);
insert into casting values (567,887,7);
insert into casting values (1245,888,1);
insert into casting values (1498,888,4);
insert into casting values (659,888,7);
insert into casting values (916,889,3);
insert into casting values (1187,889,7);
insert into casting values (108,889,8);
insert into casting values (172,889,2);
insert into casting values (345,889,6);
insert into casting values (536,889,3);
insert into casting values (796,890,9);
--- tabcasting, 5751, 50
insert into casting values (1011,891,4);
insert into casting values (881,891,3);
insert into casting values (212,891,5);
insert into casting values (64,891,2);
insert into casting values (670,891,6);
insert into casting values (994,892,4);
insert into casting values (958,892,4);
insert into casting values (1247,892,1);
insert into casting values (576,892,8);
insert into casting values (769,893,4);
insert into casting values (1249,893,2);
insert into casting values (1676,893,2);
insert into casting values (1528,893,6);
insert into casting values (271,893,2);
insert into casting values (209,894,6);
insert into casting values (349,894,5);
insert into casting values (472,894,7);
insert into casting values (410,894,7);
insert into casting values (402,894,5);
insert into casting values (438,894,4);
insert into casting values (1334,895,1);
insert into casting values (1743,895,3);
insert into casting values (616,895,4);
insert into casting values (405,895,8);
insert into casting values (1069,896,8);
insert into casting values (1106,896,9);
insert into casting values (1515,896,2);
insert into casting values (1527,896,1);
insert into casting values (594,896,8);
insert into casting values (1127,897,1);
insert into casting values (1524,897,2);
insert into casting values (1621,897,6);
insert into casting values (470,897,4);
insert into casting values (1316,898,3);
insert into casting values (125,898,3);
insert into casting values (289,898,6);
insert into casting values (592,898,4);
insert into casting values (507,898,3);
insert into casting values (777,899,1);
insert into casting values (1299,899,4);
insert into casting values (1200,899,9);
insert into casting values (1643,899,4);
insert into casting values (900,900,2);
insert into casting values (895,900,3);
insert into casting values (1631,900,8);
insert into casting values (225,900,4);
insert into casting values (483,900,9);
insert into casting values (377,900,6);
insert into casting values (771,901,8);
insert into casting values (1143,901,1);
--- tabcasting, 5801, 50
insert into casting values (1753,901,4);
insert into casting values (283,901,3);
insert into casting values (979,902,6);
insert into casting values (1322,902,5);
insert into casting values (1199,902,5);
insert into casting values (153,902,4);
insert into casting values (357,902,3);
insert into casting values (1011,903,3);
insert into casting values (751,903,3);
insert into casting values (790,903,8);
insert into casting values (1445,903,3);
insert into casting values (1414,904,1);
insert into casting values (1474,904,4);
insert into casting values (317,904,4);
insert into casting values (334,904,7);
insert into casting values (1232,905,7);
insert into casting values (1596,905,3);
insert into casting values (275,905,6);
insert into casting values (729,905,6);
insert into casting values (703,905,4);
insert into casting values (725,905,5);
insert into casting values (1091,906,1);
insert into casting values (1065,906,7);
insert into casting values (1479,906,9);
insert into casting values (272,906,6);
insert into casting values (448,906,5);
insert into casting values (979,907,7);
insert into casting values (865,907,8);
insert into casting values (770,907,12);
insert into casting values (861,907,8);
insert into casting values (748,907,8);
insert into casting values (1243,907,6);
insert into casting values (1322,907,9);
insert into casting values (1577,907,5);
insert into casting values (361,907,11);
insert into casting values (149,907,15);
insert into casting values (160,907,12);
insert into casting values (367,907,15);
insert into casting values (1004,908,4);
insert into casting values (1589,908,4);
insert into casting values (1692,908,2);
insert into casting values (1609,908,4);
insert into casting values (332,908,9);
insert into casting values (1644,909,8);
insert into casting values (1003,910,2);
insert into casting values (436,910,5);
insert into casting values (721,910,2);
insert into casting values (407,910,4);
insert into casting values (815,911,3);
insert into casting values (940,911,3);
--- tabcasting, 5851, 50
insert into casting values (1119,911,2);
insert into casting values (432,911,4);
insert into casting values (549,911,8);
insert into casting values (1456,912,8);
insert into casting values (1771,912,1);
insert into casting values (1818,912,2);
insert into casting values (332,912,5);
insert into casting values (233,913,3);
insert into casting values (188,913,7);
insert into casting values (350,913,4);
insert into casting values (128,913,2);
insert into casting values (637,913,3);
insert into casting values (1053,914,6);
insert into casting values (998,914,2);
insert into casting values (1754,914,1);
insert into casting values (488,914,6);
insert into casting values (642,914,6);
insert into casting values (1655,915,1);
insert into casting values (237,915,1);
insert into casting values (473,915,9);
insert into casting values (741,916,15);
insert into casting values (849,916,6);
insert into casting values (831,916,12);
insert into casting values (1114,916,10);
insert into casting values (1308,916,4);
insert into casting values (1777,916,7);
insert into casting values (1686,916,8);
insert into casting values (232,916,5);
insert into casting values (527,916,12);
insert into casting values (563,916,10);
insert into casting values (482,916,6);
insert into casting values (753,917,10);
insert into casting values (1361,917,4);
insert into casting values (1528,917,8);
insert into casting values (317,917,13);
insert into casting values (137,917,11);
insert into casting values (336,917,5);
insert into casting values (191,917,7);
insert into casting values (44,917,10);
insert into casting values (507,917,4);
insert into casting values (755,918,8);
insert into casting values (808,918,13);
insert into casting values (1355,918,3);
insert into casting values (1337,918,7);
insert into casting values (1275,918,8);
insert into casting values (1219,918,7);
insert into casting values (1553,918,12);
insert into casting values (577,918,14);
insert into casting values (930,919,3);
insert into casting values (929,919,11);
--- tabcasting, 5901, 50
insert into casting values (1834,919,11);
insert into casting values (215,919,3);
insert into casting values (233,919,5);
insert into casting values (236,919,13);
insert into casting values (98,919,9);
insert into casting values (42,919,9);
insert into casting values (992,920,7);
insert into casting values (1289,920,2);
insert into casting values (1156,920,9);
insert into casting values (1271,920,13);
insert into casting values (1824,920,3);
insert into casting values (302,920,12);
insert into casting values (534,920,3);
insert into casting values (1037,921,10);
insert into casting values (865,921,7);
insert into casting values (1034,921,7);
insert into casting values (1374,921,9);
insert into casting values (1151,921,6);
insert into casting values (1528,921,10);
insert into casting values (187,921,5);
insert into casting values (51,921,4);
insert into casting values (428,921,12);
insert into casting values (803,922,10);
insert into casting values (308,922,6);
insert into casting values (202,922,4);
insert into casting values (29,922,4);
insert into casting values (96,922,11);
insert into casting values (374,922,2);
insert into casting values (500,922,8);
insert into casting values (746,923,11);
insert into casting values (961,923,7);
insert into casting values (1115,923,9);
insert into casting values (181,923,3);
insert into casting values (320,923,14);
insert into casting values (491,923,5);
insert into casting values (891,924,10);
insert into casting values (1408,924,4);
insert into casting values (336,924,4);
insert into casting values (66,924,3);
insert into casting values (382,924,11);
insert into casting values (1343,925,5);
insert into casting values (13,925,12);
insert into casting values (5,925,10);
insert into casting values (189,925,2);
insert into casting values (1,925,5);
insert into casting values (471,925,5);
insert into casting values (894,926,6);
insert into casting values (1479,926,8);
insert into casting values (30,926,12);
insert into casting values (132,926,3);
--- tabcasting, 5951, 50
insert into casting values (574,926,1);
insert into casting values (617,926,10);
insert into casting values (738,927,12);
insert into casting values (1323,927,5);
insert into casting values (1520,927,5);
insert into casting values (145,927,10);
insert into casting values (678,927,3);
insert into casting values (685,927,4);
insert into casting values (851,928,12);
insert into casting values (942,928,13);
insert into casting values (1085,928,5);
insert into casting values (1370,928,11);
insert into casting values (1187,928,10);
insert into casting values (1470,928,6);
insert into casting values (1419,928,9);
insert into casting values (1146,928,14);
insert into casting values (1462,928,9);
insert into casting values (130,928,6);
insert into casting values (106,928,10);
insert into casting values (77,928,11);
insert into casting values (406,928,7);
insert into casting values (1048,929,12);
insert into casting values (780,929,3);
insert into casting values (1840,929,4);
insert into casting values (1675,929,5);
insert into casting values (300,929,2);
insert into casting values (450,929,15);
insert into casting values (1087,930,1);
insert into casting values (1296,930,3);
insert into casting values (124,930,15);
insert into casting values (149,930,3);
insert into casting values (586,930,15);
insert into casting values (1385,931,14);
insert into casting values (1264,931,14);
insert into casting values (1095,932,8);
insert into casting values (1009,932,11);
insert into casting values (1392,932,6);
insert into casting values (1114,932,6);
insert into casting values (1844,932,9);
insert into casting values (1509,932,6);
insert into casting values (648,932,9);
insert into casting values (616,932,15);
insert into casting values (864,933,2);
insert into casting values (1549,933,11);
insert into casting values (188,933,4);
insert into casting values (11,933,2);
insert into casting values (212,933,14);
insert into casting values (593,933,2);
insert into casting values (807,934,12);
insert into casting values (1359,934,4);
--- tabcasting, 6001, 50
insert into casting values (1313,934,5);
insert into casting values (1104,934,2);
insert into casting values (1474,934,3);
insert into casting values (1822,934,15);
insert into casting values (1170,935,4);
insert into casting values (1174,935,1);
insert into casting values (1702,935,2);
insert into casting values (1600,935,11);
insert into casting values (75,935,11);
insert into casting values (1069,936,13);
insert into casting values (1327,936,1);
insert into casting values (698,936,11);
insert into casting values (561,936,1);
insert into casting values (12,937,14);
insert into casting values (149,937,2);
insert into casting values (61,937,5);
insert into casting values (498,937,4);
insert into casting values (700,937,2);
insert into casting values (1727,938,2);
insert into casting values (1542,938,2);
insert into casting values (362,938,3);
insert into casting values (599,938,11);
insert into casting values (694,938,3);
insert into casting values (953,939,7);
insert into casting values (1717,939,11);
insert into casting values (344,939,3);
insert into casting values (356,939,2);
insert into casting values (623,939,3);
insert into casting values (531,939,7);
insert into casting values (1095,940,5);
insert into casting values (1368,940,2);
insert into casting values (1124,940,1);
insert into casting values (364,940,13);
insert into casting values (950,941,1);
insert into casting values (1751,941,2);
insert into casting values (312,941,6);
insert into casting values (593,941,8);
insert into casting values (573,941,15);
insert into casting values (890,942,14);
insert into casting values (934,942,3);
insert into casting values (1694,942,2);
insert into casting values (248,942,5);
insert into casting values (620,942,4);
insert into casting values (1129,943,3);
insert into casting values (1312,943,3);
insert into casting values (1193,943,1);
insert into casting values (967,944,10);
insert into casting values (152,944,9);
insert into casting values (356,944,9);
insert into casting values (392,944,5);
--- tabcasting, 6051, 50
insert into casting values (568,944,4);
insert into casting values (619,944,6);
insert into casting values (913,945,2);
insert into casting values (1190,945,2);
insert into casting values (1438,945,5);
insert into casting values (1112,945,7);
insert into casting values (1812,945,15);
insert into casting values (1576,945,6);
insert into casting values (1045,946,1);
insert into casting values (1540,946,4);
insert into casting values (132,946,2);
insert into casting values (664,946,11);
insert into casting values (752,947,9);
insert into casting values (1117,947,5);
insert into casting values (1603,947,1);
insert into casting values (82,947,8);
insert into casting values (719,947,14);
insert into casting values (1026,948,13);
insert into casting values (939,949,6);
insert into casting values (763,949,6);
insert into casting values (1036,949,7);
insert into casting values (773,949,11);
insert into casting values (1282,949,3);
insert into casting values (133,949,8);
insert into casting values (239,949,5);
insert into casting values (1002,950,4);
insert into casting values (1392,950,5);
insert into casting values (109,950,2);
insert into casting values (19,950,4);
insert into casting values (285,950,14);
insert into casting values (1078,951,2);
insert into casting values (353,951,3);
insert into casting values (58,951,8);
insert into casting values (338,951,14);
insert into casting values (614,951,6);
insert into casting values (605,951,2);
insert into casting values (804,952,14);
insert into casting values (719,952,1);
insert into casting values (1351,953,3);
insert into casting values (1541,953,10);
insert into casting values (558,953,3);
insert into casting values (408,953,3);
insert into casting values (1360,954,10);
insert into casting values (872,955,11);
insert into casting values (1315,956,10);
insert into casting values (1569,956,1);
insert into casting values (56,956,5);
insert into casting values (78,956,3);
insert into casting values (1441,957,3);
insert into casting values (1439,957,6);
--- tabcasting, 6101, 50
insert into casting values (76,957,13);
insert into casting values (297,957,9);
insert into casting values (296,957,9);
insert into casting values (113,957,7);
insert into casting values (586,957,4);
insert into casting values (742,958,5);
insert into casting values (999,958,3);
insert into casting values (1421,958,10);
insert into casting values (232,958,2);
insert into casting values (619,958,3);
insert into casting values (1352,959,7);
insert into casting values (1180,959,11);
insert into casting values (609,959,7);
insert into casting values (401,959,4);
insert into casting values (674,959,8);
insert into casting values (647,959,3);
insert into casting values (1095,960,7);
insert into casting values (351,960,7);
insert into casting values (26,960,4);
insert into casting values (267,960,10);
insert into casting values (399,960,8);
insert into casting values (568,960,5);
insert into casting values (573,960,7);
insert into casting values (828,961,6);
insert into casting values (797,961,6);
insert into casting values (1146,961,5);
insert into casting values (1802,961,13);
insert into casting values (1481,961,5);
insert into casting values (1052,962,8);
insert into casting values (1340,962,4);
insert into casting values (1296,962,14);
insert into casting values (320,962,5);
insert into casting values (535,962,8);
insert into casting values (639,962,2);
insert into casting values (1256,963,7);
insert into casting values (1259,963,11);
insert into casting values (1688,963,8);
insert into casting values (1697,963,4);
insert into casting values (558,963,7);
insert into casting values (530,963,7);
insert into casting values (700,963,3);
insert into casting values (788,964,8);
insert into casting values (1823,964,9);
insert into casting values (252,964,8);
insert into casting values (350,964,7);
insert into casting values (64,964,1);
insert into casting values (400,964,15);
insert into casting values (926,965,5);
insert into casting values (1290,965,3);
insert into casting values (1776,965,3);
--- tabcasting, 6151, 50
insert into casting values (117,965,4);
insert into casting values (429,965,12);
insert into casting values (278,966,15);
insert into casting values (1076,967,14);
insert into casting values (955,968,9);
insert into casting values (1070,968,9);
insert into casting values (792,968,5);
insert into casting values (949,968,10);
insert into casting values (1158,968,5);
insert into casting values (675,968,3);
insert into casting values (961,969,2);
insert into casting values (1824,969,5);
insert into casting values (356,969,5);
insert into casting values (344,969,12);
insert into casting values (10,969,3);
insert into casting values (1177,970,1);
insert into casting values (1580,970,5);
insert into casting values (1504,970,14);
insert into casting values (501,970,7);
insert into casting values (471,970,8);
insert into casting values (914,972,1);
insert into casting values (1083,972,4);
insert into casting values (626,972,5);
insert into casting values (765,973,1);
insert into casting values (147,973,1);
insert into casting values (1358,975,1);
insert into casting values (1825,975,1);
insert into casting values (772,976,4);
insert into casting values (1018,976,4);
insert into casting values (1023,976,6);
insert into casting values (1458,976,9);
insert into casting values (491,976,6);
insert into casting values (550,976,7);
insert into casting values (1056,978,3);
insert into casting values (650,978,2);
insert into casting values (517,978,2);
insert into casting values (367,978,2);
insert into casting values (966,981,1);
insert into casting values (555,981,1);
insert into casting values (884,983,3);
insert into casting values (843,983,6);
insert into casting values (1360,983,1);
insert into casting values (1376,983,9);
insert into casting values (1052,984,6);
insert into casting values (1817,984,3);
insert into casting values (2,984,4);
insert into casting values (197,984,6);
insert into casting values (692,984,3);
insert into casting values (775,986,4);
insert into casting values (1296,986,2);
--- tabcasting, 6201, 50
insert into casting values (265,986,6);
insert into casting values (7,986,4);
insert into casting values (441,986,6);
insert into casting values (941,987,2);
insert into casting values (1257,987,5);
insert into casting values (1480,987,1);
insert into casting values (807,989,2);
insert into casting values (977,989,9);
insert into casting values (930,989,4);
insert into casting values (880,989,7);
insert into casting values (1462,989,8);
insert into casting values (286,989,8);
insert into casting values (1570,990,1);
insert into casting values (235,990,1);
insert into casting values (1602,996,2);
insert into casting values (46,996,3);
insert into casting values (20,996,2);
insert into casting values (557,996,2);
insert into casting values (1745,999,1);
insert into casting values (760,1000,7);
insert into casting values (1808,1000,9);
insert into casting values (205,1000,5);
insert into casting values (107,1000,6);
insert into casting values (110,1000,9);
insert into casting values (86,1000,7);
insert into casting values (160,1000,6);
insert into casting values (1058,1002,7);
insert into casting values (1001,1002,7);
insert into casting values (1149,1002,8);
insert into casting values (1344,1002,3);
insert into casting values (89,1002,8);
insert into casting values (386,1002,7);
insert into casting values (501,1002,8);
insert into casting values (1815,1005,2);
insert into casting values (1773,1005,1);
insert into casting values (14,1005,4);
insert into casting values (115,1006,3);
insert into casting values (190,1006,4);
insert into casting values (348,1006,2);
insert into casting values (507,1006,2);
insert into casting values (1436,1008,1);
insert into casting values (1564,1008,1);
insert into casting values (899,1009,6);
insert into casting values (916,1009,2);
insert into casting values (1422,1009,3);
insert into casting values (343,1009,7);
insert into casting values (612,1009,2);
insert into casting values (877,1012,5);
insert into casting values (1574,1012,6);
insert into casting values (1771,1012,3);
--- tabcasting, 6251, 50
insert into casting values (407,1012,9);
insert into casting values (613,1012,2);
insert into casting values (936,1013,5);
insert into casting values (1444,1013,6);
insert into casting values (358,1013,6);
insert into casting values (381,1013,1);
insert into casting values (953,1014,3);
insert into casting values (1151,1014,1);
insert into casting values (552,1014,2);
insert into casting values (1388,1015,3);
insert into casting values (496,1015,3);
insert into casting values (601,1015,1);
insert into casting values (1095,1018,4);
insert into casting values (224,1018,8);
insert into casting values (47,1018,3);
insert into casting values (553,1018,3);
insert into casting values (444,1018,8);
insert into casting values (1356,1019,1);
insert into casting values (1380,1019,3);
insert into casting values (546,1019,3);
insert into casting values (1766,1023,5);
insert into casting values (1791,1023,2);
insert into casting values (1631,1023,3);
insert into casting values (481,1023,4);
insert into casting values (1632,1024,2);
insert into casting values (1478,1024,1);
insert into casting values (541,1024,5);
insert into casting values (809,1026,8);
insert into casting values (748,1026,4);
insert into casting values (1722,1026,1);
insert into casting values (463,1026,8);
insert into casting values (869,1027,6);
insert into casting values (1730,1027,5);
insert into casting values (140,1027,9);
insert into casting values (130,1027,2);
insert into casting values (430,1027,5);
insert into casting values (1088,1030,2);
insert into casting values (967,1030,4);
insert into casting values (1639,1030,2);
insert into casting values (511,1030,5);
insert into casting values (948,1031,2);
insert into casting values (87,1031,2);
insert into casting values (681,1031,2);
insert into casting values (476,1031,5);
insert into casting values (1413,1033,3);
insert into casting values (196,1033,3);
insert into casting values (489,1033,3);
insert into casting values (678,1033,2);
insert into casting values (821,1038,5);
insert into casting values (934,1038,9);
--- tabcasting, 6301, 50
insert into casting values (1662,1038,6);
insert into casting values (1716,1038,8);
insert into casting values (1820,1038,6);
insert into casting values (43,1038,5);
insert into casting values (740,1042,2);
insert into casting values (1162,1042,4);
insert into casting values (1270,1042,4);
insert into casting values (219,1042,2);
insert into casting values (1076,1045,4);
insert into casting values (582,1045,1);
insert into casting values (707,1045,3);
insert into casting values (850,1046,3);
insert into casting values (918,1046,4);
insert into casting values (1196,1046,3);
insert into casting values (214,1046,5);
insert into casting values (883,1050,1);
insert into casting values (1488,1050,1);
insert into casting values (341,1052,1);
insert into casting values (682,1052,1);
insert into casting values (1609,1056,3);
insert into casting values (473,1056,3);
insert into casting values (551,1056,3);
insert into casting values (1153,1057,2);
insert into casting values (1600,1057,5);
insert into casting values (29,1057,6);
insert into casting values (95,1057,9);
insert into casting values (688,1057,4);
insert into casting values (980,1065,7);
insert into casting values (1471,1065,7);
insert into casting values (1219,1065,9);
insert into casting values (1486,1065,2);
insert into casting values (168,1065,4);
insert into casting values (803,1066,2);
insert into casting values (81,1066,2);
insert into casting values (480,1066,1);
insert into casting values (1363,1067,2);
insert into casting values (1204,1067,8);
insert into casting values (1837,1067,1);
insert into casting values (373,1067,7);
insert into casting values (1295,1068,3);
insert into casting values (1262,1068,1);
insert into casting values (1523,1068,4);
insert into casting values (887,1074,4);
insert into casting values (796,1074,1);
insert into casting values (726,1074,3);
insert into casting values (1103,1077,5);
insert into casting values (105,1077,6);
insert into casting values (476,1077,2);
insert into casting values (453,1077,6);
insert into casting values (1439,1078,4);
--- tabcasting, 6351, 50
insert into casting values (339,1078,6);
insert into casting values (273,1078,3);
insert into casting values (389,1078,5);
insert into casting values (629,1078,7);
insert into casting values (1537,1079,1);
insert into casting values (457,1079,3);
insert into casting values (638,1079,4);
insert into casting values (925,1081,5);
insert into casting values (824,1081,3);
insert into casting values (1385,1081,5);
insert into casting values (1335,1081,15);
insert into casting values (1491,1081,10);
insert into casting values (1600,1081,10);
insert into casting values (1806,1081,12);
insert into casting values (86,1081,10);
insert into casting values (511,1081,8);
insert into casting values (750,1082,3);
insert into casting values (1660,1082,1);
insert into casting values (346,1082,5);
insert into casting values (800,1083,6);
insert into casting values (1581,1083,6);
insert into casting values (200,1083,7);
insert into casting values (628,1083,1);
insert into casting values (458,1083,9);
insert into casting values (1395,1084,3);
insert into casting values (1262,1084,2);
insert into casting values (409,1084,1);
insert into casting values (124,1085,9);
insert into casting values (523,1085,6);
insert into casting values (617,1085,1);
insert into casting values (389,1085,3);
insert into casting values (874,1086,2);
insert into casting values (892,1086,2);
insert into casting values (750,1086,2);
insert into casting values (1374,1086,2);
insert into casting values (1025,1088,1);
insert into casting values (1225,1088,2);
insert into casting values (379,1088,2);
insert into casting values (959,1089,5);
insert into casting values (1177,1089,3);
insert into casting values (1644,1089,4);
insert into casting values (356,1089,6);
insert into casting values (386,1089,6);
insert into casting values (1569,1092,4);
insert into casting values (1843,1092,5);
insert into casting values (1657,1092,7);
insert into casting values (446,1092,7);
insert into casting values (984,1093,4);
insert into casting values (229,1093,5);
insert into casting values (156,1093,4);
--- tabcasting, 6401, 50
insert into casting values (77,1093,3);
insert into casting values (1022,1098,6);
insert into casting values (949,1098,8);
insert into casting values (955,1098,5);
insert into casting values (1070,1098,5);
insert into casting values (1148,1098,5);
insert into casting values (822,1100,4);
insert into casting values (1329,1100,1);
insert into casting values (14,1100,2);
insert into casting values (920,1102,2);
insert into casting values (1069,1102,5);
insert into casting values (1641,1102,3);
insert into casting values (1700,1102,2);
insert into casting values (773,1105,3);
insert into casting values (1289,1105,3);
insert into casting values (1716,1105,7);
insert into casting values (416,1105,6);
insert into casting values (578,1105,5);
insert into casting values (1306,1107,5);
insert into casting values (1572,1107,6);
insert into casting values (586,1107,3);
insert into casting values (105,1108,1);
insert into casting values (1033,1109,3);
insert into casting values (401,1109,1);
insert into casting values (1324,1112,5);
insert into casting values (1141,1112,2);
insert into casting values (1359,1112,8);
insert into casting values (38,1112,7);
insert into casting values (358,1112,9);
insert into casting values (752,1113,3);
insert into casting values (1388,1113,1);
insert into casting values (972,1125,3);
insert into casting values (1835,1125,4);
insert into casting values (185,1125,3);
insert into casting values (458,1125,5);
insert into casting values (944,1126,2);
insert into casting values (861,1126,2);
insert into casting values (1665,1126,2);
insert into casting values (307,1126,2);
insert into casting values (924,1128,4);
insert into casting values (27,1128,4);
insert into casting values (646,1128,3);
insert into casting values (453,1128,3);
insert into casting values (1309,1130,1);
insert into casting values (1357,1130,3);
insert into casting values (1593,1130,3);
insert into casting values (1484,1134,2);
insert into casting values (1823,1134,1);
insert into casting values (719,1134,5);
insert into casting values (1415,1140,2);
--- tabcasting, 6451, 50
insert into casting values (1814,1140,5);
insert into casting values (1674,1140,2);
insert into casting values (489,1140,2);
insert into casting values (1552,1142,1);
insert into casting values (508,1142,5);
insert into casting values (560,1142,8);
insert into casting values (727,1142,9);
insert into casting values (1357,1143,2);
insert into casting values (1467,1143,1);
insert into casting values (1389,1144,3);
insert into casting values (1345,1144,1);
insert into casting values (286,1144,3);
insert into casting values (851,1145,3);
insert into casting values (735,1145,5);
insert into casting values (14,1145,3);
insert into casting values (240,1145,3);
insert into casting values (964,1146,4);
insert into casting values (756,1146,4);
insert into casting values (55,1146,1);
insert into casting values (815,1147,2);
insert into casting values (1820,1147,2);
insert into casting values (30,1147,5);
insert into casting values (321,1147,8);
insert into casting values (777,1148,5);
insert into casting values (1299,1148,2);
insert into casting values (1643,1148,1);
insert into casting values (965,1153,2);
insert into casting values (1300,1153,2);
insert into casting values (1584,1153,3);
insert into casting values (399,1153,7);
insert into casting values (559,1153,6);
insert into casting values (1072,1155,4);
insert into casting values (997,1155,3);
insert into casting values (1245,1155,3);
insert into casting values (1498,1155,6);
insert into casting values (1006,1157,1);
insert into casting values (504,1157,2);
insert into casting values (390,1157,3);
insert into casting values (814,1158,3);
insert into casting values (863,1158,3);
insert into casting values (258,1158,5);
insert into casting values (521,1158,4);
insert into casting values (1211,1161,3);
insert into casting values (1603,1161,2);
insert into casting values (1708,1161,1);
insert into casting values (1297,1162,5);
insert into casting values (57,1162,3);
insert into casting values (155,1162,5);
insert into casting values (116,1162,5);
insert into casting values (1016,1165,3);
--- tabcasting, 6501, 50
insert into casting values (1457,1165,1);
insert into casting values (116,1165,4);
insert into casting values (1375,1168,6);
insert into casting values (1393,1168,5);
insert into casting values (251,1168,3);
insert into casting values (458,1168,2);
insert into casting values (535,1168,6);
insert into casting values (1027,1176,7);
insert into casting values (979,1176,3);
insert into casting values (80,1176,6);
insert into casting values (186,1176,4);
insert into casting values (1090,1177,1);
insert into casting values (754,1177,3);
insert into casting values (1357,1177,4);
insert into casting values (1040,1179,1);
insert into casting values (1625,1179,3);
insert into casting values (673,1179,2);
insert into casting values (1057,1180,6);
insert into casting values (111,1180,4);
insert into casting values (594,1180,5);
insert into casting values (631,1180,7);
insert into casting values (843,1181,4);
insert into casting values (108,1181,6);
insert into casting values (116,1181,9);
insert into casting values (57,1181,7);
insert into casting values (345,1181,7);
insert into casting values (1248,1183,3);
insert into casting values (332,1183,4);
insert into casting values (1795,1184,2);
insert into casting values (161,1184,3);
insert into casting values (579,1184,5);
insert into casting values (1066,1185,3);
insert into casting values (1558,1185,1);
insert into casting values (374,1185,3);
insert into casting values (891,1186,14);
insert into casting values (942,1186,12);
insert into casting values (992,1186,8);
insert into casting values (1585,1186,9);
insert into casting values (320,1186,12);
insert into casting values (361,1186,7);
insert into casting values (490,1186,4);
insert into casting values (637,1186,6);
insert into casting values (560,1186,6);
insert into casting values (1045,1187,15);
insert into casting values (1362,1187,2);
insert into casting values (1664,1187,4);
insert into casting values (1633,1187,3);
insert into casting values (122,1187,10);
insert into casting values (73,1187,12);
insert into casting values (1102,1188,7);
--- tabcasting, 6551, 50
insert into casting values (809,1188,13);
insert into casting values (1277,1188,12);
insert into casting values (1824,1188,11);
insert into casting values (1642,1188,9);
insert into casting values (109,1188,8);
insert into casting values (184,1188,5);
insert into casting values (1021,1189,5);
insert into casting values (1054,1189,10);
insert into casting values (1332,1189,10);
insert into casting values (1607,1189,8);
insert into casting values (1717,1189,4);
insert into casting values (360,1189,7);
insert into casting values (408,1189,14);
insert into casting values (557,1189,6);
insert into casting values (1300,1190,7);
insert into casting values (1600,1190,6);
insert into casting values (80,1190,13);
insert into casting values (58,1190,7);
insert into casting values (296,1190,10);
insert into casting values (188,1190,5);
insert into casting values (170,1190,11);
insert into casting values (55,1190,5);
insert into casting values (870,1191,9);
insert into casting values (1421,1191,12);
insert into casting values (1261,1191,8);
insert into casting values (1262,1191,8);
insert into casting values (85,1191,5);
insert into casting values (179,1191,7);
insert into casting values (623,1191,10);
insert into casting values (430,1191,7);
insert into casting values (852,1192,5);
insert into casting values (1704,1192,3);
insert into casting values (566,1192,5);
insert into casting values (647,1192,6);
insert into casting values (587,1192,11);
insert into casting values (1428,1193,1);
insert into casting values (1444,1193,7);
insert into casting values (1598,1193,10);
insert into casting values (101,1193,3);
insert into casting values (701,1193,12);
insert into casting values (929,1194,1);
insert into casting values (1092,1194,6);
insert into casting values (1366,1194,5);
insert into casting values (1500,1194,14);
insert into casting values (174,1194,10);
insert into casting values (923,1195,4);
insert into casting values (1392,1195,13);
insert into casting values (1647,1195,3);
insert into casting values (1515,1195,9);
insert into casting values (8,1195,10);
--- tabcasting, 6601, 50
insert into casting values (563,1195,3);
insert into casting values (1447,1196,6);
insert into casting values (1440,1196,2);
insert into casting values (1660,1196,3);
insert into casting values (1740,1196,14);
insert into casting values (214,1196,6);
insert into casting values (363,1196,6);
insert into casting values (568,1196,15);
insert into casting values (1264,1197,4);
insert into casting values (1394,1197,3);
insert into casting values (1127,1197,4);
insert into casting values (122,1197,14);
insert into casting values (197,1197,13);
insert into casting values (591,1197,8);
insert into casting values (1370,1198,4);
insert into casting values (1811,1198,12);
insert into casting values (1801,1198,12);
insert into casting values (45,1198,4);
insert into casting values (700,1198,4);
insert into casting values (430,1198,6);
insert into casting values (1092,1199,11);
insert into casting values (1017,1199,3);
insert into casting values (58,1199,15);
insert into casting values (173,1199,4);
insert into casting values (256,1199,7);
insert into casting values (394,1199,5);
insert into casting values (956,1200,10);
insert into casting values (1003,1200,4);
insert into casting values (972,1200,12);
insert into casting values (1228,1200,7);
insert into casting values (346,1200,9);
insert into casting values (256,1200,6);
insert into casting values (712,1200,5);
insert into casting values (942,1201,14);
insert into casting values (1239,1201,6);
insert into casting values (1284,1201,11);
insert into casting values (1529,1201,8);
insert into casting values (1630,1201,9);
insert into casting values (84,1201,7);
insert into casting values (296,1201,7);
insert into casting values (370,1201,4);
insert into casting values (782,1202,12);
insert into casting values (1235,1202,5);
insert into casting values (167,1202,3);
insert into casting values (2,1202,5);
insert into casting values (77,1202,6);
insert into casting values (507,1202,10);
insert into casting values (865,1203,5);
insert into casting values (1808,1203,4);
insert into casting values (1598,1203,9);
--- tabcasting, 6651, 50
insert into casting values (46,1203,4);
insert into casting values (209,1203,10);
insert into casting values (441,1203,13);
insert into casting values (1197,1204,4);
insert into casting values (1524,1204,8);
insert into casting values (1839,1204,15);
insert into casting values (140,1204,15);
insert into casting values (112,1204,7);
insert into casting values (80,1204,9);
insert into casting values (16,1204,4);
insert into casting values (930,1205,13);
insert into casting values (1378,1205,10);
insert into casting values (1389,1205,1);
insert into casting values (1527,1205,5);
insert into casting values (594,1205,9);
insert into casting values (111,1206,12);
insert into casting values (280,1206,3);
insert into casting values (300,1206,7);
insert into casting values (19,1206,12);
insert into casting values (68,1206,3);
insert into casting values (252,1206,3);
insert into casting values (1304,1207,2);
insert into casting values (1240,1207,6);
insert into casting values (292,1207,4);
insert into casting values (92,1207,7);
insert into casting values (500,1207,11);
insert into casting values (515,1207,12);
insert into casting values (418,1207,7);
insert into casting values (741,1208,9);
insert into casting values (1322,1208,4);
insert into casting values (1703,1208,3);
insert into casting values (400,1208,10);
insert into casting values (402,1208,10);
insert into casting values (740,1209,12);
insert into casting values (946,1209,4);
insert into casting values (1624,1209,4);
insert into casting values (1521,1209,7);
insert into casting values (263,1209,4);
insert into casting values (947,1210,3);
insert into casting values (1776,1210,2);
insert into casting values (139,1210,3);
insert into casting values (365,1210,9);
insert into casting values (411,1210,15);
insert into casting values (1004,1211,5);
insert into casting values (1734,1211,6);
insert into casting values (1710,1211,2);
insert into casting values (252,1211,10);
insert into casting values (583,1211,5);
insert into casting values (1057,1212,2);
insert into casting values (1347,1212,3);
--- tabcasting, 6701, 50
insert into casting values (1319,1212,5);
insert into casting values (1323,1212,7);
insert into casting values (230,1212,11);
insert into casting values (856,1213,10);
insert into casting values (1259,1213,8);
insert into casting values (1313,1213,2);
insert into casting values (1396,1213,7);
insert into casting values (1684,1213,6);
insert into casting values (471,1213,3);
insert into casting values (891,1214,11);
insert into casting values (775,1214,6);
insert into casting values (1633,1214,4);
insert into casting values (446,1214,6);
insert into casting values (448,1214,4);
insert into casting values (466,1214,6);
insert into casting values (1392,1215,3);
insert into casting values (98,1215,6);
insert into casting values (174,1215,13);
insert into casting values (95,1215,3);
insert into casting values (515,1215,4);
insert into casting values (793,1216,2);
insert into casting values (1493,1216,1);
insert into casting values (314,1216,12);
insert into casting values (514,1216,6);
insert into casting values (998,1217,3);
insert into casting values (1676,1217,8);
insert into casting values (1518,1217,3);
insert into casting values (214,1217,11);
insert into casting values (570,1217,3);
insert into casting values (1786,1218,2);
insert into casting values (115,1218,6);
insert into casting values (4,1218,11);
insert into casting values (614,1218,5);
insert into casting values (1428,1219,7);
insert into casting values (1290,1219,5);
insert into casting values (365,1219,5);
insert into casting values (384,1219,5);
insert into casting values (714,1219,11);
insert into casting values (816,1220,5);
insert into casting values (1294,1220,5);
insert into casting values (1324,1220,3);
insert into casting values (1724,1220,11);
insert into casting values (132,1220,8);
insert into casting values (1343,1221,4);
insert into casting values (1799,1221,4);
insert into casting values (36,1221,9);
insert into casting values (672,1221,5);
insert into casting values (1195,1222,10);
insert into casting values (1340,1222,11);
insert into casting values (1718,1222,14);
--- tabcasting, 6751, 50
insert into casting values (1742,1222,8);
insert into casting values (1737,1222,10);
insert into casting values (1788,1222,12);
insert into casting values (200,1222,11);
insert into casting values (116,1222,7);
insert into casting values (57,1222,5);
insert into casting values (36,1222,5);
insert into casting values (954,1223,7);
insert into casting values (1480,1223,3);
insert into casting values (1726,1223,1);
insert into casting values (634,1223,12);
insert into casting values (779,1224,4);
insert into casting values (1292,1224,13);
insert into casting values (1627,1224,7);
insert into casting values (194,1224,4);
insert into casting values (567,1224,8);
insert into casting values (844,1225,4);
insert into casting values (1487,1225,1);
insert into casting values (1730,1225,9);
insert into casting values (349,1225,15);
insert into casting values (884,1226,5);
insert into casting values (732,1226,27);
insert into casting values (1187,1226,6);
insert into casting values (1585,1226,11);
insert into casting values (1678,1226,2);
insert into casting values (119,1226,5);
insert into casting values (1352,1227,3);
insert into casting values (1392,1227,8);
insert into casting values (661,1227,2);
insert into casting values (609,1227,6);
insert into casting values (577,1227,7);
insert into casting values (506,1227,10);
insert into casting values (885,1228,12);
insert into casting values (1550,1228,3);
insert into casting values (1548,1228,2);
insert into casting values (286,1228,2);
insert into casting values (529,1228,6);
insert into casting values (1035,1229,4);
insert into casting values (753,1229,3);
insert into casting values (1822,1229,10);
insert into casting values (1551,1229,8);
insert into casting values (588,1229,9);
insert into casting values (934,1230,6);
insert into casting values (1076,1230,8);
insert into casting values (1515,1230,6);
insert into casting values (159,1230,4);
insert into casting values (521,1230,11);
insert into casting values (621,1230,9);
insert into casting values (657,1230,8);
insert into casting values (952,1231,3);
--- tabcasting, 6801, 50
insert into casting values (1716,1231,5);
insert into casting values (168,1231,3);
insert into casting values (468,1231,13);
insert into casting values (704,1231,6);
insert into casting values (1314,1232,12);
insert into casting values (1229,1232,4);
insert into casting values (15,1232,6);
insert into casting values (979,1233,4);
insert into casting values (1608,1233,4);
insert into casting values (1663,1233,4);
insert into casting values (162,1233,12);
insert into casting values (458,1233,8);
insert into casting values (902,1234,2);
insert into casting values (757,1234,2);
insert into casting values (1286,1234,7);
insert into casting values (186,1234,12);
insert into casting values (110,1234,4);
insert into casting values (1400,1235,10);
insert into casting values (1271,1235,1);
insert into casting values (1477,1235,6);
insert into casting values (325,1235,2);
insert into casting values (1034,1236,12);
insert into casting values (1827,1236,6);
insert into casting values (180,1236,8);
insert into casting values (127,1236,4);
insert into casting values (354,1236,6);
insert into casting values (385,1236,9);
insert into casting values (547,1236,6);
insert into casting values (1235,1237,7);
insert into casting values (1118,1237,20);
insert into casting values (1769,1237,2);
insert into casting values (106,1237,1);
insert into casting values (811,1238,2);
insert into casting values (856,1238,11);
insert into casting values (1128,1238,5);
insert into casting values (1206,1238,5);
insert into casting values (395,1238,7);
insert into casting values (955,1239,15);
insert into casting values (1160,1239,5);
insert into casting values (1279,1239,2);
insert into casting values (1791,1239,5);
insert into casting values (143,1239,7);
insert into casting values (1180,1240,12);
insert into casting values (1182,1240,1);
insert into casting values (139,1240,6);
insert into casting values (610,1240,5);
insert into casting values (1182,1241,2);
insert into casting values (1412,1241,8);
insert into casting values (1365,1241,10);
insert into casting values (1796,1241,1);
--- tabcasting, 6851, 50
insert into casting values (1329,1242,4);
insert into casting values (1730,1242,6);
insert into casting values (300,1242,5);
insert into casting values (73,1242,11);
insert into casting values (2,1242,9);
insert into casting values (132,1242,7);
insert into casting values (1091,1243,2);
insert into casting values (1561,1243,7);
insert into casting values (6,1243,1);
insert into casting values (898,1244,7);
insert into casting values (1272,1244,6);
insert into casting values (1493,1244,3);
insert into casting values (1706,1244,8);
insert into casting values (1518,1244,2);
insert into casting values (977,1245,2);
insert into casting values (988,1245,7);
insert into casting values (1416,1245,2);
insert into casting values (1633,1245,2);
insert into casting values (742,1246,9);
insert into casting values (821,1246,6);
insert into casting values (1104,1246,4);
insert into casting values (1784,1246,9);
insert into casting values (132,1246,9);
insert into casting values (459,1246,7);
insert into casting values (1155,1247,13);
insert into casting values (1681,1247,7);
insert into casting values (1812,1247,6);
insert into casting values (207,1247,11);
insert into casting values (635,1247,6);
insert into casting values (598,1247,5);
insert into casting values (411,1247,14);
insert into casting values (527,1247,15);
insert into casting values (706,1247,11);
insert into casting values (462,1247,6);
insert into casting values (1017,1248,4);
insert into casting values (32,1248,3);
insert into casting values (136,1248,6);
insert into casting values (305,1248,4);
insert into casting values (736,1249,6);
insert into casting values (762,1249,6);
insert into casting values (995,1249,9);
insert into casting values (1461,1249,5);
insert into casting values (63,1249,9);
insert into casting values (607,1249,6);
insert into casting values (940,1250,2);
insert into casting values (8,1250,6);
insert into casting values (420,1250,3);
insert into casting values (843,1251,3);
insert into casting values (863,1251,5);
insert into casting values (1455,1251,5);
--- tabcasting, 6901, 50
insert into casting values (532,1251,6);
insert into casting values (785,1252,3);
insert into casting values (1308,1252,3);
insert into casting values (529,1252,2);
insert into casting values (411,1252,8);
insert into casting values (1088,1253,8);
insert into casting values (1010,1253,2);
insert into casting values (1688,1253,9);
insert into casting values (623,1253,7);
insert into casting values (449,1253,5);
insert into casting values (1347,1254,2);
insert into casting values (232,1254,7);
insert into casting values (718,1254,2);
insert into casting values (1555,1255,3);
insert into casting values (109,1255,3);
insert into casting values (182,1255,4);
insert into casting values (73,1255,7);
insert into casting values (920,1256,4);
insert into casting values (1175,1256,4);
insert into casting values (1550,1256,2);
insert into casting values (553,1256,7);
insert into casting values (827,1257,3);
insert into casting values (1258,1257,4);
insert into casting values (1112,1257,6);
insert into casting values (338,1257,5);
insert into casting values (137,1258,8);
insert into casting values (305,1258,5);
insert into casting values (106,1258,4);
insert into casting values (812,1259,4);
insert into casting values (1466,1259,7);
insert into casting values (1509,1259,7);
insert into casting values (606,1259,4);
insert into casting values (396,1259,9);
insert into casting values (780,1260,2);
insert into casting values (516,1260,6);
insert into casting values (1750,1261,9);
insert into casting values (1685,1261,4);
insert into casting values (505,1261,1);
insert into casting values (753,1262,5);
insert into casting values (1331,1262,6);
insert into casting values (220,1262,8);
insert into casting values (600,1262,9);
insert into casting values (642,1262,2);
insert into casting values (842,1263,5);
insert into casting values (106,1263,3);
insert into casting values (262,1263,4);
insert into casting values (314,1263,8);
insert into casting values (882,1264,7);
insert into casting values (1225,1264,3);
insert into casting values (1684,1264,5);
--- tabcasting, 6951, 50
insert into casting values (298,1264,4);
insert into casting values (235,1265,6);
insert into casting values (110,1265,3);
insert into casting values (425,1265,2);
insert into casting values (512,1265,3);
insert into casting values (1581,1266,7);
insert into casting values (1764,1266,9);
insert into casting values (35,1266,7);
insert into casting values (495,1266,3);
insert into casting values (477,1266,3);
insert into casting values (954,1267,5);
insert into casting values (1114,1267,7);
insert into casting values (890,1268,6);
insert into casting values (357,1268,1);
insert into casting values (76,1268,5);
insert into casting values (821,1269,2);
insert into casting values (1425,1269,4);
insert into casting values (1376,1269,7);
insert into casting values (164,1269,3);
insert into casting values (1028,1270,1);
insert into casting values (1645,1270,3);
insert into casting values (595,1270,8);
insert into casting values (804,1271,9);
insert into casting values (1823,1271,4);
insert into casting values (1484,1271,4);
insert into casting values (719,1271,3);
insert into casting values (1436,1272,2);
insert into casting values (1513,1272,4);
insert into casting values (273,1272,9);
insert into casting values (599,1272,3);
insert into casting values (755,1273,5);
insert into casting values (910,1273,2);
insert into casting values (1831,1273,2);
insert into casting values (223,1273,7);
insert into casting values (1090,1274,5);
insert into casting values (127,1274,9);
insert into casting values (308,1274,1);
insert into casting values (992,1275,4);
insert into casting values (748,1275,3);
insert into casting values (1391,1275,7);
insert into casting values (1342,1275,5);
insert into casting values (920,1276,6);
insert into casting values (734,1276,4);
insert into casting values (1208,1276,6);
insert into casting values (644,1276,4);
insert into casting values (757,1277,1);
insert into casting values (1154,1277,3);
insert into casting values (1593,1277,6);
insert into casting values (1561,1278,8);
insert into casting values (95,1278,2);
--- tabcasting, 7001, 50
insert into casting values (282,1278,2);
insert into casting values (413,1278,2);
insert into casting values (854,1279,28);
insert into casting values (765,1279,9);
insert into casting values (812,1279,5);
insert into casting values (212,1279,3);
insert into casting values (626,1279,4);
insert into casting values (740,1280,4);
insert into casting values (961,1280,6);
insert into casting values (1756,1280,3);
insert into casting values (463,1280,9);
insert into casting values (616,1280,9);
insert into casting values (1258,1281,7);
insert into casting values (1603,1281,3);
insert into casting values (1639,1281,5);
insert into casting values (416,1281,5);
insert into casting values (1285,1282,5);
insert into casting values (1640,1282,9);
insert into casting values (1607,1282,5);
insert into casting values (429,1282,3);
insert into casting values (1294,1283,7);
insert into casting values (1489,1283,2);
insert into casting values (282,1283,1);
insert into casting values (927,1284,4);
insert into casting values (1315,1284,3);
insert into casting values (384,1284,9);
insert into casting values (419,1284,4);
insert into casting values (1839,1285,8);
insert into casting values (1747,1285,4);
insert into casting values (46,1285,6);
insert into casting values (83,1285,9);
insert into casting values (625,1285,3);
insert into casting values (1378,1286,9);
insert into casting values (162,1286,6);
insert into casting values (255,1286,3);
insert into casting values (459,1286,8);
insert into casting values (465,1286,3);
insert into casting values (1099,1287,3);
insert into casting values (1365,1287,5);
insert into casting values (1359,1287,7);
insert into casting values (1700,1287,4);
insert into casting values (1233,1288,5);
insert into casting values (66,1288,1);
insert into casting values (508,1288,6);
insert into casting values (986,1289,7);
insert into casting values (927,1289,11);
insert into casting values (854,1289,16);
insert into casting values (1352,1289,11);
insert into casting values (1341,1289,4);
insert into casting values (1706,1289,9);
--- tabcasting, 7051, 50
insert into casting values (101,1289,11);
insert into casting values (513,1289,3);
insert into casting values (669,1289,11);
insert into casting values (969,1290,9);
insert into casting values (913,1290,7);
insert into casting values (97,1290,5);
insert into casting values (225,1290,5);
insert into casting values (622,1290,8);
insert into casting values (1765,1291,3);
insert into casting values (1482,1291,2);
insert into casting values (399,1291,9);
insert into casting values (593,1291,3);
insert into casting values (1575,1292,1);
insert into casting values (1587,1292,8);
insert into casting values (316,1292,3);
insert into casting values (1027,1293,6);
insert into casting values (1670,1293,4);
insert into casting values (1753,1293,6);
insert into casting values (4,1293,8);
insert into casting values (484,1293,5);
insert into casting values (1016,1294,6);
insert into casting values (1427,1294,5);
insert into casting values (1628,1294,4);
insert into casting values (746,1295,6);
insert into casting values (1375,1295,3);
insert into casting values (1182,1295,3);
insert into casting values (789,1296,3);
insert into casting values (898,1296,4);
insert into casting values (1156,1296,7);
insert into casting values (178,1296,4);
insert into casting values (875,1297,4);
insert into casting values (1364,1297,1);
insert into casting values (527,1297,8);
insert into casting values (265,1298,7);
insert into casting values (639,1298,3);
insert into casting values (567,1298,2);
insert into casting values (679,1298,4);
insert into casting values (1401,1299,4);
insert into casting values (260,1299,2);
insert into casting values (353,1299,2);
insert into casting values (234,1299,6);
insert into casting values (1621,1300,3);
insert into casting values (333,1300,9);
insert into casting values (564,1300,4);
insert into casting values (1075,1301,4);
insert into casting values (89,1301,3);
insert into casting values (501,1301,4);
insert into casting values (373,1301,9);
insert into casting values (1191,1302,7);
insert into casting values (1442,1302,2);
--- tabcasting, 7101, 50
insert into casting values (75,1302,2);
insert into casting values (102,1302,9);
insert into casting values (603,1302,8);
insert into casting values (784,1303,9);
insert into casting values (1483,1303,5);
insert into casting values (1759,1303,4);
insert into casting values (332,1303,7);
insert into casting values (519,1303,9);
insert into casting values (1083,1304,2);
insert into casting values (1390,1304,2);
insert into casting values (530,1304,6);
insert into casting values (607,1304,5);
insert into casting values (1276,1305,7);
insert into casting values (1770,1305,5);
insert into casting values (1559,1305,3);
insert into casting values (208,1305,3);
insert into casting values (853,1306,1);
insert into casting values (1399,1306,6);
insert into casting values (1304,1306,9);
insert into casting values (440,1306,6);
insert into casting values (1018,1307,7);
insert into casting values (803,1307,7);
insert into casting values (1006,1307,10);
insert into casting values (764,1307,9);
insert into casting values (1310,1307,13);
insert into casting values (1523,1307,5);
insert into casting values (344,1307,7);
insert into casting values (360,1307,10);
insert into casting values (333,1307,13);
insert into casting values (1027,1308,9);
insert into casting values (1073,1308,15);
insert into casting values (1289,1308,6);
insert into casting values (1136,1308,6);
insert into casting values (1654,1308,4);
insert into casting values (73,1308,6);
insert into casting values (392,1308,14);
insert into casting values (382,1308,13);
insert into casting values (373,1308,10);
insert into casting values (1039,1309,11);
insert into casting values (861,1309,6);
insert into casting values (784,1309,8);
insert into casting values (1358,1309,12);
insert into casting values (1813,1309,2);
insert into casting values (1604,1309,12);
insert into casting values (251,1309,5);
insert into casting values (62,1309,11);
insert into casting values (919,1310,4);
insert into casting values (1659,1310,4);
insert into casting values (1594,1310,8);
insert into casting values (1607,1310,13);
--- tabcasting, 7151, 50
insert into casting values (212,1310,11);
insert into casting values (186,1310,10);
insert into casting values (449,1310,8);
insert into casting values (790,1311,6);
insert into casting values (819,1311,2);
insert into casting values (1410,1311,8);
insert into casting values (1595,1311,14);
insert into casting values (132,1311,10);
insert into casting values (216,1311,7);
insert into casting values (125,1311,8);
insert into casting values (627,1311,14);
insert into casting values (1034,1312,15);
insert into casting values (985,1312,7);
insert into casting values (1077,1312,14);
insert into casting values (841,1312,7);
insert into casting values (1717,1312,6);
insert into casting values (1524,1312,7);
insert into casting values (1491,1312,9);
insert into casting values (307,1312,10);
insert into casting values (451,1312,7);
insert into casting values (758,1313,4);
insert into casting values (1806,1313,5);
insert into casting values (22,1313,4);
insert into casting values (90,1313,10);
insert into casting values (274,1313,11);
insert into casting values (58,1313,10);
insert into casting values (1401,1314,13);
insert into casting values (1282,1314,2);
insert into casting values (1755,1314,4);
insert into casting values (1712,1314,3);
insert into casting values (9,1314,12);
insert into casting values (223,1314,10);
insert into casting values (762,1315,10);
insert into casting values (1096,1315,3);
insert into casting values (890,1315,15);
insert into casting values (1810,1315,4);
insert into casting values (669,1315,12);
insert into casting values (545,1315,4);
insert into casting values (987,1316,10);
insert into casting values (1112,1316,4);
insert into casting values (1277,1316,5);
insert into casting values (1718,1316,2);
insert into casting values (701,1316,14);
insert into casting values (724,1316,11);
insert into casting values (740,1317,6);
insert into casting values (1565,1317,3);
insert into casting values (92,1317,6);
insert into casting values (674,1317,3);
insert into casting values (499,1317,11);
insert into casting values (787,1318,4);
--- tabcasting, 7201, 50
insert into casting values (1332,1318,7);
insert into casting values (1755,1318,13);
insert into casting values (291,1318,9);
insert into casting values (613,1318,4);
insert into casting values (1006,1319,4);
insert into casting values (1220,1319,15);
insert into casting values (58,1319,4);
insert into casting values (320,1319,2);
insert into casting values (535,1319,11);
insert into casting values (1170,1320,11);
insert into casting values (1310,1320,5);
insert into casting values (1706,1320,3);
insert into casting values (1701,1320,8);
insert into casting values (144,1320,11);
insert into casting values (118,1320,6);
insert into casting values (750,1321,10);
insert into casting values (406,1321,8);
insert into casting values (606,1321,10);
insert into casting values (591,1321,9);
insert into casting values (1267,1322,4);
insert into casting values (1696,1322,10);
insert into casting values (94,1322,5);
insert into casting values (683,1322,4);
insert into casting values (551,1322,12);
insert into casting values (1374,1323,11);
insert into casting values (1156,1323,4);
insert into casting values (163,1323,2);
insert into casting values (653,1323,3);
insert into casting values (428,1323,11);
insert into casting values (1102,1324,4);
insert into casting values (1567,1324,1);
insert into casting values (1529,1324,13);
insert into casting values (625,1324,10);
insert into casting values (1095,1325,3);
insert into casting values (1355,1325,15);
insert into casting values (1625,1325,7);
insert into casting values (1565,1325,9);
insert into casting values (1585,1325,4);
insert into casting values (98,1325,10);
insert into casting values (903,1326,5);
insert into casting values (1675,1326,8);
insert into casting values (1659,1326,15);
insert into casting values (102,1326,14);
insert into casting values (244,1326,8);
insert into casting values (560,1326,5);
insert into casting values (1203,1327,5);
insert into casting values (1839,1327,14);
insert into casting values (1811,1327,3);
insert into casting values (1678,1327,10);
insert into casting values (717,1327,2);
--- tabcasting, 7251, 50
insert into casting values (818,1328,5);
insert into casting values (792,1328,8);
insert into casting values (1363,1328,8);
insert into casting values (1332,1328,11);
insert into casting values (1678,1328,6);
insert into casting values (1817,1328,14);
insert into casting values (477,1328,7);
insert into casting values (868,1329,7);
insert into casting values (1171,1329,8);
insert into casting values (1516,1329,13);
insert into casting values (6,1329,11);
insert into casting values (780,1330,13);
insert into casting values (1507,1330,1);
insert into casting values (131,1330,9);
insert into casting values (414,1330,14);
insert into casting values (509,1330,6);
insert into casting values (1449,1331,10);
insert into casting values (1160,1331,6);
insert into casting values (1370,1331,13);
insert into casting values (1502,1331,5);
insert into casting values (125,1331,5);
insert into casting values (654,1331,8);
insert into casting values (1668,1332,5);
insert into casting values (1706,1332,12);
insert into casting values (1820,1332,12);
insert into casting values (119,1332,2);
insert into casting values (42,1332,4);
insert into casting values (1070,1333,11);
insert into casting values (1669,1333,4);
insert into casting values (198,1333,7);
insert into casting values (225,1333,10);
insert into casting values (596,1333,8);
insert into casting values (697,1333,5);
insert into casting values (791,1334,2);
insert into casting values (1356,1334,12);
insert into casting values (114,1334,13);
insert into casting values (546,1334,1);
insert into casting values (954,1335,6);
insert into casting values (1086,1335,5);
insert into casting values (1122,1335,9);
insert into casting values (1354,1335,13);
insert into casting values (1829,1335,15);
insert into casting values (1630,1335,4);
insert into casting values (879,1336,6);
insert into casting values (952,1336,5);
insert into casting values (1215,1336,6);
insert into casting values (453,1336,14);
insert into casting values (582,1336,4);
insert into casting values (1175,1337,5);
insert into casting values (124,1337,3);
--- tabcasting, 7301, 50
insert into casting values (465,1337,2);
insert into casting values (598,1337,12);
insert into casting values (1382,1338,1);
insert into casting values (1743,1338,8);
insert into casting values (322,1338,7);
insert into casting values (19,1338,13);
insert into casting values (984,1339,5);
insert into casting values (1837,1339,2);
insert into casting values (209,1339,11);
insert into casting values (642,1339,3);
insert into casting values (992,1340,5);
insert into casting values (978,1340,10);
insert into casting values (1839,1340,1);
insert into casting values (1063,1341,2);
insert into casting values (1441,1341,1);
insert into casting values (1576,1341,13);
insert into casting values (1203,1342,9);
insert into casting values (50,1342,8);
insert into casting values (167,1342,13);
insert into casting values (9,1342,4);
insert into casting values (685,1342,2);
insert into casting values (864,1343,10);
insert into casting values (1458,1343,6);
insert into casting values (1514,1343,9);
insert into casting values (140,1343,5);
insert into casting values (712,1343,4);
insert into casting values (973,1344,7);
insert into casting values (1359,1344,9);
insert into casting values (1388,1344,2);
insert into casting values (177,1344,3);
insert into casting values (14,1344,10);
insert into casting values (1685,1345,11);
insert into casting values (1826,1345,8);
insert into casting values (110,1345,8);
insert into casting values (17,1345,5);
insert into casting values (13,1345,8);
insert into casting values (640,1345,6);
insert into casting values (734,1346,14);
insert into casting values (1460,1346,1);
insert into casting values (135,1346,5);
insert into casting values (1091,1347,3);
insert into casting values (1388,1347,4);
insert into casting values (1823,1347,11);
insert into casting values (48,1347,4);
insert into casting values (896,1348,1);
insert into casting values (1076,1348,10);
insert into casting values (1685,1348,2);
insert into casting values (889,1349,2);
insert into casting values (899,1349,10);
insert into casting values (1139,1349,2);
--- tabcasting, 7351, 50
insert into casting values (693,1349,2);
insert into casting values (1542,1350,3);
insert into casting values (362,1350,4);
insert into casting values (704,1350,5);
insert into casting values (1111,1351,2);
insert into casting values (249,1351,2);
insert into casting values (476,1351,13);
insert into casting values (594,1351,2);
insert into casting values (1227,1352,4);
insert into casting values (1457,1352,12);
insert into casting values (1702,1352,4);
insert into casting values (184,1352,8);
insert into casting values (379,1352,8);
insert into casting values (1471,1353,6);
insert into casting values (269,1353,15);
insert into casting values (400,1353,6);
insert into casting values (670,1353,4);
insert into casting values (580,1353,3);
insert into casting values (739,1354,10);
insert into casting values (1433,1354,4);
insert into casting values (1766,1354,4);
insert into casting values (131,1354,8);
insert into casting values (662,1354,7);
insert into casting values (735,1355,4);
insert into casting values (1023,1355,14);
insert into casting values (226,1355,4);
insert into casting values (529,1355,8);
insert into casting values (1141,1356,6);
insert into casting values (1657,1356,10);
insert into casting values (251,1356,9);
insert into casting values (175,1356,2);
insert into casting values (863,1357,4);
insert into casting values (814,1357,4);
insert into casting values (1639,1357,8);
insert into casting values (26,1357,7);
insert into casting values (521,1357,12);
insert into casting values (992,1358,2);
insert into casting values (1513,1358,10);
insert into casting values (619,1358,5);
insert into casting values (1260,1359,3);
insert into casting values (1313,1359,12);
insert into casting values (30,1359,4);
insert into casting values (282,1359,3);
insert into casting values (1560,1360,5);
insert into casting values (203,1360,10);
insert into casting values (691,1360,1);
insert into casting values (1821,1361,11);
insert into casting values (1785,1361,2);
insert into casting values (902,1362,5);
insert into casting values (1827,1362,7);
--- tabcasting, 7401, 50
insert into casting values (364,1362,9);
insert into casting values (308,1362,7);
insert into casting values (399,1362,11);
insert into casting values (696,1362,8);
insert into casting values (835,1363,12);
insert into casting values (1592,1363,1);
insert into casting values (454,1363,4);
insert into casting values (1089,1364,9);
insert into casting values (1009,1364,2);
insert into casting values (1270,1364,3);
insert into casting values (1718,1364,10);
insert into casting values (633,1365,4);
insert into casting values (471,1365,1);
insert into casting values (439,1365,14);
insert into casting values (1203,1366,4);
insert into casting values (1740,1366,2);
insert into casting values (390,1366,14);
insert into casting values (1352,1367,6);
insert into casting values (1540,1367,8);
insert into casting values (287,1367,8);
insert into casting values (418,1367,8);
insert into casting values (609,1367,4);
insert into casting values (554,1367,15);
insert into casting values (1659,1368,8);
insert into casting values (20,1368,4);
insert into casting values (428,1368,7);
insert into casting values (411,1368,11);
insert into casting values (538,1368,5);
insert into casting values (838,1369,5);
insert into casting values (1019,1369,3);
insert into casting values (816,1369,9);
insert into casting values (1132,1369,8);
insert into casting values (139,1369,12);
insert into casting values (1345,1370,4);
insert into casting values (1506,1370,7);
insert into casting values (94,1370,15);
insert into casting values (159,1370,9);
insert into casting values (376,1370,4);
insert into casting values (1365,1371,12);
insert into casting values (1194,1371,1);
insert into casting values (1728,1371,4);
insert into casting values (864,1372,3);
insert into casting values (1706,1372,10);
insert into casting values (122,1372,3);
insert into casting values (371,1372,4);
insert into casting values (839,1373,15);
insert into casting values (1733,1373,1);
insert into casting values (436,1373,3);
insert into casting values (815,1374,7);
insert into casting values (1425,1374,11);
--- tabcasting, 7451, 50
insert into casting values (1547,1374,4);
insert into casting values (174,1374,5);
insert into casting values (1461,1375,6);
insert into casting values (1135,1375,3);
insert into casting values (1527,1375,7);
insert into casting values (226,1375,5);
insert into casting values (594,1375,10);
insert into casting values (253,1376,2);
insert into casting values (515,1376,1);
insert into casting values (664,1376,12);
insert into casting values (799,1377,9);
insert into casting values (1273,1377,1);
insert into casting values (1267,1377,11);
insert into casting values (1247,1377,7);
insert into casting values (1154,1378,10);
insert into casting values (152,1378,3);
insert into casting values (397,1378,2);
insert into casting values (460,1378,4);
insert into casting values (1067,1379,1);
insert into casting values (1208,1379,5);
insert into casting values (1614,1379,13);
insert into casting values (793,1380,10);
insert into casting values (1774,1380,2);
insert into casting values (401,1380,8);
insert into casting values (728,1380,9);
insert into casting values (550,1380,5);
insert into casting values (1106,1381,1);
insert into casting values (142,1381,10);
insert into casting values (337,1381,2);
insert into casting values (1020,1382,3);
insert into casting values (1177,1382,11);
insert into casting values (1685,1382,7);
insert into casting values (1736,1382,6);
insert into casting values (110,1382,7);
insert into casting values (517,1382,6);
insert into casting values (1075,1383,3);
insert into casting values (1427,1383,15);
insert into casting values (1786,1383,3);
insert into casting values (1662,1383,3);
insert into casting values (871,1384,12);
insert into casting values (1332,1384,5);
insert into casting values (360,1384,6);
insert into casting values (192,1384,8);
insert into casting values (474,1384,5);
insert into casting values (819,1385,5);
insert into casting values (891,1385,5);
insert into casting values (1747,1385,7);
insert into casting values (80,1385,12);
insert into casting values (657,1385,6);
insert into casting values (1192,1386,5);
--- tabcasting, 7501, 50
insert into casting values (1366,1386,3);
insert into casting values (1479,1386,7);
insert into casting values (716,1386,13);
insert into casting values (666,1386,8);
insert into casting values (1083,1387,3);
insert into casting values (1049,1387,4);
insert into casting values (1162,1387,10);
insert into casting values (626,1387,3);
insert into casting values (880,1388,10);
insert into casting values (91,1388,5);
insert into casting values (272,1388,4);
insert into casting values (656,1388,5);
insert into casting values (886,1389,3);
insert into casting values (1409,1389,3);
insert into casting values (1448,1389,2);
insert into casting values (364,1389,12);
insert into casting values (971,1390,15);
insert into casting values (826,1390,2);
insert into casting values (580,1390,1);
insert into casting values (1071,1391,4);
insert into casting values (411,1391,2);
insert into casting values (418,1391,15);
insert into casting values (523,1391,3);
insert into casting values (1051,1392,8);
insert into casting values (1085,1392,7);
insert into casting values (112,1392,8);
insert into casting values (292,1392,13);
insert into casting values (395,1392,8);
insert into casting values (436,1392,8);
insert into casting values (721,1392,8);
insert into casting values (793,1393,6);
insert into casting values (885,1393,6);
insert into casting values (1396,1393,6);
insert into casting values (1158,1393,6);
insert into casting values (1564,1393,2);
insert into casting values (110,1393,15);
insert into casting values (914,1394,2);
insert into casting values (1454,1394,1);
insert into casting values (798,1395,3);
insert into casting values (552,1395,4);
insert into casting values (718,1395,3);
insert into casting values (959,1396,9);
insert into casting values (1169,1396,5);
insert into casting values (1244,1396,4);
insert into casting values (43,1396,7);
insert into casting values (1055,1397,2);
insert into casting values (1176,1397,2);
insert into casting values (1640,1397,7);
insert into casting values (218,1398,3);
insert into casting values (588,1398,5);
--- tabcasting, 7551, 50
insert into casting values (463,1398,4);
insert into casting values (1255,1399,8);
insert into casting values (235,1399,8);
insert into casting values (457,1399,1);
insert into casting values (956,1400,3);
insert into casting values (1583,1400,2);
insert into casting values (1474,1400,5);
insert into casting values (837,1401,3);
insert into casting values (1469,1401,3);
insert into casting values (19,1401,5);
insert into casting values (1183,1402,5);
insert into casting values (1165,1402,7);
insert into casting values (70,1402,7);
insert into casting values (576,1402,6);
insert into casting values (731,1402,6);
insert into casting values (1208,1403,2);
insert into casting values (1729,1403,1);
insert into casting values (1831,1404,7);
insert into casting values (384,1404,3);
insert into casting values (696,1404,9);
insert into casting values (1076,1405,2);
insert into casting values (1770,1405,3);
insert into casting values (214,1405,4);
insert into casting values (982,1406,3);
insert into casting values (206,1407,3);
insert into casting values (451,1407,1);
insert into casting values (1338,1408,1);
insert into casting values (1583,1409,3);
insert into casting values (1526,1409,1);
insert into casting values (77,1410,2);
insert into casting values (394,1410,4);
insert into casting values (1463,1411,3);
insert into casting values (1425,1411,1);
insert into casting values (1077,1412,9);
insert into casting values (908,1412,3);
insert into casting values (1581,1412,9);
insert into casting values (91,1412,3);
insert into casting values (1650,1413,1);
insert into casting values (141,1413,2);
insert into casting values (194,1414,3);
insert into casting values (18,1414,4);
insert into casting values (635,1414,4);
insert into casting values (802,1415,8);
insert into casting values (940,1415,6);
insert into casting values (1269,1415,3);
insert into casting values (187,1415,4);
insert into casting values (893,1416,3);
insert into casting values (1433,1416,2);
insert into casting values (212,1416,4);
insert into casting values (175,1417,4);
--- tabcasting, 7601, 50
insert into casting values (552,1417,1);
insert into casting values (1794,1418,5);
insert into casting values (262,1418,9);
insert into casting values (370,1418,5);
insert into casting values (691,1418,7);
insert into casting values (1635,1419,3);
insert into casting values (123,1419,3);
insert into casting values (225,1419,3);
insert into casting values (764,1420,8);
insert into casting values (913,1420,6);
insert into casting values (327,1420,9);
insert into casting values (123,1420,6);
insert into casting values (388,1420,4);
insert into casting values (937,1421,3);
insert into casting values (1371,1421,4);
insert into casting values (1258,1421,9);
insert into casting values (107,1421,9);
insert into casting values (1742,1422,4);
insert into casting values (314,1422,1);
insert into casting values (1027,1423,2);
insert into casting values (744,1423,3);
insert into casting values (1475,1423,5);
insert into casting values (1179,1424,2);
insert into casting values (1498,1424,1);
insert into casting values (1571,1425,1);
insert into casting values (234,1425,2);
insert into casting values (798,1426,1);
insert into casting values (1756,1426,2);
insert into casting values (23,1427,1);
insert into casting values (636,1427,5);
insert into casting values (860,1428,3);
insert into casting values (1388,1428,5);
insert into casting values (1769,1428,3);
insert into casting values (863,1429,9);
insert into casting values (814,1429,9);
insert into casting values (1708,1429,2);
insert into casting values (258,1429,8);
insert into casting values (521,1429,6);
insert into casting values (1105,1430,1);
insert into casting values (324,1430,5);
insert into casting values (1047,1431,4);
insert into casting values (1149,1431,3);
insert into casting values (327,1431,4);
insert into casting values (1813,1432,1);
insert into casting values (654,1432,4);
insert into casting values (879,1433,3);
insert into casting values (1482,1433,1);
insert into casting values (1412,1434,5);
insert into casting values (1605,1434,5);
insert into casting values (542,1434,5);
--- tabcasting, 7651, 50
insert into casting values (1150,1435,2);
insert into casting values (553,1435,2);
insert into casting values (643,1435,3);
insert into casting values (1114,1436,5);
insert into casting values (536,1436,1);
insert into casting values (1714,1437,8);
insert into casting values (288,1437,4);
insert into casting values (258,1437,7);
insert into casting values (283,1437,5);
insert into casting values (952,1438,2);
insert into casting values (1398,1438,1);
insert into casting values (1100,1439,2);
insert into casting values (996,1439,3);
insert into casting values (356,1439,3);
insert into casting values (1437,1440,2);
insert into casting values (1349,1440,3);
insert into casting values (238,1440,2);
insert into casting values (1251,1441,1);
insert into casting values (48,1441,2);
insert into casting values (694,1442,4);
insert into casting values (486,1442,2);
insert into casting values (376,1442,2);
insert into casting values (976,1443,1);
insert into casting values (1789,1443,2);
insert into casting values (1082,1444,1);
insert into casting values (1249,1444,3);
insert into casting values (918,1445,1);
insert into casting values (1207,1445,3);
insert into casting values (1670,1446,2);
insert into casting values (1834,1446,1);
insert into casting values (1666,1447,2);
insert into casting values (342,1447,5);
insert into casting values (430,1447,4);
insert into casting values (1127,1448,2);
insert into casting values (1585,1448,2);
insert into casting values (1042,1449,2);
insert into casting values (211,1449,2);
insert into casting values (189,1449,3);
insert into casting values (789,1450,6);
insert into casting values (852,1450,7);
insert into casting values (1354,1450,11);
insert into casting values (1127,1450,15);
insert into casting values (1502,1450,8);
insert into casting values (14,1450,11);
insert into casting values (154,1450,15);
insert into casting values (566,1450,4);
insert into casting values (401,1450,10);
insert into casting values (202,1451,5);
insert into casting values (356,1451,4);
insert into casting values (145,1451,2);
--- tabcasting, 7701, 50
insert into casting values (1340,1452,6);
insert into casting values (175,1452,5);
insert into casting values (621,1452,4);
insert into casting values (669,1452,9);
insert into casting values (913,1453,5);
insert into casting values (1610,1453,8);
insert into casting values (12,1453,8);
insert into casting values (41,1453,3);
insert into casting values (852,1454,3);
insert into casting values (1347,1454,5);
insert into casting values (245,1454,3);
insert into casting values (1349,1455,1);
insert into casting values (347,1455,5);
insert into casting values (1516,1456,1);
insert into casting values (527,1456,3);
insert into casting values (1479,1457,5);
insert into casting values (272,1457,2);
insert into casting values (656,1457,2);
insert into casting values (931,1458,6);
insert into casting values (1104,1458,3);
insert into casting values (1783,1458,7);
insert into casting values (64,1458,5);
insert into casting values (280,1459,5);
insert into casting values (68,1459,5);
insert into casting values (252,1459,5);
insert into casting values (868,1460,5);
insert into casting values (1791,1460,3);
insert into casting values (508,1460,4);
insert into casting values (1369,1461,2);
insert into casting values (1790,1461,1);
insert into casting values (77,1462,1);
insert into casting values (110,1462,5);
insert into casting values (880,1463,4);
insert into casting values (1401,1463,6);
insert into casting values (673,1463,4);
insert into casting values (610,1463,9);
insert into casting values (958,1464,1);
insert into casting values (1215,1464,2);
insert into casting values (1427,1465,2);
insert into casting values (1508,1465,1);
insert into casting values (1214,1466,1);
insert into casting values (1650,1466,3);
insert into casting values (896,1467,3);
insert into casting values (271,1467,5);
insert into casting values (580,1467,4);
insert into casting values (1042,1468,1);
insert into casting values (1312,1468,4);
insert into casting values (805,1469,3);
insert into casting values (1353,1470,1);
insert into casting values (672,1470,2);
--- tabcasting, 7751, 50
insert into casting values (1801,1471,9);
insert into casting values (437,1471,9);
insert into casting values (178,1472,3);
insert into casting values (331,1472,2);
insert into casting values (1690,1473,4);
insert into casting values (294,1473,3);
insert into casting values (344,1473,4);
insert into casting values (1819,1474,2);
insert into casting values (44,1474,6);
insert into casting values (47,1474,5);
insert into casting values (458,1474,6);
insert into casting values (751,1475,5);
insert into casting values (1225,1475,5);
insert into casting values (311,1475,4);
insert into casting values (1443,1476,1);
insert into casting values (331,1476,5);
insert into casting values (101,1477,2);
insert into casting values (329,1477,1);
insert into casting values (807,1478,1);
insert into casting values (610,1478,3);
insert into casting values (1681,1480,2);
insert into casting values (711,1480,1);
insert into casting values (944,1481,4);
insert into casting values (638,1481,1);
insert into casting values (1258,1482,5);
insert into casting values (1774,1482,4);
insert into casting values (75,1482,4);
insert into casting values (1266,1483,1);
insert into casting values (1356,1483,2);
insert into casting values (112,1485,4);
insert into casting values (1052,1486,1);
insert into casting values (92,1486,5);
insert into casting values (795,1487,2);
insert into casting values (1220,1487,1);
insert into casting values (734,1488,2);
insert into casting values (879,1488,1);
insert into casting values (1079,1489,2);
insert into casting values (1131,1489,8);
insert into casting values (1625,1489,2);
insert into casting values (1508,1489,9);
insert into casting values (148,1490,4);
insert into casting values (26,1490,5);
insert into casting values (192,1490,4);
insert into casting values (1699,1491,1);
insert into casting values (40,1491,5);
insert into casting values (1661,1492,7);
insert into casting values (284,1492,6);
insert into casting values (246,1492,9);
insert into casting values (117,1492,9);
insert into casting values (576,1492,7);
--- tabcasting, 7801, 50
insert into casting values (530,1492,8);
insert into casting values (1823,1493,5);
insert into casting values (704,1494,3);
insert into casting values (485,1494,1);
insert into casting values (1071,1495,6);
insert into casting values (62,1495,7);
insert into casting values (948,1496,4);
insert into casting values (1248,1496,5);
insert into casting values (681,1496,4);
insert into casting values (488,1497,5);
insert into casting values (641,1497,1);
insert into casting values (1359,1498,2);
insert into casting values (164,1498,1);
insert into casting values (834,1499,5);
insert into casting values (1018,1499,5);
insert into casting values (1390,1499,4);
insert into casting values (1382,1500,3);
insert into casting values (1759,1500,3);
insert into casting values (320,1500,3);
insert into casting values (236,1501,1);
insert into casting values (190,1501,2);
insert into casting values (1179,1502,1);
insert into casting values (1699,1502,2);
insert into casting values (1543,1503,2);
insert into casting values (1750,1504,5);
insert into casting values (595,1504,1);
insert into casting values (1289,1505,4);
insert into casting values (1369,1505,6);
insert into casting values (1604,1505,7);
insert into casting values (534,1505,5);
insert into casting values (1170,1506,5);
insert into casting values (917,1507,5);
insert into casting values (1527,1507,4);
insert into casting values (1504,1507,2);
insert into casting values (859,1508,2);
insert into casting values (1371,1508,2);
insert into casting values (1366,1508,2);
insert into casting values (907,1509,2);
insert into casting values (453,1509,1);
insert into casting values (1109,1510,1);
insert into casting values (1277,1510,8);
insert into casting values (1784,1510,6);
insert into casting values (1032,1511,2);
insert into casting values (1520,1511,4);
insert into casting values (308,1511,2);
insert into casting values (1004,1512,2);
insert into casting values (1429,1512,2);
insert into casting values (1050,1513,3);
insert into casting values (1634,1513,1);
insert into casting values (863,1514,6);
--- tabcasting, 7851, 50
insert into casting values (1165,1514,5);
insert into casting values (1794,1514,3);
insert into casting values (1828,1514,6);
insert into casting values (244,1515,6);
insert into casting values (615,1515,3);
insert into casting values (727,1515,7);
insert into casting values (673,1515,5);
insert into casting values (209,1516,7);
insert into casting values (349,1516,7);
insert into casting values (402,1516,7);
insert into casting values (472,1516,6);
insert into casting values (438,1516,6);
insert into casting values (410,1516,6);
insert into casting values (1405,1517,4);
insert into casting values (341,1517,3);
insert into casting values (682,1517,3);
insert into casting values (1701,1518,4);
insert into casting values (1584,1518,4);
insert into casting values (248,1518,3);
insert into casting values (1024,1519,1);
insert into casting values (535,1519,2);
insert into casting values (1304,1520,4);
insert into casting values (1645,1520,6);
insert into casting values (253,1520,8);
insert into casting values (319,1520,5);
insert into casting values (1017,1521,2);
insert into casting values (1566,1521,1);
insert into casting values (1256,1522,8);
insert into casting values (365,1522,4);
insert into casting values (696,1522,4);
insert into casting values (875,1523,5);
insert into casting values (1066,1523,4);
insert into casting values (898,1523,2);
insert into casting values (105,1524,2);
insert into casting values (694,1524,1);
insert into casting values (1664,1525,2);
insert into casting values (420,1525,1);
insert into casting values (1440,1526,4);
insert into casting values (34,1526,4);
insert into casting values (633,1526,5);
insert into casting values (829,1527,3);
insert into casting values (683,1527,1);
insert into casting values (987,1528,7);
insert into casting values (1084,1528,5);
insert into casting values (1216,1528,9);
insert into casting values (146,1528,4);
insert into casting values (344,1529,5);
insert into casting values (365,1529,3);
insert into casting values (79,1529,4);
insert into casting values (991,1530,2);
--- tabcasting, 7901, 50
insert into casting values (766,1530,1);
insert into casting values (933,1531,4);
insert into casting values (42,1531,3);
insert into casting values (197,1531,4);
insert into casting values (1031,1532,6);
insert into casting values (840,1532,14);
insert into casting values (969,1532,14);
insert into casting values (1346,1532,6);
insert into casting values (1190,1532,10);
insert into casting values (1281,1532,12);
insert into casting values (1845,1532,12);
insert into casting values (307,1532,5);
insert into casting values (648,1532,6);
insert into casting values (954,1533,4);
insert into casting values (1121,1533,3);
insert into casting values (1275,1533,4);
insert into casting values (173,1534,2);
insert into casting values (384,1534,1);
insert into casting values (1091,1535,4);
insert into casting values (985,1535,8);
insert into casting values (1271,1535,5);
insert into casting values (185,1535,8);
insert into casting values (920,1536,5);
insert into casting values (1246,1536,2);
insert into casting values (1741,1536,4);
insert into casting values (1324,1537,7);
insert into casting values (98,1537,4);
insert into casting values (421,1537,3);
insert into casting values (692,1537,6);
insert into casting values (915,1538,5);
insert into casting values (1088,1538,3);
insert into casting values (96,1538,7);
insert into casting values (214,1538,7);
insert into casting values (1211,1539,1);
insert into casting values (519,1539,2);
insert into casting values (1759,1540,6);
insert into casting values (84,1540,8);
insert into casting values (142,1540,7);
insert into casting values (699,1540,9);
insert into casting values (720,1540,7);
insert into casting values (1097,1541,2);
insert into casting values (750,1541,7);
insert into casting values (1769,1541,8);
insert into casting values (906,1542,5);
insert into casting values (1839,1542,4);
insert into casting values (120,1542,2);
insert into casting values (1215,1543,1);
insert into casting values (1208,1543,3);
insert into casting values (1721,1544,1);
insert into casting values (510,1544,2);
--- tabcasting, 7951, 50
insert into casting values (159,1545,2);
insert into casting values (135,1545,3);
insert into casting values (486,1545,3);
insert into casting values (1016,1546,8);
insert into casting values (1212,1546,9);
insert into casting values (1790,1546,4);
insert into casting values (1771,1546,9);
insert into casting values (153,1546,6);
insert into casting values (1094,1547,1);
insert into casting values (1311,1547,3);
insert into casting values (893,1548,5);
insert into casting values (98,1548,3);
insert into casting values (936,1549,1);
insert into casting values (1486,1549,3);
insert into casting values (1286,1550,2);
insert into casting values (1126,1550,1);
insert into casting values (1157,1551,2);
insert into casting values (418,1551,4);
insert into casting values (720,1551,4);
insert into casting values (1477,1552,8);
insert into casting values (570,1552,2);
insert into casting values (652,1552,8);
insert into casting values (447,1552,3);
insert into casting values (1007,1553,5);
insert into casting values (1790,1553,2);
insert into casting values (1702,1553,6);
insert into casting values (242,1553,6);
insert into casting values (686,1554,5);
insert into casting values (649,1554,4);
insert into casting values (814,1555,5);
insert into casting values (1306,1555,4);
insert into casting values (545,1555,3);
insert into casting values (174,1556,4);
insert into casting values (234,1556,5);
insert into casting values (684,1556,3);
insert into casting values (982,1557,7);
insert into casting values (950,1557,6);
insert into casting values (765,1557,5);
insert into casting values (147,1557,5);
insert into casting values (875,1558,2);
insert into casting values (1263,1558,8);
insert into casting values (338,1558,3);
insert into casting values (413,1558,7);
insert into casting values (252,1559,4);
insert into casting values (68,1559,4);
insert into casting values (280,1559,4);
insert into casting values (1375,1560,5);
insert into casting values (1616,1560,3);
insert into casting values (639,1560,5);
insert into casting values (1419,1561,6);
--- tabcasting, 8001, 50
insert into casting values (1775,1561,2);
insert into casting values (1514,1561,3);
insert into casting values (449,1561,6);
insert into casting values (1059,1562,1);
insert into casting values (1757,1562,2);
insert into casting values (1041,1563,3);
insert into casting values (1465,1563,7);
insert into casting values (1569,1563,3);
insert into casting values (1539,1563,6);
insert into casting values (737,1564,14);
insert into casting values (1351,1564,7);
insert into casting values (1555,1564,14);
insert into casting values (1654,1564,10);
insert into casting values (712,1564,6);
insert into casting values (699,1564,7);
insert into casting values (441,1564,5);
insert into casting values (984,1565,3);
insert into casting values (1095,1565,9);
insert into casting values (987,1565,11);
insert into casting values (753,1565,15);
insert into casting values (365,1565,25);
insert into casting values (10,1565,7);
insert into casting values (375,1565,14);
insert into casting values (436,1565,6);
insert into casting values (384,1565,11);
insert into casting values (940,1566,4);
insert into casting values (953,1566,14);
insert into casting values (1450,1566,6);
insert into casting values (1382,1566,10);
insert into casting values (1361,1566,6);
insert into casting values (1384,1566,6);
insert into casting values (1782,1566,10);
insert into casting values (296,1566,13);
insert into casting values (863,1567,12);
insert into casting values (1150,1567,7);
insert into casting values (1255,1567,13);
insert into casting values (1201,1567,3);
insert into casting values (89,1567,10);
insert into casting values (425,1567,10);
insert into casting values (380,1567,5);
insert into casting values (1063,1568,1);
insert into casting values (840,1568,13);
insert into casting values (1285,1568,13);
insert into casting values (231,1568,9);
insert into casting values (444,1568,15);
insert into casting values (851,1569,9);
insert into casting values (1555,1569,5);
insert into casting values (298,1569,6);
insert into casting values (312,1569,10);
insert into casting values (197,1569,10);
--- tabcasting, 8051, 50
insert into casting values (96,1569,15);
insert into casting values (630,1569,7);
insert into casting values (1306,1570,8);
insert into casting values (1152,1570,10);
insert into casting values (1497,1570,9);
insert into casting values (301,1570,5);
insert into casting values (15,1570,9);
insert into casting values (648,1570,12);
insert into casting values (586,1570,10);
insert into casting values (1056,1571,8);
insert into casting values (1112,1571,14);
insert into casting values (1214,1571,12);
insert into casting values (172,1571,4);
insert into casting values (545,1571,6);
insert into casting values (568,1571,14);
insert into casting values (676,1571,6);
insert into casting values (980,1572,14);
insert into casting values (1469,1572,5);
insert into casting values (1153,1572,14);
insert into casting values (1183,1572,6);
insert into casting values (262,1572,6);
insert into casting values (670,1572,7);
insert into casting values (616,1572,10);
insert into casting values (831,1573,8);
insert into casting values (1352,1573,10);
insert into casting values (1392,1573,10);
insert into casting values (1706,1573,13);
insert into casting values (448,1573,1);
insert into casting values (1118,1574,12);
insert into casting values (1143,1574,15);
insert into casting values (32,1574,6);
insert into casting values (467,1574,1);
insert into casting values (520,1574,14);
insert into casting values (941,1575,14);
insert into casting values (821,1575,12);
insert into casting values (1180,1575,6);
insert into casting values (172,1575,15);
insert into casting values (167,1575,7);
insert into casting values (392,1575,4);
insert into casting values (569,1575,7);
insert into casting values (1051,1576,3);
insert into casting values (15,1576,8);
insert into casting values (274,1576,3);
insert into casting values (588,1576,12);
insert into casting values (475,1576,14);
insert into casting values (618,1576,10);
insert into casting values (1845,1577,9);
insert into casting values (623,1577,5);
insert into casting values (622,1577,5);
insert into casting values (536,1577,11);
--- tabcasting, 8101, 50
insert into casting values (538,1577,11);
insert into casting values (1455,1578,9);
insert into casting values (1191,1578,9);
insert into casting values (1596,1578,11);
insert into casting values (1590,1578,8);
insert into casting values (229,1578,12);
insert into casting values (426,1578,5);
insert into casting values (782,1579,10);
insert into casting values (1390,1579,6);
insert into casting values (1460,1579,10);
insert into casting values (1440,1579,5);
insert into casting values (11,1579,4);
insert into casting values (870,1580,3);
insert into casting values (1030,1580,9);
insert into casting values (1117,1580,8);
insert into casting values (411,1580,10);
insert into casting values (710,1580,10);
insert into casting values (1627,1581,11);
insert into casting values (270,1581,3);
insert into casting values (134,1581,11);
insert into casting values (1272,1582,10);
insert into casting values (1170,1582,15);
insert into casting values (1718,1582,8);
insert into casting values (228,1582,6);
insert into casting values (61,1582,9);
insert into casting values (45,1582,9);
insert into casting values (654,1582,7);
insert into casting values (844,1583,15);
insert into casting values (1825,1583,3);
insert into casting values (1546,1583,14);
insert into casting values (60,1583,8);
insert into casting values (201,1583,9);
insert into casting values (368,1583,8);
insert into casting values (1817,1584,10);
insert into casting values (1820,1584,13);
insert into casting values (38,1584,8);
insert into casting values (424,1584,5);
insert into casting values (497,1584,5);
insert into casting values (973,1585,8);
insert into casting values (781,1585,6);
insert into casting values (1786,1585,7);
insert into casting values (1637,1585,10);
insert into casting values (217,1585,7);
insert into casting values (207,1585,8);
insert into casting values (692,1585,12);
insert into casting values (925,1586,9);
insert into casting values (1050,1586,8);
insert into casting values (1188,1586,11);
insert into casting values (1631,1586,9);
insert into casting values (1716,1586,11);
--- tabcasting, 8151, 50
insert into casting values (1542,1586,8);
insert into casting values (225,1586,6);
insert into casting values (1223,1587,6);
insert into casting values (1108,1587,5);
insert into casting values (284,1587,10);
insert into casting values (291,1587,4);
insert into casting values (853,1588,10);
insert into casting values (170,1588,2);
insert into casting values (574,1588,3);
insert into casting values (433,1588,9);
insert into casting values (440,1588,12);
insert into casting values (875,1589,7);
insert into casting values (1668,1589,6);
insert into casting values (25,1589,5);
insert into casting values (688,1589,10);
insert into casting values (456,1589,7);
insert into casting values (1084,1590,4);
insert into casting values (1430,1590,4);
insert into casting values (1355,1590,6);
insert into casting values (196,1590,12);
insert into casting values (228,1590,10);
insert into casting values (1035,1591,15);
insert into casting values (1253,1591,11);
insert into casting values (215,1591,5);
insert into casting values (73,1591,9);
insert into casting values (399,1591,5);
insert into casting values (780,1592,11);
insert into casting values (1458,1592,4);
insert into casting values (1199,1592,3);
insert into casting values (1665,1592,9);
insert into casting values (242,1592,10);
insert into casting values (1088,1593,5);
insert into casting values (1096,1593,10);
insert into casting values (1661,1593,3);
insert into casting values (1754,1593,6);
insert into casting values (1608,1593,15);
insert into casting values (1039,1594,4);
insert into casting values (1276,1594,2);
insert into casting values (1727,1594,10);
insert into casting values (224,1594,10);
insert into casting values (621,1594,8);
insert into casting values (242,1595,9);
insert into casting values (572,1595,8);
insert into casting values (688,1595,14);
insert into casting values (385,1595,7);
insert into casting values (710,1595,5);
insert into casting values (1636,1596,4);
insert into casting values (77,1596,4);
insert into casting values (174,1596,11);
insert into casting values (508,1596,7);
--- tabcasting, 8201, 50
insert into casting values (947,1597,5);
insert into casting values (1774,1597,3);
insert into casting values (1505,1597,11);
insert into casting values (596,1597,7);
insert into casting values (918,1598,11);
insert into casting values (779,1598,8);
insert into casting values (1217,1598,2);
insert into casting values (1416,1598,5);
insert into casting values (909,1599,8);
insert into casting values (1596,1599,9);
insert into casting values (1633,1599,8);
insert into casting values (1722,1599,2);
insert into casting values (392,1599,13);
insert into casting values (1057,1600,15);
insert into casting values (1256,1600,9);
insert into casting values (213,1600,5);
insert into casting values (173,1600,9);
insert into casting values (491,1600,8);
insert into casting values (1025,1601,3);
insert into casting values (1163,1601,2);
insert into casting values (1401,1601,12);
insert into casting values (248,1601,9);
insert into casting values (789,1602,9);
insert into casting values (1288,1602,7);
insert into casting values (526,1602,3);
insert into casting values (593,1602,10);
insert into casting values (625,1602,8);
insert into casting values (999,1603,4);
insert into casting values (739,1603,6);
insert into casting values (807,1603,8);
insert into casting values (286,1603,6);
insert into casting values (401,1603,11);
insert into casting values (912,1604,3);
insert into casting values (1502,1604,2);
insert into casting values (310,1604,10);
insert into casting values (172,1604,7);
insert into casting values (866,1605,5);
insert into casting values (1359,1605,13);
insert into casting values (346,1605,8);
insert into casting values (446,1605,5);
insert into casting values (917,1606,3);
insert into casting values (1689,1606,13);
insert into casting values (1725,1606,4);
insert into casting values (698,1606,9);
insert into casting values (1425,1607,8);
insert into casting values (1449,1607,6);
insert into casting values (29,1607,7);
insert into casting values (282,1607,12);
insert into casting values (420,1607,2);
insert into casting values (1100,1608,5);
--- tabcasting, 8251, 50
insert into casting values (1445,1608,4);
insert into casting values (1654,1608,6);
insert into casting values (511,1608,14);
insert into casting values (915,1609,3);
insert into casting values (1827,1609,3);
insert into casting values (1817,1609,7);
insert into casting values (248,1609,10);
insert into casting values (802,1610,10);
insert into casting values (1328,1610,1);
insert into casting values (484,1610,8);
insert into casting values (1567,1611,8);
insert into casting values (316,1611,12);
insert into casting values (291,1611,6);
insert into casting values (185,1611,4);
insert into casting values (413,1611,8);
insert into casting values (743,1612,15);
insert into casting values (1629,1612,8);
insert into casting values (1495,1612,2);
insert into casting values (406,1612,4);
insert into casting values (151,1613,15);
insert into casting values (322,1613,5);
insert into casting values (489,1613,6);
insert into casting values (387,1613,5);
insert into casting values (1432,1614,7);
insert into casting values (1422,1614,5);
insert into casting values (1261,1614,15);
insert into casting values (1802,1614,8);
insert into casting values (325,1614,9);
insert into casting values (928,1615,2);
insert into casting values (1686,1615,6);
insert into casting values (43,1615,4);
insert into casting values (494,1615,12);
insert into casting values (1329,1616,5);
insert into casting values (1346,1616,7);
insert into casting values (1785,1616,5);
insert into casting values (134,1616,14);
insert into casting values (823,1617,3);
insert into casting values (896,1617,11);
insert into casting values (1751,1617,7);
insert into casting values (1641,1617,6);
insert into casting values (1603,1617,8);
insert into casting values (735,1618,7);
insert into casting values (1306,1618,11);
insert into casting values (1337,1618,3);
insert into casting values (1786,1618,5);
insert into casting values (803,1619,3);
insert into casting values (1200,1619,25);
insert into casting values (1606,1619,9);
insert into casting values (444,1619,10);
insert into casting values (558,1619,2);
--- tabcasting, 8301, 50
insert into casting values (816,1620,3);
insert into casting values (600,1620,6);
insert into casting values (459,1620,13);
insert into casting values (969,1621,12);
insert into casting values (1146,1621,4);
insert into casting values (1495,1621,9);
insert into casting values (1648,1621,4);
insert into casting values (1032,1622,6);
insert into casting values (1177,1622,13);
insert into casting values (1560,1622,6);
insert into casting values (544,1622,4);
insert into casting values (674,1622,7);
insert into casting values (1012,1623,8);
insert into casting values (1645,1623,8);
insert into casting values (1592,1623,7);
insert into casting values (1801,1623,13);
insert into casting values (45,1623,5);
insert into casting values (244,1624,5);
insert into casting values (489,1624,5);
insert into casting values (564,1624,9);
insert into casting values (621,1624,12);
insert into casting values (836,1625,4);
insert into casting values (1183,1625,7);
insert into casting values (391,1625,4);
insert into casting values (535,1625,10);
insert into casting values (1594,1626,6);
insert into casting values (91,1626,8);
insert into casting values (347,1626,10);
insert into casting values (557,1626,7);
insert into casting values (536,1626,5);
insert into casting values (25,1627,3);
insert into casting values (465,1627,5);
insert into casting values (428,1627,10);
insert into casting values (616,1627,8);
insert into casting values (140,1628,6);
insert into casting values (294,1628,10);
insert into casting values (114,1628,8);
insert into casting values (614,1628,9);
insert into casting values (649,1628,7);
insert into casting values (436,1628,9);
insert into casting values (935,1629,11);
insert into casting values (1131,1629,4);
insert into casting values (1612,1629,5);
insert into casting values (1518,1629,7);
insert into casting values (771,1630,10);
insert into casting values (739,1630,7);
insert into casting values (564,1630,1);
insert into casting values (1026,1631,7);
insert into casting values (137,1631,14);
insert into casting values (617,1631,3);
--- tabcasting, 8351, 50
insert into casting values (1135,1632,4);
insert into casting values (487,1632,12);
insert into casting values (1335,1633,6);
insert into casting values (76,1633,2);
insert into casting values (280,1633,12);
insert into casting values (85,1633,7);
insert into casting values (84,1633,6);
insert into casting values (1079,1634,9);
insert into casting values (1598,1634,3);
insert into casting values (304,1634,6);
insert into casting values (194,1634,6);
insert into casting values (151,1634,12);
insert into casting values (1033,1635,7);
insert into casting values (1816,1635,2);
insert into casting values (103,1635,4);
insert into casting values (283,1635,15);
insert into casting values (845,1636,3);
insert into casting values (1378,1636,7);
insert into casting values (285,1636,11);
insert into casting values (120,1636,5);
insert into casting values (1260,1637,15);
insert into casting values (1322,1637,3);
insert into casting values (1688,1637,4);
insert into casting values (858,1638,4);
insert into casting values (1337,1638,6);
insert into casting values (1363,1638,5);
insert into casting values (341,1638,15);
insert into casting values (1481,1639,3);
insert into casting values (259,1639,4);
insert into casting values (19,1639,10);
insert into casting values (401,1639,6);
insert into casting values (1119,1640,3);
insert into casting values (187,1640,8);
insert into casting values (8,1640,11);
insert into casting values (375,1640,5);
insert into casting values (1090,1641,4);
insert into casting values (1127,1641,12);
insert into casting values (1539,1641,5);
insert into casting values (573,1641,6);
insert into casting values (1845,1642,3);
insert into casting values (1621,1642,4);
insert into casting values (728,1642,12);
insert into casting values (1432,1643,12);
insert into casting values (1508,1643,5);
insert into casting values (1641,1643,7);
insert into casting values (860,1644,4);
insert into casting values (1449,1644,8);
insert into casting values (1128,1644,11);
insert into casting values (282,1644,7);
insert into casting values (628,1644,7);
--- tabcasting, 8401, 50
insert into casting values (843,1645,12);
insert into casting values (19,1645,8);
insert into casting values (563,1645,5);
insert into casting values (662,1645,3);
insert into casting values (837,1646,6);
insert into casting values (1286,1646,10);
insert into casting values (1668,1646,2);
insert into casting values (342,1646,3);
insert into casting values (880,1647,5);
insert into casting values (1100,1647,3);
insert into casting values (1802,1647,7);
insert into casting values (612,1647,12);
insert into casting values (979,1648,10);
insert into casting values (157,1648,3);
insert into casting values (575,1648,4);
insert into casting values (406,1648,6);
insert into casting values (1743,1649,11);
insert into casting values (1838,1649,1);
insert into casting values (649,1649,6);
insert into casting values (1118,1650,18);
insert into casting values (1794,1650,4);
insert into casting values (350,1650,8);
insert into casting values (548,1650,4);
insert into casting values (1159,1651,5);
insert into casting values (519,1651,11);
insert into casting values (551,1651,4);
insert into casting values (438,1651,9);
insert into casting values (753,1652,1);
insert into casting values (494,1652,15);
insert into casting values (395,1652,6);
insert into casting values (174,1653,9);
insert into casting values (73,1653,10);
insert into casting values (8,1653,4);
insert into casting values (537,1653,2);
insert into casting values (741,1654,10);
insert into casting values (364,1654,6);
insert into casting values (370,1654,1);
insert into casting values (17,1655,10);
insert into casting values (13,1655,5);
insert into casting values (1,1655,6);
insert into casting values (5,1655,5);
insert into casting values (1396,1656,15);
insert into casting values (1514,1656,2);
insert into casting values (96,1656,6);
insert into casting values (692,1656,4);
insert into casting values (1074,1657,10);
insert into casting values (1190,1657,9);
insert into casting values (1136,1657,5);
insert into casting values (1711,1657,6);
insert into casting values (485,1657,7);
--- tabcasting, 8451, 50
insert into casting values (1375,1658,2);
insert into casting values (1738,1658,8);
insert into casting values (296,1658,2);
insert into casting values (549,1658,11);
insert into casting values (1434,1659,8);
insert into casting values (1413,1659,13);
insert into casting values (1455,1659,11);
insert into casting values (1118,1659,16);
insert into casting values (1235,1659,8);
insert into casting values (1668,1659,11);
insert into casting values (76,1659,8);
insert into casting values (142,1659,11);
insert into casting values (638,1659,6);
insert into casting values (466,1659,15);
insert into casting values (850,1660,4);
insert into casting values (2,1660,8);
insert into casting values (362,1660,5);
insert into casting values (1139,1661,7);
insert into casting values (1615,1661,1);
insert into casting values (1123,1662,7);
insert into casting values (1762,1662,2);
insert into casting values (1769,1662,4);
insert into casting values (873,1663,2);
insert into casting values (1428,1663,5);
insert into casting values (587,1663,7);
insert into casting values (821,1664,1);
insert into casting values (231,1664,7);
insert into casting values (1374,1665,4);
insert into casting values (1684,1665,8);
insert into casting values (246,1665,7);
insert into casting values (448,1665,7);
insert into casting values (1513,1666,6);
insert into casting values (603,1666,5);
insert into casting values (856,1667,9);
insert into casting values (771,1667,7);
insert into casting values (1492,1667,2);
insert into casting values (467,1667,8);
insert into casting values (829,1668,4);
insert into casting values (1696,1668,3);
insert into casting values (519,1668,8);
insert into casting values (1343,1669,6);
insert into casting values (1248,1669,4);
insert into casting values (1568,1669,5);
insert into casting values (1136,1670,2);
insert into casting values (56,1670,4);
insert into casting values (30,1670,9);
insert into casting values (1249,1671,4);
insert into casting values (1188,1671,4);
insert into casting values (487,1671,7);
insert into casting values (811,1672,9);
--- tabcasting, 8501, 50
insert into casting values (1352,1672,8);
insert into casting values (1167,1672,8);
insert into casting values (609,1672,8);
insert into casting values (1480,1673,2);
insert into casting values (235,1673,9);
insert into casting values (238,1673,3);
insert into casting values (1033,1674,4);
insert into casting values (1820,1674,8);
insert into casting values (590,1674,2);
insert into casting values (1066,1675,2);
insert into casting values (1126,1675,5);
insert into casting values (93,1675,8);
insert into casting values (1009,1676,9);
insert into casting values (1123,1676,9);
insert into casting values (1808,1676,5);
insert into casting values (243,1676,8);
insert into casting values (220,1677,5);
insert into casting values (287,1677,7);
insert into casting values (1249,1678,6);
insert into casting values (11,1678,5);
insert into casting values (37,1678,5);
insert into casting values (1189,1679,7);
insert into casting values (582,1679,3);
insert into casting values (519,1679,4);
insert into casting values (1378,1680,6);
insert into casting values (1289,1680,9);
insert into casting values (295,1680,5);
insert into casting values (109,1680,7);
insert into casting values (1068,1681,2);
insert into casting values (1305,1681,8);
insert into casting values (111,1681,2);
insert into casting values (1162,1682,9);
insert into casting values (446,1682,4);
insert into casting values (457,1682,5);
insert into casting values (1177,1683,9);
insert into casting values (713,1683,1);
insert into casting values (800,1684,5);
insert into casting values (1676,1684,7);
insert into casting values (38,1684,3);
insert into casting values (1364,1685,3);
insert into casting values (1780,1685,6);
insert into casting values (1829,1685,4);
insert into casting values (865,1686,6);
insert into casting values (246,1686,2);
insert into casting values (685,1686,3);
insert into casting values (978,1687,4);
insert into casting values (696,1687,7);
insert into casting values (411,1687,4);
insert into casting values (807,1688,6);
insert into casting values (1516,1688,5);
--- tabcasting, 8551, 50
insert into casting values (1608,1688,2);
insert into casting values (1381,1689,8);
insert into casting values (1726,1690,5);
insert into casting values (1535,1690,4);
insert into casting values (236,1690,6);
insert into casting values (1739,1691,8);
insert into casting values (940,1692,8);
insert into casting values (1841,1692,1);
insert into casting values (1287,1693,4);
insert into casting values (1702,1693,3);
insert into casting values (678,1693,9);
insert into casting values (1453,1694,7);
insert into casting values (1173,1694,2);
insert into casting values (479,1694,2);
insert into casting values (811,1695,7);
insert into casting values (281,1695,4);
insert into casting values (204,1695,9);
insert into casting values (597,1695,6);
insert into casting values (1390,1696,3);
insert into casting values (1650,1696,9);
insert into casting values (403,1696,4);
insert into casting values (853,1697,5);
insert into casting values (1048,1697,9);
insert into casting values (1090,1697,2);
insert into casting values (974,1698,9);
insert into casting values (510,1698,1);
insert into casting values (1197,1699,2);
insert into casting values (528,1699,6);
insert into casting values (379,1699,5);
insert into casting values (1083,1700,6);
insert into casting values (25,1701,4);
insert into casting values (202,1701,3);
insert into casting values (662,1701,8);
insert into casting values (862,1702,1);
insert into casting values (441,1702,7);
insert into casting values (71,1703,5);
insert into casting values (98,1703,7);
insert into casting values (95,1703,5);
insert into casting values (1794,1704,7);
insert into casting values (221,1704,2);
insert into casting values (615,1704,2);
insert into casting values (860,1705,8);
insert into casting values (1352,1705,5);
insert into casting values (609,1705,5);
insert into casting values (1087,1706,9);
insert into casting values (1026,1707,9);
insert into casting values (1592,1707,8);
insert into casting values (382,1707,7);
insert into casting values (599,1707,4);
insert into casting values (1490,1708,1);
--- tabcasting, 8601, 50
insert into casting values (212,1708,7);
insert into casting values (1400,1709,1);
insert into casting values (65,1709,7);
insert into casting values (887,1710,1);
insert into casting values (1233,1710,6);
insert into casting values (1096,1711,4);
insert into casting values (1138,1711,6);
insert into casting values (984,1712,8);
insert into casting values (200,1712,3);
insert into casting values (523,1712,4);
insert into casting values (830,1713,5);
insert into casting values (1153,1713,5);
insert into casting values (185,1713,7);
insert into casting values (1461,1714,7);
insert into casting values (1389,1714,9);
insert into casting values (1527,1714,8);
insert into casting values (226,1714,3);
insert into casting values (73,1715,4);
insert into casting values (58,1715,9);
insert into casting values (379,1715,4);
insert into casting values (1244,1716,6);
insert into casting values (1527,1717,3);
insert into casting values (522,1717,3);
insert into casting values (696,1717,6);
insert into casting values (1228,1718,3);
insert into casting values (1540,1718,9);
insert into casting values (1514,1718,7);
insert into casting values (418,1718,9);
insert into casting values (1818,1719,6);
insert into casting values (1492,1720,9);
insert into casting values (34,1720,3);
insert into casting values (376,1720,3);
insert into casting values (946,1721,7);
insert into casting values (1689,1721,2);
insert into casting values (1688,1721,2);
insert into casting values (1259,1722,4);
insert into casting values (1261,1722,2);
insert into casting values (1603,1722,7);
insert into casting values (880,1723,9);
insert into casting values (1351,1723,6);
insert into casting values (307,1723,6);
insert into casting values (385,1723,5);
insert into casting values (830,1724,4);
insert into casting values (533,1724,4);
insert into casting values (645,1724,8);
insert into casting values (1432,1725,4);
insert into casting values (82,1725,9);
insert into casting values (698,1725,5);
insert into casting values (890,1726,9);
insert into casting values (907,1726,6);
--- tabcasting, 8651, 50
insert into casting values (1831,1726,5);
insert into casting values (483,1726,7);
insert into casting values (5,1727,4);
insert into casting values (13,1727,4);
insert into casting values (86,1727,6);
insert into casting values (1192,1728,8);
insert into casting values (1493,1728,9);
insert into casting values (253,1728,4);
insert into casting values (139,1728,8);
insert into casting values (822,1729,7);
insert into casting values (391,1729,1);
insert into casting values (1730,1730,8);
insert into casting values (643,1730,4);
insert into casting values (713,1730,4);
insert into casting values (234,1731,4);
insert into casting values (338,1731,4);
insert into casting values (1512,1732,1);
insert into casting values (1760,1732,6);
insert into casting values (1286,1733,9);
insert into casting values (1346,1733,1);
insert into casting values (1469,1734,1);
insert into casting values (1765,1734,6);
insert into casting values (1190,1735,4);
insert into casting values (1630,1735,2);
insert into casting values (636,1735,7);
insert into casting values (1786,1736,4);
insert into casting values (1594,1736,4);
insert into casting values (64,1736,6);
insert into casting values (1703,1737,8);
insert into casting values (424,1737,2);
insert into casting values (727,1737,6);
insert into casting values (720,1737,8);
insert into casting values (826,1738,3);
insert into casting values (1164,1738,3);
insert into casting values (1116,1738,7);
insert into casting values (1019,1739,5);
insert into casting values (919,1739,3);
insert into casting values (1607,1739,7);
insert into casting values (1263,1740,3);
insert into casting values (1599,1740,8);
insert into casting values (354,1740,5);
insert into casting values (1101,1741,4);
insert into casting values (1256,1741,5);
insert into casting values (1471,1741,8);
insert into casting values (813,1742,4);
insert into casting values (1466,1742,8);
insert into casting values (1222,1742,6);
insert into casting values (476,1742,8);
insert into casting values (1130,1743,1);
insert into casting values (324,1743,6);
--- tabcasting, 8701, 50
insert into casting values (828,1744,7);
insert into casting values (1453,1744,5);
insert into casting values (724,1744,3);
insert into casting values (1086,1745,4);
insert into casting values (1638,1745,7);
insert into casting values (101,1745,5);
insert into casting values (896,1746,4);
insert into casting values (1260,1746,8);
insert into casting values (477,1746,4);
insert into casting values (1170,1747,2);
insert into casting values (696,1747,3);
insert into casting values (528,1747,7);
insert into casting values (759,1748,2);
insert into casting values (207,1748,10);
insert into casting values (357,1748,13);
insert into casting values (116,1748,10);
insert into casting values (463,1748,7);
insert into casting values (688,1748,8);
insert into casting values (520,1748,10);
insert into casting values (1553,1749,7);
insert into casting values (263,1749,1);
insert into casting values (1182,1750,9);
insert into casting values (41,1750,5);
insert into casting values (263,1750,3);
insert into casting values (939,1751,9);
insert into casting values (1197,1751,3);
insert into casting values (528,1751,5);
insert into casting values (1733,1752,6);
insert into casting values (1573,1752,4);
insert into casting values (585,1752,2);
insert into casting values (1705,1753,1);
insert into casting values (135,1753,7);
insert into casting values (773,1754,6);
insert into casting values (1232,1754,3);
insert into casting values (447,1754,4);
insert into casting values (1141,1755,5);
insert into casting values (1746,1755,2);
insert into casting values (981,1756,4);
insert into casting values (1056,1757,7);
insert into casting values (1423,1757,7);
insert into casting values (1601,1757,4);
insert into casting values (183,1757,6);
insert into casting values (897,1758,5);
insert into casting values (1422,1758,2);
insert into casting values (338,1758,8);
insert into casting values (784,1759,4);
insert into casting values (1826,1759,4);
insert into casting values (356,1759,8);
insert into casting values (1821,1760,1);
insert into casting values (329,1760,8);
--- tabcasting, 8751, 50
insert into casting values (1345,1761,5);
insert into casting values (1515,1761,3);
insert into casting values (301,1761,6);
insert into casting values (1323,1762,6);
insert into casting values (255,1762,5);
insert into casting values (62,1762,9);
insert into casting values (186,1762,9);
insert into casting values (968,1763,4);
insert into casting values (1506,1763,5);
insert into casting values (1686,1763,7);
insert into casting values (946,1764,10);
insert into casting values (1024,1764,13);
insert into casting values (1340,1764,12);
insert into casting values (1641,1764,12);
insert into casting values (1628,1764,5);
insert into casting values (141,1764,15);
insert into casting values (1297,1765,1);
insert into casting values (615,1765,6);
insert into casting values (960,1766,1);
insert into casting values (1713,1766,6);
insert into casting values (289,1767,9);
insert into casting values (605,1767,3);
insert into casting values (399,1767,3);
insert into casting values (925,1768,2);
insert into casting values (1565,1768,6);
insert into casting values (723,1768,4);
insert into casting values (1687,1769,6);
insert into casting values (1590,1769,6);
insert into casting values (391,1769,2);
insert into casting values (389,1769,8);
insert into casting values (1009,1770,15);
insert into casting values (1322,1770,10);
insert into casting values (1242,1770,5);
insert into casting values (1785,1770,8);
insert into casting values (1704,1770,12);
insert into casting values (557,1770,15);
insert into casting values (698,1770,13);
insert into casting values (622,1770,9);
insert into casting values (1356,1771,7);
insert into casting values (1735,1771,3);
insert into casting values (1579,1771,3);
insert into casting values (1582,1771,3);
insert into casting values (1265,1772,6);
insert into casting values (1522,1772,1);
insert into casting values (845,1773,5);
insert into casting values (481,1773,2);
insert into casting values (612,1773,6);
insert into casting values (1799,1774,5);
insert into casting values (41,1774,4);
insert into casting values (580,1774,9);
--- tabcasting, 8801, 50
insert into casting values (1044,1775,3);
insert into casting values (1293,1775,2);
insert into casting values (1173,1775,8);
insert into casting values (1268,1776,5);
insert into casting values (1372,1776,2);
insert into casting values (91,1776,7);
insert into casting values (975,1777,5);
insert into casting values (1159,1777,7);
insert into casting values (1060,1778,5);
insert into casting values (1093,1778,5);
insert into casting values (100,1778,7);
insert into casting values (1010,1779,6);
insert into casting values (1380,1779,4);
insert into casting values (53,1779,9);
insert into casting values (711,1779,8);
insert into casting values (202,1780,7);
insert into casting values (613,1780,3);
insert into casting values (393,1780,5);
insert into casting values (758,1781,6);
insert into casting values (766,1781,4);
insert into casting values (1780,1781,2);
insert into casting values (1498,1782,3);
insert into casting values (198,1782,8);
insert into casting values (171,1782,4);
insert into casting values (1030,1783,7);
insert into casting values (1479,1783,6);
insert into casting values (126,1783,6);
insert into casting values (569,1783,4);
insert into casting values (1137,1784,7);
insert into casting values (1794,1784,13);
insert into casting values (1576,1784,11);
insert into casting values (1812,1784,5);
insert into casting values (144,1784,15);
insert into casting values (65,1784,11);
insert into casting values (677,1784,7);
insert into casting values (443,1784,10);
insert into casting values (1771,1785,6);
insert into casting values (1492,1785,1);
insert into casting values (124,1786,4);
insert into casting values (502,1786,3);
insert into casting values (386,1786,9);
insert into casting values (775,1787,8);
insert into casting values (1277,1787,4);
insert into casting values (318,1787,3);
insert into casting values (899,1788,9);
insert into casting values (1020,1788,2);
insert into casting values (245,1788,4);
insert into casting values (734,1789,6);
insert into casting values (1482,1789,3);
insert into casting values (1790,1789,6);
--- tabcasting, 8851, 50
insert into casting values (281,1789,6);
insert into casting values (985,1790,10);
insert into casting values (1239,1790,12);
insert into casting values (1509,1790,10);
insert into casting values (1767,1790,9);
insert into casting values (1775,1790,12);
insert into casting values (240,1790,6);
insert into casting values (297,1790,8);
insert into casting values (511,1790,7);
insert into casting values (797,1791,4);
insert into casting values (1469,1791,10);
insert into casting values (1550,1791,6);
insert into casting values (240,1791,12);
insert into casting values (345,1791,10);
insert into casting values (108,1791,9);
insert into casting values (1276,1792,3);
insert into casting values (1471,1792,11);
insert into casting values (1335,1792,10);
insert into casting values (1532,1792,11);
insert into casting values (161,1792,10);
insert into casting values (122,1792,7);
insert into casting values (495,1792,9);
insert into casting values (823,1793,10);
insert into casting values (810,1793,10);
insert into casting values (747,1793,12);
insert into casting values (787,1793,12);
insert into casting values (801,1793,10);
insert into casting values (145,1793,11);
insert into casting values (178,1793,10);
insert into casting values (156,1793,7);
insert into casting values (726,1793,12);
insert into casting values (613,1793,8);
insert into casting values (723,1793,12);
insert into casting values (729,1793,9);
insert into casting values (965,1794,9);
insert into casting values (750,1794,12);
insert into casting values (745,1794,10);
insert into casting values (1281,1794,9);
insert into casting values (1654,1794,9);
insert into casting values (322,1794,15);
insert into casting values (307,1794,9);
insert into casting values (568,1794,10);
insert into casting values (1019,1795,9);
insert into casting values (819,1795,9);
insert into casting values (1199,1795,6);
insert into casting values (1335,1795,14);
insert into casting values (173,1795,10);
insert into casting values (227,1795,6);
insert into casting values (599,1795,14);
insert into casting values (1033,1796,10);
--- tabcasting, 8901, 50
insert into casting values (1839,1796,12);
insert into casting values (1529,1796,5);
insert into casting values (1730,1796,15);
insert into casting values (1497,1796,8);
insert into casting values (369,1796,9);
insert into casting values (1048,1797,11);
insert into casting values (785,1797,8);
insert into casting values (1433,1797,6);
insert into casting values (1669,1797,9);
insert into casting values (1755,1797,8);
insert into casting values (529,1797,11);
insert into casting values (408,1797,12);
insert into casting values (927,1798,10);
insert into casting values (808,1798,1);
insert into casting values (338,1798,12);
insert into casting values (502,1798,12);
insert into casting values (844,1799,14);
insert into casting values (1281,1799,5);
insert into casting values (1131,1799,6);
insert into casting values (1219,1799,10);
insert into casting values (1688,1799,11);
insert into casting values (104,1799,6);
insert into casting values (747,1800,14);
insert into casting values (801,1800,9);
insert into casting values (810,1800,11);
insert into casting values (823,1800,6);
insert into casting values (199,1800,11);
insert into casting values (613,1800,9);
insert into casting values (579,1800,12);
insert into casting values (729,1800,11);
insert into casting values (723,1800,14);
insert into casting values (726,1800,11);
insert into casting values (479,1800,10);
insert into casting values (1363,1801,7);
insert into casting values (1473,1801,5);
insert into casting values (1596,1801,10);
insert into casting values (24,1801,8);
insert into casting values (20,1801,10);
insert into casting values (280,1801,14);
insert into casting values (1423,1802,13);
insert into casting values (1754,1802,8);
insert into casting values (85,1802,14);
insert into casting values (33,1802,3);
insert into casting values (266,1802,12);
insert into casting values (624,1802,8);
insert into casting values (758,1803,11);
insert into casting values (1296,1803,12);
insert into casting values (1449,1803,11);
insert into casting values (266,1803,7);
insert into casting values (452,1803,9);
--- tabcasting, 8951, 50
insert into casting values (634,1803,5);
insert into casting values (741,1804,12);
insert into casting values (893,1804,13);
insert into casting values (275,1804,13);
insert into casting values (144,1804,8);
insert into casting values (612,1804,5);
insert into casting values (452,1804,6);
insert into casting values (821,1805,7);
insert into casting values (1449,1805,14);
insert into casting values (1376,1805,12);
insert into casting values (1494,1805,15);
insert into casting values (1794,1805,6);
insert into casting values (695,1805,5);
insert into casting values (1152,1806,5);
insert into casting values (1301,1806,14);
insert into casting values (1636,1806,8);
insert into casting values (142,1806,8);
insert into casting values (210,1806,13);
insert into casting values (392,1806,15);
insert into casting values (941,1807,11);
insert into casting values (1340,1807,15);
insert into casting values (1763,1807,14);
insert into casting values (871,1808,9);
insert into casting values (867,1808,10);
insert into casting values (1717,1808,5);
insert into casting values (24,1808,10);
insert into casting values (2,1808,7);
insert into casting values (295,1808,12);
insert into casting values (893,1809,10);
insert into casting values (842,1809,11);
insert into casting values (793,1809,8);
insert into casting values (808,1809,6);
insert into casting values (1432,1809,6);
insert into casting values (314,1809,11);
insert into casting values (46,1809,9);
insert into casting values (784,1810,11);
insert into casting values (1277,1810,11);
insert into casting values (1802,1810,11);
insert into casting values (1611,1810,9);
insert into casting values (1713,1810,5);
insert into casting values (612,1810,7);
insert into casting values (742,1811,7);
insert into casting values (258,1811,12);
insert into casting values (17,1811,14);
insert into casting values (359,1811,9);
insert into casting values (552,1811,3);
insert into casting values (521,1811,13);
insert into casting values (855,1812,9);
insert into casting values (1229,1812,8);
insert into casting values (1762,1812,11);
--- tabcasting, 9001, 50
insert into casting values (335,1812,5);
insert into casting values (158,1812,10);
insert into casting values (461,1812,15);
insert into casting values (1150,1813,10);
insert into casting values (1312,1813,10);
insert into casting values (118,1813,4);
insert into casting values (32,1813,5);
insert into casting values (356,1813,11);
insert into casting values (1401,1814,9);
insert into casting values (1606,1814,4);
insert into casting values (2,1814,13);
insert into casting values (604,1814,11);
insert into casting values (595,1814,9);
insert into casting values (728,1814,14);
insert into casting values (850,1815,14);
insert into casting values (1354,1815,14);
insert into casting values (1546,1815,13);
insert into casting values (119,1815,4);
insert into casting values (625,1815,5);
insert into casting values (1045,1816,11);
insert into casting values (1110,1816,3);
insert into casting values (31,1816,13);
insert into casting values (462,1816,2);
insert into casting values (531,1816,15);
insert into casting values (1263,1817,11);
insert into casting values (163,1817,4);
insert into casting values (155,1817,10);
insert into casting values (43,1817,9);
insert into casting values (428,1817,13);
insert into casting values (1229,1818,2);
insert into casting values (1762,1818,8);
insert into casting values (172,1818,14);
insert into casting values (113,1818,15);
insert into casting values (51,1818,11);
insert into casting values (424,1818,9);
insert into casting values (1018,1819,13);
insert into casting values (1035,1819,14);
insert into casting values (846,1819,6);
insert into casting values (1264,1819,5);
insert into casting values (1494,1819,6);
insert into casting values (532,1819,10);
insert into casting values (1219,1820,14);
insert into casting values (1507,1820,15);
insert into casting values (1594,1820,2);
insert into casting values (624,1820,2);
insert into casting values (1374,1821,6);
insert into casting values (1195,1821,7);
insert into casting values (642,1821,12);
insert into casting values (705,1821,13);
insert into casting values (372,1821,3);
--- tabcasting, 9051, 50
insert into casting values (965,1822,3);
insert into casting values (746,1822,13);
insert into casting values (780,1822,8);
insert into casting values (174,1822,15);
insert into casting values (470,1822,6);
insert into casting values (1225,1823,8);
insert into casting values (1233,1823,14);
insert into casting values (1494,1823,9);
insert into casting values (1778,1823,8);
insert into casting values (330,1823,8);
insert into casting values (224,1823,11);
insert into casting values (906,1824,13);
insert into casting values (1152,1824,6);
insert into casting values (1668,1824,4);
insert into casting values (1727,1824,6);
insert into casting values (121,1824,13);
insert into casting values (761,1825,14);
insert into casting values (1495,1825,3);
insert into casting values (1750,1825,4);
insert into casting values (1722,1826,5);
insert into casting values (1759,1826,8);
insert into casting values (1664,1826,8);
insert into casting values (634,1826,14);
insert into casting values (906,1827,8);
insert into casting values (858,1827,6);
insert into casting values (1404,1827,6);
insert into casting values (116,1827,12);
insert into casting values (137,1827,6);
insert into casting values (57,1827,10);
insert into casting values (1079,1828,8);
insert into casting values (1732,1828,6);
insert into casting values (393,1828,4);
insert into casting values (387,1828,11);
insert into casting values (636,1828,12);
insert into casting values (1027,1829,10);
insert into casting values (1192,1829,3);
insert into casting values (139,1829,11);
insert into casting values (375,1829,3);
insert into casting values (800,1830,13);
insert into casting values (836,1830,1);
insert into casting values (136,1830,14);
insert into casting values (1421,1831,9);
insert into casting values (69,1831,2);
insert into casting values (173,1831,11);
insert into casting values (19,1831,11);
insert into casting values (691,1831,8);
insert into casting values (963,1832,6);
insert into casting values (1341,1832,15);
insert into casting values (1306,1832,6);
insert into casting values (1689,1832,4);
--- tabcasting, 9101, 50
insert into casting values (264,1832,14);
insert into casting values (892,1833,4);
insert into casting values (1201,1833,10);
insert into casting values (1783,1833,5);
insert into casting values (230,1833,13);
insert into casting values (1022,1834,11);
insert into casting values (949,1834,11);
insert into casting values (1148,1834,9);
insert into casting values (1109,1834,7);
insert into casting values (593,1834,5);
insert into casting values (1042,1835,15);
insert into casting values (34,1835,2);
insert into casting values (713,1835,14);
insert into casting values (725,1835,3);
insert into casting values (818,1836,10);
insert into casting values (1013,1836,1);
insert into casting values (635,1836,15);
insert into casting values (953,1837,5);
insert into casting values (139,1837,14);
insert into casting values (151,1837,11);
insert into casting values (815,1838,4);
insert into casting values (1199,1838,12);
insert into casting values (1626,1838,6);
insert into casting values (30,1838,8);
insert into casting values (1642,1839,3);
insert into casting values (146,1839,3);
insert into casting values (705,1839,11);
insert into casting values (642,1839,14);
insert into casting values (775,1840,5);
insert into casting values (1471,1840,12);
insert into casting values (1272,1840,5);
insert into casting values (295,1840,15);
insert into casting values (775,1841,11);
insert into casting values (1437,1841,4);
insert into casting values (280,1841,13);
insert into casting values (572,1841,5);
insert into casting values (1147,1842,10);
insert into casting values (178,1842,5);
insert into casting values (127,1842,11);
insert into casting values (516,1842,3);
insert into casting values (873,1843,1);
insert into casting values (284,1843,13);
insert into casting values (214,1843,13);
insert into casting values (1785,1844,6);
insert into casting values (1774,1844,11);
insert into casting values (1709,1844,4);
insert into casting values (562,1844,9);
insert into casting values (666,1844,10);
insert into casting values (896,1845,14);
insert into casting values (1165,1845,4);
--- tabcasting, 9151, 50
insert into casting values (1233,1845,4);
insert into casting values (159,1845,12);
insert into casting values (1025,1846,4);
insert into casting values (294,1846,6);
insert into casting values (187,1846,12);
insert into casting values (649,1846,9);
insert into casting values (627,1846,13);
insert into casting values (1669,1847,12);
insert into casting values (1767,1847,4);
insert into casting values (263,1847,11);
insert into casting values (154,1847,5);
insert into casting values (822,1848,14);
insert into casting values (1793,1848,3);
insert into casting values (234,1848,13);
insert into casting values (617,1848,5);
insert into casting values (1473,1849,1);
insert into casting values (83,1849,15);
insert into casting values (547,1849,13);
insert into casting values (1075,1850,5);
insert into casting values (1009,1850,12);
insert into casting values (272,1850,15);
insert into casting values (407,1850,7);
insert into casting values (1366,1851,4);
insert into casting values (1644,1851,14);
insert into casting values (415,1851,2);
insert into casting values (633,1851,15);
insert into casting values (71,1852,1);
insert into casting values (98,1852,14);
insert into casting values (95,1852,12);
insert into casting values (431,1853,1);
insert into casting values (1033,1854,8);
insert into casting values (1051,1854,5);
insert into casting values (80,1854,10);
insert into casting values (444,1854,7);
insert into casting values (1454,1855,3);
insert into casting values (1241,1855,12);
insert into casting values (1683,1855,7);
insert into casting values (1665,1855,8);
insert into casting values (1580,1856,13);
insert into casting values (697,1856,1);
insert into casting values (1244,1857,2);
insert into casting values (1657,1857,2);
insert into casting values (631,1857,11);
insert into casting values (1549,1858,1);
insert into casting values (346,1858,10);
insert into casting values (733,1859,3);
insert into casting values (1689,1859,5);
insert into casting values (270,1859,12);
insert into casting values (966,1860,16);
insert into casting values (464,1860,5);
--- tabcasting, 9201, 50
insert into casting values (715,1860,5);
insert into casting values (1003,1861,3);
insert into casting values (1775,1861,5);
insert into casting values (184,1861,14);
insert into casting values (1301,1862,12);
insert into casting values (760,1863,3);
insert into casting values (771,1863,2);
insert into casting values (1644,1863,10);
insert into casting values (36,1864,11);
insert into casting values (1496,1865,4);
insert into casting values (1506,1865,11);
insert into casting values (668,1865,5);
insert into casting values (999,1866,11);
insert into casting values (972,1867,13);
insert into casting values (1393,1867,4);
insert into casting values (1507,1867,3);
insert into casting values (1278,1868,3);
insert into casting values (1678,1868,7);
insert into casting values (4,1868,12);
insert into casting values (6,1868,8);
insert into casting values (1418,1869,13);
insert into casting values (1793,1870,4);
insert into casting values (172,1870,5);
insert into casting values (598,1870,14);
insert into casting values (1456,1871,15);
insert into casting values (1107,1871,1);
insert into casting values (1297,1872,3);
insert into casting values (1456,1872,3);
insert into casting values (444,1872,12);
insert into casting values (204,1873,13);
insert into casting values (90,1873,7);
insert into casting values (101,1873,4);
insert into casting values (617,1873,7);
insert into casting values (1176,1874,11);
insert into casting values (1573,1874,8);
insert into casting values (344,1874,9);
insert into casting values (369,1874,5);
insert into casting values (1489,1875,5);
insert into casting values (529,1875,3);
insert into casting values (642,1875,11);
insert into casting values (367,1876,12);
insert into casting values (728,1876,1);
insert into casting values (1845,1877,2);
insert into casting values (1641,1877,15);
insert into casting values (1831,1877,3);
insert into casting values (867,1878,4);
insert into casting values (1358,1878,2);
insert into casting values (1707,1878,11);
insert into casting values (804,1879,11);
insert into casting values (911,1879,4);
--- tabcasting, 9251, 50
insert into casting values (1492,1879,4);
insert into casting values (1020,1880,5);
insert into casting values (1570,1880,12);
insert into casting values (1685,1880,6);
insert into casting values (363,1880,7);
insert into casting values (1432,1881,5);
insert into casting values (12,1881,12);
insert into casting values (765,1882,15);
insert into casting values (1465,1882,1);
insert into casting values (1744,1883,13);
insert into casting values (672,1883,1);
insert into casting values (1831,1884,13);
insert into casting values (124,1884,2);
insert into casting values (710,1884,2);
insert into casting values (661,1885,15);
insert into casting values (368,1886,15);
insert into casting values (1253,1887,1);
insert into casting values (1621,1887,13);
insert into casting values (1698,1888,2);
insert into casting values (1767,1888,2);
insert into casting values (1516,1888,15);
insert into casting values (1360,1889,9);
insert into casting values (1310,1889,10);
insert into casting values (1734,1889,7);
insert into casting values (695,1889,4);
insert into casting values (843,1890,10);
insert into casting values (1056,1890,1);
insert into casting values (965,1891,15);
insert into casting values (975,1891,8);
insert into casting values (1459,1891,6);
insert into casting values (1592,1891,5);
insert into casting values (1513,1892,8);
insert into casting values (152,1892,12);
insert into casting values (354,1892,7);
insert into casting values (509,1892,2);
insert into casting values (1040,1893,6);
insert into casting values (1083,1893,5);
insert into casting values (46,1893,15);
insert into casting values (394,1893,6);
insert into casting values (834,1894,1);
insert into casting values (713,1894,13);
insert into casting values (1235,1895,6);
insert into casting values (15,1895,3);
insert into casting values (310,1895,6);
insert into casting values (80,1895,11);
insert into casting values (1389,1896,4);
insert into casting values (1440,1896,15);
insert into casting values (1362,1896,6);
insert into casting values (1779,1896,8);
insert into casting values (1121,1898,4);
--- tabcasting, 9301, 50
insert into casting values (1318,1898,2);
insert into casting values (448,1898,11);
insert into casting values (1587,1899,5);
insert into casting values (330,1899,15);
insert into casting values (129,1899,3);
insert into casting values (761,1900,8);
insert into casting values (1153,1900,11);
insert into casting values (484,1900,6);
insert into casting values (407,1900,5);
insert into casting values (1178,1901,5);
insert into casting values (221,1901,13);
insert into casting values (496,1901,5);
insert into casting values (759,1902,3);
insert into casting values (711,1902,4);
insert into casting values (426,1902,13);
insert into casting values (1314,1903,3);
insert into casting values (1541,1903,15);
insert into casting values (115,1903,4);
insert into casting values (1003,1904,10);
insert into casting values (1052,1904,4);
insert into casting values (1697,1904,2);
insert into casting values (804,1905,12);
insert into casting values (1484,1905,3);
insert into casting values (1823,1905,2);
insert into casting values (442,1906,11);
insert into casting values (1592,1907,3);
insert into casting values (99,1907,3);
insert into casting values (793,1908,1);
insert into casting values (314,1908,10);
insert into casting values (804,1909,4);
insert into casting values (63,1909,12);
insert into casting values (1815,1910,3);
insert into casting values (31,1910,3);
insert into casting values (459,1910,14);
insert into casting values (844,1911,3);
insert into casting values (1612,1911,12);
insert into casting values (722,1911,3);
insert into casting values (1317,1912,1);
insert into casting values (1221,1913,8);
insert into casting values (1203,1913,14);
insert into casting values (8,1913,5);
insert into casting values (282,1913,6);
insert into casting values (1651,1914,8);
insert into casting values (1580,1914,7);
insert into casting values (230,1914,4);
insert into casting values (178,1914,15);
insert into casting values (1212,1915,15);
insert into casting values (290,1915,1);
insert into casting values (881,1916,10);
insert into casting values (794,1916,5);
--- tabcasting, 9351, 50
insert into casting values (276,1916,4);
insert into casting values (893,1917,15);
insert into casting values (753,1917,4);
insert into casting values (1494,1917,3);
insert into casting values (856,1918,12);
insert into casting values (1224,1918,3);
insert into casting values (1756,1918,6);
insert into casting values (174,1918,6);
insert into casting values (986,1919,13);
insert into casting values (1139,1919,5);
insert into casting values (291,1919,3);
insert into casting values (1275,1920,1);
insert into casting values (431,1920,12);
insert into casting values (1203,1921,1);
insert into casting values (175,1921,13);
insert into casting values (752,1922,4);
insert into casting values (1046,1922,3);
insert into casting values (51,1922,12);
insert into casting values (30,1923,14);
insert into casting values (815,1924,5);
insert into casting values (1565,1924,12);
insert into casting values (1626,1924,5);
insert into casting values (1587,1925,2);
insert into casting values (662,1925,11);
insert into casting values (384,1925,2);
insert into casting values (1371,1926,14);
insert into casting values (731,1927,14);
insert into casting values (985,1928,5);
insert into casting values (1597,1928,2);
insert into casting values (568,1928,11);
insert into casting values (940,1929,5);
insert into casting values (174,1929,12);
insert into casting values (322,1929,6);
insert into casting values (720,1929,6);
insert into casting values (914,1930,15);
insert into casting values (1355,1931,5);
insert into casting values (1636,1931,7);
insert into casting values (215,1931,6);
insert into casting values (384,1931,10);
insert into casting values (1320,1932,4);
insert into casting values (67,1932,3);
insert into casting values (607,1932,13);
insert into casting values (1367,1933,7);
insert into casting values (275,1933,14);
insert into casting values (24,1933,4);
insert into casting values (530,1933,9);
insert into casting values (1567,1934,13);
insert into casting values (140,1934,2);
insert into casting values (382,1934,3);
insert into casting values (1660,1935,4);
--- tabcasting, 9401, 50
insert into casting values (1820,1935,5);
insert into casting values (656,1935,14);
insert into casting values (1586,1936,1);
insert into casting values (567,1936,15);
insert into casting values (1041,1937,2);
insert into casting values (1603,1937,4);
insert into casting values (724,1937,12);
insert into casting values (358,1938,14);
insert into casting values (929,1939,12);
insert into casting values (1500,1939,2);
insert into casting values (9,1939,5);
insert into casting values (348,1940,13);
insert into casting values (946,1941,6);
insert into casting values (1624,1941,5);
insert into casting values (1628,1941,7);
insert into casting values (1142,1942,11);
insert into casting values (1323,1942,1);
insert into casting values (1392,1943,2);
insert into casting values (304,1943,4);
insert into casting values (525,1943,11);
insert into casting values (1030,1944,13);
insert into casting values (819,1944,3);
insert into casting values (524,1944,2);
insert into casting values (1035,1945,11);
insert into casting values (1031,1945,4);
insert into casting values (631,1945,3);
insert into casting values (1749,1946,13);
insert into casting values (241,1946,5);
insert into casting values (660,1946,5);
insert into casting values (1470,1947,5);
insert into casting values (284,1947,5);
insert into casting values (344,1947,14);
insert into casting values (1405,1948,1);
insert into casting values (702,1948,10);
insert into casting values (819,1949,1);
insert into casting values (373,1949,12);
insert into casting values (1006,1950,9);
insert into casting values (894,1950,3);
insert into casting values (769,1950,9);
insert into casting values (96,1950,10);
insert into casting values (749,1951,7);
insert into casting values (1151,1951,4);
insert into casting values (85,1951,13);
insert into casting values (8,1951,8);
insert into casting values (1046,1952,14);
insert into casting values (1153,1952,4);
insert into casting values (1227,1952,2);
insert into casting values (1216,1953,7);
insert into casting values (82,1953,5);
insert into casting values (95,1953,7);
--- tabcasting, 9451, 50
insert into casting values (628,1953,11);
insert into casting values (902,1954,12);
insert into casting values (364,1954,3);
insert into casting values (502,1954,4);
insert into casting values (833,1955,13);
insert into casting values (887,1956,11);
insert into casting values (164,1956,4);
insert into casting values (193,1956,4);
insert into casting values (1816,1957,1);
insert into casting values (283,1957,11);
insert into casting values (854,1958,1);
insert into casting values (1788,1958,13);
insert into casting values (1240,1959,14);
insert into casting values (498,1959,1);
insert into casting values (910,1960,11);
insert into casting values (1439,1960,7);
insert into casting values (1500,1960,6);
insert into casting values (1647,1960,8);
insert into casting values (380,1960,6);
insert into casting values (1063,1961,4);
insert into casting values (1588,1961,12);
insert into casting values (74,1961,2);
insert into casting values (837,1962,9);
insert into casting values (1232,1962,4);
insert into casting values (1603,1962,14);
insert into casting values (588,1962,6);
insert into casting values (995,1963,7);
insert into casting values (1315,1963,5);
insert into casting values (1180,1963,8);
insert into casting values (1785,1963,10);
insert into casting values (1089,1964,6);
insert into casting values (1565,1964,4);
insert into casting values (1486,1964,14);
insert into casting values (842,1965,4);
insert into casting values (1393,1965,9);
insert into casting values (78,1965,8);
insert into casting values (329,1965,13);
insert into casting values (1051,1966,11);
insert into casting values (227,1966,9);
insert into casting values (32,1966,7);
insert into casting values (500,1966,4);
insert into casting values (934,1967,8);
insert into casting values (802,1967,9);
insert into casting values (181,1967,11);
insert into casting values (302,1967,7);
insert into casting values (146,1967,7);
insert into casting values (988,1968,4);
insert into casting values (1187,1968,9);
insert into casting values (1370,1968,8);
insert into casting values (339,1968,11);
--- tabcasting, 9501, 50
insert into casting values (1321,1969,4);
insert into casting values (1569,1969,15);
insert into casting values (326,1969,3);
insert into casting values (1687,1970,15);
insert into casting values (1396,1971,10);
insert into casting values (1488,1971,8);
insert into casting values (1580,1971,8);
insert into casting values (306,1971,4);
insert into casting values (1023,1972,1);
insert into casting values (713,1972,12);
insert into casting values (732,1973,1);
insert into casting values (1242,1973,14);
insert into casting values (1172,1974,3);
insert into casting values (1566,1974,7);
insert into casting values (103,1974,9);
insert into casting values (647,1974,14);
insert into casting values (1173,1975,14);
insert into casting values (1381,1975,1);
insert into casting values (803,1976,5);
insert into casting values (1200,1976,20);
insert into casting values (1683,1976,4);
insert into casting values (1420,1977,13);
insert into casting values (1134,1977,1);
insert into casting values (1368,1978,5);
insert into casting values (253,1978,11);
insert into casting values (407,1978,2);
insert into casting values (323,1979,5);
insert into casting values (309,1979,7);
insert into casting values (166,1979,13);
insert into casting values (369,1979,7);
insert into casting values (923,1980,5);
insert into casting values (1780,1980,4);
insert into casting values (134,1980,10);
insert into casting values (843,1981,7);
insert into casting values (1527,1981,14);
insert into casting values (627,1981,8);
insert into casting values (651,1981,5);
insert into casting values (1266,1982,3);
insert into casting values (252,1982,11);
insert into casting values (289,1982,2);
insert into casting values (166,1983,14);
insert into casting values (577,1983,1);
insert into casting values (988,1984,10);
insert into casting values (1002,1984,7);
insert into casting values (1296,1984,5);
insert into casting values (200,1984,8);
insert into casting values (948,1985,3);
insert into casting values (1700,1985,15);
insert into casting values (94,1985,4);
insert into casting values (1057,1986,14);
--- tabcasting, 9551, 50
insert into casting values (1227,1986,6);
insert into casting values (1679,1986,5);
insert into casting values (462,1986,7);
insert into casting values (1018,1987,9);
insert into casting values (179,1987,9);
insert into casting values (269,1987,3);
insert into casting values (635,1987,10);
insert into casting values (139,1988,15);
insert into casting values (99,1988,2);
insert into casting values (358,1988,3);
insert into casting values (1429,1989,5);
insert into casting values (1695,1989,5);
insert into casting values (476,1989,14);
insert into casting values (1068,1990,7);
insert into casting values (1099,1990,2);
insert into casting values (814,1990,8);
insert into casting values (989,1990,10);
insert into casting values (1070,1991,12);
insert into casting values (1450,1991,9);
insert into casting values (1810,1991,3);
insert into casting values (1760,1991,8);
insert into casting values (1024,1992,6);
insert into casting values (1355,1992,12);
insert into casting values (1665,1992,3);
insert into casting values (414,1992,6);
insert into casting values (1252,1993,5);
insert into casting values (1802,1993,14);
insert into casting values (677,1993,3);
insert into casting values (1630,1994,5);
insert into casting values (1841,1994,9);
insert into casting values (1562,1994,9);
insert into casting values (1686,1994,10);
insert into casting values (1372,1995,3);
insert into casting values (1494,1995,11);
insert into casting values (494,1995,3);
insert into casting values (878,1996,1);
insert into casting values (1350,1996,11);
insert into casting values (595,1997,5);
insert into casting values (414,1997,2);
insert into casting values (1186,1998,3);
insert into casting values (1830,1998,4);
insert into casting values (1330,1999,1);
insert into casting values (734,2000,3);
insert into casting values (667,2000,5);
insert into casting values (473,2003,2);
insert into casting values (519,2003,3);
insert into casting values (321,2004,1);
insert into casting values (1651,2005,4);
insert into casting values (398,2005,4);
insert into casting values (1356,2007,5);
--- tabcasting, 9601, 50
insert into casting values (1525,2007,2);
insert into casting values (1637,2008,3);
insert into casting values (677,2008,4);
insert into casting values (924,2009,1);
insert into casting values (366,2010,1);
insert into casting values (1247,2012,4);
insert into casting values (997,2013,1);
insert into casting values (871,2019,5);
insert into casting values (1456,2019,4);
insert into casting values (795,2022,1);
insert into casting values (303,2030,1);
insert into casting values (1432,2032,1);
insert into casting values (981,2033,2);
insert into casting values (922,2034,5);
insert into casting values (589,2034,3);
insert into casting values (1427,2036,3);
insert into casting values (1252,2036,3);
insert into casting values (398,2037,1);
insert into casting values (1390,2041,5);
insert into casting values (1804,2041,4);
insert into casting values (1612,2042,1);
insert into casting values (1330,2044,4);
insert into casting values (199,2044,2);
insert into casting values (1217,2047,4);
insert into casting values (1740,2047,8);
insert into casting values (52,2047,8);
insert into casting values (1402,2049,1);
insert into casting values (1820,2050,9);
insert into casting values (1659,2050,7);
insert into casting values (305,2050,9);
insert into casting values (137,2050,7);
insert into casting values (914,2052,3);
insert into casting values (1454,2052,2);
insert into casting values (571,2053,3);
insert into casting values (679,2053,5);
insert into casting values (1168,2055,1);
insert into casting values (1177,2056,7);
insert into casting values (283,2056,8);
insert into casting values (713,2056,3);
insert into casting values (1074,2057,4);
insert into casting values (1788,2057,3);
insert into casting values (1176,2058,5);
insert into casting values (557,2058,5);
insert into casting values (1467,2060,2);
insert into casting values (79,2060,3);
insert into casting values (1489,2062,1);
insert into casting values (375,2063,1);
insert into casting values (1412,2064,4);
insert into casting values (1597,2064,5);
insert into casting values (1074,2065,1);
--- tabcasting, 9651, 50
insert into casting values (92,2066,1);
insert into casting values (748,2067,7);
insert into casting values (1754,2067,2);
insert into casting values (650,2067,8);
insert into casting values (1373,2068,1);
insert into casting values (1538,2069,3);
insert into casting values (611,2069,2);
insert into casting values (974,2070,3);
insert into casting values (1749,2070,8);
insert into casting values (241,2070,8);
insert into casting values (1283,2071,7);
insert into casting values (1724,2071,3);
insert into casting values (318,2071,6);
insert into casting values (998,2074,4);
insert into casting values (1271,2074,3);
insert into casting values (1432,2075,8);
insert into casting values (1719,2075,4);
insert into casting values (532,2075,9);
insert into casting values (1234,2076,4);
insert into casting values (442,2076,3);
insert into casting values (903,2077,7);
insert into casting values (1225,2077,9);
insert into casting values (1672,2077,3);
insert into casting values (1145,2078,4);
insert into casting values (1118,2078,2);
insert into casting values (629,2079,1);
insert into casting values (249,2081,4);
insert into casting values (437,2081,5);
insert into casting values (1312,2082,5);
insert into casting values (1121,2082,5);
insert into casting values (324,2083,1);
insert into casting values (1350,2085,1);
insert into casting values (1055,2087,1);
insert into casting values (1157,2088,3);
insert into casting values (1260,2088,5);
insert into casting values (1461,2092,1);
insert into casting values (1072,2093,3);
insert into casting values (997,2093,2);
insert into casting values (1079,2095,5);
insert into casting values (193,2095,3);
insert into casting values (1836,2096,1);
insert into casting values (1415,2097,1);
insert into casting values (1067,2098,2);
insert into casting values (1614,2098,3);
insert into casting values (1107,2099,3);
insert into casting values (1488,2099,5);
insert into casting values (952,2100,4);
insert into casting values (879,2100,4);
insert into casting values (214,2102,1);
insert into casting values (1181,2104,1);
--- tabcasting, 9701, 50
insert into casting values (687,2106,1);
insert into casting values (1337,2107,5);
insert into casting values (1780,2107,5);
insert into casting values (464,2108,1);
insert into casting values (1145,2113,1);
insert into casting values (1782,2119,7);
insert into casting values (451,2119,3);
insert into casting values (412,2119,7);
insert into casting values (975,2120,4);
insert into casting values (1713,2120,2);
insert into casting values (1533,2121,1);
insert into casting values (911,2123,2);
insert into casting values (1379,2123,2);
insert into casting values (907,2124,1);
insert into casting values (883,2130,3);
insert into casting values (1488,2130,3);
insert into casting values (643,2131,5);
insert into casting values (1098,2135,3);
insert into casting values (1111,2135,3);
insert into casting values (1413,2136,5);
insert into casting values (696,2136,2);
insert into casting values (788,2137,4);
insert into casting values (1129,2137,4);
insert into casting values (340,2141,5);
insert into casting values (551,2141,5);
insert into casting values (1499,2143,1);
insert into casting values (768,2144,1);
insert into casting values (1028,2145,3);
insert into casting values (1147,2145,4);
insert into casting values (476,2147,1);
insert into casting values (823,2148,1);
insert into casting values (870,2150,4);
insert into casting values (724,2150,5);
insert into casting values (756,2153,5);
insert into casting values (987,2153,9);
insert into casting values (1339,2154,1);
insert into casting values (1207,2157,1);
insert into casting values (1586,2158,4);
insert into casting values (199,2158,3);
insert into casting values (1499,2159,3);
insert into casting values (1558,2159,3);
insert into casting values (930,2160,6);
insert into casting values (1474,2160,6);
insert into casting values (151,2160,4);
insert into casting values (1417,2161,1);
insert into casting values (1449,2165,9);
insert into casting values (1187,2165,8);
insert into casting values (1539,2165,2);
insert into casting values (1352,2170,4);
insert into casting values (609,2170,3);
--- tabcasting, 9751, 50
insert into casting values (1345,2171,3);
insert into casting values (121,2171,3);
insert into casting values (966,2173,3);
insert into casting values (555,2173,2);
insert into casting values (1680,2174,1);
insert into casting values (1200,2177,1);
insert into casting values (1705,2179,5);
insert into casting values (135,2179,4);
insert into casting values (720,2180,2);
insert into casting values (628,2180,3);
insert into casting values (59,2182,1);
insert into casting values (793,2185,7);
insert into casting values (1722,2185,6);
insert into casting values (550,2185,4);
insert into casting values (1614,2188,1);
insert into casting values (1255,2189,1);
insert into casting values (924,2192,3);
insert into casting values (1790,2192,3);
insert into casting values (499,2193,1);
insert into casting values (1453,2195,1);
insert into casting values (1450,2197,5);
insert into casting values (1557,2197,5);
insert into casting values (1398,2198,4);
insert into casting values (442,2198,5);
insert into casting values (421,2200,2);
insert into casting values (692,2200,2);
insert into casting values (832,2201,9);
insert into casting values (1249,2201,5);
insert into casting values (263,2201,8);
insert into casting values (823,2202,4);
insert into casting values (580,2202,5);
insert into casting values (1507,2203,5);
insert into casting values (206,2203,5);
insert into casting values (889,2207,5);
insert into casting values (938,2207,4);
insert into casting values (942,2209,9);
insert into casting values (899,2209,7);
insert into casting values (268,2209,4);
insert into casting values (983,2210,1);
insert into casting values (168,2213,5);
insert into casting values (709,2213,4);
insert into casting values (1135,2214,5);
insert into casting values (659,2216,1);
insert into casting values (1028,2218,5);
insert into casting values (1422,2218,4);
insert into casting values (1033,2219,5);
insert into casting values (1561,2219,5);
insert into casting values (355,2220,1);
insert into casting values (752,2222,8);
insert into casting values (1101,2222,5);
--- tabcasting, 9801, 50
insert into casting values (1560,2222,7);
insert into casting values (1207,2223,4);
insert into casting values (573,2223,2);
insert into casting values (1175,2225,3);
insert into casting values (18,2225,2);
insert into casting values (958,2227,2);
insert into casting values (1222,2227,2);
insert into casting values (1036,2228,3);
insert into casting values (813,2228,5);
insert into casting values (689,2229,1);
insert into casting values (352,2230,6);
insert into casting values (595,2230,7);
insert into casting values (617,2230,2);
insert into casting values (1365,2234,6);
insert into casting values (1396,2234,8);
insert into casting values (1116,2234,3);
insert into casting values (1186,2237,1);
insert into casting values (1768,2238,1);
insert into casting values (735,2240,9);
insert into casting values (1331,2240,8);
insert into casting values (1844,2240,8);
insert into casting values (227,2240,7);
insert into casting values (1716,2241,1);
insert into casting values (772,2243,1);
insert into casting values (1359,2244,1);
insert into casting values (541,2246,1);
insert into casting values (1833,2249,1);
insert into casting values (1691,2251,1);
insert into casting values (1126,2254,4);
insert into casting values (1808,2254,2);
insert into casting values (799,2255,5);
insert into casting values (1459,2255,5);
insert into casting values (896,2256,5);
insert into casting values (704,2256,2);
insert into casting values (1131,2258,2);
insert into casting values (195,2258,2);
insert into casting values (1380,2261,1);
insert into casting values (1259,2263,1);
insert into casting values (1603,2266,9);
insert into casting values (263,2266,9);
insert into casting values (90,2266,5);
insert into casting values (1234,2268,1);
insert into casting values (1405,2270,3);
insert into casting values (341,2270,4);
insert into casting values (1524,2272,1);
insert into casting values (947,2274,8);
insert into casting values (1419,2274,5);
insert into casting values (1611,2274,8);
insert into casting values (101,2276,1);
insert into casting values (194,2277,1);
--- tabcasting, 9851, 50
insert into casting values (1262,2281,4);
insert into casting values (1159,2281,3);
insert into casting values (397,2285,4);
insert into casting values (460,2285,5);
insert into casting values (1714,2286,1);
insert into casting values (602,2288,1);
insert into casting values (386,2289,1);
insert into casting values (791,2290,1);
insert into casting values (1381,2291,2);
insert into casting values (1700,2291,3);
insert into casting values (972,2294,4);
insert into casting values (1835,2294,5);
insert into casting values (203,2297,5);
insert into casting values (477,2297,5);
insert into casting values (1085,2300,4);
insert into casting values (1685,2300,5);
insert into casting values (418,2301,5);
insert into casting values (696,2301,5);
insert into casting values (744,2302,1);
insert into casting values (702,2304,1);
insert into casting values (1003,2307,8);
insert into casting values (846,2307,13);
insert into casting values (1471,2307,13);
insert into casting values (1774,2307,9);
insert into casting values (1575,2307,10);
insert into casting values (316,2307,11);
insert into casting values (542,2307,15);
insert into casting values (935,2308,1);
insert into casting values (1029,2309,3);
insert into casting values (316,2309,5);
insert into casting values (780,2310,5);
insert into casting values (1206,2310,6);
insert into casting values (361,2310,6);
insert into casting values (1444,2312,1);
insert into casting values (1103,2313,1);
insert into casting values (1093,2316,2);
insert into casting values (1747,2316,3);
insert into casting values (1470,2318,4);
insert into casting values (1781,2318,5);
insert into casting values (371,2319,5);
insert into casting values (700,2319,5);
insert into casting values (1696,2321,2);
insert into casting values (551,2321,2);
insert into casting values (1314,2322,1);
insert into casting values (935,2326,5);
insert into casting values (1747,2326,5);
insert into casting values (1163,2328,3);
insert into casting values (1490,2328,3);
insert into casting values (966,2329,2);
insert into casting values (555,2329,3);
--- tabcasting, 9901, 50
insert into casting values (1079,2330,6);
insert into casting values (1315,2330,4);
insert into casting values (419,2330,6);
insert into casting values (1712,2331,1);
insert into casting values (1663,2332,1);
insert into casting values (1743,2333,4);
insert into casting values (82,2333,4);
insert into casting values (804,2335,1);
insert into casting values (1010,2336,1);
insert into casting values (921,2338,3);
insert into casting values (1504,2338,4);
insert into casting values (1075,2340,7);
insert into casting values (219,2340,5);
insert into casting values (608,2340,6);
insert into casting values (175,2344,1);
insert into casting values (842,2348,9);
insert into casting values (1414,2348,3);
insert into casting values (1602,2348,7);
insert into casting values (1464,2349,5);
insert into casting values (1507,2349,2);
insert into casting values (1485,2350,1);
insert into casting values (1174,2354,2);
insert into casting values (727,2354,5);
insert into casting values (1652,2357,1);
insert into casting values (853,2359,3);
insert into casting values (433,2359,4);
insert into casting values (1199,2360,2);
insert into casting values (607,2360,8);
insert into casting values (1072,2361,8);
insert into casting values (1179,2361,5);
insert into casting values (1498,2361,8);
insert into casting values (1687,2363,1);
insert into casting values (1220,2364,3);
insert into casting values (52,2364,2);
insert into casting values (387,2366,1);
insert into casting values (31,2367,1);
insert into casting values (1171,2368,1);
insert into casting values (724,2369,1);
insert into casting values (1276,2370,4);
insert into casting values (1764,2370,5);
insert into casting values (783,2371,2);
insert into casting values (1633,2371,7);
insert into casting values (529,2371,7);
insert into casting values (1068,2372,3);
insert into casting values (1305,2372,2);
insert into casting values (872,2374,1);
insert into casting values (1791,2375,1);
insert into casting values (1277,2377,7);
insert into casting values (338,2377,6);
insert into casting values (318,2377,4);
--- tabcasting, 9951, 50
insert into casting values (1233,2379,3);
insert into casting values (624,2379,4);
insert into casting values (1386,2380,3);
insert into casting values (308,2380,4);
insert into casting values (758,2381,1);
insert into casting values (1369,2383,1);
insert into casting values (913,2384,3);
insert into casting values (882,2384,2);
insert into casting values (1360,2386,2);
insert into casting values (1171,2386,5);
insert into casting values (411,2387,1);
insert into casting values (1099,2391,4);
insert into casting values (583,2391,4);
insert into casting values (1053,2392,3);
insert into casting values (1726,2392,6);
insert into casting values (358,2392,8);
insert into casting values (1159,2393,4);
insert into casting values (455,2393,4);
insert into casting values (1264,2394,1);
insert into casting values (655,2395,1);
insert into casting values (1751,2396,6);
insert into casting values (1533,2396,9);
insert into casting values (707,2396,5);
insert into casting values (1500,2397,1);
insert into casting values (1666,2398,1);
insert into casting values (1108,2402,3);
insert into casting values (1843,2402,4);
insert into casting values (1674,2403,1);
insert into casting values (1012,2404,3);
insert into casting values (1737,2404,4);
insert into casting values (852,2405,1);
insert into casting values (503,2407,5);
insert into casting values (450,2407,5);
insert into casting values (1216,2408,5);
insert into casting values (200,2408,5);
insert into casting values (1329,2409,7);
insert into casting values (1282,2409,4);
insert into casting values (1779,2409,7);
insert into casting values (1071,2410,5);
insert into casting values (252,2410,9);
insert into casting values (1183,2411,3);
insert into casting values (72,2412,1);
insert into casting values (1038,2413,1);
insert into casting values (1531,2414,1);
insert into casting values (1044,2415,4);
insert into casting values (1404,2416,8);
insert into casting values (1694,2416,6);
insert into casting values (69,2416,5);
insert into casting values (1087,2417,5);
insert into casting values (1214,2417,3);
--- tabcasting, 10001, 50
insert into casting values (1671,2421,1);
insert into casting values (245,2422,5);
insert into casting values (702,2422,5);
insert into casting values (1481,2428,4);
insert into casting values (1074,2435,2);
insert into casting values (1435,2435,5);
insert into casting values (445,2436,1);
insert into casting values (720,2437,1);
insert into casting values (1219,2438,2);
insert into casting values (254,2438,4);
insert into casting values (1632,2439,1);
insert into casting values (1213,2440,1);
insert into casting values (1307,2441,1);
insert into casting values (1711,2442,1);
insert into casting values (1321,2443,1);
insert into casting values (9,2446,1);
insert into casting values (1080,2449,1);
insert into casting values (1333,2450,5);
insert into casting values (1771,2450,2);
insert into casting values (285,2456,1);
insert into casting values (1635,2457,4);
insert into casting values (1567,2457,5);
insert into casting values (1542,2460,1);
insert into casting values (189,2465,5);
insert into casting values (271,2465,4);
insert into casting values (1450,2469,7);
insert into casting values (1426,2469,3);
insert into casting values (1074,2470,3);
insert into casting values (676,2470,5);
insert into casting values (1178,2471,3);
insert into casting values (1465,2471,5);
insert into casting values (222,2475,3);
insert into casting values (330,2475,4);
insert into casting values (1704,2476,5);
insert into casting values (566,2476,3);
insert into casting values (1779,2477,4);
insert into casting values (1727,2477,3);
insert into casting values (927,2481,1);
insert into casting values (1096,2482,6);
insert into casting values (1451,2482,8);
insert into casting values (1686,2482,5);
insert into casting values (1568,2484,1);
insert into casting values (172,2485,1);
insert into casting values (924,2486,2);
insert into casting values (105,2486,4);
insert into casting values (341,2487,2);
insert into casting values (682,2487,2);
insert into casting values (1184,2488,4);
insert into casting values (1442,2488,5);
insert into casting values (1150,2490,1);
--- tabcasting, 10051, 50
insert into casting values (1112,2494,3);
insert into casting values (139,2494,2);
insert into casting values (812,2495,7);
insert into casting values (1801,2495,2);
insert into casting values (45,2495,6);
insert into casting values (1758,2496,4);
insert into casting values (427,2496,5);
insert into casting values (1778,2497,6);
insert into casting values (1657,2497,9);
insert into casting values (728,2497,2);
insert into casting values (1821,2498,2);
insert into casting values (329,2498,5);
insert into casting values (1543,2499,1);
insert into casting values (1804,2504,1);
insert into casting values (785,2505,9);
insert into casting values (770,2505,3);
insert into casting values (1122,2505,8);
insert into casting values (1702,2506,5);
insert into casting values (1577,2506,3);
insert into casting values (1470,2507,1);
insert into casting values (153,2508,1);
insert into casting values (988,2511,1);
insert into casting values (776,2514,1);
insert into casting values (858,2516,5);
insert into casting values (1788,2516,6);
insert into casting values (632,2516,9);
insert into casting values (276,2519,1);
insert into casting values (1073,2520,4);
insert into casting values (1544,2520,2);
insert into casting values (876,2521,1);
insert into casting values (1418,2522,1);
insert into casting values (1072,2523,1);
insert into casting values (1617,2524,2);
insert into casting values (723,2524,3);
insert into casting values (1830,2525,1);
insert into casting values (676,2527,4);
insert into casting values (611,2527,9);
insert into casting values (661,2527,6);
insert into casting values (1303,2529,1);
insert into casting values (713,2530,2);
insert into casting values (512,2530,4);
insert into casting values (721,2533,1);
insert into casting values (1265,2534,5);
insert into casting values (1522,2534,3);
insert into casting values (1118,2535,1);
insert into casting values (1213,2536,2);
insert into casting values (1836,2536,3);
insert into casting values (1040,2537,2);
insert into casting values (869,2537,7);
insert into casting values (673,2537,6);
--- tabcasting, 10101, 50
insert into casting values (1299,2538,1);
insert into casting values (1595,2545,1);
insert into casting values (866,2546,7);
insert into casting values (1136,2546,3);
insert into casting values (126,2546,9);
insert into casting values (1060,2547,1);
insert into casting values (1628,2548,2);
insert into casting values (198,2548,3);
insert into casting values (1021,2549,3);
insert into casting values (1698,2549,4);
insert into casting values (1395,2550,9);
insert into casting values (1727,2550,7);
insert into casting values (409,2550,3);
insert into casting values (982,2553,4);
insert into casting values (1655,2553,5);
insert into casting values (936,2554,4);
insert into casting values (289,2554,3);
insert into casting values (671,2555,1);
insert into casting values (1008,2559,1);
insert into casting values (1061,2562,4);
insert into casting values (1658,2562,5);
insert into casting values (1587,2563,3);
insert into casting values (204,2563,4);
insert into casting values (847,2565,1);
insert into casting values (1003,2566,1);
insert into casting values (1653,2568,1);
insert into casting values (1599,2569,1);
insert into casting values (1617,2572,1);
insert into casting values (1787,2576,4);
insert into casting values (11,2576,3);
insert into casting values (1656,2579,1);
insert into casting values (797,2580,3);
insert into casting values (1088,2580,4);
insert into casting values (1623,2583,1);
insert into casting values (1763,2584,2);
insert into casting values (608,2584,3);
insert into casting values (723,2591,5);
insert into casting values (380,2591,4);
insert into casting values (1772,2595,1);
insert into casting values (397,2600,1);
insert into casting values (1509,2602,5);
insert into casting values (511,2602,4);
insert into casting values (1750,2603,1);
insert into casting values (993,2604,1);
insert into casting values (1411,2607,4);
insert into casting values (1763,2608,3);
insert into casting values (220,2608,6);
insert into casting values (608,2608,8);
insert into casting values (1131,2609,7);
insert into casting values (1515,2609,7);
--- tabcasting, 10151, 50
insert into casting values (227,2609,3);
insert into casting values (833,2611,1);
insert into casting values (1533,2616,5);
insert into casting values (1656,2616,3);
insert into casting values (1140,2617,1);
insert into casting values (1333,2622,2);
insert into casting values (1750,2622,3);
insert into casting values (1061,2624,5);
insert into casting values (1145,2624,5);
insert into casting values (1435,2627,4);
insert into casting values (1655,2627,2);
insert into casting values (919,2632,2);
insert into casting values (76,2632,3);
insert into casting values (1796,2635,2);
insert into casting values (644,2635,3);
insert into casting values (1525,2636,1);
insert into casting values (1311,2637,1);
insert into casting values (404,2638,1);
insert into casting values (1513,2639,7);
insert into casting values (1811,2639,4);
insert into casting values (1554,2640,1);
insert into casting values (227,2646,5);
insert into casting values (573,2646,5);
insert into casting values (785,2648,7);
insert into casting values (1825,2648,4);
insert into casting values (1411,2649,5);
insert into casting values (97,2649,4);
insert into casting values (1723,2650,1);
insert into casting values (504,2654,1);
insert into casting values (1762,2656,1);
insert into casting values (927,2657,2);
insert into casting values (1341,2657,3);
insert into casting values (665,2658,4);
insert into casting values (883,2660,4);
insert into casting values (1488,2660,4);
insert into casting values (1799,2662,2);
insert into casting values (237,2662,2);
insert into casting values (1336,2666,3);
insert into casting values (1788,2666,4);
insert into casting values (1332,2667,2);
insert into casting values (452,2667,4);
insert into casting values (824,2668,14);
insert into casting values (1239,2668,11);
insert into casting values (1596,2668,5);
insert into casting values (279,2668,12);
insert into casting values (344,2668,8);
insert into casting values (586,2668,13);
insert into casting values (759,2669,1);
insert into casting values (1812,2671,1);
insert into casting values (1721,2672,4);
--- tabcasting, 10201, 50
insert into casting values (510,2672,5);
insert into casting values (805,2677,1);
insert into casting values (1028,2678,2);
insert into casting values (1781,2678,2);
insert into casting values (1423,2679,2);
insert into casting values (1601,2679,3);
insert into casting values (1731,2681,5);
insert into casting values (1780,2681,9);
insert into casting values (607,2681,7);
insert into casting values (539,2682,1);
insert into casting values (313,2683,1);
insert into casting values (1070,2685,7);
insert into casting values (955,2685,8);
insert into casting values (916,2685,4);
insert into casting values (1797,2687,1);
insert into casting values (1504,2694,3);
insert into casting values (729,2694,2);
insert into casting values (951,2695,1);
insert into casting values (914,2697,4);
insert into casting values (1454,2697,5);
insert into casting values (295,2700,3);
insert into casting values (527,2700,2);
insert into casting values (1384,2702,5);
insert into casting values (727,2702,3);
insert into casting values (1210,2703,1);
insert into casting values (837,2705,2);
insert into casting values (1112,2705,5);
insert into casting values (845,2708,1);
insert into casting values (1447,2709,1);
insert into casting values (1588,2710,1);
insert into casting values (412,2711,1);
insert into casting values (1805,2718,1);
insert into casting values (738,2719,1);
insert into casting values (1320,2720,1);
insert into casting values (1703,2722,1);
insert into casting values (844,2723,9);
insert into casting values (1215,2723,3);
insert into casting values (705,2723,6);
insert into casting values (1044,2724,2);
insert into casting values (1741,2724,2);
insert into casting values (1248,2728,1);
insert into casting values (1748,2730,1);
insert into casting values (1251,2731,5);
insert into casting values (1841,2731,3);
insert into casting values (1056,2732,4);
insert into casting values (1679,2732,3);
insert into casting values (183,2733,1);
insert into casting values (749,2736,3);
insert into casting values (1287,2736,3);
insert into casting values (475,2737,1);
--- tabcasting, 10251, 50
insert into casting values (1302,2738,1);
insert into casting values (1263,2739,4);
insert into casting values (1599,2739,2);
insert into casting values (1265,2741,1);
insert into casting values (1475,2742,4);
insert into casting values (560,2742,4);
insert into casting values (1359,2746,5);
insert into casting values (1127,2746,3);
insert into casting values (1714,2748,3);
insert into casting values (299,2748,3);
insert into casting values (716,2749,1);
insert into casting values (1403,2750,5);
insert into casting values (1638,2750,3);
insert into casting values (1154,2751,1);
insert into casting values (1155,2753,2);
insert into casting values (1588,2753,2);
insert into casting values (1818,2756,1);
insert into casting values (1116,2764,9);
insert into casting values (1186,2764,4);
insert into casting values (1830,2764,6);
insert into casting values (1751,2766,3);
insert into casting values (1539,2766,4);
insert into casting values (756,2767,6);
insert into casting values (1317,2767,4);
insert into casting values (1694,2769,5);
insert into casting values (181,2769,2);
insert into casting values (230,2772,1);
insert into casting values (1164,2773,5);
insert into casting values (1130,2773,3);
insert into casting values (1219,2774,4);
insert into casting values (1638,2778,4);
insert into casting values (329,2778,3);
insert into casting values (1679,2780,1);
insert into casting values (1557,2786,9);
insert into casting values (1578,2786,5);
insert into casting values (257,2786,9);
insert into casting values (1301,2788,1);
insert into casting values (1760,2789,1);
insert into casting values (1677,2790,1);
insert into casting values (1446,2791,1);
insert into casting values (1695,2792,4);
insert into casting values (27,2792,7);
insert into casting values (455,2792,6);
insert into casting values (695,2794,1);
insert into casting values (1452,2796,1);
insert into casting values (282,2798,5);
insert into casting values (535,2798,4);
insert into casting values (681,2799,1);
insert into casting values (664,2800,1);
insert into casting values (1121,2801,7);
--- tabcasting, 10301, 50
insert into casting values (1573,2801,7);
insert into casting values (417,2801,3);
insert into casting values (806,2805,5);
insert into casting values (1409,2811,4);
insert into casting values (1116,2811,2);
insert into casting values (1111,2812,5);
insert into casting values (249,2812,5);
insert into casting values (1576,2813,1);
insert into casting values (888,2814,1);
insert into casting values (1746,2815,1);
insert into casting values (1535,2816,3);
insert into casting values (516,2816,5);
insert into casting values (764,2817,4);
insert into casting values (1073,2817,5);
insert into casting values (1259,2818,5);
insert into casting values (546,2818,2);
insert into casting values (812,2820,3);
insert into casting values (1779,2820,2);
insert into casting values (1800,2821,1);
insert into casting values (892,2826,9);
insert into casting values (1547,2826,5);
insert into casting values (96,2826,8);
insert into casting values (1242,2827,1);
insert into casting values (378,2828,1);
insert into casting values (1397,2831,4);
insert into casting values (1223,2831,4);
insert into casting values (1262,2832,3);
insert into casting values (455,2832,3);
insert into casting values (945,2834,7);
insert into casting values (950,2834,2);
insert into casting values (1814,2834,6);
insert into casting values (889,2835,1);
insert into casting values (1621,2836,5);
insert into casting values (456,2836,4);
insert into casting values (790,2837,3);
insert into casting values (309,2837,4);
insert into casting values (750,2839,5);
insert into casting values (1704,2839,4);
insert into casting values (973,2841,3);
insert into casting values (115,2841,2);
insert into casting values (571,2843,1);
insert into casting values (1737,2844,5);
insert into casting values (559,2844,4);
insert into casting values (1182,2845,5);
insert into casting values (1411,2845,3);
insert into casting values (1164,2850,4);
insert into casting values (1658,2850,4);
insert into casting values (1241,2851,1);
insert into casting values (1808,2854,3);
insert into casting values (334,2854,8);
--- tabcasting, 10351, 50
insert into casting values (210,2854,7);
insert into casting values (883,2855,2);
insert into casting values (1488,2855,2);
insert into casting values (840,2856,3);
insert into casting values (449,2856,2);
insert into casting values (1185,2858,1);
insert into casting values (1029,2862,5);
insert into casting values (1760,2862,4);
insert into casting values (1027,2864,3);
insert into casting values (1592,2864,6);
insert into casting values (1204,2865,5);
insert into casting values (673,2865,3);
insert into casting values (1227,2866,5);
insert into casting values (458,2866,4);
insert into casting values (426,2869,1);
insert into casting values (1287,2870,1);
insert into casting values (1186,2871,5);
insert into casting values (1830,2871,5);
insert into casting values (787,2872,6);
insert into casting values (1744,2872,14);
insert into casting values (299,2872,6);
insert into casting values (726,2872,14);
insert into casting values (579,2872,8);
insert into casting values (723,2872,15);
insert into casting values (729,2872,13);
insert into casting values (1055,2873,6);
insert into casting values (1392,2873,11);
insert into casting values (388,2873,11);
insert into casting values (553,2873,9);
insert into casting values (454,2873,10);
insert into casting values (640,2873,7);
insert into casting values (714,2873,13);
insert into casting values (1541,2874,11);
insert into casting values (1733,2874,10);
insert into casting values (251,2874,13);
insert into casting values (301,2874,8);
insert into casting values (412,2874,2);
insert into casting values (657,2874,13);
insert into casting values (1282,2875,7);
insert into casting values (1668,2875,12);
insert into casting values (1820,2875,14);
insert into casting values (239,2875,12);
insert into casting values (615,2875,8);
insert into casting values (466,2875,11);
insert into casting values (1123,2876,4);
insert into casting values (1392,2876,12);
insert into casting values (1449,2876,12);
insert into casting values (1584,2876,10);
insert into casting values (267,2876,8);
insert into casting values (985,2877,15);
--- tabcasting, 10401, 50
insert into casting values (763,2877,12);
insert into casting values (1250,2877,2);
insert into casting values (1659,2877,14);
insert into casting values (610,2877,7);
insert into casting values (462,2877,10);
insert into casting values (808,2878,15);
insert into casting values (842,2878,12);
insert into casting values (793,2878,5);
insert into casting values (1106,2878,14);
insert into casting values (68,2878,14);
insert into casting values (661,2878,7);
insert into casting values (1627,2879,10);
insert into casting values (297,2879,11);
insert into casting values (677,2879,9);
insert into casting values (375,2879,9);
insert into casting values (569,2879,10);
insert into casting values (609,2879,14);
insert into casting values (534,2879,9);
insert into casting values (747,2880,9);
insert into casting values (989,2880,14);
insert into casting values (1254,2880,4);
insert into casting values (1727,2880,15);
insert into casting values (362,2880,13);
insert into casting values (13,2881,13);
insert into casting values (64,2881,9);
insert into casting values (17,2881,12);
insert into casting values (5,2881,8);
insert into casting values (1,2881,7);
insert into casting values (501,2881,11);
insert into casting values (761,2882,12);
insert into casting values (738,2882,14);
insert into casting values (962,2882,12);
insert into casting values (1051,2882,7);
insert into casting values (1220,2882,4);
insert into casting values (1248,2883,7);
insert into casting values (1321,2883,15);
insert into casting values (1238,2883,5);
insert into casting values (1662,2883,10);
insert into casting values (409,2883,15);
insert into casting values (1031,2884,12);
insert into casting values (851,2884,11);
insert into casting values (1553,2884,15);
insert into casting values (1642,2884,7);
insert into casting values (699,2884,6);
insert into casting values (503,2884,6);
insert into casting values (828,2885,11);
insert into casting values (1388,2885,12);
insert into casting values (1524,2885,10);
insert into casting values (1731,2885,3);
insert into casting values (617,2885,9);
--- tabcasting, 10451, 50
insert into casting values (894,2886,4);
insert into casting values (770,2886,14);
insert into casting values (1325,2886,10);
insert into casting values (1604,2886,14);
insert into casting values (255,2886,6);
insert into casting values (998,2887,13);
insert into casting values (1497,2887,5);
insert into casting values (147,2887,12);
insert into casting values (275,2887,8);
insert into casting values (545,2887,10);
insert into casting values (782,2888,15);
insert into casting values (205,2888,10);
insert into casting values (178,2888,8);
insert into casting values (218,2888,15);
insert into casting values (351,2888,8);
insert into casting values (514,2888,9);
insert into casting values (838,2889,15);
insert into casting values (1233,2889,15);
insert into casting values (1360,2889,5);
insert into casting values (1363,2889,9);
insert into casting values (1728,2889,12);
insert into casting values (933,2890,6);
insert into casting values (1221,2890,10);
insert into casting values (1607,2890,15);
insert into casting values (128,2890,7);
insert into casting values (630,2890,9);
insert into casting values (600,2890,15);
insert into casting values (1087,2891,8);
insert into casting values (1007,2891,7);
insert into casting values (1009,2891,7);
insert into casting values (342,2891,15);
insert into casting values (61,2891,10);
insert into casting values (437,2891,13);
insert into casting values (1005,2892,12);
insert into casting values (933,2892,5);
insert into casting values (1279,2892,11);
insert into casting values (1306,2892,7);
insert into casting values (333,2892,10);
insert into casting values (1473,2893,11);
insert into casting values (300,2893,15);
insert into casting values (240,2893,7);
insert into casting values (508,2893,10);
insert into casting values (590,2893,3);
insert into casting values (732,2894,11);
insert into casting values (1466,2894,12);
insert into casting values (1755,2894,12);
insert into casting values (28,2894,8);
insert into casting values (63,2894,4);
insert into casting values (1334,2895,7);
insert into casting values (1676,2895,12);
--- tabcasting, 10501, 50
insert into casting values (144,2895,12);
insert into casting values (250,2895,6);
insert into casting values (220,2895,7);
insert into casting values (668,2895,14);
insert into casting values (1292,2896,6);
insert into casting values (1827,2896,5);
insert into casting values (1734,2896,12);
insert into casting values (240,2896,13);
insert into casting values (492,2896,12);
insert into casting values (894,2897,5);
insert into casting values (1055,2897,7);
insert into casting values (1263,2897,12);
insert into casting values (1795,2897,10);
insert into casting values (906,2898,10);
insert into casting values (1665,2898,5);
insert into casting values (266,2898,10);
insert into casting values (710,2898,7);
insert into casting values (998,2899,10);
insert into casting values (1117,2899,13);
insert into casting values (1654,2899,15);
insert into casting values (295,2899,8);
insert into casting values (629,2899,2);
insert into casting values (963,2900,4);
insert into casting values (1023,2900,9);
insert into casting values (1783,2900,12);
insert into casting values (1708,2900,12);
insert into casting values (149,2900,12);
insert into casting values (1637,2901,4);
insert into casting values (119,2901,10);
insert into casting values (38,2901,11);
insert into casting values (637,2901,12);
insert into casting values (559,2901,8);
insert into casting values (941,2902,5);
insert into casting values (992,2902,9);
insert into casting values (1228,2902,13);
insert into casting values (1676,2902,14);
insert into casting values (407,2902,15);
insert into casting values (1542,2903,4);
insert into casting values (1605,2903,13);
insert into casting values (362,2903,7);
insert into casting values (542,2903,13);
insert into casting values (1558,2904,7);
insert into casting values (1537,2904,12);
insert into casting values (1480,2904,8);
insert into casting values (238,2904,9);
insert into casting values (685,2904,10);
insert into casting values (1189,2905,5);
insert into casting values (121,2905,6);
insert into casting values (349,2905,13);
insert into casting values (410,2905,11);
--- tabcasting, 10551, 50
insert into casting values (1006,2906,7);
insert into casting values (246,2906,12);
insert into casting values (489,2906,4);
insert into casting values (373,2906,13);
insert into casting values (753,2907,13);
insert into casting values (767,2907,6);
insert into casting values (1037,2907,8);
insert into casting values (1606,2907,6);
insert into casting values (268,2907,14);
insert into casting values (1469,2908,8);
insert into casting values (1794,2908,10);
insert into casting values (1822,2908,5);
insert into casting values (319,2908,11);
insert into casting values (1253,2909,9);
insert into casting values (1722,2909,13);
insert into casting values (301,2909,15);
insert into casting values (1045,2910,12);
insert into casting values (1006,2910,12);
insert into casting values (1415,2910,7);
insert into casting values (1124,2910,3);
insert into casting values (828,2911,5);
insert into casting values (1370,2911,12);
insert into casting values (1831,2911,6);
insert into casting values (162,2911,15);
insert into casting values (912,2912,13);
insert into casting values (1217,2912,3);
insert into casting values (178,2912,13);
insert into casting values (100,2912,8);
insert into casting values (927,2913,7);
insert into casting values (1341,2913,14);
insert into casting values (1228,2913,6);
insert into casting values (1755,2913,14);
insert into casting values (625,2913,6);
insert into casting values (272,2914,9);
insert into casting values (527,2914,14);
insert into casting values (656,2914,3);
insert into casting values (470,2914,15);
insert into casting values (887,2915,13);
insert into casting values (63,2915,6);
insert into casting values (103,2915,5);
insert into casting values (725,2915,15);
insert into casting values (1100,2916,4);
insert into casting values (1149,2916,12);
insert into casting values (1742,2916,12);
insert into casting values (278,2916,9);
insert into casting values (1642,2917,11);
insert into casting values (1576,2917,7);
insert into casting values (443,2917,5);
insert into casting values (666,2917,15);
insert into casting values (814,2918,12);
--- tabcasting, 10601, 50
insert into casting values (1249,2918,7);
insert into casting values (1337,2918,10);
insert into casting values (1589,2918,9);
insert into casting values (1609,2918,6);
insert into casting values (741,2919,8);
insert into casting values (853,2919,11);
insert into casting values (181,2919,4);
insert into casting values (4,2919,10);
insert into casting values (886,2920,8);
insert into casting values (1412,2920,6);
insert into casting values (1122,2920,7);
insert into casting values (123,2920,11);
insert into casting values (688,2920,15);
insert into casting values (1022,2921,5);
insert into casting values (1070,2921,8);
insert into casting values (1148,2921,14);
insert into casting values (675,2921,12);
insert into casting values (909,2922,7);
insert into casting values (1494,2922,14);
insert into casting values (295,2922,14);
insert into casting values (495,2922,8);
insert into casting values (534,2922,8);
insert into casting values (1444,2923,5);
insert into casting values (1781,2923,13);
insert into casting values (56,2923,6);
insert into casting values (546,2923,10);
insert into casting values (750,2924,8);
insert into casting values (1811,2924,15);
insert into casting values (1672,2924,5);
insert into casting values (459,2924,11);
insert into casting values (1031,2925,5);
insert into casting values (279,2925,11);
insert into casting values (466,2925,10);
insert into casting values (1211,2926,7);
insert into casting values (1189,2926,15);
insert into casting values (1624,2926,7);
insert into casting values (195,2926,7);
insert into casting values (631,2926,14);
insert into casting values (903,2927,6);
insert into casting values (311,2927,5);
insert into casting values (369,2927,11);
insert into casting values (691,2927,12);
insert into casting values (1315,2928,12);
insert into casting values (20,2928,5);
insert into casting values (46,2928,8);
insert into casting values (650,2928,14);
insert into casting values (1440,2929,11);
insert into casting values (1537,2929,9);
insert into casting values (81,2929,10);
insert into casting values (381,2929,5);
--- tabcasting, 10651, 50
insert into casting values (1011,2930,13);
insert into casting values (1383,2930,8);
insert into casting values (1665,2930,6);
insert into casting values (136,2930,10);
insert into casting values (651,2930,9);
insert into casting values (973,2931,10);
insert into casting values (1502,2931,9);
insert into casting values (321,2931,4);
insert into casting values (557,2931,10);
insert into casting values (1088,2932,14);
insert into casting values (1214,2932,15);
insert into casting values (219,2932,8);
insert into casting values (302,2932,4);
insert into casting values (813,2933,9);
insert into casting values (793,2933,12);
insert into casting values (1008,2933,7);
insert into casting values (1791,2933,14);
insert into casting values (650,2933,6);
insert into casting values (1464,2934,3);
insert into casting values (1122,2934,12);
insert into casting values (1337,2934,8);
insert into casting values (1824,2934,10);
insert into casting values (962,2935,11);
insert into casting values (1066,2935,7);
insert into casting values (50,2935,2);
insert into casting values (834,2936,3);
insert into casting values (371,2936,9);
insert into casting values (483,2936,12);
insert into casting values (620,2936,11);
insert into casting values (127,2937,14);
insert into casting values (11,2937,6);
insert into casting values (573,2937,14);
insert into casting values (528,2937,3);
insert into casting values (1362,2938,13);
insert into casting values (1225,2938,11);
insert into casting values (1393,2938,7);
insert into casting values (206,2938,4);
insert into casting values (1241,2939,10);
insert into casting values (1692,2939,6);
insert into casting values (23,2939,5);
insert into casting values (725,2939,14);
insert into casting values (1151,2940,7);
insert into casting values (1300,2940,4);
insert into casting values (645,2940,13);
insert into casting values (1368,2941,3);
insert into casting values (274,2941,12);
insert into casting values (70,2941,9);
insert into casting values (180,2941,11);
insert into casting values (1027,2942,14);
insert into casting values (1278,2942,7);
--- tabcasting, 10701, 50
insert into casting values (1730,2942,7);
insert into casting values (162,2942,7);
insert into casting values (588,2942,15);
insert into casting values (760,2943,4);
insert into casting values (1644,2943,6);
insert into casting values (145,2943,13);
insert into casting values (156,2943,11);
insert into casting values (1553,2944,8);
insert into casting values (195,2944,5);
insert into casting values (136,2944,15);
insert into casting values (596,2944,12);
insert into casting values (1162,2945,11);
insert into casting values (154,2945,7);
insert into casting values (568,2945,6);
insert into casting values (621,2945,7);
insert into casting values (600,2945,11);
insert into casting values (809,2946,15);
insert into casting values (801,2946,12);
insert into casting values (1502,2946,7);
insert into casting values (822,2947,13);
insert into casting values (1034,2947,14);
insert into casting values (926,2947,7);
insert into casting values (451,2947,6);
insert into casting values (706,2947,8);
insert into casting values (1077,2948,15);
insert into casting values (1407,2948,12);
insert into casting values (1376,2948,8);
insert into casting values (610,2948,2);
insert into casting values (959,2949,7);
insert into casting values (1383,2949,15);
insert into casting values (266,2949,8);
insert into casting values (448,2949,9);
insert into casting values (446,2949,14);
insert into casting values (781,2950,4);
insert into casting values (818,2950,7);
insert into casting values (812,2950,11);
insert into casting values (476,2950,15);
insert into casting values (1026,2951,8);
insert into casting values (824,2951,6);
insert into casting values (1095,2951,12);
insert into casting values (1242,2951,9);
insert into casting values (1476,2951,14);
insert into casting values (1088,2952,7);
insert into casting values (1702,2952,8);
insert into casting values (239,2952,9);
insert into casting values (490,2952,11);
insert into casting values (554,2952,10);
insert into casting values (1428,2953,12);
insert into casting values (1489,2953,12);
insert into casting values (101,2953,8);
--- tabcasting, 10751, 50
insert into casting values (10,2953,5);
insert into casting values (1270,2954,7);
insert into casting values (1837,2954,3);
insert into casting values (1701,2954,10);
insert into casting values (1353,2955,4);
insert into casting values (1757,2955,9);
insert into casting values (672,2955,13);
insert into casting values (397,2955,14);
insert into casting values (837,2956,7);
insert into casting values (1487,2956,5);
insert into casting values (141,2956,10);
insert into casting values (1081,2957,3);
insert into casting values (1631,2957,11);
insert into casting values (159,2957,7);
insert into casting values (1187,2958,13);
insert into casting values (1601,2958,6);
insert into casting values (728,2958,4);
insert into casting values (757,2959,6);
insert into casting values (1520,2959,12);
insert into casting values (1673,2959,3);
insert into casting values (866,2960,8);
insert into casting values (1507,2960,9);
insert into casting values (62,2960,15);
insert into casting values (389,2960,6);
insert into casting values (980,2961,8);
insert into casting values (1039,2961,14);
insert into casting values (1795,2961,7);
insert into casting values (931,2962,9);
insert into casting values (1279,2962,4);
insert into casting values (1798,2962,15);
insert into casting values (816,2963,12);
insert into casting values (1778,2963,5);
insert into casting values (612,2963,8);
insert into casting values (1674,2964,10);
insert into casting values (1677,2964,2);
insert into casting values (311,2964,6);
insert into casting values (1456,2965,14);
insert into casting values (560,2965,9);
insert into casting values (710,2965,4);
insert into casting values (1035,2966,8);
insert into casting values (1162,2966,3);
insert into casting values (1201,2966,13);
insert into casting values (884,2967,11);
insert into casting values (1473,2967,2);
insert into casting values (445,2967,8);
insert into casting values (1180,2968,15);
insert into casting values (210,2968,6);
insert into casting values (214,2968,2);
insert into casting values (1133,2969,15);
insert into casting values (1407,2969,5);
--- tabcasting, 10801, 50
insert into casting values (1693,2969,8);
insert into casting values (1602,2970,3);
insert into casting values (203,2970,8);
insert into casting values (567,2970,12);
insert into casting values (1020,2971,4);
insert into casting values (245,2971,6);
insert into casting values (425,2971,11);
insert into casting values (1270,2972,5);
insert into casting values (26,2972,9);
insert into casting values (133,2972,15);
insert into casting values (1291,2973,8);
insert into casting values (1803,2973,8);
insert into casting values (324,2973,8);
insert into casting values (393,2973,13);
insert into casting values (769,2974,12);
insert into casting values (1071,2974,9);
insert into casting values (1274,2974,2);
insert into casting values (1093,2975,15);
insert into casting values (1102,2975,9);
insert into casting values (1774,2975,8);
insert into casting values (78,2975,9);
insert into casting values (1722,2976,10);
insert into casting values (730,2976,5);
insert into casting values (910,2977,12);
insert into casting values (794,2977,3);
insert into casting values (1742,2977,6);
insert into casting values (1084,2978,11);
insert into casting values (1279,2978,5);
insert into casting values (1663,2978,6);
insert into casting values (809,2979,10);
insert into casting values (1170,2979,8);
insert into casting values (1227,2979,3);
insert into casting values (871,2980,6);
insert into casting values (947,2980,11);
insert into casting values (1743,2980,2);
insert into casting values (1204,2981,4);
insert into casting values (33,2981,6);
insert into casting values (53,2981,13);
insert into casting values (1676,2982,11);
insert into casting values (1659,2982,6);
insert into casting values (581,2982,5);
insert into casting values (1023,2983,5);
insert into casting values (1165,2983,6);
insert into casting values (1109,2983,11);
insert into casting values (1373,2984,6);
insert into casting values (1485,2984,14);
insert into casting values (348,2984,3);
insert into casting values (1196,2985,7);
insert into casting values (1669,2985,6);
insert into casting values (205,2985,6);
--- tabcasting, 10851, 50
insert into casting values (375,2985,15);
insert into casting values (1310,2986,9);
insert into casting values (1755,2986,6);
insert into casting values (521,2986,10);
insert into casting values (377,2986,8);
insert into casting values (927,2987,5);
insert into casting values (1341,2987,12);
insert into casting values (1399,2987,7);
insert into casting values (1010,2988,5);
insert into casting values (1039,2988,7);
insert into casting values (301,2988,10);
insert into casting values (909,2989,6);
insert into casting values (499,2989,10);
insert into casting values (959,2990,6);
insert into casting values (196,2990,9);
insert into casting values (295,2990,11);
insert into casting values (758,2991,12);
insert into casting values (1025,2991,6);
insert into casting values (1690,2991,9);
insert into casting values (187,2991,7);
insert into casting values (1158,2992,8);
insert into casting values (1516,2992,4);
insert into casting values (444,2992,14);
insert into casting values (882,2993,15);
insert into casting values (1833,2993,4);
insert into casting values (1778,2993,7);
insert into casting values (1327,2994,4);
insert into casting values (38,2994,10);
insert into casting values (497,2994,6);
insert into casting values (926,2995,11);
insert into casting values (1341,2995,6);
insert into casting values (247,2995,9);
insert into casting values (598,2995,6);
insert into casting values (1347,2996,8);
insert into casting values (1834,2996,4);
insert into casting values (574,2996,10);
insert into casting values (1287,2997,7);
insert into casting values (259,2997,5);
insert into casting values (314,2997,13);
insert into casting values (889,2998,12);
insert into casting values (754,2998,6);
insert into casting values (1181,2998,5);
insert into casting values (1655,2999,3);
insert into casting values (1714,2999,14);
insert into casting values (105,2999,8);
insert into casting values (831,3000,13);
insert into casting values (1043,3000,4);
insert into casting values (1244,3000,9);
insert into casting values (918,3001,12);
insert into casting values (1203,3001,6);
--- tabcasting, 10901, 50
insert into casting values (175,3001,3);
insert into casting values (1625,3002,5);
insert into casting values (1635,3002,9);
insert into casting values (401,3002,12);
insert into casting values (1540,3003,11);
insert into casting values (33,3003,4);
insert into casting values (193,3003,9);
insert into casting values (1578,3004,2);
insert into casting values (345,3004,12);
insert into casting values (208,3004,7);
insert into casting values (945,3005,10);
insert into casting values (1379,3005,4);
insert into casting values (1799,3005,6);
insert into casting values (1232,3006,8);
insert into casting values (146,3006,14);
insert into casting values (57,3006,6);
insert into casting values (116,3006,8);
insert into casting values (822,3007,10);
insert into casting values (1449,3007,4);
insert into casting values (627,3007,7);
insert into casting values (860,3008,14);
insert into casting values (1192,3008,6);
insert into casting values (417,3008,4);
insert into casting values (949,3009,5);
insert into casting values (1022,3009,14);
insert into casting values (1148,3009,8);
insert into casting values (998,3010,5);
insert into casting values (549,3010,6);
insert into casting values (598,3010,10);
insert into casting values (1638,3011,15);
insert into casting values (1640,3011,2);
insert into casting values (525,3011,9);
insert into casting values (1371,3012,5);
insert into casting values (137,3012,15);
insert into casting values (432,3012,9);
insert into casting values (844,3013,6);
insert into casting values (1259,3013,15);
insert into casting values (640,3013,5);
insert into casting values (1015,3014,9);
insert into casting values (1712,3014,6);
insert into casting values (210,3014,14);
insert into casting values (433,3014,8);
insert into casting values (851,3015,7);
insert into casting values (1190,3015,7);
insert into casting values (1707,3015,10);
insert into casting values (242,3015,8);
insert into casting values (1060,3016,2);
insert into casting values (1605,3016,7);
insert into casting values (542,3016,12);
insert into casting values (1611,3017,10);
--- tabcasting, 10951, 50
insert into casting values (22,3017,6);
insert into casting values (62,3017,8);
insert into casting values (382,3017,9);
insert into casting values (909,3018,3);
insert into casting values (998,3018,6);
insert into casting values (3,3018,15);
insert into casting values (967,3019,11);
insert into casting values (1113,3019,8);
insert into casting values (1837,3019,7);
insert into casting values (106,3019,7);
insert into casting values (941,3020,9);
insert into casting values (1628,3020,6);
insert into casting values (161,3020,7);
insert into casting values (382,3020,14);
insert into casting values (928,3021,3);
insert into casting values (1778,3021,13);
insert into casting values (1728,3021,7);
insert into casting values (918,3022,6);
insert into casting values (732,3022,34);
insert into casting values (183,3022,5);
insert into casting values (711,3022,11);
insert into casting values (1104,3023,5);
insert into casting values (1661,3023,14);
insert into casting values (120,3023,9);
insert into casting values (855,3024,10);
insert into casting values (272,3024,8);
insert into casting values (656,3024,4);
insert into casting values (1456,3025,7);
insert into casting values (1549,3025,13);
insert into casting values (138,3025,7);
insert into casting values (585,3025,8);
insert into casting values (1276,3026,9);
insert into casting values (327,3026,10);
insert into casting values (423,3026,5);
insert into casting values (930,3027,10);
insert into casting values (1502,3027,6);
insert into casting values (1598,3027,6);
insert into casting values (538,3027,9);
insert into casting values (894,3028,8);
insert into casting values (828,3028,9);
insert into casting values (140,3028,13);
insert into casting values (494,3028,6);
insert into casting values (1372,3029,4);
insert into casting values (384,3029,8);
insert into casting values (418,3029,12);
insert into casting values (1534,3030,2);
insert into casting values (113,3030,8);
insert into casting values (503,3030,10);
insert into casting values (937,3031,5);
insert into casting values (155,3031,8);
--- tabcasting, 11001, 50
insert into casting values (483,3031,10);
insert into casting values (1571,3032,7);
insert into casting values (1033,3033,9);
insert into casting values (1172,3033,10);
insert into casting values (1502,3033,4);
insert into casting values (1133,3034,7);
insert into casting values (259,3034,13);
insert into casting values (487,3034,6);
insert into casting values (1788,3035,8);
insert into casting values (517,3035,5);
insert into casting values (593,3035,15);
insert into casting values (104,3036,12);
insert into casting values (670,3036,9);
insert into casting values (622,3036,2);
insert into casting values (1561,3037,2);
insert into casting values (138,3037,14);
insert into casting values (285,3037,9);
insert into casting values (1843,3038,2);
insert into casting values (1611,3038,11);
insert into casting values (122,3038,6);
insert into casting values (1248,3039,6);
insert into casting values (478,3039,10);
insert into casting values (715,3039,4);
insert into casting values (1142,3040,5);
insert into casting values (380,3040,7);
insert into casting values (444,3040,11);
insert into casting values (877,3041,8);
insert into casting values (1077,3041,8);
insert into casting values (1547,3041,9);
insert into casting values (705,3041,12);
insert into casting values (935,3042,12);
insert into casting values (1021,3042,4);
insert into casting values (1332,3042,8);
insert into casting values (1205,3043,7);
insert into casting values (137,3043,10);
insert into casting values (419,3043,2);
insert into casting values (1543,3044,3);
insert into casting values (79,3044,12);
insert into casting values (647,3044,7);
insert into casting values (849,3045,3);
insert into casting values (243,3045,6);
insert into casting values (42,3045,10);
insert into casting values (976,3046,4);
insert into casting values (1328,3046,16);
insert into casting values (398,3046,8);
insert into casting values (1344,3047,14);
insert into casting values (1249,3047,8);
insert into casting values (1589,3047,5);
insert into casting values (293,3048,5);
insert into casting values (169,3048,8);
--- tabcasting, 11051, 50
insert into casting values (375,3048,11);
insert into casting values (349,3049,8);
insert into casting values (402,3049,12);
insert into casting values (438,3049,7);
insert into casting values (410,3049,9);
insert into casting values (1277,3050,3);
insert into casting values (1775,3050,14);
insert into casting values (1844,3050,6);
insert into casting values (862,3051,4);
insert into casting values (1576,3051,9);
insert into casting values (428,3051,14);
insert into casting values (358,3052,4);
insert into casting values (556,3052,6);
insert into casting values (386,3052,12);
insert into casting values (925,3053,8);
insert into casting values (1093,3053,7);
insert into casting values (771,3053,13);
insert into casting values (1390,3053,7);
insert into casting values (822,3054,11);
insert into casting values (1449,3054,5);
insert into casting values (1188,3054,9);
insert into casting values (1065,3055,15);
insert into casting values (578,3055,6);
insert into casting values (421,3055,5);
insert into casting values (243,3056,9);
insert into casting values (581,3056,4);
insert into casting values (710,3056,11);
insert into casting values (1356,3057,6);
insert into casting values (1525,3057,3);
insert into casting values (489,3057,12);
insert into casting values (891,3058,9);
insert into casting values (1342,3058,11);
insert into casting values (1798,3058,5);
insert into casting values (1319,3059,7);
insert into casting values (1489,3059,3);
insert into casting values (8,3059,15);
insert into casting values (1693,3060,6);
insert into casting values (318,3060,7);
insert into casting values (581,3060,15);
insert into casting values (680,3060,9);
insert into casting values (1124,3061,2);
insert into casting values (1456,3061,11);
insert into casting values (1573,3061,9);
insert into casting values (481,3062,7);
insert into casting values (546,3062,4);
insert into casting values (514,3062,10);
insert into casting values (944,3063,8);
insert into casting values (959,3063,8);
insert into casting values (1056,3063,6);
insert into casting values (1507,3063,14);
--- tabcasting, 11101, 50
insert into casting values (101,3064,13);
insert into casting values (424,3064,8);
insert into casting values (628,3064,2);
insert into casting values (1734,3065,5);
insert into casting values (167,3065,6);
insert into casting values (162,3065,10);
insert into casting values (1300,3066,12);
insert into casting values (1681,3066,3);
insert into casting values (25,3066,9);
insert into casting values (1737,3067,3);
insert into casting values (1612,3067,9);
insert into casting values (286,3067,10);
insert into casting values (1037,3068,9);
insert into casting values (964,3068,14);
insert into casting values (1606,3068,7);
insert into casting values (1534,3068,8);
insert into casting values (1436,3069,9);
insert into casting values (216,3069,4);
insert into casting values (718,3069,13);
insert into casting values (32,3070,12);
insert into casting values (278,3070,4);
insert into casting values (304,3070,7);
insert into casting values (148,3071,11);
insert into casting values (177,3071,4);
insert into casting values (546,3071,7);
insert into casting values (136,3072,8);
insert into casting values (385,3072,12);
insert into casting values (492,3072,2);
insert into casting values (1184,3073,3);
insert into casting values (1761,3073,15);
insert into casting values (206,3073,9);
insert into casting values (1798,3074,7);
insert into casting values (143,3074,5);
insert into casting values (132,3074,11);
insert into casting values (1279,3075,10);
insert into casting values (1791,3075,6);
insert into casting values (717,3075,3);
insert into casting values (1827,3076,8);
insert into casting values (325,3076,4);
insert into casting values (634,3076,10);
insert into casting values (933,3077,2);
insert into casting values (884,3077,7);
insert into casting values (1204,3077,15);
insert into casting values (1624,3078,8);
insert into casting values (1711,3078,5);
insert into casting values (195,3078,15);
insert into casting values (1051,3079,6);
insert into casting values (1750,3079,6);
insert into casting values (251,3079,6);
insert into casting values (89,3079,13);
--- tabcasting, 11151, 50
insert into casting values (1706,3080,15);
insert into casting values (112,3080,5);
insert into casting values (482,3080,7);
insert into casting values (1757,3081,11);
insert into casting values (548,3081,7);
insert into casting values (366,3081,2);
insert into casting values (1686,3082,4);
insert into casting values (212,3082,9);
insert into casting values (1068,3083,5);
insert into casting values (317,3083,8);
insert into casting values (1261,3084,3);
insert into casting values (1329,3084,6);
insert into casting values (1342,3085,8);
insert into casting values (1728,3085,5);
insert into casting values (1475,3086,8);
insert into casting values (187,3086,9);
insert into casting values (452,3086,8);
insert into casting values (984,3087,7);
insert into casting values (102,3087,7);
insert into casting values (75,3087,8);
insert into casting values (1837,3088,4);
insert into casting values (309,3088,9);
insert into casting values (1703,3089,4);
insert into casting values (384,3089,7);
insert into casting values (1332,3090,3);
insert into casting values (229,3090,9);
insert into casting values (1393,3091,3);
insert into casting values (1561,3091,6);
insert into casting values (1090,3092,3);
insert into casting values (1781,3092,8);
insert into casting values (817,3093,9);
insert into casting values (1498,3093,7);
insert into casting values (193,3094,5);
insert into casting values (422,3094,9);
insert into casting values (1074,3095,7);
insert into casting values (1226,3095,4);
insert into casting values (1144,3096,6);
insert into casting values (1712,3096,2);
insert into casting values (732,3097,2);
insert into casting values (57,3097,14);
insert into casting values (183,3097,12);
insert into casting values (506,3097,11);
insert into casting values (463,3097,12);
insert into casting values (989,3098,6);
insert into casting values (1646,3098,3);
insert into casting values (989,3099,7);
insert into casting values (1396,3099,3);
insert into casting values (1395,3100,4);
insert into casting values (125,3100,6);
insert into casting values (924,3101,5);
--- tabcasting, 11201, 50
insert into casting values (1398,3101,6);
insert into casting values (1698,3102,5);
insert into casting values (238,3102,7);
insert into casting values (945,3103,8);
insert into casting values (306,3103,2);
insert into casting values (855,3104,8);
insert into casting values (335,3104,3);
insert into casting values (1673,3105,5);
insert into casting values (439,3105,7);
insert into casting values (164,3106,5);
insert into casting values (89,3106,7);
insert into casting values (473,3107,6);
insert into casting values (504,3107,3);
insert into casting values (454,3108,9);
insert into casting values (676,3108,2);
insert into casting values (980,3109,5);
insert into casting values (1464,3109,7);
insert into casting values (1241,3110,7);
insert into casting values (211,3110,5);
insert into casting values (1705,3111,6);
insert into casting values (27,3111,3);
insert into casting values (341,3112,7);
insert into casting values (682,3112,5);
insert into casting values (1389,3113,5);
insert into casting values (1617,3113,8);
insert into casting values (1493,3114,2);
insert into casting values (702,3114,7);
insert into casting values (1032,3115,9);
insert into casting values (167,3115,9);
insert into casting values (17,3115,8);
insert into casting values (809,3116,9);
insert into casting values (240,3116,4);
insert into casting values (931,3117,3);
insert into casting values (698,3117,6);
insert into casting values (1309,3118,3);
insert into casting values (1154,3118,9);
insert into casting values (57,3119,4);
insert into casting values (116,3119,6);
insert into casting values (958,3120,7);
insert into casting values (1246,3120,5);
insert into casting values (1803,3121,6);
insert into casting values (378,3121,4);
insert into casting values (1353,3122,8);
insert into casting values (682,3122,4);
insert into casting values (1168,3123,3);
insert into casting values (689,3123,6);
insert into casting values (778,3124,4);
insert into casting values (72,3124,8);
insert into casting values (1118,3125,7);
insert into casting values (309,3125,3);
--- tabcasting, 11251, 50
insert into casting values (896,3126,9);
insert into casting values (518,3126,2);
insert into casting values (1729,3127,5);
insert into casting values (683,3127,9);
insert into casting values (1451,3128,9);
insert into casting values (526,3128,5);
insert into casting values (991,3129,4);
insert into casting values (1758,3129,8);
insert into casting values (1583,3130,6);
insert into casting values (418,3130,2);
insert into casting values (1160,3131,4);
insert into casting values (314,3131,6);
insert into casting values (1193,3132,3);
insert into casting values (474,3132,6);
insert into casting values (1672,3133,4);
insert into casting values (649,3133,8);
insert into casting values (1357,3134,9);
insert into casting values (1512,3134,4);
insert into casting values (1228,3135,4);
insert into casting values (585,3135,7);
insert into casting values (1184,3136,7);
insert into casting values (169,3136,4);
insert into casting values (715,3137,8);
insert into casting values (589,3137,2);
insert into casting values (1189,3138,8);
insert into casting values (376,3138,5);
insert into casting values (1074,3139,5);
insert into casting values (1189,3139,6);
insert into casting values (1029,3140,4);
insert into casting values (1189,3140,9);
insert into casting values (982,3141,9);
insert into casting values (966,3141,7);
insert into casting values (1369,3141,24);
insert into casting values (1768,3141,7);
insert into casting values (1462,3142,3);
insert into casting values (988,3143,6);
insert into casting values (66,3143,2);
insert into casting values (1136,3144,9);
insert into casting values (158,3144,4);
insert into casting values (941,3145,8);
insert into casting values (1031,3145,2);
insert into casting values (1793,3146,5);
insert into casting values (310,3146,7);
insert into casting values (859,3147,5);
insert into casting values (1201,3147,9);
insert into casting values (350,3148,2);
insert into casting values (459,3148,9);
insert into casting values (1188,3149,5);
insert into casting values (10,3149,9);
insert into casting values (746,3150,9);
--- tabcasting, 11301, 50
insert into casting values (765,3150,4);
insert into casting values (801,3151,14);
insert into casting values (1419,3151,11);
insert into casting values (1589,3151,12);
insert into casting values (1504,3151,10);
insert into casting values (1609,3151,14);
insert into casting values (1692,3151,4);
insert into casting values (1385,3152,9);
insert into casting values (269,3152,4);
insert into casting values (1478,3153,4);
insert into casting values (541,3153,7);
insert into casting values (68,3154,6);
insert into casting values (252,3154,6);
insert into casting values (280,3154,6);
insert into casting values (337,3155,8);
insert into casting values (578,3155,4);
insert into casting values (1673,3156,6);
insert into casting values (99,3156,5);
insert into casting values (1181,3157,4);
insert into casting values (1467,3157,8);
insert into casting values (1714,3158,9);
insert into casting values (690,3158,5);
insert into casting values (1818,3159,3);
insert into casting values (1082,3160,3);
insert into casting values (950,3161,4);
insert into casting values (455,3161,7);
insert into casting values (841,3162,5);
insert into casting values (115,3162,7);
insert into casting values (1493,3163,8);
insert into casting values (713,3163,5);
insert into casting values (1296,3164,4);
insert into casting values (170,3164,7);
insert into casting values (340,3165,7);
insert into casting values (299,3165,5);
insert into casting values (1384,3166,7);
insert into casting values (1511,3166,8);
insert into casting values (179,3166,8);
insert into casting values (1017,3167,5);
insert into casting values (256,3167,8);
insert into casting values (1547,3168,6);
insert into casting values (81,3168,5);
insert into casting values (1047,3169,8);
insert into casting values (1625,3169,4);
insert into casting values (1264,3170,3);
insert into casting values (1489,3170,8);
insert into casting values (1422,3171,6);
insert into casting values (360,3171,3);
insert into casting values (937,3172,4);
insert into casting values (443,3172,8);
insert into casting values (1208,3173,9);
--- tabcasting, 11351, 50
insert into casting values (154,3173,4);
insert into casting values (1133,3174,4);
insert into casting values (636,3174,9);
insert into casting values (1714,3175,2);
insert into casting values (211,3175,9);
insert into casting values (1472,3176,6);
insert into casting values (718,3176,4);
insert into casting values (765,3177,6);
insert into casting values (1189,3177,3);
insert into casting values (13,3178,6);
insert into casting values (1,3178,8);
insert into casting values (5,3178,7);
insert into casting values (276,3179,6);
insert into casting values (711,3179,5);
insert into casting values (1386,3180,6);
insert into casting values (1472,3180,7);
insert into casting values (718,3180,9);
insert into casting values (1696,3181,4);
insert into casting values (551,3181,6);
insert into casting values (1289,3182,8);
insert into casting values (1775,3182,3);
insert into casting values (1570,3183,3);
insert into casting values (1753,3183,7);
insert into casting values (1460,3184,9);
insert into casting values (661,3184,5);
insert into casting values (1714,3185,6);
insert into casting values (1532,3186,5);
insert into casting values (138,3186,8);
insert into casting values (1727,3187,4);
insert into casting values (1542,3187,9);
insert into casting values (1689,3188,6);
insert into casting values (200,3188,2);
insert into casting values (1119,3189,5);
insert into casting values (352,3189,7);
insert into casting values (765,3190,8);
insert into casting values (87,3190,5);
insert into casting values (1207,3191,5);
insert into casting values (109,3191,6);
insert into casting values (803,3192,9);
insert into casting values (1623,3192,5);
insert into casting values (1625,3193,8);
insert into casting values (1804,3193,5);
insert into casting values (1541,3194,6);
insert into casting values (665,3194,2);
insert into casting values (864,3195,4);
insert into casting values (896,3195,6);
insert into casting values (792,3196,6);
insert into casting values (1171,3196,6);
insert into casting values (622,3196,6);
insert into casting values (839,3197,8);
--- tabcasting, 11401, 50
insert into casting values (1239,3197,13);
insert into casting values (1160,3197,11);
insert into casting values (492,3197,7);
insert into casting values (536,3197,14);
insert into casting values (427,3197,14);
insert into casting values (878,3198,6);
insert into casting values (1350,3198,2);
insert into casting values (336,3199,6);
insert into casting values (354,3199,3);
insert into casting values (919,3200,5);
insert into casting values (1272,3200,8);
insert into casting values (807,3201,9);
insert into casting values (1268,3202,7);
insert into casting values (385,3202,4);
insert into casting values (760,3203,8);
insert into casting values (1236,3203,3);
insert into casting values (834,3204,4);
insert into casting values (1291,3204,7);
insert into casting values (1369,3205,9);
insert into casting values (326,3205,5);
insert into casting values (852,3206,6);
insert into casting values (1553,3206,6);
insert into casting values (157,3206,8);
insert into casting values (1081,3207,7);
insert into casting values (1818,3207,5);
insert into casting values (1806,3208,7);
insert into casting values (152,3208,5);
insert into casting values (1023,3209,4);
insert into casting values (1698,3209,7);
insert into casting values (813,3210,6);
insert into casting values (258,3210,9);
insert into casting values (521,3210,7);
insert into casting values (1648,3211,6);
insert into casting values (1627,3211,5);
insert into casting values (821,3212,4);
insert into casting values (887,3212,6);
insert into casting values (1699,3213,6);
insert into casting values (105,3213,5);
insert into casting values (101,3214,9);
insert into casting values (387,3214,4);
insert into casting values (1237,3215,7);
insert into casting values (49,3215,8);
insert into casting values (422,3215,7);
insert into casting values (1179,3216,7);
insert into casting values (1498,3216,9);
insert into casting values (1696,3216,7);
insert into casting values (977,3217,7);
insert into casting values (1539,3217,3);
insert into casting values (1519,3218,3);
insert into casting values (277,3219,4);
--- tabcasting, 11451, 50
insert into casting values (101,3219,6);
insert into casting values (1335,3220,7);
insert into casting values (210,3220,4);
insert into casting values (972,3221,5);
insert into casting values (1835,3221,6);
insert into casting values (1161,3222,8);
insert into casting values (1476,3222,5);
insert into casting values (553,3223,4);
insert into casting values (367,3223,8);
insert into casting values (4,3224,5);
insert into casting values (118,3224,7);
insert into casting values (1600,3225,8);
insert into casting values (508,3225,3);
insert into casting values (1841,3226,8);
insert into casting values (666,3226,3);
insert into casting values (1730,3227,3);
insert into casting values (99,3227,7);
insert into casting values (1435,3228,6);
insert into casting values (222,3228,4);
insert into casting values (1610,3229,7);
insert into casting values (1512,3229,2);
insert into casting values (855,3230,3);
insert into casting values (164,3230,7);
insert into casting values (906,3231,2);
insert into casting values (352,3231,9);
insert into casting values (1689,3232,8);
insert into casting values (256,3232,5);
insert into casting values (646,3233,7);
insert into casting values (464,3233,4);
insert into casting values (1,3234,4);
insert into casting values (633,3234,6);
insert into casting values (1758,3235,3);
insert into casting values (427,3235,6);
insert into casting values (967,3236,9);
insert into casting values (1781,3236,4);
insert into casting values (1529,3237,4);
insert into casting values (39,3237,7);
insert into casting values (153,3238,7);
insert into casting values (1707,3239,3);
insert into casting values (371,3239,6);
insert into casting values (900,3240,13);
insert into casting values (1324,3240,9);
insert into casting values (1289,3240,13);
insert into casting values (1686,3240,15);
insert into casting values (1627,3240,13);
insert into casting values (1718,3240,11);
insert into casting values (122,3240,8);
insert into casting values (1418,3241,2);
insert into casting values (1571,3241,6);
insert into casting values (841,3242,8);
--- tabcasting, 11501, 50
insert into casting values (436,3242,4);
insert into casting values (1190,3243,6);
insert into casting values (161,3243,9);
insert into casting values (636,3243,8);
insert into casting values (299,3244,4);
insert into casting values (41,3244,6);
insert into casting values (1025,3245,9);
insert into casting values (611,3245,5);
insert into casting values (17,3246,4);
insert into casting values (1248,3247,2);
insert into casting values (522,3247,7);
insert into casting values (813,3248,7);
insert into casting values (1574,3248,3);
insert into casting values (883,3249,9);
insert into casting values (1586,3249,5);
insert into casting values (1081,3250,5);
insert into casting values (1707,3250,6);
insert into casting values (956,3251,2);
insert into casting values (1285,3251,6);
insert into casting values (37,3252,6);
insert into casting values (726,3252,5);
insert into casting values (32,3253,8);
insert into casting values (702,3253,4);
insert into casting values (1059,3254,3);
insert into casting values (112,3254,9);
insert into casting values (1139,3255,3);
insert into casting values (1511,3255,6);
insert into casting values (743,3256,9);
insert into casting values (953,3256,8);
insert into casting values (1400,3256,8);
insert into casting values (1560,3257,4);
insert into casting values (525,3257,7);
insert into casting values (479,3258,6);
insert into casting values (681,3258,5);
insert into casting values (979,3259,8);
insert into casting values (1091,3259,5);
insert into casting values (799,3260,2);
insert into casting values (455,3260,8);
insert into casting values (1447,3261,4);
insert into casting values (11,3261,9);
insert into casting values (280,3262,7);
insert into casting values (252,3262,7);
insert into casting values (68,3262,7);
insert into casting values (916,3263,6);
insert into casting values (986,3263,9);
insert into casting values (1011,3263,8);
insert into casting values (869,3264,8);
insert into casting values (1100,3264,8);
insert into casting values (78,3264,6);
insert into casting values (1197,3265,7);
--- tabcasting, 11551, 50
insert into casting values (1681,3265,5);
insert into casting values (835,3266,5);
insert into casting values (1780,3266,7);
insert into casting values (1315,3267,7);
insert into casting values (1538,3267,4);
insert into casting values (121,3268,5);
insert into casting values (416,3268,7);
insert into casting values (1470,3269,3);
insert into casting values (611,3269,8);
insert into casting values (766,3270,6);
insert into casting values (725,3270,2);
insert into casting values (770,3271,6);
insert into casting values (1506,3271,8);
insert into casting values (722,3271,8);
insert into casting values (1825,3272,5);
insert into casting values (614,3272,7);
insert into casting values (211,3273,8);
insert into casting values (504,3273,4);
insert into casting values (260,3274,9);
insert into casting values (103,3274,8);
insert into casting values (723,3274,7);
insert into casting values (925,3275,6);
insert into casting values (521,3275,5);
insert into casting values (1046,3276,5);
insert into casting values (170,3276,6);
insert into casting values (1358,3277,8);
insert into casting values (1333,3277,4);
insert into casting values (1521,3278,8);
insert into casting values (631,3278,5);
insert into casting values (773,3279,2);
insert into casting values (624,3279,6);
insert into casting values (1103,3280,3);
insert into casting values (1818,3280,7);
insert into casting values (283,3281,6);
insert into casting values (564,3281,3);
insert into casting values (1496,3282,3);
insert into casting values (1542,3282,6);
insert into casting values (1109,3283,8);
insert into casting values (608,3283,2);
insert into casting values (1069,3284,6);
insert into casting values (1641,3284,4);
insert into casting values (1036,3285,2);
insert into casting values (83,3285,7);
insert into casting values (1146,3286,3);
insert into casting values (1842,3286,8);
insert into casting values (1468,3287,2);
insert into casting values (853,3288,6);
insert into casting values (1720,3288,7);
insert into casting values (440,3288,8);
insert into casting values (970,3289,7);
--- tabcasting, 11601, 50
insert into casting values (1534,3289,3);
insert into casting values (156,3290,5);
insert into casting values (145,3290,7);
insert into casting values (1008,3291,6);
insert into casting values (1320,3291,5);
insert into casting values (1362,3292,5);
insert into casting values (390,3293,7);
insert into casting values (416,3293,4);
insert into casting values (751,3294,8);
insert into casting values (1355,3294,9);
insert into casting values (1629,3294,7);
insert into casting values (1796,3295,3);
insert into casting values (731,3295,7);
insert into casting values (1521,3296,9);
insert into casting values (631,3296,8);
insert into casting values (1213,3297,5);
insert into casting values (1361,3297,9);
insert into casting values (970,3298,6);
insert into casting values (1294,3298,6);
insert into casting values (69,3298,6);
insert into casting values (1061,3299,7);
insert into casting values (1338,3299,4);
insert into casting values (1430,3300,2);
insert into casting values (219,3300,6);
insert into casting values (1700,3301,9);
insert into casting values (63,3301,5);
insert into casting values (1347,3302,4);
insert into casting values (1670,3302,8);
insert into casting values (293,3303,7);
insert into casting values (37,3303,8);
insert into casting values (537,3303,7);
insert into casting values (1424,3304,6);
insert into casting values (1817,3304,5);
insert into casting values (967,3305,8);
insert into casting values (1424,3305,8);
insert into casting values (197,3305,9);
insert into casting values (941,3306,3);
insert into casting values (1609,3307,5);
insert into casting values (41,3307,8);
insert into casting values (1175,3308,7);
insert into casting values (346,3308,4);
insert into casting values (1408,3309,3);
insert into casting values (558,3309,9);
insert into casting values (1505,3310,7);
insert into casting values (329,3310,4);
insert into casting values (979,3311,5);
insert into casting values (1769,3311,6);
insert into casting values (1738,3312,4);
insert into casting values (515,3312,7);
insert into casting values (907,3313,3);
--- tabcasting, 11651, 50
insert into casting values (1700,3313,7);
insert into casting values (1142,3314,2);
insert into casting values (1323,3314,9);
insert into casting values (855,3315,4);
insert into casting values (564,3315,7);
insert into casting values (559,3316,5);
insert into casting values (472,3316,9);
insert into casting values (1634,3317,8);
insert into casting values (314,3317,4);
insert into casting values (782,3318,7);
insert into casting values (1710,3318,3);
insert into casting values (1586,3319,6);
insert into casting values (1275,3320,2);
insert into casting values (1138,3320,8);
insert into casting values (1633,3321,5);
insert into casting values (316,3321,6);
insert into casting values (360,3322,4);
insert into casting values (474,3322,8);
insert into casting values (1443,3323,6);
insert into casting values (1554,3323,3);
insert into casting values (1314,3324,7);
insert into casting values (1654,3324,3);
insert into casting values (845,3325,6);
insert into casting values (1784,3325,4);
insert into casting values (902,3326,6);
insert into casting values (222,3326,2);
insert into casting values (949,3327,9);
insert into casting values (955,3327,7);
insert into casting values (1070,3327,6);
insert into casting values (1260,3328,4);
insert into casting values (1587,3328,7);
insert into casting values (822,3329,5);
insert into casting values (30,3329,6);
insert into casting values (1153,3330,8);
insert into casting values (515,3330,3);
insert into casting values (1777,3331,3);
insert into casting values (1594,3331,9);
insert into casting values (1394,3332,7);
insert into casting values (1491,3332,5);
insert into casting values (750,3333,6);
insert into casting values (275,3333,4);
insert into casting values (1505,3334,5);
insert into casting values (1777,3334,9);
insert into casting values (1050,3335,6);
insert into casting values (1734,3335,3);
insert into casting values (1490,3336,7);
insert into casting values (519,3336,5);
insert into casting values (754,3337,5);
insert into casting values (1154,3337,8);
insert into casting values (1005,3338,4);
--- tabcasting, 11701, 50
insert into casting values (1135,3338,9);
insert into casting values (1569,3339,2);
insert into casting values (712,3339,7);
insert into casting values (1204,3340,7);
insert into casting values (1361,3340,3);
insert into casting values (172,3341,8);
insert into casting values (494,3341,5);
insert into casting values (128,3342,4);
insert into casting values (680,3342,6);
insert into casting values (1013,3343,3);
insert into casting values (1314,3343,8);
insert into casting values (1765,3344,4);
insert into casting values (61,3344,7);
insert into casting values (646,3345,4);
insert into casting values (555,3345,7);
insert into casting values (1271,3346,8);
insert into casting values (1712,3346,4);
insert into casting values (222,3347,8);
insert into casting values (326,3347,4);
insert into casting values (940,3348,9);
insert into casting values (1664,3348,7);
insert into casting values (389,3348,7);
insert into casting values (1043,3349,3);
insert into casting values (1024,3349,7);
insert into casting values (1617,3350,4);
insert into casting values (197,3350,7);
insert into casting values (1317,3351,5);
insert into casting values (507,3351,9);
insert into casting values (1829,3352,5);
insert into casting values (328,3352,7);
insert into casting values (1263,3353,9);
insert into casting values (1633,3353,9);
insert into casting values (379,3353,6);
insert into casting values (806,3354,9);
insert into casting values (158,3354,3);
insert into casting values (836,3355,5);
insert into casting values (204,3355,7);
insert into casting values (1056,3356,2);
insert into casting values (1340,3356,8);
insert into casting values (1806,3357,4);
insert into casting values (172,3357,9);
insert into casting values (1740,3358,3);
insert into casting values (1565,3358,8);
insert into casting values (1365,3359,9);
insert into casting values (363,3359,5);
insert into casting values (1098,3360,9);
insert into casting values (933,3361,9);
insert into casting values (1281,3361,6);
insert into casting values (430,3361,9);
insert into casting values (1545,3362,3);
--- tabcasting, 11751, 50
insert into casting values (3,3362,7);
insert into casting values (156,3363,9);
insert into casting values (378,3363,3);
insert into casting values (744,3364,4);
insert into casting values (1585,3364,8);
insert into casting values (1206,3365,7);
insert into casting values (1722,3365,8);
insert into casting values (353,3365,6);
insert into casting values (966,3366,8);
insert into casting values (555,3366,5);
insert into casting values (788,3367,7);
insert into casting values (1557,3367,6);
insert into casting values (353,3367,9);
insert into casting values (952,3368,9);
insert into casting values (1581,3369,8);
insert into casting values (1576,3369,3);
insert into casting values (207,3370,9);
insert into casting values (584,3370,5);
insert into casting values (1506,3371,9);
insert into casting values (167,3371,2);
insert into casting values (39,3372,8);
insert into casting values (499,3372,4);
insert into casting values (769,3373,7);
insert into casting values (289,3373,8);
insert into casting values (533,3373,8);
insert into casting values (1113,3374,5);
insert into casting values (676,3374,7);
insert into casting values (1544,3375,3);
insert into casting values (621,3375,6);
insert into casting values (1289,3376,7);
insert into casting values (534,3376,4);
insert into casting values (1819,3377,9);
insert into casting values (143,3377,2);
insert into casting values (1585,3378,3);
insert into casting values (188,3378,9);
insert into casting values (14,3379,9);
insert into casting values (63,3379,7);
insert into casting values (518,3379,7);
insert into casting values (1122,3380,6);
insert into casting values (1171,3380,3);
insert into casting values (835,3381,3);
insert into casting values (89,3381,9);
insert into casting values (816,3382,11);
insert into casting values (1672,3382,8);
insert into casting values (1676,3382,13);
insert into casting values (1657,3382,8);
insert into casting values (210,3382,11);
insert into casting values (90,3382,14);
insert into casting values (909,3383,5);
insert into casting values (1153,3383,13);
--- tabcasting, 11801, 50
insert into casting values (1216,3383,10);
insert into casting values (1844,3383,14);
insert into casting values (127,3383,15);
insert into casting values (824,3384,5);
insert into casting values (1242,3384,10);
insert into casting values (1495,3384,10);
insert into casting values (1588,3384,14);
insert into casting values (1529,3384,10);
insert into casting values (821,3385,8);
insert into casting values (1506,3385,10);
insert into casting values (1736,3385,15);
insert into casting values (278,3385,7);
insert into casting values (622,3385,10);
insert into casting values (737,3386,12);
insert into casting values (949,3386,14);
insert into casting values (1148,3386,12);
insert into casting values (85,3386,9);
insert into casting values (514,3386,8);
insert into casting values (675,3386,14);
insert into casting values (1095,3387,10);
insert into casting values (937,3387,6);
insert into casting values (1188,3387,12);
insert into casting values (1584,3387,12);
insert into casting values (1600,3387,9);
insert into casting values (684,3387,12);
insert into casting values (1385,3388,8);
insert into casting values (1510,3388,9);
insert into casting values (127,3388,13);
insert into casting values (631,3388,15);
insert into casting values (530,3388,12);
insert into casting values (858,3389,7);
insert into casting values (1754,3389,13);
insert into casting values (144,3389,14);
insert into casting values (118,3389,8);
insert into casting values (172,3389,13);
insert into casting values (952,3390,14);
insert into casting values (778,3390,8);
insert into casting values (1379,3390,13);
insert into casting values (27,3390,12);
insert into casting values (644,3390,6);
insert into casting values (865,3391,11);
insert into casting values (752,3391,10);
insert into casting values (1354,3391,8);
insert into casting values (1337,3391,15);
insert into casting values (1774,3391,7);
insert into casting values (1083,3392,7);
insert into casting values (944,3392,14);
insert into casting values (1397,3392,7);
insert into casting values (1796,3392,10);
insert into casting values (557,3392,12);
--- tabcasting, 11851, 50
insert into casting values (864,3393,12);
insert into casting values (1242,3393,4);
insert into casting values (1527,3393,12);
insert into casting values (1762,3393,13);
insert into casting values (956,3394,14);
insert into casting values (1576,3394,10);
insert into casting values (191,3394,15);
insert into casting values (443,3394,2);
insert into casting values (1235,3395,10);
insert into casting values (1258,3395,11);
insert into casting values (278,3395,16);
insert into casting values (462,3395,5);
insert into casting values (1054,3396,12);
insert into casting values (866,3396,6);
insert into casting values (345,3396,11);
insert into casting values (329,3396,6);
insert into casting values (272,3396,10);
insert into casting values (1795,3397,13);
insert into casting values (12,3397,15);
insert into casting values (486,3397,12);
insert into casting values (694,3397,5);
insert into casting values (1088,3398,13);
insert into casting values (1310,3398,11);
insert into casting values (135,3398,9);
insert into casting values (179,3398,11);
insert into casting values (372,3398,9);
insert into casting values (869,3399,13);
insert into casting values (909,3399,14);
insert into casting values (1005,3399,5);
insert into casting values (1773,3399,10);
insert into casting values (1239,3400,9);
insert into casting values (152,3400,11);
insert into casting values (344,3400,10);
insert into casting values (590,3400,15);
insert into casting values (520,3400,8);
insert into casting values (1012,3401,15);
insert into casting values (1100,3401,10);
insert into casting values (1146,3401,7);
insert into casting values (1551,3401,14);
insert into casting values (562,3401,7);
insert into casting values (1270,3402,11);
insert into casting values (1778,3402,4);
insert into casting values (1773,3402,14);
insert into casting values (410,3402,15);
insert into casting values (926,3403,8);
insert into casting values (891,3403,12);
insert into casting values (1214,3403,13);
insert into casting values (1471,3403,10);
insert into casting values (1469,3403,11);
insert into casting values (315,3403,13);
--- tabcasting, 11901, 50
insert into casting values (186,3403,14);
insert into casting values (527,3403,11);
insert into casting values (1153,3404,10);
insert into casting values (1495,3404,13);
insert into casting values (1516,3404,14);
insert into casting values (351,3404,2);
insert into casting values (1674,3405,11);
insert into casting values (245,3405,9);
insert into casting values (112,3405,10);
insert into casting values (627,3405,10);
insert into casting values (1251,3406,12);
insert into casting values (1537,3406,3);
insert into casting values (1644,3406,13);
insert into casting values (52,3406,10);
insert into casting values (1626,3407,10);
insert into casting values (1815,3407,5);
insert into casting values (279,3407,13);
insert into casting values (678,3407,11);
insert into casting values (1694,3408,8);
insert into casting values (1554,3408,9);
insert into casting values (191,3408,11);
insert into casting values (494,3408,14);
insert into casting values (405,3408,12);
insert into casting values (965,3409,6);
insert into casting values (1414,3409,15);
insert into casting values (616,3409,11);
insert into casting values (441,3409,12);
insert into casting values (727,3409,8);
insert into casting values (782,3410,9);
insert into casting values (1171,3410,15);
insert into casting values (1678,3410,9);
insert into casting values (350,3410,12);
insert into casting values (1689,3411,11);
insert into casting values (1511,3411,5);
insert into casting values (51,3411,10);
insert into casting values (85,3411,15);
insert into casting values (812,3412,9);
insert into casting values (1810,3412,13);
insert into casting values (362,3412,10);
insert into casting values (626,3412,11);
insert into casting values (583,3412,7);
insert into casting values (1285,3413,11);
insert into casting values (1449,3413,13);
insert into casting values (1770,3413,10);
insert into casting values (684,3413,7);
insert into casting values (700,3413,6);
insert into casting values (1065,3414,14);
insert into casting values (1163,3414,15);
insert into casting values (1594,3414,7);
insert into casting values (201,3414,8);
--- tabcasting, 11951, 50
insert into casting values (96,3414,13);
insert into casting values (742,3415,11);
insert into casting values (1547,3415,10);
insert into casting values (55,3415,4);
insert into casting values (603,3415,10);
insert into casting values (740,3416,11);
insert into casting values (1354,3416,7);
insert into casting values (1486,3416,8);
insert into casting values (895,3417,4);
insert into casting values (707,3417,14);
insert into casting values (984,3418,6);
insert into casting values (1463,3418,10);
insert into casting values (157,3418,6);
insert into casting values (621,3418,15);
insert into casting values (28,3419,5);
insert into casting values (332,3419,15);
insert into casting values (654,3419,15);
insert into casting values (908,3420,10);
insert into casting values (1785,3420,14);
insert into casting values (1798,3420,9);
insert into casting values (1546,3420,7);
insert into casting values (788,3421,11);
insert into casting values (1416,3421,3);
insert into casting values (274,3421,15);
insert into casting values (1187,3422,11);
insert into casting values (1127,3422,6);
insert into casting values (21,3422,9);
insert into casting values (389,3422,15);
insert into casting values (748,3423,12);
insert into casting values (780,3423,4);
insert into casting values (1156,3423,12);
insert into casting values (1423,3424,11);
insert into casting values (1778,3424,12);
insert into casting values (83,3424,13);
insert into casting values (328,3424,14);
insert into casting values (192,3424,13);
insert into casting values (26,3424,11);
insert into casting values (148,3424,6);
insert into casting values (567,3424,13);
insert into casting values (1035,3425,10);
insert into casting values (156,3425,2);
insert into casting values (9,3425,14);
insert into casting values (1060,3426,14);
insert into casting values (1165,3426,10);
insert into casting values (1211,3426,5);
insert into casting values (800,3427,8);
insert into casting values (185,3427,6);
insert into casting values (534,3427,10);
insert into casting values (628,3427,15);
insert into casting values (1651,3428,5);
--- tabcasting, 12001, 50
insert into casting values (293,3428,15);
insert into casting values (32,3428,14);
insert into casting values (1069,3429,12);
insert into casting values (1641,3429,5);
insert into casting values (593,3429,14);
insert into casting values (1045,3430,10);
insert into casting values (413,3430,3);
insert into casting values (411,3430,13);
insert into casting values (817,3431,5);
insert into casting values (171,3431,14);
insert into casting values (207,3432,7);
insert into casting values (300,3432,9);
insert into casting values (612,3432,11);
insert into casting values (532,3432,12);
insert into casting values (808,3433,14);
insert into casting values (955,3433,14);
insert into casting values (1760,3433,2);
insert into casting values (1024,3434,12);
insert into casting values (1379,3434,5);
insert into casting values (141,3434,11);
insert into casting values (153,3435,12);
insert into casting values (111,3435,3);
insert into casting values (1040,3436,7);
insert into casting values (763,3436,15);
insert into casting values (240,3436,8);
insert into casting values (449,3436,11);
insert into casting values (1432,3437,10);
insert into casting values (1292,3437,7);
insert into casting values (1374,3437,8);
insert into casting values (722,3437,15);
insert into casting values (1610,3438,11);
insert into casting values (1512,3438,10);
insert into casting values (288,3438,2);
insert into casting values (1004,3439,14);
insert into casting values (1178,3439,4);
insert into casting values (406,3439,15);
insert into casting values (128,3440,8);
insert into casting values (430,3440,14);
insert into casting values (525,3440,6);
insert into casting values (618,3440,12);
insert into casting values (1423,3441,4);
insert into casting values (373,3441,15);
insert into casting values (755,3442,10);
insert into casting values (858,3442,10);
insert into casting values (1203,3442,8);
insert into casting values (1718,3442,9);
insert into casting values (1041,3443,8);
insert into casting values (1183,3443,8);
insert into casting values (1465,3443,13);
insert into casting values (1539,3443,14);
--- tabcasting, 12051, 50
insert into casting values (1274,3444,12);
insert into casting values (1707,3444,14);
insert into casting values (60,3444,5);
insert into casting values (234,3445,3);
insert into casting values (268,3445,12);
insert into casting values (1629,3446,3);
insert into casting values (638,3446,10);
insert into casting values (688,3446,11);
insert into casting values (1363,3447,13);
insert into casting values (1646,3447,4);
insert into casting values (205,3447,14);
insert into casting values (1655,3448,11);
insert into casting values (1533,3448,14);
insert into casting values (1037,3449,7);
insert into casting values (1137,3449,8);
insert into casting values (3,3449,13);
insert into casting values (319,3449,15);
insert into casting values (990,3450,14);
insert into casting values (1195,3450,2);
insert into casting values (1544,3450,13);
insert into casting values (964,3451,6);
insert into casting values (1383,3451,11);
insert into casting values (287,3451,15);
insert into casting values (269,3452,11);
insert into casting values (339,3452,5);
insert into casting values (408,3452,13);
insert into casting values (1005,3453,15);
insert into casting values (1057,3453,5);
insert into casting values (1459,3453,13);
insert into casting values (909,3454,10);
insert into casting values (869,3454,9);
insert into casting values (1117,3454,7);
insert into casting values (325,3454,13);
insert into casting values (338,3455,10);
insert into casting values (628,3455,10);
insert into casting values (1228,3456,8);
insert into casting values (1198,3456,9);
insert into casting values (19,3456,14);
insert into casting values (107,3456,10);
insert into casting values (293,3457,12);
insert into casting values (230,3457,15);
insert into casting values (317,3457,9);
insert into casting values (484,3457,7);
insert into casting values (1163,3458,12);
insert into casting values (1529,3458,14);
insert into casting values (577,3458,4);
insert into casting values (790,3459,9);
insert into casting values (1063,3459,14);
insert into casting values (1441,3459,8);
insert into casting values (1250,3459,15);
--- tabcasting, 12101, 50
insert into casting values (1352,3460,9);
insert into casting values (1770,3460,14);
insert into casting values (330,3460,13);
insert into casting values (609,3460,9);
insert into casting values (1013,3461,4);
insert into casting values (1640,3461,15);
insert into casting values (462,3461,11);
insert into casting values (1648,3462,11);
insert into casting values (719,3462,10);
insert into casting values (1010,3463,3);
insert into casting values (545,3463,15);
insert into casting values (939,3464,14);
insert into casting values (1636,3464,6);
insert into casting values (60,3464,10);
insert into casting values (712,3464,9);
insert into casting values (1636,3465,9);
insert into casting values (53,3465,15);
insert into casting values (320,3465,10);
insert into casting values (58,3465,14);
insert into casting values (630,3465,13);
insert into casting values (564,3465,10);
insert into casting values (449,3465,13);
insert into casting values (387,3465,10);
insert into casting values (947,3466,13);
insert into casting values (1083,3466,8);
insert into casting values (1419,3466,7);
insert into casting values (1490,3466,14);
insert into casting values (1708,3467,11);
insert into casting values (637,3467,4);
insert into casting values (458,3467,11);
insert into casting values (870,3468,13);
insert into casting values (182,3468,12);
insert into casting values (412,3468,5);
insert into casting values (763,3469,5);
insert into casting values (298,3469,13);
insert into casting values (319,3469,12);
insert into casting values (747,3470,3);
insert into casting values (801,3470,11);
insert into casting values (193,3470,10);
insert into casting values (868,3471,9);
insert into casting values (1036,3471,10);
insert into casting values (1028,3471,9);
insert into casting values (126,3471,11);
insert into casting values (1551,3472,13);
insert into casting values (220,3472,10);
insert into casting values (142,3472,5);
insert into casting values (1377,3473,7);
insert into casting values (1523,3473,12);
insert into casting values (188,3473,15);
insert into casting values (730,3473,7);
--- tabcasting, 12151, 50
insert into casting values (746,3474,8);
insert into casting values (259,3474,10);
insert into casting values (339,3474,9);
insert into casting values (599,3474,10);
insert into casting values (808,3475,12);
insert into casting values (1096,3475,14);
insert into casting values (842,3475,6);
insert into casting values (661,3475,8);
insert into casting values (1549,3476,4);
insert into casting values (653,3476,12);
insert into casting values (489,3476,11);
insert into casting values (1664,3477,5);
insert into casting values (1505,3477,15);
insert into casting values (645,3477,10);
insert into casting values (865,3478,10);
insert into casting values (815,3478,6);
insert into casting values (748,3478,10);
insert into casting values (1315,3478,6);
insert into casting values (1385,3479,12);
insert into casting values (75,3479,10);
insert into casting values (703,3479,3);
insert into casting values (1740,3480,10);
insert into casting values (89,3480,12);
insert into casting values (574,3480,5);
insert into casting values (1810,3481,15);
insert into casting values (192,3481,9);
insert into casting values (526,3481,7);
insert into casting values (483,3481,13);
insert into casting values (1066,3482,5);
insert into casting values (1150,3482,15);
insert into casting values (110,3482,14);
insert into casting values (902,3483,7);
insert into casting values (975,3483,13);
insert into casting values (1016,3483,13);
insert into casting values (1118,3483,15);
insert into casting values (1122,3483,11);
insert into casting values (226,3483,10);
insert into casting values (265,3483,11);
insert into casting values (198,3483,12);
insert into casting values (1426,3484,7);
insert into casting values (1748,3484,12);
insert into casting values (1825,3484,7);
insert into casting values (285,3484,13);
insert into casting values (1253,3485,7);
insert into casting values (1114,3485,14);
insert into casting values (1532,3485,9);
insert into casting values (255,3485,14);
insert into casting values (732,3486,4);
insert into casting values (1158,3486,11);
insert into casting values (1711,3486,11);
--- tabcasting, 12201, 50
insert into casting values (1628,3487,9);
insert into casting values (1669,3487,11);
insert into casting values (198,3487,9);
insert into casting values (263,3487,10);
insert into casting values (1024,3488,4);
insert into casting values (1639,3488,10);
insert into casting values (1612,3488,15);
insert into casting values (1032,3489,15);
insert into casting values (1771,3489,10);
insert into casting values (1342,3490,6);
insert into casting values (1621,3490,14);
insert into casting values (1734,3490,11);
insert into casting values (1334,3491,8);
insert into casting values (1704,3491,15);
insert into casting values (1612,3491,11);
insert into casting values (255,3491,7);
insert into casting values (1243,3492,12);
insert into casting values (308,3492,8);
insert into casting values (395,3492,10);
insert into casting values (913,3493,8);
insert into casting values (1364,3493,6);
insert into casting values (1547,3493,11);
insert into casting values (101,3493,14);
insert into casting values (771,3494,6);
insert into casting values (1123,3494,8);
insert into casting values (590,3494,13);
insert into casting values (421,3494,13);
insert into casting values (280,3495,15);
insert into casting values (712,3495,10);
insert into casting values (432,3495,5);
insert into casting values (904,3496,9);
insert into casting values (106,3496,11);
insert into casting values (26,3496,10);
insert into casting values (382,3496,8);
insert into casting values (1294,3497,10);
insert into casting values (1509,3497,9);
insert into casting values (84,3497,9);
insert into casting values (60,3497,11);
insert into casting values (968,3498,15);
insert into casting values (1333,3498,3);
insert into casting values (32,3498,13);
insert into casting values (1131,3499,15);
insert into casting values (255,3499,11);
insert into casting values (1061,3500,6);
insert into casting values (863,3500,15);
insert into casting values (1692,3500,15);
insert into casting values (23,3500,7);
insert into casting values (1440,3501,13);
insert into casting values (1650,3501,5);
insert into casting values (161,3501,11);
--- tabcasting, 12251, 50
insert into casting values (1261,3502,13);
insert into casting values (490,3502,5);
insert into casting values (441,3502,14);
insert into casting values (751,3503,4);
insert into casting values (549,3503,13);
insert into casting values (946,3504,14);
insert into casting values (1845,3504,4);
insert into casting values (543,3504,14);
insert into casting values (1766,3505,13);
insert into casting values (1731,3505,4);
insert into casting values (1794,3505,14);
insert into casting values (1057,3506,11);
insert into casting values (1416,3506,10);
insert into casting values (1305,3506,5);
insert into casting values (36,3507,2);
insert into casting values (567,3507,11);
insert into casting values (1011,3508,7);
insert into casting values (1627,3508,15);
insert into casting values (443,3508,9);
insert into casting values (1223,3509,15);
insert into casting values (1656,3509,2);
insert into casting values (1424,3510,3);
insert into casting values (1382,3510,13);
insert into casting values (1533,3511,3);
insert into casting values (94,3511,12);
insert into casting values (1437,3512,14);
insert into casting values (595,3512,2);
insert into casting values (1073,3513,7);
insert into casting values (856,3513,13);
insert into casting values (1825,3513,8);
insert into casting values (1273,3514,5);
insert into casting values (1768,3514,11);
insert into casting values (737,3515,6);
insert into casting values (85,3515,11);
insert into casting values (533,3515,6);
insert into casting values (1071,3516,11);
insert into casting values (1005,3516,8);
insert into casting values (1281,3516,7);
insert into casting values (269,3517,10);
insert into casting values (709,3517,5);
insert into casting values (1630,3518,3);
insert into casting values (181,3518,10);
insert into casting values (1419,3519,10);
insert into casting values (728,3519,5);
insert into casting values (1024,3520,14);
insert into casting values (513,3520,5);
insert into casting values (1356,3521,13);
insert into casting values (284,3521,8);
insert into casting values (529,3521,9);
insert into casting values (79,3522,10);
--- tabcasting, 12301, 50
insert into casting values (627,3522,3);
insert into casting values (1774,3523,10);
insert into casting values (162,3523,5);
insert into casting values (935,3524,4);
insert into casting values (1548,3524,12);
insert into casting values (1201,3525,11);
insert into casting values (425,3525,4);
insert into casting values (181,3526,5);
insert into casting values (268,3526,10);
insert into casting values (27,3527,14);
insert into casting values (672,3527,4);
insert into casting values (798,3528,5);
insert into casting values (102,3528,10);
insert into casting values (1186,3529,10);
insert into casting values (1830,3529,3);
insert into casting values (1773,3530,2);
insert into casting values (116,3530,13);
insert into casting values (1177,3531,10);
insert into casting values (276,3531,5);
insert into casting values (1382,3532,4);
insert into casting values (585,3532,13);
insert into casting values (1729,3533,2);
insert into casting values (74,3533,12);
insert into casting values (1343,3534,11);
insert into casting values (697,3534,3);
insert into casting values (1502,3535,13);
insert into casting values (605,3535,5);
insert into casting values (1438,3536,14);
insert into casting values (1789,3536,3);
insert into casting values (1212,3537,16);
insert into casting values (290,3537,2);
insert into casting values (1479,3538,10);
insert into casting values (1844,3538,5);
insert into casting values (919,3539,9);
insert into casting values (1180,3539,9);
insert into casting values (657,3539,10);
insert into casting values (1462,3540,11);
insert into casting values (1781,3540,3);
insert into casting values (1472,3541,10);
insert into casting values (292,3541,5);
insert into casting values (1786,3542,6);
insert into casting values (233,3542,7);
insert into casting values (146,3542,13);
insert into casting values (745,3543,15);
insert into casting values (839,3543,4);
insert into casting values (1043,3544,13);
insert into casting values (1810,3544,5);
insert into casting values (1006,3545,15);
insert into casting values (1588,3545,5);
insert into casting values (1282,3546,6);
--- tabcasting, 12351, 50
insert into casting values (1659,3546,12);
insert into casting values (586,3546,9);
insert into casting values (1148,3547,15);
insert into casting values (1591,3547,5);
insert into casting values (1313,3548,11);
insert into casting values (126,3548,3);
insert into casting values (1758,3549,5);
insert into casting values (427,3549,11);
insert into casting values (1172,3550,4);
insert into casting values (1600,3550,12);
insert into casting values (437,3551,10);
insert into casting values (1173,3552,13);
insert into casting values (237,3552,4);
insert into casting values (1081,3553,8);
insert into casting values (1109,3553,15);
insert into casting values (1818,3553,8);
insert into casting values (1328,3554,2);
insert into casting values (1673,3554,11);
insert into casting values (31,3555,8);
insert into casting values (422,3555,8);
insert into casting values (662,3555,10);
insert into casting values (1171,3556,4);
insert into casting values (246,3556,13);
insert into casting values (1769,3557,13);
insert into casting values (1595,3557,4);
insert into casting values (279,3558,14);
insert into casting values (699,3558,5);
insert into casting values (1054,3559,6);
insert into casting values (1642,3559,10);
insert into casting values (1829,3559,7);
insert into casting values (1061,3560,15);
insert into casting values (1564,3560,5);
insert into casting values (1799,3561,11);
insert into casting values (518,3561,4);
insert into casting values (1039,3562,15);
insert into casting values (498,3562,3);
insert into casting values (1351,3563,5);
insert into casting values (497,3563,10);
insert into casting values (896,3564,10);
insert into casting values (483,3564,3);
insert into casting values (1149,3565,6);
insert into casting values (118,3565,10);
insert into casting values (391,3565,8);
insert into casting values (990,3566,4);
insert into casting values (328,3566,10);
insert into casting values (998,3567,7);
insert into casting values (1780,3567,8);
insert into casting values (649,3567,12);
insert into casting values (209,3568,12);
insert into casting values (367,3568,4);
--- tabcasting, 12401, 50
insert into casting values (1397,3569,13);
insert into casting values (166,3569,5);
insert into casting values (1028,3570,14);
insert into casting values (357,3570,4);
insert into casting values (60,3571,4);
insert into casting values (1490,3572,4);
insert into casting values (1648,3572,14);
insert into casting values (884,3573,15);
insert into casting values (1575,3573,4);
insert into casting values (986,3574,3);
insert into casting values (1684,3574,11);
insert into casting values (340,3575,4);
insert into casting values (288,3575,11);
insert into casting values (283,3576,14);
insert into casting values (103,3576,3);
insert into casting values (494,3577,13);
insert into casting values (1300,3578,13);
insert into casting values (1539,3578,7);
insert into casting values (213,3578,8);
insert into casting values (1290,3579,4);
insert into casting values (642,3579,13);
insert into casting values (890,3580,11);
insert into casting values (1635,3580,5);
insert into casting values (1250,3581,14);
insert into casting values (1441,3581,2);
insert into casting values (764,3582,2);
insert into casting values (1665,3582,11);
insert into casting values (1462,3583,5);
insert into casting values (666,3583,11);
insert into casting values (1436,3584,11);
insert into casting values (420,3584,5);
insert into casting values (1351,3585,8);
insert into casting values (1596,3585,15);
insert into casting values (75,3585,9);
insert into casting values (1533,3586,4);
insert into casting values (1790,3586,14);
insert into casting values (1410,3587,10);
insert into casting values (544,3587,5);
insert into casting values (1486,3588,12);
insert into casting values (444,3588,4);
insert into casting values (1571,3589,5);
insert into casting values (901,3590,12);
insert into casting values (100,3590,5);
insert into casting values (1051,3591,9);
insert into casting values (1361,3591,7);
insert into casting values (1626,3591,14);
insert into casting values (974,3592,10);
insert into casting values (241,3592,6);
insert into casting values (660,3592,8);
insert into casting values (1706,3593,14);
--- tabcasting, 12451, 50
insert into casting values (1307,3594,4);
insert into casting values (51,3594,14);
insert into casting values (1238,3595,3);
insert into casting values (1542,3595,12);
insert into casting values (1445,3596,5);
insert into casting values (78,3596,12);
insert into casting values (1515,3597,14);
insert into casting values (602,3597,4);
insert into casting values (822,3598,12);
insert into casting values (1731,3598,8);
insert into casting values (282,3598,8);
insert into casting values (845,3599,9);
insert into casting values (840,3599,12);
insert into casting values (1811,3599,7);
insert into casting values (1027,3600,15);
insert into casting values (466,3600,3);
insert into casting values (846,3601,10);
insert into casting values (1526,3601,5);
insert into casting values (787,3602,7);
insert into casting values (726,3602,13);
insert into casting values (613,3602,7);
insert into casting values (1275,3603,15);
insert into casting values (1627,3603,6);
insert into casting values (728,3603,6);
insert into casting values (1014,3604,4);
insert into casting values (1436,3604,12);
insert into casting values (1275,3605,9);
insert into casting values (183,3605,13);
insert into casting values (732,3605,7);
insert into casting values (1478,3606,5);
insert into casting values (1593,3606,11);
insert into casting values (1397,3607,8);
insert into casting values (1659,3607,11);
insert into casting values (454,3607,6);
insert into casting values (1815,3608,6);
insert into casting values (47,3608,8);
insert into casting values (262,3608,12);
insert into casting values (1581,3609,5);
insert into casting values (148,3609,15);
insert into casting values (1598,3610,11);
insert into casting values (239,3610,8);
insert into casting values (554,3610,6);
insert into casting values (994,3611,5);
insert into casting values (1598,3611,14);
insert into casting values (183,3612,10);
insert into casting values (401,3612,2);
insert into casting values (938,3613,8);
insert into casting values (754,3613,12);
insert into casting values (480,3613,6);
insert into casting values (1254,3614,3);
--- tabcasting, 12501, 50
insert into casting values (246,3614,15);
insert into casting values (1018,3615,10);
insert into casting values (675,3615,5);
insert into casting values (37,3616,4);
insert into casting values (723,3616,10);
insert into casting values (1078,3617,14);
insert into casting values (1105,3617,2);
insert into casting values (1184,3618,10);
insert into casting values (426,3618,2);
insert into casting values (958,3619,11);
insert into casting values (40,3619,6);
insert into casting values (522,3619,8);
insert into casting values (757,3620,9);
insert into casting values (1447,3620,8);
insert into casting values (1814,3620,13);
insert into casting values (1810,3621,9);
insert into casting values (606,3621,6);
insert into casting values (529,3621,12);
insert into casting values (1079,3622,14);
insert into casting values (67,3622,5);
insert into casting values (1551,3623,12);
insert into casting values (1523,3623,8);
insert into casting values (265,3623,9);
insert into casting values (1844,3624,15);
insert into casting values (368,3624,7);
insert into casting values (1378,3625,12);
insert into casting values (1358,3625,4);
insert into casting values (325,3626,8);
insert into casting values (491,3626,7);
insert into casting values (808,3627,5);
insert into casting values (173,3627,12);
insert into casting values (845,3628,12);
insert into casting values (1254,3628,2);
insert into casting values (1732,3629,5);
insert into casting values (636,3629,13);
insert into casting values (1266,3630,5);
insert into casting values (1404,3630,12);
insert into casting values (854,3631,3);
insert into casting values (463,3631,15);
insert into casting values (997,3632,10);
insert into casting values (1118,3632,3);
insert into casting values (803,3633,4);
insert into casting values (563,3633,15);
insert into casting values (839,3634,5);
insert into casting values (107,3634,15);
insert into casting values (1219,3635,3);
insert into casting values (282,3635,11);
insert into casting values (767,3636,3);
insert into casting values (1606,3636,14);
insert into casting values (1463,3637,8);
--- tabcasting, 12551, 50
insert into casting values (1290,3637,6);
insert into casting values (2,3637,10);
insert into casting values (854,3638,9);
insert into casting values (1810,3638,6);
insert into casting values (291,3638,11);
insert into casting values (1253,3639,3);
insert into casting values (1804,3639,14);
insert into casting values (310,3640,14);
insert into casting values (109,3640,4);
insert into casting values (1025,3641,5);
insert into casting values (500,3641,12);
insert into casting values (858,3642,9);
insert into casting values (1023,3642,10);
insert into casting values (360,3642,8);
insert into casting values (1278,3643,11);
insert into casting values (136,3643,9);
insert into casting values (527,3643,9);
insert into casting values (139,3644,13);
insert into casting values (585,3644,5);
insert into casting values (1460,3645,3);
insert into casting values (1488,3645,11);
insert into casting values (1385,3646,4);
insert into casting values (15,3646,15);
insert into casting values (1286,3647,12);
insert into casting values (381,3647,4);
insert into casting values (1514,3648,4);
insert into casting values (1730,3648,10);
insert into casting values (762,3649,7);
insert into casting values (1575,3649,11);
insert into casting values (261,3649,7);
insert into casting values (1025,3650,11);
insert into casting values (1755,3650,2);
insert into casting values (618,3651,11);
insert into casting values (537,3651,4);
insert into casting values (1722,3652,4);
insert into casting values (1370,3653,10);
insert into casting values (1654,3653,5);
insert into casting values (385,3654,13);
insert into casting values (663,3654,5);
insert into casting values (1145,3655,13);
insert into casting values (1568,3655,4);
insert into casting values (310,3656,11);
insert into casting values (431,3656,3);
insert into casting values (800,3657,14);
insert into casting values (1243,3657,7);
insert into casting values (202,3657,6);
insert into casting values (915,3658,12);
insert into casting values (1346,3658,5);
insert into casting values (1073,3659,14);
insert into casting values (48,3659,5);
--- tabcasting, 12601, 50
insert into casting values (529,3660,4);
insert into casting values (997,3661,12);
insert into casting values (817,3661,2);
insert into casting values (793,3662,11);
insert into casting values (314,3662,3);
insert into casting values (29,3663,15);
insert into casting values (391,3663,6);
insert into casting values (688,3663,6);
insert into casting values (589,3664,5);
insert into casting values (715,3664,13);
insert into casting values (779,3665,12);
insert into casting values (1561,3665,4);
insert into casting values (1365,3666,15);
insert into casting values (1692,3666,5);
insert into casting values (945,3667,3);
insert into casting values (213,3668,3);
insert into casting values (289,3668,11);
insert into casting values (1036,3669,12);
insert into casting values (1614,3669,5);
insert into casting values (967,3670,12);
insert into casting values (1019,3670,7);
insert into casting values (1119,3670,9);
insert into casting values (1349,3671,11);
insert into casting values (457,3671,2);
insert into casting values (1349,3672,8);
insert into casting values (281,3672,8);
insert into casting values (564,3672,13);
insert into casting values (1697,3673,5);
insert into casting values (320,3673,11);
insert into casting values (1547,3674,14);
insert into casting values (1546,3674,5);
insert into casting values (1255,3675,2);
insert into casting values (363,3675,11);
insert into casting values (593,3676,12);
insert into casting values (921,3677,5);
insert into casting values (225,3677,14);
insert into casting values (1028,3678,6);
insert into casting values (1839,3678,10);
insert into casting values (487,3678,9);
insert into casting values (788,3679,3);
insert into casting values (1114,3679,12);
insert into casting values (894,3680,7);
insert into casting values (999,3680,9);
insert into casting values (591,3680,11);
insert into casting values (1247,3681,3);
insert into casting values (1807,3681,14);
insert into casting values (907,3682,10);
insert into casting values (1656,3682,4);
insert into casting values (1307,3683,3);
insert into casting values (562,3683,11);
--- tabcasting, 12651, 50
insert into casting values (774,3684,3);
insert into casting values (1196,3684,10);
insert into casting values (1053,3685,10);
insert into casting values (928,3685,7);
insert into casting values (1523,3685,9);
insert into casting values (1063,3686,7);
insert into casting values (1441,3686,9);
insert into casting values (1250,3686,11);
insert into casting values (1256,3687,6);
insert into casting values (1188,3687,13);
insert into casting values (47,3687,6);
insert into casting values (164,3688,13);
insert into casting values (341,3688,5);
insert into casting values (1054,3689,7);
insert into casting values (1781,3689,12);
insert into casting values (606,3689,7);
insert into casting values (238,3690,4);
insert into casting values (467,3690,15);
insert into casting values (269,3691,12);
insert into casting values (724,3691,4);
insert into casting values (505,3692,5);
insert into casting values (1214,3693,9);
insert into casting values (1765,3693,9);
insert into casting values (360,3693,12);
insert into casting values (1309,3694,6);
insert into casting values (1691,3694,8);
insert into casting values (397,3694,11);
insert into casting values (943,3695,15);
insert into casting values (1007,3695,4);
insert into casting values (1742,3696,10);
insert into casting values (405,3696,4);
insert into casting values (1678,3697,3);
insert into casting values (10,3697,10);
insert into casting values (1150,3698,14);
insert into casting values (987,3699,12);
insert into casting values (1367,3699,5);
insert into casting values (1700,3700,10);
insert into casting values (1442,3701,7);
insert into casting values (1457,3701,8);
insert into casting values (488,3701,14);
insert into casting values (1012,3702,4);
insert into casting values (1007,3702,11);
insert into casting values (934,3703,13);
insert into casting values (1818,3703,4);
insert into casting values (1380,3704,5);
insert into casting values (696,3704,13);
insert into casting values (1379,3705,8);
insert into casting values (70,3705,8);
insert into casting values (661,3705,14);
insert into casting values (381,3706,14);
--- tabcasting, 12701, 50
insert into casting values (539,3706,3);
insert into casting values (13,3707,11);
insert into casting values (1,3707,9);
insert into casting values (5,3707,6);
insert into casting values (940,3708,15);
insert into casting values (1703,3708,5);
insert into casting values (203,3709,3);
insert into casting values (691,3709,15);
insert into casting values (835,3710,4);
insert into casting values (262,3710,11);
insert into casting values (947,3711,9);
insert into casting values (963,3711,8);
insert into casting values (1388,3711,11);
insert into casting values (733,3712,5);
insert into casting values (454,3713,14);
insert into casting values (248,3714,15);
insert into casting values (596,3714,3);
insert into casting values (1137,3715,11);
insert into casting values (1243,3715,9);
insert into casting values (129,3715,9);
insert into casting values (798,3716,7);
insert into casting values (1739,3716,7);
insert into casting values (1673,3716,10);
insert into casting values (829,3717,2);
insert into casting values (332,3717,10);
insert into casting values (1479,3718,15);
insert into casting values (1687,3718,4);
insert into casting values (841,3719,2);
insert into casting values (1155,3719,10);
insert into casting values (1558,3720,5);
insert into casting values (467,3720,11);
insert into casting values (790,3721,11);
insert into casting values (1309,3721,2);
insert into casting values (112,3722,11);
insert into casting values (1207,3723,9);
insert into casting values (1555,3723,8);
insert into casting values (1519,3723,12);
insert into casting values (836,3724,2);
insert into casting values (1733,3724,13);
insert into casting values (1037,3725,14);
insert into casting values (1773,3725,3);
insert into casting values (740,3726,8);
insert into casting values (871,3726,7);
insert into casting values (684,3726,11);
insert into casting values (1393,3727,10);
insert into casting values (103,3727,7);
insert into casting values (262,3727,7);
insert into casting values (493,3728,8);
insert into casting values (714,3728,10);
insert into casting values (388,3728,8);
--- tabcasting, 12751, 50
insert into casting values (758,3729,8);
insert into casting values (224,3729,14);
insert into casting values (389,3729,9);
insert into casting values (1833,3730,3);
insert into casting values (1765,3730,14);
insert into casting values (849,3731,10);
insert into casting values (514,3731,5);
insert into casting values (1490,3732,6);
insert into casting values (547,3732,10);
insert into casting values (495,3732,7);
insert into casting values (1004,3733,9);
insert into casting values (1788,3733,11);
insert into casting values (23,3733,8);
insert into casting values (1437,3734,9);
insert into casting values (1489,3734,7);
insert into casting values (1584,3734,11);
insert into casting values (98,3735,11);
insert into casting values (485,3735,2);
insert into casting values (909,3736,11);
insert into casting values (1626,3736,2);
insert into casting values (1099,3737,7);
insert into casting values (1412,3737,15);
insert into casting values (123,3737,9);
insert into casting values (105,3738,14);
insert into casting values (583,3738,3);
insert into casting values (1257,3739,7);
insert into casting values (32,3739,9);
insert into casting values (169,3739,11);
insert into casting values (907,3740,9);
insert into casting values (584,3740,11);
insert into casting values (704,3740,9);
insert into casting values (201,3741,10);
insert into casting values (598,3741,4);
insert into casting values (450,3742,2);
insert into casting values (931,3743,5);
insert into casting values (1769,3743,10);
insert into casting values (1404,3744,10);
insert into casting values (257,3744,4);
insert into casting values (1569,3745,11);
insert into casting values (1562,3745,3);
insert into casting values (1325,3746,12);
insert into casting values (1431,3746,9);
insert into casting values (619,3746,8);
insert into casting values (1709,3747,2);
insert into casting values (413,3747,11);
insert into casting values (250,3748,5);
insert into casting values (308,3748,11);
insert into casting values (781,3749,5);
insert into casting values (120,3749,12);
insert into casting values (18,3750,5);
--- tabcasting, 12801, 50
insert into casting values (169,3750,13);
insert into casting values (873,3751,12);
insert into casting values (1461,3751,2);
insert into casting values (1776,3752,5);
insert into casting values (252,3752,12);
insert into casting values (293,3753,4);
insert into casting values (620,3753,12);
insert into casting values (304,3754,5);
insert into casting values (318,3754,10);
insert into casting values (1392,3755,15);
insert into casting values (523,3755,5);
insert into casting values (758,3756,13);
insert into casting values (868,3757,4);
insert into casting values (1725,3757,10);
insert into casting values (1516,3758,12);
insert into casting values (1674,3758,3);
insert into casting values (1425,3759,12);
insert into casting values (527,3759,5);
insert into casting values (914,3760,5);
insert into casting values (1454,3760,11);
insert into casting values (87,3761,4);
insert into casting values (473,3761,10);
insert into casting values (1138,3762,13);
insert into casting values (1842,3762,6);
insert into casting values (1784,3762,8);
insert into casting values (1190,3763,11);
insert into casting values (1293,3763,4);
insert into casting values (772,3764,9);
insert into casting values (1244,3764,10);
insert into casting values (1562,3764,8);
insert into casting values (1355,3765,13);
insert into casting values (449,3765,4);
insert into casting values (651,3766,4);
insert into casting values (455,3767,14);
insert into casting values (584,3767,3);
insert into casting values (883,3768,8);
insert into casting values (1589,3768,13);
insert into casting values (1488,3768,7);
insert into casting values (928,3769,4);
insert into casting values (1077,3769,13);
insert into casting values (1823,3770,15);
insert into casting values (911,3771,7);
insert into casting values (1609,3771,13);
insert into casting values (199,3771,8);
insert into casting values (1573,3772,10);
insert into casting values (77,3772,5);
insert into casting values (1652,3773,3);
insert into casting values (553,3773,13);
insert into casting values (958,3774,12);
insert into casting values (1215,3774,5);
--- tabcasting, 12851, 50
insert into casting values (1808,3775,8);
insert into casting values (1636,3775,13);
insert into casting values (615,3775,9);
insert into casting values (1095,3776,11);
insert into casting values (465,3776,4);
insert into casting values (1147,3777,3);
insert into casting values (623,3777,11);
insert into casting values (739,3778,5);
insert into casting values (998,3778,11);
insert into casting values (756,3779,8);
insert into casting values (870,3779,8);
insert into casting values (1010,3779,11);
insert into casting values (1551,3780,3);
insert into casting values (344,3780,11);
insert into casting values (1567,3781,4);
insert into casting values (107,3781,13);
insert into casting values (1097,3782,4);
insert into casting values (587,3782,10);
insert into casting values (1489,3783,4);
insert into casting values (330,3783,12);
insert into casting values (684,3784,5);
insert into casting values (867,3785,14);
insert into casting values (977,3785,5);
insert into casting values (1229,3786,5);
insert into casting values (1585,3786,12);
insert into casting values (1340,3787,5);
insert into casting values (1037,3788,12);
insert into casting values (1259,3788,2);
insert into casting values (1691,3789,3);
insert into casting values (553,3789,12);
insert into casting values (749,3790,5);
insert into casting values (307,3790,14);
insert into casting values (56,3791,15);
insert into casting values (537,3791,5);
insert into casting values (1215,3792,12);
insert into casting values (1245,3792,5);
insert into casting values (764,3793,12);
insert into casting values (1415,3793,4);
insert into casting values (1650,3794,4);
insert into casting values (161,3794,13);
insert into casting values (98,3795,13);
insert into casting values (71,3795,2);
insert into casting values (28,3796,4);
insert into casting values (611,3796,12);
insert into casting values (74,3797,11);
insert into casting values (541,3797,2);
insert into casting values (124,3798,11);
insert into casting values (706,3798,3);
insert into casting values (1261,3799,12);
insert into casting values (1559,3799,5);
--- tabcasting, 12901, 50
insert into casting values (790,3800,10);
insert into casting values (677,3800,5);
insert into casting values (1690,3801,8);
insert into casting values (354,3801,8);
insert into casting values (365,3801,24);
insert into casting values (462,3801,14);
insert into casting values (210,3802,3);
insert into casting values (218,3802,10);
insert into casting values (366,3803,3);
insert into casting values (548,3803,12);
insert into casting values (1150,3804,4);
insert into casting values (1685,3804,15);
insert into casting values (890,3805,5);
insert into casting values (840,3805,11);
insert into casting values (1040,3806,8);
insert into casting values (310,3806,8);
insert into casting values (446,3806,13);
insert into casting values (1537,3807,5);
insert into casting values (230,3807,12);
insert into casting values (1055,3808,8);
insert into casting values (1219,3808,6);
insert into casting values (205,3808,12);
insert into casting values (1293,3809,8);
insert into casting values (40,3809,12);
insert into casting values (582,3809,9);
insert into casting values (773,3810,9);
insert into casting values (1132,3810,11);
insert into casting values (1645,3810,7);
insert into casting values (1292,3811,5);
insert into casting values (1374,3811,12);
insert into casting values (1365,3812,13);
insert into casting values (1574,3812,5);
insert into casting values (1301,3813,2);
insert into casting values (1621,3813,12);
insert into casting values (535,3814,5);
insert into casting values (576,3814,13);
insert into casting values (322,3815,10);
insert into casting values (170,3815,9);
insert into casting values (137,3815,9);
insert into casting values (991,3816,7);
insert into casting values (302,3816,8);
insert into casting values (675,3816,13);
insert into casting values (1453,3817,15);
insert into casting values (1447,3817,5);
insert into casting values (1266,3818,14);
insert into casting values (1552,3818,3);
insert into casting values (1647,3819,14);
insert into casting values (129,3819,2);
insert into casting values (846,3820,8);
insert into casting values (1640,3820,6);
--- tabcasting, 12951, 50
insert into casting values (215,3820,13);
insert into casting values (1262,3821,5);
insert into casting values (377,3821,12);
insert into casting values (741,3822,14);
insert into casting values (1518,3822,5);
insert into casting values (875,3823,3);
insert into casting values (248,3823,11);
insert into casting values (1757,3824,3);
insert into casting values (231,3824,10);
insert into casting values (1820,3825,4);
insert into casting values (126,3825,15);
insert into casting values (1292,3826,4);
insert into casting values (401,3826,14);
insert into casting values (34,3827,5);
insert into casting values (1169,3828,15);
insert into casting values (828,3829,14);
insert into casting values (995,3829,4);
insert into casting values (1047,3830,15);
insert into casting values (1485,3830,3);
insert into casting values (902,3831,15);
insert into casting values (1022,3831,9);
insert into casting values (1148,3831,7);
insert into casting values (141,3832,4);
insert into casting values (1526,3833,4);
insert into casting values (462,3833,13);
insert into casting values (621,3834,14);
insert into casting values (623,3834,4);
insert into casting values (353,3835,8);
insert into casting values (88,3835,8);
insert into casting values (85,3835,10);
insert into casting values (1021,3836,7);
insert into casting values (903,3836,9);
insert into casting values (1440,3836,12);
insert into casting values (953,3837,15);
insert into casting values (1216,3837,4);
insert into casting values (143,3838,10);
insert into casting values (217,3838,5);
insert into casting values (1004,3839,10);
insert into casting values (854,3839,4);
insert into casting values (1674,3840,15);
insert into casting values (426,3840,3);
insert into casting values (1421,3841,13);
insert into casting values (332,3841,3);
insert into casting values (864,3842,5);
insert into casting values (226,3842,14);
insert into casting values (1338,3843,11);
insert into casting values (386,3843,5);
insert into casting values (1103,3844,10);
insert into casting values (565,3844,3);
insert into casting values (1844,3845,7);
--- tabcasting, 13001, 50
insert into casting values (287,3845,11);
insert into casting values (131,3845,7);
insert into casting values (962,3846,3);
insert into casting values (322,3846,14);
insert into casting values (769,3847,11);
insert into casting values (666,3847,5);
insert into casting values (1573,3848,11);
insert into casting values (170,3848,3);
insert into casting values (1102,3849,5);
insert into casting values (1022,3849,12);
insert into casting values (1426,3850,2);
insert into casting values (66,3850,14);
insert into casting values (1001,3851,12);
insert into casting values (1349,3851,4);
insert into casting values (1093,3852,4);
insert into casting values (1492,3852,10);
insert into casting values (1335,3853,9);
insert into casting values (1296,3853,13);
insert into casting values (867,3854,2);
insert into casting values (610,3854,10);
insert into casting values (1531,3855,2);
insert into casting values (601,3856,5);
insert into casting values (27,3857,5);
insert into casting values (221,3858,5);
insert into casting values (829,3859,5);
insert into casting values (469,3860,2);
insert into casting values (21,3861,4);
insert into casting values (170,3862,4);
insert into casting values (1816,3863,5);
insert into casting values (1815,3864,4);
insert into casting values (1237,3865,8);
insert into casting values (49,3865,7);
insert into casting values (1599,3866,4);
insert into casting values (579,3867,2);
insert into casting values (1782,3868,6);
insert into casting values (412,3868,6);
insert into casting values (826,3869,4);
insert into casting values (1564,3870,3);
insert into casting values (1741,3871,5);
insert into casting values (481,3872,3);
insert into casting values (1330,3873,2);
insert into casting values (1441,3874,5);
insert into casting values (413,3875,4);
insert into casting values (1581,3876,3);
insert into casting values (909,3877,9);
insert into casting values (710,3877,6);
insert into casting values (717,3878,4);
insert into casting values (704,3879,4);
insert into casting values (998,3880,8);
insert into casting values (1243,3880,8);
--- tabcasting, 13051, 50
insert into casting values (505,3881,2);
insert into casting values (250,3882,2);
insert into casting values (827,3883,4);
insert into casting values (1682,3884,2);
insert into casting values (1591,3885,4);
insert into casting values (1687,3886,5);
insert into casting values (836,3887,3);
insert into casting values (220,3888,9);
insert into casting values (833,3889,2);
insert into casting values (1298,3890,7);
insert into casting values (1692,3890,9);
insert into casting values (1323,3891,3);
insert into casting values (451,3892,4);
insert into casting values (267,3893,5);
insert into casting values (720,3894,5);
insert into casting values (1561,3895,3);
insert into casting values (1714,3896,4);
insert into casting values (1214,3897,5);
insert into casting values (435,3898,5);
insert into casting values (901,3899,5);
insert into casting values (199,3900,4);
insert into casting values (313,3901,3);
insert into casting values (121,3902,9);
insert into casting values (1588,3903,3);
insert into casting values (647,3904,5);
insert into casting values (1115,3905,3);
insert into casting values (1465,3906,4);
insert into casting values (1004,3907,6);
insert into casting values (208,3907,8);
insert into casting values (1440,3908,3);
insert into casting values (795,3909,5);
insert into casting values (63,3910,3);
insert into casting values (323,3911,2);
insert into casting values (927,3912,3);
insert into casting values (1520,3913,6);
insert into casting values (81,3913,6);
insert into casting values (1568,3914,2);
insert into casting values (1538,3915,6);
insert into casting values (591,3915,6);
insert into casting values (9,3916,3);
insert into casting values (1497,3917,6);
insert into casting values (593,3917,6);
insert into casting values (539,3918,2);
insert into casting values (823,3919,2);
insert into casting values (1040,3920,4);
insert into casting values (686,3921,2);
insert into casting values (1144,3922,5);
insert into casting values (1082,3923,2);
insert into casting values (804,3924,3);
insert into casting values (1339,3925,5);
--- tabcasting, 13101, 50
insert into casting values (910,3926,5);
insert into casting values (1241,3927,2);
insert into casting values (1080,3928,4);
insert into casting values (1169,3929,4);
insert into casting values (1485,3930,4);
insert into casting values (602,3931,5);
insert into casting values (1399,3932,5);
insert into casting values (1019,3933,4);
insert into casting values (1623,3934,3);
insert into casting values (1722,3935,9);
insert into casting values (1661,3936,4);
insert into casting values (240,3937,5);
insert into casting values (1711,3938,2);
insert into casting values (1195,3939,9);
insert into casting values (569,3939,9);
insert into casting values (264,3940,4);
insert into casting values (1169,3941,3);
insert into casting values (1210,3942,8);
insert into casting values (205,3942,7);
insert into casting values (1460,3943,5);
insert into casting values (787,3944,3);
insert into casting values (1414,3945,6);
insert into casting values (1697,3945,6);
insert into casting values (1399,3946,3);
insert into casting values (888,3947,4);
insert into casting values (77,3948,7);
insert into casting values (452,3948,7);
insert into casting values (807,3949,4);
insert into casting values (1253,3950,5);
insert into casting values (335,3951,2);
insert into casting values (958,3952,3);
insert into casting values (1838,3953,4);
insert into casting values (1008,3954,5);
insert into casting values (1552,3955,4);
insert into casting values (241,3956,4);
insert into casting values (1110,3957,5);
insert into casting values (1674,3958,4);
insert into casting values (1465,3959,2);
insert into casting values (1452,3960,3);
insert into casting values (1495,3961,4);
insert into casting values (548,3962,5);
insert into casting values (381,3963,3);
insert into casting values (602,3964,3);
insert into casting values (853,3965,9);
insert into casting values (1399,3965,8);
insert into casting values (478,3966,4);
insert into casting values (1416,3967,4);
insert into casting values (461,3968,5);
insert into casting values (372,3969,4);
insert into casting values (683,3970,2);
--- tabcasting, 13151, 50
insert into casting values (74,3971,5);
insert into casting values (1562,3972,2);
insert into casting values (417,3973,5);
insert into casting values (1722,3974,3);
insert into casting values (961,3975,9);
insert into casting values (538,3975,8);
insert into casting values (250,3976,3);
insert into casting values (1266,3977,4);
insert into casting values (1811,3978,2);
insert into casting values (953,3979,10);
insert into casting values (939,3979,10);
insert into casting values (1394,3979,11);
insert into casting values (1736,3979,14);
insert into casting values (79,3979,9);
insert into casting values (334,3979,15);
insert into casting values (282,3980,4);
insert into casting values (42,3981,5);
insert into casting values (1369,3982,5);
insert into casting values (716,3983,5);
insert into casting values (317,3984,5);
insert into casting values (189,3985,4);
insert into casting values (1696,3986,5);
insert into casting values (510,3987,4);
insert into casting values (121,3988,4);
insert into casting values (1787,3990,2);
insert into casting values (9,3991,2);
insert into casting values (1161,3992,4);
insert into casting values (1646,3993,5);
insert into casting values (732,3993,23);
insert into casting values (439,3994,3);
insert into casting values (768,3995,5);
insert into casting values (1273,3996,4);
insert into casting values (1205,3997,4);
insert into casting values (826,3998,5);
insert into casting values (613,3999,5);
insert into casting values (974,4000,5);
insert into casting values (382,4001,2);
insert into casting values (1586,4002,2);
insert into casting values (1369,4003,3);
insert into casting values (23,4004,4);
insert into casting values (604,4005,5);
insert into casting values (776,4006,2);
insert into casting values (439,4007,4);
insert into casting values (1763,4008,4);
insert into casting values (1505,4009,3);
insert into casting values (1386,4010,2);
insert into casting values (1682,4011,4);
insert into casting values (1622,4012,3);
insert into casting values (943,4013,5);
insert into casting values (685,4014,5);
--- tabcasting, 13201, 50
insert into casting values (1615,4015,5);
insert into casting values (1398,4016,3);
insert into casting values (1648,4017,5);
insert into casting values (590,4018,4);
insert into casting values (1309,4019,4);
insert into casting values (695,4020,2);
insert into casting values (1254,4021,6);
insert into casting values (103,4021,6);
insert into casting values (1800,4022,4);
insert into casting values (686,4023,3);
insert into casting values (1261,4024,5);
insert into casting values (1106,4025,2);
insert into casting values (1381,4026,3);
insert into casting values (951,4027,3);
insert into casting values (481,4028,5);
insert into casting values (1078,4029,4);
insert into casting values (1792,4030,2);
insert into casting values (1640,4031,3);
insert into casting values (1057,4032,3);
insert into casting values (1344,4033,5);
insert into casting values (868,4034,3);
insert into casting values (1622,4035,5);
insert into casting values (1582,4036,2);
insert into casting values (1579,4036,2);
insert into casting values (1272,4037,2);
insert into casting values (95,4038,8);
insert into casting values (71,4038,7);
insert into casting values (702,4039,2);
insert into casting values (888,4040,5);
insert into casting values (1637,4041,5);
insert into casting values (1065,4042,2);
insert into casting values (1837,4043,5);
insert into casting values (718,4044,5);
insert into casting values (1133,4045,5);
insert into casting values (207,4046,5);
insert into casting values (946,4048,9);
insert into casting values (513,4048,6);
insert into casting values (1537,4049,2);
insert into casting values (1444,4050,4);
insert into casting values (460,4051,2);
insert into casting values (303,4052,3);
insert into casting values (1090,4053,6);
insert into casting values (614,4053,8);
insert into casting values (434,4054,5);
insert into casting values (166,4055,3);
insert into casting values (1087,4056,4);
insert into casting values (651,4057,3);
insert into casting values (1190,4058,3);
insert into casting values (383,4060,2);
insert into casting values (1330,4061,5);
--- tabcasting, 13251, 50
insert into casting values (1602,4062,5);
insert into casting values (1797,4064,4);
insert into casting values (671,4065,2);
insert into casting values (754,4066,2);
insert into casting values (1373,4067,3);
insert into casting values (1417,4068,5);
insert into casting values (1757,4069,4);
insert into casting values (752,4070,5);
insert into casting values (561,4071,3);
insert into casting values (31,4072,5);
insert into casting values (541,4073,4);
insert into casting values (1612,4074,4);
insert into casting values (1677,4075,5);
insert into casting values (507,4077,5);
insert into casting values (1220,4078,5);
insert into casting values (1408,4079,5);
insert into casting values (767,4080,4);
insert into casting values (790,4081,5);
insert into casting values (734,4082,5);
insert into casting values (1833,4083,5);
insert into casting values (738,4084,5);
insert into casting values (640,4085,4);
insert into casting values (1821,4086,4);
insert into casting values (1348,4087,5);
insert into casting values (1773,4088,4);
insert into casting values (469,4089,4);
insert into casting values (1357,4090,5);
insert into casting values (1194,4091,2);
insert into casting values (1129,4092,5);
insert into casting values (958,4093,5);
insert into casting values (485,4094,3);
insert into casting values (716,4095,3);
insert into casting values (439,4096,2);
insert into casting values (1495,4097,5);
insert into casting values (1265,4098,4);
insert into casting values (1172,4099,5);
insert into casting values (1317,4100,9);
insert into casting values (273,4100,8);
insert into casting values (1664,4101,3);
insert into casting values (1168,4102,5);
insert into casting values (499,4103,2);
insert into casting values (274,4104,5);
insert into casting values (1035,4105,5);
insert into casting values (1556,4106,3);
insert into casting values (1167,4107,4);
insert into casting values (1155,4108,4);
insert into casting values (1533,4109,2);
insert into casting values (1623,4110,2);
insert into casting values (968,4111,3);
insert into casting values (126,4112,8);
--- tabcasting, 13301, 50
insert into casting values (557,4112,9);
insert into casting values (967,4113,5);
insert into casting values (795,4114,3);
insert into casting values (1164,4115,2);
insert into casting values (872,4116,4);
insert into casting values (772,4117,6);
insert into casting values (1454,4117,12);
insert into casting values (1232,4117,13);
insert into casting values (1788,4117,10);
insert into casting values (243,4117,10);
insert into casting values (1459,4118,9);
insert into casting values (409,4119,5);
insert into casting values (297,4120,3);
insert into casting values (1369,4121,4);
insert into casting values (1714,4123,5);
insert into casting values (565,4124,5);
insert into casting values (1198,4125,4);
insert into casting values (1343,4126,2);
insert into casting values (427,4127,3);
insert into casting values (1492,4128,3);
insert into casting values (508,4129,2);
insert into casting values (328,4130,5);
insert into casting values (936,4131,8);
insert into casting values (1425,4131,7);
insert into casting values (1043,4132,5);
insert into casting values (582,4133,2);
insert into casting values (1512,4134,5);
insert into casting values (1072,4135,5);
insert into casting values (141,4136,5);
insert into casting values (1617,4137,7);
insert into casting values (480,4138,2);
insert into casting values (405,4139,3);
insert into casting values (1721,4140,3);
insert into casting values (777,4141,2);
insert into casting values (1821,4142,3);
insert into casting values (412,4143,3);
insert into casting values (167,4144,5);
insert into casting values (1286,4145,5);
insert into casting values (1276,4146,5);
insert into casting values (1348,4147,2);
insert into casting values (1169,4148,2);
insert into casting values (403,4149,5);
insert into casting values (1138,4150,5);
insert into casting values (1196,4151,4);
insert into casting values (1297,4152,4);
insert into casting values (1698,4153,3);
insert into casting values (1130,4154,2);
insert into casting values (668,4155,7);
insert into casting values (732,4155,6);
insert into casting values (888,4156,2);
--- tabcasting, 13351, 50
insert into casting values (1076,4157,3);
insert into casting values (1065,4158,3);
insert into casting values (960,4159,5);
insert into casting values (1772,4160,3);
insert into casting values (1492,4161,5);
insert into casting values (961,4163,4);
insert into casting values (1446,4164,4);
insert into casting values (1205,4165,5);
insert into casting values (1729,4166,4);
insert into casting values (587,4167,9);
insert into casting values (1328,4168,4);
insert into casting values (21,4169,3);
insert into casting values (1838,4170,5);
insert into casting values (1723,4171,2);
insert into casting values (1679,4172,2);
insert into casting values (771,4173,4);
insert into casting values (97,4174,3);
insert into casting values (787,4175,2);
insert into casting values (1418,4176,5);
insert into casting values (1042,4177,3);
insert into casting values (1568,4178,3);
insert into casting values (1162,4179,5);
insert into casting values (1709,4180,3);
insert into casting values (752,4182,7);
insert into casting values (82,4182,7);
insert into casting values (1772,4183,2);
insert into casting values (854,4184,25);
insert into casting values (1524,4184,4);
insert into casting values (1744,4185,5);
insert into casting values (1417,4186,2);
insert into casting values (1144,4187,4);
insert into casting values (1200,4188,2);
insert into casting values (1068,4189,4);
insert into casting values (1723,4190,3);
insert into casting values (935,4191,3);
insert into casting values (1500,4192,4);
insert into casting values (1047,4193,3);
insert into casting values (1143,4194,4);
insert into casting values (664,4195,3);
insert into casting values (924,4196,7);
insert into casting values (1298,4197,5);
insert into casting values (757,4198,4);
insert into casting values (522,4199,5);
insert into casting values (801,4200,2);
insert into casting values (664,4201,5);
insert into casting values (1723,4202,4);
insert into casting values (1140,4203,2);
insert into casting values (1582,4204,4);
insert into casting values (1579,4204,4);
insert into casting values (1031,4205,8);
--- tabcasting, 13401, 50
insert into casting values (1284,4205,8);
insert into casting values (925,4206,3);
insert into casting values (1134,4207,3);
insert into casting values (93,4208,3);
insert into casting values (23,4209,3);
insert into casting values (847,4210,4);
insert into casting values (1411,4211,2);
insert into casting values (1226,4212,5);
insert into casting values (1447,4213,2);
insert into casting values (247,4214,5);
insert into casting values (791,4215,4);
insert into casting values (790,4216,4);
insert into casting values (938,4217,5);
insert into casting values (983,4218,5);
insert into casting values (1098,4219,4);
insert into casting values (1185,4220,4);
insert into casting values (1216,4221,3);
insert into casting values (1748,4222,5);
insert into casting values (1666,4223,3);
insert into casting values (1129,4224,2);
insert into casting values (1007,4225,9);
insert into casting values (1690,4225,7);
insert into casting values (936,4226,3);
insert into casting values (302,4227,2);
insert into casting values (348,4228,5);
insert into casting values (1105,4229,5);
insert into casting values (1334,4230,6);
insert into casting values (562,4230,6);
insert into casting values (1059,4231,4);
insert into casting values (917,4232,6);
insert into casting values (1764,4232,6);
insert into casting values (555,4233,4);
insert into casting values (744,4234,2);
insert into casting values (698,4235,2);
insert into casting values (331,4236,3);
insert into casting values (210,4237,5);
insert into casting values (1467,4238,4);
insert into casting values (875,4239,6);
insert into casting values (620,4239,9);
insert into casting values (374,4240,5);
insert into casting values (241,4241,3);
insert into casting values (40,4242,4);
insert into casting values (1150,4243,3);
insert into casting values (1595,4244,2);
insert into casting values (1094,4245,5);
insert into casting values (1443,4246,2);
insert into casting values (664,4248,2);
insert into casting values (1120,4249,3);
insert into casting values (1034,4250,5);
insert into casting values (600,4251,4);
--- tabcasting, 13451, 50
insert into casting values (1703,4252,2);
insert into casting values (518,4253,3);
insert into casting values (810,4254,3);
insert into casting values (415,4255,8);
insert into casting values (536,4255,7);
insert into casting values (1043,4257,8);
insert into casting values (26,4257,8);
insert into casting values (249,4258,3);
insert into casting values (518,4259,5);
insert into casting values (87,4260,3);
insert into casting values (414,4261,5);
insert into casting values (1531,4262,4);
insert into casting values (1782,4263,3);
insert into casting values (671,4264,4);
insert into casting values (1735,4265,5);
insert into casting values (903,4266,4);
insert into casting values (1414,4267,2);
insert into casting values (1762,4268,5);
insert into casting values (318,4269,5);
insert into casting values (1308,4270,5);
insert into casting values (1255,4271,5);
insert into casting values (873,4272,3);
insert into casting values (701,4273,4);
insert into casting values (565,4274,2);
insert into casting values (1500,4275,5);
insert into casting values (1606,4277,2);
insert into casting values (667,4278,4);
insert into casting values (845,4279,4);
insert into casting values (1640,4280,5);
insert into casting values (1093,4281,3);
insert into casting values (695,4282,3);
insert into casting values (966,4283,5);
insert into casting values (693,4284,3);
insert into casting values (1525,4285,5);
insert into casting values (697,4286,8);
insert into casting values (548,4286,9);
insert into casting values (1543,4287,5);
insert into casting values (1467,4288,3);
insert into casting values (1571,4289,2);
insert into casting values (776,4291,4);
insert into casting values (216,4292,5);
insert into casting values (1454,4293,6);
insert into casting values (24,4293,7);
insert into casting values (1286,4294,4);
insert into casting values (1191,4295,4);
insert into casting values (619,4296,4);
insert into casting values (532,4297,7);
insert into casting values (575,4297,6);
insert into casting values (847,4298,2);
insert into casting values (627,4299,4);
--- tabcasting, 13501, 50
insert into casting values (1671,4300,2);
insert into casting values (1334,4301,5);
insert into casting values (1732,4302,4);
insert into casting values (1424,4303,2);
insert into casting values (28,4304,3);
insert into casting values (745,4305,4);
insert into casting values (1213,4306,3);
insert into casting values (62,4307,4);
insert into casting values (391,4308,5);
insert into casting values (1193,4309,4);
insert into casting values (490,4310,2);
insert into casting values (1694,4311,4);
insert into casting values (910,4312,3);
insert into casting values (1024,4313,5);
insert into casting values (883,4314,5);
insert into casting values (1386,4315,4);
insert into casting values (836,4316,6);
insert into casting values (544,4316,9);
insert into casting values (1487,4317,3);
insert into casting values (454,4318,5);
insert into casting values (132,4319,4);
insert into casting values (227,4320,4);
insert into casting values (808,4321,3);
insert into casting values (1615,4322,4);
insert into casting values (983,4323,4);
insert into casting values (10,4324,4);
insert into casting values (1303,4325,2);
insert into casting values (93,4326,4);
insert into casting values (52,4327,5);
insert into casting values (264,4328,3);
insert into casting values (776,4329,5);
insert into casting values (480,4330,4);
insert into casting values (443,4331,3);
insert into casting values (852,4332,4);
insert into casting values (1278,4333,6);
insert into casting values (1786,4333,9);
insert into casting values (1836,4334,4);
insert into casting values (331,4335,4);
insert into casting values (1642,4336,5);
insert into casting values (948,4337,5);
insert into casting values (485,4338,5);
insert into casting values (993,4339,2);
insert into casting values (667,4340,3);
insert into casting values (1691,4341,5);
insert into casting values (1157,4342,6);
insert into casting values (1463,4342,6);
insert into casting values (1443,4343,3);
insert into casting values (211,4344,4);
insert into casting values (1325,4345,5);
insert into casting values (1762,4346,4);
--- tabcasting, 13551, 50
insert into casting values (213,4347,2);
insert into casting values (991,4348,6);
insert into casting values (275,4348,9);
insert into casting values (804,4349,2);
insert into casting values (1269,4350,5);
insert into casting values (297,4351,4);
insert into casting values (64,4352,8);
insert into casting values (467,4352,7);
insert into casting values (812,4353,2);
insert into casting values (1116,4354,5);
insert into casting values (1632,4355,3);
insert into casting values (629,4356,4);
insert into casting values (1748,4357,4);
insert into casting values (859,4358,4);
insert into casting values (1424,4359,5);
insert into casting values (1360,4360,3);
insert into casting values (1582,4361,5);
insert into casting values (1579,4361,5);
insert into casting values (958,4362,6);
insert into casting values (211,4362,7);
insert into casting values (1745,4363,5);
insert into casting values (1293,4364,5);
insert into casting values (1255,4365,3);
insert into casting values (1761,4368,8);
insert into casting values (1821,4368,7);
insert into casting values (1349,4369,2);
insert into casting values (1028,4370,4);
insert into casting values (1599,4371,3);
insert into casting values (817,4372,3);
insert into casting values (1115,4373,5);
insert into casting values (732,4374,5);
insert into casting values (314,4375,5);
insert into casting values (1589,4376,3);
insert into casting values (1436,4377,5);
insert into casting values (1274,4378,4);
insert into casting values (1228,4379,5);
insert into casting values (799,4380,4);
insert into casting values (278,4381,5);
insert into casting values (104,4382,5);
insert into casting values (1303,4383,3);
insert into casting values (177,4384,5);
insert into casting values (1671,4385,3);
insert into casting values (1821,4386,5);
insert into casting values (210,4387,2);
insert into casting values (1052,4388,7);
insert into casting values (424,4388,7);
insert into casting values (473,4389,4);
insert into casting values (1441,4390,4);
insert into casting values (1570,4391,5);
insert into casting values (1790,4392,5);
--- tabcasting, 13601, 50
insert into casting values (1118,4393,5);
insert into casting values (1720,4394,3);
insert into casting values (431,4395,5);
insert into casting values (303,4396,4);
insert into casting values (1059,4397,5);
insert into casting values (457,4398,4);
insert into casting values (1134,4399,2);
insert into casting values (997,4400,4);
insert into casting values (952,4401,8);
insert into casting values (1435,4401,9);
insert into casting values (1843,4402,3);
insert into casting values (960,4403,4);
insert into casting values (1309,4404,5);
insert into casting values (1588,4405,4);
insert into casting values (216,4406,3);
insert into casting values (1596,4407,2);
insert into casting values (1130,4408,4);
insert into casting values (1387,4409,4);
insert into casting values (1349,4410,5);
insert into casting values (1732,4411,3);
insert into casting values (1099,4412,6);
insert into casting values (326,4412,6);
insert into casting values (1269,4413,2);
insert into casting values (467,4414,3);
insert into casting values (952,4415,7);
insert into casting values (1245,4415,7);
insert into casting values (1634,4416,2);
insert into casting values (1800,4417,2);
insert into casting values (1372,4418,5);
insert into casting values (1220,4419,2);
insert into casting values (492,4420,4);
insert into casting values (850,4421,5);
insert into casting values (1298,4422,2);
insert into casting values (810,4423,2);
insert into casting values (1382,4425,5);
insert into casting values (878,4426,4);
insert into casting values (1803,4427,4);
insert into casting values (689,4428,5);
insert into casting values (1813,4429,4);
insert into casting values (445,4430,2);
insert into casting values (1327,4431,3);
insert into casting values (1025,4432,8);
insert into casting values (502,4432,7);
insert into casting values (340,4433,3);
insert into casting values (218,4434,4);
insert into casting values (1186,4435,8);
insert into casting values (1478,4435,8);
insert into casting values (1772,4436,5);
insert into casting values (659,4437,2);
insert into casting values (1137,4438,5);
--- tabcasting, 13651, 50
insert into casting values (1526,4439,2);
insert into casting values (1652,4440,5);
insert into casting values (1792,4441,5);
insert into casting values (990,4442,5);
insert into casting values (505,4443,4);
insert into casting values (1168,4444,4);
insert into casting values (1834,4445,5);
insert into casting values (1176,4446,3);
insert into casting values (203,4447,6);
insert into casting values (545,4447,7);
insert into casting values (1674,4448,5);
insert into casting values (1678,4449,4);
insert into casting values (686,4450,4);
insert into casting values (1655,4451,4);
insert into casting values (1107,4452,2);
insert into casting values (1364,4453,4);
insert into casting values (1169,4454,6);
insert into casting values (274,4454,7);
insert into casting values (1447,4455,3);
insert into casting values (218,4456,5);
insert into casting values (697,4457,4);
insert into casting values (1841,4458,2);
insert into casting values (1389,4459,2);
insert into casting values (1551,4460,5);
insert into casting values (1178,4461,2);
insert into casting values (643,4462,6);
insert into casting values (633,4462,8);
insert into casting values (1065,4463,5);
insert into casting values (1274,4464,5);
insert into casting values (1356,4465,8);
insert into casting values (106,4465,8);
insert into casting values (1154,4466,4);
insert into casting values (659,4467,4);
insert into casting values (939,4468,3);
insert into casting values (1010,4469,4);
insert into casting values (907,4470,4);
insert into casting values (406,4471,5);
insert into casting values (1054,4472,9);
insert into casting values (759,4472,7);
insert into casting values (1575,4473,6);
insert into casting values (513,4473,8);
insert into casting values (1210,4474,9);
insert into casting values (1822,4474,9);
insert into casting values (1414,4475,4);
insert into casting values (1412,4476,7);
insert into casting values (330,4476,6);
insert into casting values (1342,4477,4);
insert into casting values (59,4478,4);
insert into casting values (1472,4479,5);
insert into casting values (971,4480,5);
--- tabcasting, 13701, 50
insert into casting values (1344,4481,2);
insert into casting values (1678,4482,5);
insert into casting values (1417,4483,3);
insert into casting values (351,4485,4);
insert into casting values (610,4486,4);
insert into casting values (854,4487,2);
insert into casting values (539,4488,5);
insert into casting values (425,4490,5);
insert into casting values (191,4491,3);
insert into casting values (1350,4492,3);
insert into casting values (560,4493,3);
insert into casting values (605,4494,4);
insert into casting values (608,4495,5);
insert into casting values (1595,4496,5);
insert into casting values (1143,4497,5);
insert into casting values (1505,4498,2);
insert into casting values (1179,4499,4);
insert into casting values (1823,4500,3);
insert into casting values (1321,4501,5);
insert into casting values (498,4502,5);
insert into casting values (453,4503,8);
insert into casting values (589,4504,4);
insert into casting values (1434,4505,4);
insert into casting values (708,4506,5);
insert into casting values (461,4507,4);
insert into casting values (1608,4508,5);
insert into casting values (235,4509,4);
insert into casting values (72,4510,4);
insert into casting values (1005,4511,3);
insert into casting values (1098,4512,5);
insert into casting values (687,4514,4);
insert into casting values (801,4515,4);
insert into casting values (128,4516,5);
insert into casting values (1096,4518,7);
insert into casting values (679,4518,6);
insert into casting values (1008,4519,3);
insert into casting values (504,4520,5);
insert into casting values (795,4523,4);
insert into casting values (1245,4524,4);
insert into casting values (901,4525,8);
insert into casting values (1673,4525,7);
insert into casting values (922,4526,3);
insert into casting values (1401,4527,7);
insert into casting values (1272,4527,9);
insert into casting values (1072,4528,2);
insert into casting values (1348,4529,3);
insert into casting values (869,4530,5);
insert into casting values (912,4531,4);
insert into casting values (1035,4532,6);
insert into casting values (347,4532,6);
--- tabcasting, 13751, 50
insert into casting values (229,4533,4);
insert into casting values (283,4534,2);
insert into casting values (541,4535,3);
insert into casting values (1443,4536,5);
insert into casting values (1811,4537,5);
insert into casting values (416,4538,3);
insert into casting values (971,4539,4);
insert into casting values (853,4540,2);
insert into casting values (901,4541,6);
insert into casting values (181,4541,6);
insert into casting values (1080,4542,2);
insert into casting values (67,4543,4);
insert into casting values (322,4544,4);
insert into casting values (680,4545,4);
insert into casting values (1344,4546,4);
insert into casting values (390,4547,4);
insert into casting values (860,4548,5);
insert into casting values (1279,4549,3);
insert into casting values (1194,4550,5);
insert into casting values (1515,4551,5);
insert into casting values (24,4552,2);
insert into casting values (1097,4553,5);
insert into casting values (1834,4554,3);
insert into casting values (787,4555,5);
insert into casting values (912,4556,5);
insert into casting values (726,4557,2);
insert into casting values (1060,4558,3);
insert into casting values (945,4559,4);
insert into casting values (325,4560,5);
insert into casting values (1318,4561,3);
insert into casting values (257,4562,3);
insert into casting values (1434,4563,5);
insert into casting values (687,4564,5);
insert into casting values (450,4565,4);
insert into casting values (421,4566,4);
insert into casting values (1564,4567,4);
insert into casting values (1143,4568,2);
insert into casting values (1467,4569,5);
insert into casting values (1291,4570,2);
insert into casting values (847,4571,5);
insert into casting values (1720,4572,4);
insert into casting values (1428,4573,3);
insert into casting values (845,4574,7);
insert into casting values (1710,4574,9);
insert into casting values (1407,4575,6);
insert into casting values (1831,4575,9);
insert into casting values (930,4576,5);
insert into casting values (1137,4577,2);
insert into casting values (1360,4578,4);
insert into casting values (260,4579,7);
--- tabcasting, 13801, 50
insert into casting values (394,4579,9);
insert into casting values (801,4580,5);
insert into casting values (404,4581,4);
insert into casting values (1214,4582,4);
insert into casting values (578,4583,2);
insert into casting values (1089,4584,3);
insert into casting values (1094,4585,2);
insert into casting values (956,4586,4);
insert into casting values (158,4587,5);
insert into casting values (1191,4588,2);
insert into casting values (199,4589,5);
insert into casting values (1250,4590,4);
insert into casting values (721,4591,5);
insert into casting values (337,4592,3);
insert into casting values (1043,4593,2);
insert into casting values (565,4594,4);
insert into casting values (764,4595,7);
insert into casting values (543,4595,8);
insert into casting values (1552,4596,2);
insert into casting values (1013,4597,2);
insert into casting values (846,4598,2);
insert into casting values (798,4600,2);
insert into casting values (510,4601,3);
insert into casting values (577,4602,3);
insert into casting values (1143,4603,3);
insert into casting valu