"======================================================================
|
|   Smalltalk in Smalltalk compiler - code to enable the compiler
|
|
 ======================================================================"


"======================================================================
|
| Copyright 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"



"Final definitions to start the compiler..."

!FileStream methodsFor: 'file-in'!

fileIn
    STInST STSymbolTable nowInsideFileIn.
    (STInST STFileInParser onStream: self) parseSmalltalk.
    STInST STSymbolTable nowOutsideFileIn.
! !

!Behavior methodsFor: 'compiling'!

evalString: aString to: anObject
    ^(STInST STFileInParser onStream: (ReadStream on: aString))
	evalFor: anObject;
	parseSmalltalk;
	lastResult
!

evalString: aString to: anObject ifError: aBlock
    | parser |
    ^(parser := STInST STFileInParser onStream: (ReadStream on: aString))
	evalFor: anObject;
	parseErrorBlock: [ :f :l :m |
	    parser close.
	    ^aBlock value: f value: l value: m.
	];
	parseSmalltalk;
	lastResult
!

compileString: aString

    | codeWithHeader |
    codeWithHeader := '!%1 methodsFor: nil!%2! !'
	bindWith: self printString
	with: aString.

    ^(STInST STFileInParser onStream: (ReadStream on: codeWithHeader)) parseSmalltalk
!

compileString: aString ifError: aBlock
    | parser codeWithHeader |
    codeWithHeader := '!%1 methodsFor: nil!
%2! !'
	bindWith: self name
	with: aString.

    ^(parser := STInST STFileInParser onStream: (ReadStream on: codeWithHeader))
	parseErrorBlock: [ :f :l :m |
	    parser close.
	    ^aBlock value: f value: l - 1 value: m.
	];
	parseSmalltalk
!

basicMethodsFor: category ifTrue: condition
    "Compile the following code inside the receiver, with the given category,
     if condition is true; else ignore it - included just to be sure"
    <primitive: VMpr_Behavior_methodsForIfTrue>
    ^self primitiveFailed
!

methodsFor: aString
    self methodsFor: aString ifTrue: true
!

methodsFor: aString ifTrue: realCompile
    STInST STFileInParser
	methodsFor: aString
	parser: self parserClass
	compiler: (realCompile
	    ifTrue: [ self compilerClass ]
	    ifFalse: [ STInST STFakeCompiler ])
	class: self
! !
