/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.io;

import gnu.expr.CommandCompleter;
import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.kawa.io.CharArrayInPort;
import gnu.kawa.io.CheckConsole;
import gnu.kawa.io.OutPort;
import gnu.kawa.io.Path;
import gnu.kawa.io.TtyInPort;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.EOFError;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.terminal.impl.ExternalTerminal;

public class JLineInPort
extends TtyInPort
implements Completer,
Parser {
    LineReader jlreader;
    Terminal terminal;
    String prompt;
    SourceMessages messages;
    String stringRest;
    private int charsRest;
    Language language;

    public JLineInPort(InputStream in, Path name, OutPort tie) throws IOException {
        this(in, name, tie, TerminalBuilder.terminal());
    }

    private static Terminal makeTerminal(InputStream in, OutputStream out) throws IOException {
        ExternalTerminal terminal = new ExternalTerminal("Kawa", "xterm-256color", in, out, "UTF-8");
        terminal.getAttributes().setOutputFlag(Attributes.OutputFlag.ONLCR, true);
        terminal.getAttributes().setOutputFlag(Attributes.OutputFlag.OPOST, true);
        return terminal;
    }

    public JLineInPort(InputStream in, Path name, OutputStream out, OutPort tie) throws IOException {
        this(in, name, tie, JLineInPort.makeTerminal(in, out));
    }

    public JLineInPort(InputStream in, Path name, OutPort tie, Terminal terminal) throws IOException {
        super(in, name, tie);
        this.jlreader = LineReaderBuilder.builder().terminal(terminal).completer((Completer)this).parser((Parser)this).build();
        if (CheckConsole.useJLineMouse() > 0) {
            this.jlreader.setOpt(LineReader.Option.MOUSE);
        }
        this.terminal = terminal;
    }

    @Override
    public void setInDomTerm(boolean v) {
        super.setInDomTerm(v);
        if (v) {
            this.jlreader.setOpt(LineReader.Option.DELAY_LINE_WRAP);
        }
    }

    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        if (context == Parser.ParseContext.COMPLETE) {
            return this.parseForComplete(line, cursor);
        }
        CharArrayInPort cin = CharArrayInPort.make(line, "\n");
        cin.setLineNumber(this.getLineNumber());
        cin.setPath(this.getPath());
        if (this.language == null) {
            return new KawaParsedLine(this, line, cursor);
        }
        try {
            Lexer lexer = this.language.getLexer(cin, this.messages);
            lexer.setInteractive(true);
            Compilation comp = this.language.parse(lexer, 131, null);
            if (comp == null) {
                throw new EndOfFileException();
            }
            if (comp.getState() == 100 && cin.eofSeen()) {
                this.messages.clear();
                throw new EOFError(-1, -1, "unexpected end-of-file", "");
            }
            return new KawaParsedLine(this, line, cursor, comp);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    ParsedLine parseForComplete(String line, int cursor) throws SyntaxError {
        int buflen = line.length();
        char[] tbuf = new char[buflen + 1];
        line.getChars(0, cursor, tbuf, 0);
        tbuf[cursor] = 61698;
        line.getChars(cursor, buflen, tbuf, cursor + 1);
        CharArrayInPort cin = new CharArrayInPort(tbuf);
        try {
            SourceMessages messages = new SourceMessages();
            Lexer lexer = this.language.getLexer(cin, messages);
            lexer.setInteractive(true);
            lexer.setTentative(true);
            Compilation comp = this.language.parse(lexer, 131, null);
            this.language.resolve(comp);
            return new KawaParsedLine(this, line, cursor, comp);
        }
        catch (SyntaxException ex) {
            if (cin.eofSeen()) {
                throw new EOFError(-1, -1, "unexpected end-of-file", "");
            }
            throw ex;
        }
        catch (CommandCompleter ex) {
            return new KawaParsedLine(this, line, cursor, ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
        KawaParsedLine kline = (KawaParsedLine)commandLine;
        if (kline.ex != null) {
            CommandCompleter ex = kline.ex;
            Collections.sort(ex.candidates);
            kline.word = ex.word;
            kline.wordCursor = ex.wordCursor;
            for (CharSequence charSequence : ex.candidates) {
                String str = charSequence.toString();
                candidates.add(new Candidate(str, str, null, null, null, null, true));
            }
        }
    }

    @Override
    protected int fill(int len) throws IOException {
        int count;
        String line;
        if (this.charsRest > 0) {
            line = this.stringRest;
        } else {
            try {
                line = this.jlreader.readLine(this.prompt, null, null, null);
            }
            catch (UserInterruptException ex) {
                return -1;
            }
            catch (EndOfFileException ex) {
                this.promptEmitted = false;
                return -1;
            }
            if (line == null) {
                return -1;
            }
            this.charsRest = line.length();
        }
        int start = line.length() - this.charsRest;
        if (this.charsRest < len) {
            line.getChars(start, line.length(), this.buffer, this.pos);
            this.buffer[this.pos + this.charsRest] = 10;
            count = this.charsRest + 1;
            this.charsRest = 0;
            this.stringRest = null;
        } else {
            line.getChars(start, start + len, this.buffer, this.pos);
            this.stringRest = line;
            this.charsRest -= len;
            count = len;
        }
        this.afterFill(count);
        return count;
    }

    @Override
    public String promptTemplate1() {
        return this.maybeColorizePrompt(super.promptTemplate1());
    }

    @Override
    public String promptTemplate2() {
        return this.maybeColorizePrompt(super.promptTemplate2());
    }

    public String maybeColorizePrompt(String prompt) {
        if (prompt.indexOf(27) < 0 && prompt.indexOf("%{") < 0) {
            prompt = "\u001b[48;5;194m" + prompt + "\u001b[0m";
        }
        return prompt;
    }

    @Override
    public void emitPrompt(String prompt) throws IOException {
        this.prompt = prompt;
    }

    @Override
    public String expandPrompt(String pattern, int padToWidth, int line, String message, int[] width) {
        return pattern;
    }

    public void setSize(int ncols, int nrows) {
        Terminal term = this.terminal;
        if (term != null) {
            term.setSize(new Size(ncols, nrows));
        }
    }

    public static class KawaParsedLine
    implements ParsedLine {
        JLineInPort inp;
        Compilation comp;
        String source;
        int cursor;
        String word;
        int wordCursor;
        CommandCompleter ex;

        public KawaParsedLine(JLineInPort inp, String source, int cursor) {
            this.inp = inp;
            this.source = source;
            this.cursor = cursor;
            this.word = "";
        }

        public KawaParsedLine(JLineInPort inp, String source, int cursor, Compilation comp) {
            this.inp = inp;
            this.comp = comp;
            this.source = source;
            this.cursor = cursor;
            this.word = "";
        }

        public KawaParsedLine(JLineInPort inp, String source, int cursor, CommandCompleter ex) {
            this.inp = inp;
            this.comp = ex.getCompilation();
            this.source = source;
            this.cursor = cursor;
            this.ex = ex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Compilation parse(Language language, Lexer lexer) throws IOException {
            String prompt;
            int opts = 135;
            JLineInPort inp = (JLineInPort)lexer.getPort();
            if (inp.tie != null) {
                inp.tie.freshLine();
            }
            int line = inp.getLineNumber() + 1;
            Object p = null;
            char saveState = inp.getReadState();
            inp.readState = (char)32;
            try {
                if (inp.prompter != null) {
                    p = inp.prompter.apply1(inp);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            inp.prompt = prompt = p == null ? "[" + line + "] " : p.toString();
            LineReader jlreader = inp.jlreader;
            jlreader.setVariable("line-offset", (Object)line);
            String pattern2 = inp.promptTemplate2();
            jlreader.setVariable("secondary-prompt-pattern", (Object)pattern2);
            inp.readState = saveState;
            inp.messages = lexer.getMessages();
            Language saveLanguage = inp.language;
            inp.language = language;
            try {
                jlreader.readLine(inp.prompt, null, null, null);
                if (inp.tie != null) {
                    inp.tie.setColumnNumber(0);
                }
                KawaParsedLine parsedLine = (KawaParsedLine)jlreader.getParsedLine();
                inp.setLineNumber(line - 1 + parsedLine.lineCount());
                Compilation compilation = parsedLine.comp;
                return compilation;
            }
            catch (EndOfFileException ex) {
                Compilation compilation = null;
                return compilation;
            }
            finally {
                inp.language = saveLanguage;
            }
        }

        public String word() {
            return this.word;
        }

        public int wordCursor() {
            return this.wordCursor;
        }

        public int wordIndex() {
            return 0;
        }

        public List<String> words() {
            return null;
        }

        public String line() {
            return this.source;
        }

        public int lineCount() {
            int n = 1;
            int i = 0;
            while ((i = this.source.indexOf(10, i) + 1) > 0) {
                ++n;
            }
            return n;
        }

        public int cursor() {
            return this.cursor;
        }
    }
}

