/*
  File autogenerated by gengetopt version 2.22.2
  generated with the following command:
  ../src/gengetopt --input=cmdline.ggo --no-handle-version --no-handle-help --no-handle-error --string-parser

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include "getopt.h"

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "This program generates a C function that uses getopt_long function\nto parse the command line options, validate them and fill a struct.";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTIONS]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_detailed_help[] = {
  "  -h, --help                    Print help and exit",
  "      --detailed-help           Print help, including all details and hidden \n                                  options, and exit",
  "  -V, --version                 Print version and exit",
  "\nMain options:",
  "",
  "  -i, --input=filename          input file (default std input)",
  "  -f, --func-name=name          name of generated function  \n                                  (default=`cmdline_parser')",
  "  -a, --arg-struct-name=name    name of generated args info struct  \n                                  (default=`gengetopt_args_info')",
  "  -F, --file-name=name          name of generated file  (default=`cmdline')",
  "      --output-dir=path         output directory",
  "  \n  if this option is not specified, the files are generated in the current \n  directory.\n",
  "  -c, --c-extension=ext         extension of c file  (default=`c')",
  "  -H, --header-extension=ext    extension of header file  (default=`h')",
  "  -l, --long-help               long usage line in help",
  "  \n  The usage line will print all the options, e.g.,\n\n  sample1 -iINT|--int-opt=INT [-h|--help]\n",
  "      --default-optional        by default, an option is considered optional if \n                                  not specified otherwise",
  "  -u, --unamed-opts[=STRING]    accept options without names (e.g., file names) \n                                   (default=`FILES')",
  "\nThe parser generated is thought to be used to parse the command line arguments. \nHowever, you can also generate parsers for configuration files, or strings that \ncontain the arguments to parse, by using the following two options.\n",
  "  -C, --conf-parser             generate a config file parser",
  "  -S, --string-parser           generate a string parser (the string contains \n                                  the command line)",
  "\nAdditional options:",
  "",
  "  -G, --include-getopt          adds the code for getopt_long in the generated \n                                  C file",
  "  -n, --no-handle-help          do not handle --help|-h automatically",
  "  \n  If --no-handle-help is specified, the command line option --help|-h will not \n  be handled automatically, so the programmer will be able to print some other \n  information; then the function for printing the standard help output can be \n  used; this function is called <parser-name>_print_help.\n  \n  Notice that, although the programmer can handle --help|-h manually, the \n  parser will return after finding such option: the other command line options, \n  if any, will be ignored.  In case you want to have full control on --help|-h, \n  you should use --ho-help.\n",
  "      --no-help                 do not add --help|-h automatically",
  "  \n  With this option you can disable the automatic addition of options --help|-h. \n  The programmer will then be able to add this option in the input file and \n  handle it as he sees fit.  Notice that --no-help will also disable the \n  automatic options --detailed-help and --full-help.\n\n  The programmer can still define options with short character h as he wants, \n  but he cannot define options help, unless he specifies --no-help (otherwise \n  an error will be printed).\n",
  "  -N, --no-handle-version       do not handle --version|-V automatically",
  "      --no-version              do not add --version|-V automatically",
  "  \n  See above the details about --no-handle-help and --no-help, respectively.\n",
  "  -e, --no-handle-error         do not exit on errors",
  "  \n  With this option, if the generated parser encounters an error (e.g., an \n  unknown option) it does not make the main program exit; instead, the parser \n  function returns a value different 0, and the main program can print a help \n  message.\n",
  "      --show-required[=STRING]  in the output of help will specify which \n                                  options are mandatory, by using the optional \n                                  passed string  (default=`(mandatory)')",
  "  -g, --gen-version             put gengetopt version in the generated file  \n                                  (default=on)",
  "      --set-package=STRING      set the package name (override package defined \n                                  in the .ggo file)",
  "      --set-version=STRING      set the version number (override version \n                                  defined in the .ggo file)",
  "      --show-help               show the output of --help instead of generating \n                                  code",
  "      --show-full-help          show the output of --full-help (i.e., including \n                                  hidden options) instead of generating code",
  "      --show-detailed-help      show the output of --detailed-help (i.e., \n                                  including details and hidden options) instead \n                                  of generating code",
  "      --show-version            show the output of --version instead of \n                                  generating code",
  "\nPlease refer to the info manual for further explanations.",
    0
};

static void
init_help_array(void)
{
  gengetopt_args_info_help[0] = gengetopt_args_info_detailed_help[0];
  gengetopt_args_info_help[1] = gengetopt_args_info_detailed_help[1];
  gengetopt_args_info_help[2] = gengetopt_args_info_detailed_help[2];
  gengetopt_args_info_help[3] = gengetopt_args_info_detailed_help[3];
  gengetopt_args_info_help[4] = gengetopt_args_info_detailed_help[4];
  gengetopt_args_info_help[5] = gengetopt_args_info_detailed_help[5];
  gengetopt_args_info_help[6] = gengetopt_args_info_detailed_help[6];
  gengetopt_args_info_help[7] = gengetopt_args_info_detailed_help[7];
  gengetopt_args_info_help[8] = gengetopt_args_info_detailed_help[8];
  gengetopt_args_info_help[9] = gengetopt_args_info_detailed_help[9];
  gengetopt_args_info_help[10] = gengetopt_args_info_detailed_help[11];
  gengetopt_args_info_help[11] = gengetopt_args_info_detailed_help[12];
  gengetopt_args_info_help[12] = gengetopt_args_info_detailed_help[13];
  gengetopt_args_info_help[13] = gengetopt_args_info_detailed_help[15];
  gengetopt_args_info_help[14] = gengetopt_args_info_detailed_help[16];
  gengetopt_args_info_help[15] = gengetopt_args_info_detailed_help[17];
  gengetopt_args_info_help[16] = gengetopt_args_info_detailed_help[18];
  gengetopt_args_info_help[17] = gengetopt_args_info_detailed_help[19];
  gengetopt_args_info_help[18] = gengetopt_args_info_detailed_help[20];
  gengetopt_args_info_help[19] = gengetopt_args_info_detailed_help[21];
  gengetopt_args_info_help[20] = gengetopt_args_info_detailed_help[22];
  gengetopt_args_info_help[21] = gengetopt_args_info_detailed_help[23];
  gengetopt_args_info_help[22] = gengetopt_args_info_detailed_help[25];
  gengetopt_args_info_help[23] = gengetopt_args_info_detailed_help[27];
  gengetopt_args_info_help[24] = gengetopt_args_info_detailed_help[28];
  gengetopt_args_info_help[25] = gengetopt_args_info_detailed_help[30];
  gengetopt_args_info_help[26] = gengetopt_args_info_detailed_help[32];
  gengetopt_args_info_help[27] = gengetopt_args_info_detailed_help[33];
  gengetopt_args_info_help[28] = gengetopt_args_info_detailed_help[34];
  gengetopt_args_info_help[29] = gengetopt_args_info_detailed_help[35];
  gengetopt_args_info_help[30] = gengetopt_args_info_detailed_help[36];
  gengetopt_args_info_help[31] = gengetopt_args_info_detailed_help[37];
  gengetopt_args_info_help[32] = gengetopt_args_info_detailed_help[38];
  gengetopt_args_info_help[33] = gengetopt_args_info_detailed_help[39];
  gengetopt_args_info_help[34] = gengetopt_args_info_detailed_help[40];
  gengetopt_args_info_help[35] = 0; 
  
}

const char *gengetopt_args_info_help[36];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

struct line_list
{
  char * string_arg;
  struct line_list * next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void
free_cmd_list(void)
{
  /* free the list of a previous call */
  if (cmd_line_list)
    {
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->detailed_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->input_given = 0 ;
  args_info->func_name_given = 0 ;
  args_info->arg_struct_name_given = 0 ;
  args_info->file_name_given = 0 ;
  args_info->output_dir_given = 0 ;
  args_info->c_extension_given = 0 ;
  args_info->header_extension_given = 0 ;
  args_info->long_help_given = 0 ;
  args_info->default_optional_given = 0 ;
  args_info->unamed_opts_given = 0 ;
  args_info->conf_parser_given = 0 ;
  args_info->string_parser_given = 0 ;
  args_info->include_getopt_given = 0 ;
  args_info->no_handle_help_given = 0 ;
  args_info->no_help_given = 0 ;
  args_info->no_handle_version_given = 0 ;
  args_info->no_version_given = 0 ;
  args_info->no_handle_error_given = 0 ;
  args_info->show_required_given = 0 ;
  args_info->gen_version_given = 0 ;
  args_info->set_package_given = 0 ;
  args_info->set_version_given = 0 ;
  args_info->show_help_given = 0 ;
  args_info->show_full_help_given = 0 ;
  args_info->show_detailed_help_given = 0 ;
  args_info->show_version_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->input_arg = NULL;
  args_info->input_orig = NULL;
  args_info->func_name_arg = gengetopt_strdup ("cmdline_parser");
  args_info->func_name_orig = NULL;
  args_info->arg_struct_name_arg = gengetopt_strdup ("gengetopt_args_info");
  args_info->arg_struct_name_orig = NULL;
  args_info->file_name_arg = gengetopt_strdup ("cmdline");
  args_info->file_name_orig = NULL;
  args_info->output_dir_arg = NULL;
  args_info->output_dir_orig = NULL;
  args_info->c_extension_arg = gengetopt_strdup ("c");
  args_info->c_extension_orig = NULL;
  args_info->header_extension_arg = gengetopt_strdup ("h");
  args_info->header_extension_orig = NULL;
  args_info->unamed_opts_arg = gengetopt_strdup ("FILES");
  args_info->unamed_opts_orig = NULL;
  args_info->show_required_arg = gengetopt_strdup ("(mandatory)");
  args_info->show_required_orig = NULL;
  args_info->gen_version_flag = 1;
  args_info->set_package_arg = NULL;
  args_info->set_package_orig = NULL;
  args_info->set_version_arg = NULL;
  args_info->set_version_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{

  init_help_array(); 
  args_info->help_help = gengetopt_args_info_detailed_help[0] ;
  args_info->detailed_help_help = gengetopt_args_info_detailed_help[1] ;
  args_info->version_help = gengetopt_args_info_detailed_help[2] ;
  args_info->input_help = gengetopt_args_info_detailed_help[5] ;
  args_info->func_name_help = gengetopt_args_info_detailed_help[6] ;
  args_info->arg_struct_name_help = gengetopt_args_info_detailed_help[7] ;
  args_info->file_name_help = gengetopt_args_info_detailed_help[8] ;
  args_info->output_dir_help = gengetopt_args_info_detailed_help[9] ;
  args_info->c_extension_help = gengetopt_args_info_detailed_help[11] ;
  args_info->header_extension_help = gengetopt_args_info_detailed_help[12] ;
  args_info->long_help_help = gengetopt_args_info_detailed_help[13] ;
  args_info->default_optional_help = gengetopt_args_info_detailed_help[15] ;
  args_info->unamed_opts_help = gengetopt_args_info_detailed_help[16] ;
  args_info->conf_parser_help = gengetopt_args_info_detailed_help[18] ;
  args_info->string_parser_help = gengetopt_args_info_detailed_help[19] ;
  args_info->include_getopt_help = gengetopt_args_info_detailed_help[22] ;
  args_info->no_handle_help_help = gengetopt_args_info_detailed_help[23] ;
  args_info->no_help_help = gengetopt_args_info_detailed_help[25] ;
  args_info->no_handle_version_help = gengetopt_args_info_detailed_help[27] ;
  args_info->no_version_help = gengetopt_args_info_detailed_help[28] ;
  args_info->no_handle_error_help = gengetopt_args_info_detailed_help[30] ;
  args_info->show_required_help = gengetopt_args_info_detailed_help[32] ;
  args_info->gen_version_help = gengetopt_args_info_detailed_help[33] ;
  args_info->set_package_help = gengetopt_args_info_detailed_help[34] ;
  args_info->set_version_help = gengetopt_args_info_detailed_help[35] ;
  args_info->show_help_help = gengetopt_args_info_detailed_help[36] ;
  args_info->show_full_help_help = gengetopt_args_info_detailed_help[37] ;
  args_info->show_detailed_help_help = gengetopt_args_info_detailed_help[38] ;
  args_info->show_version_help = gengetopt_args_info_detailed_help[39] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_print_detailed_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_detailed_help[i])
    printf("%s\n", gengetopt_args_info_detailed_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->input_arg));
  free_string_field (&(args_info->input_orig));
  free_string_field (&(args_info->func_name_arg));
  free_string_field (&(args_info->func_name_orig));
  free_string_field (&(args_info->arg_struct_name_arg));
  free_string_field (&(args_info->arg_struct_name_orig));
  free_string_field (&(args_info->file_name_arg));
  free_string_field (&(args_info->file_name_orig));
  free_string_field (&(args_info->output_dir_arg));
  free_string_field (&(args_info->output_dir_orig));
  free_string_field (&(args_info->c_extension_arg));
  free_string_field (&(args_info->c_extension_orig));
  free_string_field (&(args_info->header_extension_arg));
  free_string_field (&(args_info->header_extension_orig));
  free_string_field (&(args_info->unamed_opts_arg));
  free_string_field (&(args_info->unamed_opts_orig));
  free_string_field (&(args_info->show_required_arg));
  free_string_field (&(args_info->show_required_orig));
  free_string_field (&(args_info->set_package_arg));
  free_string_field (&(args_info->set_package_orig));
  free_string_field (&(args_info->set_version_arg));
  free_string_field (&(args_info->set_version_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->detailed_help_given)
    write_into_file(outfile, "detailed-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->input_given)
    write_into_file(outfile, "input", args_info->input_orig, 0);
  if (args_info->func_name_given)
    write_into_file(outfile, "func-name", args_info->func_name_orig, 0);
  if (args_info->arg_struct_name_given)
    write_into_file(outfile, "arg-struct-name", args_info->arg_struct_name_orig, 0);
  if (args_info->file_name_given)
    write_into_file(outfile, "file-name", args_info->file_name_orig, 0);
  if (args_info->output_dir_given)
    write_into_file(outfile, "output-dir", args_info->output_dir_orig, 0);
  if (args_info->c_extension_given)
    write_into_file(outfile, "c-extension", args_info->c_extension_orig, 0);
  if (args_info->header_extension_given)
    write_into_file(outfile, "header-extension", args_info->header_extension_orig, 0);
  if (args_info->long_help_given)
    write_into_file(outfile, "long-help", 0, 0 );
  if (args_info->default_optional_given)
    write_into_file(outfile, "default-optional", 0, 0 );
  if (args_info->unamed_opts_given)
    write_into_file(outfile, "unamed-opts", args_info->unamed_opts_orig, 0);
  if (args_info->conf_parser_given)
    write_into_file(outfile, "conf-parser", 0, 0 );
  if (args_info->string_parser_given)
    write_into_file(outfile, "string-parser", 0, 0 );
  if (args_info->include_getopt_given)
    write_into_file(outfile, "include-getopt", 0, 0 );
  if (args_info->no_handle_help_given)
    write_into_file(outfile, "no-handle-help", 0, 0 );
  if (args_info->no_help_given)
    write_into_file(outfile, "no-help", 0, 0 );
  if (args_info->no_handle_version_given)
    write_into_file(outfile, "no-handle-version", 0, 0 );
  if (args_info->no_version_given)
    write_into_file(outfile, "no-version", 0, 0 );
  if (args_info->no_handle_error_given)
    write_into_file(outfile, "no-handle-error", 0, 0 );
  if (args_info->show_required_given)
    write_into_file(outfile, "show-required", args_info->show_required_orig, 0);
  if (args_info->gen_version_given)
    write_into_file(outfile, "gen-version", 0, 0 );
  if (args_info->set_package_given)
    write_into_file(outfile, "set-package", args_info->set_package_orig, 0);
  if (args_info->set_version_given)
    write_into_file(outfile, "set-version", args_info->set_version_orig, 0);
  if (args_info->show_help_given)
    write_into_file(outfile, "show-help", 0, 0 );
  if (args_info->show_full_help_given)
    write_into_file(outfile, "show-full-help", 0, 0 );
  if (args_info->show_detailed_help_given)
    write_into_file(outfile, "show-detailed-help", 0, 0 );
  if (args_info->show_version_given)
    write_into_file(outfile, "show-version", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  return result;
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  FIX_UNUSED (field);
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };


  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "detailed-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "input",	1, NULL, 'i' },
        { "func-name",	1, NULL, 'f' },
        { "arg-struct-name",	1, NULL, 'a' },
        { "file-name",	1, NULL, 'F' },
        { "output-dir",	1, NULL, 0 },
        { "c-extension",	1, NULL, 'c' },
        { "header-extension",	1, NULL, 'H' },
        { "long-help",	0, NULL, 'l' },
        { "default-optional",	0, NULL, 0 },
        { "unamed-opts",	2, NULL, 'u' },
        { "conf-parser",	0, NULL, 'C' },
        { "string-parser",	0, NULL, 'S' },
        { "include-getopt",	0, NULL, 'G' },
        { "no-handle-help",	0, NULL, 'n' },
        { "no-help",	0, NULL, 0 },
        { "no-handle-version",	0, NULL, 'N' },
        { "no-version",	0, NULL, 0 },
        { "no-handle-error",	0, NULL, 'e' },
        { "show-required",	2, NULL, 0 },
        { "gen-version",	0, NULL, 'g' },
        { "set-package",	1, NULL, 0 },
        { "set-version",	1, NULL, 0 },
        { "show-help",	0, NULL, 0 },
        { "show-full-help",	0, NULL, 0 },
        { "show-detailed-help",	0, NULL, 0 },
        { "show-version",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVi:f:a:F:c:H:lu::CSGnNeg", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->help_given),
              &(local_args_info.help_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "help", 'h',
              additional_error))
            goto failure;
          cmdline_parser_free (&local_args_info);
          return 0;
        
          break;
        case 'V':	/* Print version and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->version_given),
              &(local_args_info.version_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "version", 'V',
              additional_error))
            goto failure;
          cmdline_parser_free (&local_args_info);
          return 0;
        
          break;
        case 'i':	/* input file (default std input).  */
        
        
          if (update_arg( (void *)&(args_info->input_arg), 
               &(args_info->input_orig), &(args_info->input_given),
              &(local_args_info.input_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "input", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* name of generated function.  */
        
        
          if (update_arg( (void *)&(args_info->func_name_arg), 
               &(args_info->func_name_orig), &(args_info->func_name_given),
              &(local_args_info.func_name_given), optarg, 0, "cmdline_parser", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "func-name", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* name of generated args info struct.  */
        
        
          if (update_arg( (void *)&(args_info->arg_struct_name_arg), 
               &(args_info->arg_struct_name_orig), &(args_info->arg_struct_name_given),
              &(local_args_info.arg_struct_name_given), optarg, 0, "gengetopt_args_info", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "arg-struct-name", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'F':	/* name of generated file.  */
        
        
          if (update_arg( (void *)&(args_info->file_name_arg), 
               &(args_info->file_name_orig), &(args_info->file_name_given),
              &(local_args_info.file_name_given), optarg, 0, "cmdline", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "file-name", 'F',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* extension of c file.  */
        
        
          if (update_arg( (void *)&(args_info->c_extension_arg), 
               &(args_info->c_extension_orig), &(args_info->c_extension_given),
              &(local_args_info.c_extension_given), optarg, 0, "c", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "c-extension", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'H':	/* extension of header file.  */
        
        
          if (update_arg( (void *)&(args_info->header_extension_arg), 
               &(args_info->header_extension_orig), &(args_info->header_extension_given),
              &(local_args_info.header_extension_given), optarg, 0, "h", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "header-extension", 'H',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* long usage line in help.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->long_help_given),
              &(local_args_info.long_help_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "long-help", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'u':	/* accept options without names (e.g., file names).  */
        
        
          if (update_arg( (void *)&(args_info->unamed_opts_arg), 
               &(args_info->unamed_opts_orig), &(args_info->unamed_opts_given),
              &(local_args_info.unamed_opts_given), optarg, 0, "FILES", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "unamed-opts", 'u',
              additional_error))
            goto failure;
        
          break;
        case 'C':	/* generate a config file parser.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->conf_parser_given),
              &(local_args_info.conf_parser_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "conf-parser", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* generate a string parser (the string contains the command line).  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->string_parser_given),
              &(local_args_info.string_parser_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "string-parser", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'G':	/* adds the code for getopt_long in the generated C file.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->include_getopt_given),
              &(local_args_info.include_getopt_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "include-getopt", 'G',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* do not handle --help|-h automatically.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->no_handle_help_given),
              &(local_args_info.no_handle_help_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "no-handle-help", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'N':	/* do not handle --version|-V automatically.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->no_handle_version_given),
              &(local_args_info.no_handle_version_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "no-handle-version", 'N',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* do not exit on errors.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->no_handle_error_given),
              &(local_args_info.no_handle_error_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "no-handle-error", 'e',
              additional_error))
            goto failure;
        
          break;
        case 'g':	/* put gengetopt version in the generated file.  */
        
        
          if (update_arg((void *)&(args_info->gen_version_flag), 0, &(args_info->gen_version_given),
              &(local_args_info.gen_version_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "gen-version", 'g',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Print help, including all details and hidden options, and exit.  */
          if (strcmp (long_options[option_index].name, "detailed-help") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->detailed_help_given),
                &(local_args_info.detailed_help_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "detailed-help", '-',
                additional_error))
              goto failure;
            cmdline_parser_free (&local_args_info);
            return 0;
          
          }
          /* output directory.  */
          else if (strcmp (long_options[option_index].name, "output-dir") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->output_dir_arg), 
                 &(args_info->output_dir_orig), &(args_info->output_dir_given),
                &(local_args_info.output_dir_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "output-dir", '-',
                additional_error))
              goto failure;
          
          }
          /* by default, an option is considered optional if not specified otherwise.  */
          else if (strcmp (long_options[option_index].name, "default-optional") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->default_optional_given),
                &(local_args_info.default_optional_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "default-optional", '-',
                additional_error))
              goto failure;
          
          }
          /* do not add --help|-h automatically.  */
          else if (strcmp (long_options[option_index].name, "no-help") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->no_help_given),
                &(local_args_info.no_help_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "no-help", '-',
                additional_error))
              goto failure;
          
          }
          /* do not add --version|-V automatically.  */
          else if (strcmp (long_options[option_index].name, "no-version") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->no_version_given),
                &(local_args_info.no_version_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "no-version", '-',
                additional_error))
              goto failure;
          
          }
          /* in the output of help will specify which options are mandatory, by using the optional passed string.  */
          else if (strcmp (long_options[option_index].name, "show-required") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->show_required_arg), 
                 &(args_info->show_required_orig), &(args_info->show_required_given),
                &(local_args_info.show_required_given), optarg, 0, "(mandatory)", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "show-required", '-',
                additional_error))
              goto failure;
          
          }
          /* set the package name (override package defined in the .ggo file).  */
          else if (strcmp (long_options[option_index].name, "set-package") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->set_package_arg), 
                 &(args_info->set_package_orig), &(args_info->set_package_given),
                &(local_args_info.set_package_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "set-package", '-',
                additional_error))
              goto failure;
          
          }
          /* set the version number (override version defined in the .ggo file).  */
          else if (strcmp (long_options[option_index].name, "set-version") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->set_version_arg), 
                 &(args_info->set_version_orig), &(args_info->set_version_given),
                &(local_args_info.set_version_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "set-version", '-',
                additional_error))
              goto failure;
          
          }
          /* show the output of --help instead of generating code.  */
          else if (strcmp (long_options[option_index].name, "show-help") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->show_help_given),
                &(local_args_info.show_help_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "show-help", '-',
                additional_error))
              goto failure;
          
          }
          /* show the output of --full-help (i.e., including hidden options) instead of generating code.  */
          else if (strcmp (long_options[option_index].name, "show-full-help") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->show_full_help_given),
                &(local_args_info.show_full_help_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "show-full-help", '-',
                additional_error))
              goto failure;
          
          }
          /* show the output of --detailed-help (i.e., including details and hidden options) instead of generating code.  */
          else if (strcmp (long_options[option_index].name, "show-detailed-help") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->show_detailed_help_given),
                &(local_args_info.show_detailed_help_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "show-detailed-help", '-',
                additional_error))
              goto failure;
          
          }
          /* show the output of --version instead of generating code.  */
          else if (strcmp (long_options[option_index].name, "show-version") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->show_version_given),
                &(local_args_info.show_version_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "show-version", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

static unsigned int
cmdline_parser_create_argv(const char *cmdline_, char ***argv_ptr, const char *prog_name)
{
  char *cmdline, *p;
  size_t n = 0, j;
  int i;

  if (prog_name) {
    cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
    cmd_line_list_tmp->next = cmd_line_list;
    cmd_line_list = cmd_line_list_tmp;
    cmd_line_list->string_arg = gengetopt_strdup (prog_name);

    ++n;
  }

  cmdline = gengetopt_strdup(cmdline_);
  p = cmdline;

  while (p && strlen(p))
    {
      j = strcspn(p, " \t");
      ++n;
      if (j && j < strlen(p))
        {
          p[j] = '\0';

          cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
          cmd_line_list_tmp->next = cmd_line_list;
          cmd_line_list = cmd_line_list_tmp;
          cmd_line_list->string_arg = gengetopt_strdup (p);

          p += (j+1);
          p += strspn(p, " \t");
        }
      else
        {
          cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
          cmd_line_list_tmp->next = cmd_line_list;
          cmd_line_list = cmd_line_list_tmp;
          cmd_line_list->string_arg = gengetopt_strdup (p);

          break;
        }
    }

  *argv_ptr = (char **) malloc((n + 1) * sizeof(char *));
  cmd_line_list_tmp = cmd_line_list;
  for (i = (n-1); i >= 0; --i)
    {
      (*argv_ptr)[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

  (*argv_ptr)[n] = 0;

  free(cmdline);
  return n;
}

int
cmdline_parser_string(const char *cmdline, struct gengetopt_args_info *args_info, const char *prog_name)
{
  return cmdline_parser_string2(cmdline, args_info, prog_name, 0, 1, 1);
}

int
cmdline_parser_string2(const char *cmdline, struct gengetopt_args_info *args_info, const char *prog_name,
    int override, int initialize, int check_required)
{
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  return cmdline_parser_string_ext(cmdline, args_info, prog_name, &params);
}

int
cmdline_parser_string_ext(const char *cmdline, struct gengetopt_args_info *args_info, const char *prog_name,
    struct cmdline_parser_params *params)
{
  char **argv_ptr = 0;
  int result;
  unsigned int argc;
  
  argc = cmdline_parser_create_argv(cmdline, &argv_ptr, prog_name);
  
  result =
    cmdline_parser_internal (argc, argv_ptr, args_info, params, 0);
  
  if (argv_ptr)
    {
      free (argv_ptr);
    }

  free_cmd_list();
  
  return result;
}

