/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Equipment;
import com.sun.electric.tool.simulation.test.Infrastructure;

public class T2500
extends Equipment {
    public T2500(String name) {
        super(name);
        T2500.logInit("Initialized T2500 Temperature Forcer named " + name);
    }

    public float getAirTemp() {
        this.write("AIRTEMP?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public float getDeviceTemp() {
        this.write("DUTTEMP?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public float getSoakTime() {
        this.write("SOAKTIME?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public float getSetpoint() {
        this.write("SETPOINT?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public float getStatus() {
        this.write("TESR?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public boolean getHeadState() {
        this.write("HEAD?");
        String[] s2 = this.read(40).split(" ");
        return Boolean.valueOf(s2[0]);
    }

    public void headDown(boolean state) {
        if (state) {
            this.write("HEAD 0");
        } else {
            this.write("HEAD 1");
        }
    }

    public boolean getCompressorState() {
        this.write("COMP?");
        String[] s2 = this.read(40).split(" ");
        return Boolean.valueOf(s2[0]);
    }

    public void setCompressorState(boolean state) {
        if (state) {
            this.write("COMP 1");
        } else {
            this.write("COMP 0");
        }
    }

    public void setTemp(int presetNum, float value) {
        this.write("TEMP" + presetNum + " " + value);
    }

    public float getTemp(int presetNum) {
        this.write("TEMP" + presetNum + "?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public void goTemp(int presetNum) {
        this.write("GOTEMP" + presetNum);
    }

    public void setSoakTime(int presetNum, float soakTime) {
        this.write("SOAK" + presetNum + " " + soakTime);
    }

    public float getSoakTime(int presetNum) {
        this.write("SOAK" + presetNum + "?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public void airOff() {
        this.write("AIROFF");
    }

    public void setBoost(int level) {
        this.write("BOOST " + level);
    }

    public float getBoostLevel() {
        this.write("BOOST?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public void setColdFlow(int value) {
        this.write("COLDFLOW " + value);
    }

    public float getColdFlow() {
        this.write("COLDFLOW?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public void setHotFlow(int value) {
        this.write("HOTFLOW " + value);
    }

    public float getHotFlow() {
        this.write("HOTFLOW?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public void setRampState(boolean state) {
        if (state) {
            this.write("RAMP 1");
        } else {
            this.write("RAMP 0");
        }
    }

    public boolean getRampState() {
        this.write("RAMP?");
        String[] s2 = this.read(40).split(" ");
        return Boolean.valueOf(s2[0]);
    }

    public void setRampRate(int value) {
        this.write("RAMPRATE " + value);
    }

    public float getRampRate() {
        this.write("RAMPRATE?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public void setTempSensing(int value) {
        this.write("TCONTROL " + value);
    }

    public float getTempSensingMode() {
        this.write("TCONTROL?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public void setTempTolerance(float value) {
        this.write("TEMPTOL " + value);
    }

    public float getTempTol() {
        this.write("TEMPTOL?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public void setMinTemp(float value) {
        this.write("MINTEMP " + value);
    }

    public float getMinTemp() {
        this.write("MINTEMP?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public void setMaxTemp(float value) {
        this.write("MAXTEMP " + value);
    }

    public float getMaxTemp() {
        this.write("MAXTEMP?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public String test() {
        this.write("FLOW?");
        return this.read(40);
    }

    public float getFlow() {
        this.write("FLOW?");
        String[] s2 = this.read(40).split(" ");
        return Float.parseFloat(s2[0]);
    }

    public static void main(String[] args) {
        int[] gpibController = new int[]{0};
        Infrastructure.gpibControllers = gpibController;
        T2500 DUT = new T2500("T2500");
        DUT.airOff();
        DUT.setMaxTemp(150.0f);
        DUT.setMinTemp(-60.0f);
        System.out.println("Min Temp: " + DUT.getMinTemp());
        System.out.println("Max Temp: " + DUT.getMaxTemp());
    }
}

