/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.Mos;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Resistor;
import com.sun.electric.tool.ncc.netlist.Subcircuit;
import com.sun.electric.tool.ncc.result.SizeMismatch;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StratCheckSizes
extends Strategy {
    private NccOptions options;
    private double minWidth;
    private double maxWidth;
    private double minLength;
    private double maxLength;
    private Part minWidPart;
    private Part maxWidPart;
    private Part minLenPart;
    private Part maxLenPart;
    private List<SizeMismatch.Mismatch> mismatches = new ArrayList<SizeMismatch.Mismatch>();
    private int cktNdx;
    private int minWidNdx;
    private int maxWidNdx;
    private int minLenNdx;
    private int maxLenNdx;

    private StratCheckSizes(NccGlobals globals) {
        super(globals);
        this.options = globals.getOptions();
    }

    private void checkWidthMismatch() {
        if (!NccUtils.sizesMatch(this.maxWidth, this.minWidth, this.options)) {
            this.mismatches.add(new SizeMismatch.WidthMismatch(this.minWidth, this.minWidPart, this.minWidNdx, this.maxWidth, this.maxWidPart, this.maxWidNdx));
        }
    }

    private void checkLengthMismatch() {
        if (!NccUtils.sizesMatch(this.maxLength, this.minLength, this.options)) {
            this.mismatches.add(new SizeMismatch.LengthMismatch(this.minLength, this.minLenPart, this.minLenNdx, this.maxLength, this.maxLenPart, this.maxLenNdx));
        }
    }

    private void summary() {
        if (this.mismatches.size() == 0) {
            return;
        }
        Collections.sort(this.mismatches, new MismatchComparator());
        System.out.println("  There are " + this.mismatches.size() + " size mismatches.");
        for (SizeMismatch.Mismatch m : this.mismatches) {
            System.out.print(m.toString());
        }
        this.globals.getNccGuiInfo().setSizeMismatches(this.mismatches);
    }

    private boolean matches() {
        return this.mismatches.size() == 0;
    }

    private double getWidth(Part p) {
        return p instanceof Mos ? ((Mos)p).getWidth() : ((Resistor)p).getWidth();
    }

    private double getLength(Part p) {
        return p instanceof Mos ? ((Mos)p).getLength() : ((Resistor)p).getLength();
    }

    @Override
    public LeafList doFor(EquivRecord j) {
        if (j.isLeaf()) {
            if (j.isMatched()) {
                this.minLength = Double.MAX_VALUE;
                this.minWidth = Double.MAX_VALUE;
                this.maxLength = Double.MIN_VALUE;
                this.maxWidth = Double.MIN_VALUE;
                this.cktNdx = 0;
                super.doFor(j);
                this.checkWidthMismatch();
                this.checkLengthMismatch();
            }
        } else {
            super.doFor(j);
        }
        return new LeafList();
    }

    @Override
    public HashMap<Integer, List<NetObject>> doFor(Circuit c) {
        HashMap<Integer, List<NetObject>> result2 = super.doFor(c);
        ++this.cktNdx;
        return result2;
    }

    @Override
    public Integer doFor(NetObject n) {
        Part p = (Part)n;
        if (p instanceof Subcircuit) {
            this.maxLength = 1.0;
            this.minLength = 1.0;
            this.maxWidth = 1.0;
            this.minWidth = 1.0;
        } else {
            double l;
            this.globals.error(!(p instanceof Mos) && !(p instanceof Resistor), "part with no width & length");
            double w = this.getWidth(p);
            if (w < this.minWidth) {
                this.minWidth = w;
                this.minWidPart = p;
                this.minWidNdx = this.cktNdx;
            }
            if (w > this.maxWidth) {
                this.maxWidth = w;
                this.maxWidPart = p;
                this.maxWidNdx = this.cktNdx;
            }
            if ((l = this.getLength(p)) < this.minLength) {
                this.minLength = l;
                this.minLenPart = p;
                this.minLenNdx = this.cktNdx;
            }
            if (l > this.maxLength) {
                this.maxLength = l;
                this.maxLenPart = p;
                this.maxLenNdx = this.cktNdx;
            }
        }
        return CODE_NO_CHANGE;
    }

    public static boolean doYourJob(NccGlobals globals) {
        NccOptions options = globals.getOptions();
        if (!options.checkSizes) {
            return true;
        }
        EquivRecord parts = globals.getParts();
        if (parts == null) {
            return true;
        }
        StratCheckSizes jsf = new StratCheckSizes(globals);
        jsf.doFor(parts);
        jsf.summary();
        return jsf.matches();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MismatchComparator
    implements Comparator<SizeMismatch.Mismatch> {
        private MismatchComparator() {
        }

        @Override
        public int compare(SizeMismatch.Mismatch m1, SizeMismatch.Mismatch m2) {
            double diff2 = m1.relErr() - m2.relErr();
            if (diff2 == 0.0) {
                return 0;
            }
            return diff2 < 0.0 ? 1 : -1;
        }
    }
}

