/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.Topology;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.util.math.DBMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Geometric
extends ElectricObject
implements RTBounds {
    protected Geometric() {
    }

    public abstract String describe(boolean var1);

    public int whichMultiPage() {
        int pageNo = 0;
        if (this.getParent().isMultiPage()) {
            double cY = this.getBounds().getCenterY();
            pageNo = (int)((cY + 500.0) / 1000.0);
        }
        return pageNo;
    }

    @Override
    public void getInfo() {
        Rectangle2D visBounds = this.getBounds();
        System.out.println(" Bounds: (" + visBounds.getCenterX() + "," + visBounds.getCenterY() + "), size: " + visBounds.getWidth() + "x" + visBounds.getHeight());
        System.out.println(" Parent: " + this.getParent());
        super.getInfo();
    }

    public Cell getParent() {
        Topology topology = this.getTopology();
        return topology != null ? topology.cell : null;
    }

    public abstract Topology getTopology();

    public abstract Iterator<Poly> getShape(Poly.Builder var1);

    @Override
    public abstract Rectangle2D getBounds();

    public Rectangle2D getLambdaBounds(Rectangle2D r) {
        if (r == null) {
            r = new Rectangle2D.Double();
        }
        r.setRect(this.getBounds());
        return r;
    }

    public Rectangle2D getGridBounds(Rectangle2D r) {
        if (r == null) {
            r = new Rectangle2D.Double();
        }
        Rectangle2D bounds = this.getBounds();
        long minX = DBMath.lambdaToGrid(bounds.getMinX());
        long minY = DBMath.lambdaToGrid(bounds.getMinY());
        long maxX = DBMath.lambdaToGrid(bounds.getMaxX());
        long maxY = DBMath.lambdaToGrid(bounds.getMaxY());
        r.setRect(minX, minY, maxX - minX, maxY - minY);
        return r;
    }

    public double getTrueCenterX() {
        return this.getBounds().getCenterX();
    }

    public double getTrueCenterY() {
        return this.getBounds().getCenterY();
    }

    public Point2D getTrueCenter() {
        return new Point2D.Double(this.getTrueCenterX(), this.getTrueCenterY());
    }

    public abstract boolean isConnected(Geometric var1);
}

