/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.bool;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.bool.DeltaMerge;
import com.sun.electric.database.geometry.bool.LayoutMerger;
import com.sun.electric.database.geometry.bool.LayoutMergerFactory;
import com.sun.electric.database.geometry.bool.UnloadPolys;
import com.sun.electric.database.geometry.bool.VectorCache;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.technology.Layer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LayoutMergerDefaultImpl
implements LayoutMerger {
    private final VectorCache vectorCache;
    private final Cell topCell;
    private static final int TMP_FILE_THRESHOLD = 1000000;

    private LayoutMergerDefaultImpl(Cell topCell) {
        this.vectorCache = new VectorCache(topCell.getDatabase().backup());
        this.vectorCache.scanLayers(topCell.getId());
        this.topCell = topCell;
    }

    @Override
    public Collection<Layer> getLayers() {
        return this.vectorCache.getLayers();
    }

    @Override
    public boolean canMerge(Layer layer) {
        return !this.vectorCache.isBadLayer(layer);
    }

    @Override
    public Iterable<PolyBase.PolyBaseTree> merge(Layer layer) {
        Iterable<PolyBase.PolyBaseTree> trees = null;
        try {
            DataInputStream inpS;
            DataOutputStream out;
            boolean inMemory = this.vectorCache.getNumFlatBoxes(this.topCell.getId(), layer) <= 1000000;
            ByteArrayOutputStream bout = null;
            File file = null;
            if (inMemory) {
                bout = new ByteArrayOutputStream();
                out = new DataOutputStream(bout);
            } else {
                file = File.createTempFile("Electric", "DRC");
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            }
            DeltaMerge dm = this.collectLayer(this.vectorCache, layer);
            dm.loop(out);
            out.close();
            dm = null;
            if (inMemory) {
                byte[] ba = bout.toByteArray();
                bout = null;
                inpS = new DataInputStream(new ByteArrayInputStream(ba));
            } else {
                inpS = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            }
            UnloadPolys up2 = new UnloadPolys();
            trees = up2.loop(inpS, false);
            inpS.close();
            if (!inMemory) {
                file.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return trees;
    }

    private DeltaMerge collectLayer(VectorCache vce, Layer layer) {
        final DeltaMerge dm = new DeltaMerge();
        VectorCache.PutRectangle putRectangle = new VectorCache.PutRectangle(){

            public void put(int lx, int ly, int hx, int hy) {
                dm.put(lx, ly, hx, hy);
            }
        };
        vce.collectLayer(layer, this.topCell.getId(), false, putRectangle);
        return dm;
    }

    static class Factory
    extends LayoutMergerFactory {
        Factory() {
        }

        public LayoutMerger newMerger(Cell topCell) {
            return new LayoutMergerDefaultImpl(topCell);
        }
    }
}

