/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.verilog;

import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerilogData
implements Serializable {
    String name;
    private Map<String, VerilogModule> modules = new HashMap<String, VerilogModule>();
    private static VerilogModuleSort compareVerilogModules = new VerilogModuleSort();
    private static VerilogPortSort compareVerilogPorts = new VerilogPortSort();
    private static VerilogInstanceSort compareVerilogInstances = new VerilogInstanceSort();
    private static VerilogAllSort compareVerilogAll = new VerilogAllSort();
    private static VerilogWireSort compareVerilogWires = new VerilogWireSort();

    VerilogData(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    VerilogModule addModule(String name, boolean primitive) {
        VerilogModule module = new VerilogModule(name, primitive);
        this.modules.put(name, module);
        return module;
    }

    public Collection<VerilogModule> getModules() {
        ArrayList<VerilogModule> list = new ArrayList<VerilogModule>(this.modules.size());
        list.addAll(this.modules.values());
        Collections.sort(list, compareVerilogModules);
        return list;
    }

    VerilogModule getModule(String name) {
        return this.modules.get(name);
    }

    void write() {
        for (VerilogModule module : this.modules.values()) {
            module.write();
        }
    }

    void simplifyWires() {
        for (VerilogModule module : this.modules.values()) {
            module.simplifyWires();
        }
    }

    private static void extractPinNames(int start, int end, String root, List<String> l) {
        if (start > end) {
            for (int i = start; i >= end; --i) {
                String thisName = root + "[" + i + "]";
                l.add(thisName);
            }
        } else {
            for (int i = start; i <= end; ++i) {
                String thisName = root + "[" + i + "]";
                l.add(thisName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VerilogWireSort
    implements Comparator<VerilogWire> {
        private VerilogWireSort() {
        }

        @Override
        public int compare(VerilogWire a1, VerilogWire a2) {
            int diff = TextUtils.STRING_NUMBER_ORDER.compare(a1.name, a2.name);
            if (diff == 0 && (diff = a1.start - a2.start) == 0) {
                diff = a1.end - a2.end;
                assert (diff != 0);
            }
            return diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VerilogModule
    implements Serializable {
        String name;
        boolean fullInfo;
        private List<VerilogWire> wires = new ArrayList<VerilogWire>();
        private Map<String, VerilogPort> ports = new LinkedHashMap<String, VerilogPort>();
        List<VerilogInstance> instances = new ArrayList<VerilogInstance>();
        boolean primitive;

        VerilogModule(String name, boolean primitive) {
            this.name = name;
            this.fullInfo = false;
        }

        void setValid(boolean flag) {
            this.fullInfo = flag;
        }

        public boolean isValid() {
            return this.fullInfo;
        }

        public String getName() {
            return this.name;
        }

        public boolean isPrimitive() {
            return this.primitive;
        }

        public List<Object> getAllSorted() {
            ArrayList<Object> list = new ArrayList<Object>(this.ports.size() + this.wires.size());
            list.addAll(this.ports.values());
            list.addAll(this.wires);
            Collections.sort(list, compareVerilogAll);
            return list;
        }

        public List<VerilogInstance> getInstances() {
            Collections.sort(this.instances, compareVerilogInstances);
            return this.instances;
        }

        public List<VerilogWire> getWires() {
            Collections.sort(this.wires, compareVerilogWires);
            return this.wires;
        }

        public Collection<VerilogPort> getPorts() {
            ArrayList<VerilogPort> list = new ArrayList<VerilogPort>(this.ports.size());
            list.addAll(this.ports.values());
            Collections.sort(list, compareVerilogPorts);
            return list;
        }

        VerilogPort findPort(String name) {
            return this.ports.get(name);
        }

        VerilogPort addPort(String name, boolean checkClock) {
            if (Job.getDebug() && this.findPort(name) != null) assert (this.findPort(name) == null);
            PortCharacteristic def = PortCharacteristic.UNKNOWN;
            String lowerName = name.toLowerCase();
            if (lowerName.startsWith("in")) {
                def = PortCharacteristic.IN;
            } else if (lowerName.startsWith("out")) {
                def = PortCharacteristic.OUT;
            } else if (checkClock && lowerName.endsWith("clk")) {
                def = PortCharacteristic.CLK;
            }
            VerilogPort export = new VerilogPort(name, def);
            this.ports.put(name, export);
            return export;
        }

        VerilogInstance addInstance(String name, VerilogModule element) {
            VerilogInstance inst = new VerilogInstance(name, element);
            this.instances.add(inst);
            return inst;
        }

        VerilogWire addWire(String name, String busInfo) {
            VerilogWire wire = new VerilogWire(name, busInfo);
            this.wires.add(wire);
            return wire;
        }

        void write() {
            System.out.print("module " + this.name + " (");
            Set<String> ports = this.ports.keySet();
            int size = ports.size();
            int count = 0;
            for (String s : ports) {
                System.out.print(s);
                if (count < size - 1) {
                    System.out.print(", ");
                }
                ++count;
            }
            System.out.println(");");
            System.out.println();
            for (VerilogPort e : this.ports.values()) {
                e.write();
            }
            System.out.println();
            for (VerilogWire w : this.wires) {
                w.write();
            }
            for (VerilogInstance i : this.instances) {
                i.write();
            }
            System.out.println("endmodule");
            System.out.println();
        }

        void simplifyWires() {
            Collections.sort(this.wires, compareVerilogWires);
            int i = 0;
            ArrayList toDelete = new ArrayList();
            while (i < this.wires.size()) {
                int j;
                VerilogWire w = this.wires.get(i);
                if (w.start == -1) {
                    ++i;
                    continue;
                }
                int end = w.end;
                ArrayList<VerilogWire> toMerge = new ArrayList<VerilogWire>();
                for (j = i + 1; j < this.wires.size(); ++j) {
                    VerilogWire r = this.wires.get(j);
                    if (!w.name.equals(r.name)) break;
                    end = r.end;
                    toMerge.add(r);
                }
                if (toMerge.size() > 0) {
                    toDelete.addAll(toMerge);
                    w.end = end;
                }
                i = j;
            }
            this.wires.removeAll(toDelete);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VerilogAllSort
    implements Comparator<Object> {
        private VerilogAllSort() {
        }

        @Override
        public int compare(Object a1, Object a2) {
            String name1 = a1 instanceof VerilogInstance ? ((VerilogInstance)a1).getName() : (a1 instanceof VerilogWire ? ((VerilogWire)a1).getName() : ((VerilogPort)a1).getName());
            String name2 = a2 instanceof VerilogInstance ? ((VerilogInstance)a2).getName() : (a2 instanceof VerilogWire ? ((VerilogWire)a2).getName() : ((VerilogPort)a2).getName());
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(name1, name2);
            return cmp;
        }
    }

    public class VerilogInstance
    implements Serializable {
        String name;
        VerilogModule element;
        List<VerilogPortInst> ports = new ArrayList<VerilogPortInst>();

        VerilogInstance(String name, VerilogModule elem) {
            this.name = name;
            this.element = elem;
        }

        public String getName() {
            return this.name;
        }

        public VerilogModule getModule() {
            return this.element;
        }

        VerilogPortInst addPortInstance(String name, VerilogPort port) {
            VerilogPortInst inst = new VerilogPortInst(name, port);
            this.ports.add(inst);
            return inst;
        }

        void write() {
            System.out.print("\t" + this.element.name + " " + this.name + " (");
            int size = this.ports.size();
            for (int i = 0; i < size; ++i) {
                VerilogPortInst port = this.ports.get(i);
                System.out.print("." + port.port.name + " (" + port.name + ")");
                if (i >= size - 1) continue;
                System.out.print(", ");
            }
            System.out.println(");");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VerilogInstanceSort
    implements Comparator<VerilogInstance> {
        private VerilogInstanceSort() {
        }

        @Override
        public int compare(VerilogInstance a1, VerilogInstance a2) {
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(a1.getName(), a2.getName());
            return cmp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VerilogPortInst
    implements Serializable {
        String name;
        VerilogPort port;

        VerilogPortInst(String name, VerilogPort port) {
            this.name = name;
            this.port = port;
        }

        List<String> getPortNames() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.name.contains("{")) {
                StringTokenizer parse = new StringTokenizer(this.name, "\t{,}", false);
                while (parse.hasMoreTokens()) {
                    String name = parse.nextToken();
                    name = name.replaceAll(" ", "");
                    list.add(name);
                    if (Job.getDebug()) assert (!name.contains(":"));
                }
            } else {
                list.add(this.name);
            }
            ArrayList<String> l = new ArrayList<String>(list.size());
            for (String s : list) {
                int pos = s.indexOf(":");
                if (pos != -1) {
                    int index1 = s.indexOf("[");
                    int index2 = s.indexOf("]");
                    String root = s.substring(0, index1);
                    int start = Integer.parseInt(s.substring(index1 + 1, pos));
                    int end = Integer.parseInt(s.substring(pos + 1, index2));
                    VerilogData.extractPinNames(start, end, root, l);
                    continue;
                }
                l.add(s);
            }
            return l;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VerilogWire
    extends VerilogConnection {
        public VerilogWire(String name, String busPins) {
            super(name);
            this.name = name;
            if (busPins == null) {
                int index = name.indexOf("[");
                if (index != -1) {
                    this.name = name.substring(0, index);
                    index = Integer.parseInt(name.substring(index + 1, name.length() - 1));
                }
                this.start = this.end = index;
            } else {
                int index2 = busPins.indexOf(":");
                assert (index2 != -1);
                this.start = Integer.parseInt(busPins.substring(1, index2));
                this.end = Integer.parseInt(busPins.substring(index2 + 1, busPins.length() - 1));
            }
        }

        @Override
        List<String> getPinNames(boolean fullOyster) {
            ArrayList<String> list = new ArrayList<String>();
            if (fullOyster && this.isBusConnection()) {
                VerilogData.extractPinNames(this.start, this.end, this.name, list);
            } else {
                list.add(this.name);
            }
            return list;
        }

        void write() {
            System.out.println("\twire " + (this.start != this.end ? "[" + this.start + ":" + this.end + "[" : "") + " " + this.name + ";");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VerilogPort
    extends VerilogConnection {
        PortCharacteristic type;

        VerilogPort(String name, PortCharacteristic type) {
            super(name);
            this.type = type;
            this.end = -1;
            this.start = -1;
        }

        @Override
        PortCharacteristic getPortType() {
            return this.type;
        }

        void setBusInformation(String s) {
            int pos = s.indexOf(":");
            this.start = Integer.parseInt(s.substring(1, pos));
            this.end = Integer.parseInt(s.substring(pos + 1, s.length() - 1));
        }

        @Override
        public List<String> getPinNames(boolean fullOyster) {
            ArrayList<String> list = new ArrayList<String>();
            if (fullOyster && this.isBusConnection()) {
                VerilogData.extractPinNames(this.start, this.end, this.name, list);
            } else {
                list.add(this.name);
            }
            return list;
        }

        void write() {
            String typeName = "";
            if (this.type == PortCharacteristic.BIDIR) {
                typeName = "inout";
            } else if (this.type == PortCharacteristic.IN) {
                typeName = "input";
            } else if (this.type == PortCharacteristic.OUT) {
                typeName = "output";
            } else if (this.type == PortCharacteristic.GND) {
                typeName = "supply0";
            } else if (this.type == PortCharacteristic.PWR) {
                typeName = "supply1";
            }
            System.out.println("\t" + typeName + " " + (this.isBusConnection() ? "[" + this.start + ":" + this.end + "]" : "") + " " + this.name + ";");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VerilogPortSort
    implements Comparator<VerilogPort> {
        private VerilogPortSort() {
        }

        @Override
        public int compare(VerilogPort a1, VerilogPort a2) {
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(a1.name, a2.name);
            return cmp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class VerilogConnection
    implements Serializable {
        protected String name;
        int start;
        int end;

        VerilogConnection(String name) {
            this.name = name;
        }

        abstract List<String> getPinNames(boolean var1);

        PortCharacteristic getPortType() {
            return null;
        }

        String getName() {
            return this.name;
        }

        boolean isBusConnection() {
            return this.start != this.end;
        }

        String getConnectionName() {
            if (this.start != -1) {
                if (this.isBusConnection()) {
                    return this.name + "[" + this.start + ":" + this.end + "]";
                }
                return this.name + "[" + this.start + "]";
            }
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VerilogModuleSort
    implements Comparator<VerilogModule> {
        private VerilogModuleSort() {
        }

        @Override
        public int compare(VerilogModule a1, VerilogModule a2) {
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(a1.getName(), a2.getName());
            return cmp;
        }
    }
}

