/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.CVSLibrary;
import com.sun.electric.tool.cvspm.Update;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.ELIB;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.JELIB;
import com.sun.electric.tool.io.input.LibDirs;
import com.sun.electric.tool.io.input.LibraryStatistics;
import com.sun.electric.tool.io.input.ReadableDump;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.dialogs.OpenFile;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LibraryFiles
extends Input {
    public static final Variable.Key IO_TRUE_LIBRARY = Variable.newKey("IO_true_library");
    public static final Variable.Key IO_DUMMY_OBJECT = Variable.newKey("IO_dummy_object");
    final EDatabase database = EDatabase.serverDatabase();
    final IdManager idManager = this.database.getIdManager();
    protected Library lib;
    protected boolean topLevelLibrary;
    protected int nodeProtoCount;
    protected Cell[] nodeProtoList;
    protected double[] cellLambda;
    protected static int totalCells;
    protected static int cellsConstructed;
    protected List<Cell> scaledCells;
    protected int errorCount;
    protected Version version;
    protected boolean convertMosisCmosTechnologies;
    protected boolean scaleLambdaBy20;
    protected boolean rotationMirrorBits;
    protected HashMap<Technology, Technology.SizeCorrector> sizeCorrectors = new HashMap();
    private String[] fontNames;
    MutableTextDescriptor mtd = new MutableTextDescriptor();
    ArrayList<Variable> variablesBuf = new ArrayList();
    protected static String mainLibDirectory;
    private static List<LibraryFiles> libsBeingRead;
    static Set<TechId> undefinedTechs;
    HashMap<Setting, Object> projectSettings = new HashMap();
    protected static final boolean VERBOSE = false;
    protected static final double TINYDISTANCE;

    LibraryFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Library readLibrary(URL fileURL, String libName, FileType type, boolean quick) {
        if (fileURL == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        errorLogger = ErrorLogger.newInstance("Library Read");
        File f = new File(fileURL.getPath());
        if (f != null && f.exists()) {
            LibDirs.readLibDirs(f.getParent());
        }
        LibraryFiles.initializeLibraryInput();
        Library lib = null;
        boolean formerQuiet = LibraryFiles.isChangeQuiet();
        if (!formerQuiet) {
            LibraryFiles.changesQuiet(true);
        }
        try {
            if (!quick) {
                LibraryFiles.startProgressDialog("library", fileURL.getFile());
            }
            Cell.setAllowCircularLibraryDependences(true);
            StringBuffer errmsg = new StringBuffer();
            boolean exists = TextUtils.URLExists(fileURL, errmsg);
            if (!exists) {
                System.out.print(errmsg.toString());
                String fileName = fileURL.toString();
                if (fileName.indexOf(".") == -1) {
                    fileURL = TextUtils.makeURLToFile(fileName + "." + type.getExtensions()[0]);
                    System.out.print("Attempting to open " + fileURL + "\n");
                    errmsg.setLength(0);
                    exists = TextUtils.URLExists(fileURL, errmsg);
                    if (!exists) {
                        System.out.print(errmsg.toString());
                    }
                }
            }
            if (exists) {
                if (libName == null) {
                    libName = TextUtils.getFileNameWithoutExtension(fileURL);
                }
                lib = LibraryFiles.readALibrary(fileURL, null, libName, type);
            }
            LibraryFiles.cleanupLibraryInput();
        }
        finally {
            if (!quick) {
                LibraryFiles.stopProgressDialog();
            }
            Cell.setAllowCircularLibraryDependences(false);
        }
        if (!formerQuiet) {
            LibraryFiles.changesQuiet(formerQuiet);
        }
        if (lib != null && !quick) {
            long endTime = System.currentTimeMillis();
            float finalTime = (float)(endTime - startTime) / 1000.0f;
            System.out.println("Library " + fileURL.getFile() + " read, took " + finalTime + " seconds");
        }
        if (CVS.isEnabled()) {
            Update.updateOpenLibraries(1);
        }
        errorLogger.termLogging(true);
        return lib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Map<Setting, Object> readProjectsSettingsFromLibrary(URL fileURL, FileType type) {
        LibraryFiles in;
        if (fileURL == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        errorLogger = ErrorLogger.newInstance("Library Read Project Settings");
        Object lib = null;
        StringBuffer errmsg = new StringBuffer();
        boolean exists = TextUtils.URLExists(fileURL, errmsg);
        if (!exists) {
            System.out.print(errmsg.toString());
            String fileName = fileURL.toString();
            if (fileName.indexOf(".") == -1) {
                fileURL = TextUtils.makeURLToFile(fileName + "." + type.getExtensions()[0]);
                System.out.print("Attempting to open " + fileURL + "\n");
                errmsg.setLength(0);
                exists = TextUtils.URLExists(fileURL, errmsg);
                if (!exists) {
                    System.out.print(errmsg.toString());
                    return null;
                }
            }
        }
        if (type == FileType.JELIB || type == FileType.DELIB) {
            TechPool techPool = EDatabase.serverDatabase().getTechPool();
            try {
                Map<Setting, Object> map = JELIB.readProjectSettings(fileURL, type, techPool, errorLogger);
                return map;
            }
            finally {
                errorLogger.termLogging(true);
            }
        }
        if (type == FileType.ELIB) {
            in = new ELIB();
            if (in.openBinaryInput(fileURL)) {
                return null;
            }
        } else if (type == FileType.READABLEDUMP) {
            in = new ReadableDump();
            if (in.openTextInput(fileURL)) {
                return null;
            }
        } else {
            System.out.println("Unknown import type: " + type);
            return null;
        }
        in.topLevelLibrary = true;
        boolean error = in.readProjectSettings();
        in.closeInput();
        if (error) {
            System.out.println("Error reading " + lib);
            if (in.topLevelLibrary) {
                mainLibDirectory = null;
            }
            return null;
        }
        long endTime = System.currentTimeMillis();
        float finalTime = (float)(endTime - startTime) / 1000.0f;
        System.out.println("Library " + fileURL.getFile() + " read, took " + finalTime + " seconds");
        errorLogger.termLogging(true);
        return in.projectSettings;
    }

    protected static Library readALibrary(URL fileURL, Library lib, String libName, FileType type) {
        LibraryFiles in;
        if (type == FileType.ELIB) {
            in = new ELIB();
            if (in.openBinaryInput(fileURL)) {
                return null;
            }
        } else if (type == FileType.JELIB || type == FileType.DELIB) {
            try {
                LibId libId = lib != null ? lib.getId() : EDatabase.serverDatabase().getIdManager().newLibId(libName);
                in = new JELIB(libId, fileURL, type);
            }
            catch (IOException e) {
                return null;
            }
        } else if (type == FileType.READABLEDUMP) {
            in = new ReadableDump();
            if (in.openTextInput(fileURL)) {
                return null;
            }
        } else {
            System.out.println("Unknown import type: " + type);
            return null;
        }
        in.topLevelLibrary = false;
        if (lib == null) {
            mainLibDirectory = TextUtils.getFilePath(fileURL);
            if (type == FileType.DELIB) {
                mainLibDirectory = mainLibDirectory.replaceAll(libName + "." + type.getExtensions()[0], "");
            }
            in.topLevelLibrary = true;
        }
        if (lib == null) {
            lib = Library.newInstance(libName, fileURL);
        }
        in.lib = lib;
        boolean error = in.readInputLibrary();
        in.closeInput();
        if (error) {
            System.out.println("Error reading " + lib);
            if (in.topLevelLibrary) {
                mainLibDirectory = null;
            }
            return null;
        }
        if (CVS.isEnabled()) {
            CVSLibrary.addLibrary(lib);
        }
        return in.lib;
    }

    public static IdMapper reloadLibrary(Library lib) {
        if (!lib.isFromDisk()) {
            System.out.println("No disk file associated with this library, cannot reload from disk");
            return null;
        }
        FileType type = OpenFile.getOpenFileType(lib.getLibFile().getPath(), FileType.JELIB);
        String name = lib.getName();
        URL libFile = lib.getLibFile();
        IdMapper idMapper = lib.setName("___old___" + name);
        if (idMapper == null) {
            return null;
        }
        lib = idMapper.get(lib.getId()).inDatabase(EDatabase.serverDatabase());
        lib.setHidden();
        LibraryFiles.startProgressDialog("library", name);
        Library newLib = LibraryFiles.readLibrary(libFile, name, type, true);
        LibraryFiles.stopProgressDialog();
        Cell.setAllowCircularLibraryDependences(true);
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell oldCell = it.next();
            String cellName = oldCell.getCellName().toString();
            Cell newCell = newLib.findNodeProto(cellName);
            if (newCell == null) {
                System.out.println("Warning, Cell " + oldCell.describe(false) + " does not exist in reloaded library. Copying it to reloaded library.");
                newCell = Cell.copyNodeProto(oldCell, newLib, cellName, true);
            }
            ArrayList<NodeInst> instances = new ArrayList<NodeInst>();
            Iterator<NodeInst> it2 = oldCell.getInstancesOf();
            while (it2.hasNext()) {
                instances.add(it2.next());
            }
            for (NodeInst ni : instances) {
                CircuitChangeJobs.replaceNodeInst(ni, newCell, true, true);
            }
        }
        Cell.setAllowCircularLibraryDependences(false);
        lib.kill("delete old library");
        System.out.println("Reloaded library " + newLib.getName() + " from disk.");
        return idMapper;
    }

    public static void reloadLibraryCells(List<Cell> cellList) {
        if (cellList == null || cellList.size() == 0) {
            return;
        }
        Library lib = cellList.get(0).getLibrary();
        if (!lib.isFromDisk()) {
            System.out.println("No disk file associated with this library, cannot reload from disk");
            return;
        }
        FileType type = OpenFile.getOpenFileType(lib.getLibFile().getPath(), FileType.JELIB);
        String name = lib.getName();
        URL libFile = lib.getLibFile();
        LibraryFiles.startProgressDialog("library", name);
        Library newLib = LibraryFiles.readLibrary(libFile, "___reloaded___" + name, type, true);
        LibraryFiles.stopProgressDialog();
        newLib.setHidden();
        Cell.setAllowCircularLibraryDependences(true);
        for (Cell oldCell : cellList) {
            String cellName = oldCell.getCellName().toString();
            Cell newCell = newLib.findNodeProto(cellName);
            if (newCell == null) {
                System.out.println("Cell " + oldCell.describe(false) + " cannot be reloaded, it does not exist in disk library");
                continue;
            }
            String renamedName = "___old___" + oldCell.getName();
            IdMapper idMapper = oldCell.rename(renamedName, renamedName);
            if (idMapper == null) continue;
            oldCell = idMapper.get(oldCell.getId()).inDatabase(EDatabase.serverDatabase());
            newCell = Cell.copyNodeProto(newCell, lib, cellName, true);
            ArrayList<NodeInst> instances = new ArrayList<NodeInst>();
            Iterator<NodeInst> it2 = oldCell.getInstancesOf();
            while (it2.hasNext()) {
                instances.add(it2.next());
            }
            for (NodeInst ni : instances) {
                CircuitChangeJobs.replaceNodeInst(ni, newCell, true, true);
            }
            oldCell.kill();
        }
        Cell.setAllowCircularLibraryDependences(false);
        newLib.kill("delete temp library");
        System.out.println("Reloaded Cells from disk.");
    }

    public static void initializeLibraryInput() {
        libsBeingRead = new ArrayList<LibraryFiles>();
        undefinedTechs = new HashSet<TechId>();
    }

    public boolean readInputLibrary() {
        assert (!libsBeingRead.contains(this));
        libsBeingRead.add(this);
        this.scaledCells = new ArrayList<Cell>();
        try {
            if (this.readTheLibrary(false, null)) {
                return true;
            }
            Map<Cell, Variable[]> originalVars = this.createLibraryCells(false);
            this.realizeCellVariables(originalVars);
            return false;
        }
        catch (IOException e) {
            System.out.println("End of file reached while reading " + this.filePath);
            return true;
        }
    }

    abstract boolean readTheLibrary(boolean var1, LibraryStatistics.FileContents var2) throws IOException;

    abstract Map<Cell, Variable[]> createLibraryCells(boolean var1);

    private void realizeCellVariables(Map<Cell, Variable[]> originalVars) {
        HashSet<Cell.CellGroup> visitedCellGroups = new HashSet<Cell.CellGroup>();
        for (Cell cell : originalVars.keySet()) {
            Cell.CellGroup cellGroup = cell.getCellGroup();
            if (visitedCellGroups.contains(cellGroup)) continue;
            this.realizeCellVariables(cellGroup, originalVars);
            visitedCellGroups.add(cellGroup);
        }
    }

    private void realizeCellVariables(Cell.CellGroup cellGroup, Map<Cell, Variable[]> originalVars) {
        Cell cellOwner = cellGroup.getParameterOwner();
        HashMap<Variable.AttrKey, Variable> groupParams = null;
        if (cellOwner != null) {
            Variable[] ownerVars;
            groupParams = new HashMap<Variable.AttrKey, Variable>();
            for (Variable var : ownerVars = originalVars.get(cellOwner)) {
                if (!var.getTextDescriptor().isParam() || cellOwner.isDeprecatedVariable(var.getKey()) || var.getKey() == NccCellAnnotations.NCC_ANNOTATION_KEY) continue;
                var = var.withInherit(true);
                cellGroup.addParam(var);
                groupParams.put((Variable.AttrKey)var.getKey(), var);
            }
        }
        Iterator<Cell> it = cellGroup.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            Variable[] origVars = originalVars.get(cell);
            if (cell.isIcon() || cell.isSchematic()) {
                this.realizeCellVariables(cell, origVars, groupParams);
                continue;
            }
            this.realizeVariables(cell, origVars);
        }
    }

    private void realizeCellVariables(Cell cell, Variable[] origVars, HashMap<Variable.AttrKey, Variable> groupParams) {
        int foundParams = 0;
        for (Variable var : origVars) {
            if (var.isAttribute()) {
                String msg;
                Variable.Key varKey = var.getKey();
                Variable groupParam = groupParams.get(varKey);
                if (groupParam != null) {
                    if (!var.getTextDescriptor().isParam()) {
                        msg = "Attribute \"" + var.getTrueName() + "\" on " + cell + " must be parameter as on " + cell.getCellGroup().getParameterOwner();
                        errorLogger.logError(msg, EPoint.fromLambda(var.getXOff(), var.getYOff()), cell, 2);
                        var = var.withParam(true);
                    }
                    if (!(var = var.withInherit(true)).getObject().equals(groupParam.getObject())) {
                        msg = "Parameter \"" + var.getTrueName() + "\" has value " + var.getPureValue(-1) + " on " + cell + " instead of " + groupParam.getPureValue(-1) + " as on " + cell.getCellGroup().getParameterOwner();
                        errorLogger.logError(msg, EPoint.fromLambda(var.getXOff(), var.getYOff()), cell, 2);
                        var = var.withObject(groupParam.getObject());
                    }
                    if (var.getUnit() != groupParam.getUnit()) {
                        msg = "Parameter \"" + var.getTrueName() + "\" has unit " + var.getUnit() + " on " + cell + " instead of " + groupParam.getUnit() + " as on " + cell.getCellGroup().getParameterOwner();
                        errorLogger.logError(msg, EPoint.fromLambda(var.getXOff(), var.getYOff()), cell, 2);
                        var = var.withUnit(groupParam.getUnit());
                    }
                    ++foundParams;
                    cell.setTextDescriptor(var.getKey(), var.getTextDescriptor());
                    continue;
                }
                if (var.getTextDescriptor().isParam()) {
                    msg = cell + " has extra parameter \"" + var.getTrueName() + "\" compared to " + cell.getCellGroup().getParameterOwner();
                    errorLogger.logError(msg, EPoint.fromLambda(var.getXOff(), var.getYOff()), cell, 2);
                    var = var.withParam(false);
                    if (var.getKey() == NccCellAnnotations.NCC_ANNOTATION_KEY) {
                        var = var.withInherit(false).withInterior(false);
                    }
                }
            }
            this.realizeVariable(cell, var);
        }
        if (foundParams == groupParams.size()) {
            return;
        }
        HashSet<Variable.AttrKey> omittedParams = new HashSet<Variable.AttrKey>(groupParams.keySet());
        for (Variable var : origVars) {
            omittedParams.remove(var.getKey());
        }
        assert (omittedParams.size() + foundParams == groupParams.size());
        Variable[] exampleVars = null;
        if (cell.isIcon()) {
            Cell schCell;
            Iterator<Cell> cit = cell.getCellGroup().getCells();
            while (cit.hasNext() && (!(schCell = cit.next()).isSchematic() || (exampleVars = this.findVarsOnExampleIcon(schCell, cell)) == null)) {
            }
        }
        for (Variable.AttrKey omittedParam : omittedParams) {
            Variable param = groupParams.get(omittedParam);
            String msg = cell + " must have parameter \"" + param.getTrueName() + "\" as on " + cell.getCellGroup().getParameterOwner();
            Variable exampleParam = null;
            if (exampleVars != null) {
                for (Variable var : exampleVars) {
                    if (var == null || var.getKey() != omittedParam) continue;
                    exampleParam = var;
                    break;
                }
            }
            if (exampleParam != null) {
                TextDescriptor td = exampleParam.getTextDescriptor();
                td = td.withInherit(true).withParam(true).withUnit(param.getUnit());
                boolean interior = !exampleParam.isDisplay();
                td = td.withInterior(interior).withDisplay(true);
                param = param.withTextDescriptor(td);
            }
            assert (param.getTextDescriptor().isParam() && param.isInherit());
            errorLogger.logError(msg, EPoint.fromLambda(param.getXOff(), param.getYOff()), cell, 2);
            cell.setTextDescriptor(param.getKey(), param.getTextDescriptor());
        }
    }

    abstract Variable[] findVarsOnExampleIcon(Cell var1, Cell var2);

    protected void scanNodesForRecursion(Cell cell, HashSet<Cell> markCellForNodes, NodeProto[] nil, int start, int end) {
        for (int j = start; j < end; ++j) {
            Cell otherCell;
            NodeProto np = nil[j];
            if (np instanceof PrimitiveNode || (otherCell = (Cell)np) == null || markCellForNodes.contains(otherCell)) continue;
            LibraryFiles reader = this;
            if (otherCell.getLibrary() != cell.getLibrary()) {
                reader = this.getReaderForLib(otherCell.getLibrary());
            }
            if (reader == null) continue;
            reader.realizeCellsRecursively(otherCell, markCellForNodes, null, 0.0);
        }
        markCellForNodes.add(cell);
    }

    protected boolean readProjectSettings() {
        return true;
    }

    protected View findOldViewName(String viewName) {
        if (this.version.getMajor() < 8) {
            if (viewName.equals("compensated")) {
                return View.LAYOUTCOMP;
            }
            if (viewName.equals("skeleton")) {
                return View.LAYOUTSKEL;
            }
            if (viewName.equals("simulation-snapshot")) {
                return View.DOCWAVE;
            }
            if (viewName.equals("netlist-netlisp-format")) {
                return View.NETLISTNETLISP;
            }
            if (viewName.equals("netlist-rsim-format")) {
                return View.NETLISTRSIM;
            }
            if (viewName.equals("netlist-silos-format")) {
                return View.NETLISTSILOS;
            }
            if (viewName.equals("netlist-quisc-format")) {
                return View.NETLISTQUISC;
            }
            if (viewName.equals("netlist-als-format")) {
                return View.NETLISTALS;
            }
        }
        return null;
    }

    protected Technology findTechnologyName(String name) {
        Technology tech = null;
        if (this.convertMosisCmosTechnologies) {
            if (name.equals("mocmossub")) {
                tech = Technology.getMocmosTechnology();
            } else if (name.equals("mocmos")) {
                tech = Technology.findTechnology("mocmosold");
            }
        }
        if (tech == null) {
            tech = Technology.findTechnology(name);
        }
        if (tech == null && name.equals("logic")) {
            tech = Schematics.tech();
        }
        if (tech == null && (name.equals("epic8c") || name.equals("epic7c"))) {
            tech = Technology.findTechnology("epic7s");
        }
        return tech;
    }

    protected Library readExternalLibraryFromFilename(String theFileName, FileType defaultType) {
        boolean exists;
        FileType importType;
        int slashPos;
        int colonPos;
        String legalLibName = TextUtils.getFileNameWithoutExtension(theFileName);
        Library elib = Library.findLibrary(legalLibName);
        if (elib != null) {
            return elib;
        }
        String libFileName = theFileName;
        while (libFileName.endsWith("\\") || libFileName.endsWith(":") || libFileName.endsWith("/")) {
            libFileName = libFileName.substring(0, libFileName.length() - 1);
        }
        int backSlashPos = libFileName.lastIndexOf(92);
        int charPos = Math.max(backSlashPos, Math.max(colonPos = libFileName.lastIndexOf(58), slashPos = libFileName.lastIndexOf(47)));
        if (charPos >= 0) {
            libFileName = libFileName.substring(charPos + 1);
        }
        String libName = libFileName;
        FileType preferredType = importType = OpenFile.getOpenFileType(libName, defaultType);
        if (libName.endsWith(".elib")) {
            libName = libName.substring(0, libName.length() - 5);
        } else if (libName.endsWith(".jelib")) {
            libName = libName.substring(0, libName.length() - 6);
        } else if (libName.endsWith(".delib")) {
            libName = libName.substring(0, libName.length() - 6);
        } else if (libName.endsWith(".txt")) {
            libName = libName.substring(0, libName.length() - 4);
        } else {
            libFileName = libFileName + "." + defaultType.getExtensions()[0];
        }
        StringBuffer errmsg = new StringBuffer();
        URL externalURL = this.getLibrary(libName + "." + preferredType.getExtensions()[0], theFileName, errmsg, true);
        if (externalURL == null && preferredType != FileType.JELIB) {
            externalURL = this.getLibrary(libName + "." + FileType.JELIB.getExtensions()[0], theFileName, errmsg, true);
        }
        if (externalURL == null && preferredType != FileType.ELIB) {
            externalURL = this.getLibrary(libName + "." + FileType.ELIB.getExtensions()[0], theFileName, errmsg, true);
        }
        if (externalURL == null && preferredType != FileType.DELIB) {
            externalURL = this.getLibrary(libName + "." + FileType.DELIB.getExtensions()[0], theFileName, errmsg, true);
        }
        if (externalURL == null && preferredType != FileType.READABLEDUMP) {
            externalURL = this.getLibrary(libName + "." + FileType.READABLEDUMP.getExtensions()[0], theFileName, errmsg, true);
        }
        boolean bl = exists = externalURL != null;
        if (!exists) {
            String description;
            System.out.println("Error: cannot find referenced library " + libName + ":");
            System.out.print(errmsg.toString());
            String pt = null;
            while (!((pt = OpenFile.chooseInputFile(FileType.LIBFILE, description = "Reference library '" + libFileName + "'")) == null || (externalURL = TextUtils.makeURLToFile(pt)) != null && (exists = TextUtils.URLExists(externalURL, null)))) {
            }
        }
        if (exists) {
            System.out.println("Reading referenced library " + externalURL.getFile());
            importType = OpenFile.getOpenFileType(externalURL.getFile(), defaultType);
            elib = Library.newInstance(legalLibName, externalURL);
        }
        if (elib != null) {
            String oldNote = LibraryFiles.getProgressNote();
            LibraryFiles.setProgressValue(0);
            LibraryFiles.setProgressNote("Reading referenced library " + legalLibName + "...");
            String eLibName = TextUtils.getFileNameWithoutExtension(externalURL);
            elib = LibraryFiles.readALibrary(externalURL, elib, eLibName, importType);
            LibraryFiles.setProgressValue(100);
            LibraryFiles.setProgressNote(oldNote);
        }
        if (elib == null) {
            System.out.println("Error: cannot find referenced library " + theFileName);
            System.out.println("...Creating new " + legalLibName + " Library instead");
            elib = Library.newInstance(legalLibName, null);
            elib.setLibFile(TextUtils.makeURLToFile(theFileName));
            elib.clearFromDisk();
        }
        return elib;
    }

    private URL getLibrary(String libFileName, String originalPath, StringBuffer errmsg, boolean checkElectricLib) {
        String fileName;
        File libFile;
        URL secondURL;
        URL url;
        URL firstURL = TextUtils.makeURLToFile(mainLibDirectory + libFileName);
        boolean exists = TextUtils.URLExists(firstURL, errmsg);
        if (exists) {
            return firstURL;
        }
        HashMap<String, String> searchedURLs = new HashMap<String, String>();
        Iterator<String> libIt = LibDirs.getLibDirs();
        while (libIt.hasNext()) {
            url = TextUtils.makeURLToFile(libIt.next() + File.separator + libFileName);
            exists = TextUtils.URLExists(url, errmsg);
            if (exists) {
                return url;
            }
            if (url == null) continue;
            searchedURLs.put(url.getFile(), url.getFile());
        }
        URL thirdURL = TextUtils.makeURLToFile(System.getProperty("user.dir") + File.separator + libFileName);
        if (thirdURL != null && !searchedURLs.containsKey(thirdURL.getFile())) {
            exists = TextUtils.URLExists(thirdURL, errmsg);
            if (exists) {
                return thirdURL;
            }
            if (thirdURL != null) {
                searchedURLs.put(thirdURL.getFile(), thirdURL.getFile());
            }
        }
        if (originalPath != null && (secondURL = TextUtils.makeURLToFile((originalPath = (libFile = new File(fileName = (url = TextUtils.makeURLToFile(originalPath)).getFile())).getParent()) + File.separator + libFileName)) != null && !searchedURLs.containsKey(secondURL.getFile())) {
            exists = TextUtils.URLExists(secondURL, errmsg);
            if (exists) {
                return secondURL;
            }
            if (secondURL != null) {
                searchedURLs.put(secondURL.getFile(), secondURL.getFile());
            }
        }
        if (checkElectricLib && (exists = TextUtils.URLExists(url = LibFile.getLibFile(libFileName), errmsg))) {
            return url;
        }
        return null;
    }

    public static void cleanupLibraryInput() {
        Cell cell4;
        Cell cell2;
        Cell cell3;
        int cellIndex;
        LibraryFiles.setProgressValue(0);
        LibraryFiles.setProgressNote("Constructing cell contents...");
        HashSet<Cell> uncomputedCells = new HashSet<Cell>();
        for (LibraryFiles reader : libsBeingRead) {
            for (cellIndex = 0; cellIndex < reader.nodeProtoCount; ++cellIndex) {
                cell3 = reader.nodeProtoList[cellIndex];
                if (cell3 == null || cell3.getLibrary() != reader.lib) continue;
                uncomputedCells.add(cell3);
            }
        }
        for (LibraryFiles reader : libsBeingRead) {
            for (cellIndex = 0; cellIndex < reader.nodeProtoCount; ++cellIndex) {
                cell3 = reader.nodeProtoList[cellIndex];
                if (cell3 == null || cell3.getLibrary() != reader.lib) continue;
                reader.computeTech(cell3, uncomputedCells);
            }
        }
        totalCells = 0;
        HashSet<Cell> markCellForNodes = new HashSet<Cell>();
        for (LibraryFiles reader : libsBeingRead) {
            totalCells += reader.nodeProtoCount;
            for (int cellIndex2 = 0; cellIndex2 < reader.nodeProtoCount; ++cellIndex2) {
                cell2 = reader.nodeProtoList[cellIndex2];
                if (cell2 == null || cell2.getLibrary() != reader.lib) continue;
                reader.cellLambda[cellIndex2] = reader.computeLambda(cell2, cellIndex2);
                cell2.setTempInt(cellIndex2);
            }
        }
        cellsConstructed = 0;
        for (int i = 0; i < 20; ++i) {
            boolean unchanged = true;
            for (LibraryFiles reader : libsBeingRead) {
                for (int cellIndex3 = 0; cellIndex3 < reader.nodeProtoCount; ++cellIndex3) {
                    cell4 = reader.nodeProtoList[cellIndex3];
                    if (cell4 == null || cell4.getLibrary() != reader.lib || !reader.spreadLambda(cell4, cellIndex3)) continue;
                    unchanged = false;
                }
            }
            if (unchanged) break;
        }
        for (LibraryFiles reader : libsBeingRead) {
            for (int cellIndex4 = 0; cellIndex4 < reader.nodeProtoCount; ++cellIndex4) {
                cell2 = reader.nodeProtoList[cellIndex4];
                if (cell2 == null || markCellForNodes.contains(cell2)) continue;
                reader.realizeCellsRecursively(cell2, markCellForNodes, null, 0.0);
            }
        }
        for (LibraryFiles reader : libsBeingRead) {
            reader.lib.clearChanged();
        }
        boolean first = true;
        for (LibraryFiles reader : libsBeingRead) {
            if (reader.scaledCells == null || reader.scaledCells.size() == 0) continue;
            if (first) {
                System.out.println("WARNING: to accommodate scaling inconsistencies, these cells were created:");
                first = false;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("   Library " + reader.lib.getName() + ":");
            for (Cell cell4 : reader.scaledCells) {
                sb.append(" " + cell4.noLibDescribe());
            }
            System.out.println(sb.toString());
        }
        Variable.Key SPICE_MODEL_FILE_KEY = Variable.newKey("SIM_spice_behave_file");
        for (LibraryFiles reader : libsBeingRead) {
            for (int cellIndex5 = 0; cellIndex5 < reader.nodeProtoCount; ++cellIndex5) {
                String verilogModelFile;
                cell4 = reader.nodeProtoList[cellIndex5];
                if (cell4 == null) continue;
                String spiceModelFile = cell4.getVarValue(SPICE_MODEL_FILE_KEY, String.class);
                if (spiceModelFile != null) {
                    CellModelPrefs.spiceModelPrefs.setModelFile(cell4, spiceModelFile, false, false);
                }
                if ((verilogModelFile = cell4.getVarValue(Verilog.VERILOG_BEHAVE_FILE_KEY, String.class)) == null) continue;
                CellModelPrefs.verilogModelPrefs.setModelFile(cell4, verilogModelFile, false, false);
            }
        }
        Iterator<Listener> it = Tool.getListeners();
        while (it.hasNext()) {
            Listener listener = it.next();
            for (LibraryFiles reader : libsBeingRead) {
                listener.readLibrary(reader.lib);
            }
        }
        if (!undefinedTechs.isEmpty()) {
            String techs = "";
            for (TechId techId : undefinedTechs) {
                techs = techs + " " + techId;
            }
            Job.getUserInterface().showErrorMessage("Library contains nodes from unknown technology:" + techs, "Unknown technologies");
        }
        libsBeingRead.clear();
        undefinedTechs.clear();
    }

    protected LibraryFiles getReaderForLib(Library lib) {
        for (LibraryFiles reader : libsBeingRead) {
            if (reader.lib != lib) continue;
            return reader;
        }
        return null;
    }

    Technology.SizeCorrector getSizeCorrector(Technology tech) {
        Technology.SizeCorrector corrector = this.sizeCorrectors.get(tech);
        if (corrector == null) {
            corrector = tech.getSizeCorrector(this.version, this.projectSettings, false, false);
            this.sizeCorrectors.put(tech, corrector);
        }
        return corrector;
    }

    String convertCellName(String s) {
        StringBuffer buf = null;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\n' || ch == '|' || ch == ':') {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(s.substring(0, i));
                }
                buf.append('-');
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            String newS = buf.toString();
            System.out.println("Cell name " + s + " was converted to " + newS);
            return newS;
        }
        return s;
    }

    protected static String convertGeomName(Object value, boolean isDisplay) {
        if (value == null || !(value instanceof String)) {
            return null;
        }
        String str = (String)value;
        int indexOfAt = str.indexOf(64);
        if (isDisplay) {
            if (indexOfAt >= 0) {
                String newS = "";
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if (c == '@') {
                        c = '_';
                    }
                    newS = newS + c;
                }
                str = newS;
            }
        } else if (indexOfAt < 0) {
            return null;
        }
        return str;
    }

    void realizeNode(NodeInstList nil, int nodeIndex, int xoff, int yoff, double lambda, Cell parent, NodeProto proto) {
        NodeInst ni;
        double lowX = nil.lowX[nodeIndex] - xoff;
        double lowY = nil.lowY[nodeIndex] - yoff;
        double highX = nil.highX[nodeIndex] - xoff;
        double highY = nil.highY[nodeIndex] - yoff;
        Point2D.Double center = new Point2D.Double((lowX + highX) / 2.0 / lambda, (lowY + highY) / 2.0 / lambda);
        EPoint size = EPoint.ORIGIN;
        if (proto instanceof PrimitiveNode) {
            PrimitiveNode pn = (PrimitiveNode)proto;
            size = this.getSizeCorrector(pn.getTechnology()).getSizeFromDisk(pn, (highX - lowX) / lambda, (highY - lowY) / lambda);
        }
        int rotation = nil.rotation[nodeIndex];
        boolean flipX = false;
        boolean flipY = false;
        if (this.rotationMirrorBits) {
            if ((nil.transpose[nodeIndex] & 1) != 0) {
                flipY = true;
                rotation = (rotation + 900) % 3600;
            }
            if ((nil.transpose[nodeIndex] & 2) != 0) {
                flipX = true;
            }
            if ((nil.transpose[nodeIndex] & 4) != 0) {
                flipY = !flipY;
            }
        } else if (nil.transpose[nodeIndex] != 0) {
            flipY = true;
            rotation = (rotation + 900) % 3600;
        }
        Orientation orient = Orientation.fromJava(rotation, flipX, flipY);
        if (proto instanceof Cell) {
            if (nil.anchorX != null) {
                double anchorX = (double)(nil.anchorX[nodeIndex] - xoff) / lambda;
                double anchorY = (double)(nil.anchorY[nodeIndex] - yoff) / lambda;
                ((Point2D)center).setLocation(anchorX, anchorY);
            } else {
                Cell subCell = (Cell)proto;
                ERectangle bounds = subCell.getBounds();
                Point2D.Double shift = new Point2D.Double(-bounds.getCenterX(), -bounds.getCenterY());
                AffineTransform trans = orient.pureRotate();
                trans.transform(shift, shift);
                ((Point2D)center).setLocation(((Point2D)center).getX() + ((Point2D)shift).getX(), ((Point2D)center).getY() + ((Point2D)shift).getY());
            }
        }
        int flags = ImmutableNodeInst.flagsFromElib(nil.userBits[nodeIndex]);
        int techBits = ImmutableNodeInst.techSpecificFromElib(nil.userBits[nodeIndex]);
        nil.theNode[nodeIndex] = ni = NodeInst.newInstance(parent, proto, nil.name[nodeIndex], nil.nameTextDescriptor[nodeIndex], center, size, orient, flags, techBits, nil.protoTextDescriptor[nodeIndex], Input.errorLogger);
        if (ni == null) {
            return;
        }
        Variable[] vars = nil.vars[nodeIndex];
        if (vars != null) {
            for (int j = 0; j < vars.length; ++j) {
                Object value;
                Variable var = vars[j];
                if (var == null) continue;
                if (var.getKey() == NodeInst.TRACE && proto instanceof PrimitiveNode && ((PrimitiveNode)proto).isHoldsOutline() && ((value = var.getObject()) instanceof Integer[] || value instanceof Float[])) {
                    Number[] outline = (Number[])value;
                    int newLength = outline.length / 2;
                    EPoint[] newOutline = new EPoint[newLength];
                    double lam = outline instanceof Integer[] ? lambda : 1.0;
                    for (int k = 0; k < newLength; ++k) {
                        double oldX = outline[k * 2].doubleValue() / lam;
                        double oldY = outline[k * 2 + 1].doubleValue() / lam;
                        newOutline[k] = new EPoint(oldX, oldY);
                    }
                    var = var.withObject(newOutline);
                }
                if (ni.isDeprecatedVariable(var.getKey())) continue;
                if (ni.isParam(var.getKey())) {
                    ni.addParameter(var);
                    continue;
                }
                ni.addVar(var.withParam(false));
            }
        }
        if (proto instanceof Cell && ((Cell)proto).getVar(IO_DUMMY_OBJECT) != null) {
            Input.errorLogger.logError("Instance of dummy cell " + proto.getName(), ni, parent, null, 1);
        }
    }

    void realizeVariables(ElectricObject eObj, Variable[] vars) {
        if (vars == null) {
            return;
        }
        for (Variable var : vars) {
            this.realizeVariable(eObj, var);
        }
    }

    private void realizeVariable(ElectricObject eObj, Variable var) {
        if (var == null || eObj.isDeprecatedVariable(var.getKey())) {
            return;
        }
        if (eObj.isParam(var.getKey()) && eObj instanceof NodeInst) {
            ((NodeInst)eObj).addParameter(var);
            return;
        }
        var = var.withParam(false);
        String origVarName = var.getKey().toString();
        if (eObj instanceof NodeInst && var.getKey().getName().startsWith("ATTRP_")) {
            NodeInst ni = (NodeInst)eObj;
            StringBuffer portName = new StringBuffer();
            String varName = null;
            int len = origVarName.length();
            for (int j = 6; j < len; ++j) {
                char ch = origVarName.charAt(j);
                if (ch == '\\') {
                    portName.append(origVarName.charAt(++j));
                    continue;
                }
                if (ch == '_') {
                    varName = origVarName.substring(j + 1);
                    break;
                }
                portName.append(ch);
            }
            if (varName != null) {
                PortInst pi;
                String thePortName = portName.toString();
                PortProto pp = LibraryFiles.findPortProto(ni.getProto(), thePortName);
                PortInst portInst = pi = pp != null ? ni.findPortInstFromProto(pp) : null;
                if (pi != null) {
                    pi.newVar(Variable.newKey(varName), var.getObject(), var.getTextDescriptor());
                    return;
                }
            }
        }
        eObj.addVar(var);
    }

    static PortProto findPortProto(NodeProto np, String portId) {
        PrimitiveNode primNode;
        PortProtoId portProtoId = np.getId().newPortId(portId);
        PortProto pp = np.getPort(portProtoId);
        if (pp != null) {
            return pp;
        }
        if (np.getNumPorts() == 1 && portId.length() == 0) {
            return np.getPort(0);
        }
        if (np instanceof PrimitiveNode && (pp = (PrimitivePort)(primNode = (PrimitiveNode)np).findPortProto(portId)) == null) {
            pp = primNode.getTechnology().convertOldPortName(portId, primNode);
        }
        return pp;
    }

    void realizeMeaningPrefs(Object obj, Variable[] vars) {
        LibraryFiles.realizeMeaningPrefs(this.projectSettings, obj, vars);
    }

    static void realizeMeaningPrefs(HashMap<Setting, Object> projectSettings, Object obj, Variable[] vars) {
        for (int i = 0; i < vars.length; ++i) {
            Setting setting;
            Variable var = vars[i];
            if (var == null) continue;
            Object value = var.getObject();
            if (!(value instanceof String)) {
                if (value instanceof Short || value instanceof Byte) {
                    value = new Integer(((Number)value).intValue());
                }
                if (!(value instanceof Number) && !(value instanceof Boolean)) continue;
            }
            String prefName = var.getKey().getName();
            String prefPath = null;
            if (obj instanceof Technology) {
                prefPath = Technology.getTechnologyPreferences().absolutePath() + "/";
                Map<Setting, Object> convertedVars = ((Technology)obj).convertOldVariable(prefName, value);
                if (convertedVars != null) {
                    for (Map.Entry<Setting, Object> e : convertedVars.entrySet()) {
                        Setting setting2 = e.getKey();
                        prefName = setting2.getPrefName();
                        value = e.getValue();
                        projectSettings.put(setting2, value);
                    }
                    continue;
                }
            } else if (obj instanceof Tool) {
                prefPath = ((Tool)obj).prefs.absolutePath() + "/";
            }
            if ((setting = Setting.getSettingByPrefPath(prefPath + prefName)) == null) continue;
            projectSettings.put(setting, value);
        }
    }

    TextDescriptor makeDescriptor(int td0, int td1) {
        this.mtd.setCBits(td0, this.fixTextDescriptorFont(td1));
        return TextDescriptor.newTextDescriptor(this.mtd);
    }

    TextDescriptor makeDescriptor(int td0, int td1, int flags) {
        this.mtd.setCBits(td0, this.fixTextDescriptorFont(td1), flags);
        return TextDescriptor.newTextDescriptor(this.mtd);
    }

    void setFontNames(String[] associationArray) {
        int fontNumber;
        int i;
        int maxAssociation = 0;
        for (i = 0; i < associationArray.length; ++i) {
            if (associationArray[i] == null || (fontNumber = TextUtils.atoi(associationArray[i])) <= maxAssociation) continue;
            maxAssociation = fontNumber;
        }
        if (maxAssociation <= 0) {
            return;
        }
        this.fontNames = new String[maxAssociation];
        for (i = 0; i < maxAssociation; ++i) {
            this.fontNames[i] = null;
        }
        for (i = 0; i < associationArray.length; ++i) {
            int slashPos;
            if (associationArray[i] == null || (fontNumber = TextUtils.atoi(associationArray[i])) <= 0 || (slashPos = associationArray[i].indexOf(47)) < 0) continue;
            this.fontNames[fontNumber - 1] = associationArray[i].substring(slashPos + 1);
        }
    }

    private int fixTextDescriptorFont(int descriptor1) {
        String fontName;
        AbstractTextDescriptor.ActiveFont af;
        int fontNumber = (descriptor1 & 0x3F8000) >> 15;
        if (fontNumber == 0) {
            return descriptor1;
        }
        descriptor1 &= 0xFFC07FFF;
        if (this.fontNames != null && fontNumber <= this.fontNames.length && (af = AbstractTextDescriptor.ActiveFont.findActiveFont(fontName = this.fontNames[fontNumber - 1])) != null && (fontNumber = af.getIndex()) <= 127) {
            descriptor1 |= fontNumber << 15;
        }
        return descriptor1;
    }

    void setLineNumber(int lineNumber) {
    }

    void logError(String message) {
        ++this.errorCount;
        System.out.println(message);
        errorLogger.logError(message, -1);
    }

    void logWarning(String message) {
        System.out.println(message);
        errorLogger.logWarning(message, null, -1);
    }

    protected void computeTech(Cell cell, Set uncomputedCells) {
        uncomputedCells.remove(cell);
    }

    protected double computeLambda(Cell cell, int cellIndex) {
        return 1.0;
    }

    protected boolean spreadLambda(Cell cell, int cellIndex) {
        return false;
    }

    protected boolean canScale() {
        return false;
    }

    abstract void realizeCellsRecursively(Cell var1, HashSet<Cell> var2, String var3, double var4);

    static {
        mainLibDirectory = null;
        TINYDISTANCE = DBMath.getEpsilon() * 2.0;
    }

    static class NodeInstList {
        NodeInst[] theNode;
        NodeProto[] protoType;
        String[] name;
        TextDescriptor[] nameTextDescriptor;
        int[] lowX;
        int[] highX;
        int[] lowY;
        int[] highY;
        int[] anchorX;
        int[] anchorY;
        short[] rotation;
        int[] transpose;
        TextDescriptor[] protoTextDescriptor;
        int[] userBits;
        Variable[][] vars;

        NodeInstList(int nodeCount, boolean hasAnchor) {
            this.theNode = new NodeInst[nodeCount];
            this.protoType = new NodeProto[nodeCount];
            this.name = new String[nodeCount];
            this.nameTextDescriptor = new TextDescriptor[nodeCount];
            this.lowX = new int[nodeCount];
            this.highX = new int[nodeCount];
            this.lowY = new int[nodeCount];
            this.highY = new int[nodeCount];
            if (hasAnchor) {
                this.anchorX = new int[nodeCount];
                this.anchorY = new int[nodeCount];
            }
            this.rotation = new short[nodeCount];
            this.transpose = new int[nodeCount];
            this.protoTextDescriptor = new TextDescriptor[nodeCount];
            this.userBits = new int[nodeCount];
            this.vars = new Variable[nodeCount][];
        }
    }
}

