/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Schematic {
    private static HashSet<ElectricObject> nodesChecked = new HashSet();
    private static ErrorLogger errorLogger = null;
    private static HashMap<Geometric, List<Variable>> newVariables = new HashMap();

    public static ErrorLogger doCheck(ErrorLogger errorLog, Cell cell, Geometric[] geomsToCheck) {
        nodesChecked.clear();
        newVariables.clear();
        errorLogger = errorLog;
        if (errorLogger == null) {
            errorLogger = DRC.getDRCErrorLogger(false, false, null);
        }
        Schematic.checkSchematicCellRecursively(cell, geomsToCheck);
        errorLogger.termLogging(true);
        DRC.addDRCUpdate(0, null, null, null, null, newVariables);
        return errorLogger;
    }

    private static Cell isACellToCheck(Geometric geo) {
        if (geo instanceof NodeInst) {
            NodeInst ni = (NodeInst)geo;
            if (ni.isIconOfParent()) {
                return null;
            }
            if (!ni.isCellInstance()) {
                return null;
            }
            Cell subCell = (Cell)ni.getProto();
            Cell contentsCell = subCell.contentsView();
            if (contentsCell == null) {
                contentsCell = subCell;
            }
            if (nodesChecked.contains(contentsCell)) {
                return null;
            }
            return contentsCell;
        }
        return null;
    }

    private static void checkSchematicCellRecursively(Cell cell, Geometric[] geomsToCheck) {
        nodesChecked.add(cell);
        if (!cell.isSchematic() && cell.getTechnology() != Schematics.tech()) {
            return;
        }
        if (geomsToCheck == null) {
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                Cell contentsCell = Schematic.isACellToCheck(ni);
                if (contentsCell == null) continue;
                Schematic.checkSchematicCellRecursively(contentsCell, geomsToCheck);
            }
        } else {
            for (Geometric geo : geomsToCheck) {
                Cell contentsCell = Schematic.isACellToCheck(geo);
                if (contentsCell == null) continue;
                Schematic.checkSchematicCellRecursively(contentsCell, geomsToCheck);
            }
        }
        System.out.println("Checking schematic " + cell);
        Schematic.checkSchematicCell(cell, false, geomsToCheck);
    }

    private static void checkSchematicCell(Cell cell, boolean justThis, Geometric[] geomsToCheck) {
        int initialErrorCount = errorLogger.getNumErrors();
        Netlist netlist = NetworkTool.getUserNetlist(cell);
        if (geomsToCheck == null) {
            Iterator<Geometric> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance() && ni.getProto().getTechnology() == Generic.tech()) continue;
                Schematic.schematicDoCheck(netlist, ni);
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                Schematic.schematicDoCheck(netlist, ai);
            }
        } else {
            for (Geometric geo : geomsToCheck) {
                Schematic.schematicDoCheck(netlist, geo);
            }
        }
        int errorCount = errorLogger.getNumErrors();
        int thisErrors = errorCount - initialErrorCount;
        String indent = "   ";
        if (justThis) {
            indent = "";
        }
        if (thisErrors == 0) {
            System.out.println(indent + "No errors found");
        } else {
            System.out.println(indent + thisErrors + " errors found");
        }
        if (justThis) {
            errorLogger.termLogging(true);
        }
    }

    private static void addVariable(NodeInst ni, Variable var) {
        List<Variable> list = newVariables.get(ni);
        if (list == null) {
            list = new ArrayList<Variable>();
            newVariables.put(ni, list);
        }
        list.add(var);
    }

    private static void schematicDoCheck(Netlist netlist, Geometric geom) {
        if (nodesChecked.contains(geom)) {
            return;
        }
        nodesChecked.add(geom);
        Cell cell = geom.getParent();
        if (geom instanceof NodeInst) {
            Iterator<Object> it;
            ArrayList<Geometric> geomList;
            Iterator<Object> it2;
            boolean found;
            NodeInst ni = (NodeInst)geom;
            NodeProto np = ni.getProto();
            if (np == Schematics.tech().busPinNode) {
                Connection con;
                if (!ni.hasExports()) {
                    found = false;
                    it2 = ni.getConnections();
                    while (it2.hasNext()) {
                        con = it2.next();
                        if (con.getArc().getProto() != Schematics.tech().bus_arc) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        errorLogger.logError("Bus pin does not connect to any bus arcs", geom, cell, null, 0);
                        return;
                    }
                }
                int i = 0;
                it2 = ni.getConnections();
                while (it2.hasNext()) {
                    con = it2.next();
                    if (con.getArc().getProto() != Schematics.tech().wire_arc) continue;
                    ++i;
                }
                if (i > 1) {
                    geomList = new ArrayList<Geometric>();
                    geomList.add(geom);
                    it = ni.getConnections();
                    while (it.hasNext()) {
                        Connection con2 = (Connection)it.next();
                        if (con2.getArc().getProto() == Schematics.tech().wire_arc) {
                            ++i;
                        }
                        geomList.add(con2.getArc());
                    }
                    errorLogger.logError("Wire arcs cannot connect through a bus pin", geomList, null, cell, 0);
                    return;
                }
            }
            if (np.getFunction() == PrimitiveNode.Function.PIN) {
                if (!ni.hasExports() && !ni.hasConnections()) {
                    found = false;
                    it2 = ni.getVariables();
                    while (it2.hasNext()) {
                        Variable var = (Variable)it2.next();
                        if (!var.isDisplay()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        errorLogger.logError("Stranded pin (not connected or exported)", geom, cell, null, 0);
                        return;
                    }
                }
                if (ni.isInlinePin()) {
                    errorLogger.logError("Unnecessary pin (between 2 arcs)", geom, cell, null, 0);
                    return;
                }
                Point2D pinLoc = ni.invisiblePinWithOffsetText(false);
                if (pinLoc != null) {
                    geomList = new ArrayList();
                    ArrayList<EPoint> ptList = new ArrayList<EPoint>();
                    geomList.add(geom);
                    ptList.add(new EPoint(ni.getAnchorCenterX(), ni.getAnchorCenterY()));
                    ptList.add(new EPoint(pinLoc.getX(), pinLoc.getY()));
                    errorLogger.logError("Invisible pin has text in different location", geomList, null, ptList, null, null, cell, 0);
                    return;
                }
            }
            if (np instanceof Cell) {
                Cell instCell = (Cell)np;
                Cell contentsCell = instCell.contentsView();
                if (contentsCell == null) {
                    contentsCell = instCell;
                }
                it = ni.getDefinedParameters();
                while (it.hasNext()) {
                    String trueVarName;
                    Variable var = it.next();
                    assert (ni.isParam(var.getKey()));
                    Variable foundVar = contentsCell.getParameter(var.getKey());
                    if (foundVar == null) {
                        trueVarName = var.getTrueName();
                        errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " is invalid", geom, cell, null, 0);
                        continue;
                    }
                    if (var.getUnit() != foundVar.getUnit()) {
                        trueVarName = var.getTrueName();
                        errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " had incorrect units (now fixed)", geom, cell, null, 0);
                        Schematic.addVariable(ni, var.withUnit(foundVar.getUnit()));
                    }
                    if (foundVar.isInterior()) {
                        if (!var.isDisplay()) continue;
                        trueVarName = var.getTrueName();
                        errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " should not be visible (now fixed)", geom, cell, null, 0);
                        Schematic.addVariable(ni, var.withDisplay(false));
                        continue;
                    }
                    if (var.isDisplay()) continue;
                    trueVarName = var.getTrueName();
                    errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " should be visible (now fixed)", geom, cell, null, 0);
                    Schematic.addVariable(ni, var.withDisplay(true));
                }
            }
            Schematic.checkPortOverlap(netlist, ni);
        } else {
            int signals;
            Name name;
            ArcInst ai = (ArcInst)geom;
            boolean checkDangle = false;
            if (Artwork.isArtworkArc(ai.getProto())) {
                return;
            }
            Name arcName = ai.getNameKey();
            if (arcName == null || arcName.isTempname()) {
                checkDangle = true;
            }
            if (checkDangle && ai.getProto() == Schematics.tech().bus_arc && (name = netlist.getBusName(ai)) != null && !name.isTempname()) {
                checkDangle = false;
            }
            if (checkDangle) {
                for (int i = 0; i < 2; ++i) {
                    NodeInst ni = ai.getPortInst(i).getNodeInst();
                    if (ni.getProto().getFunction() != PrimitiveNode.Function.PIN || ni.hasExports() || ni.getNumConnections() != 1) continue;
                    errorLogger.logError("Arc dangles", geom, cell, null, 0);
                    return;
                }
            }
            if ((signals = netlist.getBusWidth(ai)) < 1) {
                signals = 1;
            }
            for (int i = 0; i < 2; ++i) {
                int nodeSize;
                PortInst pi = ai.getPortInst(i);
                NodeInst ni = pi.getNodeInst();
                if (!ni.isCellInstance()) continue;
                Cell subNp = (Cell)ni.getProto();
                PortProto pp = pi.getPortProto();
                Cell np = subNp.contentsView();
                if (np != null && ((pp = ((Export)pi.getPortProto()).getEquivalent()) == null || pp == pi.getPortProto())) {
                    ArrayList<Geometric> geomList = new ArrayList<Geometric>();
                    geomList.add(geom);
                    geomList.add(ni);
                    errorLogger.logError("Arc " + ai.describe(true) + " connects to " + pi.getPortProto() + " of " + ni + ", but there is no equivalent port in " + np, geomList, null, cell, 0);
                    continue;
                }
                int portWidth = netlist.getBusWidth((Export)pp);
                if (portWidth < 1) {
                    portWidth = 1;
                }
                if ((nodeSize = ni.getNameKey().busWidth()) <= 0) {
                    nodeSize = 1;
                }
                if (signals == portWidth || signals == portWidth * nodeSize) continue;
                ArrayList<Geometric> geomList = new ArrayList<Geometric>();
                geomList.add(geom);
                geomList.add(ni);
                errorLogger.logError("Arc " + ai.describe(true) + " (" + signals + " wide) connects to " + pp + " of " + ni + " (" + portWidth + " wide)", geomList, null, cell, 0);
            }
        }
    }

    private static void checkPortOverlap(Netlist netlist, NodeInst ni) {
        if (ni.getProto().getTechnology() == Generic.tech() || ni.getProto().getTechnology() == Artwork.tech()) {
            return;
        }
        Cell cell = ni.getParent();
        Iterator<PortInst> it = ni.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = it.next();
            Network net = netlist.getNetwork(pi);
            Rectangle2D bounds = pi.getPoly().getBounds2D();
            Iterator<RTBounds> sIt = cell.searchIterator(bounds);
            while (sIt.hasNext()) {
                NodeInst oNi;
                Geometric oGeom = (Geometric)sIt.next();
                if (!(oGeom instanceof NodeInst) || ni == (oNi = (NodeInst)oGeom) || ni.getNodeIndex() > oNi.getNodeIndex() || oNi.getProto().getTechnology() == Generic.tech() || oNi.getProto().getTechnology() == Artwork.tech()) continue;
                Iterator<PortInst> pIt = oNi.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst oPi = pIt.next();
                    Rectangle2D oBounds = oPi.getPoly().getBounds2D();
                    if (bounds.getMaxX() < oBounds.getMinX() || bounds.getMinX() > oBounds.getMaxX() || bounds.getMaxY() < oBounds.getMinY() || bounds.getMinY() > oBounds.getMaxY() || net == netlist.getNetwork(oPi)) continue;
                    ArrayList<Geometric> geomList = new ArrayList<Geometric>();
                    geomList.add(ni);
                    geomList.add(oNi);
                    errorLogger.logError("Nodes '" + ni + "' '" + oNi + "' have touching ports that are not connected", geomList, null, cell, 0);
                    return;
                }
            }
        }
    }
}

