/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ERCAntenna {
    public static final double DEFPOLYRATIO = 200.0;
    public static final double DEFMETALRATIO = 400.0;
    public static final double DEFPOLYTHICKNESS = 2.0;
    public static final double DEFMETALTHICKNESS = 5.7;
    private static final int ERCANTPATHNULL = 0;
    private static final int ERCANTPATHGATE = 1;
    private static final int ERCANTPATHACTIVE = 2;
    private static final int ERCABORTED = 3;
    private List<AntennaObject> firstSpreadAntennaObj;
    private Technology curTech;
    private Cell topCell;
    private double totalGateArea;
    private double worstRatio;
    private List<AntennaObject> pathList;
    private HashMap<ArcProto, Layer> arcProtoToLayer;
    private HashMap<Layer, ArcProto> layerToArcProto;
    private HashSet<Geometric> fsGeom;
    private HashSet<Cell> fsCell;
    private ErrorLogger errorLogger;

    private ERCAntenna() {
    }

    public static void doAntennaCheck() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        new AntennaCheckJob(cell);
    }

    private void doCheck(Job job) {
        this.curTech = this.topCell.getTechnology();
        this.fsGeom = new HashSet();
        this.fsCell = new HashSet();
        this.arcProtoToLayer = new HashMap();
        this.layerToArcProto = new HashMap();
        Iterator<ArcProto> it = this.curTech.getArcs();
        block0: while (it.hasNext()) {
            ArcProto ap = it.next();
            ArcProto.Function aFun = ap.getFunction();
            if (!aFun.isMetal() && aFun != ArcProto.Function.POLY1) continue;
            Iterator<Layer> lIt = this.curTech.getLayers();
            while (lIt.hasNext()) {
                Layer lay = lIt.next();
                Layer.Function lFun = lay.getFunction();
                if ((!aFun.isMetal() || !lFun.isMetal() || aFun.getLevel() != lFun.getLevel()) && (!aFun.isPoly() || !lFun.isPoly() || aFun.getLevel() != lFun.getLevel())) continue;
                this.arcProtoToLayer.put(ap, lay);
                this.layerToArcProto.put(lay, ap);
                continue block0;
            }
        }
        long startTime = System.currentTimeMillis();
        this.errorLogger = ErrorLogger.newInstance("ERC Antella Rules Check");
        int lasterrorcount = 0;
        this.worstRatio = 0.0;
        for (Layer lay : this.layerToArcProto.keySet()) {
            System.out.println("Checking Antenna rules for " + lay.getName() + "...");
            this.fsCell.clear();
            if (this.checkThisCell(this.topCell, lay, job)) break;
            int i = this.errorLogger.getNumErrors();
            if (i == lasterrorcount) continue;
            System.out.println("  Found " + (i - lasterrorcount) + " errors");
            lasterrorcount = i;
        }
        long endTime = System.currentTimeMillis();
        int errorCount = this.errorLogger.getNumErrors();
        if (errorCount == 0) {
            System.out.println("No antenna errors found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
        } else {
            System.out.println("FOUND " + errorCount + " ANTENNA ERRORS (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
        }
        this.errorLogger.termLogging(true);
        this.fsGeom = null;
        this.fsCell = null;
    }

    private boolean checkThisCell(Cell cell, Layer lay, Job job) {
        NodeInst ni;
        this.fsGeom.clear();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            if (job.checkAbort()) {
                return true;
            }
            ni = it.next();
            if (this.fsGeom.contains(ni)) continue;
            this.fsGeom.add(ni);
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                boolean seen = false;
                Iterator<Connection> cIt = pi.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    ArcInst ai = con.getArc();
                    if (!this.fsGeom.contains(ai)) continue;
                    seen = true;
                    break;
                }
                if (seen) continue;
                this.totalGateArea = 0.0;
                this.pathList = new ArrayList<AntennaObject>();
                int found = this.followNode(ni, pi.getPortProto(), lay, DBMath.MATID, job);
                if (found == 3) {
                    return true;
                }
                if (found != 1) continue;
                GeometryHandler vmerge = null;
                for (AntennaObject ao : this.pathList) {
                    Poly poly;
                    int i;
                    Poly[] polyList;
                    Technology tech;
                    AffineTransform tTrans;
                    AffineTransform trans;
                    if (ao.geom instanceof NodeInst) {
                        NodeInst oni = (NodeInst)ao.geom;
                        trans = oni.rotateOut();
                        for (int i2 = ao.depth - 1; i2 >= 0; --i2) {
                            tTrans = ao.hierstack[i2].translateOut();
                            trans.concatenate(tTrans);
                            AffineTransform rTrans = ao.hierstack[i2].rotateOut();
                            trans.concatenate(rTrans);
                        }
                        tech = oni.getProto().getTechnology();
                        if (tech != this.curTech) continue;
                        polyList = tech.getShapeOfNode(oni);
                        for (i = 0; i < polyList.length; ++i) {
                            poly = polyList[i];
                            if (poly.getLayer() != lay) continue;
                            if (vmerge == null) {
                                vmerge = new PolyMerge();
                            }
                            poly.transform(trans);
                            ((PolyMerge)vmerge).addPolygon(poly.getLayer(), poly);
                        }
                        continue;
                    }
                    ArcInst ai = (ArcInst)ao.geom;
                    trans = new AffineTransform();
                    for (int i3 = ao.depth - 1; i3 >= 0; --i3) {
                        tTrans = ao.hierstack[i3].translateOut();
                        trans.concatenate(tTrans);
                        AffineTransform rTrans = ao.hierstack[i3].rotateOut();
                        trans.concatenate(rTrans);
                    }
                    tech = ai.getProto().getTechnology();
                    if (tech != this.curTech) continue;
                    polyList = tech.getShapeOfArc(ai);
                    for (i = 0; i < polyList.length; ++i) {
                        poly = polyList[i];
                        if (poly.getLayer() != lay) continue;
                        if (vmerge == null) {
                            vmerge = new PolyMerge();
                        }
                        poly.transform(trans);
                        ((PolyMerge)vmerge).addPolygon(poly.getLayer(), poly);
                    }
                }
                if (vmerge == null) continue;
                double totalRegionPerimeterArea = 0.0;
                for (Layer oLay : vmerge.getKeySet()) {
                    double thickness = oLay.getThickness();
                    if (thickness == 0.0) {
                        if (oLay.getFunction().isMetal()) {
                            thickness = 5.7;
                        } else if (oLay.getFunction().isPoly()) {
                            thickness = 2.0;
                        }
                    }
                    List<PolyBase> merges = ((PolyMerge)vmerge).getMergedPoints(oLay, true);
                    for (PolyBase merged : merges) {
                        totalRegionPerimeterArea += merged.getPerimeter() * thickness;
                    }
                }
                double ratio = totalRegionPerimeterArea / this.totalGateArea;
                double neededratio = this.getAntennaRatio(lay);
                if (ratio > this.worstRatio) {
                    this.worstRatio = ratio;
                }
                if (!(ratio >= neededratio)) continue;
                String errMsg = "layer " + lay.getName() + " has perimeter-area " + totalRegionPerimeterArea + "; gates have area " + this.totalGateArea + ", ratio is " + ratio + " but limit is " + neededratio;
                ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                for (Layer oLay : vmerge.getKeySet()) {
                    List<PolyBase> merges = ((PolyMerge)vmerge).getMergedPoints(oLay, true);
                    for (PolyBase merged : merges) {
                        polyList.add(merged);
                    }
                }
                this.errorLogger.logError(errMsg, null, null, null, null, polyList, cell, 0);
            }
        }
        this.fsCell.add(cell);
        it = cell.getNodes();
        while (it.hasNext()) {
            Cell subCell;
            ni = it.next();
            if (!ni.isCellInstance() || this.fsCell.contains(subCell = (Cell)ni.getProto()) || !this.checkThisCell(subCell, lay, job)) continue;
            return true;
        }
        return false;
    }

    private int followNode(NodeInst ni, PortProto pp, Layer lay, AffineTransform trans, Job job) {
        int ret = 0;
        this.firstSpreadAntennaObj = new ArrayList<AntennaObject>();
        NodeInst[] antstack = new NodeInst[200];
        int depth = 0;
        block0: while (true) {
            AntennaObject ao;
            if (job.checkAbort()) {
                return 3;
            }
            this.fsGeom.add(ni);
            NodeInst thisni = ni;
            while (thisni.isCellInstance()) {
                antstack[depth] = thisni;
                ++depth;
                thisni = ((Export)pp).getOriginalPort().getNodeInst();
                pp = ((Export)pp).getOriginalPort().getPortProto();
            }
            boolean seen = false;
            if (thisni.isFET()) {
                if (thisni.getTransistorDrainPort().getPortProto() == pp || thisni.getTransistorSourcePort().getPortProto() == pp) {
                    return 2;
                }
                TransistorSize dim = thisni.getTransistorSize(VarContext.globalContext);
                this.totalGateArea += dim.getDoubleLength() * dim.getDoubleWidth();
                ret = 1;
            } else {
                if (this.hasDiffusion(thisni)) {
                    return 2;
                }
                ao = new AntennaObject(ni);
                if (this.haveAntennaObject(ao)) {
                    seen = true;
                } else {
                    ao.loadAntennaObject(antstack, depth);
                    this.addAntennaObject(ao);
                }
            }
            if (!seen) {
                int found = this.findArcs(thisni, pp, lay, depth, antstack);
                if (found == 2) {
                    return found;
                }
                if (depth > 0 && (found = this.findExports(thisni, pp, lay, depth, antstack)) == 2) {
                    return found;
                }
            }
            if (this.firstSpreadAntennaObj.size() == 0) break;
            ao = this.firstSpreadAntennaObj.get(0);
            this.firstSpreadAntennaObj.remove(0);
            ArcInst ai = (ArcInst)ao.geom;
            ni = ai.getPortInst(ao.otherend).getNodeInst();
            pp = ai.getPortInst(ao.otherend).getPortProto();
            depth = ao.hierstack.length;
            int i = 0;
            while (true) {
                if (i >= depth) continue block0;
                antstack[i] = ao.hierstack[i];
                ++i;
            }
            break;
        }
        return ret;
    }

    private boolean hasDiffusion(NodeInst ni) {
        if (ni.getFunction() == PrimitiveNode.Function.PIN) {
            return false;
        }
        Technology tech = ni.getProto().getTechnology();
        Poly[] polyList = tech.getShapeOfNode(ni);
        for (int i = 0; i < polyList.length; ++i) {
            Poly poly = polyList[i];
            Layer.Function fun = poly.getLayer().getFunction();
            if (!fun.isDiff()) continue;
            return true;
        }
        return false;
    }

    private int findArcs(NodeInst ni, PortProto pp, Layer lay, int depth, NodeInst[] antstack) {
        PortInst pi = ni.findPortInstFromProto(pp);
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            ArcInst ai = con.getArc();
            if (ai.getProto().getFunction().isDiffusion()) {
                return 2;
            }
            Layer aLayer = this.arcProtoToLayer.get(ai.getProto());
            if (aLayer == null || ai.getProto().getFunction().isMetal() != aLayer.getFunction().isMetal() || ai.getProto().getFunction().isPoly() != aLayer.getFunction().isPoly() || ai.getProto().getFunction().getLevel() > aLayer.getFunction().getLevel()) continue;
            this.fsGeom.add(ai);
            AntennaObject ao = new AntennaObject(ai);
            if (this.haveAntennaObject(ao)) continue;
            ao.loadAntennaObject(antstack, depth);
            int other = 0;
            if (ai.getPortInst(0) == pi) {
                other = 1;
            }
            ao.otherend = other;
            this.addAntennaObject(ao);
            this.firstSpreadAntennaObj.add(ao);
        }
        return 0;
    }

    private int findExports(NodeInst ni, PortProto pp, Layer lay, int depth, NodeInst[] antstack) {
        --depth;
        Iterator<Export> it = ni.getExports();
        while (it.hasNext()) {
            Export e = it.next();
            if (e != pp) continue;
            ni = antstack[depth];
            pp = e;
            int found = this.findArcs(ni, pp, lay, depth, antstack);
            if (found == 2) {
                return found;
            }
            if (depth <= 0 || (found = this.findExports(ni, pp, lay, depth, antstack)) != 2) continue;
            return found;
        }
        return 0;
    }

    private boolean haveAntennaObject(AntennaObject ao) {
        for (AntennaObject oAo : this.pathList) {
            if (oAo.geom != ao.geom || oAo.depth != ao.depth) continue;
            boolean found = true;
            int len = 0;
            if (ao.hierstack != null) {
                len = ao.hierstack.length;
            }
            int oLen = 0;
            if (oAo.hierstack != null) {
                oLen = oAo.hierstack.length;
            }
            if (len != oLen) continue;
            for (int i = 0; i < len; ++i) {
                if (oAo.hierstack[i] == ao.hierstack[i]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    private void addAntennaObject(AntennaObject ao) {
        this.pathList.add(ao);
    }

    private double getAntennaRatio(Layer layer) {
        ArcProto ap = this.layerToArcProto.get(layer);
        if (ap == null) {
            return 0.0;
        }
        return ERC.tool.getAntennaRatio(ap);
    }

    private static class AntennaCheckJob
    extends Job {
        private Cell cell;

        private AntennaCheckJob(Cell cell) {
            super("ERC Antenna Check", ERC.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            ERCAntenna handler = new ERCAntenna();
            handler.topCell = this.cell;
            handler.doCheck(this);
            return true;
        }
    }

    private static class AntennaObject {
        Geometric geom;
        int depth;
        int otherend;
        NodeInst[] hierstack;

        AntennaObject(Geometric geom) {
            this.geom = geom;
        }

        private void loadAntennaObject(NodeInst[] stack, int depth) {
            this.hierstack = new NodeInst[depth];
            for (int i = 0; i < depth; ++i) {
                this.hierstack[i] = stack[i];
            }
        }
    }
}

