/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.routing.MimicStitch;
import com.sun.electric.tool.user.User;
import java.awt.geom.Point2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Routing
extends Listener {
    private Activity current;
    private Activity past = null;
    private boolean checkAutoStitch = false;
    private static Routing tool = new Routing();
    private static boolean sunRouterChecked = false;
    private static Class sunRouterClass = null;
    private static Method sunRouterMethod;
    private static Cell copiedTopologyCell;
    private static Pref cachePreferredRoutingArc;
    private static Pref cacheAutoStitchOn;
    private static Pref cacheMimicStitchOn;
    private static Pref cacheMimicStitchInteractive;
    private static Pref cacheMimicStitchPinsKept;
    private static Pref cacheMimicStitchMatchPorts;
    private static Pref cacheMimicStitchMatchPortWidth;
    private static Pref cacheMimicStitchMatchNumArcs;
    private static Pref cacheMimicStitchMatchNodeSize;
    private static Pref cacheMimicStitchMatchNodeType;
    private static Pref cacheMimicStitchNoOtherArcsSameDir;
    private static Pref cacheSLRVerboseLevel;
    private static Pref cacheSLRCostLimit;
    private static Pref cacheSLRCutlineDeviation;
    private static Pref cacheSLRDelta;
    private static Pref cacheSLRXBitSize;
    private static Pref cacheSLRYBitSize;
    private static Pref cacheSLRXTileSize;
    private static Pref cacheSLRYTileSize;
    private static Pref cacheSLRLayerAssgnCapF;
    private static Pref cacheSLRLengthLongNet;
    private static Pref cacheSLRLengthMedNet;
    private static Pref cacheSLRTilesPerPinLongNet;
    private static Pref cacheSLRTilesPerPinMedNet;
    private static Pref cacheSLROneTileFactor;
    private static Pref cacheSLROverloadLimit;
    private static Pref cacheSLRPinFactor;
    private static Pref cacheSLRUPinDensityF;
    private static Pref cacheSLRWindow;
    private static Pref cacheWireOffset;
    private static Pref cacheWireModulo;
    private static Pref cacheWireBlockageFactor;
    private static Pref cacheRipUpMaximum;
    private static Pref cacheRipUpPenalty;
    private static Pref cacheRipUpExpansion;
    private static Pref cacheZRipUpExpansion;
    private static Pref cacheRipUpSearches;
    private static Pref cacheGlobalPathExpansion;
    private static Pref cacheSourceAccessExpansion;
    private static Pref cacheSinkAccessExpansion;
    private static Pref cacheDenseViaAreaSize;
    private static Pref cacheRetryExpandRouting;
    private static Pref cacheRetryDenseViaAreaSize;
    private static Pref cachePathSearchControl;
    private static Pref cacheSparseViaModulo;
    private static Pref cacheLowPathSearchCost;
    private static Pref cacheMediumPathSearchCost;
    private static Pref cacheHighPathSearchCost;
    private static Pref cacheTakenPathSearchCost;

    private Routing() {
        super("routing");
    }

    @Override
    public void init() {
        this.setOn();
    }

    public static Routing getRoutingTool() {
        return tool;
    }

    @Override
    public void endBatch(Snapshot oldSnapshot, Snapshot newSnapshot, boolean undoRedo) {
        if (undoRedo) {
            return;
        }
        if (newSnapshot.tool == tool) {
            return;
        }
        this.current = new Activity();
        this.checkAutoStitch = false;
        for (CellId cellId : newSnapshot.getChangedCells(oldSnapshot)) {
            ImmutableElectricObject oldD;
            ImmutableElectricObject d;
            CellBackup oldBackup;
            Cell cell = Cell.inCurrentThread(cellId);
            if (cell == null || (oldBackup = oldSnapshot.getCell(cellId)) == null || oldBackup == cell.backup()) continue;
            ArrayList<ImmutableNodeInst> oldNodes = new ArrayList<ImmutableNodeInst>();
            for (ImmutableNodeInst n : oldBackup.nodes) {
                while (n.nodeId >= oldNodes.size()) {
                    oldNodes.add(null);
                }
                oldNodes.set(n.nodeId, n);
            }
            ArrayList<ImmutableArcInst> oldArcs = new ArrayList<ImmutableArcInst>();
            for (ImmutableArcInst a : oldBackup.arcs) {
                while (a.arcId >= oldArcs.size()) {
                    oldArcs.add(null);
                }
                oldArcs.set(a.arcId, a);
            }
            Iterator<Geometric> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                d = ni.getD();
                ImmutableNodeInst immutableNodeInst = oldD = d.nodeId < oldNodes.size() ? (ImmutableNodeInst)oldNodes.get(d.nodeId) : null;
                if (oldD == null) {
                    if (this.current.numCreatedNodes >= 3) continue;
                    this.current.createdNodes[this.current.numCreatedNodes++] = ni;
                    continue;
                }
                if (oldD == d) continue;
                this.checkAutoStitch = true;
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                d = ai.getD();
                oldD = ((ImmutableArcInst)d).arcId < oldArcs.size() ? (ImmutableArcInst)oldArcs.get(((ImmutableArcInst)d).arcId) : null;
                if (oldD != null || this.current.numCreatedArcs >= 3) continue;
                this.current.createdArcs[this.current.numCreatedArcs++] = ai;
            }
            for (ImmutableArcInst nid : oldBackup.arcs) {
                if (nid == null || cell.getNodeById(nid.arcId) != null) continue;
                ++this.current.numDeletedNodes;
            }
            for (ImmutableArcInst aid : oldBackup.arcs) {
                if (aid == null || cell.getArcById(aid.arcId) != null) continue;
                if (this.current.numDeletedArcs == 0) {
                    this.current.deletedArc = aid;
                    this.current.deletedArcParent = cell.getId();
                    this.current.deletedPorts[0] = aid.headPortId;
                    this.current.deletedPorts[1] = aid.tailPortId;
                }
                ++this.current.numDeletedArcs;
            }
        }
        if (this.current.numCreatedArcs > 0 || this.current.numCreatedNodes > 0 || this.current.deletedArc != null) {
            this.past = this.current;
            if (Routing.isMimicStitchOn()) {
                MimicStitch.mimicStitch(false);
                return;
            }
        }
        if (this.checkAutoStitch && Routing.isAutoStitchOn()) {
            AutoStitch.autoStitch(false, false);
        }
        this.current = null;
    }

    public void mimicSelected() {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        ArcInst ai = (ArcInst)wnd.getOneElectricObject(ArcInst.class);
        if (ai == null) {
            return;
        }
        this.past = new Activity();
        this.past.createdArcs[this.past.numCreatedArcs++] = ai;
        MimicStitch.mimicStitch(false);
    }

    public static void unrouteCurrent() {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        Set<Network> nets = wnd.getHighlightedNetworks();
        if (nets.size() == 0) {
            System.out.println("Must select networks to unroute");
            return;
        }
        new UnrouteJob(cell, nets);
    }

    public static ArcProto getPreferredRoutingArcProto() {
        ArcProto curAp;
        ArcProto preferredArc = null;
        String preferredName = Routing.getPreferredRoutingArc();
        if (preferredName.length() > 0) {
            preferredArc = ArcProto.findArcProto(preferredName);
        }
        if (preferredArc == null && (curAp = User.getUserTool().getCurrentArcProto()) != null) {
            preferredArc = curAp;
        }
        return preferredArc;
    }

    public static List<Connection> findNetEnds(Network net, HashSet<ArcInst> arcsToDelete, HashSet<NodeInst> nodesToDelete, Netlist netList) {
        Cell cell = net.getParent();
        ArrayList<Connection> endList = new ArrayList<Connection>();
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            Network aNet = netList.getNetwork(ai, 0);
            if (aNet != net) continue;
            arcsToDelete.add(ai);
            for (int i = 0; i < 2; ++i) {
                Connection thisCon = ai.getConnection(i);
                NodeInst ni = thisCon.getPortInst().getNodeInst();
                boolean term = true;
                Iterator<Connection> cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    if (con.equals(thisCon) || netList.getNetwork(con.getArc(), 0) != net) continue;
                    term = false;
                    break;
                }
                if (ni.hasExports()) {
                    term = true;
                }
                if (ni.isCellInstance()) {
                    term = true;
                }
                if (term) {
                    if (endList.contains(thisCon)) continue;
                    endList.add(thisCon);
                    continue;
                }
                nodesToDelete.add(ni);
            }
        }
        return endList;
    }

    public Activity getLastActivity() {
        return this.past;
    }

    public static boolean hasSunRouter() {
        if (!sunRouterChecked) {
            sunRouterChecked = true;
            try {
                sunRouterClass = Class.forName("com.sun.electric.plugins.sunRouter.SunRouter");
            }
            catch (ClassNotFoundException e) {
                sunRouterClass = null;
                return false;
            }
            try {
                sunRouterMethod = sunRouterClass.getMethod("routeCell", Cell.class);
            }
            catch (NoSuchMethodException e) {
                sunRouterClass = null;
                return false;
            }
        }
        return sunRouterClass != null;
    }

    public static void sunRouteCurrentCell() {
        if (!Routing.hasSunRouter()) {
            return;
        }
        UserInterface ui = Job.getUserInterface();
        Cell curCell = ui.needCurrentCell();
        if (curCell == null) {
            return;
        }
        try {
            sunRouterMethod.invoke((Object)sunRouterClass, curCell);
        }
        catch (Exception e) {
            System.out.println("Unable to run the Sun Router module");
            e.printStackTrace(System.out);
        }
    }

    public static void copyRoutingTopology() {
        UserInterface ui = Job.getUserInterface();
        Cell np = ui.needCurrentCell();
        if (np == null) {
            return;
        }
        copiedTopologyCell = np;
        System.out.println("Cell " + np.describe(true) + " will have its connectivity remembered");
    }

    public static void pasteRoutingTopology() {
        if (copiedTopologyCell == null) {
            System.out.println("Must copy topology before pasting it");
            return;
        }
        if (!copiedTopologyCell.isLinked()) {
            System.out.println("Copied cell is no longer valid");
            return;
        }
        UserInterface ui = Job.getUserInterface();
        Cell toCell = ui.needCurrentCell();
        if (toCell == null) {
            return;
        }
        if (copiedTopologyCell == toCell) {
            System.out.println("Topology must be copied to a different cell");
            return;
        }
        new CopyRoutingTopology(copiedTopologyCell, toCell);
    }

    public static boolean copyTopology(Cell fromCell, Cell toCell) {
        NodeInst tNi;
        System.out.println("Copying topology of " + fromCell + " to " + toCell);
        int wiresMade = 0;
        HashMap<NodeInst, NodeInst> nodesAssoc = new HashMap<NodeInst, NodeInst>();
        Iterator<NodeInst> it = toCell.getNodes();
        block0: while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.getProto() == Generic.tech.cellCenterNode || ni.getProto() == Generic.tech.essentialBoundsNode || nodesAssoc.get(ni) != null) continue;
            PrimitiveNode.Function fun = null;
            if (!(ni.isCellInstance() || (fun = ni.getFunction()) != PrimitiveNode.Function.UNKNOWN && fun != PrimitiveNode.Function.PIN && fun != PrimitiveNode.Function.CONTACT && fun != PrimitiveNode.Function.NODE)) {
                if (!ni.hasExports()) continue;
                Iterator<Export> eIt = ni.getExports();
                while (eIt.hasNext()) {
                    Export e = eIt.next();
                    Export fromE = fromCell.findExport(e.getName());
                    if (fromE == null) continue;
                    nodesAssoc.put(ni, fromE.getOriginalPort().getNodeInst());
                    continue block0;
                }
                continue;
            }
            ArrayList<NodeInst> fromList = new ArrayList<NodeInst>();
            Iterator<NodeInst> nIt = fromCell.getNodes();
            while (nIt.hasNext()) {
                NodeInst oNi = nIt.next();
                if (ni.isCellInstance()) {
                    if (((Cell)oNi.getProto()).getCellGroup() != ((Cell)ni.getProto()).getCellGroup()) continue;
                    fromList.add(oNi);
                    continue;
                }
                PrimitiveNode.Function oFun = oNi.getFunction();
                if (oFun != fun) continue;
                fromList.add(oNi);
            }
            ArrayList<NodeInst> toList = new ArrayList<NodeInst>();
            Iterator<NodeInst> nIt2 = toCell.getNodes();
            while (nIt2.hasNext()) {
                NodeInst oNi = nIt2.next();
                if (ni.isCellInstance()) {
                    if (oNi.getProto() != ni.getProto()) continue;
                    toList.add(oNi);
                    continue;
                }
                PrimitiveNode.Function oFun = oNi.getFunction();
                if (oFun != fun) continue;
                toList.add(oNi);
            }
            if (toList.size() != fromList.size()) {
                if (fromList.size() == 0) continue;
                System.out.println("Warning: " + fromCell + " has " + fromList.size() + " of " + ni.getProto() + " but " + toCell + " has " + toList.size());
                return false;
            }
            ArrayList<NodeInst> copyList = new ArrayList<NodeInst>();
            for (NodeInst fNi : fromList) {
                copyList.add(fNi);
            }
            for (NodeInst fNi : copyList) {
                String fName = fNi.getName();
                NodeInst matchedNode = null;
                for (NodeInst tNi2 : toList) {
                    String tName = tNi2.getName();
                    if (!fName.equals(tName)) continue;
                    matchedNode = tNi2;
                    break;
                }
                if (matchedNode == null) continue;
                nodesAssoc.put(matchedNode, fNi);
                fromList.remove(fNi);
            }
            if (toList.size() != fromList.size()) {
                System.out.println("Error: after name match, there are " + fromList.size() + " instances of " + ni.getProto() + " in source and " + toList.size() + " in destination");
                return false;
            }
            if (fromList.size() == 0) continue;
            Collections.sort(fromList, new InstacesSpatially());
            Collections.sort(toList, new InstacesSpatially());
            for (int i = 0; i < Math.min(toList.size(), fromList.size()); ++i) {
                NodeInst tNi3 = (NodeInst)toList.get(i);
                NodeInst fNi = (NodeInst)fromList.get(i);
                nodesAssoc.put(tNi3, fNi);
            }
        }
        Netlist fNl = fromCell.acquireUserNetlist();
        Netlist tNl = toCell.acquireUserNetlist();
        if (fNl == null || tNl == null) {
            System.out.println("Sorry, a deadlock aborted topology copying (network information unavailable).  Please try again");
            return false;
        }
        Iterator<NodeInst> tIt = toCell.getNodes();
        while (tIt.hasNext()) {
            tNi = tIt.next();
            NodeInst fNi = (NodeInst)nodesAssoc.get(tNi);
            if (fNi == null) continue;
            Iterator<NodeInst> oTIt = toCell.getNodes();
            while (oTIt.hasNext()) {
                NodeInst oFNi;
                NodeInst oTNi = oTIt.next();
                if (tNi == oTNi || (oFNi = (NodeInst)nodesAssoc.get(oTNi)) == null) continue;
                PortInst fPi = null;
                PortInst oFPi = null;
                Iterator<PortInst> fPIt = fNi.getPortInsts();
                while (fPIt.hasNext()) {
                    PortInst pi = fPIt.next();
                    Network net = fNl.getNetwork(pi);
                    Iterator<PortInst> oFPIt = oFNi.getPortInsts();
                    while (oFPIt.hasNext()) {
                        PortInst oPi = oFPIt.next();
                        Network oNet = fNl.getNetwork(oPi);
                        if (net != oNet) continue;
                        fPi = pi;
                        oFPi = oPi;
                        break;
                    }
                    if (fPi == null) continue;
                    break;
                }
                if (fPi == null) continue;
                PortProto tPp = tNi.getProto().findPortProto(fPi.getPortProto().getName());
                PortInst tPi = null;
                if (tPp != null) {
                    tPi = tNi.findPortInstFromProto(tPp);
                }
                if (tPi == null) continue;
                PortProto oTPp = oTNi.getProto().findPortProto(oFPi.getPortProto().getName());
                PortInst oTPi = null;
                if (oTPp != null) {
                    oTPi = oTNi.findPortInstFromProto(oTPp);
                }
                if (oTPi == null) continue;
                int result = Routing.makeUnroutedConnection(tPi, oTPi, toCell, tNl);
                if (result < 0) {
                    return false;
                }
                wiresMade += result;
            }
        }
        tIt = toCell.getNodes();
        while (tIt.hasNext()) {
            PortProto oTPp;
            PortInst oPi;
            PrimitiveNode.Function fun;
            tNi = tIt.next();
            if (nodesAssoc.get(tNi) != null || tNi.isCellInstance() || !tNi.hasExports() || (fun = tNi.getFunction()) != PrimitiveNode.Function.PIN && fun != PrimitiveNode.Function.CONTACT) continue;
            String matchName = tNi.getExports().next().getName();
            Network net = null;
            Iterator<PortProto> fIt = fromCell.getPorts();
            while (fIt.hasNext()) {
                Export fPp = (Export)fIt.next();
                int width = fNl.getBusWidth(fPp);
                for (int i = 0; i < width; ++i) {
                    Network aNet = fNl.getNetwork(fPp, i);
                    if (aNet == null || !aNet.toString().equalsIgnoreCase(matchName)) continue;
                    net = aNet;
                    break;
                }
                if (net == null) continue;
                break;
            }
            if (net == null) continue;
            PortInst oFPi = null;
            NodeInst oTNi = null;
            Iterator<NodeInst> oTIt = toCell.getNodes();
            while (oTIt.hasNext()) {
                NodeInst ni = oTIt.next();
                NodeInst oFNi = (NodeInst)nodesAssoc.get(ni);
                if (oFNi == null) continue;
                Iterator<PortInst> oFPIt = oFNi.getPortInsts();
                while (oFPIt.hasNext()) {
                    PortInst pi = oFPIt.next();
                    Network oNet = fNl.getNetwork(pi);
                    if (oNet == null || oNet != net) continue;
                    oFPi = pi;
                    break;
                }
                if (oFPi == null) continue;
                oTNi = ni;
                break;
            }
            if (oTNi == null || (oPi = oTNi.findPortInstFromProto(oTPp = oTNi.getProto().findPortProto(oFPi.getPortProto().getName()))) == null) continue;
            int result = Routing.makeUnroutedConnection(tNi.getPortInst(0), oPi, toCell, tNl);
            if (result < 0) {
                return false;
            }
            wiresMade += result;
        }
        if (wiresMade == 0) {
            System.out.println("No topology was copied");
        } else {
            System.out.println("Created " + wiresMade + " arcs to copy the topology");
        }
        return true;
    }

    private static int makeUnroutedConnection(PortInst fPi, PortInst tPi, Cell cell, Netlist nl) {
        Network tNet;
        Network fNet;
        if (fPi != null && tPi != null && (fNet = nl.getNetwork(fPi)) == (tNet = nl.getNetwork(tPi))) {
            return 0;
        }
        Poly fPoly = fPi.getPoly();
        Poly tPoly = tPi.getPoly();
        Point2D.Double fPt = new Point2D.Double(fPoly.getCenterX(), fPoly.getCenterY());
        Point2D.Double tPt = new Point2D.Double(tPoly.getCenterX(), tPoly.getCenterY());
        double wid = Generic.tech.unrouted_arc.getDefaultWidth();
        ArcInst ai = ArcInst.makeInstance(Generic.tech.unrouted_arc, wid, fPi, tPi, fPt, tPt, null);
        if (ai == null) {
            return -1;
        }
        return 1;
    }

    public static String getPreferredRoutingArc() {
        return cachePreferredRoutingArc.getString();
    }

    public static void setPreferredRoutingArc(String arcName) {
        cachePreferredRoutingArc.setString(arcName);
    }

    public static boolean isAutoStitchOn() {
        return cacheAutoStitchOn.getBoolean();
    }

    public static void setAutoStitchOn(boolean on) {
        cacheAutoStitchOn.setBoolean(on);
    }

    public static boolean isMimicStitchOn() {
        return cacheMimicStitchOn.getBoolean();
    }

    public static void setMimicStitchOn(boolean on) {
        cacheMimicStitchOn.setBoolean(on);
    }

    public static boolean isMimicStitchInteractive() {
        return cacheMimicStitchInteractive.getBoolean();
    }

    public static void setMimicStitchInteractive(boolean on) {
        cacheMimicStitchInteractive.setBoolean(on);
    }

    public static boolean isMimicStitchPinsKept() {
        return cacheMimicStitchPinsKept.getBoolean();
    }

    public static void setMimicStitchPinsKept(boolean on) {
        cacheMimicStitchPinsKept.setBoolean(on);
    }

    public static boolean isMimicStitchMatchPorts() {
        return cacheMimicStitchMatchPorts.getBoolean();
    }

    public static void setMimicStitchMatchPorts(boolean on) {
        cacheMimicStitchMatchPorts.setBoolean(on);
    }

    public static boolean isMimicStitchMatchPortWidth() {
        return cacheMimicStitchMatchPortWidth.getBoolean();
    }

    public static void setMimicStitchMatchPortWidth(boolean on) {
        cacheMimicStitchMatchPortWidth.setBoolean(on);
    }

    public static boolean isMimicStitchMatchNumArcs() {
        return cacheMimicStitchMatchNumArcs.getBoolean();
    }

    public static void setMimicStitchMatchNumArcs(boolean on) {
        cacheMimicStitchMatchNumArcs.setBoolean(on);
    }

    public static boolean isMimicStitchMatchNodeSize() {
        return cacheMimicStitchMatchNodeSize.getBoolean();
    }

    public static void setMimicStitchMatchNodeSize(boolean on) {
        cacheMimicStitchMatchNodeSize.setBoolean(on);
    }

    public static boolean isMimicStitchMatchNodeType() {
        return cacheMimicStitchMatchNodeType.getBoolean();
    }

    public static void setMimicStitchMatchNodeType(boolean on) {
        cacheMimicStitchMatchNodeType.setBoolean(on);
    }

    public static boolean isMimicStitchNoOtherArcsSameDir() {
        return cacheMimicStitchNoOtherArcsSameDir.getBoolean();
    }

    public static void setMimicStitchNoOtherArcsSameDir(boolean on) {
        cacheMimicStitchNoOtherArcsSameDir.setBoolean(on);
    }

    public static int getSunRouterVerboseLevel() {
        return cacheSLRVerboseLevel.getInt();
    }

    public static void setSunRouterVerboseLevel(int v) {
        cacheSLRVerboseLevel.setInt(v);
    }

    public static double getSunRouterCostLimit() {
        return cacheSLRCostLimit.getDouble();
    }

    public static void setSunRouterCostLimit(double r) {
        cacheSLRCostLimit.setDouble(r);
    }

    public static double getSunRouterCutlineDeviation() {
        return cacheSLRCutlineDeviation.getDouble();
    }

    public static void setSunRouterCutlineDeviation(double r) {
        cacheSLRCutlineDeviation.setDouble(r);
    }

    public static double getSunRouterDelta() {
        return cacheSLRDelta.getDouble();
    }

    public static void setSunRouterDelta(double r) {
        cacheSLRDelta.setDouble(r);
    }

    public static int getSunRouterXBitSize() {
        return cacheSLRXBitSize.getInt();
    }

    public static void setSunRouterXBitSize(int r) {
        cacheSLRXBitSize.setInt(r);
    }

    public static int getSunRouterYBitSize() {
        return cacheSLRYBitSize.getInt();
    }

    public static void setSunRouterYBitSize(int r) {
        cacheSLRYBitSize.setInt(r);
    }

    public static int getSunRouterXTileSize() {
        return cacheSLRXTileSize.getInt();
    }

    public static void setSunRouterXTileSize(int r) {
        cacheSLRXTileSize.setInt(r);
    }

    public static int getSunRouterYTileSize() {
        return cacheSLRYTileSize.getInt();
    }

    public static void setSunRouterYTileSize(int r) {
        cacheSLRYTileSize.setInt(r);
    }

    public static double getSunRouterLayerAssgnCapF() {
        return cacheSLRLayerAssgnCapF.getDouble();
    }

    public static void setSunRouterLayerAssgnCapF(double r) {
        cacheSLRLayerAssgnCapF.setDouble(r);
    }

    public static double getSunRouterLengthLongNet() {
        return cacheSLRLengthLongNet.getDouble();
    }

    public static void setSunRouterLengthLongNet(double r) {
        cacheSLRLengthLongNet.setDouble(r);
    }

    public static double getSunRouterLengthMedNet() {
        return cacheSLRLengthMedNet.getDouble();
    }

    public static void setSunRouterLengthMedNet(double r) {
        cacheSLRLengthMedNet.setDouble(r);
    }

    public static double getSunRouterTilesPerPinLongNet() {
        return cacheSLRTilesPerPinLongNet.getDouble();
    }

    public static void setSunRouterTilesPerPinLongNet(double r) {
        cacheSLRTilesPerPinLongNet.setDouble(r);
    }

    public static double getSunRouterTilesPerPinMedNet() {
        return cacheSLRTilesPerPinMedNet.getDouble();
    }

    public static void setSunRouterTilesPerPinMedNet(double r) {
        cacheSLRTilesPerPinMedNet.setDouble(r);
    }

    public static double getSunRouterOneTileFactor() {
        return cacheSLROneTileFactor.getDouble();
    }

    public static void setSunRouterOneTileFactor(double r) {
        cacheSLROneTileFactor.setDouble(r);
    }

    public static int getSunRouterOverloadLimit() {
        return cacheSLROverloadLimit.getInt();
    }

    public static void setSunRouterOverloadLimit(int r) {
        cacheSLROverloadLimit.setInt(r);
    }

    public static int getSunRouterPinFactor() {
        return cacheSLRPinFactor.getInt();
    }

    public static void setSunRouterPinFactor(int r) {
        cacheSLRPinFactor.setInt(r);
    }

    public static double getSunRouterUPinDensityF() {
        return cacheSLRUPinDensityF.getDouble();
    }

    public static void setSunRouterUPinDensityF(double r) {
        cacheSLRUPinDensityF.setDouble(r);
    }

    public static int getSunRouterWindow() {
        return cacheSLRWindow.getInt();
    }

    public static void setSunRouterWindow(int r) {
        cacheSLRWindow.setInt(r);
    }

    public static int getSunRouterWireOffset() {
        return cacheWireOffset.getInt();
    }

    public static void setSunRouterWireOffset(int r) {
        cacheWireOffset.setInt(r);
    }

    public static int getSunRouterWireModulo() {
        return cacheWireModulo.getInt();
    }

    public static void setSunRouterWireModulo(int r) {
        cacheWireModulo.setInt(r);
    }

    public static double getSunRouterWireBlockageFactor() {
        return cacheWireBlockageFactor.getDouble();
    }

    public static void setSunRouterWireBlockageFactor(double r) {
        cacheWireBlockageFactor.setDouble(r);
    }

    public static int getSunRouterRipUpMaximum() {
        return cacheRipUpMaximum.getInt();
    }

    public static void setSunRouterRipUpMaximum(int r) {
        cacheRipUpMaximum.setInt(r);
    }

    public static int getSunRouterRipUpPenalty() {
        return cacheRipUpPenalty.getInt();
    }

    public static void setSunRouterRipUpPenalty(int r) {
        cacheRipUpPenalty.setInt(r);
    }

    public static int getSunRouterRipUpExpansion() {
        return cacheRipUpExpansion.getInt();
    }

    public static void setSunRouterRipUpExpansion(int r) {
        cacheRipUpExpansion.setInt(r);
    }

    public static int getSunRouterZRipUpExpansion() {
        return cacheZRipUpExpansion.getInt();
    }

    public static void setSunRouterZRipUpExpansion(int r) {
        cacheZRipUpExpansion.setInt(r);
    }

    public static int getSunRouterRipUpSearches() {
        return cacheRipUpSearches.getInt();
    }

    public static void setSunRouterRipUpSearches(int r) {
        cacheRipUpSearches.setInt(r);
    }

    public static int getSunRouterGlobalPathExpansion() {
        return cacheGlobalPathExpansion.getInt();
    }

    public static void setSunRouterGlobalPathExpansion(int r) {
        cacheGlobalPathExpansion.setInt(r);
    }

    public static int getSunRouterSourceAccessExpansion() {
        return cacheSourceAccessExpansion.getInt();
    }

    public static void setSunRouterSourceAccessExpansion(int r) {
        cacheSourceAccessExpansion.setInt(r);
    }

    public static int getSunRouterSinkAccessExpansion() {
        return cacheSinkAccessExpansion.getInt();
    }

    public static void setSunRouterSinkAccessExpansion(int r) {
        cacheSinkAccessExpansion.setInt(r);
    }

    public static int getSunRouterDenseViaAreaSize() {
        return cacheDenseViaAreaSize.getInt();
    }

    public static void setSunRouterDenseViaAreaSize(int r) {
        cacheDenseViaAreaSize.setInt(r);
    }

    public static int getSunRouterRetryExpandRouting() {
        return cacheRetryExpandRouting.getInt();
    }

    public static void setSunRouterRetryExpandRouting(int r) {
        cacheRetryExpandRouting.setInt(r);
    }

    public static int getSunRouterRetryDenseViaAreaSize() {
        return cacheRetryDenseViaAreaSize.getInt();
    }

    public static void setSunRouterRetryDenseViaAreaSize(int r) {
        cacheRetryDenseViaAreaSize.setInt(r);
    }

    public static int getSunRouterPathSearchControl() {
        return cachePathSearchControl.getInt();
    }

    public static void setSunRouterPathSearchControl(int r) {
        cachePathSearchControl.setInt(r);
    }

    public static int getSunRouterSparseViaModulo() {
        return cacheSparseViaModulo.getInt();
    }

    public static void setSunRouterSparseViaModulo(int r) {
        cacheSparseViaModulo.setInt(r);
    }

    public static int getSunRouterLowPathSearchCost() {
        return cacheLowPathSearchCost.getInt();
    }

    public static void setSunRouterLowPathSearchCost(int r) {
        cacheLowPathSearchCost.setInt(r);
    }

    public static int getSunRouterMediumPathSearchCost() {
        return cacheMediumPathSearchCost.getInt();
    }

    public static void setSunRouterMediumPathSearchCost(int r) {
        cacheMediumPathSearchCost.setInt(r);
    }

    public static int getSunRouterHighPathSearchCost() {
        return cacheHighPathSearchCost.getInt();
    }

    public static void setSunRouterHighPathSearchCost(int r) {
        cacheHighPathSearchCost.setInt(r);
    }

    public static int getSunRouterTakenPathSearchCost() {
        return cacheTakenPathSearchCost.getInt();
    }

    public static void setSunRouterTakenPathSearchCost(int r) {
        cacheTakenPathSearchCost.setInt(r);
    }

    static {
        cachePreferredRoutingArc = Pref.makeStringPref("PreferredRoutingArc", Routing.tool.prefs, "");
        cacheAutoStitchOn = Pref.makeBooleanPref("AutoStitchOn", Routing.tool.prefs, false);
        cacheMimicStitchOn = Pref.makeBooleanPref("MimicStitchOn", Routing.tool.prefs, false);
        cacheMimicStitchInteractive = Pref.makeBooleanPref("MimicStitchInteractive", Routing.tool.prefs, false);
        cacheMimicStitchPinsKept = Pref.makeBooleanPref("MimicStitchPinsKept", Routing.tool.prefs, false);
        cacheMimicStitchMatchPorts = Pref.makeBooleanPref("MimicStitchMatchPorts", Routing.tool.prefs, false);
        cacheMimicStitchMatchPortWidth = Pref.makeBooleanPref("MimicStitchMatchPortWidth", Routing.tool.prefs, true);
        cacheMimicStitchMatchNumArcs = Pref.makeBooleanPref("MimicStitchMatchNumArcs", Routing.tool.prefs, false);
        cacheMimicStitchMatchNodeSize = Pref.makeBooleanPref("MimicStitchMatchNodeSize", Routing.tool.prefs, false);
        cacheMimicStitchMatchNodeType = Pref.makeBooleanPref("MimicStitchMatchNodeType", Routing.tool.prefs, true);
        cacheMimicStitchNoOtherArcsSameDir = Pref.makeBooleanPref("MimicStitchNoOtherArcsSameDir", Routing.tool.prefs, true);
        cacheSLRVerboseLevel = Pref.makeIntPref("SunRouterVerboseLevel", Routing.getRoutingTool().prefs, 2);
        cacheSLRCostLimit = Pref.makeDoublePref("SunRouterCostLimit", Routing.getRoutingTool().prefs, 10.0);
        cacheSLRCutlineDeviation = Pref.makeDoublePref("SunRouterCutlineDeviation", Routing.getRoutingTool().prefs, 0.1);
        cacheSLRDelta = Pref.makeDoublePref("SunRouterDelta", Routing.getRoutingTool().prefs, 1.0);
        cacheSLRXBitSize = Pref.makeIntPref("SunRouterXBitSize", Routing.getRoutingTool().prefs, 20);
        cacheSLRYBitSize = Pref.makeIntPref("SunRouterYBitSize", Routing.getRoutingTool().prefs, 20);
        cacheSLRXTileSize = Pref.makeIntPref("SunRouterXTileSize", Routing.getRoutingTool().prefs, 40);
        cacheSLRYTileSize = Pref.makeIntPref("SunRouterYTileSize", Routing.getRoutingTool().prefs, 40);
        cacheSLRLayerAssgnCapF = Pref.makeDoublePref("SunRouterLayerAssgnCapF", Routing.getRoutingTool().prefs, 0.9);
        cacheSLRLengthLongNet = Pref.makeDoublePref("SunRouterLengthLongNet", Routing.getRoutingTool().prefs, 0.0);
        cacheSLRLengthMedNet = Pref.makeDoublePref("SunRouterLengthMedNet", Routing.getRoutingTool().prefs, 0.0);
        cacheSLRTilesPerPinLongNet = Pref.makeDoublePref("SunRouterTilesPerPinLongNet", Routing.getRoutingTool().prefs, 5.0);
        cacheSLRTilesPerPinMedNet = Pref.makeDoublePref("SunRouterTilesPerPinMedNet", Routing.getRoutingTool().prefs, 3.0);
        cacheSLROneTileFactor = Pref.makeDoublePref("SunRouterOneTileFactor", Routing.getRoutingTool().prefs, 2.65);
        cacheSLROverloadLimit = Pref.makeIntPref("SunRouterOverloadLimit", Routing.getRoutingTool().prefs, 10);
        cacheSLRPinFactor = Pref.makeIntPref("SunRouterPinFactor", Routing.getRoutingTool().prefs, 10);
        cacheSLRUPinDensityF = Pref.makeDoublePref("SunRouterUPinDensityF", Routing.getRoutingTool().prefs, 100.0);
        cacheSLRWindow = Pref.makeIntPref("SunRouterWindow", Routing.getRoutingTool().prefs, 30);
        cacheWireOffset = Pref.makeIntPref("SunRouterWireOffset", Routing.getRoutingTool().prefs, 0);
        cacheWireModulo = Pref.makeIntPref("SunRouterWireModulo", Routing.getRoutingTool().prefs, -1);
        cacheWireBlockageFactor = Pref.makeDoublePref("SunRouterWireBlockageFactor", Routing.getRoutingTool().prefs, 0.0);
        cacheRipUpMaximum = Pref.makeIntPref("SunRouterRipUpMaximum", Routing.getRoutingTool().prefs, 3);
        cacheRipUpPenalty = Pref.makeIntPref("SunRouterRipUpPenalty", Routing.getRoutingTool().prefs, 10);
        cacheRipUpExpansion = Pref.makeIntPref("SunRouterRipUpExpansion", Routing.getRoutingTool().prefs, 10);
        cacheZRipUpExpansion = Pref.makeIntPref("SunRouterZRipUpExpansion", Routing.getRoutingTool().prefs, 2);
        cacheRipUpSearches = Pref.makeIntPref("SunRouterRipUpSearches", Routing.getRoutingTool().prefs, 1);
        cacheGlobalPathExpansion = Pref.makeIntPref("SunRouterGlobalPathExpansion", Routing.getRoutingTool().prefs, 5);
        cacheSourceAccessExpansion = Pref.makeIntPref("SunRouterSourceAccessExpansion", Routing.getRoutingTool().prefs, 10);
        cacheSinkAccessExpansion = Pref.makeIntPref("SunRouterSinkAccessExpansion", Routing.getRoutingTool().prefs, 10);
        cacheDenseViaAreaSize = Pref.makeIntPref("SunRouterDenseViaAreaSize", Routing.getRoutingTool().prefs, 60);
        cacheRetryExpandRouting = Pref.makeIntPref("SunRouterRetryExpandRouting", Routing.getRoutingTool().prefs, 50);
        cacheRetryDenseViaAreaSize = Pref.makeIntPref("SunRouterRetryDenseViaAreaSize", Routing.getRoutingTool().prefs, 100);
        cachePathSearchControl = Pref.makeIntPref("SunRouterPathSearchControl", Routing.getRoutingTool().prefs, 10000);
        cacheSparseViaModulo = Pref.makeIntPref("SunRouterSparseViaModulo", Routing.getRoutingTool().prefs, 31);
        cacheLowPathSearchCost = Pref.makeIntPref("SunRouterLowPathSearchCost", Routing.getRoutingTool().prefs, 5);
        cacheMediumPathSearchCost = Pref.makeIntPref("SunRouterMediumPathSearchCost", Routing.getRoutingTool().prefs, 20);
        cacheHighPathSearchCost = Pref.makeIntPref("SunRouterHighPathSearchCost", Routing.getRoutingTool().prefs, 100);
        cacheTakenPathSearchCost = Pref.makeIntPref("SunRouterTakenPathSearchCost", Routing.getRoutingTool().prefs, 10000);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstacesSpatially
    implements Comparator<NodeInst> {
        private InstacesSpatially() {
        }

        @Override
        public int compare(NodeInst n1, NodeInst n2) {
            double x1 = n1.getAnchorCenterX();
            double y1 = n1.getAnchorCenterY();
            double x2 = n2.getAnchorCenterX();
            double y2 = n2.getAnchorCenterY();
            if (y1 == y2) {
                if (x1 == x2) {
                    return 0;
                }
                if (x1 > x2) {
                    return 1;
                }
                return -1;
            }
            if (y1 == y2) {
                return 0;
            }
            if (y1 > y2) {
                return 1;
            }
            return -1;
        }
    }

    private static class CopyRoutingTopology
    extends Job {
        private Cell fromCell;
        private Cell toCell;

        protected CopyRoutingTopology(Cell fromCell, Cell toCell) {
            super("Copy Routing Topology", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fromCell = fromCell;
            this.toCell = toCell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            return Routing.copyTopology(this.fromCell, this.toCell);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnrouteJob
    extends Job {
        private Cell cell;
        private Set<Network> nets;
        private List<ArcInst> highlightThese;

        private UnrouteJob(Cell cell, Set<Network> nets) {
            super("Unroute", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.nets = nets;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Netlist netList = this.cell.acquireUserNetlist();
            if (netList == null) {
                throw new JobException("Sorry, a deadlock aborted unrouting (network information unavailable).  Please try again");
            }
            this.highlightThese = new ArrayList<ArcInst>();
            int total = this.nets.size();
            Network[] netsToUnroute = new Network[total];
            ArrayList<List<Connection>> netEnds = new ArrayList<List<Connection>>();
            ArrayList<HashSet<ArcInst>> arcsToDelete = new ArrayList<HashSet<ArcInst>>();
            ArrayList<HashSet<NodeInst>> nodesToDelete = new ArrayList<HashSet<NodeInst>>();
            int i = 0;
            Iterator<Network> i$ = this.nets.iterator();
            while (i$.hasNext()) {
                Network net;
                netsToUnroute[i] = net = i$.next();
                HashSet<ArcInst> arcs = new HashSet<ArcInst>();
                HashSet<NodeInst> nodes = new HashSet<NodeInst>();
                arcsToDelete.add(arcs);
                nodesToDelete.add(nodes);
                netEnds.add(Routing.findNetEnds(net, arcs, nodes, netList));
                ++i;
            }
            for (int j = 0; j < total && !UnrouteJob.unrouteNet(netsToUnroute[j], (HashSet)arcsToDelete.get(j), (HashSet)nodesToDelete.get(j), (List)netEnds.get(j), netList, this.highlightThese); ++j) {
            }
            this.fieldVariableChanged("highlightThese");
            return true;
        }

        @Override
        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            wnd.clearHighlighting();
            for (ArcInst ai : this.highlightThese) {
                wnd.addElectricObject(ai, ai.getParent());
            }
            wnd.finishedHighlighting();
        }

        private static boolean unrouteNet(Network net, HashSet<ArcInst> arcsToDelete, HashSet<NodeInst> nodesToDelete, List<Connection> netEnds, Netlist netList, List<ArcInst> highlightThese) {
            for (ArcInst ai : arcsToDelete) {
                ai.kill();
            }
            for (NodeInst ni : nodesToDelete) {
                ni.kill();
            }
            double wid = Generic.tech.unrouted_arc.getDefaultWidth();
            int count = netEnds.size();
            int[] covered = new int[count];
            Point2D[] points = new Point2D[count];
            for (int i = 0; i < count; ++i) {
                Connection con = netEnds.get(i);
                PortInst pi = con.getPortInst();
                Poly poly = pi.getPoly();
                points[i] = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                covered[i] = 0;
            }
            int first = 0;
            while (true) {
                PortInst tail;
                boolean found = true;
                double bestdist = 0.0;
                int besti = 0;
                int bestj = 0;
                for (int i = 0; i < count; ++i) {
                    for (int j = i + 1; j < count; ++j) {
                        if (first != 0 && covered[i] + covered[j] != 1) continue;
                        double dist = points[i].distance(points[j]);
                        if (!found && dist >= bestdist) continue;
                        found = false;
                        bestdist = dist;
                        besti = i;
                        bestj = j;
                    }
                }
                if (found) break;
                covered[bestj] = 1;
                covered[besti] = 1;
                PortInst head = netEnds.get(besti).getPortInst();
                ArcInst ai = ArcInst.makeInstance(Generic.tech.unrouted_arc, wid, head, tail = netEnds.get(bestj).getPortInst());
                if (ai == null) {
                    System.out.println("Could not create unrouted arc");
                    return true;
                }
                highlightThese.add(ai);
                ++first;
            }
            return false;
        }
    }

    public static class Activity {
        int numCreatedArcs = 0;
        int numCreatedNodes = 0;
        ArcInst[] createdArcs = new ArcInst[3];
        NodeInst[] createdNodes = new NodeInst[3];
        int numDeletedArcs = 0;
        int numDeletedNodes = 0;
        ImmutableArcInst deletedArc;
        CellId deletedArcParent;
        PortProtoId[] deletedPorts = new PortProtoId[2];

        Activity() {
        }
    }
}

