/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.generator.layout.DrcRings;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.GenerateLayoutForGatesInSchematic;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.user.User;

public class GateLayoutGenerator
extends Job {
    private Tech.Type technology;
    private Cell cell;
    private VarContext context;
    private static final DrcRings.Filter FILTER = new DrcRings.Filter(){

        public boolean skip(NodeInst ni) {
            return ni.getProto().getName().indexOf("mosWellTie_") != -1;
        }
    };

    private Library generateLayout(Library outLib, Cell cell, VarContext context, Tech.Type technology) {
        Tech.setTechnology(technology);
        Technology tsmc90 = Technology.getTSMC90Technology();
        StdCellParams stdCell = tsmc90 != null && technology == Tech.Type.TSMC90 ? GateLayoutGenerator.sportParams(outLib) : GateLayoutGenerator.dividerParams(outLib, technology);
        GenerateLayoutForGatesInSchematic visitor = new GenerateLayoutForGatesInSchematic(stdCell);
        HierarchyEnumerator.enumerateCell(cell, context, visitor);
        Cell gallery = Gallery.makeGallery(outLib);
        DrcRings.addDrcRings(gallery, FILTER, stdCell);
        return outLib;
    }

    public static StdCellParams locoParams(Library outLib) {
        StdCellParams stdCell = new StdCellParams(outLib, Tech.Type.MOCMOS);
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(42.0);
        stdCell.setPmosWellHeight(42.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    private static StdCellParams sportParams(Library outLib) {
        StdCellParams stdCell = new StdCellParams(outLib, Tech.Type.TSMC90);
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(24.5);
        stdCell.setGndY(-24.5);
        stdCell.setNmosWellHeight(84.0);
        stdCell.setPmosWellHeight(84.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static StdCellParams dividerParams(Library outLib, Tech.Type technology) {
        StdCellParams stdCell = new StdCellParams(outLib, technology);
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(84.0);
        stdCell.setPmosWellHeight(84.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static StdCellParams justinParams(Library outLib, Tech.Type technology) {
        StdCellParams stdCell = new StdCellParams(outLib, technology);
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(42.0);
        stdCell.setPmosWellHeight(42.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public boolean doIt() throws JobException {
        String outLibNm = "autoGenLib" + (Object)((Object)this.technology);
        Library outLib = LayoutLib.openLibForWrite(outLibNm);
        if (this.cell == null) {
            System.out.println("Please open the schematic for which you want to generate gate layouts.");
            return false;
        }
        if (!this.cell.isSchematic()) {
            System.out.println("The current cell isn't a schematic. This command only works on schematics.");
            return false;
        }
        System.out.println("Generating layouts for gates in the schematic: " + this.cell.getName() + " and its descendents");
        System.out.println("Output goes to library: " + outLibNm);
        this.generateLayout(outLib, this.cell, this.context, this.technology);
        System.out.println("done.");
        return true;
    }

    public GateLayoutGenerator(Tech.Type techNm) {
        super("Generate gate layouts", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
        this.technology = techNm;
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.needCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        this.cell = wnd.getCell();
        this.context = wnd.getVarContext();
        this.startJob();
    }
}

