/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ArcProto
implements Comparable {
    private static HashMap defaultWidthPrefs = new HashMap();
    private static HashMap defaultAnglePrefs = new HashMap();
    private static HashMap defaultRigidPrefs = new HashMap();
    private static HashMap defaultFixedAnglePrefs = new HashMap();
    private static HashMap defaultSlidablePrefs = new HashMap();
    private static HashMap defaultExtendedPrefs = new HashMap();
    private static HashMap defaultDirectionalPrefs = new HashMap();
    protected String protoName;
    protected Technology tech;
    protected double widthOffset;
    private int userBits;
    private Function function;
    Technology.ArcLayer[] layers;
    String fullName;
    int primArcIndex;
    private static final int CANWIPE = 64;
    private static final int CANCURVE = 128;
    private static final int ARCSPECIAL = 0x200000;
    private static final int AEDGESELECT = 0x400000;
    private static final int AINVISIBLE = 0x800000;
    private static final int ANOTUSED = Integer.MIN_VALUE;
    HashMap arcPinPrefs = new HashMap();

    private ArcProto(Technology tech, String protoName, double defaultWidth, Technology.ArcLayer[] layers) {
        if (!Technology.jelibSafeName(protoName)) {
            System.out.println("ArcProto name " + protoName + " is not safe to write into JELIB");
        }
        this.protoName = protoName;
        this.fullName = tech.getTechName() + ":" + protoName;
        this.widthOffset = 0.0;
        this.tech = tech;
        this.userBits = 0;
        this.function = Function.UNKNOWN;
        this.layers = layers;
        this.setFactoryDefaultWidth(defaultWidth);
    }

    public static ArcProto newInstance(Technology tech, String protoName, double defaultWidth, Technology.ArcLayer[] layers) {
        if (tech.findArcProto(protoName) != null) {
            System.out.println("Error: technology " + tech.getTechName() + " has multiple arcs named " + protoName);
            return null;
        }
        if (defaultWidth < 0.0) {
            System.out.println("ArcProto " + tech.getTechName() + ":" + protoName + " has negative width");
            return null;
        }
        ArcProto ap = new ArcProto(tech, protoName, defaultWidth, layers);
        tech.addArcProto(ap);
        return ap;
    }

    public String getName() {
        return this.protoName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Technology getTechnology() {
        return this.tech;
    }

    private Pref getArcProtoWidthPref(double factory) {
        Pref pref = (Pref)defaultWidthPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref("DefaultWidthFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            defaultWidthPrefs.put(this, pref);
        }
        return pref;
    }

    protected void setFactoryDefaultWidth(double defaultWidth) {
        this.getArcProtoWidthPref(defaultWidth);
    }

    public boolean setDefaultWidth(double defaultWidth) {
        return this.getArcProtoWidthPref(0.0).setDouble(defaultWidth);
    }

    public double getDefaultWidth() {
        return this.getArcProtoWidthPref(0.0).getDouble();
    }

    public void setWidthOffset(double widthOffset) {
        if (widthOffset < 0.0) {
            System.out.println("ArcProto " + this.tech.getTechName() + ":" + this.protoName + " has negative width offset");
            return;
        }
        this.widthOffset = widthOffset;
    }

    public double getWidthOffset() {
        return this.widthOffset;
    }

    public double getWidth() {
        return this.getDefaultWidth() - this.widthOffset;
    }

    private Pref getArcProtoBitPref(String what, HashMap map, boolean factory) {
        Pref pref = (Pref)map.get(this);
        if (pref == null) {
            pref = Pref.makeBooleanPref("Default" + what + "For" + this.protoName + "IN" + this.tech.getTechName(), User.getUserTool().prefs, factory);
            map.put(this, pref);
        }
        return pref;
    }

    public void setFactoryRigid(boolean rigid) {
        this.getArcProtoBitPref("Rigid", defaultRigidPrefs, rigid);
    }

    public void setRigid(boolean rigid) {
        this.getArcProtoBitPref("Rigid", defaultRigidPrefs, false).setBoolean(rigid);
    }

    public boolean isRigid() {
        return this.getArcProtoBitPref("Rigid", defaultRigidPrefs, false).getBoolean();
    }

    public void setFactoryFixedAngle(boolean fixed) {
        this.getArcProtoBitPref("FixedAngle", defaultFixedAnglePrefs, fixed);
    }

    public void setFixedAngle(boolean fixed) {
        this.getArcProtoBitPref("FixedAngle", defaultFixedAnglePrefs, true).setBoolean(fixed);
    }

    public boolean isFixedAngle() {
        return this.getArcProtoBitPref("FixedAngle", defaultFixedAnglePrefs, true).getBoolean();
    }

    public void setFactorySlidable(boolean slidable) {
        this.getArcProtoBitPref("Slidable", defaultSlidablePrefs, slidable);
    }

    public void setSlidable(boolean slidable) {
        this.getArcProtoBitPref("Slidable", defaultSlidablePrefs, true).setBoolean(slidable);
    }

    public boolean isSlidable() {
        return this.getArcProtoBitPref("Slidable", defaultSlidablePrefs, true).getBoolean();
    }

    public void setFactoryExtended(boolean extended) {
        this.getArcProtoBitPref("Extended", defaultExtendedPrefs, extended);
    }

    public void setExtended(boolean extended) {
        this.getArcProtoBitPref("Extended", defaultExtendedPrefs, true).setBoolean(extended);
    }

    public boolean isExtended() {
        return this.getArcProtoBitPref("Extended", defaultExtendedPrefs, true).getBoolean();
    }

    public void setDirectional(boolean directional) {
        this.getArcProtoBitPref("Directional", defaultDirectionalPrefs, false).setBoolean(directional);
    }

    public boolean isDirectional() {
        return this.getArcProtoBitPref("Directional", defaultDirectionalPrefs, false).getBoolean();
    }

    public void setNotUsed() {
        this.userBits |= Integer.MIN_VALUE;
    }

    public void clearNotUsed() {
        this.userBits &= Integer.MAX_VALUE;
    }

    public boolean isNotUsed() {
        return (this.userBits & Integer.MIN_VALUE) != 0;
    }

    public void setArcInvisible(boolean invisible) {
        this.userBits = invisible ? (this.userBits |= 0x800000) : (this.userBits &= 0xFF7FFFFF);
    }

    public boolean isArcInvisible() {
        return (this.userBits & 0x800000) != 0;
    }

    public void setWipable() {
        this.userBits |= 0x40;
    }

    public void clearWipable() {
        this.userBits &= 0xFFFFFFBF;
    }

    public boolean isWipable() {
        return (this.userBits & 0x40) != 0;
    }

    public void setCurvable() {
        this.userBits |= 0x80;
    }

    public void clearCurvable() {
        this.userBits &= 0xFFFFFF7F;
    }

    public boolean isCurvable() {
        return (this.userBits & 0x80) != 0;
    }

    public void setEdgeSelect() {
        this.userBits |= 0x400000;
    }

    public void clearEdgeSelect() {
        this.userBits &= 0xFFBFFFFF;
    }

    public boolean isEdgeSelect() {
        return (this.userBits & 0x400000) != 0;
    }

    public void setSpecialArc() {
        this.userBits |= 0x200000;
    }

    public boolean isSpecialArc() {
        return (this.userBits & 0x200000) != 0;
    }

    public int getDefaultConstraints() {
        int flags = 0;
        flags = ImmutableArcInst.RIGID.set(flags, this.isRigid());
        flags = ImmutableArcInst.FIXED_ANGLE.set(flags, this.isFixedAngle());
        flags = ImmutableArcInst.SLIDABLE.set(flags, this.isSlidable());
        flags = ImmutableArcInst.HEAD_EXTENDED.set(flags, this.isExtended());
        flags = ImmutableArcInst.TAIL_EXTENDED.set(flags, this.isExtended());
        flags = ImmutableArcInst.HEAD_ARROWED.set(flags, this.isDirectional());
        flags = ImmutableArcInst.BODY_ARROWED.set(flags, this.isDirectional());
        return flags;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFactoryAngleIncrement(int angle) {
        Pref pref = Pref.makeIntPref("DefaultAngleFor" + this.protoName + "IN" + this.tech.getTechName(), User.getUserTool().prefs, angle);
        defaultAnglePrefs.put(this, pref);
    }

    public void setAngleIncrement(int angle) {
        Pref pref = (Pref)defaultAnglePrefs.get(this);
        if (pref == null) {
            return;
        }
        pref.setInt(angle);
    }

    public int getAngleIncrement() {
        Pref pref = (Pref)defaultAnglePrefs.get(this);
        if (pref == null) {
            return 90;
        }
        return pref.getInt();
    }

    private Pref getArcPinPref() {
        Pref pref = (Pref)this.arcPinPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeStringPref("PinFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), "");
            this.arcPinPrefs.put(this, pref);
        }
        return pref;
    }

    public void setPinProto(PrimitiveNode np) {
        Pref pref = this.getArcPinPref();
        pref.setString(np.getName());
    }

    public PrimitiveNode findOverridablePinProto() {
        PrimitiveNode np;
        Pref pref = this.getArcPinPref();
        String primName = pref.getString();
        if (primName != null && primName.length() > 0 && (np = this.tech.findNodeProto(primName)) != null) {
            return np;
        }
        return this.findPinProto();
    }

    public PrimitiveNode findPinProto() {
        Iterator it = this.tech.getNodes();
        while (it.hasNext()) {
            PrimitivePort pp;
            PrimitiveNode pn = (PrimitiveNode)it.next();
            if (!pn.isPin() || !(pp = (PrimitivePort)pn.getPorts().next()).connectsTo(this)) continue;
            return pn;
        }
        return null;
    }

    public static ArcProto findArcProto(String line) {
        String withoutPrefix;
        Technology tech = Technology.getCurrent();
        int colon = line.indexOf(58);
        if (colon == -1) {
            withoutPrefix = line;
        } else {
            String prefix = line.substring(0, colon);
            Technology t = Technology.findTechnology(prefix);
            if (t != null) {
                tech = t;
            }
            withoutPrefix = line.substring(colon + 1);
        }
        ArcProto ap = tech.findArcProto(withoutPrefix);
        if (ap != null) {
            return ap;
        }
        return null;
    }

    public Technology.ArcLayer[] getLayers() {
        return this.layers;
    }

    public Iterator layerIterator() {
        return new LayerIterator(this.layers);
    }

    public Technology.ArcLayer findArcLayer(Layer layer) {
        for (int j = 0; j < this.layers.length; ++j) {
            Technology.ArcLayer oneLayer = this.layers[j];
            if (oneLayer.getLayer() != layer) continue;
            return oneLayer;
        }
        return null;
    }

    public void getZValues(double[] array) {
        for (int j = 0; j < this.layers.length; ++j) {
            Layer layer = this.layers[j].getLayer();
            double distance = layer.getDistance();
            double thickness = layer.getThickness();
            double z = distance + thickness;
            array[0] = array[0] > distance ? distance : array[0];
            array[1] = array[1] < z ? z : array[1];
        }
    }

    public String describe() {
        String description = "";
        Technology tech = this.getTechnology();
        if (Technology.getCurrent() != tech) {
            description = description + tech.getTechName() + ":";
        }
        description = description + this.protoName;
        return description;
    }

    public int compareTo(Object obj) {
        int cmp;
        ArcProto that = (ArcProto)obj;
        if (this.tech != that.tech && (cmp = this.tech.compareTo(that.tech)) != 0) {
            return cmp;
        }
        return this.primArcIndex - that.primArcIndex;
    }

    public String toString() {
        return "arc " + this.describe();
    }

    private static class LayerIterator
    implements Iterator {
        Technology.ArcLayer[] array;
        int pos;

        public LayerIterator(Technology.ArcLayer[] a) {
            this.array = a;
            this.pos = 0;
        }

        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        public Object next() throws NoSuchElementException {
            if (this.pos >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.pos++].getLayer();
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }

    public static class Function {
        private final String name;
        private final String constantName;
        private int level;
        private static HashMap metalLayers = new HashMap();
        private static HashMap polyLayers = new HashMap();
        private static List allFunctions = new ArrayList();
        public static final Function UNKNOWN = new Function("unknown", "UNKNOWN", 0, 0);
        public static final Function METAL1 = new Function("metal-1", "METAL1", 1, 0);
        public static final Function METAL2 = new Function("metal-2", "METAL2", 2, 0);
        public static final Function METAL3 = new Function("metal-3", "METAL3", 3, 0);
        public static final Function METAL4 = new Function("metal-4", "METAL4", 4, 0);
        public static final Function METAL5 = new Function("metal-5", "METAL5", 5, 0);
        public static final Function METAL6 = new Function("metal-6", "METAL6", 6, 0);
        public static final Function METAL7 = new Function("metal-7", "METAL7", 7, 0);
        public static final Function METAL8 = new Function("metal-8", "METAL8", 8, 0);
        public static final Function METAL9 = new Function("metal-9", "METAL9", 9, 0);
        public static final Function METAL10 = new Function("metal-10", "METAL10", 10, 0);
        public static final Function METAL11 = new Function("metal-11", "METAL11", 11, 0);
        public static final Function METAL12 = new Function("metal-12", "METAL12", 12, 0);
        public static final Function POLY1 = new Function("polysilicon-1", "POLY1", 0, 1);
        public static final Function POLY2 = new Function("polysilicon-2", "POLY2", 0, 2);
        public static final Function POLY3 = new Function("polysilicon-3", "POLY3", 0, 3);
        public static final Function DIFF = new Function("diffusion", "DIFF", 0, 0);
        public static final Function DIFFP = new Function("p-diffusion", "DIFFP", 0, 0);
        public static final Function DIFFN = new Function("n-diffusion", "DIFFN", 0, 0);
        public static final Function DIFFS = new Function("substrate-diffusion", "DIFFS", 0, 0);
        public static final Function DIFFW = new Function("well-diffusion", "DIFFW", 0, 0);
        public static final Function BUS = new Function("bus", "BUS", 0, 0);
        public static final Function UNROUTED = new Function("unrouted", "UNROUTED", 0, 0);
        public static final Function NONELEC = new Function("nonelectrical", "NONELEC", 0, 0);

        private Function(String name, String constantName, int metalLevel, int polyLevel) {
            this.name = name;
            this.constantName = constantName;
            this.level = 0;
            if (metalLevel != 0) {
                this.level = metalLevel;
                metalLayers.put(new Integer(this.level), this);
            }
            if (polyLevel != 0) {
                this.level = polyLevel;
                polyLayers.put(new Integer(this.level), this);
            }
            allFunctions.add(this);
        }

        public String toString() {
            return this.name;
        }

        public String getConstantName() {
            return this.constantName;
        }

        public static List getFunctions() {
            return allFunctions;
        }

        public int getLevel() {
            return this.level;
        }

        public static Function getMetal(int level) {
            Function func = (Function)metalLayers.get(new Integer(level));
            return func;
        }

        public static Function getPoly(int level) {
            Function func = (Function)polyLayers.get(new Integer(level));
            return func;
        }

        public boolean isMetal() {
            return this == METAL1 || this == METAL2 || this == METAL3 || this == METAL4 || this == METAL5 || this == METAL6 || this == METAL7 || this == METAL8 || this == METAL9 || this == METAL10 || this == METAL11 || this == METAL12;
        }

        public boolean isPoly() {
            return this == POLY1 || this == POLY2 || this == POLY3;
        }

        public boolean isDiffusion() {
            return this == DIFF || this == DIFFP || this == DIFFN || this == DIFFS || this == DIFFW;
        }
    }
}

