/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class MimicStitch {
    private static InteractiveRouter router = new SimpleWirer();
    private static final int LIKELYDIFFPORT = 1;
    private static final int LIKELYDIFFARCCOUNT = 2;
    private static final int LIKELYDIFFNODETYPE = 4;
    private static final int LIKELYDIFFNODESIZE = 8;
    private static final int LIKELYARCSSAMEDIR = 16;
    private static final int[] situations = new int[]{0, 16, 8, 2, 1, 4, 24, 18, 17, 20, 10, 9, 12, 3, 6, 5, 26, 25, 28, 19, 22, 21, 11, 14, 13, 7, 27, 30, 29, 23, 15, 31};

    public static void mimicStitch(boolean forced) {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Routing.Activity lastActivity = Routing.getRoutingTool().getLastActivity();
        if (lastActivity == null) {
            System.out.println("No wiring activity to mimic");
            return;
        }
        if (lastActivity.numDeletedArcs == 1 && Routing.isMimicStitchCanUnstitch()) {
            ArcProto ap = lastActivity.deletedArcs[0].getProto();
            MimicStitch.ro_mimicdelete(ap, lastActivity);
            lastActivity.numDeletedArcs = 0;
            return;
        }
        if (lastActivity.numCreatedArcs == 1) {
            ArcInst ai = lastActivity.createdArcs[0];
            MimicStitchJob job = new MimicStitchJob(ai.getHead(), ai.getTail(), ai.getWidth(), ai.getProto(), 0.0, 0.0, forced, highlighter);
            lastActivity.numCreatedArcs = 0;
            return;
        }
        if (lastActivity.numCreatedArcs > 1 && lastActivity.numCreatedNodes > 0) {
            ArcProto proto = lastActivity.createdArcs[0].getProto();
            Cell parent = lastActivity.createdArcs[0].getParent();
            HashSet<NodeInst> gotOne = new HashSet<NodeInst>();
            HashSet<NodeInst> gotMany = new HashSet<NodeInst>();
            for (int i = 0; i < lastActivity.numCreatedArcs; ++i) {
                ArcInst ai = lastActivity.createdArcs[i];
                for (int e = 0; e < 2; ++e) {
                    NodeInst ni = ai.getPortInst(e).getNodeInst();
                    if (gotMany.contains(ni)) continue;
                    if (!gotOne.contains(ni)) {
                        gotOne.add(ni);
                        continue;
                    }
                    gotOne.remove(ni);
                    gotMany.add(ni);
                }
            }
            int foundEnds = 0;
            Connection[] ends = new Connection[2];
            double width = 0.0;
            for (int i = 0; i < lastActivity.numCreatedArcs; ++i) {
                ArcInst ai = lastActivity.createdArcs[i];
                for (int e = 0; e < 2; ++e) {
                    NodeInst ni = ai.getPortInst(e).getNodeInst();
                    if (!gotOne.contains(ni)) continue;
                    if (foundEnds < 2) {
                        ends[foundEnds] = ai.getConnection(e);
                        if (ai.getWidth() > width) {
                            width = ai.getWidth();
                        }
                    }
                    ++foundEnds;
                }
            }
            if (foundEnds == 2) {
                Poly portPoly0;
                double prefX = 0.0;
                double prefY = 0.0;
                if (lastActivity.numCreatedNodes == 1) {
                    portPoly0 = ends[0].getPortInst().getPoly();
                    double x0 = portPoly0.getCenterX();
                    double y0 = portPoly0.getCenterY();
                    Poly portPoly1 = ends[1].getPortInst().getPoly();
                    double x1 = portPoly1.getCenterX();
                    double y1 = portPoly1.getCenterY();
                    prefX = lastActivity.createdNodes[0].getAnchorCenterX() - (x0 + x1) / 2.0;
                    prefY = lastActivity.createdNodes[0].getAnchorCenterY() - (y0 + y1) / 2.0;
                } else if (lastActivity.numCreatedNodes == 2) {
                    portPoly0 = ends[0].getPortInst().getPoly();
                    double x0 = portPoly0.getCenterX();
                    double y0 = portPoly0.getCenterY();
                    Poly portPoly1 = ends[1].getPortInst().getPoly();
                    double x1 = portPoly1.getCenterX();
                    double y1 = portPoly1.getCenterY();
                    prefX = (lastActivity.createdNodes[0].getAnchorCenterX() + lastActivity.createdNodes[1].getAnchorCenterX()) / 2.0 - (x0 + x1) / 2.0;
                    prefY = (lastActivity.createdNodes[0].getAnchorCenterY() + lastActivity.createdNodes[1].getAnchorCenterY()) / 2.0 - (y0 + y1) / 2.0;
                }
                MimicStitchJob job = new MimicStitchJob(ends[0], ends[1], width, null, prefX, prefY, forced, highlighter);
            }
            lastActivity.numCreatedArcs = 0;
            return;
        }
    }

    private static void ro_mimicdelete(ArcProto typ, Routing.Activity activity) {
        EPoint pt0 = activity.deletedArcs[0].getHeadLocation();
        EPoint pt1 = activity.deletedArcs[0].getTailLocation();
        double dist = pt0.distance(pt1);
        int angle = 0;
        if (dist != 0.0) {
            angle = DBMath.figureAngle(pt0, pt1);
        }
        Cell cell = activity.deletedNodes[0].getParent();
        ArrayList<ArcInst> arcKills = new ArrayList<ArcInst>();
        Iterator it = cell.getArcs();
        while (it.hasNext()) {
            int thisAngle;
            EPoint end1;
            EPoint end0;
            double thisDist;
            ArcInst ai = (ArcInst)it.next();
            if (ai.getProto() != typ) continue;
            int match = 0;
            if (ai.getHeadPortInst().getNodeInst().getProto() == activity.deletedNodes[0].getProto() && ai.getTailPortInst().getNodeInst().getProto() == activity.deletedNodes[1].getProto() && ai.getHeadPortInst().getPortProto() == activity.deletedPorts[0] && ai.getTailPortInst().getPortProto() == activity.deletedPorts[1]) {
                match = 1;
            }
            if (ai.getHeadPortInst().getNodeInst().getProto() == activity.deletedNodes[1].getProto() && ai.getTailPortInst().getNodeInst().getProto() == activity.deletedNodes[0].getProto() && ai.getHeadPortInst().getPortProto() == activity.deletedPorts[1] && ai.getTailPortInst().getPortProto() == activity.deletedPorts[0]) {
                match = -1;
            }
            if (match == 0 || dist != (thisDist = (end0 = ai.getHeadLocation()).distance(end1 = ai.getTailLocation())) || dist != 0.0 && angle % 1800 != (thisAngle = DBMath.figureAngle(end0, end1)) % 1800) continue;
            arcKills.add(ai);
        }
        MimicUnstitchJob job = new MimicUnstitchJob(arcKills);
    }

    public static void mimicOneArc(Connection conn1, Connection conn2, double oWidth, ArcProto oProto, double prefX, double prefY, boolean forced, Highlighter highlighter, Job.Type method, boolean mimicInteractive, boolean matchPorts, boolean matchArcCount, boolean matchNodeType, boolean matchNodeSize, boolean noOtherArcsThisDir) {
        if (forced) {
            System.out.println("Mimicing last arc...");
        }
        PortInst[] endPi = new PortInst[]{conn1.getPortInst(), conn2.getPortInst()};
        Point2D[] endPts = new Point2D[]{conn1.getLocation(), conn2.getLocation()};
        Cell cell = endPi[0].getNodeInst().getParent();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted mimic-routing (network information unavailable).  Please try again");
            return;
        }
        ArrayList<PossibleArc> possibleArcs = new ArrayList<PossibleArc>();
        int con1 = endPi[0].getNodeInst().getNumConnections() + endPi[1].getNodeInst().getNumConnections() - 2;
        HashMap<PortInst, Poly> cachedPortPoly = new HashMap<PortInst, Poly>();
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = (PortInst)pIt.next();
                if (oProto != null && !pi.getPortProto().connectsTo(oProto)) continue;
                cachedPortPoly.put(pi, pi.getPoly());
            }
        }
        if (cachedPortPoly.size() == 0) {
            return;
        }
        for (int end = 0; end < 2; ++end) {
            PortInst pi0 = endPi[end];
            PortInst pi1 = endPi[1 - end];
            NodeInst node0 = pi0.getNodeInst();
            NodeInst node1 = pi1.getNodeInst();
            PortProto port0 = pi0.getPortProto();
            PortProto port1 = pi1.getPortProto();
            Point2D pt0 = endPts[end];
            Point2D pt1 = endPts[1 - end];
            double dist = pt0.distance(pt1);
            double distX = pt1.getX() - pt0.getX();
            double distY = pt1.getY() - pt0.getY();
            int angle = 0;
            if (dist != 0.0) {
                angle = DBMath.figureAngle(pt0, pt1);
            }
            boolean useFAngle = false;
            double angleRadians = 0.0;
            if (angle % 900 != 0) {
                angleRadians = DBMath.figureAngleRadians(pt0, pt1);
                useFAngle = true;
            }
            Poly port0Poly = pi0.getPoly();
            double end0Offx = pt0.getX() - port0Poly.getCenterX();
            double end0Offy = pt0.getY() - port0Poly.getCenterY();
            SizeOffset so0 = node0.getSizeOffset();
            double node0Wid = node0.getXSize() - so0.getLowXOffset() - so0.getHighXOffset();
            double node0Hei = node0.getYSize() - so0.getLowYOffset() - so0.getHighYOffset();
            SizeOffset so1 = node1.getSizeOffset();
            double node1Wid = node1.getXSize() - so1.getLowXOffset() - so1.getHighXOffset();
            double node1Hei = node1.getYSize() - so1.getLowYOffset() - so1.getHighYOffset();
            Iterator it2 = cell.getNodes();
            while (it2.hasNext()) {
                NodeInst ni = (NodeInst)it2.next();
                Rectangle2D bounds = ni.getBounds();
                Iterator oIt = cell.getNodes();
                while (oIt.hasNext()) {
                    NodeInst oNi = (NodeInst)oIt.next();
                    Rectangle2D oBounds = oNi.getBounds();
                    if ((node0 != node1 ? ni == oNi : ni != oNi) || (!(distX > 0.0) ? bounds.getMinX() + distX > oBounds.getMaxX() || bounds.getMaxX() + distX < oBounds.getMinX() : bounds.getMaxX() + distX < oBounds.getMinX() || bounds.getMinX() + distX > oBounds.getMaxX())) continue;
                    if (distY > 0.0 ? bounds.getMaxY() + distY < oBounds.getMinY() || bounds.getMinY() + distY > oBounds.getMaxY() : bounds.getMinY() + distY > oBounds.getMaxY() || bounds.getMaxY() + distY < oBounds.getMinY()) continue;
                    Iterator pIt = ni.getPortInsts();
                    while (pIt.hasNext()) {
                        PortInst pi = (PortInst)pIt.next();
                        PortProto pp = pi.getPortProto();
                        Poly poly = (Poly)cachedPortPoly.get(pi);
                        if (poly == null) continue;
                        double x0 = poly.getCenterX();
                        double y0 = poly.getCenterY();
                        double wantX1 = x0 += end0Offx;
                        double wantY1 = y0 += end0Offy;
                        if (dist != 0.0) {
                            if (useFAngle) {
                                wantX1 = x0 + Math.cos(angleRadians) * dist;
                                wantY1 = y0 + Math.sin(angleRadians) * dist;
                            } else {
                                wantX1 = x0 + DBMath.cos(angle) * dist;
                                wantY1 = y0 + DBMath.sin(angle) * dist;
                            }
                        }
                        Point2D.Double xy0 = new Point2D.Double(x0, y0);
                        Point2D.Double want1 = new Point2D.Double(wantX1, wantY1);
                        Iterator oPIt = oNi.getPortInsts();
                        while (oPIt.hasNext()) {
                            int con2;
                            boolean ptInPoly;
                            PortInst oPi = (PortInst)oPIt.next();
                            PortProto oPp = oPi.getPortProto();
                            Poly thisPoly = (Poly)cachedPortPoly.get(oPi);
                            if (thisPoly == null || pi == pi0 && oPi == pi1 || !(ptInPoly = thisPoly.isInside(want1))) continue;
                            int situation = 0;
                            int desiredAngle = -1;
                            if (x0 != wantX1 || y0 != wantY1) {
                                desiredAngle = DBMath.figureAngle(xy0, want1);
                            }
                            PortInst piNet0 = null;
                            Iterator pII = ni.getConnections();
                            while (pII.hasNext()) {
                                int existingAngle;
                                Connection con = (Connection)pII.next();
                                PortInst aPi = con.getPortInst();
                                if (aPi.getPortProto() != pp) continue;
                                ArcInst oAi = con.getArc();
                                piNet0 = aPi;
                                if (desiredAngle < 0) {
                                    if (oAi.getHeadLocation().getX() != oAi.getTailLocation().getX() || oAi.getHeadLocation().getY() != oAi.getTailLocation().getY()) continue;
                                    situation |= 0x10;
                                    break;
                                }
                                if (oAi.getHeadLocation().getX() == oAi.getTailLocation().getX() && oAi.getHeadLocation().getY() == oAi.getTailLocation().getY()) continue;
                                int thisend = 0;
                                if (oAi.getTailPortInst() == aPi) {
                                    thisend = 1;
                                }
                                if ((existingAngle = DBMath.figureAngle(oAi.getLocation(thisend), oAi.getLocation(1 - thisend))) != desiredAngle) continue;
                                situation |= 0x10;
                                break;
                            }
                            desiredAngle = -1;
                            if (x0 != wantX1 || y0 != wantY1) {
                                desiredAngle = DBMath.figureAngle(want1, xy0);
                            }
                            PortInst piNet1 = null;
                            Iterator pII2 = oNi.getConnections();
                            while (pII2.hasNext()) {
                                int existingAngle;
                                Connection con = (Connection)pII2.next();
                                PortInst aPi = con.getPortInst();
                                if (aPi.getPortProto() != oPp) continue;
                                ArcInst oAi = con.getArc();
                                piNet1 = aPi;
                                if (desiredAngle < 0) {
                                    if (oAi.getHeadLocation().getX() != oAi.getTailLocation().getX() || oAi.getHeadLocation().getY() != oAi.getTailLocation().getY()) continue;
                                    situation |= 0x10;
                                    break;
                                }
                                if (oAi.getHeadLocation().getX() == oAi.getTailLocation().getX() && oAi.getHeadLocation().getY() == oAi.getTailLocation().getY()) continue;
                                int thisend = 0;
                                if (oAi.getTailPortInst() == aPi) {
                                    thisend = 1;
                                }
                                if ((existingAngle = DBMath.figureAngle(oAi.getLocation(thisend), oAi.getLocation(1 - thisend))) != desiredAngle) continue;
                                situation |= 0x10;
                                break;
                            }
                            if (piNet0 != null && piNet1 != null && netlist.sameNetwork(piNet0.getNodeInst(), piNet0.getPortProto(), piNet1.getNodeInst(), piNet1.getPortProto())) continue;
                            if (pp != port0 || oPp != port1) {
                                situation |= 1;
                            }
                            if (con1 != (con2 = ni.getNumConnections() + oNi.getNumConnections())) {
                                situation |= 2;
                            }
                            if (ni.getProto() != node0.getProto() || oNi.getProto() != node1.getProto()) {
                                situation |= 4;
                            }
                            SizeOffset so = ni.getSizeOffset();
                            double wid = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
                            double hei = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
                            if (wid != node0Wid || hei != node0Hei) {
                                situation |= 8;
                            }
                            so = oNi.getSizeOffset();
                            wid = oNi.getXSize() - so.getLowXOffset() - so.getHighXOffset();
                            hei = oNi.getYSize() - so.getLowYOffset() - so.getHighYOffset();
                            if (wid != node1Wid || hei != node1Hei) {
                                situation |= 8;
                            }
                            PossibleArc found = null;
                            Iterator paIt = possibleArcs.iterator();
                            while (paIt.hasNext()) {
                                PossibleArc pa = (PossibleArc)paIt.next();
                                if (pa.ni1 == ni && pa.pp1 == pp && pa.ni2 == oNi && pa.pp2 == oPp) {
                                    found = pa;
                                    break;
                                }
                                if (pa.ni2 != ni || pa.pp2 != pp || pa.ni1 != oNi || pa.pp1 != oPp) continue;
                                found = pa;
                                break;
                            }
                            if (found != null) {
                                if (found.situation == situation) continue;
                                int foundIndex = -1;
                                for (int k = 0; k < situations.length && found.situation != situations[k]; ++k) {
                                    if (situation != situations[k]) continue;
                                    foundIndex = k;
                                    break;
                                }
                                if (foundIndex >= 0 && found.situation == situations[foundIndex]) continue;
                            }
                            if (found == null) {
                                found = new PossibleArc();
                                possibleArcs.add(found);
                            }
                            found.ni1 = ni;
                            found.pp1 = pp;
                            found.pt1 = xy0;
                            found.ni2 = oNi;
                            found.pp2 = oPp;
                            found.pt2 = want1;
                            found.situation = situation;
                        }
                    }
                }
            }
        }
        if (mimicInteractive) {
            MimicInteractive task = new MimicInteractive(cell, possibleArcs, prefX, prefY, highlighter);
            SwingUtilities.invokeLater(task);
        } else {
            int ifIgnorePorts = 0;
            int ifIgnoreArcCount = 0;
            int ifIgnoreNodeType = 0;
            int ifIgnoreNodeSize = 0;
            int ifIgnoreOtherSameDir = 0;
            int count = 0;
            for (int j = 0; j < situations.length; ++j) {
                ArrayList<Route> allRoutes = new ArrayList<Route>();
                Iterator it3 = possibleArcs.iterator();
                while (it3.hasNext()) {
                    PossibleArc pa = (PossibleArc)it3.next();
                    if (pa.situation != situations[j]) continue;
                    Poly portPoly1 = pa.ni1.getShapeOfPort(pa.pp1);
                    Poly portPoly2 = pa.ni2.getShapeOfPort(pa.pp2);
                    Point2D.Double bend = new Point2D.Double((portPoly1.getCenterX() + portPoly2.getCenterX()) / 2.0 + prefX, (portPoly1.getCenterY() + portPoly2.getCenterY()) / 2.0 + prefY);
                    PortInst pi1 = pa.ni1.findPortInstFromProto(pa.pp1);
                    PortInst pi2 = pa.ni2.findPortInstFromProto(pa.pp2);
                    Route route = router.planRoute(pa.ni1.getParent(), pi1, pi2, bend, null);
                    if (route.size() == 0) {
                        System.out.println("Problem creating arc");
                        continue;
                    }
                    allRoutes.add(route);
                }
                int total = allRoutes.size();
                if (total == 0) continue;
                if (matchPorts && (situations[j] & 1) != 0) {
                    ifIgnorePorts += total;
                    continue;
                }
                if (matchArcCount && (situations[j] & 2) != 0) {
                    ifIgnoreArcCount += total;
                    continue;
                }
                if (matchNodeType && (situations[j] & 4) != 0) {
                    ifIgnoreNodeType += total;
                    continue;
                }
                if (matchNodeSize && (situations[j] & 8) != 0) {
                    ifIgnoreNodeSize += total;
                    continue;
                }
                if (noOtherArcsThisDir && (situations[j] & 0x10) != 0) {
                    ifIgnoreOtherSameDir += total;
                    continue;
                }
                if (method == Job.Type.EXAMINE) {
                    MimicWireJob job = new MimicWireJob(allRoutes, highlighter, false);
                } else {
                    MimicStitch.runTheWires(allRoutes, highlighter, false);
                }
                count += total;
            }
            if (count != 0) {
                System.out.println("MIMIC ROUTING: Created " + count + " arcs");
            } else if (forced) {
                String msg = "No wires added";
                if (ifIgnorePorts != 0) {
                    msg = msg + ", might have added " + ifIgnorePorts + " wires if 'ports must match' were off";
                }
                if (ifIgnoreArcCount != 0) {
                    msg = msg + ", might have added " + ifIgnoreArcCount + " wires if 'number of existing arcs must match' were off";
                }
                if (ifIgnoreNodeType != 0) {
                    msg = msg + ", might have added " + ifIgnoreNodeType + " wires if 'node types must match' were off";
                }
                if (ifIgnoreNodeSize != 0) {
                    msg = msg + ", might have added " + ifIgnoreNodeSize + " wires if 'nodes sizes must match' were off";
                }
                if (ifIgnoreOtherSameDir != 0) {
                    msg = msg + ", might have added " + ifIgnoreOtherSameDir + " wires if 'cannot have other arcs in the same direction' were off";
                }
                System.out.println(msg);
                if (ifIgnorePorts + ifIgnoreArcCount + ifIgnoreNodeType + ifIgnoreNodeSize + ifIgnoreOtherSameDir != 0) {
                    System.out.println(" (settings are in the Tools / Routing tab of the Preferences)");
                }
            }
        }
    }

    private static void runTheWires(List allRoutes, Highlighter highlighter, boolean redisplay) {
        Iterator it = allRoutes.iterator();
        while (it.hasNext()) {
            Route route = (Route)it.next();
            RouteElement re = (RouteElement)route.get(0);
            Cell c = re.getCell();
            Router.createRouteNoJob(route, c, false, false, highlighter);
        }
        if (redisplay) {
            EditWindow.repaintAllContents();
        }
    }

    private static void presentNextSituation(int count, int situationNumber, List possibleArcs, Cell cell, Highlighter highlighter, double prefX, double prefY) {
        for (int j = situationNumber; j < situations.length; ++j) {
            ArrayList<Route> allRoutes = new ArrayList<Route>();
            Iterator it = possibleArcs.iterator();
            while (it.hasNext()) {
                PossibleArc pa = (PossibleArc)it.next();
                if (pa.situation != situations[j]) continue;
                Poly portPoly1 = pa.ni1.getShapeOfPort(pa.pp1);
                Poly portPoly2 = pa.ni2.getShapeOfPort(pa.pp2);
                Point2D.Double bend = new Point2D.Double((portPoly1.getCenterX() + portPoly2.getCenterX()) / 2.0 + prefX, (portPoly1.getCenterY() + portPoly2.getCenterY()) / 2.0 + prefY);
                PortInst pi1 = pa.ni1.findPortInstFromProto(pa.pp1);
                PortInst pi2 = pa.ni2.findPortInstFromProto(pa.pp2);
                Route route = router.planRoute(pa.ni1.getParent(), pi1, pi2, bend, null);
                if (route.size() == 0) {
                    System.out.println("Problem creating arc");
                    continue;
                }
                allRoutes.add(route);
            }
            if (allRoutes.size() == 0) continue;
            ArrayList saveHighlights = new ArrayList();
            Iterator it2 = highlighter.getHighlights().iterator();
            while (it2.hasNext()) {
                saveHighlights.add(it2.next());
            }
            highlighter.clear();
            it2 = allRoutes.iterator();
            while (it2.hasNext()) {
                Route route = (Route)it2.next();
                Poly sPi = route.getStart().getPortInst().getPoly();
                Poly ePi = route.getEnd().getPortInst().getPoly();
                double fX = sPi.getCenterX();
                double fY = sPi.getCenterY();
                double tX = ePi.getCenterX();
                double tY = ePi.getCenterY();
                if (fX == tX && fY == tY) {
                    Rectangle2D.Double pointRect = new Rectangle2D.Double(fX - 1.0, fY - 1.0, 2.0, 2.0);
                    highlighter.addArea(pointRect, cell);
                    continue;
                }
                highlighter.addLine(new Point2D.Double(fX, fY), new Point2D.Double(tX, tY), cell);
            }
            highlighter.finished();
            MimicDialog md = new MimicDialog(TopLevel.getCurrentJFrame(), count, allRoutes, saveHighlights, highlighter, j + 1, possibleArcs, cell, prefX, prefY);
            return;
        }
        if (count != 0) {
            System.out.println("MIMIC ROUTING: Created " + count + " arcs");
        }
    }

    private static class MimicDialog
    extends EDialog {
        private int count;
        private List allRoutes;
        private List saveHighlights;
        private Highlighter highlighter;
        private int nextSituationNumber;
        private List possibleArcs;
        private Cell cell;
        private double prefX;
        private double prefY;

        private MimicDialog(Frame parent, int count, List allRoutes, List saveHighlights, Highlighter highlighter, int nextSituationNumber, List possibleArcs, Cell cell, double prefX, double prefY) {
            super(parent, false);
            this.count = count;
            this.allRoutes = allRoutes;
            this.saveHighlights = saveHighlights;
            this.highlighter = highlighter;
            this.nextSituationNumber = nextSituationNumber;
            this.possibleArcs = possibleArcs;
            this.cell = cell;
            this.prefX = prefX;
            this.prefY = prefY;
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Create wires?");
            this.setDefaultCloseOperation(0);
            JLabel question = new JLabel("Create " + allRoutes.size() + " wires shown here?");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 4;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)question, gbc);
            JButton yes = new JButton("Yes");
            yes.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MimicDialog.this.yes();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)yes, gbc);
            this.getRootPane().setDefaultButton(yes);
            JButton no = new JButton("No");
            no.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MimicDialog.this.no();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)no, gbc);
            JButton noAndStop = new JButton("No, and stop");
            noAndStop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MimicDialog.this.noAndStopActionPerformed();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)noAndStop, gbc);
            JButton yesAndStop = new JButton("Yes, then stop");
            yesAndStop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MimicDialog.this.yesAndStopActionPerformed();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)yesAndStop, gbc);
            this.pack();
            this.finishInitialization();
            this.setVisible(true);
        }

        protected void escapePressed() {
            this.no();
        }

        private void yesAndStopActionPerformed() {
            this.highlighter.clear();
            this.highlighter.setHighlightList(this.saveHighlights);
            this.highlighter.finished();
            MimicWireJob job = new MimicWireJob(this.allRoutes, this.highlighter, true);
            this.count += this.allRoutes.size();
            MimicStitch.presentNextSituation(this.count, situations.length, this.possibleArcs, this.cell, this.highlighter, this.prefX, this.prefY);
            this.setVisible(false);
            this.dispose();
        }

        private void noAndStopActionPerformed() {
            this.highlighter.clear();
            this.highlighter.setHighlightList(this.saveHighlights);
            this.highlighter.finished();
            MimicStitch.presentNextSituation(this.count, situations.length, this.possibleArcs, this.cell, this.highlighter, this.prefX, this.prefY);
            this.setVisible(false);
            this.dispose();
        }

        private void yes() {
            this.highlighter.clear();
            this.highlighter.setHighlightList(this.saveHighlights);
            this.highlighter.finished();
            MimicWireJob job = new MimicWireJob(this.allRoutes, this.highlighter, true);
            this.count += this.allRoutes.size();
            MimicStitch.presentNextSituation(this.count, this.nextSituationNumber, this.possibleArcs, this.cell, this.highlighter, this.prefX, this.prefY);
            this.setVisible(false);
            this.dispose();
        }

        private void no() {
            this.highlighter.clear();
            this.highlighter.setHighlightList(this.saveHighlights);
            this.highlighter.finished();
            MimicStitch.presentNextSituation(this.count, this.nextSituationNumber, this.possibleArcs, this.cell, this.highlighter, this.prefX, this.prefY);
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class MimicInteractive
    implements Runnable {
        private Cell cell;
        private List possibleArcs;
        private double prefX;
        private double prefY;
        private Highlighter highlighter;

        private MimicInteractive(Cell cell, List possibleArcs, double prefX, double prefY, Highlighter highlighter) {
            this.cell = cell;
            this.possibleArcs = possibleArcs;
            this.prefX = prefX;
            this.prefY = prefY;
            this.highlighter = highlighter;
        }

        public void run() {
            MimicStitch.presentNextSituation(0, 0, this.possibleArcs, this.cell, this.highlighter, this.prefX, this.prefY);
        }
    }

    private static class MimicWireJob
    extends Job {
        private List allRoutes;
        private Highlighter highlighter;
        private boolean redisplay;

        private MimicWireJob(List allRoutes, Highlighter highlighter, boolean redisplay) {
            super("Mimic-Stitch", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.allRoutes = allRoutes;
            this.highlighter = highlighter;
            this.redisplay = redisplay;
            this.startJob();
        }

        public boolean doIt() {
            MimicStitch.runTheWires(this.allRoutes, this.highlighter, this.redisplay);
            return true;
        }
    }

    private static class MimicStitchJob
    extends Job {
        private Connection conn1;
        private Connection conn2;
        private double oWidth;
        private ArcProto oProto;
        private double prefX;
        private double prefY;
        private boolean forced;
        private Highlighter highlighter;

        private MimicStitchJob(Connection conn1, Connection conn2, double oWidth, ArcProto oProto, double prefX, double prefY, boolean forced, Highlighter highlighter) {
            super("Mimic-Stitch", Routing.getRoutingTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.conn1 = conn1;
            this.conn2 = conn2;
            this.oWidth = oWidth;
            this.oProto = oProto;
            this.prefX = prefX;
            this.prefY = prefY;
            this.forced = forced;
            this.highlighter = highlighter;
            this.setReportExecutionFlag(true);
            this.startJob();
        }

        public boolean doIt() {
            boolean mimicInteractive = Routing.isMimicStitchInteractive();
            boolean matchPorts = Routing.isMimicStitchMatchPorts();
            boolean matchArcCount = Routing.isMimicStitchMatchNumArcs();
            boolean matchNodeType = Routing.isMimicStitchMatchNodeType();
            boolean matchNodeSize = Routing.isMimicStitchMatchNodeSize();
            boolean noOtherArcsThisDir = Routing.isMimicStitchNoOtherArcsSameDir();
            MimicStitch.mimicOneArc(this.conn1, this.conn2, this.oWidth, this.oProto, this.prefX, this.prefY, this.forced, this.highlighter, Job.Type.EXAMINE, mimicInteractive, matchPorts, matchArcCount, matchNodeType, matchNodeSize, noOtherArcsThisDir);
            return true;
        }
    }

    private static class MimicUnstitchJob
    extends Job {
        private List arcKills;

        private MimicUnstitchJob(List arcKills) {
            super("Mimic-Unstitch", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.arcKills = arcKills;
            this.setReportExecutionFlag(true);
            this.startJob();
        }

        public boolean doIt() {
            int deleted = 0;
            Iterator it = this.arcKills.iterator();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                ai.kill();
                ++deleted;
            }
            if (deleted != 0) {
                System.out.println("MIMIC ROUTING: deleted " + deleted + "wires");
            }
            return true;
        }
    }

    private static class PossibleArc {
        private int situation;
        private NodeInst ni1;
        private NodeInst ni2;
        private PortProto pp1;
        private PortProto pp2;
        private Point2D pt1;
        private Point2D pt2;

        private PossibleArc() {
        }
    }
}

