/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellContents;
import com.sun.electric.database.Cell_;
import com.sun.electric.database.DatabaseChangeThread;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.NodeInst_;
import com.sun.electric.database.Snapshot;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class DatabaseThread
extends Thread {
    Cell_[] cells = new Cell_[0];
    TreeMap orderedCells = new TreeMap();
    boolean valid = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Snapshot backup(Snapshot oldS) {
        int length;
        if (!this.valid) {
            throw new IllegalStateException("database invalid");
        }
        if (oldS == null) {
            oldS = Snapshot.EMPTY;
        }
        for (length = this.cells.length; length > 0 && this.cells[length - 1] == null; --length) {
        }
        ImmutableCell[] icells = new ImmutableCell[length];
        for (int i = 0; i < length; ++i) {
            icells[i] = this.cells[i] != null ? this.cells[i].backup(oldS.getCellById(i)) : null;
        }
        return oldS.withCells(icells);
    }

    void restore(Snapshot s) {
        Cell_ cell;
        int i;
        this.valid = false;
        if (this.cells.length <= s.maxCellId()) {
            Cell_[] newCells = new Cell_[s.maxCellId() + 1];
            System.arraycopy(this.cells, 0, newCells, 0, this.cells.length);
            this.cells = newCells;
        }
        boolean changeNames = true;
        for (i = 0; i < this.cells.length; ++i) {
            Cell_ oldCell = this.cells[i];
            ImmutableCell icell = s.getCellById(i);
            if (oldCell == null) {
                changeNames = true;
                new Cell_(i, icell);
                continue;
            }
            if (icell == null) {
                changeNames = true;
                oldCell.unlink();
                continue;
            }
            if (oldCell.name != icell.name) {
                changeNames = true;
            }
            oldCell.restore(icell);
        }
        if (changeNames) {
            this.orderedCells.clear();
            for (i = 0; i < this.cells.length; ++i) {
                cell = this.cells[i];
                if (cell == null) continue;
                this.orderedCells.put(cell.name, cell);
            }
        }
        for (i = 0; i < this.cells.length; ++i) {
            CellContents contents;
            cell = this.cells[i];
            if (cell == null || cell.contentsRef == null || (contents = (CellContents)cell.contentsRef.get()) == null) continue;
            contents.restore();
        }
        this.valid = true;
    }

    void clear() {
        this.orderedCells.clear();
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            this.cells[i].unlink();
        }
    }

    public void check() {
        Cell_ cell;
        int i;
        for (i = 0; i < this.cells.length; ++i) {
            CellContents contents;
            cell = this.cells[i];
            if (cell == null) continue;
            if (!$assertionsDisabled && cell.thread != this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && cell.id != i) {
                throw new AssertionError();
            }
            if (cell.contentsRef == null || (contents = (CellContents)cell.contentsRef.get()) == null) continue;
            if (!$assertionsDisabled && contents.cell != cell) {
                throw new AssertionError();
            }
            for (int j = 0; j < contents.nodes.length; ++j) {
                NodeInst_ node = contents.nodes[j];
                if (node == null) continue;
                if (!$assertionsDisabled && node.parent != contents) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && node.id != j) {
                    throw new AssertionError();
                }
            }
        }
        if (!this.valid) {
            return;
        }
        for (i = 0; i < this.cells.length; ++i) {
            cell = this.cells[i];
            if (cell == null) continue;
            cell.check();
            if (!$assertionsDisabled && this.orderedCells.get(cell.name) != cell) {
                throw new AssertionError();
            }
        }
        Iterator it = this.orderedCells.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String name = (String)e.getKey();
            Cell_ cell2 = (Cell_)e.getValue();
            if (!$assertionsDisabled && name != cell2.name) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && cell2 != this.cells[cell2.id]) {
                throw new AssertionError();
            }
        }
    }

    void checkLinked() {
        if (!$assertionsDisabled && Thread.currentThread() != this) {
            throw new AssertionError();
        }
    }

    DatabaseChangeThread checkChanging() {
        if (this != Thread.currentThread()) {
            throw new IllegalStateException("Other thread");
        }
        throw new IllegalStateException("Readonly thread");
    }

    void checkRunning() {
        if (this != Thread.currentThread()) {
            throw new IllegalStateException("Other thread");
        }
        if (!this.valid) {
            throw new IllegalStateException("database invalid");
        }
    }

    static {
        $assertionsDisabled = !DatabaseThread.class.desiredAssertionStatus();
    }
}

