/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Tech;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class Router {
    private HashMap portMap = new HashMap();

    private String makeKey(PortInst pi) {
        String x = "" + LayoutLib.roundCenterX(pi);
        String y = "" + LayoutLib.roundCenterY(pi);
        return x + "x" + y;
    }

    private boolean bothConnect(PrimitiveArc a, PortProto pp1, PortProto pp2) {
        return pp1.connectsTo(a) && pp2.connectsTo(a);
    }

    private PrimitiveArc findCommonArc(PortInst p1, PortInst p2) {
        PrimitiveArc[] metals = new PrimitiveArc[]{Tech.m6, Tech.m5, Tech.m4, Tech.m3, Tech.m2, Tech.m1};
        PortProto pp1 = p1.getPortProto();
        PortProto pp2 = p2.getPortProto();
        for (int i = 0; i < metals.length; ++i) {
            if (!pp1.connectsTo(metals[i]) || !pp2.connectsTo(metals[i])) continue;
            return metals[i];
        }
        return null;
    }

    private void connectPorts(List ports) {
        Iterator it = ports.iterator();
        while (it.hasNext()) {
            PortInst first = (PortInst)it.next();
            double width = LayoutLib.widestWireWidth(first);
            it.remove();
            Iterator it2 = ports.iterator();
            while (it2.hasNext()) {
                PortInst pi = (PortInst)it2.next();
                PrimitiveArc a = this.findCommonArc(first, pi);
                if (a == null) continue;
                LayoutLib.newArcInst(a, width, first, pi);
            }
        }
    }

    private Router(ArrayList ports) {
        Iterator<Object> it = ports.iterator();
        while (it.hasNext()) {
            PortInst pi = (PortInst)it.next();
            String key = this.makeKey(pi);
            LinkedList<PortInst> l = (LinkedList<PortInst>)this.portMap.get(key);
            if (l == null) {
                l = new LinkedList<PortInst>();
                this.portMap.put(key, l);
            }
            l.add(pi);
        }
        it = this.portMap.keySet().iterator();
        while (it.hasNext()) {
            this.connectPorts((List)this.portMap.get(it.next()));
        }
    }

    public static void connectCoincident(ArrayList ports) {
        new Router(ports);
    }
}

