// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#include "google/cloud/speech/v1/internal/adaptation_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace speech_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AdaptationTracingConnection::AdaptationTracingConnection(
    std::shared_ptr<speech_v1::AdaptationConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationTracingConnection::CreatePhraseSet(
    google::cloud::speech::v1::CreatePhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v1::AdaptationConnection::CreatePhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreatePhraseSet(request));
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationTracingConnection::GetPhraseSet(
    google::cloud::speech::v1::GetPhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v1::AdaptationConnection::GetPhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetPhraseSet(request));
}

StreamRange<google::cloud::speech::v1::PhraseSet>
AdaptationTracingConnection::ListPhraseSet(
    google::cloud::speech::v1::ListPhraseSetRequest request) {
  auto span =
      internal::MakeSpan("speech_v1::AdaptationConnection::ListPhraseSet");
  internal::OTelScope scope(span);
  auto sr = child_->ListPhraseSet(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::speech::v1::PhraseSet>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationTracingConnection::UpdatePhraseSet(
    google::cloud::speech::v1::UpdatePhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v1::AdaptationConnection::UpdatePhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdatePhraseSet(request));
}

Status AdaptationTracingConnection::DeletePhraseSet(
    google::cloud::speech::v1::DeletePhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v1::AdaptationConnection::DeletePhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeletePhraseSet(request));
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationTracingConnection::CreateCustomClass(
    google::cloud::speech::v1::CreateCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v1::AdaptationConnection::CreateCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateCustomClass(request));
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationTracingConnection::GetCustomClass(
    google::cloud::speech::v1::GetCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v1::AdaptationConnection::GetCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetCustomClass(request));
}

StreamRange<google::cloud::speech::v1::CustomClass>
AdaptationTracingConnection::ListCustomClasses(
    google::cloud::speech::v1::ListCustomClassesRequest request) {
  auto span =
      internal::MakeSpan("speech_v1::AdaptationConnection::ListCustomClasses");
  internal::OTelScope scope(span);
  auto sr = child_->ListCustomClasses(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::speech::v1::CustomClass>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationTracingConnection::UpdateCustomClass(
    google::cloud::speech::v1::UpdateCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v1::AdaptationConnection::UpdateCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateCustomClass(request));
}

Status AdaptationTracingConnection::DeleteCustomClass(
    google::cloud::speech::v1::DeleteCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v1::AdaptationConnection::DeleteCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteCustomClass(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<speech_v1::AdaptationConnection>
MakeAdaptationTracingConnection(
    std::shared_ptr<speech_v1::AdaptationConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<AdaptationTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1_internal
}  // namespace cloud
}  // namespace google
