// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto

#include "google/cloud/rapidmigrationassessment/v1/internal/rapid_migration_assessment_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace rapidmigrationassessment_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RapidMigrationAssessmentTracingStub::RapidMigrationAssessmentTracingStub(
    std::shared_ptr<RapidMigrationAssessmentStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

future<StatusOr<google::longrunning::Operation>>
RapidMigrationAssessmentTracingStub::AsyncCreateCollector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::rapidmigrationassessment::v1::CreateCollectorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessment",
      "CreateCollector");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateCollector(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
RapidMigrationAssessmentTracingStub::AsyncCreateAnnotation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::rapidmigrationassessment::v1::CreateAnnotationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessment",
      "CreateAnnotation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateAnnotation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>
RapidMigrationAssessmentTracingStub::GetAnnotation(
    grpc::ClientContext& context,
    google::cloud::rapidmigrationassessment::v1::GetAnnotationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessment",
      "GetAnnotation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAnnotation(context, request));
}

StatusOr<google::cloud::rapidmigrationassessment::v1::ListCollectorsResponse>
RapidMigrationAssessmentTracingStub::ListCollectors(
    grpc::ClientContext& context,
    google::cloud::rapidmigrationassessment::v1::ListCollectorsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessment",
      "ListCollectors");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListCollectors(context, request));
}

StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>
RapidMigrationAssessmentTracingStub::GetCollector(
    grpc::ClientContext& context,
    google::cloud::rapidmigrationassessment::v1::GetCollectorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessment",
      "GetCollector");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCollector(context, request));
}

future<StatusOr<google::longrunning::Operation>>
RapidMigrationAssessmentTracingStub::AsyncUpdateCollector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::rapidmigrationassessment::v1::UpdateCollectorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessment",
      "UpdateCollector");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateCollector(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
RapidMigrationAssessmentTracingStub::AsyncDeleteCollector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::rapidmigrationassessment::v1::DeleteCollectorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessment",
      "DeleteCollector");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteCollector(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
RapidMigrationAssessmentTracingStub::AsyncResumeCollector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::rapidmigrationassessment::v1::ResumeCollectorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessment",
      "ResumeCollector");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncResumeCollector(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
RapidMigrationAssessmentTracingStub::AsyncRegisterCollector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::rapidmigrationassessment::v1::RegisterCollectorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessment",
      "RegisterCollector");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncRegisterCollector(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
RapidMigrationAssessmentTracingStub::AsyncPauseCollector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::rapidmigrationassessment::v1::PauseCollectorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.rapidmigrationassessment.v1.RapidMigrationAssessment",
      "PauseCollector");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncPauseCollector(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
RapidMigrationAssessmentTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> RapidMigrationAssessmentTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<RapidMigrationAssessmentStub>
MakeRapidMigrationAssessmentTracingStub(
    std::shared_ptr<RapidMigrationAssessmentStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<RapidMigrationAssessmentTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace rapidmigrationassessment_v1_internal
}  // namespace cloud
}  // namespace google
