// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_zonal_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_OS_CONFIG_ZONAL_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_OS_CONFIG_ZONAL_CLIENT_H

#include "google/cloud/osconfig/v1/os_config_zonal_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Zonal OS Config API
///
/// The OS Config service is the server-side component that allows users to
/// manage package installations and patch jobs for Compute Engine VM instances.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class OsConfigZonalServiceClient {
 public:
  explicit OsConfigZonalServiceClient(
      std::shared_ptr<OsConfigZonalServiceConnection> connection,
      Options opts = {});
  ~OsConfigZonalServiceClient();

  ///@{
  /// @name Copy and move support
  OsConfigZonalServiceClient(OsConfigZonalServiceClient const&) = default;
  OsConfigZonalServiceClient& operator=(OsConfigZonalServiceClient const&) =
      default;
  OsConfigZonalServiceClient(OsConfigZonalServiceClient&&) = default;
  OsConfigZonalServiceClient& operator=(OsConfigZonalServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(OsConfigZonalServiceClient const& a,
                         OsConfigZonalServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(OsConfigZonalServiceClient const& a,
                         OsConfigZonalServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Create an OS policy assignment.
  ///
  /// This method also creates the first revision of the OS policy assignment.
  ///
  /// This method returns a long running operation (LRO) that contains the
  /// rollout details. The rollout can be cancelled by cancelling the LRO.
  ///
  /// For more information, see [Method:
  /// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
  ///
  /// @param parent  Required. The parent resource name in the form:
  ///  projects/{project}/locations/{location}
  /// @param os_policy_assignment  Required. The OS policy assignment to be created.
  /// @param os_policy_assignment_id  Required. The logical name of the OS policy assignment in the project
  ///  with the following restrictions:
  ///  @n
  ///  * Must contain only lowercase letters, numbers, and hyphens.
  ///  * Must start with a letter.
  ///  * Must be between 1-63 characters.
  ///  * Must end with a number or a letter.
  ///  * Must be unique within the project.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.osconfig.v1.OSPolicyAssignment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.CreateOSPolicyAssignmentRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L269}
  /// [google.cloud.osconfig.v1.OSPolicyAssignment]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L46}
  ///
  // clang-format on
  future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  CreateOSPolicyAssignment(
      std::string const& parent,
      google::cloud::osconfig::v1::OSPolicyAssignment const&
          os_policy_assignment,
      std::string const& os_policy_assignment_id, Options opts = {});

  // clang-format off
  ///
  /// Create an OS policy assignment.
  ///
  /// This method also creates the first revision of the OS policy assignment.
  ///
  /// This method returns a long running operation (LRO) that contains the
  /// rollout details. The rollout can be cancelled by cancelling the LRO.
  ///
  /// For more information, see [Method:
  /// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.CreateOSPolicyAssignmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.osconfig.v1.OSPolicyAssignment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.CreateOSPolicyAssignmentRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L269}
  /// [google.cloud.osconfig.v1.OSPolicyAssignment]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L46}
  ///
  // clang-format on
  future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  CreateOSPolicyAssignment(
      google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Update an existing OS policy assignment.
  ///
  /// This method creates a new revision of the OS policy assignment.
  ///
  /// This method returns a long running operation (LRO) that contains the
  /// rollout details. The rollout can be cancelled by cancelling the LRO.
  ///
  /// For more information, see [Method:
  /// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
  ///
  /// @param os_policy_assignment  Required. The updated OS policy assignment.
  /// @param update_mask  Optional. Field mask that controls which fields of the assignment should be
  ///  updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.osconfig.v1.OSPolicyAssignment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.OSPolicyAssignment]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L46}
  /// [google.cloud.osconfig.v1.UpdateOSPolicyAssignmentRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L295}
  ///
  // clang-format on
  future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  UpdateOSPolicyAssignment(
      google::cloud::osconfig::v1::OSPolicyAssignment const&
          os_policy_assignment,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update an existing OS policy assignment.
  ///
  /// This method creates a new revision of the OS policy assignment.
  ///
  /// This method returns a long running operation (LRO) that contains the
  /// rollout details. The rollout can be cancelled by cancelling the LRO.
  ///
  /// For more information, see [Method:
  /// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.UpdateOSPolicyAssignmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.osconfig.v1.OSPolicyAssignment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.OSPolicyAssignment]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L46}
  /// [google.cloud.osconfig.v1.UpdateOSPolicyAssignmentRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L295}
  ///
  // clang-format on
  future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  UpdateOSPolicyAssignment(
      google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieve an existing OS policy assignment.
  ///
  /// This method always returns the latest revision. In order to retrieve a
  /// previous revision of the assignment, also provide the revision ID in the
  /// `name` parameter.
  ///
  /// @param name  Required. The resource name of OS policy assignment.
  ///  @n
  ///  Format:
  ///  `projects/{project}/locations/{location}/osPolicyAssignments/{os_policy_assignment}@{revisionId}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.osconfig.v1.OSPolicyAssignment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.GetOSPolicyAssignmentRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L307}
  /// [google.cloud.osconfig.v1.OSPolicyAssignment]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L46}
  ///
  // clang-format on
  StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>
  GetOSPolicyAssignment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieve an existing OS policy assignment.
  ///
  /// This method always returns the latest revision. In order to retrieve a
  /// previous revision of the assignment, also provide the revision ID in the
  /// `name` parameter.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.GetOSPolicyAssignmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.osconfig.v1.OSPolicyAssignment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.GetOSPolicyAssignmentRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L307}
  /// [google.cloud.osconfig.v1.OSPolicyAssignment]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L46}
  ///
  // clang-format on
  StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>
  GetOSPolicyAssignment(
      google::cloud::osconfig::v1::GetOSPolicyAssignmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List the OS policy assignments under the parent resource.
  ///
  /// For each OS policy assignment, the latest revision is returned.
  ///
  /// @param parent  Required. The parent resource name.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.osconfig.v1.OSPolicyAssignment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.ListOSPolicyAssignmentsRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L321}
  /// [google.cloud.osconfig.v1.OSPolicyAssignment]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L46}
  ///
  // clang-format on
  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
  ListOSPolicyAssignments(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List the OS policy assignments under the parent resource.
  ///
  /// For each OS policy assignment, the latest revision is returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.ListOSPolicyAssignmentsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.osconfig.v1.OSPolicyAssignment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.ListOSPolicyAssignmentsRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L321}
  /// [google.cloud.osconfig.v1.OSPolicyAssignment]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L46}
  ///
  // clang-format on
  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
  ListOSPolicyAssignments(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// List the OS policy assignment revisions for a given OS policy assignment.
  ///
  /// @param name  Required. The name of the OS policy assignment to list revisions for.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.osconfig.v1.OSPolicyAssignment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.ListOSPolicyAssignmentRevisionsRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L349}
  /// [google.cloud.osconfig.v1.OSPolicyAssignment]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L46}
  ///
  // clang-format on
  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
  ListOSPolicyAssignmentRevisions(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// List the OS policy assignment revisions for a given OS policy assignment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.ListOSPolicyAssignmentRevisionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.osconfig.v1.OSPolicyAssignment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.ListOSPolicyAssignmentRevisionsRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L349}
  /// [google.cloud.osconfig.v1.OSPolicyAssignment]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L46}
  ///
  // clang-format on
  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
  ListOSPolicyAssignmentRevisions(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentRevisionsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Delete the OS policy assignment.
  ///
  /// This method creates a new revision of the OS policy assignment.
  ///
  /// This method returns a long running operation (LRO) that contains the
  /// rollout details. The rollout can be cancelled by cancelling the LRO.
  ///
  /// If the LRO completes and is not cancelled, all revisions associated with
  /// the OS policy assignment are deleted.
  ///
  /// For more information, see [Method:
  /// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
  ///
  /// @param name  Required. The name of the OS policy assignment to be deleted
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.DeleteOSPolicyAssignmentRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L378}
  /// [google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L213}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>
  DeleteOSPolicyAssignment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Delete the OS policy assignment.
  ///
  /// This method creates a new revision of the OS policy assignment.
  ///
  /// This method returns a long running operation (LRO) that contains the
  /// rollout details. The rollout can be cancelled by cancelling the LRO.
  ///
  /// If the LRO completes and is not cancelled, all revisions associated with
  /// the OS policy assignment are deleted.
  ///
  /// For more information, see [Method:
  /// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.DeleteOSPolicyAssignmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.DeleteOSPolicyAssignmentRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L378}
  /// [google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignments.proto#L213}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>
  DeleteOSPolicyAssignment(
      google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Get the OS policy asssignment report for the specified Compute Engine VM
  /// instance.
  ///
  /// @param name  Required. API resource name for OS policy assignment report.
  ///  @n
  ///  Format:
  ///  `/projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/report`
  ///  @n
  ///  For `{project}`, either `project-number` or `project-id` can be provided.
  ///  For `{instance_id}`, either Compute Engine `instance-id` or `instance-name`
  ///  can be provided.
  ///  For `{assignment_id}`, the OSPolicyAssignment id must be provided.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.osconfig.v1.OSPolicyAssignmentReport])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.GetOSPolicyAssignmentReportRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignment_reports.proto#L36}
  /// [google.cloud.osconfig.v1.OSPolicyAssignmentReport]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignment_reports.proto#L109}
  ///
  // clang-format on
  StatusOr<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
  GetOSPolicyAssignmentReport(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get the OS policy asssignment report for the specified Compute Engine VM
  /// instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.GetOSPolicyAssignmentReportRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.osconfig.v1.OSPolicyAssignmentReport])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.GetOSPolicyAssignmentReportRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignment_reports.proto#L36}
  /// [google.cloud.osconfig.v1.OSPolicyAssignmentReport]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignment_reports.proto#L109}
  ///
  // clang-format on
  StatusOr<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
  GetOSPolicyAssignmentReport(
      google::cloud::osconfig::v1::GetOSPolicyAssignmentReportRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// List OS policy asssignment reports for all Compute Engine VM instances in
  /// the specified zone.
  ///
  /// @param parent  Required. The parent resource name.
  ///  @n
  ///  Format:
  ///  `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
  ///  @n
  ///  For `{project}`, either `project-number` or `project-id` can be provided.
  ///  For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
  ///  provided. If '-' is provided, the response will include
  ///  OSPolicyAssignmentReports for all instances in the project/location.
  ///  For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
  ///  is provided, the response will include OSPolicyAssignmentReports for all
  ///  OSPolicyAssignments in the project/location.
  ///  Either {instance} or {assignment} must be `-`.
  ///  @n
  ///  For example:
  ///  `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
  ///   returns all reports for the instance
  ///  `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
  ///   returns all the reports for the given assignment across all instances.
  ///  `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
  ///   returns all the reports for all assignments across all instances.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.osconfig.v1.OSPolicyAssignmentReport], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignment_reports.proto#L55}
  /// [google.cloud.osconfig.v1.OSPolicyAssignmentReport]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignment_reports.proto#L109}
  ///
  // clang-format on
  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
  ListOSPolicyAssignmentReports(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List OS policy asssignment reports for all Compute Engine VM instances in
  /// the specified zone.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.osconfig.v1.OSPolicyAssignmentReport], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignment_reports.proto#L55}
  /// [google.cloud.osconfig.v1.OSPolicyAssignmentReport]: @googleapis_reference_link{google/cloud/osconfig/v1/os_policy_assignment_reports.proto#L109}
  ///
  // clang-format on
  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
  ListOSPolicyAssignmentReports(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentReportsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Get inventory data for the specified VM instance. If the VM has no
  /// associated inventory, the message `NOT_FOUND` is returned.
  ///
  /// @param name  Required. API resource name for inventory resource.
  ///  @n
  ///  Format:
  ///  `projects/{project}/locations/{location}/instances/{instance}/inventory`
  ///  @n
  ///  For `{project}`, either `project-number` or `project-id` can be provided.
  ///  For `{instance}`, either Compute Engine  `instance-id` or `instance-name`
  ///  can be provided.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.osconfig.v1.Inventory])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.GetInventoryRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/inventory.proto#L310}
  /// [google.cloud.osconfig.v1.Inventory]: @googleapis_reference_link{google/cloud/osconfig/v1/inventory.proto#L42}
  ///
  // clang-format on
  StatusOr<google::cloud::osconfig::v1::Inventory> GetInventory(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get inventory data for the specified VM instance. If the VM has no
  /// associated inventory, the message `NOT_FOUND` is returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.GetInventoryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.osconfig.v1.Inventory])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.GetInventoryRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/inventory.proto#L310}
  /// [google.cloud.osconfig.v1.Inventory]: @googleapis_reference_link{google/cloud/osconfig/v1/inventory.proto#L42}
  ///
  // clang-format on
  StatusOr<google::cloud::osconfig::v1::Inventory> GetInventory(
      google::cloud::osconfig::v1::GetInventoryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List inventory data for all VM instances in the specified zone.
  ///
  /// @param parent  Required. The parent resource name.
  ///  @n
  ///  Format: `projects/{project}/locations/{location}/instances/-`
  ///  @n
  ///  For `{project}`, either `project-number` or `project-id` can be provided.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.osconfig.v1.Inventory], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.Inventory]: @googleapis_reference_link{google/cloud/osconfig/v1/inventory.proto#L42}
  /// [google.cloud.osconfig.v1.ListInventoriesRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/inventory.proto#L333}
  ///
  // clang-format on
  StreamRange<google::cloud::osconfig::v1::Inventory> ListInventories(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List inventory data for all VM instances in the specified zone.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.ListInventoriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.osconfig.v1.Inventory], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.Inventory]: @googleapis_reference_link{google/cloud/osconfig/v1/inventory.proto#L42}
  /// [google.cloud.osconfig.v1.ListInventoriesRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/inventory.proto#L333}
  ///
  // clang-format on
  StreamRange<google::cloud::osconfig::v1::Inventory> ListInventories(
      google::cloud::osconfig::v1::ListInventoriesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the vulnerability report for the specified VM instance. Only VMs with
  /// inventory data have vulnerability reports associated with them.
  ///
  /// @param name  Required. API resource name for vulnerability resource.
  ///  @n
  ///  Format:
  ///  `projects/{project}/locations/{location}/instances/{instance}/vulnerabilityReport`
  ///  @n
  ///  For `{project}`, either `project-number` or `project-id` can be provided.
  ///  For `{instance}`, either Compute Engine `instance-id` or `instance-name`
  ///  can be provided.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.osconfig.v1.VulnerabilityReport])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.GetVulnerabilityReportRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/vulnerability.proto#L148}
  /// [google.cloud.osconfig.v1.VulnerabilityReport]: @googleapis_reference_link{google/cloud/osconfig/v1/vulnerability.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::osconfig::v1::VulnerabilityReport>
  GetVulnerabilityReport(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the vulnerability report for the specified VM instance. Only VMs with
  /// inventory data have vulnerability reports associated with them.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.GetVulnerabilityReportRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.osconfig.v1.VulnerabilityReport])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.GetVulnerabilityReportRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/vulnerability.proto#L148}
  /// [google.cloud.osconfig.v1.VulnerabilityReport]: @googleapis_reference_link{google/cloud/osconfig/v1/vulnerability.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::osconfig::v1::VulnerabilityReport>
  GetVulnerabilityReport(
      google::cloud::osconfig::v1::GetVulnerabilityReportRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List vulnerability reports for all VM instances in the specified zone.
  ///
  /// @param parent  Required. The parent resource name.
  ///  @n
  ///  Format: `projects/{project}/locations/{location}/instances/-`
  ///  @n
  ///  For `{project}`, either `project-number` or `project-id` can be provided.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.osconfig.v1.VulnerabilityReport], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.ListVulnerabilityReportsRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/vulnerability.proto#L167}
  /// [google.cloud.osconfig.v1.VulnerabilityReport]: @googleapis_reference_link{google/cloud/osconfig/v1/vulnerability.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::osconfig::v1::VulnerabilityReport>
  ListVulnerabilityReports(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List vulnerability reports for all VM instances in the specified zone.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.osconfig.v1.ListVulnerabilityReportsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.osconfig.v1.VulnerabilityReport], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.osconfig.v1.ListVulnerabilityReportsRequest]: @googleapis_reference_link{google/cloud/osconfig/v1/vulnerability.proto#L167}
  /// [google.cloud.osconfig.v1.VulnerabilityReport]: @googleapis_reference_link{google/cloud/osconfig/v1/vulnerability.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::osconfig::v1::VulnerabilityReport>
  ListVulnerabilityReports(
      google::cloud::osconfig::v1::ListVulnerabilityReportsRequest request,
      Options opts = {});

 private:
  std::shared_ptr<OsConfigZonalServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_OS_CONFIG_ZONAL_CLIENT_H
