// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/service_service.proto

#include "google/cloud/monitoring/v3/internal/service_monitoring_connection_impl.h"
#include "google/cloud/monitoring/v3/internal/service_monitoring_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<monitoring_v3::ServiceMonitoringServiceRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<monitoring_v3::ServiceMonitoringServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<monitoring_v3::ServiceMonitoringServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    monitoring_v3::ServiceMonitoringServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<monitoring_v3::
               ServiceMonitoringServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

ServiceMonitoringServiceConnectionImpl::ServiceMonitoringServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<monitoring_v3_internal::ServiceMonitoringServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), ServiceMonitoringServiceConnection::options())) {}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceConnectionImpl::CreateService(
    google::monitoring::v3::CreateServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateService(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::CreateServiceRequest const& request) {
        return stub_->CreateService(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceConnectionImpl::GetService(
    google::monitoring::v3::GetServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetService(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::GetServiceRequest const& request) {
        return stub_->GetService(context, request);
      },
      request, __func__);
}

StreamRange<google::monitoring::v3::Service>
ServiceMonitoringServiceConnectionImpl::ListServices(
    google::monitoring::v3::ListServicesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListServices(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::Service>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<monitoring_v3::ServiceMonitoringServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::monitoring::v3::ListServicesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::monitoring::v3::ListServicesRequest const& request) {
              return stub->ListServices(context, request);
            },
            r, function_name);
      },
      [](google::monitoring::v3::ListServicesResponse r) {
        std::vector<google::monitoring::v3::Service> result(
            r.services().size());
        auto& messages = *r.mutable_services();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceConnectionImpl::UpdateService(
    google::monitoring::v3::UpdateServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateService(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::UpdateServiceRequest const& request) {
        return stub_->UpdateService(context, request);
      },
      request, __func__);
}

Status ServiceMonitoringServiceConnectionImpl::DeleteService(
    google::monitoring::v3::DeleteServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteService(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::DeleteServiceRequest const& request) {
        return stub_->DeleteService(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceConnectionImpl::CreateServiceLevelObjective(
    google::monitoring::v3::CreateServiceLevelObjectiveRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateServiceLevelObjective(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::CreateServiceLevelObjectiveRequest const&
                 request) {
        return stub_->CreateServiceLevelObjective(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceConnectionImpl::GetServiceLevelObjective(
    google::monitoring::v3::GetServiceLevelObjectiveRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetServiceLevelObjective(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::GetServiceLevelObjectiveRequest const&
                 request) {
        return stub_->GetServiceLevelObjective(context, request);
      },
      request, __func__);
}

StreamRange<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceConnectionImpl::ListServiceLevelObjectives(
    google::monitoring::v3::ListServiceLevelObjectivesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListServiceLevelObjectives(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::ServiceLevelObjective>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<monitoring_v3::ServiceMonitoringServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::monitoring::v3::ListServiceLevelObjectivesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::monitoring::v3::ListServiceLevelObjectivesRequest const&
                    request) {
              return stub->ListServiceLevelObjectives(context, request);
            },
            r, function_name);
      },
      [](google::monitoring::v3::ListServiceLevelObjectivesResponse r) {
        std::vector<google::monitoring::v3::ServiceLevelObjective> result(
            r.service_level_objectives().size());
        auto& messages = *r.mutable_service_level_objectives();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceConnectionImpl::UpdateServiceLevelObjective(
    google::monitoring::v3::UpdateServiceLevelObjectiveRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateServiceLevelObjective(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::UpdateServiceLevelObjectiveRequest const&
                 request) {
        return stub_->UpdateServiceLevelObjective(context, request);
      },
      request, __func__);
}

Status ServiceMonitoringServiceConnectionImpl::DeleteServiceLevelObjective(
    google::monitoring::v3::DeleteServiceLevelObjectiveRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteServiceLevelObjective(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::DeleteServiceLevelObjectiveRequest const&
                 request) {
        return stub_->DeleteServiceLevelObjective(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
