// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/iam/credentials/v1/iamcredentials.proto

#include "google/cloud/iam/credentials/v1/iam_credentials_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace iam_credentials_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IAMCredentialsClient::IAMCredentialsClient(
    std::shared_ptr<IAMCredentialsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
IAMCredentialsClient::~IAMCredentialsClient() = default;

StatusOr<google::iam::credentials::v1::GenerateAccessTokenResponse>
IAMCredentialsClient::GenerateAccessToken(
    std::string const& name, std::vector<std::string> const& delegates,
    std::vector<std::string> const& scope,
    google::protobuf::Duration const& lifetime, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::credentials::v1::GenerateAccessTokenRequest request;
  request.set_name(name);
  *request.mutable_delegates() = {delegates.begin(), delegates.end()};
  *request.mutable_scope() = {scope.begin(), scope.end()};
  *request.mutable_lifetime() = lifetime;
  return connection_->GenerateAccessToken(request);
}

StatusOr<google::iam::credentials::v1::GenerateAccessTokenResponse>
IAMCredentialsClient::GenerateAccessToken(
    google::iam::credentials::v1::GenerateAccessTokenRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GenerateAccessToken(request);
}

StatusOr<google::iam::credentials::v1::GenerateIdTokenResponse>
IAMCredentialsClient::GenerateIdToken(std::string const& name,
                                      std::vector<std::string> const& delegates,
                                      std::string const& audience,
                                      bool include_email, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::credentials::v1::GenerateIdTokenRequest request;
  request.set_name(name);
  *request.mutable_delegates() = {delegates.begin(), delegates.end()};
  request.set_audience(audience);
  request.set_include_email(include_email);
  return connection_->GenerateIdToken(request);
}

StatusOr<google::iam::credentials::v1::GenerateIdTokenResponse>
IAMCredentialsClient::GenerateIdToken(
    google::iam::credentials::v1::GenerateIdTokenRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GenerateIdToken(request);
}

StatusOr<google::iam::credentials::v1::SignBlobResponse>
IAMCredentialsClient::SignBlob(std::string const& name,
                               std::vector<std::string> const& delegates,
                               std::string const& payload, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::credentials::v1::SignBlobRequest request;
  request.set_name(name);
  *request.mutable_delegates() = {delegates.begin(), delegates.end()};
  request.set_payload(payload);
  return connection_->SignBlob(request);
}

StatusOr<google::iam::credentials::v1::SignBlobResponse>
IAMCredentialsClient::SignBlob(
    google::iam::credentials::v1::SignBlobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SignBlob(request);
}

StatusOr<google::iam::credentials::v1::SignJwtResponse>
IAMCredentialsClient::SignJwt(std::string const& name,
                              std::vector<std::string> const& delegates,
                              std::string const& payload, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::credentials::v1::SignJwtRequest request;
  request.set_name(name);
  *request.mutable_delegates() = {delegates.begin(), delegates.end()};
  request.set_payload(payload);
  return connection_->SignJwt(request);
}

StatusOr<google::iam::credentials::v1::SignJwtResponse>
IAMCredentialsClient::SignJwt(
    google::iam::credentials::v1::SignJwtRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SignJwt(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iam_credentials_v1
}  // namespace cloud
}  // namespace google
