// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/service_attachments/v1/service_attachments.proto

#include "google/cloud/compute/service_attachments/v1/service_attachments_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_service_attachments_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ServiceAttachmentsClient::ServiceAttachmentsClient(
    std::shared_ptr<ServiceAttachmentsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ServiceAttachmentsClient::~ServiceAttachmentsClient() = default;

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::ServiceAttachmentsScopedList>>
ServiceAttachmentsClient::AggregatedListServiceAttachments(
    std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::service_attachments::v1::
      AggregatedListServiceAttachmentsRequest request;
  request.set_project(project);
  return connection_->AggregatedListServiceAttachments(request);
}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::ServiceAttachmentsScopedList>>
ServiceAttachmentsClient::AggregatedListServiceAttachments(
    google::cloud::cpp::compute::service_attachments::v1::
        AggregatedListServiceAttachmentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListServiceAttachments(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ServiceAttachmentsClient::DeleteServiceAttachment(
    std::string const& project, std::string const& region,
    std::string const& service_attachment, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::service_attachments::v1::
      DeleteServiceAttachmentRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_service_attachment(service_attachment);
  return connection_->DeleteServiceAttachment(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ServiceAttachmentsClient::DeleteServiceAttachment(
    google::cloud::cpp::compute::service_attachments::v1::
        DeleteServiceAttachmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteServiceAttachment(request);
}

StatusOr<google::cloud::cpp::compute::v1::ServiceAttachment>
ServiceAttachmentsClient::GetServiceAttachment(
    std::string const& project, std::string const& region,
    std::string const& service_attachment, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::service_attachments::v1::
      GetServiceAttachmentRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_service_attachment(service_attachment);
  return connection_->GetServiceAttachment(request);
}

StatusOr<google::cloud::cpp::compute::v1::ServiceAttachment>
ServiceAttachmentsClient::GetServiceAttachment(
    google::cloud::cpp::compute::service_attachments::v1::
        GetServiceAttachmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetServiceAttachment(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ServiceAttachmentsClient::GetIamPolicy(std::string const& project,
                                       std::string const& region,
                                       std::string const& resource,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::service_attachments::v1::GetIamPolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ServiceAttachmentsClient::GetIamPolicy(
    google::cloud::cpp::compute::service_attachments::v1::
        GetIamPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ServiceAttachmentsClient::InsertServiceAttachment(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::ServiceAttachment const&
        service_attachment_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::service_attachments::v1::
      InsertServiceAttachmentRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_service_attachment_resource() = service_attachment_resource;
  return connection_->InsertServiceAttachment(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ServiceAttachmentsClient::InsertServiceAttachment(
    google::cloud::cpp::compute::service_attachments::v1::
        InsertServiceAttachmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertServiceAttachment(request);
}

StreamRange<google::cloud::cpp::compute::v1::ServiceAttachment>
ServiceAttachmentsClient::ListServiceAttachments(std::string const& project,
                                                 std::string const& region,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::service_attachments::v1::
      ListServiceAttachmentsRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListServiceAttachments(request);
}

StreamRange<google::cloud::cpp::compute::v1::ServiceAttachment>
ServiceAttachmentsClient::ListServiceAttachments(
    google::cloud::cpp::compute::service_attachments::v1::
        ListServiceAttachmentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListServiceAttachments(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ServiceAttachmentsClient::PatchServiceAttachment(
    std::string const& project, std::string const& region,
    std::string const& service_attachment,
    google::cloud::cpp::compute::v1::ServiceAttachment const&
        service_attachment_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::service_attachments::v1::
      PatchServiceAttachmentRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_service_attachment(service_attachment);
  *request.mutable_service_attachment_resource() = service_attachment_resource;
  return connection_->PatchServiceAttachment(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ServiceAttachmentsClient::PatchServiceAttachment(
    google::cloud::cpp::compute::service_attachments::v1::
        PatchServiceAttachmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchServiceAttachment(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ServiceAttachmentsClient::SetIamPolicy(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::RegionSetPolicyRequest const&
        region_set_policy_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::service_attachments::v1::SetIamPolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_region_set_policy_request_resource() =
      region_set_policy_request_resource;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ServiceAttachmentsClient::SetIamPolicy(
    google::cloud::cpp::compute::service_attachments::v1::
        SetIamPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
ServiceAttachmentsClient::TestIamPermissions(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::service_attachments::v1::
      TestIamPermissionsRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
ServiceAttachmentsClient::TestIamPermissions(
    google::cloud::cpp::compute::service_attachments::v1::
        TestIamPermissionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_service_attachments_v1
}  // namespace cloud
}  // namespace google
