// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/node_types/v1/node_types.proto

#include "google/cloud/compute/node_types/v1/node_types_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_node_types_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NodeTypesClient::NodeTypesClient(
    std::shared_ptr<NodeTypesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
NodeTypesClient::~NodeTypesClient() = default;

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::NodeTypesScopedList>>
NodeTypesClient::AggregatedListNodeTypes(std::string const& project,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::node_types::v1::AggregatedListNodeTypesRequest
      request;
  request.set_project(project);
  return connection_->AggregatedListNodeTypes(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::NodeTypesScopedList>>
NodeTypesClient::AggregatedListNodeTypes(
    google::cloud::cpp::compute::node_types::v1::AggregatedListNodeTypesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListNodeTypes(std::move(request));
}

StatusOr<google::cloud::cpp::compute::v1::NodeType>
NodeTypesClient::GetNodeType(std::string const& project,
                             std::string const& zone,
                             std::string const& node_type, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::node_types::v1::GetNodeTypeRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_node_type(node_type);
  return connection_->GetNodeType(request);
}

StatusOr<google::cloud::cpp::compute::v1::NodeType>
NodeTypesClient::GetNodeType(
    google::cloud::cpp::compute::node_types::v1::GetNodeTypeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNodeType(request);
}

StreamRange<google::cloud::cpp::compute::v1::NodeType>
NodeTypesClient::ListNodeTypes(std::string const& project,
                               std::string const& zone, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::node_types::v1::ListNodeTypesRequest request;
  request.set_project(project);
  request.set_zone(zone);
  return connection_->ListNodeTypes(request);
}

StreamRange<google::cloud::cpp::compute::v1::NodeType>
NodeTypesClient::ListNodeTypes(
    google::cloud::cpp::compute::node_types::v1::ListNodeTypesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNodeTypes(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_node_types_v1
}  // namespace cloud
}  // namespace google
