// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/baremetalsolution/v2/baremetalsolution.proto

#include "google/cloud/baremetalsolution/v2/internal/bare_metal_solution_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace baremetalsolution_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

BareMetalSolutionTracingConnection::BareMetalSolutionTracingConnection(
    std::shared_ptr<baremetalsolution_v2::BareMetalSolutionConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::baremetalsolution::v2::Instance>
BareMetalSolutionTracingConnection::ListInstances(
    google::cloud::baremetalsolution::v2::ListInstancesRequest request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::ListInstances");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstances(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::baremetalsolution::v2::Instance>(std::move(span),
                                                      std::move(sr));
}

StatusOr<google::cloud::baremetalsolution::v2::Instance>
BareMetalSolutionTracingConnection::GetInstance(
    google::cloud::baremetalsolution::v2::GetInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::GetInstance");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstance(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Instance>>
BareMetalSolutionTracingConnection::UpdateInstance(
    google::cloud::baremetalsolution::v2::UpdateInstanceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::UpdateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateInstance(request));
}

StatusOr<google::cloud::baremetalsolution::v2::Instance>
BareMetalSolutionTracingConnection::RenameInstance(
    google::cloud::baremetalsolution::v2::RenameInstanceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::RenameInstance");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RenameInstance(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::ResetInstanceResponse>>
BareMetalSolutionTracingConnection::ResetInstance(
    google::cloud::baremetalsolution::v2::ResetInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::ResetInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ResetInstance(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::StartInstanceResponse>>
BareMetalSolutionTracingConnection::StartInstance(
    google::cloud::baremetalsolution::v2::StartInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::StartInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StartInstance(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::StopInstanceResponse>>
BareMetalSolutionTracingConnection::StopInstance(
    google::cloud::baremetalsolution::v2::StopInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::StopInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StopInstance(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::
                    EnableInteractiveSerialConsoleResponse>>
BareMetalSolutionTracingConnection::EnableInteractiveSerialConsole(
    google::cloud::baremetalsolution::v2::
        EnableInteractiveSerialConsoleRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::"
      "EnableInteractiveSerialConsole");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->EnableInteractiveSerialConsole(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::
                    DisableInteractiveSerialConsoleResponse>>
BareMetalSolutionTracingConnection::DisableInteractiveSerialConsole(
    google::cloud::baremetalsolution::v2::
        DisableInteractiveSerialConsoleRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::"
      "DisableInteractiveSerialConsole");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DisableInteractiveSerialConsole(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Instance>>
BareMetalSolutionTracingConnection::DetachLun(
    google::cloud::baremetalsolution::v2::DetachLunRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::DetachLun");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DetachLun(request));
}

StreamRange<google::cloud::baremetalsolution::v2::SSHKey>
BareMetalSolutionTracingConnection::ListSSHKeys(
    google::cloud::baremetalsolution::v2::ListSSHKeysRequest request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::ListSSHKeys");
  internal::OTelScope scope(span);
  auto sr = child_->ListSSHKeys(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::baremetalsolution::v2::SSHKey>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::cloud::baremetalsolution::v2::SSHKey>
BareMetalSolutionTracingConnection::CreateSSHKey(
    google::cloud::baremetalsolution::v2::CreateSSHKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::CreateSSHKey");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateSSHKey(request));
}

Status BareMetalSolutionTracingConnection::DeleteSSHKey(
    google::cloud::baremetalsolution::v2::DeleteSSHKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::DeleteSSHKey");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteSSHKey(request));
}

StreamRange<google::cloud::baremetalsolution::v2::Volume>
BareMetalSolutionTracingConnection::ListVolumes(
    google::cloud::baremetalsolution::v2::ListVolumesRequest request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::ListVolumes");
  internal::OTelScope scope(span);
  auto sr = child_->ListVolumes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::baremetalsolution::v2::Volume>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::cloud::baremetalsolution::v2::Volume>
BareMetalSolutionTracingConnection::GetVolume(
    google::cloud::baremetalsolution::v2::GetVolumeRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::GetVolume");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetVolume(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Volume>>
BareMetalSolutionTracingConnection::UpdateVolume(
    google::cloud::baremetalsolution::v2::UpdateVolumeRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::UpdateVolume");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateVolume(request));
}

StatusOr<google::cloud::baremetalsolution::v2::Volume>
BareMetalSolutionTracingConnection::RenameVolume(
    google::cloud::baremetalsolution::v2::RenameVolumeRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::RenameVolume");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RenameVolume(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionTracingConnection::EvictVolume(
    google::cloud::baremetalsolution::v2::EvictVolumeRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::EvictVolume");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->EvictVolume(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Volume>>
BareMetalSolutionTracingConnection::ResizeVolume(
    google::cloud::baremetalsolution::v2::ResizeVolumeRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::ResizeVolume");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ResizeVolume(request));
}

StreamRange<google::cloud::baremetalsolution::v2::Network>
BareMetalSolutionTracingConnection::ListNetworks(
    google::cloud::baremetalsolution::v2::ListNetworksRequest request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::ListNetworks");
  internal::OTelScope scope(span);
  auto sr = child_->ListNetworks(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::baremetalsolution::v2::Network>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::baremetalsolution::v2::ListNetworkUsageResponse>
BareMetalSolutionTracingConnection::ListNetworkUsage(
    google::cloud::baremetalsolution::v2::ListNetworkUsageRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::ListNetworkUsage");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ListNetworkUsage(request));
}

StatusOr<google::cloud::baremetalsolution::v2::Network>
BareMetalSolutionTracingConnection::GetNetwork(
    google::cloud::baremetalsolution::v2::GetNetworkRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::GetNetwork");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNetwork(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Network>>
BareMetalSolutionTracingConnection::UpdateNetwork(
    google::cloud::baremetalsolution::v2::UpdateNetworkRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::UpdateNetwork");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateNetwork(request));
}

StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
BareMetalSolutionTracingConnection::CreateVolumeSnapshot(
    google::cloud::baremetalsolution::v2::CreateVolumeSnapshotRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::"
      "CreateVolumeSnapshot");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateVolumeSnapshot(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>>
BareMetalSolutionTracingConnection::RestoreVolumeSnapshot(
    google::cloud::baremetalsolution::v2::RestoreVolumeSnapshotRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::"
      "RestoreVolumeSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->RestoreVolumeSnapshot(request));
}

Status BareMetalSolutionTracingConnection::DeleteVolumeSnapshot(
    google::cloud::baremetalsolution::v2::DeleteVolumeSnapshotRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::"
      "DeleteVolumeSnapshot");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteVolumeSnapshot(request));
}

StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
BareMetalSolutionTracingConnection::GetVolumeSnapshot(
    google::cloud::baremetalsolution::v2::GetVolumeSnapshotRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::GetVolumeSnapshot");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetVolumeSnapshot(request));
}

StreamRange<google::cloud::baremetalsolution::v2::VolumeSnapshot>
BareMetalSolutionTracingConnection::ListVolumeSnapshots(
    google::cloud::baremetalsolution::v2::ListVolumeSnapshotsRequest request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::ListVolumeSnapshots");
  internal::OTelScope scope(span);
  auto sr = child_->ListVolumeSnapshots(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::baremetalsolution::v2::VolumeSnapshot>(std::move(span),
                                                            std::move(sr));
}

StatusOr<google::cloud::baremetalsolution::v2::Lun>
BareMetalSolutionTracingConnection::GetLun(
    google::cloud::baremetalsolution::v2::GetLunRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::GetLun");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLun(request));
}

StreamRange<google::cloud::baremetalsolution::v2::Lun>
BareMetalSolutionTracingConnection::ListLuns(
    google::cloud::baremetalsolution::v2::ListLunsRequest request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::ListLuns");
  internal::OTelScope scope(span);
  auto sr = child_->ListLuns(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::baremetalsolution::v2::Lun>(std::move(span),
                                                 std::move(sr));
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionTracingConnection::EvictLun(
    google::cloud::baremetalsolution::v2::EvictLunRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::EvictLun");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->EvictLun(request));
}

StatusOr<google::cloud::baremetalsolution::v2::NfsShare>
BareMetalSolutionTracingConnection::GetNfsShare(
    google::cloud::baremetalsolution::v2::GetNfsShareRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::GetNfsShare");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNfsShare(request));
}

StreamRange<google::cloud::baremetalsolution::v2::NfsShare>
BareMetalSolutionTracingConnection::ListNfsShares(
    google::cloud::baremetalsolution::v2::ListNfsSharesRequest request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::ListNfsShares");
  internal::OTelScope scope(span);
  auto sr = child_->ListNfsShares(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::baremetalsolution::v2::NfsShare>(std::move(span),
                                                      std::move(sr));
}

future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
BareMetalSolutionTracingConnection::UpdateNfsShare(
    google::cloud::baremetalsolution::v2::UpdateNfsShareRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::UpdateNfsShare");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateNfsShare(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
BareMetalSolutionTracingConnection::CreateNfsShare(
    google::cloud::baremetalsolution::v2::CreateNfsShareRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::CreateNfsShare");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateNfsShare(request));
}

StatusOr<google::cloud::baremetalsolution::v2::NfsShare>
BareMetalSolutionTracingConnection::RenameNfsShare(
    google::cloud::baremetalsolution::v2::RenameNfsShareRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::RenameNfsShare");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RenameNfsShare(request));
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionTracingConnection::DeleteNfsShare(
    google::cloud::baremetalsolution::v2::DeleteNfsShareRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::DeleteNfsShare");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNfsShare(request));
}

StreamRange<google::cloud::baremetalsolution::v2::ProvisioningQuota>
BareMetalSolutionTracingConnection::ListProvisioningQuotas(
    google::cloud::baremetalsolution::v2::ListProvisioningQuotasRequest
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::"
      "ListProvisioningQuotas");
  internal::OTelScope scope(span);
  auto sr = child_->ListProvisioningQuotas(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::baremetalsolution::v2::ProvisioningQuota>(std::move(span),
                                                               std::move(sr));
}

StatusOr<google::cloud::baremetalsolution::v2::SubmitProvisioningConfigResponse>
BareMetalSolutionTracingConnection::SubmitProvisioningConfig(
    google::cloud::baremetalsolution::v2::SubmitProvisioningConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::"
      "SubmitProvisioningConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SubmitProvisioningConfig(request));
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionTracingConnection::GetProvisioningConfig(
    google::cloud::baremetalsolution::v2::GetProvisioningConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::"
      "GetProvisioningConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetProvisioningConfig(request));
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionTracingConnection::CreateProvisioningConfig(
    google::cloud::baremetalsolution::v2::CreateProvisioningConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::"
      "CreateProvisioningConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateProvisioningConfig(request));
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionTracingConnection::UpdateProvisioningConfig(
    google::cloud::baremetalsolution::v2::UpdateProvisioningConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::"
      "UpdateProvisioningConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateProvisioningConfig(request));
}

StatusOr<google::cloud::baremetalsolution::v2::Network>
BareMetalSolutionTracingConnection::RenameNetwork(
    google::cloud::baremetalsolution::v2::RenameNetworkRequest const& request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::RenameNetwork");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RenameNetwork(request));
}

StreamRange<google::cloud::baremetalsolution::v2::OSImage>
BareMetalSolutionTracingConnection::ListOSImages(
    google::cloud::baremetalsolution::v2::ListOSImagesRequest request) {
  auto span = internal::MakeSpan(
      "baremetalsolution_v2::BareMetalSolutionConnection::ListOSImages");
  internal::OTelScope scope(span);
  auto sr = child_->ListOSImages(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::baremetalsolution::v2::OSImage>(std::move(span),
                                                     std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<baremetalsolution_v2::BareMetalSolutionConnection>
MakeBareMetalSolutionTracingConnection(
    std::shared_ptr<baremetalsolution_v2::BareMetalSolutionConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<BareMetalSolutionTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace baremetalsolution_v2_internal
}  // namespace cloud
}  // namespace google
