// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#include "google/cloud/appengine/v1/internal/firewall_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace appengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

FirewallTracingStub::FirewallTracingStub(std::shared_ptr<FirewallStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::appengine::v1::ListIngressRulesResponse>
FirewallTracingStub::ListIngressRules(
    grpc::ClientContext& context,
    google::appengine::v1::ListIngressRulesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.appengine.v1.Firewall",
                                     "ListIngressRules");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListIngressRules(context, request));
}

StatusOr<google::appengine::v1::BatchUpdateIngressRulesResponse>
FirewallTracingStub::BatchUpdateIngressRules(
    grpc::ClientContext& context,
    google::appengine::v1::BatchUpdateIngressRulesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.appengine.v1.Firewall",
                                     "BatchUpdateIngressRules");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->BatchUpdateIngressRules(context, request));
}

StatusOr<google::appengine::v1::FirewallRule>
FirewallTracingStub::CreateIngressRule(
    grpc::ClientContext& context,
    google::appengine::v1::CreateIngressRuleRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.appengine.v1.Firewall",
                                     "CreateIngressRule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateIngressRule(context, request));
}

StatusOr<google::appengine::v1::FirewallRule>
FirewallTracingStub::GetIngressRule(
    grpc::ClientContext& context,
    google::appengine::v1::GetIngressRuleRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.appengine.v1.Firewall", "GetIngressRule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetIngressRule(context, request));
}

StatusOr<google::appengine::v1::FirewallRule>
FirewallTracingStub::UpdateIngressRule(
    grpc::ClientContext& context,
    google::appengine::v1::UpdateIngressRuleRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.appengine.v1.Firewall",
                                     "UpdateIngressRule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateIngressRule(context, request));
}

Status FirewallTracingStub::DeleteIngressRule(
    grpc::ClientContext& context,
    google::appengine::v1::DeleteIngressRuleRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.appengine.v1.Firewall",
                                     "DeleteIngressRule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteIngressRule(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<FirewallStub> MakeFirewallTracingStub(
    std::shared_ptr<FirewallStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<FirewallTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_v1_internal
}  // namespace cloud
}  // namespace google
