// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/executions/v1/executions.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_EXECUTIONS_V1_INTERNAL_EXECUTIONS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_EXECUTIONS_V1_INTERNAL_EXECUTIONS_TRACING_CONNECTION_H

#include "google/cloud/workflows/executions/v1/executions_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace workflows_executions_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ExecutionsTracingConnection
    : public workflows_executions_v1::ExecutionsConnection {
 public:
  ~ExecutionsTracingConnection() override = default;

  explicit ExecutionsTracingConnection(
      std::shared_ptr<workflows_executions_v1::ExecutionsConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::workflows::executions::v1::Execution>
  ListExecutions(google::cloud::workflows::executions::v1::ListExecutionsRequest
                     request) override;

  StatusOr<google::cloud::workflows::executions::v1::Execution> CreateExecution(
      google::cloud::workflows::executions::v1::CreateExecutionRequest const&
          request) override;

  StatusOr<google::cloud::workflows::executions::v1::Execution> GetExecution(
      google::cloud::workflows::executions::v1::GetExecutionRequest const&
          request) override;

  StatusOr<google::cloud::workflows::executions::v1::Execution> CancelExecution(
      google::cloud::workflows::executions::v1::CancelExecutionRequest const&
          request) override;

 private:
  std::shared_ptr<workflows_executions_v1::ExecutionsConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<workflows_executions_v1::ExecutionsConnection>
MakeExecutionsTracingConnection(
    std::shared_ptr<workflows_executions_v1::ExecutionsConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows_executions_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_EXECUTIONS_V1_INTERNAL_EXECUTIONS_TRACING_CONNECTION_H
