// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmmigration/v1/vmmigration.proto

#include "google/cloud/vmmigration/v1/internal/vm_migration_auth_decorator.h"
#include <google/cloud/vmmigration/v1/vmmigration.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace vmmigration_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

VmMigrationAuth::VmMigrationAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<VmMigrationStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::vmmigration::v1::ListSourcesResponse>
VmMigrationAuth::ListSources(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::ListSourcesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListSources(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::Source> VmMigrationAuth::GetSource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::GetSourceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetSource(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncCreateSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::CreateSourceRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateSource(cq, *std::move(context),
                                        std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::CreateSource(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::CreateSourceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateSource(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncUpdateSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::UpdateSourceRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateSource(cq, *std::move(context),
                                        std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::UpdateSource(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::UpdateSourceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateSource(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncDeleteSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::DeleteSourceRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteSource(cq, *std::move(context),
                                        std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::DeleteSource(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::DeleteSourceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteSource(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::FetchInventoryResponse>
VmMigrationAuth::FetchInventory(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::FetchInventoryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->FetchInventory(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::ListUtilizationReportsResponse>
VmMigrationAuth::ListUtilizationReports(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::ListUtilizationReportsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListUtilizationReports(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::UtilizationReport>
VmMigrationAuth::GetUtilizationReport(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::GetUtilizationReportRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetUtilizationReport(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncCreateUtilizationReport(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::CreateUtilizationReportRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateUtilizationReport(cq, *std::move(context),
                                                   std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
VmMigrationAuth::CreateUtilizationReport(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::CreateUtilizationReportRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateUtilizationReport(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncDeleteUtilizationReport(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::DeleteUtilizationReportRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteUtilizationReport(cq, *std::move(context),
                                                   std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
VmMigrationAuth::DeleteUtilizationReport(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::DeleteUtilizationReportRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteUtilizationReport(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::ListDatacenterConnectorsResponse>
VmMigrationAuth::ListDatacenterConnectors(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::ListDatacenterConnectorsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListDatacenterConnectors(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::DatacenterConnector>
VmMigrationAuth::GetDatacenterConnector(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::GetDatacenterConnectorRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetDatacenterConnector(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncCreateDatacenterConnector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::CreateDatacenterConnectorRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateDatacenterConnector(
            cq, *std::move(context), std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
VmMigrationAuth::CreateDatacenterConnector(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::CreateDatacenterConnectorRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateDatacenterConnector(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncDeleteDatacenterConnector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::DeleteDatacenterConnectorRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteDatacenterConnector(
            cq, *std::move(context), std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
VmMigrationAuth::DeleteDatacenterConnector(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::DeleteDatacenterConnectorRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteDatacenterConnector(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncUpgradeAppliance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::UpgradeApplianceRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpgradeAppliance(cq, *std::move(context),
                                            std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::UpgradeAppliance(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::UpgradeApplianceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpgradeAppliance(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncCreateMigratingVm(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::CreateMigratingVmRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateMigratingVm(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::CreateMigratingVm(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::CreateMigratingVmRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateMigratingVm(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::ListMigratingVmsResponse>
VmMigrationAuth::ListMigratingVms(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::ListMigratingVmsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListMigratingVms(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::MigratingVm>
VmMigrationAuth::GetMigratingVm(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::GetMigratingVmRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetMigratingVm(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncUpdateMigratingVm(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::UpdateMigratingVmRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateMigratingVm(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::UpdateMigratingVm(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::UpdateMigratingVmRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateMigratingVm(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncDeleteMigratingVm(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::DeleteMigratingVmRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteMigratingVm(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::DeleteMigratingVm(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::DeleteMigratingVmRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteMigratingVm(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncStartMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::StartMigrationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncStartMigration(cq, *std::move(context),
                                          std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::StartMigration(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::StartMigrationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->StartMigration(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncResumeMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::ResumeMigrationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncResumeMigration(cq, *std::move(context),
                                           std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::ResumeMigration(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::ResumeMigrationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ResumeMigration(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncPauseMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::PauseMigrationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncPauseMigration(cq, *std::move(context),
                                          std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::PauseMigration(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::PauseMigrationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->PauseMigration(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncFinalizeMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::FinalizeMigrationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncFinalizeMigration(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::FinalizeMigration(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::FinalizeMigrationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->FinalizeMigration(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncCreateCloneJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::CreateCloneJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateCloneJob(cq, *std::move(context),
                                          std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::CreateCloneJob(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::CreateCloneJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateCloneJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncCancelCloneJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::CancelCloneJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCancelCloneJob(cq, *std::move(context),
                                          std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::CancelCloneJob(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::CancelCloneJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CancelCloneJob(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::ListCloneJobsResponse>
VmMigrationAuth::ListCloneJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::ListCloneJobsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListCloneJobs(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::CloneJob> VmMigrationAuth::GetCloneJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::GetCloneJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetCloneJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncCreateCutoverJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::CreateCutoverJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateCutoverJob(cq, *std::move(context),
                                            std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::CreateCutoverJob(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::CreateCutoverJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateCutoverJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncCancelCutoverJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::CancelCutoverJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCancelCutoverJob(cq, *std::move(context),
                                            std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::CancelCutoverJob(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::CancelCutoverJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CancelCutoverJob(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::ListCutoverJobsResponse>
VmMigrationAuth::ListCutoverJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::ListCutoverJobsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListCutoverJobs(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::CutoverJob>
VmMigrationAuth::GetCutoverJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::GetCutoverJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetCutoverJob(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::ListGroupsResponse>
VmMigrationAuth::ListGroups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::ListGroupsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListGroups(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::Group> VmMigrationAuth::GetGroup(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::GetGroupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetGroup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncCreateGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::CreateGroupRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateGroup(cq, *std::move(context),
                                       std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::CreateGroup(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::CreateGroupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateGroup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncUpdateGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::UpdateGroupRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateGroup(cq, *std::move(context),
                                       std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::UpdateGroup(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::UpdateGroupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateGroup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncDeleteGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::DeleteGroupRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteGroup(cq, *std::move(context),
                                       std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::DeleteGroup(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::DeleteGroupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteGroup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncAddGroupMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::AddGroupMigrationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncAddGroupMigration(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::AddGroupMigration(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::AddGroupMigrationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AddGroupMigration(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncRemoveGroupMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::RemoveGroupMigrationRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncRemoveGroupMigration(cq, *std::move(context),
                                                std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::RemoveGroupMigration(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::RemoveGroupMigrationRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RemoveGroupMigration(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::ListTargetProjectsResponse>
VmMigrationAuth::ListTargetProjects(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::ListTargetProjectsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListTargetProjects(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::TargetProject>
VmMigrationAuth::GetTargetProject(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::GetTargetProjectRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetTargetProject(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncCreateTargetProject(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::CreateTargetProjectRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateTargetProject(cq, *std::move(context),
                                               std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::CreateTargetProject(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::CreateTargetProjectRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateTargetProject(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncUpdateTargetProject(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::UpdateTargetProjectRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateTargetProject(cq, *std::move(context),
                                               std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::UpdateTargetProject(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::UpdateTargetProjectRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateTargetProject(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncDeleteTargetProject(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmmigration::v1::DeleteTargetProjectRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteTargetProject(cq, *std::move(context),
                                               std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> VmMigrationAuth::DeleteTargetProject(
    grpc::ClientContext& context, Options options,
    google::cloud::vmmigration::v1::DeleteTargetProjectRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteTargetProject(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::ListReplicationCyclesResponse>
VmMigrationAuth::ListReplicationCycles(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::ListReplicationCyclesRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListReplicationCycles(context, options, request);
}

StatusOr<google::cloud::vmmigration::v1::ReplicationCycle>
VmMigrationAuth::GetReplicationCycle(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmmigration::v1::GetReplicationCycleRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetReplicationCycle(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationAuth::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncGetOperation(cq, *std::move(context),
                                        std::move(options), request);
      });
}

future<Status> VmMigrationAuth::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncCancelOperation(cq, *std::move(context),
                                           std::move(options), request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmmigration_v1_internal
}  // namespace cloud
}  // namespace google
