// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudtrace/v1/trace.proto

#include "google/cloud/trace/v1/trace_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace trace_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TraceServiceConnectionIdempotencyPolicy::
    ~TraceServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<TraceServiceConnectionIdempotencyPolicy>
TraceServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<TraceServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency TraceServiceConnectionIdempotencyPolicy::ListTraces(
    google::devtools::cloudtrace::v1::ListTracesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TraceServiceConnectionIdempotencyPolicy::GetTrace(
    google::devtools::cloudtrace::v1::GetTraceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TraceServiceConnectionIdempotencyPolicy::PatchTraces(
    google::devtools::cloudtrace::v1::PatchTracesRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<TraceServiceConnectionIdempotencyPolicy>
MakeDefaultTraceServiceConnectionIdempotencyPolicy() {
  return std::make_unique<TraceServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace trace_v1
}  // namespace cloud
}  // namespace google
