// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/job_service.proto

#include "google/cloud/talent/v4/internal/job_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/talent/v4/job_service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace talent_v4_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

JobServiceMetadata::JobServiceMetadata(
    std::shared_ptr<JobServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::talent::v4::Job> JobServiceMetadata::CreateJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::CreateJobRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
JobServiceMetadata::AsyncBatchCreateJobs(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::talent::v4::BatchCreateJobsRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncBatchCreateJobs(cq, std::move(context),
                                      std::move(options), request);
}

StatusOr<google::longrunning::Operation> JobServiceMetadata::BatchCreateJobs(
    grpc::ClientContext& context, Options options,
    google::cloud::talent::v4::BatchCreateJobsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchCreateJobs(context, options, request);
}

StatusOr<google::cloud::talent::v4::Job> JobServiceMetadata::GetJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::GetJobRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetJob(context, options, request);
}

StatusOr<google::cloud::talent::v4::Job> JobServiceMetadata::UpdateJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::UpdateJobRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("job.name=", internal::UrlEncode(request.job().name())));
  return child_->UpdateJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
JobServiceMetadata::AsyncBatchUpdateJobs(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::talent::v4::BatchUpdateJobsRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncBatchUpdateJobs(cq, std::move(context),
                                      std::move(options), request);
}

StatusOr<google::longrunning::Operation> JobServiceMetadata::BatchUpdateJobs(
    grpc::ClientContext& context, Options options,
    google::cloud::talent::v4::BatchUpdateJobsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchUpdateJobs(context, options, request);
}

Status JobServiceMetadata::DeleteJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::DeleteJobRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
JobServiceMetadata::AsyncBatchDeleteJobs(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::talent::v4::BatchDeleteJobsRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncBatchDeleteJobs(cq, std::move(context),
                                      std::move(options), request);
}

StatusOr<google::longrunning::Operation> JobServiceMetadata::BatchDeleteJobs(
    grpc::ClientContext& context, Options options,
    google::cloud::talent::v4::BatchDeleteJobsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchDeleteJobs(context, options, request);
}

StatusOr<google::cloud::talent::v4::ListJobsResponse>
JobServiceMetadata::ListJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::ListJobsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListJobs(context, options, request);
}

StatusOr<google::cloud::talent::v4::SearchJobsResponse>
JobServiceMetadata::SearchJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::SearchJobsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->SearchJobs(context, options, request);
}

StatusOr<google::cloud::talent::v4::SearchJobsResponse>
JobServiceMetadata::SearchJobsForAlert(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::SearchJobsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->SearchJobsForAlert(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
JobServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> JobServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void JobServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                     Options const& options,
                                     std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void JobServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                     Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_v4_internal
}  // namespace cloud
}  // namespace google
