// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/storage/control/v2/storage_control.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGECONTROL_V2_STORAGE_CONTROL_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGECONTROL_V2_STORAGE_CONTROL_CONNECTION_H

#include "google/cloud/storagecontrol/v2/internal/storage_control_retry_traits.h"
#include "google/cloud/storagecontrol/v2/storage_control_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <google/storage/control/v2/storage_control.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace storagecontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `StorageControlConnection`.
class StorageControlRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<StorageControlRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `StorageControlConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kDeadlineExceeded`](@ref google::cloud::StatusCode)
 * - [`kInternal`](@ref google::cloud::StatusCode)
 * - [`kResourceExhausted`](@ref google::cloud::StatusCode)
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 * - [`kUnknown`](@ref google::cloud::StatusCode)
 */
class StorageControlLimitedErrorCountRetryPolicy
    : public StorageControlRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit StorageControlLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  StorageControlLimitedErrorCountRetryPolicy(
      StorageControlLimitedErrorCountRetryPolicy&& rhs) noexcept
      : StorageControlLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  StorageControlLimitedErrorCountRetryPolicy(
      StorageControlLimitedErrorCountRetryPolicy const& rhs) noexcept
      : StorageControlLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<StorageControlRetryPolicy> clone() const override {
    return std::make_unique<StorageControlLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = StorageControlRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      storagecontrol_v2_internal::StorageControlRetryTraits>
      impl_;
};

/**
 * A retry policy for `StorageControlConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kDeadlineExceeded`](@ref google::cloud::StatusCode)
 * - [`kInternal`](@ref google::cloud::StatusCode)
 * - [`kResourceExhausted`](@ref google::cloud::StatusCode)
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 * - [`kUnknown`](@ref google::cloud::StatusCode)
 */
class StorageControlLimitedTimeRetryPolicy : public StorageControlRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit StorageControlLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  StorageControlLimitedTimeRetryPolicy(
      StorageControlLimitedTimeRetryPolicy&& rhs) noexcept
      : StorageControlLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  StorageControlLimitedTimeRetryPolicy(
      StorageControlLimitedTimeRetryPolicy const& rhs) noexcept
      : StorageControlLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<StorageControlRetryPolicy> clone() const override {
    return std::make_unique<StorageControlLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = StorageControlRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      storagecontrol_v2_internal::StorageControlRetryTraits>
      impl_;
};

/**
 * The `StorageControlConnection` object for `StorageControlClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `StorageControlClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `StorageControlClient`.
 *
 * To create a concrete instance, see `MakeStorageControlConnection()`.
 *
 * For mocking, see `storagecontrol_v2_mocks::MockStorageControlConnection`.
 */
class StorageControlConnection {
 public:
  virtual ~StorageControlConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::storage::control::v2::Folder> CreateFolder(
      google::storage::control::v2::CreateFolderRequest const& request);

  virtual Status DeleteFolder(
      google::storage::control::v2::DeleteFolderRequest const& request);

  virtual StatusOr<google::storage::control::v2::Folder> GetFolder(
      google::storage::control::v2::GetFolderRequest const& request);

  virtual StreamRange<google::storage::control::v2::Folder> ListFolders(
      google::storage::control::v2::ListFoldersRequest request);

  virtual future<StatusOr<google::storage::control::v2::Folder>> RenameFolder(
      google::storage::control::v2::RenameFolderRequest const& request);

  virtual StatusOr<google::longrunning::Operation> RenameFolder(
      NoAwaitTag,
      google::storage::control::v2::RenameFolderRequest const& request);

  virtual future<StatusOr<google::storage::control::v2::Folder>> RenameFolder(
      google::longrunning::Operation const& operation);

  virtual StatusOr<google::storage::control::v2::StorageLayout>
  GetStorageLayout(
      google::storage::control::v2::GetStorageLayoutRequest const& request);

  virtual StatusOr<google::storage::control::v2::ManagedFolder>
  CreateManagedFolder(
      google::storage::control::v2::CreateManagedFolderRequest const& request);

  virtual Status DeleteManagedFolder(
      google::storage::control::v2::DeleteManagedFolderRequest const& request);

  virtual StatusOr<google::storage::control::v2::ManagedFolder>
  GetManagedFolder(
      google::storage::control::v2::GetManagedFolderRequest const& request);

  virtual StreamRange<google::storage::control::v2::ManagedFolder>
  ListManagedFolders(
      google::storage::control::v2::ListManagedFoldersRequest request);
};

/**
 * A factory function to construct an object of type `StorageControlConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of StorageControlClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `StorageControlConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::storagecontrol_v2::StorageControlPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `StorageControlConnection` created by
 * this function.
 */
std::shared_ptr<StorageControlConnection> MakeStorageControlConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storagecontrol_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGECONTROL_V2_STORAGE_CONTROL_CONNECTION_H
